# Generated by Django 4.1.2 on 2022-11-17 18:43

from django.db import migrations


def set_is_visitable_for_maven_index_uris(apps, _):
    ResourceURI = apps.get_model("minecode", "ResourceURI")
    resource_uris = ResourceURI.objects.filter(
        uri__startswith="maven-index://",
        is_visitable=True,
    ).iterator(chunk_size=5000)
    updated = []
    for i, resource_uri in enumerate(resource_uris):
        if not i % 5000:
            ResourceURI.objects.bulk_update(
                objs=updated,
                fields=[
                    "is_visitable",
                ]
            )
            updated = []
        resource_uri.is_visitable = False
        updated.append(resource_uri)
    if updated:
        ResourceURI.objects.bulk_update(
            objs=updated,
            fields=[
                "is_visitable",
            ]
        )


class Migration(migrations.Migration):

    dependencies = [
        (
            "minecode",
            "0025_populate_has_error_fields"
        ),
    ]

    operations = [
        migrations.RunPython(set_is_visitable_for_maven_index_uris, migrations.RunPython.noop),
    ]
