# -*- coding: utf-8 -*-
# Generated by Django 1.11.13 on 2018-06-20 05:36
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('minecode', '0016_remove_resourceuri_sig'),
    ]

    operations = [
        migrations.CreateModel(
            name='ScannableURI',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uri', models.CharField(db_index=True, help_text='URI for this resource. This is the unmodified original URI.', max_length=2048)),
                ('canonical', models.CharField(db_index=True, help_text='Canonical form of the URI for this resource that must be unique across all ResourceURI.', max_length=3000)),
                ('source_uri', models.CharField(blank=True, help_text='Optional: real source remote URI for this visit.For example for a package repository index is a typical source via which a first level of package data is fetched. And it is not the URI in the uri field. It is just the source of the fetchOr the source may be a mirror URI used for fetching.', max_length=2048, null=True)),
                ('rank', models.PositiveIntegerField(blank=True, db_index=True, help_text='Relative rank of an URI inside a domain (such as the highest ranking project on sourceforge would be rank 1). Use to prioritize processing. Several URI may have the same rank, even inside the same domain.', null=True)),
                ('priority', models.PositiveIntegerField(db_index=True, default=0, help_text='Absolute procdssing priority of a URI (default to zero), higher number means higher priority, zero means lowest priority.')),
                ('wip_date', models.DateTimeField(blank=True, db_index=True, help_text='Work In Progress. This is a timestamp set at the start of a visit or mapping or indexing or null when no processing is in progress.', null=True)),
                ('file_name', models.CharField(blank=True, db_index=True, help_text='File name of a resource sometimes part of the URI proper and sometimes only available through an HTTP header.', max_length=255, null=True)),
                ('size', models.PositiveIntegerField(blank=True, db_index=True, help_text='Size in bytes of the file represented by this ResourceURI.', null=True)),
                ('sha1', models.CharField(blank=True, db_index=True, help_text='SHA1 checksum hex-encoded (as in the sha1sum command) of the content of the file represented by this ResourceURI.', max_length=40, null=True)),
                ('md5', models.CharField(blank=True, db_index=True, help_text='MD5 checksum hex-encoded (as in the md5sum command) of the content of the file represented by this ResourceURI.', max_length=32, null=True)),
                ('sha256', models.CharField(blank=True, db_index=True, help_text='SHA256 checksum hex-encoded (as in the sha256sum command) of the content of the file represented by this ResourceURI.', max_length=64, null=True)),
                ('last_modified_date', models.DateTimeField(blank=True, db_index=True, help_text='Timestamp set to the last modified date of the remote resource represented by this URI such as the modified date of a file, the lastmod value on a sitemap or the modified date returned by an HTTP resource.', null=True)),
                ('scan_request_date', models.DateTimeField(blank=True, db_index=True, help_text='Timestamp set to the date when a scan was requested.  Used to track scan status.', null=True)),
                ('last_status_poll_date', models.DateTimeField(blank=True, db_index=True, help_text='Timestamp set to the date of the last status poll. Used to track the scan polling.', null=True)),
                ('scan_status', models.IntegerField(choices=[(0, 'new'), (1, 'submitted'), (2, 'in progress'), (3, 'scanned'), (4, 'indexed'), (5, 'failed'), (6, 'timeout')], db_index=True, default=0, help_text='Status of the scan for this URI.')),
                ('scan_uuid', models.CharField(blank=True, db_index=True, help_text='UUID of a scan for this URI in ScanCode.io.', max_length=36, null=True)),
                ('scan_error', models.TextField(blank=True, help_text='Scan errors messages. When present this means the scan failed.', null=True)),
                ('index_error', models.TextField(blank=True, help_text='Indexing errors messages. When present this means the indexing failed.', null=True)),
            ],
            options={
                'verbose_name': 'Scannable URI',
            },
        ),
        migrations.AddIndex(
            model_name='scannableuri',
            index=models.Index(fields=['scan_status', 'scan_request_date', 'last_status_poll_date'], name='minecode_s_scan_st_21b64d_idx'),
        ),
        migrations.AddIndex(
            model_name='scannableuri',
            index=models.Index(fields=['-priority', 'rank'], name='minecode_s_priorit_5b5e01_idx'),
        ),
        migrations.AlterUniqueTogether(
            name='scannableuri',
            unique_together=set([('canonical', 'scan_uuid')]),
        ),
    ]
