#
# Copyright (c) nexB Inc. and others. All rights reserved.
# purldb is a trademark of nexB Inc.
# SPDX-License-Identifier: Apache-2.0
# See http://www.apache.org/licenses/LICENSE-2.0 for the license text.
# See https://github.com/aboutcode-org/purldb for support or download.
# See https://aboutcode.org for more information about nexB OSS projects.
#

"""
Structure: {'googlecode_label': 'dje_keyword'}

See visitors.googlecode.get_project_labels_feed_as_list() for the origin of
those values.
"""

GCODE_KEYWORDS = {
    "AJAX": "AJAX",
    "AOP": "AOP",
    "API": "API",
    "AWS": "AWS",
    "Academic": "Academic",
    "Accessibility": "Accessibility",
    "Accounting": "Accounting",
    "ActiveRecord": "ActiveRecord",
    "Agent": "Agent",
    "Agile": "Agile",
    "Air": "Air",
    "Album": "Album",
    "Algorithm": "Algorithms",
    "Analysis": "Analysis",
    "Analytics": "Analytics",
    "Android": "Android",
    "Animation": "Animation",
    "Annotation": "Annotation",
    "Apache": "Apache",
    "AppEngine": "AppEngine",
    "Applet": "Applet",
    "Application": "Application",
    "Apps": "Apps",
    "Arcade": "Arcade",
    "Archive": "Archive",
    "Arm": "Arm",
    "Asterisk": "Asterisk",
    "Astronomy": "Astronomy",
    "Atom": "Atom",
    "Automation": "Automation",
    "BSD": "BSD",
    "Backup": "Backup",
    "Batch": "Batch",
    "Bioinformatics": "Bioinformatics",
    "Biology": "Biology",
    "Bittorrent": "BitTorrent",
    "Blender": "Blender",
    "Blogger": "Blogger",
    "Blogging": "Blogging",
    "Bluetooth": "Bluetooth",
    "Board": "Board",
    "Boardgame": "Board Games",
    "Book": "Book",
    "Books": "Books",
    "Boost": "Boost",
    "Browser": "Browsers",
    "Build": "Build Tool",
    "Business": "Business",
    "CGI": "CGI",
    "CML": "CML",
    "CMS": "CMS Systems",
    "CRM": "CRM",
    "CRUD": "CRUD",
    "CS": "CS",
    "CSE": "CSE",
    "CSV": "CSV",
    "CakePHP": "CakePHP",
    "Calculator": "Calculator",
    "Canvas": "Canvas",
    "Chess": "Chess",
    "Chinese": "Chinese",
    "Chrome": "Chrome",
    "ChromeOS": "ChromeOS",
    "Client": "Client",
    "Cluster": "Cluster",
    "Cocoa": "Cocoa",
    "CodeGeneration": "Code Generation",
    "Codeigniter": "Codeigniter",
    "Color": "Color",
    "Communication": "Communications",
    "Community": "Community",
    "Component": "Component",
    "Compression": "Compression",
    "Computer": "Computer",
    "Concurrency": "Concurrency",
    "Console": "Console",
    "Contacts": "Contacts",
    "Content": "Content",
    "ContentManagement": "ContentManagement",
    "Control": "Control",
    "Controller": "Controller",
    "Convert": "Convert",
    "Crawler": "Crawler",
    "CrossPlatform": "CrossPlatform",
    "Cryptography": "Cryptography",
    "Cuda": "Cuda",
    "Custom": "Custom",
    "DAO": "DAO",
    "DHTML": "DHTML",
    "DNS": "DNS",
    "DSL": "DSL",
    "Dashboard": "Dashboard",
    "Database": "Database",
    "Debug": "Debugger",
    "Delphi": "Delphi",
    "Demo": "Demo",
    "Design": "Design",
    "Desktop": "Desktop",
    "DevTool": "DevTool",
    "Developer": "Developer",
    "Dictionary": "Dictionary",
    "Distributed": "Distributed",
    "Django": "Django",
    "Doc": "Documentation",
    "Documentation": "Documentation",
    "Dojo": "Dojo",
    "DotNet": "DotNet",
    "Downloader": "Downloader",
    "Driver": "Driver",
    "Drupal": "Drupal",
    "Dynamic": "Dynamic",
    "E-commerce": "E-commerce",
    "EJB": "EJB",
    "ERP": "ERP",
    "Ebook": "Ebook",
    "Eclipse": "Eclipse",
    "Embedded": "Embedded",
    "Emulator": "Emulators",
    "Engineering": "Engineering",
    "English": "English",
    "Enterprise": "Enterprise",
    "Events": "Events",
    "Evolution": "Evolution",
    "Extension": "Extension",
    "FLV": "FLV",
    "FUSE": "FUSE",
    "Facebook": "Facebook",
    "Filesystem": "Filesystems",
    "Finance": "Finance",
    "Firefox": "Firefox",
    "Firewall": "Firewalls",
    "Flash": "Flash",
    "Football": "Football",
    "Forms": "Forms",
    "Framework": "Framework",
    "FreeBSD": "FreeBSD",
    "Functional": "Functional",
    "GIS": "GIS",
    "GPU": "GPU",
    "GTD": "GTD",
    "GTK": "GTK",
    "GWT": "GWT",
    "Gadget": "Gadget",
    "Gallery": "Gallery",
    "Game": "Game",
    "Gdata": "Gdata",
    "Generator": "Generator",
    "Gentoo": "Gentoo",
    "Geo": "Geo",
    "Gnome": "Gnome",
    "Grails": "Grails",
    "Grid": "Grid",
    "Guice": "Guice",
    "HTML": "HTML/XHTML",
    "HTTP": "HTTP",
    "Hadoop": "Hadoop",
    "Hardware": "Hardware",
    "Health": "Health",
    "Hello": "Hello",
    "Hibernate": "Hibernate",
    "Home": "Home",
    "Hosting": "Hosting",
    "I18n": "I18N (Internationalization)",
    "IDE": "IDE",
    "IM": "IM",
    "IOC": "IOC",
    "IP": "IP",
    "IRC": "IRC",
    "Images": "Images",
    "Installer": "Installer",
    "Integration": "Integration",
    "Interactive": "Interactive",
    "Interface": "Interface",
    "Internet": "Internet",
    "Itunes": "Itunes",
    "JBoss": "JBoss",
    "JEE": "JEE",
    "JME": "JME",
    "JPA": "JPA",
    "JSF": "JSF",
    "JSON": "JSON",
    "JSP": "JSP",
    "Jabber": "Jabber",
    "Japanese": "Japanese",
    "JavaFX": "JavaFX",
    "Jobeet": "Jobeet",
    "Joomla": "Joomla",
    "KDE": "KDE",
    "KML": "KML",
    "Kernel": "Kernel",
    "Keyboard": "Keyboard",
    "LDAP": "LDAP",
    "LaTex": "TeX/LaTeX",
    "Lab": "Lab",
    "Layout": "Layout",
    "Learn": "Learn",
    "Library": "Library",
    "Life": "Life",
    "Light": "Light",
    "Linq": "Linq",
    "Linux": "Linux",
    "List": "List",
    "Live": "Live",
    "Localization": "Localization",
    "Location": "Location",
    "Log": "Logging",
    "Logger": "Logger",
    "MFC": "MFC",
    "MIDI": "MIDI",
    "MMO": "MMO",
    "MMORPG": "MMORPG",
    "Mac": "Mac",
    "Machinelearning": "Machine Learning",
    "Mail": "Mail",
    "Manage": "Manage",
    "Mapping": "Mapping",
    "Mashup": "Mashup",
    "Mathematics": "Mathematics",
    "Matlab": "Matlab",
    "Maven": "Maven",
    "Mediawiki": "Mediawiki",
    "Medical": "Medical",
    "Memory": "Memory",
    "Menu": "Menu",
    "Message": "Message",
    "Messaging": "Messaging",
    "Messenger": "Messenger",
    "Microcontroller": "Microcontroller",
    "Middleware": "Middleware",
    "Mod": "Mod",
    "Modeling": "Modeling",
    "Module": "Module",
    "Modules": "Modules",
    "Monitoring": "Monitoring",
    "Mono": "Mono",
    "Multiplayer": "Multiplayer",
    "Multitouch": "Multitouch",
    "MySQL": "MySQL",
    "NHibernate": "NHibernate",
    "Navigation": "Navigation",
    "Netbeans": "Netbeans",
    "Networking": "Networking",
    "News": "News",
    "Nintendo": "Nintendo",
    "Notes": "Notes",
    "OAuth": "OAuth",
    "OOP": "OOP",
    "OWL": "OWL",
    "Object": "Object",
    "Ocaml": "Ocaml",
    "Office": "Office",
    "Ogre": "Ogre",
    "Online": "Online",
    "Ontology": "Ontology",
    "OpenGL": "OpenGL",
    "OpenID": "OpenID",
    "OpenSocial": "OpenSocial",
    "PDF": "PDF",
    "PSP": "PSP",
    "Package": "Package",
    "Parsing": "Parsing",
    "Password": "Password",
    "Pattern": "Pattern",
    "Performance": "Performance",
    "Persistence": "Persistence",
    "PhpBB": "PhpBB",
    "Picasa": "Picasa",
    "Platform": "Platform",
    "Player": "Player",
    "Podcast": "Podcast",
    "Poker": "Poker",
    "Portable": "Portable",
    "Portal": "Portal",
    "PostgreSQL": "PostgreSQL",
    "Process": "Process",
    "Projects": "Projects",
    "Projeto": "Projeto",
    "Protocol": "Protocol",
    "Prototype": "Prototype",
    "Proxy": "Proxy",
    "Prueba": "Prueba",
    "Query": "Query",
    "RCP": "RCP",
    "RDF": "RDF",
    "REST": "REST",
    "RIA": "RIA",
    "RMI": "RMI",
    "RPC": "RPC",
    "RSS": "RSS",
    "RTS": "RTS",
    "Rails": "Rails",
    "Random": "Random",
    "Realtime": "Realtime",
    "Report": "Report",
    "Research": "Research",
    "Robotics": "Robotics",
    "RogueLike": "RogueLike",
    "SDF": "SDF",
    "SDK": "SDK",
    "SDL": "SDL",
    "SEO": "SEO",
    "SIP": "SIP",
    "SMS": "SMS",
    "SMTP": "SMTP",
    "SQL": "SQL",
    "SQLServer": "SQLServer",
    "SSH": "SSH",
    "SWF": "SWF",
    "SWT": "SWT",
    "Sandbox": "Sandbox",
    "Schedule": "Schedule",
    "Scheduler": "Scheduler",
    "Scheduling": "Scheduling",
    "Scrum": "Scrum",
    "Seam": "Seam",
    "SearchEngine": "SearchEngine",
    "Semantic": "Semantic",
    "SemanticWeb": "SemanticWeb",
    "Server": "Server",
    "Service": "Service",
    "Services": "Services",
    "Sharing": "Sharing",
    "Shooter": "Shooter",
    "Simple": "Simple",
    "Simulator": "Simulator",
    "Sistema": "Sistema",
    "SlideShow": "SlideShow",
    "Small": "Small",
    "SocialNetworking": "SocialNetworking",
    "Socket": "Socket",
    "Sockets": "Sockets",
    "Spider": "Spider",
    "Spring": "Spring",
    "Sqlite": "Sqlite",
    "Statistics": "Statistics",
    "Storage": "Storage",
    "Stream": "Stream",
    "Struts": "Struts",
    "Student": "Student",
    "Study": "Study",
    "Subversion": "Subversion",
    "Sudoku": "Sudoku",
    "Svn": "Svn",
    "Swing": "Swing",
    "Symfony": "Symfony",
    "Sync": "Sync",
    "TCL": "TCL",
    "TCP": "TCP",
    "Table": "Table",
    "Taggi": "Taggi",
    "Tasks": "Tasks",
    "Template": "Templates",
    "Terminal": "Terminal",
    "Theme": "Theme",
    "Thesis": "Thesis",
    "Time": "Time",
    "Timer": "Timer",
    "Tool": "Tool",
    "Toolkit": "Toolkit",
    "Tracking": "Tracking",
    "Traffic": "Traffic",
    "Training": "Training",
    "Translate": "Translate",
    "Translation": "Translation",
    "Travel": "Travel",
    "Tree": "Tree",
    "Tutorial": "Tutorial",
    "Twitter": "Twitter",
    "UDP": "UDP",
    "UI": "UI",
    "UML": "UML",
    "URL": "URL",
    "Ubuntu": "Ubuntu",
    "Unicode": "Unicode",
    "UnitTesting": "Unit Test",
    "Unittest": "Unit Test",
    "University": "University",
    "Unix": "Unix",
    "Utility": "Utility",
    "Vector": "Vector",
    "Videogame": "Videogame",
    "Viewer": "Viewer",
    "Virtual": "Virtual",
    "Visual": "Visual",
    "VisualStudio": "VisualStudio",
    "WPF": "WPF",
    "Wave": "Wave",
    "Web": "Web",
    "Webcam": "Webcam",
    "Webkit": "Webkit",
    "Webservice": "Web Service",
    "Webservices": "Web Service",
    "Website": "Website",
    "WiFi": "WiFi",
    "Wicket": "Wicket",
    "Widget": "Widget",
    "Widgets": "Widgets",
    "Wiki": "Wiki",
    "Wikipedia": "Wikipedia",
    "Windows": "Windows",
    "WoW": "WoW",
    "Word": "Word",
    "Work": "Work",
    "World": "World",
    "XHTML": "XHTML",
    "XMPP": "XMPP",
    "XNA": "XNA",
    "XSL": "XSL",
    "XUL": "XUL",
    "XWindow": "XWindow",
    "YUI": "YUI",
    "YouTube": "YouTube",
    "Zend": "Zend",
    "ZendFramework": "ZendFramework",
    "addon": "Addon",
    "extjs": "extjs",
    "ffmpeg": "ffmpeg",
    "iPhone": "iPhone",
    "j2ee": "j2ee",
    "j2me": "j2me",
    "j2se": "j2se",
    "jQuery": "jQuery",
    "memcached": "memcached",
    "mp3": "MP3",
    "p2p": "p2p",
    "plugin": "plugin",
    "pygame": "pygame",
    "pyqt": "pyqt",
    "regex": "Regex",
    "s3": "s3",
    "s60": "s60",
    "twisted": "Twisted",
    "wxwidgets": "wxwidgets",
}
