package htmlcheck

import "regexp"

// HTML tests
var htmlTests = map[string]string{
	// body check is manually done because it always exists in *goquery.Document
	"html-body": "body",
	// HTML tests
	"html-object":         "object, embed, image, pdf",
	"html-link":           "link",
	"html-hr":             "hr",
	"html-dialog":         "dialog",
	"html-srcset":         "[srcset]",
	"html-picture":        "picture",
	"html-svg":            "svg",
	"html-progress":       "progress",
	"html-required":       "[required]",
	"html-meter":          "meter",
	"html-audio":          "audio",
	"html-form":           "form",
	"html-input-submit":   "submit",
	"html-button-reset":   "button[type=\"reset\"]",
	"html-button-submit":  "submit, button[type=\"submit\"]",
	"html-base":           "base",
	"html-input-checkbox": "checkbox",
	"html-input-hidden":   "[type=\"hidden\"]",
	"html-input-radio":    "radio",
	"html-input-text":     "input[type=\"text\"]",
	"html-video":          "video",
	"html-semantics":      "article, aside, details, figcaption, figure, footer, header, main, mark, nav, section, summary, time",
	"html-select":         "select",
	"html-textarea":       "textarea",
	"html-anchor-links":   "a[href^=\"#\"]",
	"html-style":          "style",
	"html-image-maps":     "map, img[usemap]",
}

// Image tests using regex to match against img[src]
var imageRegexpTests = map[string]*regexp.Regexp{
	"image-apng":   regexp.MustCompile(`(?i)\.apng$`),
	"image-avif":   regexp.MustCompile(`(?i)\.avif$`),
	"image-base64": regexp.MustCompile(`^(?i)data:image\/`),
	"image-bmp":    regexp.MustCompile(`(?i)\.bmp$`),
	"image-gif":    regexp.MustCompile(`(?i)\.gif$`),
	"image-hdr":    regexp.MustCompile(`(?i)\.hdr$`),
	"image-heif":   regexp.MustCompile(`(?i)\.heif$`),
	"image-ico":    regexp.MustCompile(`(?i)\.ico$`),
	"image-mp4":    regexp.MustCompile(`(?i)\.mp4$`),
	"image-ppm":    regexp.MustCompile(`(?i)\.ppm$`),
	"image-svg":    regexp.MustCompile(`(?i)\.svg$`),
	"image-tiff":   regexp.MustCompile(`(?i)\.tiff?$`),
	"image-webp":   regexp.MustCompile(`(?i)\.webp$`),
}

// inline attribute <match>=""
var styleInlineAttributes = map[string]string{
	"css-background-color": "[bgcolor]",
	"css-background":       "[background]",
	"css-border":           "[border]",
	"css-height":           "[height]",
	"css-padding":          "[padding]",
	"css-width":            "[width]",
}

// inline style="<match>"
var cssInlineRegexTests = map[string]*regexp.Regexp{
	"css-accent-color":                   regexp.MustCompile(`(?i)(^|\s|;)accent-color(\s+)?:`),
	"css-align-items":                    regexp.MustCompile(`(?i)(^|\s|;)align-items(\s+)?:`),
	"css-aspect-ratio":                   regexp.MustCompile(`(?i)(^|\s|;)aspect-ratio(\s+)?:`),
	"css-background-blend-mode":          regexp.MustCompile(`(?i)(^|\s|;)background-blend-mode(\s+)?:`),
	"css-background-clip":                regexp.MustCompile(`(?i)(^|\s|;)background-clip(\s+)?:`),
	"css-background-color":               regexp.MustCompile(`(?i)(^|\s|;)background-color(\s+)?:`),
	"css-background-image":               regexp.MustCompile(`(?i)(^|\s|;)background-image(\s+)?:`),
	"css-background-origin":              regexp.MustCompile(`(?i)(^|\s|;)background-origin(\s+)?:`),
	"css-background-position":            regexp.MustCompile(`(?i)(^|\s|;)background-position(\s+)?:`),
	"css-background-repeat":              regexp.MustCompile(`(?i)(^|\s|;)background-repeat(\s+)?:`),
	"css-background-size":                regexp.MustCompile(`(?i)(^|\s|;)background-size(\s+)?:`),
	"css-background":                     regexp.MustCompile(`(?i)(^|\s|;)background(\s+)?:`),
	"css-block-inline-size":              regexp.MustCompile(`(?i)(^|\s|;)block-inline-size(\s+)?:`),
	"css-border-image":                   regexp.MustCompile(`(?i)(^|\s|;)border-image(\s+)?:`),
	"css-border-inline-block-individual": regexp.MustCompile(`(?i)(^|\s|;)border-inline(\s+)?:`),
	"css-border-radius":                  regexp.MustCompile(`(?i)(^|\s|;)border-radius(\s+)?:`),
	"css-border":                         regexp.MustCompile(`(?i)(^|\s|;)border(\s+)?:`),
	"css-box-shadow":                     regexp.MustCompile(`(?i)(^|\s|;)box-shadow(\s+)?:`),
	"css-box-sizing":                     regexp.MustCompile(`(?i)(^|\s|;)box-sizing(\s+)?:`),
	"css-caption-side":                   regexp.MustCompile(`(?i)(^|\s|;)caption-side(\s+)?:`),
	"css-clip-path":                      regexp.MustCompile(`(?i)(^|\s|;)clip-path(\s+)?:`),
	"css-column-count":                   regexp.MustCompile(`(?i)(^|\s|;)column-count(\s+)?:`),
	"css-column-layout-properties":       regexp.MustCompile(`(?i)(^|\s|;)column-layout-properties(\s+)?:`),
	"css-conic-gradient":                 regexp.MustCompile(`(?i)(^|\s|;)conic-gradient(\s+)?:`),
	"css-direction":                      regexp.MustCompile(`(?i)(^|\s|;)direction(\s+)?:`),
	"css-display-flex":                   regexp.MustCompile(`(?i)(^|\s|;)display(\s+)?:(\s+)?flex($|\s|;)`),
	"css-display-grid":                   regexp.MustCompile(`(?i)(^|\s|;)display:grid`),
	"css-display-none":                   regexp.MustCompile(`(?i)(^|\s|;)display:none`),
	"css-display":                        regexp.MustCompile(`(?i)(^|\s|;)display(\s+)?:`),
	"css-filter":                         regexp.MustCompile(`(?i)(^|\s|;)filter(\s+)?:`),
	"css-flex-direction":                 regexp.MustCompile(`(?i)(^|\s|;)flex-direction(\s+)?:`),
	"css-flex-wrap":                      regexp.MustCompile(`(?i)(^|\s|;)flex-wrap(\s+)?:`),
	"css-float":                          regexp.MustCompile(`(?i)(^|\s|;)float(\s+)?:`),
	"css-font-kerning":                   regexp.MustCompile(`(?i)(^|\s|;)font-kerning(\s+)?:`),
	"css-font-weight":                    regexp.MustCompile(`(?i)(^|\s|;)font-weight(\s+)?:`),
	"css-font":                           regexp.MustCompile(`(?i)(^|\s|;)font(\s+)?:`),
	"css-gap":                            regexp.MustCompile(`(?i)(^|\s|;)gap(\s+)?:`),
	"css-grid-template":                  regexp.MustCompile(`(?i)(^|\s|;)grid-template(\s+)?:`),
	"css-height":                         regexp.MustCompile(`(?i)(^|\s|;)height(\s+)?:`),
	"css-hyphens":                        regexp.MustCompile(`(?i)(^|\s|;)hyphens(\s+)?:`),
	"css-important":                      regexp.MustCompile(`(?i)!important($|\s|;)`),
	"css-inline-size":                    regexp.MustCompile(`(?i)(^|\s|;)inline-size(\s+)?:`),
	"css-intrinsic-size":                 regexp.MustCompile(`(?i)(^|\s|;)intrinsic-size(\s+)?:`),
	"css-justify-content":                regexp.MustCompile(`(?i)(^|\s|;)justify-content(\s+)?:`),
	"css-letter-spacing":                 regexp.MustCompile(`(?i)(^|\s|;)letter-spacing(\s+)?:`),
	"css-line-height":                    regexp.MustCompile(`(?i)(^|\s|;)line-height(\s+)?:`),
	"css-list-style-image":               regexp.MustCompile(`(?i)(^|\s|;)list-style-image(\s+)?:`),
	"css-list-style-position":            regexp.MustCompile(`(?i)(^|\s|;)list-style-position(\s+)?:`),
	"css-list-style":                     regexp.MustCompile(`(?i)(^|\s|;)list-style(\s+)?:`),
	"css-margin-block-start-end":         regexp.MustCompile(`(?i)(^|\s|;)margin-block-(start|end)(\s+)?:`),
	"css-margin-inline-block":            regexp.MustCompile(`(?i)(^|\s|;)margin-inline-block(\s+)?:`),
	"css-margin-inline-start-end":        regexp.MustCompile(`(?i)(^|\s|;)margin-inline-(start|end)(\s+)?:`),
	"css-margin-inline":                  regexp.MustCompile(`(?i)(^|\s|;)margin-inline(\s+)?:`),
	"css-margin":                         regexp.MustCompile(`(?i)(^|\s|;)margin(\s+)?:`),
	"css-max-block-size":                 regexp.MustCompile(`(?i)(^|\s|;)max-block-size(\s+)?:`),
	"css-max-height":                     regexp.MustCompile(`(?i)(^|\s|;)max-height(\s+)?:`),
	"css-max-width":                      regexp.MustCompile(`(?i)(^|\s|;)max-width(\s+)?:`),
	"css-min-height":                     regexp.MustCompile(`(?i)(^|\s|;)min-height(\s+)?:`),
	"css-min-inline-size":                regexp.MustCompile(`(?i)(^|\s|;)min-inline-size(\s+)?:`),
	"css-min-width":                      regexp.MustCompile(`(?i)(^|\s|;)min-width(\s+)?:`),
	"css-mix-blend-mode":                 regexp.MustCompile(`(?i)(^|\s|;)mix-blend-mode(\s+)?:`),
	"css-modern-color":                   regexp.MustCompile(`(?i)(^|\s|;)modern-color(\s+)?:`),
	"css-object-fit":                     regexp.MustCompile(`(?i)(^|\s|;)object-fit(\s+)?:`),
	"css-object-position":                regexp.MustCompile(`(?i)(^|\s|;)object-position(\s+)?:`),
	"css-opacity":                        regexp.MustCompile(`(?i)(^|\s|;)opacity(\s+)?:`),
	"css-outline-offset":                 regexp.MustCompile(`(?i)(^|\s|;)outline-offset(\s+)?:`),
	"css-outline":                        regexp.MustCompile(`(?i)(^|\s|;)outline(\s+)?:`),
	"css-overflow-wrap":                  regexp.MustCompile(`(?i)(^|\s|;)overflow-wrap(\s+)?:`),
	"css-overflow":                       regexp.MustCompile(`(?i)(^|\s|;)overflow(\s+)?:`),
	"css-padding-block-start-end":        regexp.MustCompile(`(?i)(^|\s|;)padding-block-(start|end)(\s+)?:`),
	"css-padding-inline-block":           regexp.MustCompile(`(?i)(^|\s|;)padding-inline-block(\s+)?:`),
	"css-padding-inline-start-end":       regexp.MustCompile(`(?i)(^|\s|;)padding-inline-(start|end)(\s+)?:`),
	"css-padding":                        regexp.MustCompile(`(?i)(^|\s|;)padding(\s+)?:`),
	"css-position":                       regexp.MustCompile(`(?i)(^|\s|;)position(\s+)?:`),
	"css-radial-gradient":                regexp.MustCompile(`(?i)(^|\s|;)radial-gradient(\s+)?:`),
	"css-rgb":                            regexp.MustCompile(`(?i)(\s|:)rgb\(`),
	"css-rgba":                           regexp.MustCompile(`(?i)(\s|:)rgba\(`),
	"css-scroll-snap":                    regexp.MustCompile(`(?i)(^|\s|;)roll-snap(\s+)?:`),
	"css-tab-size":                       regexp.MustCompile(`(?i)(^|\s|;)tab-size(\s+)?:`),
	"css-table-layout":                   regexp.MustCompile(`(?i)(^|\s|;)table-layout(\s+)?:`),
	"css-text-align-last":                regexp.MustCompile(`(?i)(^|\s|;)text-align-last(\s+)?:`),
	"css-text-align":                     regexp.MustCompile(`(?i)(^|\s|;)text-align(\s+)?:`),
	"css-text-decoration-color":          regexp.MustCompile(`(?i)(^|\s|;)text-decoration-color(\s+)?:`),
	"css-text-decoration-thickness":      regexp.MustCompile(`(?i)(^|\s|;)text-decoration-thickness(\s+)?:`),
	"css-text-decoration":                regexp.MustCompile(`(?i)(^|\s|;)text-decoration(\s+)?:`),
	"css-text-emphasis-position":         regexp.MustCompile(`(?i)(^|\s|;)text-emphasis-position(\s+)?:`),
	"css-text-emphasis":                  regexp.MustCompile(`(?i)(^|\s|;)text-emphasis(\s+)?:`),
	"css-text-indent":                    regexp.MustCompile(`(?i)(^|\s|;)text-indent(\s+)?:`),
	"css-text-overflow":                  regexp.MustCompile(`(?i)(^|\s|;)text-overflow(\s+)?:`),
	"css-text-shadow":                    regexp.MustCompile(`(?i)(^|\s|;)text-shadow(\s+)?:`),
	"css-text-transform":                 regexp.MustCompile(`(?i)(^|\s|;)text-transform(\s+)?:`),
	"css-text-underline-offset":          regexp.MustCompile(`(?i)(^|\s|;)text-underline-offset(\s+)?:`),
	"css-transform":                      regexp.MustCompile(`(?i)(^|\s|;)transform(\s+)?:`),
	"css-unit-calc":                      regexp.MustCompile(`(?i)(\s|:)calc\(`),
	"css-variables":                      regexp.MustCompile(`(?i)(^|\s|;)variables(\s+)?:`),
	"css-visibility":                     regexp.MustCompile(`(?i)(^|\s|;)visibility(\s+)?:`),
	"css-white-space":                    regexp.MustCompile(`(?i)(^|\s|;)white-space(\s+)?:`),
	"css-width":                          regexp.MustCompile(`(?i)(^|\s|;)width(\s+)?:`),
	"css-word-break":                     regexp.MustCompile(`(?i)(^|\s|;)word-break(\s+)?:`),
	"css-writing-mode":                   regexp.MustCompile(`(?i)(^|\s|;)writing-mode(\s+)?:`),
	"css-z-index":                        regexp.MustCompile(`(?i)(^|\s|;)z-index(\s+)?:`),
}

// some CSS tests using regex for things that can't be merged inline
var cssRegexpTests = map[string]*regexp.Regexp{
	"css-at-font-face":                  regexp.MustCompile(`(?mi)@font\-face\s+?{`),
	"css-at-import":                     regexp.MustCompile(`(?mi)@import\s`),
	"css-at-keyframes":                  regexp.MustCompile(`(?mi)@keyframes\s`),
	"css-at-media":                      regexp.MustCompile(`(?mi)@media\s?\(`),
	"css-at-supports":                   regexp.MustCompile(`(?mi)@supports\s?\(`),
	"css-pseudo-class-active":           regexp.MustCompile(`:active`),
	"css-pseudo-class-checked":          regexp.MustCompile(`:checked`),
	"css-pseudo-class-first-child":      regexp.MustCompile(`:first\-child`),
	"css-pseudo-class-first-of-type":    regexp.MustCompile(`:first\-of\-type`),
	"css-pseudo-class-focus":            regexp.MustCompile(`:focus`),
	"css-pseudo-class-has":              regexp.MustCompile(`:has`),
	"css-pseudo-class-hover":            regexp.MustCompile(`:hover`),
	"css-pseudo-class-lang":             regexp.MustCompile(`:lang\s?\(`),
	"css-pseudo-class-last-child":       regexp.MustCompile(`:last\-child`),
	"css-pseudo-class-last-of-type":     regexp.MustCompile(`:last\-of\-type`),
	"css-pseudo-class-link":             regexp.MustCompile(`:link`),
	"css-pseudo-class-not":              regexp.MustCompile(`:not(\s+)?\(`),
	"css-pseudo-class-nth-child":        regexp.MustCompile(`:nth\-child(\s+)?\(`),
	"css-pseudo-class-nth-last-child":   regexp.MustCompile(`:nth\-last\-child(\s+)?\(`),
	"css-pseudo-class-nth-last-of-type": regexp.MustCompile(`:nth\-last\-of\-type(\s+)?\(`),
	"css-pseudo-class-nth-of-type":      regexp.MustCompile(`:nth\-of\-type(\s+)?\(`),
	"css-pseudo-class-only-child":       regexp.MustCompile(`:only\-child(\s+)?\(`),
	"css-pseudo-class-only-of-type":     regexp.MustCompile(`:only\-of\-type(\s+)?\(`),
	"css-pseudo-class-target":           regexp.MustCompile(`:target`),
	"css-pseudo-class-visited":          regexp.MustCompile(`:visited`),
	"css-pseudo-element-after":          regexp.MustCompile(`:after`),
	"css-pseudo-element-before":         regexp.MustCompile(`:before`),
	"css-pseudo-element-first-letter":   regexp.MustCompile(`::first\-letter`),
	"css-pseudo-element-first-line":     regexp.MustCompile(`::first\-line`),
	"css-pseudo-element-marker":         regexp.MustCompile(`::marker`),
	"css-pseudo-element-placeholder":    regexp.MustCompile(`::placeholder`),
}

// some CSS tests using regex for units
var cssRegexpUnitTests = map[string]*regexp.Regexp{
	"css-unit-ch":      regexp.MustCompile(`\b\d+ch\b`),
	"css-unit-initial": regexp.MustCompile(`:\s?initial\b`),
	"css-unit-rem":     regexp.MustCompile(`\b\d+rem\b`),
	"css-unit-vh":      regexp.MustCompile(`\b\d+vh\b`),
	"css-unit-vmax":    regexp.MustCompile(`\b\d+vmax\b`),
	"css-unit-vmin":    regexp.MustCompile(`\b\d+vmin\b`),
	"css-unit-vw":      regexp.MustCompile(`\b\d+vw\b`),
}
