import App from '../../models/app.js';
import Step from '../../models/step.js';

const createFlow = async (_parent, params, context) => {
  context.currentUser.can('create', 'Flow');

  const connectionId = params?.input?.connectionId;
  const appKey = params?.input?.triggerAppKey;

  if (appKey) {
    await App.findOneByKey(appKey);
  }

  const flow = await context.currentUser.$relatedQuery('flows').insert({
    name: 'Name your flow',
  });

  if (connectionId) {
    const hasConnection = await context.currentUser
      .$relatedQuery('connections')
      .findById(connectionId);

    if (!hasConnection) {
      throw new Error('The connection does not exist!');
    }
  }

  await Step.query().insert({
    flowId: flow.id,
    type: 'trigger',
    position: 1,
    appKey,
    connectionId,
  });

  await Step.query().insert({
    flowId: flow.id,
    type: 'action',
    position: 2,
  });

  return flow;
};

export default createFlow;
