import { URLSearchParams } from 'url';
import authScope from '../common/auth-scope.js';

export default async function generateAuthUrl($) {
  const oauthRedirectUrlField = $.app.auth.fields.find(
    (field) => field.key == 'oAuthRedirectUrl'
  );

  const redirectUri = oauthRedirectUrlField.value;
  const searchParams = new URLSearchParams({
    response_type: 'code',
    redirect_uri: redirectUri,
    client_id: $.auth.data.clientId,
    scope: authScope.join(' '),
  });

  await $.auth.set({
    url: `${
      $.auth.data.instanceUrl
    }/oauth/authorizations/new?${searchParams.toString()}`,
  });
}
