import defineAction from '../../../../helpers/define-action.js';
import { fields } from './fields.js';

export default defineAction({
  name: 'Create contact',
  key: 'createContact',
  description: 'Create a new contact.',
  arguments: fields,

  async run($) {
    const {
      salutation,
      firstName,
      lastName,
      primaryEmail,
      officePhone,
      mobilePhone,
      homePhone,
      dateOfBirth,
      fax,
      organizationId,
      title,
      department,
      reportsTo,
      leadSource,
      secondaryEmail,
      assignedTo,
      doNotCall,
      notifyOwner,
      twitterUsername,
      slaId,
      lifecycleStage,
      status,
      happinessRating,
      recordCurrencyId,
      referredBy,
      emailOptin,
      smsOptin,
      language,
      sourceCampaignId,
      portalUser,
      supportStartDate,
      supportEndDate,
      otherCountry,
      mailingCountry,
      mailingStreet,
      otherStreet,
      mailingPoBox,
      otherPoBox,
      mailingCity,
      otherCity,
      mailingState,
      otherState,
      mailingZip,
      otherZip,
      description,
      contactImage,
      linkedinUrl,
      linkedinFollowers,
      facebookUrl,
      facebookFollowers,
    } = $.step.parameters;

    const elementData = {
      salutationtype: salutation,
      firstname: firstName,
      lastname: lastName,
      email: primaryEmail,
      phone: officePhone,
      mobile: mobilePhone,
      homephone: homePhone,
      birthday: dateOfBirth,
      fax: fax,
      account_id: organizationId,
      title: title,
      department: department,
      contact_id: reportsTo,
      leadsource: leadSource,
      secondaryemail: secondaryEmail,
      assigned_user_id: assignedTo || $.auth.data.userId,
      donotcall: doNotCall,
      notify_owner: notifyOwner,
      emailoptout: emailOptin,
      primary_twitter: twitterUsername,
      slaid: slaId,
      contacttype: lifecycleStage,
      contactstatus: status,
      happiness_rating: happinessRating,
      record_currency_id: recordCurrencyId,
      referred_by: referredBy,
      emailoptin: emailOptin,
      smsoptin: smsOptin,
      language: language,
      source_campaign: sourceCampaignId,
      portal: portalUser,
      support_start_date: supportStartDate,
      support_end_date: supportEndDate,
      othercountry: otherCountry,
      mailingcountry: mailingCountry,
      mailingstreet: mailingStreet,
      otherstreet: otherStreet,
      mailingpobox: mailingPoBox,
      otherpobox: otherPoBox,
      mailingcity: mailingCity,
      othercity: otherCity,
      mailingstate: mailingState,
      otherstate: otherState,
      mailingzip: mailingZip,
      otherzip: otherZip,
      description: description,
      imagename: contactImage,
      primary_linkedin: linkedinUrl,
      followers_linkedin: linkedinFollowers,
      primary_facebook: facebookUrl,
      followers_facebook: facebookFollowers,
    };

    const body = {
      operation: 'create',
      sessionName: $.auth.data.sessionName,
      element: JSON.stringify(elementData),
      elementType: 'Contacts',
    };

    const response = await $.http.post('/webservice.php', body);

    $.setActionItem({ raw: response.data });
  },
});
