# Twitter

:::info
This page explains the steps you need to follow to set up the Twitter connection in Automatisch. If any of the steps are outdated, please let us know!
:::

1. Go to the [Twitter Developer Portal](https://developer.twitter.com/en/portal/projects-and-apps), complete the questionnaire and click the **Let's do this** button.
2. Accept terms & conditions on the following page and click **Submit**.

:::warning
If you see an error saying `There was a problem completing your request. User must have a verified phone number on file prior to submitting application.` Go to the [phone settings page](https://twitter.com/settings/phone) and set up your phone number to be able to continue on step 2.
:::

3. You will get a verification email from Twitter. Click on **Confirm your email** button.
4. Fill out the **App name** field and click on the **Get keys** button.
5. Copy **API Key** and **API Key Secret** values and save them to use later.
6. Click **Dashboard** and **Yes, I saved them** buttons, respectively.
7. Go to the **App settings** link in the project section you have created.
8. Go to the **User authentication settings** section and click **Set up**.
9. Enable **OAuth 1.0a** on the following page.
10. In the **OAuth 1.0A Settings** section, select **Read and write** option.
11. Copy **OAuth Redirect URL** from Automatisch and paste it to the **Callback URI / Redirect URL** field.
12. Fill **Website URL** and click **Save**.
13. Paste **API Key** and **API Key Secret** values you have saved from the 5th step and paste them into Automatisch as **API Key** and **API Secret**, respectively.
14. Congrats! You can start using the new Twitter connection!
