export const fields = [
  {
    label: 'Salutation',
    key: 'salutation',
    type: 'dropdown',
    required: false,
    description: '',
    variables: true,
    options: [
      { label: 'Mr.', value: 'Mr.' },
      { label: 'Ms.', value: 'Ms.' },
      { label: 'Mrs.', value: 'Mrs.' },
      { label: 'Dr.', value: 'Dr.' },
      { label: 'Prof.', value: 'Prof.' },
    ],
  },
  {
    label: 'First Name',
    key: 'firstName',
    type: 'string',
    required: false,
    description: '',
    variables: true,
  },
  {
    label: 'Last Name',
    key: 'lastName',
    type: 'string',
    required: true,
    description: '',
    variables: true,
  },
  {
    label: 'Primary Email',
    key: 'primaryEmail',
    type: 'string',
    required: false,
    description: '',
    variables: true,
  },
  {
    label: 'Office Phone',
    key: 'officePhone',
    type: 'string',
    required: false,
    description: '',
    variables: true,
  },
  {
    label: 'Mobile Phone',
    key: 'mobilePhone',
    type: 'string',
    required: false,
    description: '',
    variables: true,
  },
  {
    label: 'Home Phone',
    key: 'homePhone',
    type: 'string',
    required: false,
    description: '',
    variables: true,
  },
  {
    label: 'Date of Birth',
    key: 'dateOfBirth',
    type: 'string',
    required: false,
    description: 'format: yyyy-mm-dd',
    variables: true,
  },
  {
    label: 'Fax',
    key: 'fax',
    type: 'string',
    required: false,
    description: '',
    variables: true,
  },
  {
    label: 'Organization',
    key: 'organizationId',
    type: 'dropdown',
    required: false,
    description: '',
    variables: true,
    source: {
      type: 'query',
      name: 'getDynamicData',
      arguments: [
        {
          name: 'key',
          value: 'listOrganizations',
        },
      ],
    },
  },
  {
    label: 'Title',
    key: 'title',
    type: 'dropdown',
    required: false,
    description: '',
    variables: true,
    source: {
      type: 'query',
      name: 'getDynamicData',
      arguments: [
        {
          name: 'key',
          value: 'listContactOptions',
        },
        {
          name: 'parameters.title',
          value: 'listContactOptions',
        },
      ],
    },
  },
  {
    label: 'Department',
    key: 'department',
    type: 'string',
    required: false,
    description: '',
    variables: true,
  },
  {
    label: 'Reports To',
    key: 'reportsTo',
    type: 'dropdown',
    required: false,
    description: '',
    variables: true,
    source: {
      type: 'query',
      name: 'getDynamicData',
      arguments: [
        {
          name: 'key',
          value: 'listContacts',
        },
      ],
    },
  },
  {
    label: 'Lead Source',
    key: 'leadSource',
    type: 'dropdown',
    required: false,
    description: '',
    variables: true,
    source: {
      type: 'query',
      name: 'getDynamicData',
      arguments: [
        {
          name: 'key',
          value: 'listContactOptions',
        },
        {
          name: 'parameters.leadSource',
          value: 'leadsource',
        },
      ],
    },
  },
  {
    label: 'Secondary Email',
    key: 'secondaryEmail',
    type: 'string',
    required: false,
    description: '',
    variables: true,
  },
  {
    label: 'Assigned To',
    key: 'assignedTo',
    type: 'string',
    required: false,
    description: '',
    variables: true,
  },
  {
    label: 'Do Not Call',
    key: 'doNotCall',
    type: 'dropdown',
    required: false,
    description: '',
    variables: true,
    options: [
      { label: 'True', value: '1' },
      { label: 'False', value: '-1' },
    ],
  },
  {
    label: 'Notify Owner',
    key: 'notifyOwner',
    type: 'dropdown',
    required: false,
    description: '',
    variables: true,
    options: [
      { label: 'True', value: '1' },
      { label: 'False', value: '-1' },
    ],
  },
  {
    label: 'Twitter Username',
    key: 'twitterUsername',
    type: 'string',
    required: false,
    description: '',
    variables: true,
  },
  {
    label: 'SLA',
    key: 'slaId',
    type: 'dropdown',
    required: false,
    description: '',
    variables: true,
    source: {
      type: 'query',
      name: 'getDynamicData',
      arguments: [
        {
          name: 'key',
          value: 'listSlaNames',
        },
      ],
    },
  },
  {
    label: 'Lifecycle Stage',
    key: 'lifecycleStage',
    type: 'dropdown',
    required: false,
    description: '',
    variables: true,
    source: {
      type: 'query',
      name: 'getDynamicData',
      arguments: [
        {
          name: 'key',
          value: 'listContactOptions',
        },
        {
          name: 'parameters.lifecycleStage',
          value: 'contacttype',
        },
      ],
    },
  },
  {
    label: 'Status',
    key: 'status',
    type: 'dropdown',
    required: false,
    description: '',
    variables: true,
    source: {
      type: 'query',
      name: 'getDynamicData',
      arguments: [
        {
          name: 'key',
          value: 'listContactOptions',
        },
        {
          name: 'parameters.status',
          value: 'contactstatus',
        },
      ],
    },
  },
  {
    label: 'Happiness Rating',
    key: 'happinessRating',
    type: 'dropdown',
    required: false,
    description: '',
    variables: true,
    source: {
      type: 'query',
      name: 'getDynamicData',
      arguments: [
        {
          name: 'key',
          value: 'listContactOptions',
        },
        {
          name: 'parameters.happinessRating',
          value: 'happiness_rating',
        },
      ],
    },
  },
  {
    label: 'Record Currency',
    key: 'recordCurrencyId',
    type: 'dropdown',
    required: false,
    description: '',
    variables: true,
    source: {
      type: 'query',
      name: 'getDynamicData',
      arguments: [
        {
          name: 'key',
          value: 'listRecordCurrencies',
        },
      ],
    },
  },
  {
    label: 'Referred By',
    key: 'referredBy',
    type: 'dropdown',
    required: false,
    description: '',
    variables: true,
    source: {
      type: 'query',
      name: 'getDynamicData',
      arguments: [
        {
          name: 'key',
          value: 'listContacts',
        },
      ],
    },
  },
  {
    label: 'Email Opt-in',
    key: 'emailOptin',
    type: 'dropdown',
    required: false,
    description: '',
    variables: true,
    source: {
      type: 'query',
      name: 'getDynamicData',
      arguments: [
        {
          name: 'key',
          value: 'listContactOptions',
        },
        {
          name: 'parameters.emailOptin',
          value: 'emailoptin',
        },
      ],
    },
  },
  {
    label: 'SMS Opt-in',
    key: 'smsOptin',
    type: 'dropdown',
    required: false,
    description: '',
    variables: true,
    source: {
      type: 'query',
      name: 'getDynamicData',
      arguments: [
        {
          name: 'key',
          value: 'listContactOptions',
        },
        {
          name: 'parameters.smsOptin',
          value: 'smsoptin',
        },
      ],
    },
  },
  {
    label: 'Language',
    key: 'language',
    type: 'dropdown',
    required: false,
    description: '',
    variables: true,
    source: {
      type: 'query',
      name: 'getDynamicData',
      arguments: [
        {
          name: 'key',
          value: 'listContactOptions',
        },
        {
          name: 'parameters.language',
          value: 'language',
        },
      ],
    },
  },
  {
    label: 'Source Campaign',
    key: 'sourceCampaignId',
    type: 'dropdown',
    required: false,
    description: '',
    variables: true,
    source: {
      type: 'query',
      name: 'getDynamicData',
      arguments: [
        {
          name: 'key',
          value: 'listCampaignSources',
        },
      ],
    },
  },
  {
    label: 'Portal User',
    key: 'portalUser',
    type: 'dropdown',
    required: false,
    description: '',
    variables: true,
    options: [
      { label: 'True', value: '1' },
      { label: 'False', value: '-1' },
    ],
  },
  {
    label: 'Support Start Date',
    key: 'supportStartDate',
    type: 'string',
    required: false,
    description: 'format: yyyy-mm-dd',
    variables: true,
  },
  {
    label: 'Support End Date',
    key: 'supportEndDate',
    type: 'string',
    required: false,
    description: 'format: yyyy-mm-dd',
    variables: true,
  },
  {
    label: 'Other Country',
    key: 'otherCountry',
    type: 'dropdown',
    required: false,
    description: '',
    variables: true,
    source: {
      type: 'query',
      name: 'getDynamicData',
      arguments: [
        {
          name: 'key',
          value: 'listContactOptions',
        },
        {
          name: 'parameters.otherCountry',
          value: 'othercountry',
        },
      ],
    },
  },
  {
    label: 'Mailing Country',
    key: 'mailingCountry',
    type: 'dropdown',
    required: false,
    description: '',
    variables: true,
    source: {
      type: 'query',
      name: 'getDynamicData',
      arguments: [
        {
          name: 'key',
          value: 'listContactOptions',
        },
        {
          name: 'parameters.mailingCountry',
          value: 'mailingcountry',
        },
      ],
    },
  },
  {
    label: 'Mailing Street',
    key: 'mailingStreet',
    type: 'string',
    required: false,
    description: '',
    variables: true,
  },
  {
    label: 'Other Street',
    key: 'otherStreet',
    type: 'string',
    required: false,
    description: '',
    variables: true,
  },
  {
    label: 'Mailing PO Box',
    key: 'mailingPoBox',
    type: 'string',
    required: false,
    description: '',
    variables: true,
  },
  {
    label: 'Other PO Box',
    key: 'otherPoBox',
    type: 'string',
    required: false,
    description: '',
    variables: true,
  },
  {
    label: 'Mailing City',
    key: 'mailingCity',
    type: 'string',
    required: false,
    description: '',
    variables: true,
  },
  {
    label: 'Other City',
    key: 'otherCity',
    type: 'string',
    required: false,
    description: '',
    variables: true,
  },
  {
    label: 'Mailing State',
    key: 'mailingState',
    type: 'dropdown',
    required: false,
    description: '',
    variables: true,
    source: {
      type: 'query',
      name: 'getDynamicData',
      arguments: [
        {
          name: 'key',
          value: 'listContactOptions',
        },
        {
          name: 'parameters.mailingState',
          value: 'mailingstate',
        },
      ],
    },
  },
  {
    label: 'Other State',
    key: 'otherState',
    type: 'dropdown',
    required: false,
    description: '',
    variables: true,
    source: {
      type: 'query',
      name: 'getDynamicData',
      arguments: [
        {
          name: 'key',
          value: 'listContactOptions',
        },
        {
          name: 'parameters.otherState',
          value: 'otherstate',
        },
      ],
    },
  },
  {
    label: 'Mailing Zip',
    key: 'mailingZip',
    type: 'string',
    required: false,
    description: '',
    variables: true,
  },
  {
    label: 'Other Zip',
    key: 'otherZip',
    type: 'string',
    required: false,
    description: '',
    variables: true,
  },
  {
    label: 'Description',
    key: 'description',
    type: 'string',
    required: false,
    description: '',
    variables: true,
  },
  {
    label: 'Contact Image',
    key: 'contactImage',
    type: 'string',
    required: false,
    description: '',
    variables: true,
  },
  {
    label: 'Linkedin URL',
    key: 'linkedinUrl',
    type: 'string',
    required: false,
    description: '',
    variables: true,
  },
  {
    label: 'Linkedin Followers',
    key: 'linkedinFollowers',
    type: 'string',
    required: false,
    description: '',
    variables: true,
  },
  {
    label: 'Facebook URL',
    key: 'facebookUrl',
    type: 'string',
    required: false,
    description: '',
    variables: true,
  },
  {
    label: 'Facebook Followers',
    key: 'facebookFollowers',
    type: 'string',
    required: false,
    description: '',
    variables: true,
  },
];
