# Gateway

The API Gateway provides an external route into your functions and collects Cloud Native metrics through Prometheus. The gateway also has a UI built-in which can be used to deploy your own functions or functions from the OpenFaaS Function Store then invoke them.

The gateway will scale functions according to demand by altering the service replica count in the Kubernetes API. Custom alerts generated by AlertManager are received on the /system/alert endpoint.

In summary:

* Built-in UI Portal
* Deploy functions from the Function Store or deploy your own
* Instrumentation via Prometheus
* Auto-scaling via AlertManager and Prometheus
* Scaling up from zero
* REST API available documented with Swagger

![OpenFaaS Gateway](https://docs.openfaas.com/images/of-conceptual-operator.png)

*Pictured: conceptual architecture when Kubernetes is used as the orchestration provider*

## Function Providers

Providers for functions can be written using the [faas-provider](https://github.com/openfaas/faas-provider/) interface in Golang which provides the REST API for interacting with the gateway.

## REST API

Swagger docs: https://github.com/openfaas/faas/tree/master/api-docs

## CORS

By default the only CORS path allowed is for the Function Store which is served from the GitHub RAW CDN.

## UI Portal

The built-in UI Portal is served through static files bound at the /ui/ path.

The UI was written in Angular 1.x and makes uses of jQuery for interactions and the Angular Material theme for visual effects and components.

View the source in the [assets](./assets/) folder.

### Function Store

The Function Store is rendered through a static JSON file served by the GitHub RAW CDN. The Function Store can also be used via the [OpenFaaS CLI](https://github.com/openfaas/faas-cli).

See the [openfaas/store](https://github.com/openfaas/store) repo for more.

## Logs

Logs are available at the function level via the API.

You can also install a Docker logging driver to aggregate your logs. By default functions will not write the request and response bodies to stdout. You can toggle this behaviour by setting `read_debug` for the request and `write_debug` for the response.

## Tracing

An "X-Call-Id" header is applied to every incoming call through the gateway and is usable for tracing and monitoring calls. We use a UUID for this string.

Header:

```
X-Call-Id
```

Within a function this is available as `Http_X_Call_Id`.

## Environmental overrides
The gateway can be configured through the following environment variables:

| Option                 | Usage             |
|------------------------|--------------|
| `write_timeout`        | HTTP timeout for writing a response body from your function (in seconds). Default: `8`  |
| `read_timeout`         | HTTP timeout for reading the payload from the client caller (in seconds). Default: `8` |
| `functions_provider_url`             | URL of upstream [functions provider](https://github.com/openfaas/faas-provider/) - i.e. Swarm, Kubernetes, Nomad etc  |
| `logs_provider_url` | URL of the upstream function logs api provider, optional, when empty the `functions_provider_url` is used |
| `faas_nats_address`          | The host at which NATS Streaming can be reached. Required for asynchronous mode |
| `faas_nats_port`    | The port at which NATS Streaming can be reached. Required for asynchronous mode |
| `faas_nats_cluster_name` | The name of the target NATS Streaming cluster. Defaults to `faas-cluster` for backwards-compatibility |
| `faas_nats_channel` | The name of the NATS Streaming channel to use. Defaults to `faas-request` for backwards-compatibility |
| `faas_prometheus_host`         | Host to connect to Prometheus. Default: `"prometheus"` |
| `faas_prometheus_port`         | Port to connect to Prometheus. Default: `9090` |
| `direct_functions`            | `true` or `false` -  functions are invoked directly over overlay network by DNS name without passing through the provider |
| `direct_functions_suffix`     | Provide a DNS suffix for invoking functions directly over overlay network  |
| `basic_auth`              | Set to `true` or `false` to enable embedded basic auth on the /system and /ui endpoints (recommended) |
| `secret_mount_path`       | Set a location where you have mounted `basic-auth-user` and `basic-auth-password`, default: `/run/secrets/`. |
| `scale_from_zero`       | Enables an intercepting proxy which will scale any function from 0 replicas to the desired amount |
