## OpenFaaS Community

Welcome to the OpenFaaS community page where you can find:

* [Industry awards, notable mentions and books](#industry-awards-notable-mentions-and-books)
* [Function Providers/Back-ends](#openfaas-providers)
* [Commercial adoption and end-users](https://github.com/openfaas/faas/blob/master/ADOPTERS.md)

* Blog posts and write-ups
    * [2017](#blog-posts-and-write-ups-2017) [2018](#blog-posts-and-write-ups-2018) [2019](#blog-posts-and-write-ups-2019) [2020](#blog-posts-and-write-ups-2020) [2021](#blog-posts-and-write-ups-2021) [2022](#blog-posts-and-write-ups-2022)

* Events
    * [2017](#events-in-2017) [2018](#events-in-2018) [2019](#events-in-2019) [2021](#events-in-2021) [2022](#events-in-2022)

* [Repositories - Projects, Samples, and Use Cases](#repositories)

There are several key GitHub repositories for the project which are available under the [openfaas](https://github.com/openfaas) organisation. Incubator and experimental projects are under the [openfaas-incubator](https://github.com/openfaas-incubator) organisation.

#### How to submit a link to this page

It would be great to hear from you especially if you have any of the above and want to share it with the rest of the community. Pull Request or submit a Github Issue.

> Note: You will need to sign-off the commit too using `git commit -s` or add `Signed-off-by: {your full name} <{your email address}>` to the commit message when using the UI.

### Industry awards, notable mentions and books

[Back to top](#openfaas-community)

| Award or mention                                          | Author(s)       | Source     | Date        |
|---------------------------------------------------------------------|--------------|----------|-------------|
| [Book: Serverless for Everyone Else](https://gumroad.com/l/serverless-for-everyone-else) | Alex Ellis | gumroad.com | 15-Jan-2021 |
| 🏆 [Winners of the Best of VMworld 2020 Awards - Startup Spotlight 2020 winner](https://searchservervirtualization.techtarget.com/photostory/252489586/Winners-of-the-Best-of-VMworld-2020-Awards/8/Judges-choice-Startup-Spotlight-2020-winner) | Tech Target | techtarget.com | 30-Sep-2020 |
| [Serverless on Kubernetes training course](https://training.linuxfoundation.org/announcements/new-free-training-course-teaches-fundamentals-of-serverless-on-kubernetes/) | Linux Foundation & Alex Ellis | LinuxFoundation.org | 10-Sep-2020 |
| [Battle Over Serverless Computing Frameworks to Heat Up in 2019](https://www.itbusinessedge.com/articles/battle-over-serverless-computing-frameworks-to-heat-up-in-2019.html) | Mike Vizard | itbusinessedge.com | 03-Jan-2019 |
| [Serverless Inside Out: Architecture & Practices](https://www.amazon.cn/dp/B07LD4KXG3/) | Nicholas Geng Chen | China Machine Press | 01-Jan-2019 |
| 🏆🏆 [2018 Bossie Award Best OSS Cloud Computing](https://www.infoworld.com/article/3306455/cloud-computing/the-best-open-source-software-for-cloud-computing.html#slide13) | Jonathan Freeman et al. | InfoWorld.com | 26-Sep-2018 |
| [KubeWeekly #145](https://mailchi.mp/cncf/kubeweekly-145?e=5c7c372824) | [KubeWeekly](https://twitter.com/kubeweekly?lang=en) | mailchi.mp | 15-Aug-2018 |
| [Book: Docker for Serverless Applications with OpenFaaS - featuring OpenFaaS](https://www.packtpub.com/mapt/book/virtualization_and_cloud/9781788835268) | Chanwit Kaewkasi | packtpub.com | 01-Apr-2018 |
| [The Cube interview at Cisco DevNet Create](https://www.youtube.com/watch?v=J8UYZ1GXNTQ) | The Cube | Youtube.com | 11-Apr-2018
| [VMware hires OpenFaaS Founder](https://thenewstack.io/vmware-hires-openfaas-founder-dell-drops-code-initiative-2/) | The New Stack | thenewstack.io | 21-Feb-2018 |
| [Book: Kubernetes for Serverless Applications - featuring OpenFaaS](https://www.packtpub.com/mapt/book/networking_and_servers/9781788620376) |  Russ McKendrick | packtpub.com | 01-Jan-2018
| [OpenFaaS added to CNCF Cloud Native Landscape - Serverless/Event-based](https://github.com/cncf/landscape/blob/master/landscape/CloudNativeLandscape_latest.jpg) | [Cloud Native Computing Foundation (CNCF)](https://www.cncf.io/) | Github | 23-Oct-2017 |
| [OpenFaaS: Package any Binary or Code as a Serverless Function](https://thenewstack.io/openfaas-put-serverless-function-container/) | Joab Jackson | The New Stack | 9-Oct-2017 |
| [Functions-as-a-Service Landscape](https://medium.com/memory-leak/this-year-gartner-added-serverless-to-its-hype-cycle-of-emerging-technologies-reflecting-the-5dfe43d818f0) | Astasia Myers | Redpoint Ventures | 4-Oct-2017 |
| 🏆 [Bossie Award for Cloud Computing 2017](https://www.infoworld.com/article/3227920/cloud-computing/bossie-awards-2017-the-best-cloud-computing-software.html#slide7) |  Martin Heller, Andrew C. Oliver and Serdar Yegulalp| InfoWorld (from IDG) |  27-Sep-2017 |
| [Open source project uses Docker for serverless computing](http://www.infoworld.com/article/3184757/open-source-tools/open-source-project-uses-docker-for-serverless-computing.html#tk.twt_ifw)| Serdar Yegulalp  | InfoWorld (from IDG)  | 27-Mar-2017 |

### Interviews and podcasts

[Back to top](#openfaas-community)

| Title                                                               | Show       | Date        |
|---------------------------------------------------------------------|--------------|----------|
| [The Cube Interview - Monetising Open Source at KubeCon Valencia](https://www.youtube.com/watch?v=iyMIF4olLWI) | the Cube | 19-May-2022 |
| ["Balancing OSS Sacrifice with Success"](https://github.com/readme/alex-ellis) | GitHub ReadME program | 04-Sep-2020 |
| [Episode #116 Independent Open Source, with Alex Ellis](https://kubernetespodcast.com/episode/116-independent-open-source/) | Kubernetes Podcast by Google | 12-Aug-2020 |
| [The explosive growth of CNCF, what is Kubernetes and independent open source](https://blog.newrelic.com/engineering/observy-mcobservface-episode-no-2-alex-ellis/) | Observy McObservface | 29-07-2020 |
| [How OpenFaaS Found its groove with arm](https://www.worksonarm.com/blog/how-openfaas-found-its-groove-with-arm/) | WorksOnArm | 20-04-2020 |
| [POPCAST Episode 5 - Going independent and Cloud Native Open Source](https://www.youtube.com/watch?v=66mMC9w-dM4) | Popcast | 09-04-2020 |
| [Serverless, FaaS, and Kubernetes Tools with Alex Ellis of OpenFaaS DevOps and Docker Talk](https://podcast.bretfisher.com/episodes/serverless-faas-and-kubernetes-tools-with-alex-ellis-of-openfaas) | Bret Fisher Docker and DevOps Talk| 24-Apr-2020 |
| [Serverless Functions with Alex Ellis of OpenFaaS: DevOps and Docker Live Show (Ep 68)](https://www.youtube.com/watch?v=5zDvjIkMf9I) | Bret Fisher Docker and DevOps | 16-Jan-2020 |
| [Serverless and OpenFaas with Alex Ellis](https://hanselminutes.com/612/serverless-and-openfaas-with-alex-ellis) | The Hanselminutes Podcast | 29-Dec-2019 |
| [OpenFaaS Creator on Open Source’s Community-Funding Model](https://thenewstack.io/openfaas-creator-on-open-sources-community-funding-model/) | The New Stack | 11-Jul-2019 |
| [Running functions anywhere with OpenFaaS - featuring Alex Ellis](https://changelog.com/podcast/343) | The Changelog | 25-Apr-2019 |
| [Episode 022 – OpenFaaS with Docker Captain](https://changelog.com/podcast/343) | The 6 Figure Developer Podcast | 15-Jan-2018 |
| [Serverless and OpenFaas with Alex Ellis](https://hanselminutes.com/612/serverless-and-openfaas-with-alex-ellis) | Hanselminutes with Scott Hanselman | 29-Dec-2017 |

### Featured Videos

[Back to top](#openfaas-community)

| Title                                                              | Presenter       | Date      |
| ------------------------------------------------------------------ | --------------- | --------- |
| [How and Why We Rebuilt Auto-scaling in OpenFaaS with Prometheus - Alex Ellis, KubeCon Valencia](https://www.youtube.com/watch?v=ka5QjX0JgFo) | Alex Ellis | 19-May-2022 |
| [Your pocket-sized cloud with OpenFaaS and GitHub Actions](https://www.youtube.com/watch?v=HTgUCm9RedU) | Alex Ellis & Martin Woodword | 25-Mar-2022 |
| [Meet faasd. Look Ma’ No Kubernetes! - Alex Ellis @ KubeCon](https://www.youtube.com/watch?v=ZnZJXI377ak&feature=youtu.be) | Alex Ellis | 8-Sep-2020 |
| [Cloud Native Tools for Developers with Alex Ellis and Alistair Hey](https://youtu.be/r4mEF8rtXWo) | Alex Ellis and Alistair Hey | 13-Mar-2019 |
| [Getting Beyond FaaS: The PLONK Stack for Kubernetes Developers](https://www.youtube.com/watch?v=NckMekZXRt8) | Alex Ellis | 21-Nov-2019 |
| [OpenFaaS Cloud + Linkerd: A Secure, Multi-Tenant Serverless Platform](https://www.youtube.com/watch?v=sD7hCwq3Gw0) | Charles Pretzer & Alex Ellis | 20-Nov-2019 |
| [How LivePerson is Tailoring its Conversational Platform Using OpenFaaS - ](https://youtu.be/bt06Z28uzPA) | Simon Pelczer & Ivana Yovcheva | 23-May-2019 |
| [OpenFaaS Community Call - December OpenFaaS is 3!](https://www.youtube.com/watch?v=wXnYx-wD4Zk) | Various | 18-Dec-2019 |
| [OpenFaaS Cloud in 100 seconds (ofc-bootstrap)](https://www.youtube.com/watch?v=Sa1VBSfVpK0&index=21&list=PLlIapFDp305DiIRhJFNzMuJXoBnzKdtpi) | Alex Ellis | 31-Jan-2019 |
| [GOTO 2018, Serverless Beyond the Hype, Alex Ellis](https://www.youtube.com/watch?v=yOpYYYRuDQ0) | Alex Ellis | 30-Jan-2019 |
| [Digital Transformation of Vision Banco Paraguay with Serverless Functions @ KubeCon](https://kccna18.sched.com/event/GraO/digital-transformation-of-vision-banco-paraguay-with-serverless-functions-alex-ellis-vmware-patricio-diaz-vision-banco-saeca) | Alex Ellis & Patricio Diaz | 13-Dec-2018 |
| [Introducing "faas" - Cool Hacks Keynote at Dockercon 2017](https://blog.docker.com/2017/04/dockercon-2017-mobys-cool-hack-sessions/) | Alex Ellis | 04-April-2017 |

### 2023

#### Blog posts, write-ups and videos 2023

[Back to top](#openfaas-community)

| Blog/video/repo name and description                                          | Author       | Site     | Date        |
|-------------------------------------------------------------------------|--------------|----------|-------------|
| [Building OpenFaaS Serverless function to detect weather using OpenWeatherMap and Python](https://www.faizanbashir.me/building-openfaas-serverless-function-to-detect-weather-using-openweathermap-and-python) | Faizan Bashir | faizanbashir.me | 02-Apr-2023 |
| [Fine-tuning the cold-start in OpenFaaS ](https://www.openfaas.com/blog/fine-tuning-the-cold-start/) | Alex Ellis | openfaas.com | 28-Mar-2023 |
| [How do changes to the Docker Hub affect OpenFaaS?](https://www.openfaas.com/blog/how-does-docker-hub-affect-openfaas/) | Alex Ellis | openfaas.com | 20-Mar-2023 |
| [Cluster auto-scaling with DigitalOcean Kubernetes and OpenFaaS](https://www.openfaas.com/blog/cluster-autoscaling-with-digitalocean/) | Alex Ellis | openfaas.com | 16-Mar-2023 |
| [Import leads from Google Forms into your CRM with functions](https://www.openfaas.com/blog/import-leads-from-google-forms-to-crm/) | Alex Ellis | openfaas.com | 02-Mar-2023 |
| [Using OpenFaaS on AKS](https://learn.microsoft.com/en-us/azure/aks/openfaas) | Various | learn.microsoft.com | 27-Feb-2023 |
| [How to integrate OpenFaaS functions with managed AWS services](https://www.openfaas.com/blog/integrate-openfaas-with-managed-aws-services/) | Han Verstraete | openfaas.com | 19-Jan-2023 |

### 2022

#### Blog posts, write-ups and videos 2022

[Back to top](#openfaas-community)

| Blog/video/repo name and description                                          | Author       | Site     | Date        |
|-------------------------------------------------------------------------|--------------|----------|-------------|
| [Trigger OpenFaaS functions from PostgreSQL with AWS Aurora](https://www.openfaas.com/blog/trigger-functions-from-postgres/) | Han Verstraete | openfaas.com | 16-Dec-2022 |
| [Introducing our new Python template for production](https://www.openfaas.com/blog/openfaas-pro-python-template/) | Han Verstraete | openfaas.com | 06-Dec-2022 |
| [Deploy Serverless Function on k3s/Kubernetes with OpenFaaS (x86/Arm, Linux VM, Go)](https://www.youtube.com/watch?v=-8MrDWg6K6s) | David Hwang | youtube.com | 09-Nov-2022 |
| [Rethinking Auto-scaling for OpenFaaS](https://www.openfaas.com/blog/autoscaling-functions/) | Han Verstraete | openfaas.com | 05-Nov-2022 |
| [Custom health and readiness checks for your OpenFaaS Functions](https://www.openfaas.com/blog/health-and-readiness-for-functions/) | Alex Ellis | openfaas.com | 26-Oct-2022 |
| [Generate PDFs at scale on Kubernetes using OpenFaaS and Puppeteer](https://www.openfaas.com/blog/pdf-generation-at-scale-on-kubernetes/) | Han Verstraete | openfaas.com | 06-Oct-2022 |
| [Eliminate vendor locking of Serverless workloads with OpenFaaS](https://awstip.com/eliminate-vendor-lock-in-of-serverless-workloads-with-openfaas-474807383ce1) | Meher Chaitanya | medium.com | 06-Oct-2022 |
| [Use the Serverless Function Method to Build a Machine Learning Microservice System](https://blog.infuseai.io/use-serverless-function-method-to-build-a-ml-microservice-system-a108f3f2c1c) |  SimonLiu  | blog.infuseai.io | 30-Aug-2022 |
| [Go Functions as a Service With Kubernetes and OpenFaaS](https://dominikbraun.io/blog/go-functions-as-a-service-with-kubernetes-and-openfaas/) |  Dominik Braun  | dominikbraun.io | 24-Aug-2022 |
| [Exploring the Fan out and Fan in pattern with OpenFaaS](https://www.openfaas.com/blog/fan-out-and-back-in-using-functions/) | Han Verstraete | openfaas.com | 22-Aug-2022 |
| [Finding Raspberry Pis with Raspberry Pis](https://www.openfaas.com/blog/searching-for-raspberrypi/) | Alex Ellis | openfaas.com | 08-Aug-2022 |
| [The Next Generation of Queuing: JetStream for OpenFaaS](https://www.openfaas.com/blog/jetstream-for-openfaas/) | Han Verstraete | openfaas.com | 21-Jul-2022 |
| [How to update your OpenFaaS functions automatically with the Argo CD Image Updater](https://www.openfaas.com/blog/argocd-image-updater-for-functions/) | Han Verstraete | openfaas.com | 04-Jul-2022 |
| [How to build functions from source code with the Function Builder API](https://www.openfaas.com/blog/how-to-build-via-api/) | Han Verstraete | openfaas.com | 23-Jun-2022 |
| [OpenFaaS First Function](https://rpi4cluster.com/k3s/k3s-openfaas-function/) | Vlado Portos | rpi4cluster.com | 22-Jun-2022 |
| [OpenFaaS](https://rpi4cluster.com/k3s/k3s-openfaas/) | Vlado Portos | rpi4cluster.com | 22-Jun-2022 |
| [How to package OpenFaaS functions with Helm](https://www.openfaas.com/blog/howto-package-functions-with-helm/) | Han Verstraete | openfaas.com | 09-Jun-2022 |
| [The Event-Driven Edge with OpenFaaS](https://www.openfaas.com/blog/eventdriven-edge/) | Han Verstraete | openfaas.com | 01-Jun-2022 |
| [Running faasd on Azure Arm-based Virtual Machines](https://blog.ediri.io/running-faasd-on-azure-arm-based-virtual-machines) | Engin Diri | blog.ediri.io | 27-May-2022 |
| [WebAssembly functions in OpenFaaS using Sat (Part1)](https://www.wasm.builders/suborbital/webassembly-functions-in-openfaas-using-sat-part-1-2omk) | Connor Hicks | wasm.builders | 04-May-2022 |
| [Building a RESTful API with functions](https://simonemms.com/blog/2022/04/24/building-a-restful-api-with-serverless-functions/) | Simon Emms | simonemms.com | 24-Apr-2022 |
| [How to process your data the resilient way with back pressure](https://www.openfaas.com/blog/limits-and-backpressure/) | Alex Ellis | openfaas.com | 12-May-2022 |
| [Open-Faas on Centos 7](https://medium.com/geekculture/open-faas-on-centos-7-c4dc629f28fe) | Heshani Samarasekara | medium.com | 07-May-2022 |
| [A Deep Dive into Golang for OpenFaaS Functions](https://www.openfaas.com/blog/golang-deep-dive/) | Alex Ellis | openfaas.com | 13-Apr-2022 |
| [Serverless Architecture with OpenFaaS and Java](https://www.xenonstack.com/blog/serverless-open-faas-java) | Navdeep Singh Gill | xenonstack.com | 13-Mar-2022 |
| [My Journey Contributing To OpenFaaS So Far](https://www.openfaas.com/blog/my-journey-contributing-to-openfaas/) | Nitishkumar Singh | openfaas.com | 02-Mar-2022 |
| [Your pocket-sized cloud with a Raspberry Pi](https://blog.alexellis.io/your-pocket-sized-cloud/) | Alex Ellis | openfaas.com | 23-Mar-2022 |
| [Hosting a React App with OpenFaaS](https://www.openfaas.com/blog/react-app/) | Alex Ellis | openfaas.com | 01-Mar-2022 |
| [Dude where's my coldstart?](https://www.openfaas.com/blog/what-serverless-coldstart/) | Alex Ellis | openfaas.com | 19-Jan-2022 |
| [OpenFaaS Highlights from 2021](https://www.openfaas.com/blog/highlights-2021/) | Alex Ellis | openfaas.com | 04-Jan-2022 |
| [OpenFaaS and HashiCorp Vault](https://johansiebens.dev/posts/2022/01/openfaas-and-hashicorp-vault/) | Johan Siebens | johansiebens.dev | 21-Jan-2022 |

### Events in 2022

Mainly virtual due to pandemic.

[Back to top](#openfaas-community)

| Event name and description                                          | Speaker      | Location | Date        |
|---------------------------------------------------------------------|--------------|----------|-------------|
| [How and Why We Rebuilt Auto-scaling in OpenFaaS with Prometheus - Alex Ellis, KubeCon Valencia](https://www.youtube.com/watch?v=ka5QjX0JgFo)  | Alex Ellis | Valencia, Spain | 19-May-2022 |
| [Your pocket-sized cloud with OpenFaaS and GitHub Actions](https://www.youtube.com/watch?v=HTgUCm9RedU) | Alex Ellis & Martin Woodword | YouTube | 25-Mar-2022 |

### 2021

#### Blog posts and write-ups 2021

[Back to top](#openfaas-community)

| Blog/repo name and description                                          | Author       | Site     | Date        |
|-------------------------------------------------------------------------|--------------|----------|-------------|
| [Configure your OpenFaaS functions for staging and production](https://www.openfaas.com/blog/custom-environments/) | Alex Ellis | openfaas.com | 09-Dec-2021 |
| [OpenFaaS - Run Containerized Functions On Your Own Terms](https://iximiuz.com/en/posts/openfaas-case-study/) | Ivan Velichko | iximiuz.com | 02-Dec-2021 |
| [Making a Docker Dev Environment for OpenFaaS](https://www.felipecruz.es/making-a-docker-dev-environment-for-openfaas/) | Felipe Cruz | felipecruz.es | 30-Nov-2021 |
| [Build at the Edge with OpenFaaS and GitHub Actions](https://www.openfaas.com/blog/edge-actions/) | Alex Ellis | openfaas.com | 29-Nov-2021 |
| [Improving long-running jobs for OpenFaaS users](https://www.openfaas.com/blog/long-running-jobs/) | Alex Ellis | openfaas.com | 05-Nov-2021 |
| [Derek says goodbye to Docker Swarm](https://www.openfaas.com/blog/migrating-derek-from-docker-swarm/) | Alex Ellis | openfaas.com | 05-Oct-2021 |
| [Case-study: Building a Low Code automation platform with OpenFaaS](https://www.openfaas.com/blog/low-code-automation/) | Veselin Pizurica | openfaas.com | 05-Oct-2021 |
| [OpenFaaS on RHOCP 4.x – Part 1](https://community.ibm.com/community/user/publiccloud/blogs/alexei-karve/2021/07/06/openfaas-on-rhocp-1) | Alexei Karve | community.ibm.com | 06-July-2021 |
| [Kubernetes in Docker (KinD) で OpenFaaS を動かす！](https://yoh1496.hatenablog.com/entry/2021/05/17/182207) | ishiguro-yo | yoh1496.hatenablog.com | 17-May-2021 |
| [Secure Serverless with OpenFaaS](https://dev.to/mikeyglitz/secure-serverless-with-openfaas-509b) | Michael Glitzos | medium.com | 14-May-2021 |
| [Learn how Istio can provide a service mesh for your functions](https://www.openfaas.com/blog/istio-functions/) | Alex Ellis | openfaas.com | 12-May-2021 |
| [Functions for data science with R templates for OpenFaaS](https://www.openfaas.com/blog/r-templates/) | Peter Solymos | openfaas.com | 12-May-2021 |
| [Learn how to build functions faster using Rancher's kim and K3s](https://www.openfaas.com/blog/kim/) | Alex Ellis | openfaas.com | 12-May-2021 |
| [OpenFaas mit faasd installieren](https://blog.micro-saas.de/open-faas-mit-faasd-installieren/) | Björn Renzel| blog.micro-saas.de | 24-
-2021
| [Bring GitOps to your OpenFaaS functions with ArgoCD](https://www.openfaas.com/blog/bring-gitops-to-your-openfaas-functions-with-argocd/) | Batuhan Apaydın | openfaas.com | 15-Apr-2021 |
| [OpenFaaS and GKE Autopilot](https://johansiebens.dev/posts/2021/03/openfaas-and-gke-autopilot/) | Johan Siebens | johansiebens.dev | 16-Mar-2021 |
| [Exploring Serverless Use-cases from Companies and the Community](https://www.openfaas.com/blog/exploring-serverless-live/) | Alex Ellis | openfaas.com | 19-Feb-2021 |
| [Micro APIs with OpenFaaS and .NET](https://itnext.io/micro-apis-with-openfaas-and-net-f82115efce4) | Goncalo Oliveira | itnext.io | 06-Feb-2021 |
| [Extend and automate self-hosted Gitea with functions ](https://www.openfaas.com/blog/gitea-faas/) | Matti Ranta | openfaas.com | 31-Jan-2021 |
| [Event driven functions powered by Postgres](https://lucasroesler.com/posts/2021/event-driven-faasd-with-postgres/) | Lucas Roesler | lucasroesler.com | 30-Jan-2021 |
| [How to integrate with GitHub the right way with GitHub Apps](https://www.openfaas.com/blog/integrate-with-github-apps-and-faasd/) | Batuhan Apaydın | openfaas.com | 26-Jan-2021 |
| [Serverless with OpenFaaS and .NET](https://goncalo-a-oliveira.medium.com/serverless-with-openfaas-and-net-6a66b5c30a5f) | Batuhan Apaydın | medium.com | 20-Jan-2021 |
| [How I discovered faas and what it changed for me](https://releasecandidate.dev/posts/2021/discovery-faasd-and-openfaas/) | Peter Thaleikis | releasecandidate.dev | 05-Jan-2021 |
| [Installing OpenFaaS On k3s (Single Node)](https://midnightprogrammer.net/post/installing-openfaas-on-k3s-single-node/) | Pashant Khandelwal  | midnightprogrammer.net | 04-Jan-2021 |

#### Events in 2021

Mainly virtual due to pandemic.

[Back to top](#openfaas-community)

| Event name and description                                          | Speaker      | Location | Date        |
|---------------------------------------------------------------------|--------------|----------|-------------|
| [GopherCon UK 2021: Alex Ellis - Zero to OpenFaas in 60 months](https://www.youtube.com/watch?v=QzwBmHkP-rQ) | Alex Ellis | London, UK | 22 Nov 2021 |
| [Event driven Postgres with OpenFaaS](https://www.youtube.com/watch?v=nGOZLOjg5Zs) | Alex Ellis and Lucas Roesler | YouTube | 02-Feb-2021 |
| [Exploring Serverless use-cases with David McKay (Rawkode) and Alex Ellis](https://www.youtube.com/watch?v=mzuXVuccaqI) | YouTube | David McKay (Rawkode) and Alex Ellis | 27-Jan-2021 |

### 2020

#### Events in 2020

[Back to top](#openfaas-community)

| Event name and description                                          | Speaker      | Location | Date        |
|---------------------------------------------------------------------|--------------|----------|-------------|
| [Meet faasd. Look Ma’ No Kubernetes!](https://spseu20.sched.com/event/ZWeT/meet-faasd-look-ma-no-kubernetes-alex-ellis-openfaas-ltd) | Alex Ellis | SPS, KubeCon EU | 17-Aug-2020 |
| [WebAssembly + OpenFaas, the Universal Runtime for Serverless Functions](https://spseu20.sched.com/event/aYpr) | Ramiro Berrelleza | SPS, KubeCon EU | 17-Aug-2020 |
| [Finding Managed Services in a Serverless World with Crossplane and OpenFaaS](https://spseu20.sched.com/event/aYq0/finding-managed-services-in-a-serverless-world-with-crossplane-and-openfaas-daniel-mangum-upbound) | Daniel Mangum | SPS, KubeCon EU | 17-Aug-2020 |
| [Migrating AWS Lambda Functions to Open Source Serverless on OpenFaaS](https://www.youtube.com/watch?v=0ZuHCSz1jjQ) | Burton Rheutan | Open Source Summit North America | 30-Jun-2020 |
| [OpenFaaS: Serverless platform with no strings attached?](https://ndcoslo.com/talk/lightning-talks-3/) | Andreas Mosti | NDC Oslo 2020 Online | 12-Jun-2020 |
| [GitOps meets Serverless with OpenFaaS and Flux ](https://www.meetup.com/Weave-User-Group/events/269899027/) | Alex Ellis | Weave Online User Group | 29-Apr-2020 |
| [Service Mesh and Serverless Chatbots with Linkerd, K8s and OpenFaaS](https://sg.com.mx/sgvirtual/sessions/service-mesh-and-serverless-chatbots-with-linkerd-k8s-and-openfaas/) | Sergio Méndez | SG Virtual Conference | 21-Apr-2020 |
| [Serverless for Kubernetes with NATS and PLONK](https://youtu.be/J0zbYbvYiM8?t=1135) | Alex Ellis | NATS Connect | 16-Apr-2020 |
| [The Need for a Cloud Native Tunnel](https://virtual.rejekts.io) | Alex Ellis | Virtual Cloud Native Rejekts | 1-Apr-2020 |
| [TBS[13] Crossplane and OpenFaaS livestream](https://www.youtube.com/watch?v=XphQgB87U-s&feature=youtu.be)| Daniel Mangum & Alex Ellis | YouTube | 26-Mar-2020 |
| [Kubernetes the easy way with k3sup, OpenFaaS and inlets](https://www.youtube.com/watch?v=r4mEF8rtXWo) | Alex Ellis & Alistair Hey | Online Webinar for Traefik | 12-Mar-2020 |
| [Service Mesh and Serverless Chatbots with Linkerd, K8s and OpenFaaS](https://www.meetup.com/de-DE/cloud-native-plus-gt/events/269147693/) | Sergio M. | Zoom | 12-Mar-2020 |

Postponed events for 2020

| Event name and description                                          | Speaker      | Location | Date        |
|---------------------------------------------------------------------|--------------|----------|-------------|
| [Service Mesh and Serverless Chatbots with Linkerd K8s and OpenFaaS](https://kccnceu20.sched.com/event/Zemu/service-mesh-and-serverless-chatbots-with-linkerd-k8s-and-openfaas-sergio-mendez-universidad-san-calors-de-guatemala)| Sergio Méndez | Kubecon EU| 02-Apr-2020 |
| [Strangling Our Venue Management Monolith at DX with Kubernetes and OpenFaaS](https://kccnceu20.sched.com/event/Zelz/strangling-our-venue-management-monolith-at-dx-with-kubernetes-and-openfaas-christian-sakshaug-dialog-exe-dx-alex-ellis-openfaas-ltd)| Alex Ellis & Christian Sakshaug | Kubecon EU| 02-Apr-2020 |
| [Sending Billions of Payments Using Hybrid Cloud and Open-source Technologies](https://kccnceu20.sched.com/event/ZejH/sending-billions-of-payments-using-hybrid-open-source-serverless-edward-wilde-bruno-miguel-custodio-form3)| Edward Wilde & Bruno Miguel Custódio | Kubecon EU| 02-Apr-2020 |
| [Finding Managed Services in a Serverless World with Crossplane and OpenFaaS](https://spseu20.sched.com/event/aYq0/finding-managed-services-in-a-serverless-world-with-crossplane-and-openfaas-daniel-mangum-upbound) | Daniel Mangum | Serverless Practitioners Summit - KubeCon EU | 30-Mar-2020 |
| [Meet faasd. Look ma’ no Kubernetes!](https://spseu20.sched.com/event/ZWeT/meet-faasd-look-ma-no-kubernetes-alex-ellis-openfaas-ltd) | Alex Ellis | Serverless Practitioners Summit @ KubeCon Amsterdam | 30-Mar-2020 |
| [The State of Open Source Serverless](https://cfp.cloud-native.rejekts.io/cloud-native-rejekts-eu-2020/talk/VDHD7C/) | Jonatas Baldin | Cloud Native Rejekts EU '20 | 28-Mar-2020 |
| [The Need for a Cloud Native Tunnel](https://cfp.cloud-native.rejekts.io/cloud-native-rejekts-eu-2020/talk/MB7AMY/) | Alex Ellis | Cloud Native Rejekts, Amsterdam | 23-Mar-2020 |
| [WebAssembly + OpenFaaS, the Universal Runtime for Serverless Functions](https://spseu20.sched.com/event/aYpr/webassembly-openfaas-the-universal-runtime-for-serverless-functions-ramiro-berrelleza-okteto)| Ramiro Berrelleza | Kubecon EU| 30-March-2020 |

#### Blog posts and write-ups 2020

[Back to top](#openfaas-community)

| Blog/repo name and description                                          | Author       | Site     | Date        |
|-------------------------------------------------------------------------|--------------|----------|-------------|
| [You're invited to our 4th Birthday!](https://www.openfaas.com/blog/birthday-invite/) | Alex Ellis | openfaas.com | 12-Dec-2020 |
| [Announcing Venafi Sponsored Apps for Arkade](https://www.openfaas.com/blog/arkade-venafi/) | Alex Ellis | openfaas.com | 08-Dec-2020 |
| [Serverless Node.js that you can run anywhere](https://www.openfaas.com/blog/serverless-nodejs/) | Alex Ellis | openfaas.com | 02-Dec-2020 |
| [Build a Flask microservice with OpenFaaS](https://www.openfaas.com/blog/openfaas-flask/) | Alex Ellis | openfaas.com | 19-Nov-2020 |
| [Web scraping that just works with OpenFaaS with Puppeteer](https://www.openfaas.com/blog/kubernetes-webhooks-made-easy-with-openfaas/) | Alex Ellis | openfaas.com | 28-Oct-2020 |
| [Kubernetes Webhooks made easy with OpenFaaS](https://www.openfaas.com/blog/kubernetes-webhooks-made-easy-with-openfaas/) | Batuhan Apaydın | openfaas.com | 27-Oct-2020 |
| [Build and deploy OpenFaaS functions with GitHub Actions](https://www.openfaas.com/blog/openfaas-functions-with-github-actions/) | Kumar Utsav Anand | openfaas.com | 13-Oct-2020 |
| [New Serverless on Kubernetes Course by the LinuxFoundation](https://www.openfaas.com/blog/introduction-to-serverless-linuxfoundation/) | Alex Ellis | openfaas.com | 16-Sep-2020 |
| [Enable Single Sign-on (SSO) for OpenFaaS with Okta and OpenID Connect](https://www.openfaas.com/blog/openfaas-oidc-okta/) | Alex Ellis | openfaas.com | 16-Sep-2020 |
| [Why did the OpenFaaS community build arkade and what's in it for you?](https://www.openfaas.com/blog/openfaas-arkade/) | Alex Ellis | openfaas.com | 13-Aug-2020 |
| [Bring a lightweight Serverless experience to DigitalOcean with Terraform and faasd](https://www.openfaas.com/blog/faasd-tls-terraform/) | Alex Ellis | openfaas.com | 13-Aug-2020 |
| [Create Serverless Functions with OpenFaaS](https://dev.to/appfleet/create-serverless-functions-with-openfaas-37ob) | Dmitriy Akulov | dev.to | 13-Aug-2020 |
| [Live reload for OpenFaaS functions](https://simonemms.com/blog/2020/08/12/live-reload-for-openfaas/) | Simon Emms | simonemms.com | 12-Aug-2020 |
| [OpenFaaS with TLS via Faasd and Terraform on Openstack](https://markopolo123.github.io/posts/openfaas-openstack/) | Mark Sharpley| markopolo123.github.io | 06-Aug-2020 |
| [Time travelling through your OpenFaaS Function logs](https://www.openfaas.com/blog/openfaas-loki-into/) | Lucas Roesler | openfaas.com | 06-Jul-2020 |
| [Serverless with OpenFaaS – DevOps Series, Part 17](https://blogs.cisco.com/developer/serverless-openfaas-devops-17) | Julio Gomez| blogs.cisco.com | 30-June-2020 |
| [Building serverless Java applications using Micronaut and OpenFaaS](https://openvalue.blog/articles/2020/05/serverless-java-applications.html) | Paulien van Alst | openvalue.blog | 22-June-2020 |
| [OpenFaaS: Serverless platform with no strings attached?](https://speakerdeck.com/andmos/openfaas-serverless-platform-with-no-strings-attached-2b403d2f-bd80-4e6f-b61c-52b8fa1f83fe) | Andreas Mosti | Speakerdeck | 12-Jun-2020 |
| [Running OpenFaaS and MongoDB on Raspbian 64bit](https://dev.to/itzikkotler/running-openfaas-and-mongodb-on-raspbian-64bit-j75) | Itzik Kotler| dev.to | 09-Jun-2020 |
| [Keep your functions running to schedule with the cron-connector](https://www.openfaas.com/blog/schedule-your-functions/) | Martin Dekov | openfaas.com | 27-May-2020 |
| [Using Azure Storage + lowdb and Node.js to manage state in OpenFaaS functions](https://medium.com/@therealburningman/using-azure-storage-lowdb-and-node-js-to-manage-state-in-openfaas-functions-5776f214e84d) | Hans van den Akker | medium.com | 27-May-2020 |
| [Powerful dynamic Email processing using SendGrid, node.JS, OpenFaaS (faasnetes), Azure Service Bus and Microsoft Flow](https://itnext.io/powerful-dynamic-email-processing-using-sendgrid-node-js-52ac68f37eeb) | Hans van den Akker | medium.com | 16-May-2020 |
| [An openFAAS multipart body processing custom language template based on node12 and restify](https://medium.com/@therealburningman/an-openfaas-multipart-body-processing-custom-language-template-based-on-node12-and-restify-7e9e8a78f9be) | Hans van den Akker | medium.com | 15-May-2020 |
| [Create Serverless Functions with OpenFaaS](https://medium.com/appfleet/create-serverless-functions-with-openfaas-1b2ba1dff8cf) | Appfleet Team | medium.com | 14-May-2020 |
| [OpenFaaS, what's it all about?](https://blog.heyal.co.uk/openfaas-whats-it-about/)| Alistair Hey | blog.heyal.co.uk | 12-05-2020 |
| [Self-hosting serverless with OpenFaaS](https://www.mskog.com/posts/self-hosting-serverless-with-openfaas/) | Magnus Skog | mskog.com | 03-May-2020 |
| [Why I Created an OpenFaaS Template for COBOL](https://unnecessary.tech/posts/openfaas-cobol/) | Christopher De Vries | unnecessary.tech | 27-Apr-2020 |
| [Continuous Deployment of your OpenFaaS Cloud](https://www.openfaas.com/blog/continously-deploy-openfaas-cloud/) | Alistair Hey | openfaas.com | 22-Apr-2020 |
| [Cloud Native Tools for Developers Webinar Recap](https://www.openfaas.com/blog/cloud-native-tools-webinar/) | Alistair Hey | openfaas.com | 21-Apr-2020 |
| [Call OpenFaaS Serverless Functions with Gloo API Gateway](https://medium.com/alterway/call-openfaas-serverless-functions-with-gloo-api-gateway-678a00710481?source=rss------kubernetes-5) | Hervé Leclerc | medium.com | 21-Apr-2020 |
| [Data Pipelines with OpenFaas on K3s](https://medium.com/@yoav.nordmann/data-pipelines-with-openfaas-on-k3s-b92e97bc125b) | Yoav Nordmann | medium.com | 19-Apr-2020 |
| [Meet faasd - portable Serverless without the complexity of Kubernetes](https://www.openfaas.com/blog/introducing-faasd/) | Alex Ellis | openfaas.com | 17-Apr-2020 |
| [Gain access to your functions with CORS](https://www.openfaas.com/blog/function-cors/) | Alex Ellis | openfaas.com | 08-Apr-2020 |
| [Tracking Stripe Payments with Slack and faasd](https://myedes.io/stripe-serverless-webhook-faasd/) | Mehdi Yedes | myedes.io | 04-Apr-2020 |
| [Adding Managed Services to Serverless with Crossplane and OpenFaaS](https://www.openfaas.com/blog/managed-services-serverless/) | Dan Mangnum | openfaas.com | 30-Mar-2020 |
|[Building Serverless CRUD services in Go with OpenFaaS, Arkade, MongoDB and k3d](https://dev.to/wingkwong/building-serverless-crud-services-in-go-with-openfaas-arkade-mongodb-and-k3d-1d93) | Wing-Kam Wong | dev.to | 29-Mar-2020 |
|[Raspberry Pi Kubernetes Cluster with OpenFaaS for Serverless Functions](https://www.shogan.co.uk/kubernetes/raspberry-pi-kubernetes-cluster-with-openfaas-for-serverless-functions-part-4/) | Sean Duffy | shogan.co.uk | 24-Mar-2020 |
| [Telar Social one-click setup: OpenFaaS Cloud Community Cluster](https://medium.com/red-gold/telar-social-one-click-setup-openfaas-cloud-community-cluster-68814b3bf47c) | Amir Movahedi | medium.com | 22-Mar-2020
| [OpenFaaS: Send email by a simple web application using Nodemailer](https://medium.com/red-gold/openfaas-send-email-web-application-using-nodemailer-8ec8d8ca714e) | Amir Movahedi | medium.com | 15-Mar-2020
| [Pi & Kubernetes with k3s, k3sup, arkade and OpenFaaS](https://www.youtube.com/watch?v=ZiR3QEfBivk) | DJ Adams | Youtube | 08-Mar-2020
| [Tutorial to get OpenFaas running on top of a Kubernetes cluster on Clear Linux OS](https://docs.01.org/clearlinux/latest/tutorials/openfaas.html) | Clear Linux | docs.01.org | 03-Mar-2020
| [Turn your Raspberry Pi into a serverless platform with faasd](https://myedes.io/serverless-on-raspberrypi/) | Mehdi Yedes | myedes.io | 01-Mar-2020
| [Walk-through — install Kubernetes to your Raspberry Pi in 15 minutes](https://medium.com/@alexellisuk/walk-through-install-kubernetes-to-your-raspberry-pi-in-15-minutes-84a8492dc95a) | Alex Ellis | medium.com | 01-Mar-2020 |
| [arkade by example — Kubernetes apps, the easy way](https://medium.com/@alexellisuk/kubernetes-apps-the-easy-way-f06d9e5cad3c) | Alex Ellis | medium.com | 01-Mar-2020 |
| [Introducing Arkade - The Kubernetes app installer](https://blog.heyal.co.uk/introducing-arkade/) | Alistair Hey | blog.heyal.co.uk | 28-Feb-2020 |
| [Running Faasd in LXC](https://dukemon.leetserve.com/posts/2020/02/faasd-in-lxc/) | Gabriel Duke | dukemon.leetserve.com | 28-Feb-2020 |
| [Create your own private cloud with OpenFaaS Cloud](https://www.openfaas.com/blog/ofc-private-cloud/) | Alex Ellis | openfaas.com | 27-Feb-2020 |
| [OpenFaaS comes to k9s, the Kubernetes CUI](https://blog.alexellis.io/k9s-the-kubernetes-cui-comes-to-openfaas/) | Alex Ellis | alexellis.io | 14-Feb-2020 |
| [New OpenFaaS SWAG store launched and Insiders Subscription](https://www.openfaas.com/blog/swag-store-launch/) | Alex Ellis | openfaas.com | 14-Feb-2020 |
| [Get storage for your functions with Python and MongoDB](https://www.openfaas.com/blog/get-started-with-python-mongo/) | Alex Ellis | openfaas.com | 12-Feb-2020 |
| [Build a Serverless appliance with faasd](https://blog.alexellis.io/deploy-serverless-faasd-with-cloud-init/) | Alex Ellis | alexellis.io | 06-Feb-2020 |
| [Get started with Java 11 and Vert.x on Kubernetes with OpenFaaS](https://www.openfaas.com/blog/get-started-with-java-openjdk11/) | Alex Ellis | openfaas.com | 30-Jan-2020 |
| [Painless Serverless Development with Kubernetes, OpenFaaS and Okteto](https://www.openfaas.com/blog/painless-serverless-development/) | Ramiro Berrelleza | openfaas.com | 24-Jan-2020 |
| [Introduction to OpenFaaS: Serverless made accessible](https://www.objectif-libre.com/en/blog/2020/01/17/openfaas-made-accessible/) | Florian Davasse | www.objectif-libre.com | 17-Jan-2020|
| [Applying GitOps to OpenFaaS with Flux Helm Operator](https://www.openfaas.com/blog/openfaas-flux/) | Stefan Prodan | openfaas.com| 16-Jan-2020|
| [OpenFaaS 3rd Birthday Celebrations](https://www.openfaas.com/blog/birthday-teamserverless/) | Alex Ellis | openfaas.com| 14-Jan-2020|
| [How To Get Started Contributing to OpenFaaS](https://blog.heyal.co.uk/developing-openfaas/)| Alistair Hey | blog.heyal.co.uk| 04-Jan-2020 |

### 2019

#### Events in 2019

[Back to top](#openfaas-community)

| Event name and description                                          | Speaker      | Location | Date        |
|---------------------------------------------------------------------|--------------|----------|-------------|
| [faasd - lightweight Serverless for your Raspberry Pi](https://blog.alexellis.io/faasd-for-lightweight-serverless/) | Alex Ellis | alexellis.io | 30-Dec-2020 |
| [OpenFaaS Community Call - December OpenFaaS is 3!](https://www.youtube.com/watch?v=wXnYx-wD4Zk) | Various | Online webinar | 18-Dec-2019 |
| [The RISC V Journey Through Containers to the Cloud @ RISC-V Summit 2019](https://www.youtube.com/watch?v=AX4bx03D3RQ) | Carlos Eduardo de Paula | San Jose, USA | 10-Dec-2019 |
| [OpenFaaS Cloud + Linkerd: A Secure, Multi-Tenant Serverless Platform @ KubeCon 2019, 3:20pm](https://kccncna19.sched.com/event/Uabn/openfaas-cloud-linkerd-a-secure-multi-tenant-serverless-platform-charles-pretzer-buoyant-alex-ellis-openfaas-ltd) | Charles Pretzer & Alex Ellis | San Diego, USA | 20-Nov-2019 |
| [How we moved from JIRA to GitHub for fun and profit using Serverless @ Goto](https://gotocph.com/2019/sessions/1016) | Edward Wilde | Copenhagen, Denmark | 19-Nov-2019 |
| [Painless Serverless Function Development In Kubernetes - Serverless Summit @ KubeCon, 1.20pm](https://spsna19.sched.com/event/Wb2t/painless-serverless-function-development-in-kubernetes-ramiro-berrelleza-okteto) | Ramiro Berrelleza | San Diego, USA | 18-Nov-2019 |
| [Getting Beyond FaaS: The PLONK Stack for Kubernetes Developers - Serverless Summit @ KubeCon, 11.20am](https://spsna19.sched.com/event/Wb2n/getting-beyond-faas-the-plonk-stack-for-kubernetes-developers-alex-ellis-openfaas-ltd) | Alex Ellis | San Diego, USA | 18-Nov-2019 |
| [Emerging Technology Meetup Surat - OpenFass + Laravel + GraphQL](https://www.meetup.com/Surat-Emerging-technology-Community/events/265866420/) | Tarun Mangukiya | Surat, India | 16-Nov-2019 |
| [Still waiting for IPv6? Get ingress to any Kubernetes cluster with inlets, 4.30pm](https://cfp.cloud-native.rejekts.io/cloud-native-rejekts-na-2019/talk/377BS9/) | Alex Ellis | San Diego | 16-Nov-2019 |
| ["If This Then That" for vSphere - The Power of Event-Driven Automation (CODE1379E) @ VMworld Europe](https://videos.vmworld.com/global/2019?q=CODE1379E) | William Lam & Michael Gasch | Barcelona, Spain | 7-Nov-2019 |
| [Get started with PLONK: the Stack for Cloud Native Developers @ Serverless Computing London, 2.00pm](https://serverlesscomputing.london/sessions/get-started-with-plonk-the-stack-for-cloud-native-developers/) | Alex Ellis | London, UK | 6-Nov-2019 |
| [Déployer Webapp/µServices/Functions sur OpenFaaS avec GitLab CI ... en local 😱](https://www.meetup.com/fr-FR/AlpesJUG/events/265653698) | Philippe Charrière | Grenoble, France | 24-Oct-2019 |
| [PLONK Stack - Prometheus, Linkerd, OpenFaaS, NATS, and Kubernetes @ Goto Berlin](https://gotober.com/2019/sessions/971) | Alex Ellis | Berlin, Germany | 23-Oct-2019 |
| [Deploying Function and Microservices with OpenFaaS](https://www.meetup.com/Golang-Houston/events/265463301/) | Michael and David M. | Houston, USA | 17-Oct-2019 |
| [Serverless with OpenFaaS and Python](https://in.pycon.org/cfp/workshops-2019/proposals/serverless-with-openfaas-and-python~aAkBd/) | Vivek Singh & Farhan Khan | PyCon India 2019 @ Chennai, IN | 14-Oct-2019 |
| [Serverless 2.0: Get Started With The PLONK Stack](https://skillsmatter.com/conferences/11723-cloudnative-london-2019#program) | Alex Ellis | London, UK | 27-Sept-2019 |
| [Serverless and the road to portability](https://techin.finance/featured-speaker-edward-wilde/) | Edward Wilde | Malaga, Spain | 20-Sept-2019 |
| [OpenFaaS Bangalore meetup](https://www.meetup.com/OpenFaaS-Community/events/264414959/) | Various | Bangalore, India | 14-Sept-2019 |
| [OpenFaaS Community Call - August](https://www.youtube.com/watch?v=hhlqA78V8Jo) | Various | Online webinar | 02-Aug-2019 |
| [Chicago Kubernetes Meetup: Going Serverless w/OpenFaaS + K8s Networking Revealed](https://www.meetup.com/Chicago-Kubernetes/events/262973241) | Saba Jamalian | Chicago, USA | 24-Jul-2019 |
| [Serverless Week](https://slsweek.netlify.com) | Several | Online, Brazil | 22-Jul-2019 to 26-Jul-2019 |
| [Unlocking your serverless functions with OpenFaaS for AI chatbot projects](https://conferences.oreilly.com/oscon/oscon-or-2019/public/schedule/detail/76105) | Sergio Méndez @sergioarmgpl | OSCON, Portland Oregon | 17-Jul-2019 |
| [Cloud Native Edinburgh](https://www.slideshare.net/mobile/KeiranSmith4/open-faas-and-linkerd) | Keiran Smith (@CLI) | Edinburgh Scotland | 16-Jul-2019 |
| [Serverless con OpenFaaS Y Java](https://bit.ly/35tKCDA) | Carlos Camacho | JConf Colombia, Medellin, Colombia | 06-Jul-2019 |
| [Deploying Go Functions @ GoWayFest](https://goway.io) | Julien Bisconti | Minsk, Belarus | 05-Jul-2019 |
| [Serverless Functions Frameworks : OpenFaaS Day](https://www.meetup.com/Cloud-Native-Computing-Belo-Horizonte/events/262673508/) | Marcelo Umberto and Jefferson Otoni Lima | Belo Horizonte, Brazil | 04-Jul-2019 |
| [Serverless con OpenFaaS Y Java](https://bit.ly/3fcpSoe) | Carlos Camacho | JConf Dominicana, Santiago, Dominican Republic | 29-Jun-2019 |
| [ContainerDays EU: Kubernetes and AWS Lambda can play nicely together with OpenFaaS](https://www.containerdays.io/program/) | Edward Wilde | ContainerDays | 25-June-2019 |
| [Blockchain as a Service at Scale](https://devweeksea2019.sched.com/event/PVpz) | Dean Shelton | Seattle, USA | 31-May-2019 |
| [OpenFaaS - mit Docker einfach Serverless](https://www.xing.com/events/openfaas-docker-einfach-serverless-2104708) | Frank Pommerening | Ratingen, Germany | 29-May-2019 |
| [OpenFaaS - mit Docker einfach Serverless](https://www.meetup.com/de-DE/Koblenz-NET-Meetup/events/260738278/) | Frank Pommerening | Koblenz, Germany | 27-May-2019 |
| [OpenFaaS in-person workshop](https://events.opensuse.org/conferences/oSC19/program/proposals/2576) | Ferenc Szekely | @openSUSE Conference | 25-May-2019 |
| [Knative, OpenFaaS, Kubeless : la guerre des frameworks serverless est lancée !](https://mixitconf.org/)  | Laurent Grangeau | Lyon, France | 24-May-2019 |
| [How LivePerson is Tailoring its Conversational Platform Using OpenFaaS - Simon Pelczer, LivePerson](https://kccnceu19.sched.com/event/MPeR/how-liveperson-is-tailoring-its-conversational-platform-using-openfaas-simon-pelczer-liveperson-ivana-yovcheva-vmware) | Simon Pelczer & Ivana Yovcheva | KubeCon, Barcelona EU | 23-May-2019 |
| [Merging Quickly in a Cloud Native World](https://kccnceu19.sched.com/event/MPZM/merging-quickly-in-a-cloud-native-world-lucas-roesler-contiamo) | Lucas Roesler | KubeCon, Barcelona EU | 22-May-2019 |
| [Accelerating the Journey of an AI Algorithm to Production with OpenFaaS - Joost Noppen, BT PLC & Alex Ellis](https://kccnceu19.sched.com/event/MPeF/accelerating-the-journey-of-an-ai-algorithm-to-production-with-openfaas-joost-noppen-bt-plc-alex-ellis-vmware) | Joost Noppen & Alex Ellis | KubeCon, Barcelona EU | 22-May-2019 |
| [OpenFaaS Birds of a Feather Session](https://spseu19.sched.com/event/Nq5C/bof-open-faas) | Alex Ellis et al. | Serverless Practitioners Summit/KubeCon | 20-May-2019 |
| [Kubernetes and AWS Lambda can play nicely together with OpenFaaS](https://spseu19.sched.com/event/Nq4u/kubernetes-and-aws-lambda-can-play-nicely-together-with-openfaas) | Edward Wilde | Serverless Practitioners Summit/KubeCon | 20-May-2019 |
| [A bright 2019 for OpenFaaS - project & community updates](https://spseu19.sched.com/event/Nq4i/a-bright-2019-for-openfaas-project-community-updates) | Alex Ellis | Serverless Practitioners Summit/KubeCon | 20-May-2019 |
| [Going Serverless with Spotinst Ocean and OpenFaas Cloud](https://hubs.ly/H0hL-Zx0) @ 5pm BST | Alex Ellis / Tsahi Duek | Free Webinar | 15-May-2019 |
| [DataScience as a Service](https://teqnation.nl/sessions/datascience-as-a-service/)  | Arno Broekhof | TEQnation, Netherlands EU | 15-May-2019 |
| [Docker Birmingham: Staying on topic - Invoke your OpenFaaS functions through Kafka](https://www.meetup.com/Docker-Birmingham/events/260563667/?_xtd=gqFyqTI2MjQ0NTE2NKFwp2FuZHJvaWQ&from=ref) | Richard Gee | Birmingham, UK | 7-May-2019 |
| [Jax - Serverless and Functions as a Service mit Java, Docker und OpenFaaS](https://jax.de/cloud-container-serverless/serverless-und-functions-as-a-service-mit-java-docker-und-openfaas/) | Dr. Halil-Cem Gürsoy | Mainz, Germany | 6-May-2019 |
| [Dockercon OSS Summit: Serverless](https://www.docker.com/dockercon/agenda/opensource/) | Burton Rheutan & Pav Jimanov | Dockercon, San Fracisco CA | 2-May-2019 |
| [PHP Shropshire: Staying on topic - Invoke your OpenFaaS functions through Kafka](https://www.meetup.com/PHP-Shropshire/events/260591121/) | Richard Gee | Telford, UK | 2-May-2019 |
| [goto Chicago masterclass: Serverless Kubernetes with OpenFaaS](https://gotochgo.com/2019/workshops/152) | Alex Ellis & Edward Wilde | Chicago, USA | 1-May-2019 |
| [goto Chicago masterclass: Use Terraform to Scale your Team](https://gotochgo.com/2019/sessions/859) | Edward Wilde | Chicago, USA |  30-Apr-2019 |
| [goto Chicago session: Welcome to Serverless 2.0](https://gotochgo.com/2019/sessions/728) | Alex Ellis | Chicago, USA | 30-Apr-2019 |
| [Knative vs. OpenFaaS: Functions on Kubernetes](https://tmt.knect365.com/container-world/agenda/1#serverless-summit_knative-vs-openfaas-functions-on-kubernetes) | Carson Anderson | ContainerWorld | 17-Apr-2019 |
| [IT Depends #1: Google Cloud na produkcji i serverless z OpenFaaS](https://www.meetup.com/meetup-group-zhlFJrTR/events/260534334/) | Sebastian Woldański | Katowice, Poland | 17-Apr-2019 |
| [BelFOSS 2019: OpenFaaS - Keeping Serverless Simple](https://belfoss.eeecs.qub.ac.uk/agenda/) | John McCabe | Belfast, Northern Ireland | 12-Apr-2019 |
| [Coworking Monterrey: Lightning Talks and Serverless Functions with OpenFaaS](https://www.facebook.com/events/546729195736337/) | Ernesto Celis | Monterrey, Nuevo León, México | 12-Apr-2019 |
| [Serverless Architecture Conf: OpenFaaS - Keeping Serverless Simple](https://serverless-architecture.io/serverless-platforms-technology) | John McCabe | The Hague, Netherlands | 9-Apr-2019 |
| [Microservices North meetup: Kubernetes and AWS Lambda: OpenFaas Demo](https://www.meetup.com/Microservices-North/events/259957002/) | Edward Wilde | London, UK | 4-Apr-2019 |
| [OpenFaaS in the VMware ecosystem - Webinar](https://www.terasky.com/news/openfaas-in-the-vmware-ecosystem-webinar-april-3rd-2019/) | Scott Rosenberg | Online webinar | 3-Apr-2019 |
| [Open Infrastructure Days UK 2019: Kubernetes and AWS Lambda can play nicely together](https://sched.co/MASC) | Edward Wilde | London, UK | 1-Apr-2019 |
| [SFEIR Lunch #6](https://www.eventbrite.fr/e/billets-sfeir-lunch-6-58291769251) | Emmanuel Lebeaupin, Patrice De Saint Steban | Nantes, France | 26-March-2019 |
| [Soirée OpenFaas et Firebase](https://www.meetup.com/fr-FR/GDG-Lille/events/258241972/?isFirstPublish=true)| Laurent Grangeau | Lille, France | 31-Jan-2019 |
| UCL (University College London) professional practice talks: Serverless evolution with OpenFaaS | Edward Wilde | London, UK | 31-Jan-2019 |
| [PythonPy Meetup Enero 2019](https://www.meetup.com/es-ES/Python-Paraguay/events/258171808) | Patricio Diaz | Asuncion, PY | 24-Jan-2019 |
| [Docker and serverless: meetup](https://events.docker.com/events/details/docker-randstad-presents-docker-and-serverless/#/) | Edward Wilde | Utrecht, Netherlands | 24-Jan-2019 |
| Docker Paraguay Meetup Enero 2019 | Patricio Diaz | Asuncion, PY | 04-Jan-2019 |

#### Blog posts and write-ups 2019
[Back to top](#openfaas-community)

| Blog/repo name and description                                          | Author       | Site     | Date        |
|-------------------------------------------------------------------------|--------------|----------|-------------|
| [faasd - lightweight Serverless for your Raspberry Pi](https://blog.alexellis.io/faasd-for-lightweight-serverless/)| Alex Ellis | blog.alexellis.io | 30-Dec-2019 |
| [My 2019 in review - Hello Open Source!](https://blog.heyal.co.uk/My-2019/)| Alistair Hey | blog.heyal.co.uk| 30-Dec-2019 |
| [OpenFAAS via Containerd on a Raspberry PI 4](https://markopolo123.github.io/posts/pi4-containerd-openfaas/) | Mark Sharpley| markopolo123.github.io | 20-Dec-2019 |
| [Nodeless OpenFaaS with AWS EKS and Fargate](https://blog.alexellis.io/nodeless-openfaas-with-aws-eks-and-fargate/) | Alex Ellis | alexellis.io | 05-Dec-2019 |
| [Build a CRUD API with Postgresql and Node.js With OpenFaaS](https://www.civo.com/learn/guide-to-build-a-crud-api-with-postgresl-and-node-js-with-openfaas)| Alex Ellis | www.civo.com | 19-Dec-2019 |
| [Build ASP.NET Core APIs with Kubernetes and OpenFaaS](https://www.openfaas.com/blog/asp-net-core/)| Alex Ellis | www.openfaas.com| 03-Dec-2019 |
| [Going Serverless with OpenFaaS and Golang - Building Optimized Templates](https://martinheinz.dev/blog/11) | Martin Heinz | martinheinz.dev | 29-Nov-2019 |
| [Serverless Kotlin with OpenFaaS](https://kotlinexpertise.com/serverless-kotlin/) | Simon Wirtz | kotlinexpertise.com | 21-Nov-2019 |
| [Going Serverless with OpenFaaS and Golang - The Ultimate Setup and Workflow](https://martinheinz.dev/blog/10) | Martin Heinz | martinheinz.dev | 16-Nov-2019 |
| [Migrate your AWS Node.js Lambda Function to OpenFaaS](https://sysadmins.co.za/migrate-your-aws-node-js-lambda-function-to-openfaas/) | Ruan Bekker | sysadmins.co.za | 09-Oct-2019 |
| [Migrate Your AWS Lambda Functions to Kubernetes with OpenFaaS](https://www.openfaas.com/blog/lambda-to-openfaas/) | Burton Rheutan | openfaas.com | 8-Oct-2019 |
| [FaaS for the Rubyist](https://blog.alexellis.io/faas-for-the-rubyist/) | Alex Ellis | alexellis.io | 2-Oct-2019 |
| [Video: Serverless 2.0: Get Started With The PLONK Stack](https://skillsmatter.com/skillscasts/14268-serverless-2-0-get-started-with-the-plonk-stack) | Alex Ellis | skillsmatter.com | 1-Oct-2019 |
| [Getting Started with OpenFaaS and the OpenFaaS Community Cluster](https://mickey.dev/posts/getting-started-with-openfaas/) | [Josh Michielsen](https://twitter.com/jmickey_) | mickey.dev | 30-Sept-2019 |
| [Action Packed Functions](https://lucasroesler.com/2019/09/action-packed-functions/) | Lucas Roesler| lucasroesler.com| 28-Sept-2019 |
| [Functions 101 - SOSC2019](https://cloud-pg.github.io/SOSC2019/events/) | Diego Ciangottini | cloud-pg.github.io | 20-Sep-2019 |
| [Mail from Slack by OpenFaaS Cloud](https://medium.com/red-gold/mail-from-slack-by-openfaas-6eeee2228cec) | Amir Movahedi | medium.com | 31-Aug-2019 |
| [Deploying Machine Learning models with OpenFaaS with Warm Start](https://medium.com/@dwipam.katariya/deploying-machine-learning-models-with-openfaas-857f1ba0e9c2) | Dwipam Katariya | medium.com | 16-Aug-2019 |
| [How to Develop a Serverless App with OpenFaaS and Okteto](https://medium.com/okteto/how-to-develop-a-serverless-app-with-openfaas-and-okteto-d85435f0eca1) | Ramiro Berrelleza | medium.com | 13-Aug-2019 |
| [Building your own serverless functions with k3s and OpenFaaS on Raspberry Pi](https://blog.codecentric.de/en/2019/08/serverless-functions-k3s-openfaas-raspberry-pi/) | Andreas Muttscheller | codecentric.de | 07-Aug-2019 |
| [OpenFaaS Creator on Open Source’s Community-Funding Model](https://thenewstack.io/openfaas-creator-on-open-sources-community-funding-model/) | The New Stack | thenewstack.io | 11-Jul-2009 |
| [On-premises Serverless Computing for Event-Driven Data Processing Applications](https://www.grycap.upv.es/gmolto/publications/b2hd-Perez2019osc.html) | Alfonso Pérez | grycap.upv.es | 09-Jul-2019 |
| [OpenFaaS multi-stage with Istio on Kubernetes](https://medium.com/@qolzam/openfaas-multi-stage-with-istio-on-kubernetes-bf184d3b6955) | Amir Movahedi | medium.com | 27-June-2019 |
| [Running GBFS bikeshare functions with OpenFaaS for fun and profit](http://blog.amosti.net/running-gbfs-bikeshare-functions-with-openfaas-for-fun-and-profit/) | Andreas Mosti | blog.amosti.net | 04-June-2019 |
| [Deploying a FaaS platform on OVH Managed Kubernetes using OpenFaaS](https://www.ovh.com/fr/blog/deploying-a-faas-platform-on-ovh-managed-kubernetes-using-openfaas/) | Horacio Gonzalez | ovh.com | 24-May-2019 |
| [Serverless Functions, Made Simple with OpenFaaS](https://www.roncrivera.io/post/serverless-functions-made-simple-with-openfaas/) | Ron Rivera | www.roncrivera.io | 15-May-2019 |
| [Openfaas K3s Appliance](https://github.com/cloudnautique/k3d-openfaas-example) | Bill Maxwell | https://github.com/cloudnautique | 13-May-2019 |
| [Creating a simple OpenFaaS template](https://blogs.4dotnet.nl/creating-a-simple-openfaas-template/) | Erwin Staal | blogs.4dotnet.nl | 11-May-2019 |
| [Meet us at KubeCon 2019, Barcelona](https://www.openfaas.com/blog/meet-us-at-barcelona/) | Alex Ellis | openfaas.com | 10-May-2019 |
| [Your first .NET Core Serverless function on OpenFaas](https://blogs.4dotnet.nl/your-first-net-core-serverless-function-on-openfaas/) | Erwin Staal | blogs.4dotnet.nl | 8-May-2019 |
| [code.talks commerce 2019 - Serverless with OpenFaaS - Live Example](https://www.youtube.com/watch?v=iWt9z1Myrsc) | Lars Rieche | youtube.com | 2-May-2019 |
| [Dockercon 19 Open Source Summit: Serverless](https://www.youtube.com/watch?v=zeXWPV09QTs) | Burton Rheutan & Pav Jimanov | youtube.com | 2-May-2019 |
| [Handling Oracle Code Card using Python on OpenFaaS](https://blog.kube-mesh.io/handling-oracle-code-card-using-python-on-openfaas/) | Prasenjit Sarkar | blog.kube-mesh.io | 2-May-2019 |
| [Oracle Code Card met OpenFaaS](https://blog.kube-mesh.io/oracle-code-card-met-openfaas/) | Prasenjit Sarkar | blog.kube-mesh.io | 1-May-2019 |
| [Get to grips with Serverless Kubernetes this Spring](https://www.openfaas.com/blog/spring-easter/) | Alex Ellis | openfaas.com | 18-Apr-2019 |
| [Ansible configuration to setup a k3s cluster](https://github.com/FlorentClarret/pi-k3s-cluster) | Florent Clarret | https://github.com/FlorentClarret | 16-Apr-2019 |
| [Simple Serverless with Golang Functions and Microservices](https://www.openfaas.com/blog/golang-serverless/) | Alex Ellis | openfaas.com | 10-Apr-2019 |
| [Run your OpenFaaS Functions on Google Cloud Run for free](https://www.openfaas.com/blog/openfaas-cloudrun/) | Alex Ellis | openfaas.com | 9-Apr-2019 |
| [Deep Learning as a function](https://github.com/yogeek/deeplearning-as-a-function) | Guillaume Dupin | https://github.com/yogeek | 6-Apr-2019 |
| [Introducing OpenFaaS Cloud with GitLab](https://www.openfaas.com/blog/openfaas-cloud-gitlab/) | Alex Ellis | openfaas.com | 28-Mar-2019 |
| [Install OpenShift & OpenFaaS in a container with Weave Footloose](https://blog.alexellis.io/openshift-in-a-footloose-container/) | Alex Ellis | alexellis.io | 27-Mar-2019 |
| [Sailing Through the Serverless Ocean with OpenFaaS Cloud](https://spotinst.com/blog/2019/03/25/sailing-through-the-serverless-ocean-with-openfaas-cloud/) | Pavel Klushin | spotinst.com | 25-Mar-2019 |
| [Hello OpenFaas](https://edwardspc.github.io/blog/hello-openfaas) | Edward Pacheco | https://edwardspc.github.io | 20-Mar-2019 |
| [Writing a face detection function for OpenFaaS](https://blog.matiaspan.dev/posts/writing-a-face-detection-function-for-openfaas/) | Matias Pan | blog.matiaspan.dev | 16-Mar-2019 |
| [Process Google Forms Responses with OpenFaaS](https://www.openfaas.com/blog/google-form-response/) | Burton Rheutan | openfaas.com | 06-Mar-2019 |
| [Node Gatekeeper - a HMAC wrapper for Node.js](https://github.com/cabrerabywaters/faas-node-gatekeeper) | Ignacio Cabrera | github.com | 28-Feb-2019 |
| [Favorite Tools - OpenFaaS](https://fischbacher.rocks/post/tools-openfaas/) | Markus Fischbacher | [fischbacher.rocks](fischbacher.rocks) | 5-Mar-2019 |
| [Serverless with OpenFaaS](https://blog.cloudstack.pl/serverless-with-openfaas/) | Daniel Noworyta | blog.cloudstack.pl | 5-Mar-2019 |
| [Experimenting with OpenFaaS](https://brandnameboredom.github.io/openfaas/2019/03/04/openfaas.html) | Brad Turner | https://brandnameboredom.github.io | 4-Mar-2019 |
| [OpenFaaS on Docker Swarm on Raspberry Pi](http://www.timlevett.com/2019/03/openfaas-on-docker-swarm-on-raspberry-pi.html) | Tim Levett | timlevett.com | 4-Mar-2019  |
| [Build your serverless functions with OpenFaaS on Azure](https://sajeetharan.com/2019/03/03/openfaas-revolution-is-here/) | Sajeetharan Sinnathurai | sajeetharan.com | 3-Mar-2019 |
| [Artifactory and OpenFaaS – Containers Everywhere!](https://jfrog.com/blog/artifactory-and-openfaas-containers-everywhere/) | Leon Stigter | jfrog.com | 19-Feb-2019 |
| [How to build a Serverless Single Page App](https://www.openfaas.com/blog/serverless-single-page-app/) | Alex Ellis | openfaas.com | 14-Feb-2019 |
| [FaaS comes to Fargate: OpenFaaS with AWS Fargate](https://www.openfaas.com/blog/openfaas-on-fargate/) | Edward Wilde | openfaas.com | 12-Feb-2019 |
| [My five highlights of working on OpenFaaS](https://medium.com/@ivana.yovcheva/my-five-highlights-of-working-on-openfaas-210f88d0c4da) | Ivana Yovcheva | medium.com | 8-Feb-2019 |
| [How to resize your images on-the-fly with OpenFaaS](https://www.openfaas.com/blog/resize-images-on-the-fly/) | Tarun Mangukiya | openfaas.com | 08-Feb-2019 |
| [Event-driven interactions with vSphere using Functions as a Service](https://rguske.github.io/post/event-driven-interactions-with-vsphere-using-functions-as-a-service/) | Robert Guske | github.io | 05-Feb-2019 |
| [Ride the Serverless Wave with DigitalOcean's One-click Droplet](https://www.openfaas.com/blog/digitalocean-one-click/) | Richard Gee | openfaas.com | 31-Jan-2019 |
| [OpenFaaS Cloud in 100 seconds (ofc-bootstrap)](https://www.youtube.com/watch?v=Sa1VBSfVpK0&index=21&list=PLlIapFDp305DiIRhJFNzMuJXoBnzKdtpi) | Alex ellis | youtube.com | 31-Jan-2019 |
| [How to split large Python Functions across multiple files](https://www.openfaas.com/blog/multifile-python-functions/) | Lucas Roesler | openfaas.com | 29-Jan-2019 |
| [Unifying Secrets for OpenFaaS](https://www.openfaas.com/blog/unified-secrets/) | Alex Ellis | openfaas.com | 24-Jan-2019 |
| [Introducing the OpenFaaS Clojure Template](http://www.tessellator.net/2019-01-25-introducing-openfaas-clojure-template/) | Chad Taylor | tessellator.net | 25-Jan-2019 |
| [Evaluation of Serverless Technologies at Jet](https://medium.com/jettech/evaluation-of-serverless-technologies-at-jet-f40af12a1c39) | Khalid Hasanov |  medium.com | 21-Jan-2019 |
| [Get Started with the Kubernetes Python Client on OpenFaaS ](https://medium.com/@turcios.kevinj/get-started-with-the-kubernetes-python-client-on-openfaas-d5a8eb2f3eca) | Kevin Turcios | medium.com | 18-Jan-2019 |
| [Awesomify anything or anyone with OpenFaaS!](https://medium.com/@diddledan/awesomify-anything-or-anyone-with-openfaas-6cb95512be9a) | Daniel Llewellyn | bowlhat.net | 17-Jan-2019 |
| [Serverless sur Raspberry PI avec Docker Swarm et OpenFaas](https://blog.ineat-conseil.fr/2019/01/serverless-sur-raspberry-pi-avec-docker-swarm-et-openfaas-partie-1-installation-dopenfaas/) | Mathias Deremer-Accettone | blog.ineat-conseil.fr | 15-Jan-2019 |
| [Making Legacy Legendary - A Windows 2003 Application Journey to the Cloud](https://youtu.be/I_vq5xuN41I?t=1454)| Indy Bains & Arthur Entwistle | DockerCon 18 Europe | 10-Jan-2019 |
| [Get Started with OpenFaaS and KinD](https://blog.alexellis.io/get-started-with-openfaas-and-kind/) | Alex Ellis | alexellis.io | 10-Jan-2019 |
| [Transmute launches blockchain decentralised app engine using OpenFaaS](https://www.enterprisetimes.co.uk/2019/01/09/transmute-launches-blockchain-decentralised-app-engine/) | Charles Brett | enterprisetimes.co.uk | 09-Jan-2019 |
| [Serverless Panel Dockercon 2018](https://youtu.be/qtlMw8bJPuE?t=583) | Alex Ellis | youtube.com | 05-Jan-2019 |
| [Bash Functions as a Service](https://medium.com/@thomas.shaw78/bash-functions-as-a-service-b4033bc1ee97) | Thomas Shaw | medium.com | 02-Jan-2019 |
| [Deploy OpenFaaS with MicroK8s](https://johnmccabe.net/technology/projects/openfaas-on-microk8s/) | John McCabe | johnmccabe.net | 01-Jan-2019 |
| [4 Top Technology Predictions for 2019](https://medium.com/@filipSk/4-top-technology-predictions-for-2019-c9ddc9c345bd) | Filip Cieker | medium.com | 01-Jan-2019 |

### 2018

#### Events in 2018
[Back to top](#openfaas-community)

| Event name and description                                          | Speaker      | Location | Date        |
|---------------------------------------------------------------------|--------------|----------|-------------|
| [Not so FaaS, Hacker](https://www.brighttalk.com/webinar/no-so-faas-hacker/) | Aaron Weaver | Webinar | 21-Feb-2019 |
| [Serverless, KubeCon and Kubernetes the easy way](https://www.meetup.com/Cloud-Native-Computing-Paris/events/257113168/) | Edward Wilde | Paris | 19-Dec-2018 |
| [KubeCon + CloudNativeCon: Digital Transformation of Vision Banco Paraguay with Serverless Functions](https://sched.co/GraO) | Alex Ellis & Patricio Diaz | Seattle, WA | 13-Dec-2018 |
| [Serverless com OpenFaaS e PHP @ PHP Conference Brazil](https://phpconference.com.br) | Fernando Silva | Porto Alegre, BR | 07-Dec-2018 |
| [Serverless - czy faktycznie chodzi serwery?](https://www.meetup.com/C_tech-Wrocław/events/256740066) | Bart Smykla | Wrocław, Poland | 04-Dec-2018 |
| [OpenFaaS - Jak to się je?](https://www.meetup.com/Serverless-Wroclaw/events/256599672/) | Bart Smykla | Wrocław, Poland | 03-Dec-2018 |
| [The FaaS & The Furious](https://www.meetup.com/CloudAustin/events/gxwbkpyxpbbc/) | Burton Rheutan | Austin, TX | 27-Nov-2018 |
| [GOTO Copenhagen: Serverless Beyond the Hype](https://gotocph.com/2018/sessions/592) | Alex Ellis | Copenhagen, DK | 19-Nov-2018 |
| [OpenFaaS workshop @ Capitole du Libre](https://2018.capitoledulibre.org/) | [Laurent Grangeau](https://twitter.com/laurentgrangeau) <br /> [Adrien Blind](https://twitter.com/adrienBlind) <br /> [Ludovic Piot](https://twitter.com/lpiot)| Toulouse, France | 18-Nov-2018 |
| [OpenFaas on Kubernetes](https://www.meetup.com/kubernetes-openshift-India-Meetup/events/255794614) | Vivek Singh| Bangalore, IN | 17-Nov-2018 |
| [🚀 2+ years of feedback @ Capitole du Libre](https://2018.capitoledulibre.org/) | [Laurent Grangeau](https://twitter.com/laurentgrangeau) <br /> [Adrien Blind](https://twitter.com/adrienBlind) <br /> [Ludovic Piot](https://twitter.com/lpiot) | Toulouse, France | 17-Nov-2018 |
| [Functions as a Service - The Easy Way](https://www.istacon.org) | [Ivana Yovcheva](https://twitter.com/ivanabyov) | Sofia, Bulgaria | 15-Nov-2018 |
| [OpenFaaS : a serverless framework on top of Docker and Kubernetes @ DevOpsDDay](https://2018.devops-dday.com/) | [Laurent Grangeau](https://twitter.com/laurentgrangeau) | Marseille, France | 15-Nov-2018 |
| [ Serverless Computing London: Why Kubernetes is the right place for your functions](http://serverless2018.wpengine.com/sessions/kubernetes-right-place-functions/) | Bart Smykla | London, UK | 13-Nov-2018 |
| [ Serverless Computing London: FaaS and Furious – 0 to Serverless in 60 Seconds, Anywhere](https://serverlesscomputing.london/sessions/faas-furious-0-serverless-60-seconds-anywhere/) | Alex Ellis | London, UK | 12-Nov-2018 |
| [Open Source Summit Europe: Introducing OpenFaaS Cloud, a Developer-Friendly CI/CD Pipeline for Serverless](https://osseu18.sched.com/event/FxXx/introducing-openfaas-cloud-a-developer-friendly-cicd-pipeline-for-serverless-alex-ellis-openfaas-project-vmware) | Alex Ellis | Edinburgh, Scotland | 22-Oct-2018 |
| Exploring the serverless framework with OpenFaaS @ DevFest Nantes | [Emmanuel Lebeaupin](https://twitter.com/elebeaup) | Nantes, France | 19-Oct-2018 |
| [OpenFaaS Tutorial: Build and Deploy Serverless Java Functions](https://www.upnxtblog.com/index.php/2018/10/19/openfaas-tutorial-build-and-deploy-serverless-java-functions/) | [Karthikeyan Shanmugam](https://twitter.com/karthi4india) | Chennai, India | 19-Oct-2018 |
| [Serverlessconf Tokyo 2018 Contributor Day](https://serverless.connpass.com/event/103404/) | Ken Fukuyama | Tokyo, JP | 13-Oct-2018 |
| [DevOpenSpace - Mühelos Serverless mit GitOps](https://github.com/fpommerening/DevOpenSpace2018) | Frank Pommerening | Leipzig, Germany | 12-Oct-2018 |
| [ScotlandPHP - Starting your Serverless Journey with OpenFaaS](https://conference.scotlandphp.co.uk/) | John McCabe | Edinburgh, Scotland | 6-Oct-2018 |
| [VMUG Ireland - Serverless, OpenFaaS and GitOps on Kubernetes](https://community.vmug.com/events/event-description?CalendarEventKey=081889a6-3ea0-451b-b5df-e3985fbe8256&CommunityKey=8c80c6de-4f79-4717-b7d1-55a43ba44624) | John McCabe | Dublin, Ireland | 4-Oct-2018 |
| [Writing Serverless functions in Python](https://www.openfest.org/2018/en/) | [Ivana Yovcheva](https://twitter.com/ivanabyov) | Sofia, Bulgaria | 3-Nov-2018 |
| [Serverless functions made simple with Kubernetes (lightning talk)](https://www.openfest.org/2018/en/) | [Ivana Yovcheva](https://twitter.com/ivanabyov) | Sofia, Bulgaria | 3-Nov-2018 |
| [Serverlessconf Tokyo 2018 OpenFaaS Workshop](http://tokyo.serverlessconf.io/workshops.html) | Ken Fukuyama | Tokyo, JP | 28-Sep-2018 |
| [OpenFaaS on Kubernetes](https://www.katacoda.com/courses/serverless/openfaas)| Jonathan Johnson | katacoda.com/courses/serverless| 22-Sep-2018 |
| [Building Cloud-Native Apps - FaaS: The Swiss Army Knife of Cloud Native](https://www.meetup.com/Cloud_Native_Meetup/events/254232936/) | James McAfee | Sydney, Australia | 12-Sep-2018 |
| [ Creating Your First Serverless Function with OpenFaaS - VMworld 2018](https://www.youtube.com/watch?v=xiLkq1zQldE&t) | Kendrick Coleman | Las Vegas, NV, USA |28-Aug-2018 |
| [ John Callaway: .NET Core on a Raspberry Pi Cluster with Docker and OpenFaaS](https://secure.meetup.com/register/?ctx=ref) | John Callaway | Orlando, FL, USA |16-Aug-2018 |
| [Cloud Native Glasgow - Serverless on Kubernetes](https://www.meetup.com/CloudNativeGlasgow/events/251913059/) | John McCabe | Glasgow, UK | 5-July-2018 |
| [Opsview & Kubernetes (incl. OpenFaaS)](https://www.meetup.com/Birmingham-digital-development-Meetup/events/250680464/) | Opsview | Birmingham, UK | 28-June-2018 |
| [Meetup[4] - Pizza and OpenFaaS](https://www.meetup.com/Shirley-Software-Development-Meetup/events/251103825/) | [Steven Tsang](https://twitter.com/stetsang) | Shirley, UK | 27-June-2018 |
| [Open Source Sharing is Caring Meetup](https://www.meetup.com/VMwareBulgaria/events/251794762/) | Alex Ellis & Ivana Yovcheva | Sofia, Bulgaria | 25-June-2018 |
| [OpenFaaS Bangalore Launch Meetup](https://www.meetup.com/Bangalore-OpenFaaS-Meetup/events/251711771/) | Vivek Singh, Vivek Sridhar, Tarun Mangukiya | Bangalore, IN | 23-June-2018 |
| [Docker Seattle - Serverless Talks: Fn Project && OpenFaaS](https://www.meetup.com/Docker-Seattle/events/251686931/) | Eric Stoekl | Seattle, WA | 21-June-2018 |
| [OpenFaaS: Serverless Kubernetes Functions](https://www.meetup.com/meetup-group-hPTHYTAe/events/251435215/) | Burton Rheutan, Tunde Oladipupo | Zoom | 20-June-2018 |
| [GitOps, OpenFaaS, Istio and Helm with Weaveworks](https://www.meetup.com/Weave-User-Group-Bay-Area/events/251409954/) | Alex Ellis, Stefan Prodan | SF, USA | 12-June-2018 |
| [Serverless Panel @ Dockercon](https://dockercon18.smarteventscloud.com/connect/sessionDetail.ww?SESSION_ID=194869) | Alex Ellis & others | SF, USA | 14-June-2018 |
| [Container Innovation SIG @ Dockercon](https://dockercon18.smarteventscloud.com/connect/sessionDetail.ww?SESSION_ID=187204) | Alex Ellis & others | SF, USA | 13-June-2018 |
| [Serverless Beyond the Hype @ Docker London](https://www.meetup.com/Docker-London/events/249221771/) | Alex Ellis | London, UK | 25-May-2018 |
| [OpenFaaS @ GOTO Nights](https://www.meetup.com/GOTO-Nights-CPH/events/249895973/) | Alex Ellis | Copenhagen, DK | 1-May-2018 |
| [Kubernetes Seattle: OpenFaas & Migrating to Envoy Proxy in K8s](https://www.meetup.com/Seattle-Kubernetes-Meetup/events/250105287/) | Eric Stoekl | Seattle, WA | 23-May-2018 |
| [OpenFaaS @ Serverless CPH](https://serverlesscph.dk) | John McCabe | Copenhagen, DK | 16-May-2018 |
| Serverless OpenFaaS and Python Workshop @ Agile Peterborough        | Alex Ellis, Richard Gee  | Peterborough, UK | 12-May-2018 |
| [Going Serverless with OpenFaaS, Kubernetes, and Python @ PyCon](https://us.pycon.org/2018/schedule/presentation/40/) | [Michael Herman](https://twitter.com/mikeherman) |  Cleveland, OH | 9-May-2018 |
| [OpenFaaS talk and workshop @ Cisco DevNet Create](https://devnetcreate.io/2018/pages/speaker/speaker.html#Alex-Ellis) | Alex Ellis | Mountain View, CA | 10/11-Apr-2018 |
| [OpenFaaS : a serverless framework on top of Docker and Kubernetes @ Devoxx France](https://www.devoxx.fr/) | [Laurent Grangeau](https://twitter.com/laurentgrangeau) | Paris, France | 18-Apr-2018 |
| [Serverless meetup - Serverless vs. Organizations: How Serverless forces us to *un*learn](https://www.meetup.com/Serverless-Dusseldorf/events/259557587/) | Thomas Peitz | Dusseldorf, Germany | 12-April-2018 |
| [Deep Dive: Serverless Computing mit OpenFaaS - Magdeburger Developer Days](https://www.md-devdays.de/Act?id=34/) | Frank Pommerening | Magdeburg Germany | 10-April-2018 |
| [.NET Core on a Raspberry Pi Cluster with Docker and OpenFaaS](https://www.meetup.com/St-Pete-NET-Meetup/events/247299483/) | John Callaway | St Petersburg, FL | 03-Apr-2018 |
| [.NET Core on a Raspberry Pi Cluster with Docker and OpenFaaS](http://www.codepalousa.com/Sessions/1034) | John Callaway | Louisville, KY | 30-Mar-2018 |
| [OpenFaaS : a serverless framework on top of Docker and Kubernetes @ BreizhCamp](http://www.breizhcamp.org/) | [Laurent Grangeau](https://twitter.com/laurentgrangeau) | Paris, France | 29-Mar-2018 |
| [Running private OpenFaaS is not about avoiding lock-in](https://www.meetup.com/Serverless-Italy/events/248536634/) | Nic Jackson | Milan, IT | 20-Mar-2018 |
| [Serverless Computing mit Docker Swarm und OpenFaaS - Softwerkskammer Jena](https://www.meetup.com/de-DE/jenadevs/events/246045796/) | Frank Pommerening | Jena Germany | 20-Mar-2018 |
| [.NET Core on a Raspberry Pi Cluster with Docker and OpenFaaS](https://orlandocodecamp.com/sessions/Details/63) | John Callaway | Orlando, FL | 17-Mar-2018 |
| [Workshop: Serverless Computing mit OpenFaaS - Spartakiade](https://github.com/fpommerening/Spartakiade2018-OpenFaaS) | Frank Pommerening | Berlin Germany | 17-Mar-2018 |
| Serverless OpenFaaS and Python Workshop @ PyCon SK        | Alex Ellis  | Bratislava, SK | 11-Mar-2018 |
| Serverless with OpenFaaS Opening Keynote @ PyCon SK        | Alex Ellis  | Bratislava, SK | 09-Mar-2018 |
| [Serverless con AWS Lambda y OpenFaaS](https://t3chfest.uc3m.es/2018/programa/serverless-con-aws-lambda-openfaas/) | [Javier Revillas](https://twitter.com/javirevillas) | Madrid, Spain | 01-Mar-2018 |
| [OpenFaaS presentation + Demo on Kubernetes @ ClusterEurope](https://clustereurope.org/) | [Laurent Grangeau](https://twitter.com/laurentgrangeau) | Paris, France | 02-Feb-2018 |
| [OpenFaaS presentation + Demo on Kubernetes @ ApiDays Paris](http://www.apidays.io/events/paris-2017) | [Laurent Grangeau](https://twitter.com/laurentgrangeau) | Paris, France | 30-Jan-2018 |
| [Serverless Computing mit OpenFaaS - Developer Group Leipzig](https://www.meetup.com/de-DE/Developer-Group-Leipzig/events/245252994/) | Frank Pommerening | Leipzig Germany | 29-Jan-2018 |
| [OpenFaaS : a serverless framework on top of Docker and Kubernetes @ Snowcamp.io](https://snowcamp2018.sched.com/event/D2nX/openfaas-a-serverless-framework-on-top-of-docker-and-kubernetes?iframe=no&w=100%&sidebar=no&bg=no) | [Laurent Grangeau](https://twitter.com/laurentgrangeau) | Paris, France | 25-Jan-2018 |
| [Talk: Building a Raspberry Pi Kubernetes Cluster with OpenFaaS](https://ndc-london.com/talk/building-a-raspberry-pi-kubernetes-cluster-and-running-.net-core/) | Alex Ellis / Scott Hanselman | London | 18-Jan-2018 |

#### Blog posts and write-ups 2018
[Back to top](#openfaas-community)

| Blog/repo name and description                                          | Author       | Site     | Date        |
|---------------------------------------------------------------------|--------------|----------|-------------|
| [3 Serverless Platform Approaches to Consider](https://searchmicroservices.techtarget.com/tip/3-serverless-platform-approaches-to-consider) | Twain Taylor | techtarget.com | 31-Dec-2018 |
| [Tracing Your Functions](http://www.nohuddleoffense.de/2018/12/27/tracing-your-functions/) | Thijs Metsch | nohuddleoffense.de | 27-Dec-2018 |
| [Routing URLs to OpenFaaS Functions](https://kamal.io/blog/routing-urls-to-openfaas-functions) | Kamal Nasser | kamal.io | 10-Dec-2018 |
| [OpenFaaS Duffle CNAB Packing](https://github.com/johnmccabe/openfaas-cnab) | John McCabe | https://github.com/johnmccabe| 05-Dec-2018 |
| [Writing Serverless Functions in Crystal](https://medium.com/@t_pei/serverless-crystal-14b22ecc4352) | Thomas Peikert | medium.com | 05-Dec-2018 |
| [.Net Core – OpenFaas – MongoDB](https://marcussmallman.io/2018/11/27/net-core-openfaas-mongodb/) | Marcus Smallman | marcussmallman.io | 28-Nov-2018 |
| [Micro-tutorial: use Redis & Node.js with OpenFaaS](https://gist.github.com/alexellis/e05a7b573ae22b209f0214d5766ff07e) | Alex Ellis | github.com | 24-Nov-2018 |
| [🇬🇧 Use Vert.x with OpenFaaS](https://k33g.gitlab.io/articles/2018-11-11-OPENFAAS.html) | Philippe Charrière | GitLab.com | 11-Nov-2018 |
| [Serverless Computing: More Time for the Code](https://www.golem.de/news/serverless-computing-mehr-zeit-fuer-den-code-1811-137516-5.html) | Valentin Höbel | golem.de | 08-Nov-2018 |
| [Using GraphQL in OpenFaaS functions](https://padiazg.github.io/graphql-on-opesfaas/) | Patricio Díaz | padiazg.github.io | 03-Nov-2018 |
| [Micro-tutorial: Learn how to run OpenFaaS Function Store functions on Knative](https://gist.github.com/alexellis/5c1587cf24b634f940764427d50719bf) | Alex Ellis | github.com | 30-Oct-2018 |
| [🇬🇧-use-express-with-openfaas](https://k33g.gitlab.io/articles/2018-10-28-OPENFAAS.html) | Philippe Charrière | GitLab.com | 28-Oct-2018 |
| [First contact with OpenFaaS](https://k33g.gitlab.io/articles/2018-10-20-OPENFAAS.html) | Philippe Charrière | GitLab.com | 20-Oct-2018 |
| [ACI Information Group: OpenFaaS among wish-list items for AWS Lambda](https://searchaws.techtarget.com/opinion/Lambda-support-for-OpenFaaS-among-wish-list-items) | Chris Moyer | techtarget.com | 11-Oct-2018 |
| [Deploy a python app using OpenFaaS](https://saurabhlondhe.github.io/technology/linux/2018/10/10/python-app-with-openfaas.html) | Saurabh Londhe | saurabhlondhe.github.io | 10-Oct-2018 |
| [Serverless R functions with OpenFaaS](https://medium.com/@keyunie/serverless-r-functions-with-openfaas-1cd34905834d) | Keyu Nie | medium.com | 30-Sept-2018 |
| [Serverless Data Fetching stack with OpenFaaS & OpenFlow](https://blog.lapw.at/serverless-data-fetching-stack-openfaas-openflow/) | Quentin Lapointe | blog.lapw.at | 23-Sept-2018 |
| [How To Install and Secure OpenFaaS Using Docker Swarm on Ubuntu 16.04](https://www.digitalocean.com/community/tutorials/how-to-install-and-secure-openfaas-using-docker-swarm-on-ubuntu-16-04) | Marko Mudrinić | digitalocean.com | 19-Sept-2018 |
| [Vert.x + Graal = Java for Serverless = ❤️!](https://www.jetdrone.xyz/2018/09/07/Vertx-Serverless-5mb.html) | Paulo Lopes | jetdrone.xyz | 07-Sept-2018 |
| [OpenFass 介绍及源码分析 (OpenFaaS Deep-Dive / Code-Analysis) - Chinese](https://www.youtube.com/watch?v=bZtgrAVR9HQ&feature=youtu.be) | Zhu Zhenfeng | youtube.com | 07-Sept-2018 |
| [Introducing stateless microservices for OpenFaaS](https://www.openfaas.com/blog/stateless-microservices/) | Alex Ellis | openfaas.com | 05-Sept-2018 |
| [Serverless com OpenFaaS e PHP (Portuguese)](https://medium.com/@FernandoDebrand/serverless-com-openfaas-e-php-3dce499f8062) | Fernando Silva | medium.com | 04-Sept-2018 |
| [Deploy OpenFaaS and Kubernetes on DigitalOcean with Ansible](https://www.openfaas.com/blog/deploy-digitalocean-ansible/) | Richard Gee | openfaas.com | 27-Aug-2018 |
| [Cerner ShipIt Hackathon - ShipIt XII](https://engineering.cerner.com/blog/shipit-xii/) | Caitie Oder | cerner.com | 30-Aug-2918 |
| [Running serverless functions on premises using OpenFaas with Kubernetes](https://medium.com/@shalithasuranga/running-serverless-functions-on-premises-using-openfaas-with-kubernetes-6c7a65aedb5b) | Shalitha Suranga | https://medium.com/@shalithasuranga | 29-Aug-2918 |
| [5 tips and tricks for the OpenFaaS CLI](https://www.openfaas.com/blog/five-cli-tips/) | Alex Ellis | openfaas.com | 21-Aug-2018 |
| [Multi-stage Serverless on Kubernetes with OpenFaaS and GKE](https://www.openfaas.com/blog/gke-multi-stage/) | Stefan Prodan | openfaas.com | 14-Aug-2018 |
| [Managing state for Serverless Functions with Minio](https://blog.lapw.at/stateful-serverless-stack-openfaas-minio/) | Quentin Lapointe | lapw.at | 14-Aug-2018 |
| [Monitor Arista Cloud vision network devices with OpenFaaS](https://github.com/burnyd/cvp-serverless-openfaas) | Daniel Hertzberg | github.com | 13-Aug-2018 |
| [Serverless email sender using OpenFaaS and .NET Core](https://medium.com/@paulius.juozelskis/serverless-email-sender-using-openfaas-and-net-core-afdef152359) | Paulius Juozelskis | medium.com | 13-Aug-2018 |
| [Become your own Functions as a Service provider using OpenFaaS](https://xpirit.com/become-your-own-functions-as-a-service-provider-using-openfaas/) | Michiel van Oudheusden	& Marc Duiker | xpirit.com | 10-Aug-2018 |
| [VMware CodeHouse: A Great Insight into the Future of Software Engineering](https://blogs.vmware.com/opensource/2018/08/07/vmware-codehouse-empowers-women/) | Jonas Rosland | blogs.vmware.com | 7-Aug-2018 |
| [OpenFaaS on Cisco DevNet Sandbox](https://developer.cisco.com/docs/sandbox/#!cloud/all-cloud-sandboxes) | [Cisco DevNet Sandbox](https://developer.cisco.com/sandbox) | [Cisco DevNet](https://developer.cisco.com) | 8-Aug-2018 |
| [How to run Rust in OpenFaaS](https://booyaa.wtf/2018/run-rust-in-openfaas/) | Mark Sta Ana | booyaa.wtf | 4-Aug-2018 |
| [Scale to Zero and Back Again with OpenFaaS](https://www.openfaas.com/blog/zero-scale/) | Alex Ellis | openfaas.com | 25-July-2018 |
| [PHP and OpenFaaS](https://mfyu.co.uk/post/php-and-openfaas) | Matt Brunt | mfyu.co.uk | 21-July-2018 |
| [Deploying OpenFaaS from Portainer.io and Creating your First Function](https://www.linkedin.com/pulse/deploying-openfaas-from-portainerio-creating-your-first-steven-kang/) | Steven Kang | linkedin.com | 8-Jul-2018 |
| [Building a custom Dynamics 365 data interface with OpenFaaS](https://alexanderdevelopment.net/post/2018/07/05/building-a-custom-dynamics-365-data-interface-with-openfaas/) | Lucas Alexander | alexanderdevelopment.net | 5-Jul-2018 |
| [Introducing the OpenFaaS Operator for Serverless on Kubernetes](https://blog.alexellis.io/introducing-the-openfaas-operator/) | Alex Ellis | alexellis.io | 2-Jul-2018 |
| [Kubernetes: From Fear to Functions in 20 Minutes](https://medium.com/@rorpage/kubernetes-from-fear-to-functions-in-20-minutes-a021f7ef5843) | Rob Page | medium.com | 11-Jun-2018 |
| [Installing and securing OpenFaaS on an AKS cluster](https://alexanderdevelopment.net/post/2018/05/31/installing-and-securing-openfaas-on-an-aks/) | Lucas Alexander | alexanderdevelopment.net | 31-May-2018 |
| [How OpenFaaS came to rescue us!](https://medium.com/iconscout/how-openfaas-came-to-rescue-us-ec129518cd46) | Tarun Mangukiya | iconscout.com | 24-May-2018 |
| [Building a Serverless Microblog in Ruby with OpenFaaS – Part 1 ](https://keiran.scot/2018/05/18/faasfriday-serverless-microblog/) | Keiran Smith | keiran.scot | 18-May-2018 |
| [Using ML.NET in an OpenFaaS function](https://alexanderdevelopment.net/post/2018/05/17/using-ml-net-in-an-openfaas-function/) | Lucas Alexander | alexanderdevelopment.net | 17-May-2018 |
| [Demystifying Serverless & OpenFaas](https://collabnix.com/demystifying-openfaas-simplifying-serverless-computing/) | Ajeet Raina | collabnix.com | 27-Apr-2018
| [Deploying OpenFaas on Minikube 1.10](https://people.cs.umu.se/~larsson/2018/04/deploying-openfaas-on-minikube-1.10/) | LARS LARSSON | https://people.cs.umu.se/~larsson | 18-Apr-2018
| [Writing OpenFaas Serverless Functions in Go](https://marcussmallman.io/2018/04/11/writing-openfaas-serverless-functions-in-go/) | Marcus Smallman | marcussmallman.io | 11-Apr-2018 |
| [Deploying OpenFaaS on Kubernetes - Azure AKS Part 2 (SSL)](https://medium.com/@ericstoekl/openfaas-on-azure-aks-with-ssl-ingress-openfaas-on-aks-part-2-2-e9f2db9db387) | Eric Stoekl | medium.com | 23-Mar-2018 |
| [VMware + OpenFaaS – One Month In](https://blogs.vmware.com/opensource/2018/03/20/vmware-openfaas-alex-ellis) | Alex Ellis | vmware.com | 21-Mar-2018 |
| [Securing Kubernetes for OpenFaaS and beyond](https://www.twistlock.com/2018/03/20/securing-kubernetes-openfaas-beyond) | Daniel Shapira | twistlock.com | 20-Mar-2018 |
| [What Is OpenFaaS and How Can It Drive Innovation?](https://www.contino.io/insights/what-is-openfaas-and-why-is-it-an-alternative-to-aws-lambda-an-interview-with-creator-alex-ellis) | Ben Tannahill | contino.com | 19-Mar-2018 |
| [MQTT Openfaas Bridge](https://github.com/alexking/mqtt-openfaas-bridge/) | Alex | https://github.com/alexking | 15-Mar-2018 |
| [Making a Racket with OpenFaaS](https://dev.to/dvdmuckle/making-a-racket-with-openfaas--4mmf) | David Muckle | dev.to | 14-Mar-2018 |
| [Installing and securing OpenFaaS on a Google Cloud virtual machine](https://alexanderdevelopment.net/post/2018/02/25/installing-and-securing-openfaas-on-a-google-cloud-virtual-machine/) | Lucas Alexander | alexanderdevelopment.net | 25-Feb-2018 |
| [OpenFaaS on a Kubernetes clusterの仕組み](https://qiita.com/TakanariKo/items/5e3117ea7c3afa948de5) | Takanari Ko | qiita.com | 21-Feb-2018 |
| [VMware Welcomes Alex Ellis](https://blogs.vmware.com/opensource/2018/02/19/vmware-welcomes-alex-ellis/) | VMware team | vmware.com | 19-Feb-2018 |
| [I'm going to be working on OpenFaaS full-time](https://blog.alexellis.io/full-time-openfaas/) | Alex Ellis | alexellis.io | 19-Feb-2018 |
| [Stop installing CLI tools on your build server: CLI-as-a-Function with OpenFaaS](https://medium.com/@burtonr/stop-installing-cli-tools-on-your-build-server-cli-as-a-function-with-openfaas-80dd8d6be611) | Burton Rheutan | medium.com/@burtonr | 12-Feb-2018 |
| [Turn Any CLI into a Function with OpenFaaS](https://blog.alexellis.io/cli-functions-with-openfaas/) | Alex Ellis | alexellis.io | 06-Feb-2018
| [Deploying OpenFaaS on Kubernetes  - Azure AKS](https://medium.com/@ericstoekl/deploying-openfaas-on-kubernetes-azure-aks-4eea99d0743f) | Eric Stoekl | medium.com | 03-Feb-2018 |
| [OpenFaaS with Ruby/MySQL/Ceph](https://github.com/Lallassu/openfaas-demo) | Magnus Persson | cygate.se | 23-Jan-2018 |
| [Installing OpenFaaS on top of Kubernetes on bare-metal with Terraform Scaleway provider and kubeadm](https://stefanprodan.com/2018/kubernetes-scaleway-baremetal-arm-terraform-installer/) | Stefan Prodan | stefanprodan.com | 22-Jan-2018
| [Get storage for your Severless Functions with Minio & Docker](https://blog.alexellis.io/openfaas-storage-for-your-functions/) | Alex Ellis | alexellis.io | 22-Jan-2018
| [ColoriseBot: three months on](https://finnian.io/blog/colorisebot-three-months-on/) | Finnian Anderson | finnian.io | 22-Jan-2018 |
| [Raspberry Pi Cluster with Docker and OpenFaaS (and SETI)](http://6figuredev.com/learning/raspberry-pi-cluster-with-docker-and-openfaas-and-seti/) | John Callaway | 6FigureDev.com | 17-Jan-2018 |
| [Podcast - Episode 022 – OpenFaaS with Docker Captain Alex Ellis](http://6figuredev.com/podcast/episode-022-openfaas-with-docker-captain-alex-ellis/) | The 6 Figure Developer Podcast | 6FigureDev.com | 15-Jan-2018 |
| [Google Home + OpenFaaS: Write your own voice controlled functions](https://medium.com/@burtonr/google-home-openfaas-write-your-own-voice-controlled-functions-11f195398e3f) | Burton Rheutan | medium.com/@burtonr | 06-Jan-2018 |
| [OpenFaaS At The Helm w/ Kubernetes in the DevNet Sandbox](https://blogs.cisco.com/developer/openfaas-at-the-helm-w-kubernetes-in-the-devnet-sandbox) | [Cisco DevNet Sandbox](https://developer.cisco.com/sandbox) | [Cisco DevNet](https://developer.cisco.com) | 2-Jan-2018 |

### 2017

#### Events in 2017
[Back to top](#openfaas-community)

| Event name and description                                          | Speaker      | Location | Date        |
|---------------------------------------------------------------------|--------------|----------|-------------|
| [OpenFaaS @ KubeCon + CloudNativeCon](https://kccncna17.sched.com/event/CU6s/faas-and-furious-0-to-serverless-in-60-seconds-anywhere-alex-ellis-adp) | Alex Ellis | Austin, USA | 07-Dec-2017 |
| [OpenFaaS on Azure AKS with ASP.NET Core website @ AzugFR](https://www.meetup.com/fr-FR/AZUG-FR/events/245186139/) | [Laurent Grangeau](https://twitter.com/laurentgrangeau) | Paris, France | 05-Dec-2017 |
| [OpenFaaS presentation + Demo on Kubernetes @ Paris Serverless Meetup](https://www.meetup.com/fr-FR/Paris-Serverless-Architecture-Meetup/) | [Laurent Grangeau](https://twitter.com/laurentgrangeau) | Paris, France | 14-Nov-2017 |
| [OpenFaaS - Serverless Functions Made Simple @ Docker Cambridge Meetup](https://www.meetup.com/docker-cambridge/events/243206434/) | Alex Ellis | Cambridge, UK | 20-Nov-2017 |
| [OpenFaaS Demo at APIOps Meetup](https://www.meetup.com/APIOps-Tampere/) | [Sakari Hoisko](https://twitter.com/Chaggeus) | Tampere, Finland | 14-Nov-2017 |
| [SecTalks Canberra: OpenFaaS + Security workshop](https://www.meetup.com/SecTalks-Canberra/events/241579721/) | Glenn Grant | Australia | 14-Nov-2017 |
| [Docker Belfast Meetup](https://www.meetup.com/Docker-Belfast/) | John McCabe | Belfast, Northern Ireland | 31-Oct-2017 |
| [Belfast Gophers Meetup](https://www.meetup.com/Belfast-Gophers/) | John McCabe | Belfast, Northern Ireland | 26-Oct-2017 |
| [Introduction to Serverless with OpenFaaS - Moby Summit](https://europe-2017.dockercon.com/moby-summit/) | Alex Ellis | Copenhagen | 19-Oct-2017 |
| [Repainting the Past with Distributed Machine Learning and Docker - DockerCon EU](https://europe-2017.dockercon.com/agenda/#tab_title6) | Finnian Anderson & Oli Callaghan | Copenhagen | 18-Oct-2017 |
| [Zero to Serverless in 60 secs - Dockercon EU](https://europe-2017.dockercon.com/agenda/#tab_title6) | Alex Ellis | Copenhagen | 17-Oct-2017 |
| [Tech Weekly @ UNiDAYS - Alex Young introduces OpenFaaS](https://speakerdeck.com/nullseed/tech-weekly-at-unidays-alex-young-introduces-openfaas) | Alex Young | Nottingham, UK | 12-Oct-2017 |
| [OpenFaaS @ JeffConf Milan](https://milan.jeffconf.com/speakers) | Alex Ellis | Milan, Italy | 29-Sept-2017 |
| [Zero to Serverless in 60 secs - Open Source Summit North America](http://events.linuxfoundation.org/events/open-source-summit-north-america/program/schedule) | Alex Ellis | LA, USA | 11-14 Sept 2017 |
| [FaaS and Furious - CloudNativeLon (Vimeo)](https://skillsmatter.com/skillscasts/10813-faas-and-furious-0-to-serverless-in-60-seconds-anywhere) | Alex Ellis | London, UK | 06 Sept 2017 |
| [From Zero to Serverless with FaaS - Fusion meet-up](https://www.eventbrite.com/e/fusion-meetup-birmingham-june-2017-tickets-35370655583?aff=es2) | Alex Ellis | Birmingham, UK | 20 June 2017 |
| [TechXLR8 - XLR8 your cloud with Docker and Serverless FaaS](https://www.slideshare.net/AlexEllis11/techxlr8-xlr8-your-cloud-with-docker-and-serverless-faas) | Alex Ellis | London, UK | 13-June-2017 |
| [Whaleless!](http://gluecon.com/#agenda) ([slides](https://speakerdeck.com/amirmc/whaleless-doing-serverless-with-docker)) | Amir Chaudhry | GlueCon, CO | 26-May-2017 |
| [MakerShift: Build Your own Serverless functions w/ FaaS](https://www.makershift.io/)| Austin Frey | Harrisburg, PA | 06-May-2017 |
| [Dockercon closing keynote - Cool Hacks](https://blog.docker.com/2017/04/dockercon-2017-mobys-cool-hack-sessions/) | Alex Ellis | Dockercon, Austin | 20-April-2017 |
| [TechLancaster](http://techlancaster.com/meetup)| Austin Frey | Lancaster, PA | 18-April-2017 |
| [ETH Polymese](https://www.polymesse.ch/current-presentations.html)| Brian Christner   | Zürich   | 04-April-2017 |
| [Operationalizing Containers](http://www.rackspace-inform.eu/dispatcher/action?wlmsac=t1ejSDdh1hygBurJJANV)| Brian Christner   | Zürich   | 5-April-2017 |
| [FaaS on Hacker News](https://news.ycombinator.com/item?id=13920588)| Alex Ellis   | Online   | 22-Mar-2017 |


### Blog posts and write-ups 2017
[Back to top](#openfaas-community)

| Blog/repo name and description                                          | Author       | Site     | Date        |
|---------------------------------------------------------------------|--------------|----------|-------------|
| [Podcast - Hanselminutes - Serverless and OpenFaas with Alex Ellis](https://www.hanselminutes.com) | Scott Hanselman | hanselminutes.com | 29-Dec-2017
| [Podcast - How Serverless Technologies Impact Kubernetes](https://thenewstack.io/serverless-technologies-impact-kubernetes/) | The New Stack Makers | thenewstack.io | 28-Dec-2017 |
| [OpenFaaS快速入门指南 (OpenFaaS Quick Start Guide) - Chinese](https://jimmysong.io/posts/openfaas-quick-start/) | Jimmy Song | jimmysong.io | 26-Dec-2017 |
| [OpenFaaS on DCOS](https://medium.com/@realrealbot/openfaas-on-dcos-9d5927f4e725) | Alberto Quario | medium.com/@realrealbot  | 20-Dec-2017
| [Deploying Kubernetes On-Premise with RKE and deploying OpenFaaS on it — Part 1](https://medium.com/@kenfdev/deploying-kubernetes-on-premise-with-rke-and-deploying-openfaas-on-it-part-1-69a35ddfa507) | Ken Fukuyama | medium.com/@kenfdev  | 10-Dec-2017
| [Deploying Kubernetes On-Premise with RKE and deploying OpenFaaS on it — Part 2](https://medium.com/@kenfdev/deploying-kubernetes-on-premise-with-rke-and-deploying-openfaas-on-it-part-2-cc14004e7007) | Ken Fukuyama | medium.com/@kenfdev  | 10-Dec-2017
| [Overview of Functions as a Service with OpenFaas](https://mfarache.github.io/mfarache/Functions-As-A-Service-OpenFaas/) | Mauricio Farache | github.io  | 06-Dec-2017
| [How to secure OpenFaaS with Let's Encrypt and basic auth on Google Kubernetes Engine](https://stefanprodan.com/2017/openfaas-kubernetes-ingress-ssl-gke/) | Stefan Prodan | stefanprodan.com | 04-Dec-2017
| [Running OpenFaaS on GKE - a step by step guide](https://www.weave.works/blog/openfaas-gke) | Stefan Prodan | weave.works | 04-Dec-2017
| [OpenFaaS Meets Perl](https://blog.hex64.com/serverless-open-faas-meets-perl/) | Piotr | hex64.com | 03-Dec-2017
| [Deploying OpenFaaS on Kubernetes - AWS](https://medium.com/@ericstoekl/deploying-openfaas-on-kubernetes-aws-259ec9515e3c) | Eric Stoekl | medium.com/ | 03-Dec-2017
| [Unleash the Artist within you with Docker, Tensorflow and OpenFaaS](http://jmkhael.io/unleash-the-artist-within-tensorflow-and-openfaas/) | Johnny Mkhael  | jmkhael.io | 22-Nov-2017
| [How to Deploy OpenFaaS Serverless PHP Functions](http://blog.gaiterjones.com/how-to-deploy-open-faas-serverless-php-functions/) | Gaiter Jones  | gaiterjones.com | 20-Nov-2017
| [Getting started with OpenFaaS on minikube](https://medium.com/@alexellisuk/getting-started-with-openfaas-on-minikube-634502c7acdf) | Alex Ellis | medium.com | 18-Nov-2017
| [OpenFaaS November Contributor Highlights](https://blog.alexellis.io/openfaas-contributors-highlights/) | Alex Ellis | alexellis.io | 15-Nov-2017 |
| [Contributing to OpenFaaS without writing any code… (yet)](https://hackernoon.com/contributing-to-openfaas-without-writing-any-code-yet-846dd014514f) | Burton Rheutan | hackernoon.com/@burtonr | 11-Nov-2017 |
| [How to start with OpenFaaS](http://panosgeorgiadis.com/blog/2017/11/08/how-to-start-with-openfaas/) | Panos Georgiadis | panosgeorgiadis.com | 08-Nov-2017 |
| [From Zero to Serverless in 60 Seconds, Anywhere](https://www.youtube.com/watch?v=W9a-JmEnDkw) | Alex Ellis | youtube.com | 05-Nov-2017 |
| [Build a Kubernetes Cluster w/ Raspberry Pi & .NET Core on OpenFaas](https://www.hanselman.com/blog/HowToBuildAKubernetesClusterWithARMRaspberryPiThenRunNETCoreOnOpenFaas.aspx) | Scott Hanselman | hanselman.com | 31-Oct-2017
| [Kubernetes + OpenFaaS + runV + ARM64 Packet.net](https://medium.com/@resouer/kubernetes-openfaas-runv-arm64-packet-net-ea4c7b61c88f) | Harry Zhang | medium.com | 31-Oct-2017 |
| [Serverless Kubernetes home-lab with your Raspberry Pis](https://blog.alexellis.io/serverless-kubernetes-on-raspberry-pi/) | Alex Ellis | alexellis.io | 27-Oct-2017 |
| [Build a Serverless Memes Function with OpenFaaS](https://medium.com/@mlabouardy/build-a-serverless-memes-function-with-openfaas-f4210a53abe8) | Mohamed Labouardy | medium.com/@mlabouardy | 24-Oct-2017 |
| [Repainting the Past with Machine Learning and OpenFaaS](http://olicallaghan.com/post/repainting-the-past-with-machine-learning-and-openfaas) | Oli Callaghan | olicallaghan.com | 23-Oct-2017 |
| [An Introduction to Serverless DevOps with OpenFaaS](https://hackernoon.com/an-introduction-to-serverless-devops-with-openfaas-b978ab0eb2b) | Ken Fukuyama | medium.com/@kenfdev | 22-Oct-2017 |
| [Colourising Video with OpenFaaS Serverless Functions](https://finnian.io/blog/colourising-video-with-openfaas-serverless-functions/) | Finnian Anderson | finnian.io | 21-Oct-2017 |
| [Deploying Function as a Service with OpenFaaS, Kubernetes and VMware API's](https://www.thehumblelab.com/deploying-openfaas-vmware-apis/) | Codyde | thehumblelab | 14-Oct-2017 |
| [My First Pull Request To OpenFaaS](https://hackernoon.com/my-first-pull-request-to-openfaas-a-major-open-source-project-d0c823790691) | Burton Rheutan | hackernoon.com/@burtonr | 10-Oct-2017 |
| [Deploying a Serverless Youtube-To-Gif Telegram bot with OpenFaaS](https://medium.com/@ericstoekl/deploying-a-serverless-youtube-to-gif-telegram-bot-with-openfaas-2b78d1e9ae6) | Eric Stoekl | medium.com/@ericstoekl | 25-Sep-2017 |
| [A Serverless GraphQL Blog in 60 Seconds with OpenFaaS](https://medium.com/@kenfdev/a-serverless-graphql-blog-in-60-seconds-with-openfaas-aaedd566b1f3) | Ken Fukuyama | medium.com/@kenfdev | 24-Sep-2017 |
| [Create your own DownNotifier with OpenFaaS](http://jmkhael.io/downnotifier-site-pinger/)| Johnny Mkhael | jmkhael.io | 22-Sep-2017|
| [Get OpenFaaS running on Azure Container Service with Kubernetes](https://gist.github.com/danigian/e6097fad36f03c476a69e6c44fde074f) | Daniele Antonio Maggio | twitter.com/danigian | 21-Sep-2017 |
| [OpenFaaS on Azure (Swarm)](https://blogs.technet.microsoft.com/livedevopsinjapan/2017/09/21/openfaas-on-azure-swarm/) | Tsuyoshi Ushio | technet.microsoft.com | 21-Sep-2017 |
| [OpenFaaS on ACS (Kubernetes)](https://blogs.technet.microsoft.com/livedevopsinjapan/2017/09/19/open-faas-on-acs-kubernetes/) | Tsuyoshi Ushio | technet.microsoft.com | 19-Sep-2017 |
| [OpenFaaS on Civo (Kubernetes)](https://www.civo.com/learn/kubernetes-and-openfaas-using-terraform) | Andy Jeffries | civo.com | 18-Sep-2017 |
| [Integrating OpenFaaS and GraphQL](https://medium.com/@kenfdev/integrating-openfaas-and-graphql-experimental-1870bd22f2a) | Ken Fukuyama | medium.com/@kenfdev | 10-Sep-2017 |
| [Morning coffee with the OpenFaaS CLI](https://blog.alexellis.io/quickstart-openfaas-cli/) | Alex Ellis | alexellis.io | 05-Sep-2017 |
| [OpenFaaS on Rancher](https://medium.com/cloud-academy-inc/openfaas-on-rancher-684650cc078e) | Ken Fukuyama | medium.com/@kenfdev | 02-Sep-2017 |
| [OpenFaaS accelerates serverless Java with AfterBurn](https://blog.alexellis.io/openfaas-serverless-acceleration/) | Alex Ellis | alexellis.io | 01-Sep-2017 |
| [OpenFaaS presents to CNCF Serverless workgroup](https://blog.alexellis.io/openfaas-cncf-workgroup/) | Alex Ellis | alexellis.io | 29-Aug-2017 |
| [Your Serverless Raspberry Pi cluster with Docker](https://blog.alexellis.io/your-serverless-raspberry-pi-cluster/) | Alex Ellis | alexellis.io | 20-Aug-2017 |
| [Your first serverless .NET function with OpenFaaS](https://medium.com/@rorpage/your-first-serverless-net-function-with-openfaas-27573017dedb) | Rob Page | medium.com | 19-Aug-2017 |
| [Your first serverless Python function with OpenFaaS](https://blog.alexellis.io/first-faas-python-function/) | Alex Ellis | alexellis.io | 11-Aug-2017 |
| [Introducing Functions as a Service - OpenFaaS](https://blog.alexellis.io/introducing-functions-as-a-service/) | Alex Ellis | alexellis.io | 08-Aug-2017 |
| [Time2Code: Functions as Service and Code as a Function](https://medium.com/@JockDaRock/time2code-functions-as-service-and-code-as-a-function-3d9125fc49fb) | Jock Reed | medium.com/@JockDaRock | 4-Aug-2017|
| [FaaS complete walk-through on Kubernetes (video)](https://www.youtube.com/watch?v=0DbrLsUvaso) | Alex Ellis | youtube.com | 28-Jul-2017 |
| [Kittens vs Tarsiers - an introduction to serverless machine learning](http://jmkhael.io/kittens-vs-tarsiers-an-introduction-to-serverless-machine-learning/) | Johnny Mkhael | jmkhael.io | 24-Jul-2017|
| [Old and new - ASCII art and serverless](http://jmkhael.io/create-a-serverless-ascii-banner-with-faas/) | Johnny Mkhael | jmkhael.io | 29-Jun-2017|
| [Sysdig newsletter](http://go.sysdig.com/webmail/231542/29878667/a2cfc2b92d460d3516188054c1f63e6ecdd7eac458f992f37bbe96acb8d83a78) | Sysdig | sysdig.com | 28-Jun-2017|
| [Ship Serverless FaaS functions with ease](http://blog.alexellis.io/build-and-deploy-with-faas/) | Alex Ellis | alexellis.io | 25-Jun-2017 |
| [Functions as a Service - deploying functions to Docker Swarm via CLI](https://dev.to/developius/functions-as-a-service---deploying-functions-to-docker-swarm-via-a-cli) |  Finnian Anderson | dev.to | 18 May 2017 |
| [Create a Morse Code serverless FaaS function in Quick Basic](http://jmkhael.io/code-a-morse-serverless-function-in-quick-basic-with-faas-and-docker/) | Johnny Mkhael | jmkhael.io | 8 May 2017 |
| ["Serverless"? On my own servers?](http://jmkhael.io/serverless-and-on-my-own-servers/) | Johnny Mkhael | jmkhael.io | 4 May 2017 |
[Ship Serverless Functions to your Docker Swarm with FaaS](https://finnian.io/blog/ship-serverless-functions-to-your-docker-swarm-with-faas/) | Finnian Anderson | finnian.io | 2 May 2017 |
| [Docker + Serverless = FaaS (Functions As A Service)](http://lukeangel.co/cross-platform/docker-servless-faas-functions-as-a-service/) | Luke Angel | lukeangel.co | 28-Apr-2017 |
| [Serverless for private clouds](https://medium.com/@pfernandom/serverless-for-private-clouds-or-managing-the-server-for-a-serverless-app-f9321e45a910) | Pedro Fernando Marquez Soto | medium.com | 30-Apr-2017 |
| [O’Reilly Systems Engineering and Operations newsletter](http://post.oreilly.com/form/oreilly/viewhtml/9z1zlu60fomtoiq41cigtigddvnejvh4vjjfm0i1sh8) | O'Reilly | oreilly.com | 11-Apr-2017 |
| [Test Driving Docker Functions as a Service (FaaS)](https://www.brianchristner.io/test-driving-docker-function-as-a-service-faas/) | Brian Christner | brianchristner.io | 10-Apr-2017 |
| [[cncf-toc] The Cloud-Nativity of Serverless](https://lists.cncf.io/pipermail/cncf-toc/2017-March/000781.html) | CNCF mailing-list | cncf.io | 31-May 2017
| [Docker-awesome curated projects](https://github.com/veggiemonk/awesome-docker#serverless) | Julien Bisconti | Github.com | 23-Mar-2017 |
| [Functions as a Service (FaaS) in French](http://blog.alexellis.io/fonction-service/) | Alex Ellis | alexellis.io | 13-Jan-2017 |
| [Functions as a Service (FaaS)](http://blog.alexellis.io/functions-as-a-service/) | Alex Ellis | alexellis.io | 4-Jan-2017 |

### Repositories
#### Projects, Samples, and Use Cases
[Back to top](#openfaas-community)

You can also find cool projects or submit your own to the [faas-and-furious organisation](https://github.com/faas-and-furious). Contact Alex for details on how.

| Project name and description                                         | Author     | Site      | Date        |
|----------------------------------------------------------------------|------------|-----------|-------------|
| [vCenter Event Broker Appliance](https://flings.vmware.com/vcenter-event-broker-appliance)|Gasch/Lam | [VMware Flings](https://flings.vmware.com/) | 11-November-2019 |
| [OpenFaaS PowerShell Polaris template](https://github.com/chelnak/openfaas-powershell-polaris)|Craig Gumbley | github.com | 23-September-2019 |
| [BikeshareFunction for GBFS Bikeshare Systems](https://github.com/andmos/BikeshareFunction) | Andreas Mosti | github.com | 25-May-2019 |
| [OpenFaaS Go 1.11 templates](https://github.com/matipan/openfaas-go111-template/) | Matias Pan | github.com | 15-May-2019 |
| [OpenFaaS GoCV template](http://github.com/matipan/openfaas-gocv-template/) | Matias Pan | github.com | 16-Mar-2019 |
| [OpenFaas CSharp MongoDB Template](https://github.com/Marcus-Smallman/csharp-kestrel-mongo) | Marcus Smallman | github.com | 28-Nov-2018 |
| [OpenFaas Java 8 + Vert.x Template](https://gitlab.com/openfaas-experiments/java-8-vert-x-template) | Philippe Charrière | gitlab.com | 11-Nov-2018 |
| [Faasflow - faas workflow as a function](https://github.com/s8sg/faasflow) | Swarvanu Sengupta | github.com | 11-Nov-2018 |
| [OpenFaaS Crystal Template](https://github.com/TPei/crystal_openfaas) | Thomas Peikert | github.com | 26-Oct-2018 |
| [OpenFaaS Terraform Provider](https://github.com/ewilde/terraform-provider-openfaas) | Edward Wilde | github.com | 12-Oct-2018 |
| [OpenFaaS Swift Template](https://github.com/affix/openfaas-swift-template) | Keiran Smith | github.com | 22-May-2018 |
| [OpenFaaS Code Eval](https://github.com/testdrivenio/openfass-code-eval) | Michael Herman | github.com | 30-Mar-2018 |
| [OpenFaaS RESTful API w/ Node and Postgres](https://github.com/testdrivenio/openfass-node-restful-api) | Michael Herman | github.com | 26-Jan-2018 |
| [OpenFaaS with Ruby/MySQL/Ceph Sample](https://github.com/Lallassu/openfaas-demo) | Magnus Persson | [lallassu/openfaas-demo](https://github.com/Lallassu/openfaas-demo) | 23-Jan-2018
| [sqlrest: API Proxy to connect to a SQL database from a function](https://github.com/BurtonR/sqlrest) | Burton Rheutan | github.com | 21-Nov-2017
| [Kafka-connector for OpenFaaS](https://github.com/ucalgary/ftrigger) | King Chung Huang | [ucalgary/ftrigger](https://github.com/ucalgary/ftrigger) | 13-Oct-2017
| [Azure Storage and Azure Service Bus Queues Trigger for OpenFaaS on Kubernetes](https://github.com/danigian/Azure-Queues-Trigger-OpenFaaS) | Daniele Antonio Maggio | github.com/danigian/Azure-Queues-Trigger-OpenFaaS | 24-Sep-2017 |
| [faas-pipeline](https://github.com/getlazy/faas-pipeline) - OpenFaaS function composition | Ivan Erceg | github.com | 23-Sep-2017 |
| [Github - Reverse geocoding](https://github.com/lucj/faas-reverse-geocoding) | Luc Juggery | github.com | 14-Sep-2017 |
| [QR Code](https://github.com/faas-and-furious/qrcode) | John McCabe | github.com | 18-Aug-2017 |
| [Img2ANSI - GIF/PNG/JPG to ANSI art converter](https://github.com/johnmccabe/faas-img2ansi/) | John McCabe | github.com | 10-Aug-2017 |
| [FaaS-netes - Kubernetes backend for FaaS](https://github.com/openfaas/faas-netes) | Alex Ellis | github.com | 25-Jul-2017 |
| [Twitter, Elastic Search and Alexa stack of functions](https://github.com/alexellis/journey-expert/tree/master/tweetstash) | Alex Ellis | github.com | 24-Apr-2017 |
| [Github - URL Shortener](https://github.com/developius/faas-node-url-shortener) | Finnian Anderson | [developius/faas-node-url-shortener](https://github.com/developius/faas-node-url-shortener) | 19-Apr-2017 |
| [Github - fibonacci numbers up to N](https://github.com/developius/faas-python-fib/) | Finnian Anderson | [developius/faas-python-fib/](https://github.com/developius/faas-python-fib/) | 19-Apr-2017 |
| [Github - ascii art generator](https://github.com/developius/faas-node-ascii) | Finnian Anderson | [developius/faas-node-ascii](https://github.com/developius/faas-node-ascii) | 17-Apr-2017 |
| [Dockercon FaaS demos including Alexa/Github](https://github.com/alexellis/faas-dockercon) | Alex Ellis | github.com | 14-Apr-2017 |
| [Docker Birthday voting app ported to FaaS](https://github.com/alexellis/faas-example-voting-app) | Alex Ellis | github.com | 14-Apr-2017 |
| [Github-Airtable Bug Tracker integration](https://github.com/aafrey/faas-demo) | Austin Frey | github.com/aafrey/faas-demo | 10-Apr-2017 |


### OpenFaaS providers

[Back to top](#openfaas-community)

Official providers developed and supported by the OpenFaaS project

| Project name and description                                         | Author     | Site      | Status      |
|----------------------------------------------------------------------|------------|-----------|-------------|
| **faas-netes**- Kubernetes provider | OpenFaaS | [github.com](https://github.com/openfaas/faas-netes) | Supported |
| **faasd**- containerd single-host provider | OpenFaaS | [github.com](https://github.com/openfaas/faasd) | Supported |

Community providers actively being developed and/or supported by a third-party

| Project name and description                                         | Author     | Site      | Status      |
|----------------------------------------------------------------------|------------|-----------|-------------|
| **faas-nomad** - Nomad provider | Andrew Cornies & Nic Jackson (Hashicorp) | [github.com](https://github.com/hashicorp/faas-nomad) | Incubation  |
| **faas-memory** - In-memory provider | Ed Wilde / Alex Ellis | [github.com](https://github.com/openfaas-incubator/faas-memory) | Inception |
| **faas-federation** - federation provider to route between one or more providers | Ed Wilde / Alex Ellis | [github.com](https://github.com/openfaas-incubator/faas-federation) | Inception |
| **faas-fargate** - AWS Fargate provider | Edward Wilde | [github.com](https://github.com/ewilde/faas-fargate) | Incubation |
| **faas-lambda** - AWS Lambda provider | Ed Wilde / Alex Ellis | [sales@openfaas.com](mailto:sales@openfaas.com) | Incubation |

Community providers no-longer being maintained

| Project name and description                                         | Author     | Site      | Status      |
|----------------------------------------------------------------------|------------|-----------|-------------|
| **faas-swarm** - Docker Swarm provider | OpenFaaS | [github.com](https://github.com/openfaas/faas-swarm) | Deprecated |
| **faas-rancher** - Rancher/Cattle provider | Ken Fukuyama | [github.com](https://github.com/kenfdev/faas-rancher) | Inception |
| **faas-dcos** - DCOS provider | Alberto Quario | [github.com](https://github.com/realbot/faas-dcos) | Inception  |
| **faas-hyper** - Hyper.sh provider | Hyper | [github.com](https://github.com/hyperhq/faas-hyper) | Inception |
| **faas-guardian** - Guardian provider | Nigel Wright | [github.com](https://github.com/nwright-nz/openfaas-guardian-backend) | Inception |
| **faas-ecs** | Xicheng Chang (Huawei) | [github.com](https://github.com/stack360/faas-ecs) | Inception |
| **faas-opendns** | OpenDNS / Cisco / EC2  | [medium.com](https://medium.com/@codeboten/faas-tastic-implementing-the-openfaas-provider-in-24-hours-5a1f1f2f0461) | Inception |

Key:

(Status)

* Incubation - actively being developed, but not stable
* Inception - more work needed. May work in happy path scenario, but unlikely to be suitable for production

