## 依赖

- Linux | macOS | Windows
- Python 3.6+
- PyTorch 1.3+
- CUDA 9.2+ (如果您从源代码构建 PyTorch, 那么 CUDA9.0也是兼容的)
- GCC 5+
- [MMCV](https://mmcv.readthedocs.io/zh_CN/latest/#installation)
- [MMDetection](https://mmdetection.readthedocs.io/zh_CN/latest/#installation)

兼容的 MMTracking，MMCV 和 MMDetection 版本如下，请安装正确的版本以避免安装问题。

| MMTracking version |        MMCV version        |     MMDetection version      |
| :----------------: | :------------------------: | :--------------------------: |
|       master       | mmcv-full>=1.3.17, \<2.0.0 | MMDetection>=2.19.1, \<3.0.0 |
|       0.14.0       | mmcv-full>=1.3.17, \<2.0.0 | MMDetection>=2.19.1, \<3.0.0 |
|       0.13.0       | mmcv-full>=1.3.17, \<1.6.0 | MMDetection>=2.19.1, \<3.0.0 |
|       0.12.0       | mmcv-full>=1.3.17, \<1.5.0 | MMDetection>=2.19.1, \<3.0.0 |
|       0.11.0       | mmcv-full>=1.3.17, \<1.5.0 | MMDetection>=2.19.1, \<3.0.0 |
|       0.10.0       | mmcv-full>=1.3.17, \<1.5.0 | MMDetection>=2.19.1, \<3.0.0 |
|       0.9.0        | mmcv-full>=1.3.17, \<1.5.0 | MMDetection>=2.19.1, \<3.0.0 |
|       0.8.0        | mmcv-full>=1.3.8, \<1.4.0  | MMDetection>=2.14.0, \<3.0.0 |
|       0.7.0        | mmcv-full>=1.3.8, \<1.4.0  | MMDetection>=2.14.0, \<3.0.0 |
|       0.6.0        | mmcv-full>=1.3.8, \<1.4.0  | MMDetection>=2.14.0, \<3.0.0 |

## 安装

### 详细说明

1. 创建一个 conda 虚拟环境并激活它：

   ```shell
   conda create -n open-mmlab python=3.7 -y
   conda activate open-mmlab
   ```

2. 按照 [PyTorch 官网](https://pytorch.org/)安装 PyTorch 和 torchvision，例如：

   ```shell
   conda install pytorch torchvision -c pytorch
   ```

   注意：请确保 CUDA 编译版本和运行版本匹配。可以在 [PyTorch 官网](https://pytorch.org/)查看预编译包所支持的 CUDA 版本。

   `例 1` 例如在 `/usr/local/cuda` 安装了 CUDA 10.1，并想安装 PyTorch 1.5，则需要安装支持 CUDA 10.1 的预构建 PyTorch：

   ```shell
   conda install pytorch==1.5 cudatoolkit=10.1 torchvision -c pytorch
   ```

   `例 2` 例如在 `/usr/local/cuda` 安装了 CUDA 9.2，并想安装 PyTorch 1.3.1，则需要安装支持 CUDA 9.2 的预构建 PyTorch：

   ```shell
   conda install pytorch=1.3.1 cudatoolkit=9.2 torchvision=0.4.2 -c pytorch
   ```

   如果不是安装预构建的包，而是从源码中构建 PyTorch，则可以使用更多的 CUDA 版本，例如 CUDA 9.0。

3. 为 VOT 数据集测试评估安装额外库（可选）

   如果您想要在 VOT Challenge 上进行评估，请在安装 mmcv 与 mmdetection 之前安装 vot-toolkit ，以避免可能出现的一些依赖间的 numpy 版本要求冲突。

   ```shell
   pip install git+https://github.com/votchallenge/toolkit.git

   ```

4. 安装 mmcv-full，我们推荐您安装以下预构建包：

   ```shell
   # pip install mmcv-full -f https://download.openmmlab.com/mmcv/dist/{cu_version}/{torch_version}/index.html
   pip install mmcv-full -f https://download.openmmlab.com/mmcv/dist/cu102/torch1.10.0/index.html
   ```

   PyTorch 在 1.x.0 和 1.x.1 之间通常是兼容的，故 mmcv-full 只提供 1.x.0 的编译包。如果你的 PyTorch 版本是 1.x.1，你可以放心地安装在 1.x.0 版本编译的 mmcv-full。

   ```shell
   # 我们可以忽略 PyTorch 的小版本号
   pip install mmcv-full -f https://download.openmmlab.com/mmcv/dist/cu102/torch1.10/index.html
   ```

   请参阅 [MMCV](https://github.com/open-mmlab/mmcv#install-with-pip) 了解不同版本的 MMCV 与不同版本的 PyTorch 和 CUDA 的兼容情况。同时，您可以使用以下命令从源码编译 MMCV：

   ```shell
   git clone https://github.com/open-mmlab/mmcv.git
   cd mmcv
   MMCV_WITH_OPS=1 pip install -e .  # package mmcv-full will be installed after this step
   cd ..
   ```

5. 安装 MMDetection：

   ```shell
   pip install mmdet
   ```

   如果您想修改代码，也可以从源码构建 MMDetection：

   ```shell
   git clone https://github.com/open-mmlab/mmdetection.git
   cd mmdetection
   pip install -r requirements/build.txt
   pip install -v -e .  # or "python setup.py develop"
   ```

6. 将 MMTracking 仓库克隆到本地：

   ```shell
   git clone https://github.com/open-mmlab/mmtracking.git
   cd mmtracking
   ```

7. 首先安装依赖，然后安装 MMTracking：

   ```shell
   pip install -r requirements/build.txt
   pip install -v -e .  # or "python setup.py develop"
   ```

8. 安装额外的依赖：

- 为 MOTChallenge 评估：

  ```shell
  pip install git+https://github.com/JonathonLuiten/TrackEval.git
  ```

- 为 LVIS 评估：

  ```shell
  pip install git+https://github.com/lvis-dataset/lvis-api.git
  ```

- 为 TAO 评估：

  ```shell
  pip install git+https://github.com/TAO-Dataset/tao.git
  ```

注意：

(1) 按照上述说明，MMTracking 将以 `dev` 模式安装，因此在本地对代码做的任何修改都会生效，无需重新安装；

(2) 如果希望使用 `opencv-python-headless` 而不是 `opencv-python`，可以在安装 MMCV 之前安装；

### 从零开始设置脚本

假设当前已经成功安装 CUDA 10.1，这里提供了一个完整的基于 conda 安装 MMTracking 的脚本：

```shell
conda create -n open-mmlab python=3.7 -y
conda activate open-mmlab

conda install pytorch==1.6.0 torchvision==0.7.0 cudatoolkit=10.1 -c pytorch -y

pip install git+https://github.com/votchallenge/toolkit.git（可选）

# 安装最新版本的 mmcv
pip install mmcv-full -f https://download.openmmlab.com/mmcv/dist/cu101/torch1.6.0/index.html

# 安装 mmdetection
pip install mmdet

# 安装 mmtracking
git clone https://github.com/open-mmlab/mmtracking.git
cd mmtracking
pip install -r requirements/build.txt
pip install -v -e .
pip install git+https://github.com/JonathonLuiten/TrackEval.git
pip install git+https://github.com/lvis-dataset/lvis-api.git
pip install git+https://github.com/TAO-Dataset/tao.git
```

### 使用多个 MMTracking 版本进行开发

训练和测试脚本已经在 `PYTHONPATH` 中进行了修改，以确保脚本使用当前目录中的 MMTracking。

要使用环境中默认安装的 MMTracking 而不是当前正在使用的版本，可以删除出现在相关脚本中的代码：

```shell
PYTHONPATH="$(dirname $0)/..":$PYTHONPATH
```

### 验证

为了验证是否正确安装了 MMTracking 和所需的环境，我们可以运行 MOT、VID、SOT 的示例脚本。

运行 MOT 演示脚本您可以看到输出一个命名为 `mot.mp4` 的视频文件：

```shell
python demo/demo_mot_vis.py configs/mot/deepsort/sort_faster-rcnn_fpn_4e_mot17-private.py --input demo/demo.mp4 --output mot.mp4
```
