/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent;

import java.lang.reflect.Field;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.concurrent.CancellationException;
import sandbox.java.util.concurrent.CompletionException;
import sandbox.java.util.concurrent.CompletionStage;
import sandbox.java.util.concurrent.ExecutionException;
import sandbox.java.util.concurrent.Executor;
import sandbox.java.util.concurrent.ForkJoinPool;
import sandbox.java.util.concurrent.ForkJoinTask;
import sandbox.java.util.concurrent.Future;
import sandbox.java.util.concurrent.ThreadLocalRandom;
import sandbox.java.util.concurrent.TimeUnit;
import sandbox.java.util.concurrent.TimeoutException;
import sandbox.java.util.concurrent.atomic.AtomicInteger;
import sandbox.java.util.concurrent.locks.LockSupport;
import sandbox.java.util.function.BiConsumer;
import sandbox.java.util.function.BiFunction;
import sandbox.java.util.function.Consumer;
import sandbox.java.util.function.Function;
import sandbox.java.util.function.Supplier;
import sandbox.sun.misc.Unsafe;

public class CompletableFuture<T>
implements Future<T>,
CompletionStage<T> {
    static final AltResult NIL;
    volatile Object result;
    volatile WaitNode waiters;
    volatile CompletionNode completions;
    static final int NCPU;
    static final int SPINS;
    private static final Unsafe UNSAFE;
    private static final long RESULT;
    private static final long WAITERS;
    private static final long COMPLETIONS;

    final void postComplete() {
        while (true) {
            WaitNode waitNode = this.waiters;
            RuntimeCostAccounter.recordJump();
            if (waitNode == null) break;
            WaitNode waitNode2 = waitNode.next;
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
            boolean bl = UNSAFE.compareAndSwapObject((Object)this, WAITERS, (Object)waitNode, (Object)waitNode2);
            RuntimeCostAccounter.recordJump();
            if (!bl) continue;
            Thread thread = waitNode.thread;
            RuntimeCostAccounter.recordJump();
            if (thread == null) continue;
            waitNode.thread = null;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.unpark:(Ljava/lang/Thread;)V");
            LockSupport.unpark(thread);
            RuntimeCostAccounter.recordJump();
        }
        while (true) {
            CompletionNode completionNode = this.completions;
            RuntimeCostAccounter.recordJump();
            if (completionNode == null) break;
            CompletionNode completionNode2 = completionNode.next;
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
            boolean bl = UNSAFE.compareAndSwapObject((Object)this, COMPLETIONS, (Object)completionNode, (Object)completionNode2);
            RuntimeCostAccounter.recordJump();
            if (!bl) continue;
            Completion completion = completionNode.completion;
            RuntimeCostAccounter.recordJump();
            if (completion == null) continue;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$Completion.run:()V");
            completion.run();
            RuntimeCostAccounter.recordJump();
        }
    }

    final void internalComplete(T t, Throwable throwable) {
        RuntimeCostAccounter.recordJump();
        if (this.result == null) {
            AltResult altResult;
            RuntimeCostAccounter.recordJump();
            if (throwable == null) {
                RuntimeCostAccounter.recordJump();
                if (t == null) {
                    altResult = NIL;
                    RuntimeCostAccounter.recordJump();
                } else {
                    altResult = t;
                    RuntimeCostAccounter.recordJump();
                }
            } else {
                Throwable throwable2;
                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AltResult");
                boolean bl = throwable instanceof CompletionException;
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    throwable2 = throwable;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletionException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletionException.<init>:(Ljava/lang/Throwable;)V");
                    throwable2 = new CompletionException(throwable);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AltResult.<init>:(Ljava/lang/Throwable;)V");
                altResult = new AltResult(throwable2);
            }
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
            UNSAFE.compareAndSwapObject((Object)this, RESULT, null, (Object)altResult);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.postComplete:()V");
        this.postComplete();
    }

    final void helpPostComplete() {
        RuntimeCostAccounter.recordJump();
        if (this.result != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.postComplete:()V");
            this.postComplete();
        }
    }

    private Object waitingGet(boolean bl) {
        WaitNode waitNode = null;
        boolean bl2 = false;
        int n = SPINS;
        while (true) {
            Object object = this.result;
            RuntimeCostAccounter.recordJump();
            if (object != null) {
                RuntimeCostAccounter.recordJump();
                if (waitNode != null) {
                    waitNode.thread = null;
                    int n2 = waitNode.interruptControl;
                    RuntimeCostAccounter.recordJump();
                    if (n2 < 0) {
                        RuntimeCostAccounter.recordJump();
                        if (bl) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.removeWaiter:(Ljava/util/concurrent/CompletableFuture$WaitNode;)V");
                            this.removeWaiter(waitNode);
                            return null;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                        Thread thread = Thread.currentThread();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupt:()V");
                        thread.interrupt();
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.postComplete:()V");
                this.postComplete();
                return object;
            }
            RuntimeCostAccounter.recordJump();
            if (n > 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.nextSecondarySeed:()I");
                int n3 = ThreadLocalRandom.nextSecondarySeed();
                RuntimeCostAccounter.recordJump();
                if (n3 == 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.current:()Ljava/util/concurrent/ThreadLocalRandom;");
                    ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.nextInt:()I");
                    n3 = threadLocalRandom.nextInt();
                }
                RuntimeCostAccounter.recordJump();
                if (n3 >= 0) {
                    --n;
                }
                RuntimeCostAccounter.recordJump();
                continue;
            }
            RuntimeCostAccounter.recordJump();
            if (waitNode == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$WaitNode");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$WaitNode.<init>:(ZJJ)V");
                waitNode = new WaitNode(bl, 0L, 0L);
                RuntimeCostAccounter.recordJump();
                continue;
            }
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                waitNode.next = this.waiters;
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                bl2 = UNSAFE.compareAndSwapObject((Object)this, WAITERS, (Object)waitNode.next, (Object)waitNode);
                RuntimeCostAccounter.recordJump();
                continue;
            }
            RuntimeCostAccounter.recordJump();
            if (bl) {
                int n4 = waitNode.interruptControl;
                RuntimeCostAccounter.recordJump();
                if (n4 < 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.removeWaiter:(Ljava/util/concurrent/CompletableFuture$WaitNode;)V");
                    this.removeWaiter(waitNode);
                    return null;
                }
            }
            Thread thread = waitNode.thread;
            RuntimeCostAccounter.recordJump();
            if (thread == null) continue;
            RuntimeCostAccounter.recordJump();
            if (this.result != null) continue;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.managedBlock:(Ljava/util/concurrent/ForkJoinPool$ManagedBlocker;)V");
                ForkJoinPool.managedBlock(waitNode);
            }
            catch (InterruptedException interruptedException) {
                waitNode.interruptControl = -1;
                RuntimeCostAccounter.recordJump();
                continue;
            }
            RuntimeCostAccounter.recordJump();
            continue;
            break;
        }
    }

    private Object timedAwaitDone(long l) throws InterruptedException, TimeoutException {
        WaitNode waitNode = null;
        boolean bl = false;
        while (true) {
            Object object = this.result;
            RuntimeCostAccounter.recordJump();
            if (object != null) {
                RuntimeCostAccounter.recordJump();
                if (waitNode != null) {
                    waitNode.thread = null;
                    int n = waitNode.interruptControl;
                    RuntimeCostAccounter.recordJump();
                    if (n < 0) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.removeWaiter:(Ljava/util/concurrent/CompletableFuture$WaitNode;)V");
                        this.removeWaiter(waitNode);
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
                        InterruptedException interruptedException = new InterruptedException();
                        RuntimeCostAccounter.recordThrow();
                        throw interruptedException;
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.postComplete:()V");
                this.postComplete();
                return object;
            }
            RuntimeCostAccounter.recordJump();
            if (waitNode == null) {
                long l2;
                RuntimeCostAccounter.recordJump();
                if (l <= 0L) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/TimeoutException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeoutException.<init>:()V");
                    TimeoutException timeoutException = new TimeoutException();
                    RuntimeCostAccounter.recordThrow();
                    throw timeoutException;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
                long l3 = System.nanoTime() + l;
                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$WaitNode");
                RuntimeCostAccounter.recordJump();
                if (l3 == 0L) {
                    l2 = 1L;
                    RuntimeCostAccounter.recordJump();
                } else {
                    l2 = l3;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$WaitNode.<init>:(ZJJ)V");
                waitNode = new WaitNode(true, l, l2);
                RuntimeCostAccounter.recordJump();
                continue;
            }
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                waitNode.next = this.waiters;
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                bl = UNSAFE.compareAndSwapObject((Object)this, WAITERS, (Object)waitNode.next, waitNode);
                RuntimeCostAccounter.recordJump();
                continue;
            }
            int n = waitNode.interruptControl;
            RuntimeCostAccounter.recordJump();
            if (n < 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.removeWaiter:(Ljava/util/concurrent/CompletableFuture$WaitNode;)V");
                this.removeWaiter(waitNode);
                RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
                InterruptedException interruptedException = new InterruptedException();
                RuntimeCostAccounter.recordThrow();
                throw interruptedException;
            }
            long l4 = waitNode.nanos - 0L;
            long l5 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l5 <= 0) {
                RuntimeCostAccounter.recordJump();
                if (this.result != null) continue;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.removeWaiter:(Ljava/util/concurrent/CompletableFuture$WaitNode;)V");
                this.removeWaiter(waitNode);
                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/TimeoutException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeoutException.<init>:()V");
                TimeoutException timeoutException = new TimeoutException();
                RuntimeCostAccounter.recordThrow();
                throw timeoutException;
            }
            Thread thread = waitNode.thread;
            RuntimeCostAccounter.recordJump();
            if (thread == null) continue;
            RuntimeCostAccounter.recordJump();
            if (this.result != null) continue;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.managedBlock:(Ljava/util/concurrent/ForkJoinPool$ManagedBlocker;)V");
                ForkJoinPool.managedBlock(waitNode);
            }
            catch (InterruptedException interruptedException) {
                waitNode.interruptControl = -1;
                RuntimeCostAccounter.recordJump();
                continue;
            }
            RuntimeCostAccounter.recordJump();
            continue;
            break;
        }
    }

    private void removeWaiter(WaitNode waitNode) {
        block8: {
            RuntimeCostAccounter.recordJump();
            if (waitNode == null) break block8;
            waitNode.thread = null;
            block0: while (true) {
                WaitNode waitNode2 = null;
                WaitNode waitNode3 = this.waiters;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (waitNode3 == null) break block0;
                    WaitNode waitNode4 = waitNode3.next;
                    Thread thread = waitNode3.thread;
                    RuntimeCostAccounter.recordJump();
                    if (thread != null) {
                        waitNode2 = waitNode3;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordJump();
                        if (waitNode2 != null) {
                            waitNode2.next = waitNode4;
                            Thread thread2 = waitNode2.thread;
                            RuntimeCostAccounter.recordJump();
                            if (thread2 == null) {
                                RuntimeCostAccounter.recordJump();
                                continue block0;
                            }
                        } else {
                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                            boolean bl = UNSAFE.compareAndSwapObject((Object)this, WAITERS, (Object)waitNode3, (Object)waitNode4);
                            RuntimeCostAccounter.recordJump();
                            if (!bl) {
                                RuntimeCostAccounter.recordJump();
                                continue block0;
                            }
                        }
                    }
                    waitNode3 = waitNode4;
                    RuntimeCostAccounter.recordJump();
                }
                break;
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static void execAsync(Executor executor, Async async) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.commonPool:()Ljava/util/concurrent/ForkJoinPool;");
        ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();
        RuntimeCostAccounter.recordJump();
        if (executor == forkJoinPool) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.getCommonPoolParallelism:()I");
            int n = ForkJoinPool.getCommonPoolParallelism();
            RuntimeCostAccounter.recordJump();
            if (n <= 1) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/Thread");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.<init>:(Ljava/lang/Runnable;)V");
                Thread thread = new Thread(async);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.start:()V");
                thread.start();
                RuntimeCostAccounter.recordJump();
                return;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executor.execute:(Ljava/lang/Runnable;)V");
        executor.execute(async);
    }

    private <U> CompletableFuture<U> doThenApply(Function<? super T, ? extends U> function, Executor executor) {
        CompletableFuture<Object> completableFuture;
        block15: {
            Object object;
            Throwable throwable;
            block18: {
                Object object2;
                Object object3;
                block16: {
                    ThenApply<T, U> thenApply;
                    block13: {
                        RuntimeCostAccounter.recordJump();
                        if (function == null) {
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                            NullPointerException nullPointerException = new NullPointerException();
                            RuntimeCostAccounter.recordThrow();
                            throw nullPointerException;
                        }
                        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.<init>:()V");
                        completableFuture = new CompletableFuture<Object>();
                        thenApply = null;
                        object3 = this.result;
                        RuntimeCostAccounter.recordJump();
                        if (object3 == null) {
                            boolean bl;
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$CompletionNode");
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$ThenApply");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ThenApply.<init>:(Ljava/util/concurrent/CompletableFuture;Ljava/util/function/Function;Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/Executor;)V");
                            thenApply = new ThenApply<T, U>(this, function, completableFuture, executor);
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$CompletionNode.<init>:(Ljava/util/concurrent/CompletableFuture$Completion;)V");
                            object2 = new CompletionNode(thenApply);
                            do {
                                object3 = this.result;
                                RuntimeCostAccounter.recordJump();
                                if (object3 != null) break block13;
                                ((CompletionNode)object2).next = this.completions;
                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                bl = UNSAFE.compareAndSwapObject((Object)this, COMPLETIONS, (Object)((CompletionNode)object2).next, object2);
                                RuntimeCostAccounter.recordJump();
                            } while (!bl);
                            RuntimeCostAccounter.recordJump();
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    if (object3 == null) break block15;
                    RuntimeCostAccounter.recordJump();
                    if (thenApply == null) break block16;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ThenApply.compareAndSet:(II)Z");
                    boolean bl = thenApply.compareAndSet(0, 1);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block15;
                }
                boolean bl = object3 instanceof AltResult;
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    throwable = ((AltResult)object3).ex;
                    object2 = null;
                    RuntimeCostAccounter.recordJump();
                } else {
                    throwable = null;
                    object2 = object = object3;
                }
                object = null;
                RuntimeCostAccounter.recordJump();
                if (throwable == null) {
                    block14: {
                        try {
                            RuntimeCostAccounter.recordJump();
                            if (executor != null) {
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AsyncApply");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AsyncApply.<init>:(Ljava/lang/Object;Ljava/util/function/Function;Ljava/util/concurrent/CompletableFuture;)V");
                                AsyncApply<? super T, ? extends U> asyncApply = new AsyncApply<T, U>(object2, function, completableFuture);
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.execAsync:(Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture$Async;)V");
                                CompletableFuture.execAsync(executor, asyncApply);
                                RuntimeCostAccounter.recordJump();
                                break block14;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
                            object = function.apply(object2);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
                if (executor == null) break block18;
                RuntimeCostAccounter.recordJump();
                if (throwable == null) break block15;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
            completableFuture.internalComplete(object, throwable);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.helpPostComplete:()V");
        this.helpPostComplete();
        return completableFuture;
    }

    private CompletableFuture<Void> doThenAccept(Consumer<? super T> consumer, Executor executor) {
        CompletableFuture<Void> completableFuture;
        block15: {
            Throwable throwable;
            block18: {
                Object object;
                Object object2;
                block16: {
                    ThenAccept<T> thenAccept;
                    block13: {
                        RuntimeCostAccounter.recordJump();
                        if (consumer == null) {
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                            NullPointerException nullPointerException = new NullPointerException();
                            RuntimeCostAccounter.recordThrow();
                            throw nullPointerException;
                        }
                        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.<init>:()V");
                        completableFuture = new CompletableFuture<Void>();
                        thenAccept = null;
                        object2 = this.result;
                        RuntimeCostAccounter.recordJump();
                        if (object2 == null) {
                            boolean bl;
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$CompletionNode");
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$ThenAccept");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ThenAccept.<init>:(Ljava/util/concurrent/CompletableFuture;Ljava/util/function/Consumer;Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/Executor;)V");
                            thenAccept = new ThenAccept<T>(this, consumer, completableFuture, executor);
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$CompletionNode.<init>:(Ljava/util/concurrent/CompletableFuture$Completion;)V");
                            object = new CompletionNode(thenAccept);
                            do {
                                object2 = this.result;
                                RuntimeCostAccounter.recordJump();
                                if (object2 != null) break block13;
                                ((CompletionNode)object).next = this.completions;
                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                bl = UNSAFE.compareAndSwapObject((Object)this, COMPLETIONS, (Object)((CompletionNode)object).next, object);
                                RuntimeCostAccounter.recordJump();
                            } while (!bl);
                            RuntimeCostAccounter.recordJump();
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    if (object2 == null) break block15;
                    RuntimeCostAccounter.recordJump();
                    if (thenAccept == null) break block16;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ThenAccept.compareAndSet:(II)Z");
                    boolean bl = thenAccept.compareAndSet(0, 1);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block15;
                }
                boolean bl = object2 instanceof AltResult;
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    throwable = ((AltResult)object2).ex;
                    object = null;
                    RuntimeCostAccounter.recordJump();
                } else {
                    Object object3;
                    throwable = null;
                    object = object3 = object2;
                }
                RuntimeCostAccounter.recordJump();
                if (throwable == null) {
                    block14: {
                        try {
                            RuntimeCostAccounter.recordJump();
                            if (executor != null) {
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AsyncAccept");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AsyncAccept.<init>:(Ljava/lang/Object;Ljava/util/function/Consumer;Ljava/util/concurrent/CompletableFuture;)V");
                                AsyncAccept<? super T> asyncAccept = new AsyncAccept<T>(object, consumer, completableFuture);
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.execAsync:(Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture$Async;)V");
                                CompletableFuture.execAsync(executor, asyncAccept);
                                RuntimeCostAccounter.recordJump();
                                break block14;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                            consumer.accept(object);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
                if (executor == null) break block18;
                RuntimeCostAccounter.recordJump();
                if (throwable == null) break block15;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
            completableFuture.internalComplete(null, throwable);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.helpPostComplete:()V");
        this.helpPostComplete();
        return completableFuture;
    }

    private CompletableFuture<Void> doThenRun(Runnable runnable, Executor executor) {
        CompletableFuture<Void> completableFuture;
        block15: {
            Object object;
            block18: {
                Object object2;
                block16: {
                    AtomicInteger atomicInteger;
                    block13: {
                        RuntimeCostAccounter.recordJump();
                        if (runnable == null) {
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                            NullPointerException nullPointerException = new NullPointerException();
                            RuntimeCostAccounter.recordThrow();
                            throw nullPointerException;
                        }
                        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.<init>:()V");
                        completableFuture = new CompletableFuture<Void>();
                        atomicInteger = null;
                        object2 = this.result;
                        RuntimeCostAccounter.recordJump();
                        if (object2 == null) {
                            boolean bl;
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$CompletionNode");
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$ThenRun");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ThenRun.<init>:(Ljava/util/concurrent/CompletableFuture;Ljava/lang/Runnable;Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/Executor;)V");
                            atomicInteger = new ThenRun(this, runnable, completableFuture, executor);
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$CompletionNode.<init>:(Ljava/util/concurrent/CompletableFuture$Completion;)V");
                            object = new CompletionNode((Completion)atomicInteger);
                            do {
                                object2 = this.result;
                                RuntimeCostAccounter.recordJump();
                                if (object2 != null) break block13;
                                ((CompletionNode)object).next = this.completions;
                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                bl = UNSAFE.compareAndSwapObject((Object)this, COMPLETIONS, (Object)((CompletionNode)object).next, object);
                                RuntimeCostAccounter.recordJump();
                            } while (!bl);
                            RuntimeCostAccounter.recordJump();
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    if (object2 == null) break block15;
                    RuntimeCostAccounter.recordJump();
                    if (atomicInteger == null) break block16;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ThenRun.compareAndSet:(II)Z");
                    boolean bl = atomicInteger.compareAndSet(0, 1);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block15;
                }
                boolean bl = object2 instanceof AltResult;
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    object = ((AltResult)object2).ex;
                    RuntimeCostAccounter.recordJump();
                } else {
                    object = null;
                }
                RuntimeCostAccounter.recordJump();
                if (object == null) {
                    block14: {
                        try {
                            RuntimeCostAccounter.recordJump();
                            if (executor != null) {
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AsyncRun");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AsyncRun.<init>:(Ljava/lang/Runnable;Ljava/util/concurrent/CompletableFuture;)V");
                                AsyncRun asyncRun = new AsyncRun(runnable, completableFuture);
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.execAsync:(Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture$Async;)V");
                                CompletableFuture.execAsync(executor, asyncRun);
                                RuntimeCostAccounter.recordJump();
                                break block14;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runnable.run:()V");
                            runnable.run();
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
                if (executor == null) break block18;
                RuntimeCostAccounter.recordJump();
                if (object == null) break block15;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
            completableFuture.internalComplete(null, (Throwable)object);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.helpPostComplete:()V");
        this.helpPostComplete();
        return completableFuture;
    }

    private <U, V> CompletableFuture<V> doThenCombine(CompletableFuture<? extends U> completableFuture, BiFunction<? super T, ? super U, ? extends V> biFunction, Executor executor) {
        CompletableFuture<Object> completableFuture2;
        block33: {
            Object object;
            Throwable throwable;
            block36: {
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                block34: {
                    ThenCombine<T, U, V> thenCombine;
                    block30: {
                        block29: {
                            block28: {
                                block27: {
                                    RuntimeCostAccounter.recordJump();
                                    if (completableFuture == null) break block27;
                                    RuntimeCostAccounter.recordJump();
                                    if (biFunction != null) break block28;
                                }
                                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                                NullPointerException nullPointerException = new NullPointerException();
                                RuntimeCostAccounter.recordThrow();
                                throw nullPointerException;
                            }
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.<init>:()V");
                            completableFuture2 = new CompletableFuture<Object>();
                            thenCombine = null;
                            object5 = null;
                            object4 = this.result;
                            RuntimeCostAccounter.recordJump();
                            if (object4 == null) break block29;
                            object5 = completableFuture.result;
                            RuntimeCostAccounter.recordJump();
                            if (object5 != null) break block30;
                        }
                        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$ThenCombine");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ThenCombine.<init>:(Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/CompletableFuture;Ljava/util/function/BiFunction;Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/Executor;)V");
                        thenCombine = new ThenCombine<T, U, V>(this, completableFuture, biFunction, completableFuture2, executor);
                        object3 = null;
                        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$CompletionNode");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$CompletionNode.<init>:(Ljava/util/concurrent/CompletableFuture$Completion;)V");
                        object2 = new CompletionNode(thenCombine);
                        while (true) {
                            block32: {
                                block31: {
                                    RuntimeCostAccounter.recordJump();
                                    if (object4 != null) break block31;
                                    object4 = this.result;
                                    RuntimeCostAccounter.recordJump();
                                    if (object4 == null) break block32;
                                }
                                RuntimeCostAccounter.recordJump();
                                if (object5 != null) break;
                                object5 = completableFuture.result;
                                RuntimeCostAccounter.recordJump();
                                if (object5 != null) break;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (object3 != null) {
                                RuntimeCostAccounter.recordJump();
                                if (object5 != null) break;
                                ((CompletionNode)object3).next = completableFuture.completions;
                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                boolean bl = UNSAFE.compareAndSwapObject(completableFuture, COMPLETIONS, (Object)((CompletionNode)object3).next, object3);
                                RuntimeCostAccounter.recordJump();
                                if (!bl) continue;
                                RuntimeCostAccounter.recordJump();
                                break;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (object4 == null) {
                                ((CompletionNode)object2).next = this.completions;
                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                boolean bl = UNSAFE.compareAndSwapObject((Object)this, COMPLETIONS, (Object)((CompletionNode)object2).next, object2);
                                RuntimeCostAccounter.recordJump();
                                if (!bl) continue;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (object5 != null) {
                                RuntimeCostAccounter.recordJump();
                                break;
                            }
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$CompletionNode");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$CompletionNode.<init>:(Ljava/util/concurrent/CompletableFuture$Completion;)V");
                            object3 = new CompletionNode(thenCombine);
                            RuntimeCostAccounter.recordJump();
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    if (object4 == null) break block33;
                    RuntimeCostAccounter.recordJump();
                    if (object5 == null) break block33;
                    RuntimeCostAccounter.recordJump();
                    if (thenCombine == null) break block34;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ThenCombine.compareAndSet:(II)Z");
                    boolean bl = thenCombine.compareAndSet(0, 1);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block33;
                }
                boolean bl = object4 instanceof AltResult;
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    throwable = ((AltResult)object4).ex;
                    object3 = null;
                    RuntimeCostAccounter.recordJump();
                } else {
                    throwable = null;
                    object3 = object = object4;
                }
                RuntimeCostAccounter.recordJump();
                if (throwable != null) {
                    object2 = null;
                    RuntimeCostAccounter.recordJump();
                } else {
                    boolean bl2 = object5 instanceof AltResult;
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        throwable = ((AltResult)object5).ex;
                        object2 = null;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        object2 = object = object5;
                    }
                }
                object = null;
                RuntimeCostAccounter.recordJump();
                if (throwable == null) {
                    block26: {
                        try {
                            RuntimeCostAccounter.recordJump();
                            if (executor != null) {
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AsyncCombine");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AsyncCombine.<init>:(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiFunction;Ljava/util/concurrent/CompletableFuture;)V");
                                AsyncCombine<? super T, ? super U, ? extends V> asyncCombine = new AsyncCombine<T, U, V>(object3, object2, biFunction, completableFuture2);
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.execAsync:(Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture$Async;)V");
                                CompletableFuture.execAsync(executor, asyncCombine);
                                RuntimeCostAccounter.recordJump();
                                break block26;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiFunction.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                            object = biFunction.apply(object3, object2);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
                if (executor == null) break block36;
                RuntimeCostAccounter.recordJump();
                if (throwable == null) break block33;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
            completableFuture2.internalComplete(object, throwable);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.helpPostComplete:()V");
        this.helpPostComplete();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.helpPostComplete:()V");
        completableFuture.helpPostComplete();
        return completableFuture2;
    }

    private <U> CompletableFuture<Void> doThenAcceptBoth(CompletableFuture<? extends U> completableFuture, BiConsumer<? super T, ? super U> biConsumer, Executor executor) {
        CompletableFuture<Void> completableFuture2;
        block33: {
            Throwable throwable;
            block36: {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                block34: {
                    ThenAcceptBoth<T, U> thenAcceptBoth;
                    block30: {
                        block29: {
                            block28: {
                                block27: {
                                    RuntimeCostAccounter.recordJump();
                                    if (completableFuture == null) break block27;
                                    RuntimeCostAccounter.recordJump();
                                    if (biConsumer != null) break block28;
                                }
                                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                                NullPointerException nullPointerException = new NullPointerException();
                                RuntimeCostAccounter.recordThrow();
                                throw nullPointerException;
                            }
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.<init>:()V");
                            completableFuture2 = new CompletableFuture<Void>();
                            thenAcceptBoth = null;
                            object5 = null;
                            object4 = this.result;
                            RuntimeCostAccounter.recordJump();
                            if (object4 == null) break block29;
                            object5 = completableFuture.result;
                            RuntimeCostAccounter.recordJump();
                            if (object5 != null) break block30;
                        }
                        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$ThenAcceptBoth");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ThenAcceptBoth.<init>:(Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/CompletableFuture;Ljava/util/function/BiConsumer;Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/Executor;)V");
                        thenAcceptBoth = new ThenAcceptBoth<T, U>(this, completableFuture, biConsumer, completableFuture2, executor);
                        object3 = null;
                        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$CompletionNode");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$CompletionNode.<init>:(Ljava/util/concurrent/CompletableFuture$Completion;)V");
                        object2 = new CompletionNode(thenAcceptBoth);
                        while (true) {
                            block32: {
                                block31: {
                                    RuntimeCostAccounter.recordJump();
                                    if (object4 != null) break block31;
                                    object4 = this.result;
                                    RuntimeCostAccounter.recordJump();
                                    if (object4 == null) break block32;
                                }
                                RuntimeCostAccounter.recordJump();
                                if (object5 != null) break;
                                object5 = completableFuture.result;
                                RuntimeCostAccounter.recordJump();
                                if (object5 != null) break;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (object3 != null) {
                                RuntimeCostAccounter.recordJump();
                                if (object5 != null) break;
                                ((CompletionNode)object3).next = completableFuture.completions;
                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                boolean bl = UNSAFE.compareAndSwapObject(completableFuture, COMPLETIONS, (Object)((CompletionNode)object3).next, object3);
                                RuntimeCostAccounter.recordJump();
                                if (!bl) continue;
                                RuntimeCostAccounter.recordJump();
                                break;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (object4 == null) {
                                ((CompletionNode)object2).next = this.completions;
                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                boolean bl = UNSAFE.compareAndSwapObject((Object)this, COMPLETIONS, (Object)((CompletionNode)object2).next, object2);
                                RuntimeCostAccounter.recordJump();
                                if (!bl) continue;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (object5 != null) {
                                RuntimeCostAccounter.recordJump();
                                break;
                            }
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$CompletionNode");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$CompletionNode.<init>:(Ljava/util/concurrent/CompletableFuture$Completion;)V");
                            object3 = new CompletionNode(thenAcceptBoth);
                            RuntimeCostAccounter.recordJump();
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    if (object4 == null) break block33;
                    RuntimeCostAccounter.recordJump();
                    if (object5 == null) break block33;
                    RuntimeCostAccounter.recordJump();
                    if (thenAcceptBoth == null) break block34;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ThenAcceptBoth.compareAndSet:(II)Z");
                    boolean bl = thenAcceptBoth.compareAndSet(0, 1);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block33;
                }
                boolean bl = object4 instanceof AltResult;
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    throwable = ((AltResult)object4).ex;
                    object3 = null;
                    RuntimeCostAccounter.recordJump();
                } else {
                    throwable = null;
                    object3 = object = object4;
                }
                RuntimeCostAccounter.recordJump();
                if (throwable != null) {
                    object2 = null;
                    RuntimeCostAccounter.recordJump();
                } else {
                    boolean bl2 = object5 instanceof AltResult;
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        throwable = ((AltResult)object5).ex;
                        object2 = null;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        object2 = object = object5;
                    }
                }
                RuntimeCostAccounter.recordJump();
                if (throwable == null) {
                    block26: {
                        try {
                            RuntimeCostAccounter.recordJump();
                            if (executor != null) {
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AsyncAcceptBoth");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AsyncAcceptBoth.<init>:(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiConsumer;Ljava/util/concurrent/CompletableFuture;)V");
                                AsyncAcceptBoth<? super T, ? super U> asyncAcceptBoth = new AsyncAcceptBoth<T, U>(object3, object2, biConsumer, completableFuture2);
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.execAsync:(Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture$Async;)V");
                                CompletableFuture.execAsync(executor, asyncAcceptBoth);
                                RuntimeCostAccounter.recordJump();
                                break block26;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiConsumer.accept:(Ljava/lang/Object;Ljava/lang/Object;)V");
                            biConsumer.accept(object3, object2);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
                if (executor == null) break block36;
                RuntimeCostAccounter.recordJump();
                if (throwable == null) break block33;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
            completableFuture2.internalComplete(null, throwable);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.helpPostComplete:()V");
        this.helpPostComplete();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.helpPostComplete:()V");
        completableFuture.helpPostComplete();
        return completableFuture2;
    }

    private CompletableFuture<Void> doRunAfterBoth(CompletableFuture<?> completableFuture, Runnable runnable, Executor executor) {
        CompletableFuture<Void> completableFuture2;
        block31: {
            Object object;
            block34: {
                Object object2;
                Object object3;
                block32: {
                    RunAfterBoth runAfterBoth;
                    block28: {
                        block27: {
                            block26: {
                                block25: {
                                    RuntimeCostAccounter.recordJump();
                                    if (completableFuture == null) break block25;
                                    RuntimeCostAccounter.recordJump();
                                    if (runnable != null) break block26;
                                }
                                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                                NullPointerException nullPointerException = new NullPointerException();
                                RuntimeCostAccounter.recordThrow();
                                throw nullPointerException;
                            }
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.<init>:()V");
                            completableFuture2 = new CompletableFuture<Void>();
                            runAfterBoth = null;
                            object3 = null;
                            object2 = this.result;
                            RuntimeCostAccounter.recordJump();
                            if (object2 == null) break block27;
                            object3 = completableFuture.result;
                            RuntimeCostAccounter.recordJump();
                            if (object3 != null) break block28;
                        }
                        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$RunAfterBoth");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$RunAfterBoth.<init>:(Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/CompletableFuture;Ljava/lang/Runnable;Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/Executor;)V");
                        runAfterBoth = new RunAfterBoth(this, completableFuture, runnable, completableFuture2, executor);
                        object = null;
                        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$CompletionNode");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$CompletionNode.<init>:(Ljava/util/concurrent/CompletableFuture$Completion;)V");
                        CompletionNode completionNode = new CompletionNode(runAfterBoth);
                        while (true) {
                            block30: {
                                block29: {
                                    RuntimeCostAccounter.recordJump();
                                    if (object2 != null) break block29;
                                    object2 = this.result;
                                    RuntimeCostAccounter.recordJump();
                                    if (object2 == null) break block30;
                                }
                                RuntimeCostAccounter.recordJump();
                                if (object3 != null) break;
                                object3 = completableFuture.result;
                                RuntimeCostAccounter.recordJump();
                                if (object3 != null) break;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (object != null) {
                                RuntimeCostAccounter.recordJump();
                                if (object3 != null) break;
                                ((CompletionNode)object).next = completableFuture.completions;
                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                boolean bl = UNSAFE.compareAndSwapObject(completableFuture, COMPLETIONS, (Object)((CompletionNode)object).next, object);
                                RuntimeCostAccounter.recordJump();
                                if (!bl) continue;
                                RuntimeCostAccounter.recordJump();
                                break;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (object2 == null) {
                                completionNode.next = this.completions;
                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                boolean bl = UNSAFE.compareAndSwapObject((Object)this, COMPLETIONS, (Object)completionNode.next, (Object)completionNode);
                                RuntimeCostAccounter.recordJump();
                                if (!bl) continue;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (object3 != null) {
                                RuntimeCostAccounter.recordJump();
                                break;
                            }
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$CompletionNode");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$CompletionNode.<init>:(Ljava/util/concurrent/CompletableFuture$Completion;)V");
                            object = new CompletionNode(runAfterBoth);
                            RuntimeCostAccounter.recordJump();
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    if (object2 == null) break block31;
                    RuntimeCostAccounter.recordJump();
                    if (object3 == null) break block31;
                    RuntimeCostAccounter.recordJump();
                    if (runAfterBoth == null) break block32;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$RunAfterBoth.compareAndSet:(II)Z");
                    boolean bl = runAfterBoth.compareAndSet(0, 1);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block31;
                }
                boolean bl = object2 instanceof AltResult;
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    object = ((AltResult)object2).ex;
                    RuntimeCostAccounter.recordJump();
                } else {
                    object = null;
                }
                RuntimeCostAccounter.recordJump();
                if (object == null) {
                    boolean bl2 = object3 instanceof AltResult;
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        object = ((AltResult)object3).ex;
                    }
                }
                RuntimeCostAccounter.recordJump();
                if (object == null) {
                    block24: {
                        try {
                            RuntimeCostAccounter.recordJump();
                            if (executor != null) {
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AsyncRun");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AsyncRun.<init>:(Ljava/lang/Runnable;Ljava/util/concurrent/CompletableFuture;)V");
                                AsyncRun asyncRun = new AsyncRun(runnable, completableFuture2);
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.execAsync:(Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture$Async;)V");
                                CompletableFuture.execAsync(executor, asyncRun);
                                RuntimeCostAccounter.recordJump();
                                break block24;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runnable.run:()V");
                            runnable.run();
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
                if (executor == null) break block34;
                RuntimeCostAccounter.recordJump();
                if (object == null) break block31;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
            completableFuture2.internalComplete(null, (Throwable)object);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.helpPostComplete:()V");
        this.helpPostComplete();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.helpPostComplete:()V");
        completableFuture.helpPostComplete();
        return completableFuture2;
    }

    private <U> CompletableFuture<U> doApplyToEither(CompletableFuture<? extends T> completableFuture, Function<? super T, U> function, Executor executor) {
        CompletableFuture<Object> completableFuture2;
        block21: {
            Object object;
            Object object2;
            block24: {
                Object object3;
                Object object4;
                block22: {
                    block20: {
                        block19: {
                            RuntimeCostAccounter.recordJump();
                            if (completableFuture == null) break block19;
                            RuntimeCostAccounter.recordJump();
                            if (function != null) break block20;
                        }
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                        NullPointerException nullPointerException = new NullPointerException();
                        RuntimeCostAccounter.recordThrow();
                        throw nullPointerException;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.<init>:()V");
                    completableFuture2 = new CompletableFuture<Object>();
                    ApplyToEither<T, U> applyToEither = null;
                    object4 = this.result;
                    RuntimeCostAccounter.recordJump();
                    if (object4 == null) {
                        object4 = completableFuture.result;
                        RuntimeCostAccounter.recordJump();
                        if (object4 == null) {
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$ApplyToEither");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ApplyToEither.<init>:(Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/CompletableFuture;Ljava/util/function/Function;Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/Executor;)V");
                            applyToEither = new ApplyToEither<T, U>(this, completableFuture, function, completableFuture2, executor);
                            object3 = null;
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$CompletionNode");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$CompletionNode.<init>:(Ljava/util/concurrent/CompletableFuture$Completion;)V");
                            object2 = new CompletionNode(applyToEither);
                            while (true) {
                                object4 = this.result;
                                RuntimeCostAccounter.recordJump();
                                if (object4 != null) break;
                                object4 = completableFuture.result;
                                RuntimeCostAccounter.recordJump();
                                if (object4 != null) break;
                                RuntimeCostAccounter.recordJump();
                                if (object3 != null) {
                                    ((CompletionNode)object3).next = completableFuture.completions;
                                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                    boolean bl = UNSAFE.compareAndSwapObject(completableFuture, COMPLETIONS, (Object)((CompletionNode)object3).next, object3);
                                    RuntimeCostAccounter.recordJump();
                                    if (!bl) continue;
                                    RuntimeCostAccounter.recordJump();
                                    break;
                                }
                                ((CompletionNode)object2).next = this.completions;
                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                boolean bl = UNSAFE.compareAndSwapObject((Object)this, COMPLETIONS, (Object)((CompletionNode)object2).next, object2);
                                RuntimeCostAccounter.recordJump();
                                if (!bl) continue;
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$CompletionNode");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$CompletionNode.<init>:(Ljava/util/concurrent/CompletableFuture$Completion;)V");
                                object3 = new CompletionNode(applyToEither);
                                RuntimeCostAccounter.recordJump();
                            }
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    if (object4 == null) break block21;
                    RuntimeCostAccounter.recordJump();
                    if (applyToEither == null) break block22;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ApplyToEither.compareAndSet:(II)Z");
                    boolean bl = applyToEither.compareAndSet(0, 1);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block21;
                }
                boolean bl = object4 instanceof AltResult;
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    object2 = ((AltResult)object4).ex;
                    object3 = null;
                    RuntimeCostAccounter.recordJump();
                } else {
                    object2 = null;
                    object3 = object = object4;
                }
                object = null;
                RuntimeCostAccounter.recordJump();
                if (object2 == null) {
                    block18: {
                        try {
                            RuntimeCostAccounter.recordJump();
                            if (executor != null) {
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AsyncApply");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AsyncApply.<init>:(Ljava/lang/Object;Ljava/util/function/Function;Ljava/util/concurrent/CompletableFuture;)V");
                                AsyncApply<? super T, U> asyncApply = new AsyncApply<T, U>(object3, function, completableFuture2);
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.execAsync:(Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture$Async;)V");
                                CompletableFuture.execAsync(executor, asyncApply);
                                RuntimeCostAccounter.recordJump();
                                break block18;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
                            object = function.apply(object3);
                        }
                        catch (Throwable throwable) {
                            object2 = throwable;
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
                if (executor == null) break block24;
                RuntimeCostAccounter.recordJump();
                if (object2 == null) break block21;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
            completableFuture2.internalComplete(object, (Throwable)object2);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.helpPostComplete:()V");
        this.helpPostComplete();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.helpPostComplete:()V");
        completableFuture.helpPostComplete();
        return completableFuture2;
    }

    private CompletableFuture<Void> doAcceptEither(CompletableFuture<? extends T> completableFuture, Consumer<? super T> consumer, Executor executor) {
        CompletableFuture<Void> completableFuture2;
        block21: {
            Object object;
            block24: {
                Object object2;
                Object object3;
                block22: {
                    block20: {
                        block19: {
                            RuntimeCostAccounter.recordJump();
                            if (completableFuture == null) break block19;
                            RuntimeCostAccounter.recordJump();
                            if (consumer != null) break block20;
                        }
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                        NullPointerException nullPointerException = new NullPointerException();
                        RuntimeCostAccounter.recordThrow();
                        throw nullPointerException;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.<init>:()V");
                    completableFuture2 = new CompletableFuture<Void>();
                    AcceptEither<T> acceptEither = null;
                    object3 = this.result;
                    RuntimeCostAccounter.recordJump();
                    if (object3 == null) {
                        object3 = completableFuture.result;
                        RuntimeCostAccounter.recordJump();
                        if (object3 == null) {
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AcceptEither");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AcceptEither.<init>:(Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/CompletableFuture;Ljava/util/function/Consumer;Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/Executor;)V");
                            acceptEither = new AcceptEither<T>(this, completableFuture, consumer, completableFuture2, executor);
                            object2 = null;
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$CompletionNode");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$CompletionNode.<init>:(Ljava/util/concurrent/CompletableFuture$Completion;)V");
                            object = new CompletionNode(acceptEither);
                            while (true) {
                                object3 = this.result;
                                RuntimeCostAccounter.recordJump();
                                if (object3 != null) break;
                                object3 = completableFuture.result;
                                RuntimeCostAccounter.recordJump();
                                if (object3 != null) break;
                                RuntimeCostAccounter.recordJump();
                                if (object2 != null) {
                                    ((CompletionNode)object2).next = completableFuture.completions;
                                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                    boolean bl = UNSAFE.compareAndSwapObject(completableFuture, COMPLETIONS, (Object)((CompletionNode)object2).next, object2);
                                    RuntimeCostAccounter.recordJump();
                                    if (!bl) continue;
                                    RuntimeCostAccounter.recordJump();
                                    break;
                                }
                                ((CompletionNode)object).next = this.completions;
                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                boolean bl = UNSAFE.compareAndSwapObject((Object)this, COMPLETIONS, (Object)((CompletionNode)object).next, object);
                                RuntimeCostAccounter.recordJump();
                                if (!bl) continue;
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$CompletionNode");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$CompletionNode.<init>:(Ljava/util/concurrent/CompletableFuture$Completion;)V");
                                object2 = new CompletionNode(acceptEither);
                                RuntimeCostAccounter.recordJump();
                            }
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    if (object3 == null) break block21;
                    RuntimeCostAccounter.recordJump();
                    if (acceptEither == null) break block22;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AcceptEither.compareAndSet:(II)Z");
                    boolean bl = acceptEither.compareAndSet(0, 1);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block21;
                }
                boolean bl = object3 instanceof AltResult;
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    object = ((AltResult)object3).ex;
                    object2 = null;
                    RuntimeCostAccounter.recordJump();
                } else {
                    Object object4;
                    object = null;
                    object2 = object4 = object3;
                }
                RuntimeCostAccounter.recordJump();
                if (object == null) {
                    block18: {
                        try {
                            RuntimeCostAccounter.recordJump();
                            if (executor != null) {
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AsyncAccept");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AsyncAccept.<init>:(Ljava/lang/Object;Ljava/util/function/Consumer;Ljava/util/concurrent/CompletableFuture;)V");
                                AsyncAccept<? super T> asyncAccept = new AsyncAccept<T>(object2, consumer, completableFuture2);
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.execAsync:(Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture$Async;)V");
                                CompletableFuture.execAsync(executor, asyncAccept);
                                RuntimeCostAccounter.recordJump();
                                break block18;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                            consumer.accept(object2);
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
                if (executor == null) break block24;
                RuntimeCostAccounter.recordJump();
                if (object == null) break block21;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
            completableFuture2.internalComplete(null, (Throwable)object);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.helpPostComplete:()V");
        this.helpPostComplete();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.helpPostComplete:()V");
        completableFuture.helpPostComplete();
        return completableFuture2;
    }

    private CompletableFuture<Void> doRunAfterEither(CompletableFuture<?> completableFuture, Runnable runnable, Executor executor) {
        CompletableFuture<Void> completableFuture2;
        block21: {
            Object object;
            block24: {
                Object object2;
                block22: {
                    block20: {
                        block19: {
                            RuntimeCostAccounter.recordJump();
                            if (completableFuture == null) break block19;
                            RuntimeCostAccounter.recordJump();
                            if (runnable != null) break block20;
                        }
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                        NullPointerException nullPointerException = new NullPointerException();
                        RuntimeCostAccounter.recordThrow();
                        throw nullPointerException;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.<init>:()V");
                    completableFuture2 = new CompletableFuture<Void>();
                    AtomicInteger atomicInteger = null;
                    object2 = this.result;
                    RuntimeCostAccounter.recordJump();
                    if (object2 == null) {
                        object2 = completableFuture.result;
                        RuntimeCostAccounter.recordJump();
                        if (object2 == null) {
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$RunAfterEither");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$RunAfterEither.<init>:(Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/CompletableFuture;Ljava/lang/Runnable;Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/Executor;)V");
                            atomicInteger = new RunAfterEither(this, completableFuture, runnable, completableFuture2, executor);
                            object = null;
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$CompletionNode");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$CompletionNode.<init>:(Ljava/util/concurrent/CompletableFuture$Completion;)V");
                            CompletionNode completionNode = new CompletionNode((Completion)atomicInteger);
                            while (true) {
                                object2 = this.result;
                                RuntimeCostAccounter.recordJump();
                                if (object2 != null) break;
                                object2 = completableFuture.result;
                                RuntimeCostAccounter.recordJump();
                                if (object2 != null) break;
                                RuntimeCostAccounter.recordJump();
                                if (object != null) {
                                    ((CompletionNode)object).next = completableFuture.completions;
                                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                    boolean bl = UNSAFE.compareAndSwapObject(completableFuture, COMPLETIONS, (Object)((CompletionNode)object).next, object);
                                    RuntimeCostAccounter.recordJump();
                                    if (!bl) continue;
                                    RuntimeCostAccounter.recordJump();
                                    break;
                                }
                                completionNode.next = this.completions;
                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                boolean bl = UNSAFE.compareAndSwapObject((Object)this, COMPLETIONS, (Object)completionNode.next, (Object)completionNode);
                                RuntimeCostAccounter.recordJump();
                                if (!bl) continue;
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$CompletionNode");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$CompletionNode.<init>:(Ljava/util/concurrent/CompletableFuture$Completion;)V");
                                object = new CompletionNode((Completion)atomicInteger);
                                RuntimeCostAccounter.recordJump();
                            }
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    if (object2 == null) break block21;
                    RuntimeCostAccounter.recordJump();
                    if (atomicInteger == null) break block22;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$RunAfterEither.compareAndSet:(II)Z");
                    boolean bl = atomicInteger.compareAndSet(0, 1);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block21;
                }
                boolean bl = object2 instanceof AltResult;
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    object = ((AltResult)object2).ex;
                    RuntimeCostAccounter.recordJump();
                } else {
                    object = null;
                }
                RuntimeCostAccounter.recordJump();
                if (object == null) {
                    block18: {
                        try {
                            RuntimeCostAccounter.recordJump();
                            if (executor != null) {
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AsyncRun");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AsyncRun.<init>:(Ljava/lang/Runnable;Ljava/util/concurrent/CompletableFuture;)V");
                                AsyncRun asyncRun = new AsyncRun(runnable, completableFuture2);
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.execAsync:(Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture$Async;)V");
                                CompletableFuture.execAsync(executor, asyncRun);
                                RuntimeCostAccounter.recordJump();
                                break block18;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runnable.run:()V");
                            runnable.run();
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
                if (executor == null) break block24;
                RuntimeCostAccounter.recordJump();
                if (object == null) break block21;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
            completableFuture2.internalComplete(null, (Throwable)object);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.helpPostComplete:()V");
        this.helpPostComplete();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.helpPostComplete:()V");
        completableFuture.helpPostComplete();
        return completableFuture2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <U> CompletableFuture<U> doThenCompose(Function<? super T, ? extends CompletionStage<U>> function, Executor executor) {
        CompletableFuture<Object> completableFuture;
        block19: {
            Throwable throwable;
            block18: {
                CompletionStage<U> completionStage;
                CompletionStage<U> completionStage2;
                Object object;
                block20: {
                    ThenCompose<CompletionStage<U>, U> thenCompose;
                    block16: {
                        RuntimeCostAccounter.recordJump();
                        if (function == null) {
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                            NullPointerException nullPointerException = new NullPointerException();
                            RuntimeCostAccounter.recordThrow();
                            throw nullPointerException;
                        }
                        completableFuture = null;
                        thenCompose = null;
                        object = this.result;
                        RuntimeCostAccounter.recordJump();
                        if (object == null) {
                            boolean bl;
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.<init>:()V");
                            completableFuture = new CompletableFuture<T>();
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$CompletionNode");
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$ThenCompose");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ThenCompose.<init>:(Ljava/util/concurrent/CompletableFuture;Ljava/util/function/Function;Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/Executor;)V");
                            thenCompose = new ThenCompose<CompletionStage<U>, U>(this, function, completableFuture, executor);
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$CompletionNode.<init>:(Ljava/util/concurrent/CompletableFuture$Completion;)V");
                            completionStage2 = new CompletionNode(thenCompose);
                            do {
                                object = this.result;
                                RuntimeCostAccounter.recordJump();
                                if (object != null) break block16;
                                ((CompletionNode)((Object)completionStage2)).next = this.completions;
                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                bl = UNSAFE.compareAndSwapObject((Object)this, COMPLETIONS, (Object)((CompletionNode)((Object)completionStage2)).next, completionStage2);
                                RuntimeCostAccounter.recordJump();
                            } while (!bl);
                            RuntimeCostAccounter.recordJump();
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    if (object == null) break block19;
                    RuntimeCostAccounter.recordJump();
                    if (thenCompose == null) break block20;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ThenCompose.compareAndSet:(II)Z");
                    boolean bl = thenCompose.compareAndSet(0, 1);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block19;
                }
                boolean bl = object instanceof AltResult;
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    throwable = ((AltResult)object).ex;
                    completionStage2 = null;
                    RuntimeCostAccounter.recordJump();
                } else {
                    throwable = null;
                    completionStage2 = completionStage = object;
                }
                RuntimeCostAccounter.recordJump();
                if (throwable == null) {
                    RuntimeCostAccounter.recordJump();
                    if (executor != null) {
                        RuntimeCostAccounter.recordJump();
                        if (completableFuture == null) {
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.<init>:()V");
                            completableFuture = new CompletableFuture<T>();
                        }
                        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AsyncCompose");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AsyncCompose.<init>:(Ljava/lang/Object;Ljava/util/function/Function;Ljava/util/concurrent/CompletableFuture;)V");
                        AsyncCompose<CompletionStage<U>, U> asyncCompose = new AsyncCompose<CompletionStage<U>, U>(completionStage2, function, completableFuture);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.execAsync:(Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture$Async;)V");
                        CompletableFuture.execAsync(executor, asyncCompose);
                        RuntimeCostAccounter.recordJump();
                    } else {
                        block17: {
                            try {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
                                completionStage = function.apply(completionStage2);
                                RuntimeCostAccounter.recordJump();
                                if (completionStage != null) {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletionStage.toCompletableFuture:()Ljava/util/concurrent/CompletableFuture;");
                                    completableFuture = completionStage.toCompletableFuture();
                                    RuntimeCostAccounter.recordJump();
                                    if (completableFuture != null) break block17;
                                }
                                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                                throwable = new NullPointerException();
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                break block18;
                            }
                        }
                        RuntimeCostAccounter.recordJump();
                    }
                }
            }
            RuntimeCostAccounter.recordJump();
            if (completableFuture == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.<init>:()V");
                completableFuture = new CompletableFuture<T>();
            }
            RuntimeCostAccounter.recordJump();
            if (throwable != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
                completableFuture.internalComplete(null, throwable);
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.helpPostComplete:()V");
        this.helpPostComplete();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.helpPostComplete:()V");
        completableFuture.helpPostComplete();
        return completableFuture;
    }

    private CompletableFuture<T> doWhenComplete(BiConsumer<? super T, ? super Throwable> biConsumer, Executor executor) {
        CompletableFuture<Object> completableFuture;
        block16: {
            Object object;
            Object object2;
            Throwable throwable;
            Object object3;
            block19: {
                block15: {
                    Object object4;
                    block17: {
                        WhenCompleteCompletion<T> whenCompleteCompletion;
                        block14: {
                            RuntimeCostAccounter.recordJump();
                            if (biConsumer == null) {
                                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                                NullPointerException nullPointerException = new NullPointerException();
                                RuntimeCostAccounter.recordThrow();
                                throw nullPointerException;
                            }
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.<init>:()V");
                            completableFuture = new CompletableFuture<Object>();
                            whenCompleteCompletion = null;
                            object4 = this.result;
                            RuntimeCostAccounter.recordJump();
                            if (object4 == null) {
                                boolean bl;
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$CompletionNode");
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$WhenCompleteCompletion");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$WhenCompleteCompletion.<init>:(Ljava/util/concurrent/CompletableFuture;Ljava/util/function/BiConsumer;Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/Executor;)V");
                                whenCompleteCompletion = new WhenCompleteCompletion<T>(this, biConsumer, completableFuture, executor);
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$CompletionNode.<init>:(Ljava/util/concurrent/CompletableFuture$Completion;)V");
                                object3 = new CompletionNode(whenCompleteCompletion);
                                do {
                                    object4 = this.result;
                                    RuntimeCostAccounter.recordJump();
                                    if (object4 != null) break block14;
                                    ((CompletionNode)object3).next = this.completions;
                                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                    bl = UNSAFE.compareAndSwapObject((Object)this, COMPLETIONS, (Object)((CompletionNode)object3).next, object3);
                                    RuntimeCostAccounter.recordJump();
                                } while (!bl);
                                RuntimeCostAccounter.recordJump();
                            }
                        }
                        RuntimeCostAccounter.recordJump();
                        if (object4 == null) break block16;
                        RuntimeCostAccounter.recordJump();
                        if (whenCompleteCompletion == null) break block17;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$WhenCompleteCompletion.compareAndSet:(II)Z");
                        boolean bl = whenCompleteCompletion.compareAndSet(0, 1);
                        RuntimeCostAccounter.recordJump();
                        if (!bl) break block16;
                    }
                    boolean bl = object4 instanceof AltResult;
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        throwable = ((AltResult)object4).ex;
                        object3 = null;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        throwable = null;
                        object3 = object2 = object4;
                    }
                    object2 = null;
                    try {
                        RuntimeCostAccounter.recordJump();
                        if (executor != null) {
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AsyncWhenComplete");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AsyncWhenComplete.<init>:(Ljava/lang/Object;Ljava/lang/Throwable;Ljava/util/function/BiConsumer;Ljava/util/concurrent/CompletableFuture;)V");
                            AsyncWhenComplete<? super T> asyncWhenComplete = new AsyncWhenComplete<T>(object3, throwable, biConsumer, completableFuture);
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.execAsync:(Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture$Async;)V");
                            CompletableFuture.execAsync(executor, asyncWhenComplete);
                            RuntimeCostAccounter.recordJump();
                            break block15;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiConsumer.accept:(Ljava/lang/Object;Ljava/lang/Object;)V");
                        biConsumer.accept(object3, throwable);
                    }
                    catch (Throwable throwable2) {
                        object2 = throwable2;
                    }
                }
                RuntimeCostAccounter.recordJump();
                RuntimeCostAccounter.recordJump();
                if (executor == null) break block19;
                RuntimeCostAccounter.recordJump();
                if (object2 == null) break block16;
            }
            RuntimeCostAccounter.recordJump();
            if (throwable != null) {
                object = throwable;
                RuntimeCostAccounter.recordJump();
            } else {
                object = object2;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
            completableFuture.internalComplete(object3, (Throwable)object);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.helpPostComplete:()V");
        this.helpPostComplete();
        return completableFuture;
    }

    private <U> CompletableFuture<U> doHandle(BiFunction<? super T, Throwable, ? extends U> biFunction, Executor executor) {
        CompletableFuture<Object> completableFuture;
        block14: {
            Throwable throwable;
            Object object;
            block17: {
                block13: {
                    Throwable throwable2;
                    Object object2;
                    Object object3;
                    block15: {
                        HandleCompletion<T, U> handleCompletion;
                        block12: {
                            RuntimeCostAccounter.recordJump();
                            if (biFunction == null) {
                                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                                NullPointerException nullPointerException = new NullPointerException();
                                RuntimeCostAccounter.recordThrow();
                                throw nullPointerException;
                            }
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.<init>:()V");
                            completableFuture = new CompletableFuture<Object>();
                            handleCompletion = null;
                            object3 = this.result;
                            RuntimeCostAccounter.recordJump();
                            if (object3 == null) {
                                boolean bl;
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$CompletionNode");
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$HandleCompletion");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$HandleCompletion.<init>:(Ljava/util/concurrent/CompletableFuture;Ljava/util/function/BiFunction;Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/Executor;)V");
                                handleCompletion = new HandleCompletion<T, U>(this, biFunction, completableFuture, executor);
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$CompletionNode.<init>:(Ljava/util/concurrent/CompletableFuture$Completion;)V");
                                object2 = new CompletionNode(handleCompletion);
                                do {
                                    object3 = this.result;
                                    RuntimeCostAccounter.recordJump();
                                    if (object3 != null) break block12;
                                    ((CompletionNode)object2).next = this.completions;
                                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                    bl = UNSAFE.compareAndSwapObject((Object)this, COMPLETIONS, (Object)((CompletionNode)object2).next, object2);
                                    RuntimeCostAccounter.recordJump();
                                } while (!bl);
                                RuntimeCostAccounter.recordJump();
                            }
                        }
                        RuntimeCostAccounter.recordJump();
                        if (object3 == null) break block14;
                        RuntimeCostAccounter.recordJump();
                        if (handleCompletion == null) break block15;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$HandleCompletion.compareAndSet:(II)Z");
                        boolean bl = handleCompletion.compareAndSet(0, 1);
                        RuntimeCostAccounter.recordJump();
                        if (!bl) break block14;
                    }
                    boolean bl = object3 instanceof AltResult;
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        throwable2 = ((AltResult)object3).ex;
                        object2 = null;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        throwable2 = null;
                        object2 = object = object3;
                    }
                    object = null;
                    throwable = null;
                    try {
                        RuntimeCostAccounter.recordJump();
                        if (executor != null) {
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AsyncCombine");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AsyncCombine.<init>:(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiFunction;Ljava/util/concurrent/CompletableFuture;)V");
                            AsyncCombine<? super T, Throwable, ? extends U> asyncCombine = new AsyncCombine<T, Throwable, U>(object2, throwable2, biFunction, completableFuture);
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.execAsync:(Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture$Async;)V");
                            CompletableFuture.execAsync(executor, asyncCombine);
                            RuntimeCostAccounter.recordJump();
                            break block13;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiFunction.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                        object = biFunction.apply(object2, throwable2);
                        throwable = null;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        object = null;
                    }
                }
                RuntimeCostAccounter.recordJump();
                RuntimeCostAccounter.recordJump();
                if (executor == null) break block17;
                RuntimeCostAccounter.recordJump();
                if (throwable == null) break block14;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
            completableFuture.internalComplete(object, throwable);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.helpPostComplete:()V");
        this.helpPostComplete();
        return completableFuture;
    }

    public CompletableFuture() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
    }

    public static <U> CompletableFuture<U> supplyAsync(Supplier<U> supplier) {
        RuntimeCostAccounter.recordJump();
        if (supplier == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.<init>:()V");
        CompletableFuture completableFuture = new CompletableFuture();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.commonPool:()Ljava/util/concurrent/ForkJoinPool;");
        ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AsyncSupply");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AsyncSupply.<init>:(Ljava/util/function/Supplier;Ljava/util/concurrent/CompletableFuture;)V");
        AsyncSupply<U> asyncSupply = new AsyncSupply<U>(supplier, completableFuture);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.execAsync:(Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture$Async;)V");
        CompletableFuture.execAsync(forkJoinPool, asyncSupply);
        return completableFuture;
    }

    public static <U> CompletableFuture<U> supplyAsync(Supplier<U> supplier, Executor executor) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordJump();
                if (executor == null) break block2;
                RuntimeCostAccounter.recordJump();
                if (supplier != null) break block3;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.<init>:()V");
        CompletableFuture completableFuture = new CompletableFuture();
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AsyncSupply");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AsyncSupply.<init>:(Ljava/util/function/Supplier;Ljava/util/concurrent/CompletableFuture;)V");
        AsyncSupply<U> asyncSupply = new AsyncSupply<U>(supplier, completableFuture);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.execAsync:(Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture$Async;)V");
        CompletableFuture.execAsync(executor, asyncSupply);
        return completableFuture;
    }

    public static CompletableFuture<Void> runAsync(Runnable runnable) {
        RuntimeCostAccounter.recordJump();
        if (runnable == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.<init>:()V");
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.commonPool:()Ljava/util/concurrent/ForkJoinPool;");
        ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AsyncRun");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AsyncRun.<init>:(Ljava/lang/Runnable;Ljava/util/concurrent/CompletableFuture;)V");
        AsyncRun asyncRun = new AsyncRun(runnable, completableFuture);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.execAsync:(Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture$Async;)V");
        CompletableFuture.execAsync(forkJoinPool, asyncRun);
        return completableFuture;
    }

    public static CompletableFuture<Void> runAsync(Runnable runnable, Executor executor) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordJump();
                if (executor == null) break block2;
                RuntimeCostAccounter.recordJump();
                if (runnable != null) break block3;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.<init>:()V");
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AsyncRun");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AsyncRun.<init>:(Ljava/lang/Runnable;Ljava/util/concurrent/CompletableFuture;)V");
        AsyncRun asyncRun = new AsyncRun(runnable, completableFuture);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.execAsync:(Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture$Async;)V");
        CompletableFuture.execAsync(executor, asyncRun);
        return completableFuture;
    }

    public static <U> CompletableFuture<U> completedFuture(U u) {
        AltResult altResult;
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.<init>:()V");
        CompletableFuture completableFuture = new CompletableFuture();
        RuntimeCostAccounter.recordJump();
        if (u == null) {
            altResult = NIL;
            RuntimeCostAccounter.recordJump();
        } else {
            altResult = u;
        }
        completableFuture.result = altResult;
        return completableFuture;
    }

    @Override
    public boolean isDone() {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (this.result != null) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        Object object = this.result;
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.waitingGet:(Z)Ljava/lang/Object;");
            object = this.waitingGet(true);
            RuntimeCostAccounter.recordJump();
            if (object == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
                InterruptedException interruptedException = new InterruptedException();
                RuntimeCostAccounter.recordThrow();
                throw interruptedException;
            }
        }
        boolean bl = object instanceof AltResult;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            Object object2 = object;
            return (T)object2;
        }
        Throwable throwable = ((AltResult)object).ex;
        RuntimeCostAccounter.recordJump();
        if (throwable == null) {
            return null;
        }
        boolean bl2 = throwable instanceof CancellationException;
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            CancellationException cancellationException = (CancellationException)throwable;
            RuntimeCostAccounter.recordThrow();
            throw cancellationException;
        }
        boolean bl3 = throwable instanceof CompletionException;
        RuntimeCostAccounter.recordJump();
        if (bl3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Throwable.getCause:()Ljava/lang/Throwable;");
            Throwable throwable2 = throwable.getCause();
            RuntimeCostAccounter.recordJump();
            if (throwable2 != null) {
                throwable = throwable2;
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ExecutionException");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ExecutionException.<init>:(Ljava/lang/Throwable;)V");
        ExecutionException executionException = new ExecutionException(throwable);
        RuntimeCostAccounter.recordThrow();
        throw executionException;
    }

    @Override
    public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toNanos:(J)J");
        long l2 = timeUnit.toNanos(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
        boolean bl = Thread.interrupted();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
            InterruptedException interruptedException = new InterruptedException();
            RuntimeCostAccounter.recordThrow();
            throw interruptedException;
        }
        Object object = this.result;
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.timedAwaitDone:(J)Ljava/lang/Object;");
            object = this.timedAwaitDone(l2);
        }
        boolean bl2 = object instanceof AltResult;
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            Object object2 = object;
            return (T)object2;
        }
        Throwable throwable = ((AltResult)object).ex;
        RuntimeCostAccounter.recordJump();
        if (throwable == null) {
            return null;
        }
        boolean bl3 = throwable instanceof CancellationException;
        RuntimeCostAccounter.recordJump();
        if (bl3) {
            CancellationException cancellationException = (CancellationException)throwable;
            RuntimeCostAccounter.recordThrow();
            throw cancellationException;
        }
        boolean bl4 = throwable instanceof CompletionException;
        RuntimeCostAccounter.recordJump();
        if (bl4) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Throwable.getCause:()Ljava/lang/Throwable;");
            Throwable throwable2 = throwable.getCause();
            RuntimeCostAccounter.recordJump();
            if (throwable2 != null) {
                throwable = throwable2;
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ExecutionException");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ExecutionException.<init>:(Ljava/lang/Throwable;)V");
        ExecutionException executionException = new ExecutionException(throwable);
        RuntimeCostAccounter.recordThrow();
        throw executionException;
    }

    public T join() {
        Object object = this.result;
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.waitingGet:(Z)Ljava/lang/Object;");
            object = this.waitingGet(false);
        }
        boolean bl = object instanceof AltResult;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            Object object2 = object;
            return (T)object2;
        }
        Throwable throwable = ((AltResult)object).ex;
        RuntimeCostAccounter.recordJump();
        if (throwable == null) {
            return null;
        }
        boolean bl2 = throwable instanceof CancellationException;
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            CancellationException cancellationException = (CancellationException)throwable;
            RuntimeCostAccounter.recordThrow();
            throw cancellationException;
        }
        boolean bl3 = throwable instanceof CompletionException;
        RuntimeCostAccounter.recordJump();
        if (bl3) {
            CompletionException completionException = (CompletionException)throwable;
            RuntimeCostAccounter.recordThrow();
            throw completionException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletionException");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletionException.<init>:(Ljava/lang/Throwable;)V");
        CompletionException completionException = new CompletionException(throwable);
        RuntimeCostAccounter.recordThrow();
        throw completionException;
    }

    public T getNow(T t) {
        Object object = this.result;
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            return t;
        }
        boolean bl = object instanceof AltResult;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            Object object2 = object;
            return (T)object2;
        }
        Throwable throwable = ((AltResult)object).ex;
        RuntimeCostAccounter.recordJump();
        if (throwable == null) {
            return null;
        }
        boolean bl2 = throwable instanceof CancellationException;
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            CancellationException cancellationException = (CancellationException)throwable;
            RuntimeCostAccounter.recordThrow();
            throw cancellationException;
        }
        boolean bl3 = throwable instanceof CompletionException;
        RuntimeCostAccounter.recordJump();
        if (bl3) {
            CompletionException completionException = (CompletionException)throwable;
            RuntimeCostAccounter.recordThrow();
            throw completionException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletionException");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletionException.<init>:(Ljava/lang/Throwable;)V");
        CompletionException completionException = new CompletionException(throwable);
        RuntimeCostAccounter.recordThrow();
        throw completionException;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean complete(T var1_1) {
        RuntimeCostAccounter.recordJump();
        if (this.result != null) ** GOTO lbl-1000
        RuntimeCostAccounter.recordJump();
        if (var1_1 == null) {
            v0 /* !! */  = CompletableFuture.NIL;
            RuntimeCostAccounter.recordJump();
        } else {
            v0 /* !! */  = var1_1;
        }
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
        v1 = CompletableFuture.UNSAFE.compareAndSwapObject((Object)this, CompletableFuture.RESULT, null, (Object)v0 /* !! */ );
        RuntimeCostAccounter.recordJump();
        if (v1) {
            v2 = true;
            RuntimeCostAccounter.recordJump();
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        var2_2 = v2;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.postComplete:()V");
        this.postComplete();
        return var2_2;
    }

    /*
     * Unable to fully structure code
     */
    public boolean completeExceptionally(Throwable var1_1) {
        RuntimeCostAccounter.recordJump();
        if (var1_1 == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            v0 = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw v0;
        }
        RuntimeCostAccounter.recordJump();
        if (this.result != null) ** GOTO lbl-1000
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AltResult");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AltResult.<init>:(Ljava/lang/Throwable;)V");
        v1 = new AltResult(var1_1);
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
        v2 = CompletableFuture.UNSAFE.compareAndSwapObject((Object)this, CompletableFuture.RESULT, null, (Object)v1);
        RuntimeCostAccounter.recordJump();
        if (v2) {
            v3 = true;
            RuntimeCostAccounter.recordJump();
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        var2_2 = v3;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.postComplete:()V");
        this.postComplete();
        return var2_2;
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> function) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doThenApply:(Ljava/util/function/Function;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doThenApply(function, null);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> function) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.commonPool:()Ljava/util/concurrent/ForkJoinPool;");
        ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doThenApply:(Ljava/util/function/Function;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doThenApply(function, forkJoinPool);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> function, Executor executor) {
        RuntimeCostAccounter.recordJump();
        if (executor == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doThenApply:(Ljava/util/function/Function;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doThenApply(function, executor);
    }

    public CompletableFuture<Void> thenAccept(Consumer<? super T> consumer) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doThenAccept:(Ljava/util/function/Consumer;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doThenAccept(consumer, null);
    }

    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> consumer) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.commonPool:()Ljava/util/concurrent/ForkJoinPool;");
        ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doThenAccept:(Ljava/util/function/Consumer;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doThenAccept(consumer, forkJoinPool);
    }

    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> consumer, Executor executor) {
        RuntimeCostAccounter.recordJump();
        if (executor == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doThenAccept:(Ljava/util/function/Consumer;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doThenAccept(consumer, executor);
    }

    public CompletableFuture<Void> thenRun(Runnable runnable) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doThenRun:(Ljava/lang/Runnable;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doThenRun(runnable, null);
    }

    public CompletableFuture<Void> thenRunAsync(Runnable runnable) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.commonPool:()Ljava/util/concurrent/ForkJoinPool;");
        ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doThenRun:(Ljava/lang/Runnable;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doThenRun(runnable, forkJoinPool);
    }

    public CompletableFuture<Void> thenRunAsync(Runnable runnable, Executor executor) {
        RuntimeCostAccounter.recordJump();
        if (executor == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doThenRun:(Ljava/lang/Runnable;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doThenRun(runnable, executor);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombine(CompletionStage<? extends U> completionStage, BiFunction<? super T, ? super U, ? extends V> biFunction) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletionStage.toCompletableFuture:()Ljava/util/concurrent/CompletableFuture;");
        CompletableFuture<? extends U> completableFuture = completionStage.toCompletableFuture();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doThenCombine:(Ljava/util/concurrent/CompletableFuture;Ljava/util/function/BiFunction;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doThenCombine(completableFuture, biFunction, null);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> completionStage, BiFunction<? super T, ? super U, ? extends V> biFunction) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletionStage.toCompletableFuture:()Ljava/util/concurrent/CompletableFuture;");
        CompletableFuture<? extends U> completableFuture = completionStage.toCompletableFuture();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.commonPool:()Ljava/util/concurrent/ForkJoinPool;");
        ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doThenCombine:(Ljava/util/concurrent/CompletableFuture;Ljava/util/function/BiFunction;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doThenCombine(completableFuture, biFunction, forkJoinPool);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> completionStage, BiFunction<? super T, ? super U, ? extends V> biFunction, Executor executor) {
        RuntimeCostAccounter.recordJump();
        if (executor == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletionStage.toCompletableFuture:()Ljava/util/concurrent/CompletableFuture;");
        CompletableFuture<? extends U> completableFuture = completionStage.toCompletableFuture();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doThenCombine:(Ljava/util/concurrent/CompletableFuture;Ljava/util/function/BiFunction;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doThenCombine(completableFuture, biFunction, executor);
    }

    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> completionStage, BiConsumer<? super T, ? super U> biConsumer) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletionStage.toCompletableFuture:()Ljava/util/concurrent/CompletableFuture;");
        CompletableFuture<? extends U> completableFuture = completionStage.toCompletableFuture();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doThenAcceptBoth:(Ljava/util/concurrent/CompletableFuture;Ljava/util/function/BiConsumer;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doThenAcceptBoth(completableFuture, biConsumer, null);
    }

    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> completionStage, BiConsumer<? super T, ? super U> biConsumer) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletionStage.toCompletableFuture:()Ljava/util/concurrent/CompletableFuture;");
        CompletableFuture<? extends U> completableFuture = completionStage.toCompletableFuture();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.commonPool:()Ljava/util/concurrent/ForkJoinPool;");
        ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doThenAcceptBoth:(Ljava/util/concurrent/CompletableFuture;Ljava/util/function/BiConsumer;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doThenAcceptBoth(completableFuture, biConsumer, forkJoinPool);
    }

    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> completionStage, BiConsumer<? super T, ? super U> biConsumer, Executor executor) {
        RuntimeCostAccounter.recordJump();
        if (executor == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletionStage.toCompletableFuture:()Ljava/util/concurrent/CompletableFuture;");
        CompletableFuture<? extends U> completableFuture = completionStage.toCompletableFuture();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doThenAcceptBoth:(Ljava/util/concurrent/CompletableFuture;Ljava/util/function/BiConsumer;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doThenAcceptBoth(completableFuture, biConsumer, executor);
    }

    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> completionStage, Runnable runnable) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletionStage.toCompletableFuture:()Ljava/util/concurrent/CompletableFuture;");
        CompletableFuture<?> completableFuture = completionStage.toCompletableFuture();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doRunAfterBoth:(Ljava/util/concurrent/CompletableFuture;Ljava/lang/Runnable;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doRunAfterBoth(completableFuture, runnable, null);
    }

    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> completionStage, Runnable runnable) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletionStage.toCompletableFuture:()Ljava/util/concurrent/CompletableFuture;");
        CompletableFuture<?> completableFuture = completionStage.toCompletableFuture();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.commonPool:()Ljava/util/concurrent/ForkJoinPool;");
        ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doRunAfterBoth:(Ljava/util/concurrent/CompletableFuture;Ljava/lang/Runnable;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doRunAfterBoth(completableFuture, runnable, forkJoinPool);
    }

    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> completionStage, Runnable runnable, Executor executor) {
        RuntimeCostAccounter.recordJump();
        if (executor == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletionStage.toCompletableFuture:()Ljava/util/concurrent/CompletableFuture;");
        CompletableFuture<?> completableFuture = completionStage.toCompletableFuture();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doRunAfterBoth:(Ljava/util/concurrent/CompletableFuture;Ljava/lang/Runnable;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doRunAfterBoth(completableFuture, runnable, executor);
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends T> completionStage, Function<? super T, U> function) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletionStage.toCompletableFuture:()Ljava/util/concurrent/CompletableFuture;");
        CompletableFuture<? extends T> completableFuture = completionStage.toCompletableFuture();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doApplyToEither:(Ljava/util/concurrent/CompletableFuture;Ljava/util/function/Function;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doApplyToEither(completableFuture, function, null);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> completionStage, Function<? super T, U> function) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletionStage.toCompletableFuture:()Ljava/util/concurrent/CompletableFuture;");
        CompletableFuture<? extends T> completableFuture = completionStage.toCompletableFuture();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.commonPool:()Ljava/util/concurrent/ForkJoinPool;");
        ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doApplyToEither:(Ljava/util/concurrent/CompletableFuture;Ljava/util/function/Function;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doApplyToEither(completableFuture, function, forkJoinPool);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> completionStage, Function<? super T, U> function, Executor executor) {
        RuntimeCostAccounter.recordJump();
        if (executor == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletionStage.toCompletableFuture:()Ljava/util/concurrent/CompletableFuture;");
        CompletableFuture<? extends T> completableFuture = completionStage.toCompletableFuture();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doApplyToEither:(Ljava/util/concurrent/CompletableFuture;Ljava/util/function/Function;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doApplyToEither(completableFuture, function, executor);
    }

    public CompletableFuture<Void> acceptEither(CompletionStage<? extends T> completionStage, Consumer<? super T> consumer) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletionStage.toCompletableFuture:()Ljava/util/concurrent/CompletableFuture;");
        CompletableFuture<? extends T> completableFuture = completionStage.toCompletableFuture();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doAcceptEither:(Ljava/util/concurrent/CompletableFuture;Ljava/util/function/Consumer;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doAcceptEither(completableFuture, consumer, null);
    }

    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> completionStage, Consumer<? super T> consumer) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletionStage.toCompletableFuture:()Ljava/util/concurrent/CompletableFuture;");
        CompletableFuture<? extends T> completableFuture = completionStage.toCompletableFuture();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.commonPool:()Ljava/util/concurrent/ForkJoinPool;");
        ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doAcceptEither:(Ljava/util/concurrent/CompletableFuture;Ljava/util/function/Consumer;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doAcceptEither(completableFuture, consumer, forkJoinPool);
    }

    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> completionStage, Consumer<? super T> consumer, Executor executor) {
        RuntimeCostAccounter.recordJump();
        if (executor == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletionStage.toCompletableFuture:()Ljava/util/concurrent/CompletableFuture;");
        CompletableFuture<? extends T> completableFuture = completionStage.toCompletableFuture();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doAcceptEither:(Ljava/util/concurrent/CompletableFuture;Ljava/util/function/Consumer;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doAcceptEither(completableFuture, consumer, executor);
    }

    public CompletableFuture<Void> runAfterEither(CompletionStage<?> completionStage, Runnable runnable) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletionStage.toCompletableFuture:()Ljava/util/concurrent/CompletableFuture;");
        CompletableFuture<?> completableFuture = completionStage.toCompletableFuture();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doRunAfterEither:(Ljava/util/concurrent/CompletableFuture;Ljava/lang/Runnable;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doRunAfterEither(completableFuture, runnable, null);
    }

    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> completionStage, Runnable runnable) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletionStage.toCompletableFuture:()Ljava/util/concurrent/CompletableFuture;");
        CompletableFuture<?> completableFuture = completionStage.toCompletableFuture();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.commonPool:()Ljava/util/concurrent/ForkJoinPool;");
        ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doRunAfterEither:(Ljava/util/concurrent/CompletableFuture;Ljava/lang/Runnable;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doRunAfterEither(completableFuture, runnable, forkJoinPool);
    }

    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> completionStage, Runnable runnable, Executor executor) {
        RuntimeCostAccounter.recordJump();
        if (executor == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletionStage.toCompletableFuture:()Ljava/util/concurrent/CompletableFuture;");
        CompletableFuture<?> completableFuture = completionStage.toCompletableFuture();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doRunAfterEither:(Ljava/util/concurrent/CompletableFuture;Ljava/lang/Runnable;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doRunAfterEither(completableFuture, runnable, executor);
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> function) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doThenCompose:(Ljava/util/function/Function;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doThenCompose(function, null);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> function) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.commonPool:()Ljava/util/concurrent/ForkJoinPool;");
        ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doThenCompose:(Ljava/util/function/Function;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doThenCompose(function, forkJoinPool);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> function, Executor executor) {
        RuntimeCostAccounter.recordJump();
        if (executor == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doThenCompose:(Ljava/util/function/Function;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doThenCompose(function, executor);
    }

    @Override
    public CompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> biConsumer) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doWhenComplete:(Ljava/util/function/BiConsumer;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doWhenComplete(biConsumer, null);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> biConsumer) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.commonPool:()Ljava/util/concurrent/ForkJoinPool;");
        ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doWhenComplete:(Ljava/util/function/BiConsumer;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doWhenComplete(biConsumer, forkJoinPool);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> biConsumer, Executor executor) {
        RuntimeCostAccounter.recordJump();
        if (executor == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doWhenComplete:(Ljava/util/function/BiConsumer;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doWhenComplete(biConsumer, executor);
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> biFunction) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doHandle:(Ljava/util/function/BiFunction;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doHandle(biFunction, null);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> biFunction) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.commonPool:()Ljava/util/concurrent/ForkJoinPool;");
        ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doHandle:(Ljava/util/function/BiFunction;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doHandle(biFunction, forkJoinPool);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> biFunction, Executor executor) {
        RuntimeCostAccounter.recordJump();
        if (executor == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.doHandle:(Ljava/util/function/BiFunction;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;");
        return this.doHandle(biFunction, executor);
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        return this;
    }

    @Override
    public CompletableFuture<T> exceptionally(Function<Throwable, ? extends T> function) {
        CompletableFuture<Object> completableFuture;
        block6: {
            Throwable throwable;
            Object object;
            block9: {
                Object object2;
                Object object3;
                block8: {
                    block7: {
                        ExceptionCompletion<T> exceptionCompletion;
                        block5: {
                            RuntimeCostAccounter.recordJump();
                            if (function == null) {
                                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                                NullPointerException nullPointerException = new NullPointerException();
                                RuntimeCostAccounter.recordThrow();
                                throw nullPointerException;
                            }
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.<init>:()V");
                            completableFuture = new CompletableFuture<Object>();
                            exceptionCompletion = null;
                            object3 = this.result;
                            RuntimeCostAccounter.recordJump();
                            if (object3 == null) {
                                boolean bl;
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$CompletionNode");
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$ExceptionCompletion");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ExceptionCompletion.<init>:(Ljava/util/concurrent/CompletableFuture;Ljava/util/function/Function;Ljava/util/concurrent/CompletableFuture;)V");
                                exceptionCompletion = new ExceptionCompletion<T>(this, function, completableFuture);
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$CompletionNode.<init>:(Ljava/util/concurrent/CompletableFuture$Completion;)V");
                                object = new CompletionNode(exceptionCompletion);
                                do {
                                    object3 = this.result;
                                    RuntimeCostAccounter.recordJump();
                                    if (object3 != null) break block5;
                                    ((CompletionNode)object).next = this.completions;
                                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                    bl = UNSAFE.compareAndSwapObject((Object)this, COMPLETIONS, (Object)((CompletionNode)object).next, object);
                                    RuntimeCostAccounter.recordJump();
                                } while (!bl);
                                RuntimeCostAccounter.recordJump();
                            }
                        }
                        RuntimeCostAccounter.recordJump();
                        if (object3 == null) break block6;
                        RuntimeCostAccounter.recordJump();
                        if (exceptionCompletion == null) break block7;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ExceptionCompletion.compareAndSet:(II)Z");
                        boolean bl = exceptionCompletion.compareAndSet(0, 1);
                        RuntimeCostAccounter.recordJump();
                        if (!bl) break block6;
                    }
                    object = null;
                    throwable = null;
                    boolean bl = object3 instanceof AltResult;
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block8;
                    Throwable throwable2 = ((AltResult)object3).ex;
                    RuntimeCostAccounter.recordJump();
                    if (throwable2 == null) break block9;
                    try {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
                        object = function.apply(throwable2);
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordJump();
                    break block9;
                    break block9;
                }
                object = object2 = object3;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
            completableFuture.internalComplete(object, throwable);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.helpPostComplete:()V");
        this.helpPostComplete();
        return completableFuture;
    }

    public static CompletableFuture<Void> allOf(CompletableFuture<?> ... completableFutureArray) {
        CompletableFuture<Void> completableFuture;
        block12: {
            CompletableFuture<?> completableFuture2;
            block13: {
                Throwable throwable;
                Object object;
                block14: {
                    AtomicInteger atomicInteger;
                    block10: {
                        block11: {
                            int n = completableFutureArray.length;
                            RuntimeCostAccounter.recordJump();
                            if (n > 1) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.allTree:([Ljava/util/concurrent/CompletableFuture;II)Ljava/util/concurrent/CompletableFuture;");
                                return CompletableFuture.allTree(completableFutureArray, 0, n - 1);
                            }
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.<init>:()V");
                            completableFuture = new CompletableFuture<Void>();
                            RuntimeCostAccounter.recordJump();
                            if (n != 0) break block11;
                            completableFuture.result = NIL;
                            RuntimeCostAccounter.recordJump();
                            break block12;
                        }
                        completableFuture2 = completableFutureArray[0];
                        RuntimeCostAccounter.recordJump();
                        if (completableFuture2 == null) {
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                            NullPointerException nullPointerException = new NullPointerException();
                            RuntimeCostAccounter.recordThrow();
                            throw nullPointerException;
                        }
                        atomicInteger = null;
                        CompletionNode completionNode = null;
                        while (true) {
                            object = completableFuture2.result;
                            RuntimeCostAccounter.recordJump();
                            if (object != null) break block10;
                            RuntimeCostAccounter.recordJump();
                            if (atomicInteger == null) {
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$ThenPropagate");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ThenPropagate.<init>:(Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/CompletableFuture;)V");
                                atomicInteger = new ThenPropagate(completableFuture2, completableFuture);
                                RuntimeCostAccounter.recordJump();
                                continue;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (completionNode == null) {
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$CompletionNode");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$CompletionNode.<init>:(Ljava/util/concurrent/CompletableFuture$Completion;)V");
                                completionNode = new CompletionNode((Completion)atomicInteger);
                                RuntimeCostAccounter.recordJump();
                                continue;
                            }
                            completionNode.next = completableFuture2.completions;
                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                            boolean bl = UNSAFE.compareAndSwapObject(completableFuture2, COMPLETIONS, (Object)completionNode.next, (Object)completionNode);
                            RuntimeCostAccounter.recordJump();
                            if (bl) break;
                        }
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordJump();
                    if (object == null) break block13;
                    RuntimeCostAccounter.recordJump();
                    if (atomicInteger == null) break block14;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ThenPropagate.compareAndSet:(II)Z");
                    boolean bl = atomicInteger.compareAndSet(0, 1);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block13;
                }
                boolean bl = object instanceof AltResult;
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    throwable = ((AltResult)object).ex;
                    RuntimeCostAccounter.recordJump();
                } else {
                    throwable = null;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
                completableFuture.internalComplete(null, throwable);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.helpPostComplete:()V");
            completableFuture2.helpPostComplete();
        }
        return completableFuture;
    }

    private static CompletableFuture<Void> allTree(CompletableFuture<?>[] completableFutureArray, int n, int n2) {
        CompletableFuture<Void> completableFuture;
        CompletableFuture<?> completableFuture2;
        CompletableFuture<?> completableFuture3;
        block25: {
            Throwable throwable;
            Object object;
            Object object2;
            block27: {
                AndCompletion andCompletion;
                block26: {
                    block24: {
                        block21: {
                            block23: {
                                block22: {
                                    CompletableFuture<Object> completableFuture4;
                                    CompletableFuture<Object> completableFuture5;
                                    int n3 = n + n2 >>> 1;
                                    RuntimeCostAccounter.recordJump();
                                    if (n == n3) {
                                        completableFuture5 = completableFutureArray[n];
                                        RuntimeCostAccounter.recordJump();
                                    } else {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.allTree:([Ljava/util/concurrent/CompletableFuture;II)Ljava/util/concurrent/CompletableFuture;");
                                        completableFuture5 = CompletableFuture.allTree(completableFutureArray, n, n3);
                                    }
                                    completableFuture3 = completableFuture5;
                                    RuntimeCostAccounter.recordJump();
                                    if (completableFuture5 == null) break block22;
                                    RuntimeCostAccounter.recordJump();
                                    if (n2 == n3 + 1) {
                                        completableFuture4 = completableFutureArray[n2];
                                        RuntimeCostAccounter.recordJump();
                                    } else {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.allTree:([Ljava/util/concurrent/CompletableFuture;II)Ljava/util/concurrent/CompletableFuture;");
                                        completableFuture4 = CompletableFuture.allTree(completableFutureArray, n3 + 1, n2);
                                    }
                                    completableFuture2 = completableFuture4;
                                    RuntimeCostAccounter.recordJump();
                                    if (completableFuture4 != null) break block23;
                                }
                                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                                NullPointerException nullPointerException = new NullPointerException();
                                RuntimeCostAccounter.recordThrow();
                                throw nullPointerException;
                            }
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.<init>:()V");
                            completableFuture = new CompletableFuture<Void>();
                            andCompletion = null;
                            CompletionNode completionNode = null;
                            CompletionNode completionNode2 = null;
                            object2 = null;
                            object = null;
                            while (true) {
                                object2 = completableFuture3.result;
                                RuntimeCostAccounter.recordJump();
                                if (object2 != null) {
                                    object = completableFuture2.result;
                                    RuntimeCostAccounter.recordJump();
                                    if (object != null) break block21;
                                }
                                RuntimeCostAccounter.recordJump();
                                if (andCompletion == null) {
                                    RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AndCompletion");
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AndCompletion.<init>:(Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/CompletableFuture;)V");
                                    andCompletion = new AndCompletion(completableFuture3, completableFuture2, completableFuture);
                                    RuntimeCostAccounter.recordJump();
                                    continue;
                                }
                                RuntimeCostAccounter.recordJump();
                                if (completionNode == null) {
                                    RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$CompletionNode");
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$CompletionNode.<init>:(Ljava/util/concurrent/CompletableFuture$Completion;)V");
                                    completionNode = new CompletionNode(andCompletion);
                                    RuntimeCostAccounter.recordJump();
                                    continue;
                                }
                                RuntimeCostAccounter.recordJump();
                                if (completionNode2 == null) {
                                    completionNode.next = completableFuture3.completions;
                                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                    boolean bl = UNSAFE.compareAndSwapObject(completableFuture3, COMPLETIONS, (Object)completionNode.next, (Object)completionNode);
                                    RuntimeCostAccounter.recordJump();
                                    if (!bl) continue;
                                    RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$CompletionNode");
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$CompletionNode.<init>:(Ljava/util/concurrent/CompletableFuture$Completion;)V");
                                    completionNode2 = new CompletionNode(andCompletion);
                                    RuntimeCostAccounter.recordJump();
                                    continue;
                                }
                                completionNode2.next = completableFuture2.completions;
                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                boolean bl = UNSAFE.compareAndSwapObject(completableFuture2, COMPLETIONS, (Object)completionNode2.next, completionNode2);
                                RuntimeCostAccounter.recordJump();
                                if (bl) break;
                            }
                            RuntimeCostAccounter.recordJump();
                        }
                        RuntimeCostAccounter.recordJump();
                        if (object2 != null) break block24;
                        object2 = completableFuture3.result;
                        RuntimeCostAccounter.recordJump();
                        if (object2 == null) break block25;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (object != null) break block26;
                    object = completableFuture2.result;
                    RuntimeCostAccounter.recordJump();
                    if (object == null) break block25;
                }
                RuntimeCostAccounter.recordJump();
                if (andCompletion == null) break block27;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AndCompletion.compareAndSet:(II)Z");
                boolean bl = andCompletion.compareAndSet(0, 1);
                RuntimeCostAccounter.recordJump();
                if (!bl) break block25;
            }
            boolean bl = object2 instanceof AltResult;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                throwable = ((AltResult)object2).ex;
                RuntimeCostAccounter.recordJump();
            } else {
                throwable = null;
            }
            RuntimeCostAccounter.recordJump();
            if (throwable == null) {
                boolean bl2 = object instanceof AltResult;
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    throwable = ((AltResult)object).ex;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
            completableFuture.internalComplete(null, throwable);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.helpPostComplete:()V");
        completableFuture3.helpPostComplete();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.helpPostComplete:()V");
        completableFuture2.helpPostComplete();
        return completableFuture;
    }

    public static CompletableFuture<Object> anyOf(CompletableFuture<?> ... completableFutureArray) {
        CompletableFuture<Object> completableFuture;
        block12: {
            CompletableFuture<?> completableFuture2;
            block13: {
                Object object;
                Throwable throwable;
                Object object2;
                block14: {
                    ThenCopy<Object> thenCopy;
                    block10: {
                        block11: {
                            int n = completableFutureArray.length;
                            RuntimeCostAccounter.recordJump();
                            if (n > 1) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.anyTree:([Ljava/util/concurrent/CompletableFuture;II)Ljava/util/concurrent/CompletableFuture;");
                                return CompletableFuture.anyTree(completableFutureArray, 0, n - 1);
                            }
                            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.<init>:()V");
                            completableFuture = new CompletableFuture<Object>();
                            RuntimeCostAccounter.recordJump();
                            if (n != 0) break block11;
                            RuntimeCostAccounter.recordJump();
                            break block12;
                        }
                        completableFuture2 = completableFutureArray[0];
                        RuntimeCostAccounter.recordJump();
                        if (completableFuture2 == null) {
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                            NullPointerException nullPointerException = new NullPointerException();
                            RuntimeCostAccounter.recordThrow();
                            throw nullPointerException;
                        }
                        thenCopy = null;
                        CompletionNode completionNode = null;
                        while (true) {
                            object2 = completableFuture2.result;
                            RuntimeCostAccounter.recordJump();
                            if (object2 != null) break block10;
                            RuntimeCostAccounter.recordJump();
                            if (thenCopy == null) {
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$ThenCopy");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ThenCopy.<init>:(Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/CompletableFuture;)V");
                                thenCopy = new ThenCopy<Object>(completableFuture2, completableFuture);
                                RuntimeCostAccounter.recordJump();
                                continue;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (completionNode == null) {
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$CompletionNode");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$CompletionNode.<init>:(Ljava/util/concurrent/CompletableFuture$Completion;)V");
                                completionNode = new CompletionNode(thenCopy);
                                RuntimeCostAccounter.recordJump();
                                continue;
                            }
                            completionNode.next = completableFuture2.completions;
                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                            boolean bl = UNSAFE.compareAndSwapObject(completableFuture2, COMPLETIONS, (Object)completionNode.next, (Object)completionNode);
                            RuntimeCostAccounter.recordJump();
                            if (bl) break;
                        }
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordJump();
                    if (object2 == null) break block13;
                    RuntimeCostAccounter.recordJump();
                    if (thenCopy == null) break block14;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ThenCopy.compareAndSet:(II)Z");
                    boolean bl = thenCopy.compareAndSet(0, 1);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block13;
                }
                boolean bl = object2 instanceof AltResult;
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    throwable = ((AltResult)object2).ex;
                    object = null;
                    RuntimeCostAccounter.recordJump();
                } else {
                    throwable = null;
                    object = object2;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
                completableFuture.internalComplete(object, throwable);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.helpPostComplete:()V");
            completableFuture2.helpPostComplete();
        }
        return completableFuture;
    }

    private static CompletableFuture<Object> anyTree(CompletableFuture<?>[] completableFutureArray, int n, int n2) {
        CompletableFuture<Object> completableFuture;
        CompletableFuture<?> completableFuture2;
        CompletableFuture<?> completableFuture3;
        block20: {
            Object object;
            Throwable throwable;
            Object object2;
            block21: {
                AtomicInteger atomicInteger;
                block19: {
                    block16: {
                        block18: {
                            block17: {
                                CompletableFuture<Object> completableFuture4;
                                CompletableFuture<Object> completableFuture5;
                                int n3 = n + n2 >>> 1;
                                RuntimeCostAccounter.recordJump();
                                if (n == n3) {
                                    completableFuture5 = completableFutureArray[n];
                                    RuntimeCostAccounter.recordJump();
                                } else {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.anyTree:([Ljava/util/concurrent/CompletableFuture;II)Ljava/util/concurrent/CompletableFuture;");
                                    completableFuture5 = CompletableFuture.anyTree(completableFutureArray, n, n3);
                                }
                                completableFuture3 = completableFuture5;
                                RuntimeCostAccounter.recordJump();
                                if (completableFuture5 == null) break block17;
                                RuntimeCostAccounter.recordJump();
                                if (n2 == n3 + 1) {
                                    completableFuture4 = completableFutureArray[n2];
                                    RuntimeCostAccounter.recordJump();
                                } else {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.anyTree:([Ljava/util/concurrent/CompletableFuture;II)Ljava/util/concurrent/CompletableFuture;");
                                    completableFuture4 = CompletableFuture.anyTree(completableFutureArray, n3 + 1, n2);
                                }
                                completableFuture2 = completableFuture4;
                                RuntimeCostAccounter.recordJump();
                                if (completableFuture4 != null) break block18;
                            }
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                            NullPointerException nullPointerException = new NullPointerException();
                            RuntimeCostAccounter.recordThrow();
                            throw nullPointerException;
                        }
                        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.<init>:()V");
                        completableFuture = new CompletableFuture<Object>();
                        atomicInteger = null;
                        CompletionNode completionNode = null;
                        CompletionNode completionNode2 = null;
                        while (true) {
                            object2 = completableFuture3.result;
                            RuntimeCostAccounter.recordJump();
                            if (object2 != null) break block16;
                            object2 = completableFuture2.result;
                            RuntimeCostAccounter.recordJump();
                            if (object2 != null) break block16;
                            RuntimeCostAccounter.recordJump();
                            if (atomicInteger == null) {
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$OrCompletion");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$OrCompletion.<init>:(Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/CompletableFuture;)V");
                                atomicInteger = new OrCompletion(completableFuture3, completableFuture2, completableFuture);
                                RuntimeCostAccounter.recordJump();
                                continue;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (completionNode == null) {
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$CompletionNode");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$CompletionNode.<init>:(Ljava/util/concurrent/CompletableFuture$Completion;)V");
                                completionNode = new CompletionNode((Completion)atomicInteger);
                                RuntimeCostAccounter.recordJump();
                                continue;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (completionNode2 == null) {
                                completionNode.next = completableFuture3.completions;
                                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                boolean bl = UNSAFE.compareAndSwapObject(completableFuture3, COMPLETIONS, (Object)completionNode.next, (Object)completionNode);
                                RuntimeCostAccounter.recordJump();
                                if (!bl) continue;
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$CompletionNode");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$CompletionNode.<init>:(Ljava/util/concurrent/CompletableFuture$Completion;)V");
                                completionNode2 = new CompletionNode((Completion)atomicInteger);
                                RuntimeCostAccounter.recordJump();
                                continue;
                            }
                            completionNode2.next = completableFuture2.completions;
                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                            boolean bl = UNSAFE.compareAndSwapObject(completableFuture2, COMPLETIONS, (Object)completionNode2.next, completionNode2);
                            RuntimeCostAccounter.recordJump();
                            if (bl) break;
                        }
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordJump();
                    if (object2 != null) break block19;
                    object2 = completableFuture3.result;
                    RuntimeCostAccounter.recordJump();
                    if (object2 != null) break block19;
                    object2 = completableFuture2.result;
                    RuntimeCostAccounter.recordJump();
                    if (object2 == null) break block20;
                }
                RuntimeCostAccounter.recordJump();
                if (atomicInteger == null) break block21;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$OrCompletion.compareAndSet:(II)Z");
                boolean bl = atomicInteger.compareAndSet(0, 1);
                RuntimeCostAccounter.recordJump();
                if (!bl) break block20;
            }
            boolean bl = object2 instanceof AltResult;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                throwable = ((AltResult)object2).ex;
                object = null;
                RuntimeCostAccounter.recordJump();
            } else {
                throwable = null;
                object = object2;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
            completableFuture.internalComplete(object, throwable);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.helpPostComplete:()V");
        completableFuture3.helpPostComplete();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.helpPostComplete:()V");
        completableFuture2.helpPostComplete();
        return completableFuture;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean cancel(boolean var1_1) {
        RuntimeCostAccounter.recordJump();
        if (this.result != null) ** GOTO lbl-1000
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AltResult");
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CancellationException");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CancellationException.<init>:()V");
        v0 = new CancellationException();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AltResult.<init>:(Ljava/lang/Throwable;)V");
        v1 = new AltResult(v0);
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
        v2 = CompletableFuture.UNSAFE.compareAndSwapObject((Object)this, CompletableFuture.RESULT, null, (Object)v1);
        RuntimeCostAccounter.recordJump();
        if (v2) {
            v3 = true;
            RuntimeCostAccounter.recordJump();
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        var2_2 = v3;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.postComplete:()V");
        this.postComplete();
        RuntimeCostAccounter.recordJump();
        if (var2_2) ** GOTO lbl-1000
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.isCancelled:()Z");
        v4 = this.isCancelled();
        RuntimeCostAccounter.recordJump();
        if (v4) lbl-1000:
        // 2 sources

        {
            v5 = true;
            RuntimeCostAccounter.recordJump();
        } else {
            v5 = false;
        }
        return v5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isCancelled() {
        Object object = this.result;
        boolean bl = object instanceof AltResult;
        RuntimeCostAccounter.recordJump();
        if (!bl) return false;
        boolean bl2 = ((AltResult)object).ex instanceof CancellationException;
        RuntimeCostAccounter.recordJump();
        if (!bl2) return false;
        boolean bl3 = true;
        RuntimeCostAccounter.recordJump();
        return bl3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isCompletedExceptionally() {
        Object object = this.result;
        boolean bl = object instanceof AltResult;
        RuntimeCostAccounter.recordJump();
        if (!bl) return false;
        RuntimeCostAccounter.recordJump();
        if (object == NIL) return false;
        boolean bl2 = true;
        RuntimeCostAccounter.recordJump();
        return bl2;
    }

    public void obtrudeValue(T t) {
        AltResult altResult;
        RuntimeCostAccounter.recordJump();
        if (t == null) {
            altResult = NIL;
            RuntimeCostAccounter.recordJump();
        } else {
            altResult = t;
        }
        this.result = altResult;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.postComplete:()V");
        this.postComplete();
    }

    public void obtrudeException(Throwable throwable) {
        RuntimeCostAccounter.recordJump();
        if (throwable == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AltResult");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AltResult.<init>:(Ljava/lang/Throwable;)V");
        this.result = new AltResult(throwable);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.postComplete:()V");
        this.postComplete();
    }

    public int getNumberOfDependents() {
        int n = 0;
        CompletionNode completionNode = this.completions;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (completionNode == null) break;
            ++n;
            completionNode = completionNode.next;
            RuntimeCostAccounter.recordJump();
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public String toString() {
        block5: {
            block4: {
                var1_1 = this.result;
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                v0 = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
                v1 = super.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                v2 = v0.append(v1);
                RuntimeCostAccounter.recordJump();
                if (var1_1 != null) break block4;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.getNumberOfDependents:()I");
                var2_2 = this.getNumberOfDependents();
                RuntimeCostAccounter.recordJump();
                if (var2_2 == 0) {
                    v3 = "[Not completed]";
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    v4 = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    v5 = v4.append("[Not completed, ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                    v6 = v5.append(var2_2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    v7 = v6.append(" dependents]");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    v3 = v7.toString();
                    RuntimeCostAccounter.recordJump();
                }
                break block5;
            }
            v8 = var1_1 instanceof AltResult;
            RuntimeCostAccounter.recordJump();
            if (!v8) ** GOTO lbl-1000
            v9 = ((AltResult)var1_1).ex;
            RuntimeCostAccounter.recordJump();
            if (v9 != null) {
                v3 = "[Completed exceptionally]";
                RuntimeCostAccounter.recordJump();
            } else lbl-1000:
            // 2 sources

            {
                v3 = "[Completed normally]";
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        v10 = v2.append(v3);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return v10.toString();
    }

    static /* synthetic */ Object access$000(CompletableFuture completableFuture, boolean bl) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.waitingGet:(Z)Ljava/lang/Object;");
        return completableFuture.waitingGet(bl);
    }

    static {
        int n;
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AltResult");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AltResult.<init>:(Ljava/lang/Throwable;)V");
        NIL = new AltResult(null);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runtime.getRuntime:()Ljava/lang/Runtime;");
        Runtime runtime = Runtime.getRuntime();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runtime.availableProcessors:()I");
        NCPU = runtime.availableProcessors();
        RuntimeCostAccounter.recordJump();
        if (NCPU > 1) {
            n = 256;
            RuntimeCostAccounter.recordJump();
        } else {
            n = 0;
        }
        SPINS = n;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getUnsafe:()Lsun/misc/Unsafe;");
            UNSAFE = Unsafe.getUnsafe();
            Class<CompletableFuture> clazz = CompletableFuture.class;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field = clazz.getDeclaredField("result");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            RESULT = UNSAFE.objectFieldOffset(field);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field2 = clazz.getDeclaredField("waiters");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            WAITERS = UNSAFE.objectFieldOffset(field2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field3 = clazz.getDeclaredField("completions");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            COMPLETIONS = UNSAFE.objectFieldOffset(field3);
        }
        catch (Exception exception) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/Throwable;)V");
            Error error = new Error(exception);
            RuntimeCostAccounter.recordThrow();
            throw error;
        }
        RuntimeCostAccounter.recordJump();
    }

    static final class ThenCompose<T, U>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final Function<? super T, ? extends CompletionStage<U>> fn;
        final CompletableFuture<U> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        ThenCompose(CompletableFuture<? extends T> completableFuture, Function<? super T, ? extends CompletionStage<U>> function, CompletableFuture<U> completableFuture2, Executor executor) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$Completion.<init>:()V");
            this.src = completableFuture;
            this.fn = function;
            this.dst = completableFuture2;
            this.executor = executor;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void run() {
            block25: {
                Object object;
                block29: {
                    Object object2;
                    Throwable throwable;
                    CompletableFuture<U> completableFuture;
                    block28: {
                        boolean bl;
                        block26: {
                            Object object3;
                            Object object4;
                            block27: {
                                Object object5;
                                block24: {
                                    block23: {
                                        Object object6;
                                        completableFuture = this.dst;
                                        RuntimeCostAccounter.recordJump();
                                        if (completableFuture == null) break block25;
                                        Function<Object, CompletionStage<U>> function = this.fn;
                                        RuntimeCostAccounter.recordJump();
                                        if (function == null) break block25;
                                        CompletableFuture<? extends T> completableFuture2 = this.src;
                                        RuntimeCostAccounter.recordJump();
                                        if (completableFuture2 == null) break block25;
                                        Object object7 = completableFuture2.result;
                                        RuntimeCostAccounter.recordJump();
                                        if (object7 == null) break block25;
                                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ThenCompose.compareAndSet:(II)Z");
                                        boolean bl2 = this.compareAndSet(0, 1);
                                        RuntimeCostAccounter.recordJump();
                                        if (!bl2) break block25;
                                        boolean bl3 = object7 instanceof AltResult;
                                        RuntimeCostAccounter.recordJump();
                                        if (bl3) {
                                            throwable = ((AltResult)object7).ex;
                                            object6 = null;
                                            RuntimeCostAccounter.recordJump();
                                        } else {
                                            throwable = null;
                                            object6 = object = object7;
                                        }
                                        object = null;
                                        object2 = null;
                                        bl = false;
                                        RuntimeCostAccounter.recordJump();
                                        if (throwable == null) {
                                            Executor executor = this.executor;
                                            RuntimeCostAccounter.recordJump();
                                            if (executor != null) {
                                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AsyncCompose");
                                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AsyncCompose.<init>:(Ljava/lang/Object;Ljava/util/function/Function;Ljava/util/concurrent/CompletableFuture;)V");
                                                AsyncCompose<? super T, U> asyncCompose = new AsyncCompose<T, U>(object6, function, completableFuture);
                                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.execAsync:(Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture$Async;)V");
                                                CompletableFuture.execAsync(executor, asyncCompose);
                                                RuntimeCostAccounter.recordJump();
                                            } else {
                                                block22: {
                                                    try {
                                                        CompletableFuture<U> completableFuture3;
                                                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
                                                        object5 = function.apply(object6);
                                                        RuntimeCostAccounter.recordJump();
                                                        if (object5 == null) {
                                                            completableFuture3 = null;
                                                            RuntimeCostAccounter.recordJump();
                                                        } else {
                                                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletionStage.toCompletableFuture:()Ljava/util/concurrent/CompletableFuture;");
                                                            completableFuture3 = object5.toCompletableFuture();
                                                        }
                                                        object = completableFuture3;
                                                        RuntimeCostAccounter.recordJump();
                                                        if (object != null) break block22;
                                                        RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                                                        throwable = new NullPointerException();
                                                    }
                                                    catch (Throwable throwable2) {
                                                        throwable = throwable2;
                                                        break block23;
                                                    }
                                                }
                                                RuntimeCostAccounter.recordJump();
                                            }
                                        }
                                    }
                                    RuntimeCostAccounter.recordJump();
                                    if (object == null) break block26;
                                    object5 = null;
                                    object4 = ((CompletableFuture)object).result;
                                    RuntimeCostAccounter.recordJump();
                                    if (object4 == null) {
                                        boolean bl4;
                                        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$CompletionNode");
                                        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$ThenCopy");
                                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ThenCopy.<init>:(Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/CompletableFuture;)V");
                                        object5 = new ThenCopy<U>((CompletableFuture<?>)object, completableFuture);
                                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$CompletionNode.<init>:(Ljava/util/concurrent/CompletableFuture$Completion;)V");
                                        object3 = new CompletionNode((Completion)object5);
                                        do {
                                            object4 = ((CompletableFuture)object).result;
                                            RuntimeCostAccounter.recordJump();
                                            if (object4 != null) break block24;
                                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.access$200:()Lsun/misc/Unsafe;");
                                            Unsafe unsafe = UNSAFE;
                                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.access$100:()J");
                                            long l = COMPLETIONS;
                                            ((CompletionNode)object3).next = ((CompletableFuture)object).completions;
                                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                                            bl4 = unsafe.compareAndSwapObject(object, l, (Object)((CompletionNode)object3).next, object3);
                                            RuntimeCostAccounter.recordJump();
                                        } while (!bl4);
                                        RuntimeCostAccounter.recordJump();
                                    }
                                }
                                RuntimeCostAccounter.recordJump();
                                if (object4 == null) break block26;
                                RuntimeCostAccounter.recordJump();
                                if (object5 == null) break block27;
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ThenCopy.compareAndSet:(II)Z");
                                boolean bl5 = ((AtomicInteger)object5).compareAndSet(0, 1);
                                RuntimeCostAccounter.recordJump();
                                if (!bl5) break block26;
                            }
                            bl = true;
                            boolean bl6 = object4 instanceof AltResult;
                            RuntimeCostAccounter.recordJump();
                            if (bl6) {
                                throwable = ((AltResult)object4).ex;
                                object2 = null;
                                RuntimeCostAccounter.recordJump();
                            } else {
                                object2 = object3 = object4;
                            }
                        }
                        RuntimeCostAccounter.recordJump();
                        if (bl) break block28;
                        RuntimeCostAccounter.recordJump();
                        if (throwable == null) break block29;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
                    completableFuture.internalComplete(object2, throwable);
                }
                RuntimeCostAccounter.recordJump();
                if (object != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.helpPostComplete:()V");
                    ((CompletableFuture)object).helpPostComplete();
                }
            }
        }
    }

    static final class HandleCompletion<T, U>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final BiFunction<? super T, Throwable, ? extends U> fn;
        final CompletableFuture<U> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        HandleCompletion(CompletableFuture<? extends T> completableFuture, BiFunction<? super T, Throwable, ? extends U> biFunction, CompletableFuture<U> completableFuture2, Executor executor) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$Completion.<init>:()V");
            this.src = completableFuture;
            this.fn = biFunction;
            this.dst = completableFuture2;
            this.executor = executor;
        }

        @Override
        public final void run() {
            block10: {
                Throwable throwable;
                Object t;
                CompletableFuture<U> completableFuture;
                block12: {
                    Object object;
                    block9: {
                        Object object2;
                        Throwable throwable2;
                        completableFuture = this.dst;
                        RuntimeCostAccounter.recordJump();
                        if (completableFuture == null) break block10;
                        BiFunction<Object, Throwable, Throwable> biFunction = this.fn;
                        RuntimeCostAccounter.recordJump();
                        if (biFunction == null) break block10;
                        CompletableFuture<? extends T> completableFuture2 = this.src;
                        RuntimeCostAccounter.recordJump();
                        if (completableFuture2 == null) break block10;
                        Object object3 = completableFuture2.result;
                        RuntimeCostAccounter.recordJump();
                        if (object3 == null) break block10;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$HandleCompletion.compareAndSet:(II)Z");
                        boolean bl = this.compareAndSet(0, 1);
                        RuntimeCostAccounter.recordJump();
                        if (!bl) break block10;
                        boolean bl2 = object3 instanceof AltResult;
                        RuntimeCostAccounter.recordJump();
                        if (bl2) {
                            throwable2 = ((AltResult)object3).ex;
                            object2 = null;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            throwable2 = null;
                            object2 = object = object3;
                        }
                        object = this.executor;
                        t = null;
                        throwable = null;
                        try {
                            RuntimeCostAccounter.recordJump();
                            if (object != null) {
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AsyncCombine");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AsyncCombine.<init>:(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiFunction;Ljava/util/concurrent/CompletableFuture;)V");
                                AsyncCombine<? super T, Throwable, ? extends U> asyncCombine = new AsyncCombine<T, Throwable, U>(object2, throwable2, biFunction, completableFuture);
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.execAsync:(Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture$Async;)V");
                                CompletableFuture.execAsync((Executor)object, asyncCombine);
                                RuntimeCostAccounter.recordJump();
                                break block9;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiFunction.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                            t = biFunction.apply(object2, throwable2);
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    RuntimeCostAccounter.recordJump();
                    if (object == null) break block12;
                    RuntimeCostAccounter.recordJump();
                    if (throwable == null) break block10;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
                completableFuture.internalComplete(t, throwable);
            }
        }
    }

    static final class ThenPropagate
    extends Completion {
        final CompletableFuture<?> src;
        final CompletableFuture<Void> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        ThenPropagate(CompletableFuture<?> completableFuture, CompletableFuture<Void> completableFuture2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$Completion.<init>:()V");
            this.src = completableFuture;
            this.dst = completableFuture2;
        }

        @Override
        public final void run() {
            CompletableFuture<Void> completableFuture = this.dst;
            RuntimeCostAccounter.recordJump();
            if (completableFuture != null) {
                CompletableFuture<?> completableFuture2 = this.src;
                RuntimeCostAccounter.recordJump();
                if (completableFuture2 != null) {
                    Object object = completableFuture2.result;
                    RuntimeCostAccounter.recordJump();
                    if (object != null) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ThenPropagate.compareAndSet:(II)Z");
                        boolean bl = this.compareAndSet(0, 1);
                        RuntimeCostAccounter.recordJump();
                        if (bl) {
                            Throwable throwable;
                            boolean bl2 = object instanceof AltResult;
                            RuntimeCostAccounter.recordJump();
                            if (bl2) {
                                throwable = ((AltResult)object).ex;
                                RuntimeCostAccounter.recordJump();
                            } else {
                                throwable = null;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
                            completableFuture.internalComplete(null, throwable);
                        }
                    }
                }
            }
        }
    }

    static final class ThenCopy<T>
    extends Completion {
        final CompletableFuture<?> src;
        final CompletableFuture<T> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        ThenCopy(CompletableFuture<?> completableFuture, CompletableFuture<T> completableFuture2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$Completion.<init>:()V");
            this.src = completableFuture;
            this.dst = completableFuture2;
        }

        @Override
        public final void run() {
            CompletableFuture<Object> completableFuture = this.dst;
            RuntimeCostAccounter.recordJump();
            if (completableFuture != null) {
                CompletableFuture<?> completableFuture2 = this.src;
                RuntimeCostAccounter.recordJump();
                if (completableFuture2 != null) {
                    Object object = completableFuture2.result;
                    RuntimeCostAccounter.recordJump();
                    if (object != null) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ThenCopy.compareAndSet:(II)Z");
                        boolean bl = this.compareAndSet(0, 1);
                        RuntimeCostAccounter.recordJump();
                        if (bl) {
                            Object object2;
                            Throwable throwable;
                            boolean bl2 = object instanceof AltResult;
                            RuntimeCostAccounter.recordJump();
                            if (bl2) {
                                throwable = ((AltResult)object).ex;
                                object2 = null;
                                RuntimeCostAccounter.recordJump();
                            } else {
                                Object object3;
                                throwable = null;
                                object2 = object3 = object;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
                            completableFuture.internalComplete(object2, throwable);
                        }
                    }
                }
            }
        }
    }

    static final class WhenCompleteCompletion<T>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final BiConsumer<? super T, ? super Throwable> fn;
        final CompletableFuture<T> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        WhenCompleteCompletion(CompletableFuture<? extends T> completableFuture, BiConsumer<? super T, ? super Throwable> biConsumer, CompletableFuture<T> completableFuture2, Executor executor) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$Completion.<init>:()V");
            this.src = completableFuture;
            this.fn = biConsumer;
            this.dst = completableFuture2;
            this.executor = executor;
        }

        @Override
        public final void run() {
            block12: {
                Throwable throwable;
                Throwable throwable2;
                Object object;
                Throwable throwable3;
                CompletableFuture<Object> completableFuture;
                block14: {
                    Object object2;
                    block11: {
                        completableFuture = this.dst;
                        RuntimeCostAccounter.recordJump();
                        if (completableFuture == null) break block12;
                        BiConsumer<Object, Throwable> biConsumer = this.fn;
                        RuntimeCostAccounter.recordJump();
                        if (biConsumer == null) break block12;
                        CompletableFuture<? extends T> completableFuture2 = this.src;
                        RuntimeCostAccounter.recordJump();
                        if (completableFuture2 == null) break block12;
                        Object object3 = completableFuture2.result;
                        RuntimeCostAccounter.recordJump();
                        if (object3 == null) break block12;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$WhenCompleteCompletion.compareAndSet:(II)Z");
                        boolean bl = this.compareAndSet(0, 1);
                        RuntimeCostAccounter.recordJump();
                        if (!bl) break block12;
                        boolean bl2 = object3 instanceof AltResult;
                        RuntimeCostAccounter.recordJump();
                        if (bl2) {
                            throwable3 = ((AltResult)object3).ex;
                            object = null;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            throwable3 = null;
                            object = object2 = object3;
                        }
                        object2 = this.executor;
                        throwable2 = null;
                        try {
                            RuntimeCostAccounter.recordJump();
                            if (object2 != null) {
                                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AsyncWhenComplete");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AsyncWhenComplete.<init>:(Ljava/lang/Object;Ljava/lang/Throwable;Ljava/util/function/BiConsumer;Ljava/util/concurrent/CompletableFuture;)V");
                                AsyncWhenComplete<? super T> asyncWhenComplete = new AsyncWhenComplete<T>(object, throwable3, biConsumer, completableFuture);
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.execAsync:(Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture$Async;)V");
                                CompletableFuture.execAsync((Executor)object2, asyncWhenComplete);
                                RuntimeCostAccounter.recordJump();
                                break block11;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiConsumer.accept:(Ljava/lang/Object;Ljava/lang/Object;)V");
                            biConsumer.accept(object, throwable3);
                        }
                        catch (Throwable throwable4) {
                            throwable2 = throwable4;
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    RuntimeCostAccounter.recordJump();
                    if (object2 == null) break block14;
                    RuntimeCostAccounter.recordJump();
                    if (throwable2 == null) break block12;
                }
                RuntimeCostAccounter.recordJump();
                if (throwable3 != null) {
                    throwable = throwable3;
                    RuntimeCostAccounter.recordJump();
                } else {
                    throwable = throwable2;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
                completableFuture.internalComplete(object, throwable);
            }
        }
    }

    static final class ExceptionCompletion<T>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final Function<? super Throwable, ? extends T> fn;
        final CompletableFuture<T> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        ExceptionCompletion(CompletableFuture<? extends T> completableFuture, Function<? super Throwable, ? extends T> function, CompletableFuture<T> completableFuture2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$Completion.<init>:()V");
            this.src = completableFuture;
            this.fn = function;
            this.dst = completableFuture2;
        }

        @Override
        public final void run() {
            block2: {
                CompletableFuture<Object> completableFuture;
                Throwable throwable;
                Object object;
                block4: {
                    Object object2;
                    Object object3;
                    block3: {
                        object = null;
                        throwable = null;
                        completableFuture = this.dst;
                        RuntimeCostAccounter.recordJump();
                        if (completableFuture == null) break block2;
                        Function<Throwable, ? super Throwable> function = this.fn;
                        RuntimeCostAccounter.recordJump();
                        if (function == null) break block2;
                        CompletableFuture<? extends T> completableFuture2 = this.src;
                        RuntimeCostAccounter.recordJump();
                        if (completableFuture2 == null) break block2;
                        object3 = completableFuture2.result;
                        RuntimeCostAccounter.recordJump();
                        if (object3 == null) break block2;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ExceptionCompletion.compareAndSet:(II)Z");
                        boolean bl = this.compareAndSet(0, 1);
                        RuntimeCostAccounter.recordJump();
                        if (!bl) break block2;
                        boolean bl2 = object3 instanceof AltResult;
                        RuntimeCostAccounter.recordJump();
                        if (!bl2) break block3;
                        Throwable throwable2 = ((AltResult)object3).ex;
                        RuntimeCostAccounter.recordJump();
                        if (throwable2 == null) break block3;
                        try {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
                            object = function.apply(throwable2);
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            RuntimeCostAccounter.recordJump();
                        }
                        RuntimeCostAccounter.recordJump();
                        break block4;
                        break block4;
                    }
                    object = object2 = object3;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
                completableFuture.internalComplete(object, throwable);
            }
        }
    }

    static final class OrCompletion
    extends Completion {
        final CompletableFuture<?> src;
        final CompletableFuture<?> snd;
        final CompletableFuture<Object> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        OrCompletion(CompletableFuture<?> completableFuture, CompletableFuture<?> completableFuture2, CompletableFuture<Object> completableFuture3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$Completion.<init>:()V");
            this.src = completableFuture;
            this.snd = completableFuture2;
            this.dst = completableFuture3;
        }

        @Override
        public final void run() {
            block6: {
                Object object;
                CompletableFuture<Object> completableFuture;
                block8: {
                    block7: {
                        completableFuture = this.dst;
                        RuntimeCostAccounter.recordJump();
                        if (completableFuture == null) break block6;
                        CompletableFuture<?> completableFuture2 = this.src;
                        RuntimeCostAccounter.recordJump();
                        if (completableFuture2 == null) break block7;
                        object = completableFuture2.result;
                        RuntimeCostAccounter.recordJump();
                        if (object != null) break block8;
                    }
                    CompletableFuture<?> completableFuture3 = this.snd;
                    RuntimeCostAccounter.recordJump();
                    if (completableFuture3 == null) break block6;
                    object = completableFuture3.result;
                    RuntimeCostAccounter.recordJump();
                    if (object == null) break block6;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$OrCompletion.compareAndSet:(II)Z");
                boolean bl = this.compareAndSet(0, 1);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    Object object2;
                    Throwable throwable;
                    boolean bl2 = object instanceof AltResult;
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        throwable = ((AltResult)object).ex;
                        object2 = null;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        throwable = null;
                        object2 = object;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
                    completableFuture.internalComplete(object2, throwable);
                }
            }
        }
    }

    static final class RunAfterEither
    extends Completion {
        final CompletableFuture<?> src;
        final CompletableFuture<?> snd;
        final Runnable fn;
        final CompletableFuture<Void> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        RunAfterEither(CompletableFuture<?> completableFuture, CompletableFuture<?> completableFuture2, Runnable runnable, CompletableFuture<Void> completableFuture3, Executor executor) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$Completion.<init>:()V");
            this.src = completableFuture;
            this.snd = completableFuture2;
            this.fn = runnable;
            this.dst = completableFuture3;
            this.executor = executor;
        }

        @Override
        public final void run() {
            block11: {
                Throwable throwable;
                CompletableFuture<Void> completableFuture;
                block15: {
                    Object object;
                    Runnable runnable;
                    block13: {
                        block12: {
                            completableFuture = this.dst;
                            RuntimeCostAccounter.recordJump();
                            if (completableFuture == null) break block11;
                            runnable = this.fn;
                            RuntimeCostAccounter.recordJump();
                            if (runnable == null) break block11;
                            CompletableFuture<?> completableFuture2 = this.src;
                            RuntimeCostAccounter.recordJump();
                            if (completableFuture2 == null) break block12;
                            object = completableFuture2.result;
                            RuntimeCostAccounter.recordJump();
                            if (object != null) break block13;
                        }
                        CompletableFuture<?> completableFuture3 = this.snd;
                        RuntimeCostAccounter.recordJump();
                        if (completableFuture3 == null) break block11;
                        object = completableFuture3.result;
                        RuntimeCostAccounter.recordJump();
                        if (object == null) break block11;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$RunAfterEither.compareAndSet:(II)Z");
                    boolean bl = this.compareAndSet(0, 1);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block11;
                    boolean bl2 = object instanceof AltResult;
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        throwable = ((AltResult)object).ex;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        throwable = null;
                    }
                    Executor executor = this.executor;
                    RuntimeCostAccounter.recordJump();
                    if (throwable == null) {
                        block10: {
                            try {
                                RuntimeCostAccounter.recordJump();
                                if (executor != null) {
                                    RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AsyncRun");
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AsyncRun.<init>:(Ljava/lang/Runnable;Ljava/util/concurrent/CompletableFuture;)V");
                                    AsyncRun asyncRun = new AsyncRun(runnable, completableFuture);
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.execAsync:(Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture$Async;)V");
                                    CompletableFuture.execAsync(executor, asyncRun);
                                    RuntimeCostAccounter.recordJump();
                                    break block10;
                                }
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runnable.run:()V");
                                runnable.run();
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                            }
                        }
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordJump();
                    if (executor == null) break block15;
                    RuntimeCostAccounter.recordJump();
                    if (throwable == null) break block11;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
                completableFuture.internalComplete(null, throwable);
            }
        }
    }

    static final class AcceptEither<T>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final CompletableFuture<? extends T> snd;
        final Consumer<? super T> fn;
        final CompletableFuture<Void> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        AcceptEither(CompletableFuture<? extends T> completableFuture, CompletableFuture<? extends T> completableFuture2, Consumer<? super T> consumer, CompletableFuture<Void> completableFuture3, Executor executor) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$Completion.<init>:()V");
            this.src = completableFuture;
            this.snd = completableFuture2;
            this.fn = consumer;
            this.dst = completableFuture3;
            this.executor = executor;
        }

        @Override
        public final void run() {
            block11: {
                Throwable throwable;
                CompletableFuture<Void> completableFuture;
                block15: {
                    Object object;
                    Object object2;
                    Object object3;
                    Consumer<Object> consumer;
                    block13: {
                        block12: {
                            completableFuture = this.dst;
                            RuntimeCostAccounter.recordJump();
                            if (completableFuture == null) break block11;
                            consumer = this.fn;
                            RuntimeCostAccounter.recordJump();
                            if (consumer == null) break block11;
                            CompletableFuture<? extends T> completableFuture2 = this.src;
                            RuntimeCostAccounter.recordJump();
                            if (completableFuture2 == null) break block12;
                            object3 = completableFuture2.result;
                            RuntimeCostAccounter.recordJump();
                            if (object3 != null) break block13;
                        }
                        CompletableFuture<? extends T> completableFuture3 = this.snd;
                        RuntimeCostAccounter.recordJump();
                        if (completableFuture3 == null) break block11;
                        object3 = completableFuture3.result;
                        RuntimeCostAccounter.recordJump();
                        if (object3 == null) break block11;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AcceptEither.compareAndSet:(II)Z");
                    boolean bl = this.compareAndSet(0, 1);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block11;
                    boolean bl2 = object3 instanceof AltResult;
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        throwable = ((AltResult)object3).ex;
                        object2 = null;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        throwable = null;
                        object2 = object = object3;
                    }
                    object = this.executor;
                    RuntimeCostAccounter.recordJump();
                    if (throwable == null) {
                        block10: {
                            try {
                                RuntimeCostAccounter.recordJump();
                                if (object != null) {
                                    RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AsyncAccept");
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AsyncAccept.<init>:(Ljava/lang/Object;Ljava/util/function/Consumer;Ljava/util/concurrent/CompletableFuture;)V");
                                    AsyncAccept<? super T> asyncAccept = new AsyncAccept<T>(object2, consumer, completableFuture);
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.execAsync:(Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture$Async;)V");
                                    CompletableFuture.execAsync((Executor)object, asyncAccept);
                                    RuntimeCostAccounter.recordJump();
                                    break block10;
                                }
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                                consumer.accept(object2);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                            }
                        }
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordJump();
                    if (object == null) break block15;
                    RuntimeCostAccounter.recordJump();
                    if (throwable == null) break block11;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
                completableFuture.internalComplete(null, throwable);
            }
        }
    }

    static final class ApplyToEither<T, U>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final CompletableFuture<? extends T> snd;
        final Function<? super T, ? extends U> fn;
        final CompletableFuture<U> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        ApplyToEither(CompletableFuture<? extends T> completableFuture, CompletableFuture<? extends T> completableFuture2, Function<? super T, ? extends U> function, CompletableFuture<U> completableFuture3, Executor executor) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$Completion.<init>:()V");
            this.src = completableFuture;
            this.snd = completableFuture2;
            this.fn = function;
            this.dst = completableFuture3;
            this.executor = executor;
        }

        @Override
        public final void run() {
            block11: {
                Object t;
                Throwable throwable;
                CompletableFuture<U> completableFuture;
                block15: {
                    Object object;
                    Object object2;
                    Object object3;
                    Function<Object, U> function;
                    block13: {
                        block12: {
                            completableFuture = this.dst;
                            RuntimeCostAccounter.recordJump();
                            if (completableFuture == null) break block11;
                            function = this.fn;
                            RuntimeCostAccounter.recordJump();
                            if (function == null) break block11;
                            CompletableFuture<? extends T> completableFuture2 = this.src;
                            RuntimeCostAccounter.recordJump();
                            if (completableFuture2 == null) break block12;
                            object3 = completableFuture2.result;
                            RuntimeCostAccounter.recordJump();
                            if (object3 != null) break block13;
                        }
                        CompletableFuture<? extends T> completableFuture3 = this.snd;
                        RuntimeCostAccounter.recordJump();
                        if (completableFuture3 == null) break block11;
                        object3 = completableFuture3.result;
                        RuntimeCostAccounter.recordJump();
                        if (object3 == null) break block11;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ApplyToEither.compareAndSet:(II)Z");
                    boolean bl = this.compareAndSet(0, 1);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block11;
                    boolean bl2 = object3 instanceof AltResult;
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        throwable = ((AltResult)object3).ex;
                        object2 = null;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        throwable = null;
                        object2 = object = object3;
                    }
                    object = this.executor;
                    t = null;
                    RuntimeCostAccounter.recordJump();
                    if (throwable == null) {
                        block10: {
                            try {
                                RuntimeCostAccounter.recordJump();
                                if (object != null) {
                                    RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AsyncApply");
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AsyncApply.<init>:(Ljava/lang/Object;Ljava/util/function/Function;Ljava/util/concurrent/CompletableFuture;)V");
                                    AsyncApply<? super T, ? extends U> asyncApply = new AsyncApply<T, U>(object2, function, completableFuture);
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.execAsync:(Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture$Async;)V");
                                    CompletableFuture.execAsync((Executor)object, asyncApply);
                                    RuntimeCostAccounter.recordJump();
                                    break block10;
                                }
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
                                t = function.apply(object2);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                            }
                        }
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordJump();
                    if (object == null) break block15;
                    RuntimeCostAccounter.recordJump();
                    if (throwable == null) break block11;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
                completableFuture.internalComplete(t, throwable);
            }
        }
    }

    static final class AndCompletion
    extends Completion {
        final CompletableFuture<?> src;
        final CompletableFuture<?> snd;
        final CompletableFuture<Void> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AndCompletion(CompletableFuture<?> completableFuture, CompletableFuture<?> completableFuture2, CompletableFuture<Void> completableFuture3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$Completion.<init>:()V");
            this.src = completableFuture;
            this.snd = completableFuture2;
            this.dst = completableFuture3;
        }

        @Override
        public final void run() {
            CompletableFuture<Void> completableFuture = this.dst;
            RuntimeCostAccounter.recordJump();
            if (completableFuture != null) {
                CompletableFuture<?> completableFuture2 = this.src;
                RuntimeCostAccounter.recordJump();
                if (completableFuture2 != null) {
                    Object object = completableFuture2.result;
                    RuntimeCostAccounter.recordJump();
                    if (object != null) {
                        CompletableFuture<?> completableFuture3 = this.snd;
                        RuntimeCostAccounter.recordJump();
                        if (completableFuture3 != null) {
                            Object object2 = completableFuture3.result;
                            RuntimeCostAccounter.recordJump();
                            if (object2 != null) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AndCompletion.compareAndSet:(II)Z");
                                boolean bl = this.compareAndSet(0, 1);
                                RuntimeCostAccounter.recordJump();
                                if (bl) {
                                    Throwable throwable;
                                    boolean bl2 = object instanceof AltResult;
                                    RuntimeCostAccounter.recordJump();
                                    if (bl2) {
                                        throwable = ((AltResult)object).ex;
                                        RuntimeCostAccounter.recordJump();
                                    } else {
                                        throwable = null;
                                    }
                                    RuntimeCostAccounter.recordJump();
                                    if (throwable == null) {
                                        boolean bl3 = object2 instanceof AltResult;
                                        RuntimeCostAccounter.recordJump();
                                        if (bl3) {
                                            throwable = ((AltResult)object2).ex;
                                        }
                                    }
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
                                    completableFuture.internalComplete(null, throwable);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    static final class RunAfterBoth
    extends Completion {
        final CompletableFuture<?> src;
        final CompletableFuture<?> snd;
        final Runnable fn;
        final CompletableFuture<Void> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        RunAfterBoth(CompletableFuture<?> completableFuture, CompletableFuture<?> completableFuture2, Runnable runnable, CompletableFuture<Void> completableFuture3, Executor executor) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$Completion.<init>:()V");
            this.src = completableFuture;
            this.snd = completableFuture2;
            this.fn = runnable;
            this.dst = completableFuture3;
            this.executor = executor;
        }

        @Override
        public final void run() {
            block13: {
                Throwable throwable;
                CompletableFuture<Void> completableFuture;
                block15: {
                    completableFuture = this.dst;
                    RuntimeCostAccounter.recordJump();
                    if (completableFuture == null) break block13;
                    Runnable runnable = this.fn;
                    RuntimeCostAccounter.recordJump();
                    if (runnable == null) break block13;
                    CompletableFuture<?> completableFuture2 = this.src;
                    RuntimeCostAccounter.recordJump();
                    if (completableFuture2 == null) break block13;
                    Object object = completableFuture2.result;
                    RuntimeCostAccounter.recordJump();
                    if (object == null) break block13;
                    CompletableFuture<?> completableFuture3 = this.snd;
                    RuntimeCostAccounter.recordJump();
                    if (completableFuture3 == null) break block13;
                    Object object2 = completableFuture3.result;
                    RuntimeCostAccounter.recordJump();
                    if (object2 == null) break block13;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$RunAfterBoth.compareAndSet:(II)Z");
                    boolean bl = this.compareAndSet(0, 1);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block13;
                    boolean bl2 = object instanceof AltResult;
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        throwable = ((AltResult)object).ex;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        throwable = null;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (throwable == null) {
                        boolean bl3 = object2 instanceof AltResult;
                        RuntimeCostAccounter.recordJump();
                        if (bl3) {
                            throwable = ((AltResult)object2).ex;
                        }
                    }
                    Executor executor = this.executor;
                    RuntimeCostAccounter.recordJump();
                    if (throwable == null) {
                        block12: {
                            try {
                                RuntimeCostAccounter.recordJump();
                                if (executor != null) {
                                    RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AsyncRun");
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AsyncRun.<init>:(Ljava/lang/Runnable;Ljava/util/concurrent/CompletableFuture;)V");
                                    AsyncRun asyncRun = new AsyncRun(runnable, completableFuture);
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.execAsync:(Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture$Async;)V");
                                    CompletableFuture.execAsync(executor, asyncRun);
                                    RuntimeCostAccounter.recordJump();
                                    break block12;
                                }
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runnable.run:()V");
                                runnable.run();
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                            }
                        }
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordJump();
                    if (executor == null) break block15;
                    RuntimeCostAccounter.recordJump();
                    if (throwable == null) break block13;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
                completableFuture.internalComplete(null, throwable);
            }
        }
    }

    static final class ThenAcceptBoth<T, U>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final CompletableFuture<? extends U> snd;
        final BiConsumer<? super T, ? super U> fn;
        final CompletableFuture<Void> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        ThenAcceptBoth(CompletableFuture<? extends T> completableFuture, CompletableFuture<? extends U> completableFuture2, BiConsumer<? super T, ? super U> biConsumer, CompletableFuture<Void> completableFuture3, Executor executor) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$Completion.<init>:()V");
            this.src = completableFuture;
            this.snd = completableFuture2;
            this.fn = biConsumer;
            this.dst = completableFuture3;
            this.executor = executor;
        }

        @Override
        public final void run() {
            block15: {
                Throwable throwable;
                CompletableFuture<Void> completableFuture;
                block17: {
                    Object object;
                    Object object2;
                    Object object3;
                    completableFuture = this.dst;
                    RuntimeCostAccounter.recordJump();
                    if (completableFuture == null) break block15;
                    BiConsumer<Object, Object> biConsumer = this.fn;
                    RuntimeCostAccounter.recordJump();
                    if (biConsumer == null) break block15;
                    CompletableFuture<? extends T> completableFuture2 = this.src;
                    RuntimeCostAccounter.recordJump();
                    if (completableFuture2 == null) break block15;
                    Object object4 = completableFuture2.result;
                    RuntimeCostAccounter.recordJump();
                    if (object4 == null) break block15;
                    CompletableFuture<? extends U> completableFuture3 = this.snd;
                    RuntimeCostAccounter.recordJump();
                    if (completableFuture3 == null) break block15;
                    Object object5 = completableFuture3.result;
                    RuntimeCostAccounter.recordJump();
                    if (object5 == null) break block15;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ThenAcceptBoth.compareAndSet:(II)Z");
                    boolean bl = this.compareAndSet(0, 1);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block15;
                    boolean bl2 = object4 instanceof AltResult;
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        throwable = ((AltResult)object4).ex;
                        object3 = null;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        throwable = null;
                        object3 = object2 = object4;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (throwable != null) {
                        object = null;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        boolean bl3 = object5 instanceof AltResult;
                        RuntimeCostAccounter.recordJump();
                        if (bl3) {
                            throwable = ((AltResult)object5).ex;
                            object = null;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            object = object2 = object5;
                        }
                    }
                    object2 = this.executor;
                    RuntimeCostAccounter.recordJump();
                    if (throwable == null) {
                        block14: {
                            try {
                                RuntimeCostAccounter.recordJump();
                                if (object2 != null) {
                                    RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AsyncAcceptBoth");
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AsyncAcceptBoth.<init>:(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiConsumer;Ljava/util/concurrent/CompletableFuture;)V");
                                    AsyncAcceptBoth<? super T, ? super U> asyncAcceptBoth = new AsyncAcceptBoth<T, U>(object3, object, biConsumer, completableFuture);
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.execAsync:(Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture$Async;)V");
                                    CompletableFuture.execAsync((Executor)object2, asyncAcceptBoth);
                                    RuntimeCostAccounter.recordJump();
                                    break block14;
                                }
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiConsumer.accept:(Ljava/lang/Object;Ljava/lang/Object;)V");
                                biConsumer.accept(object3, object);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                            }
                        }
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordJump();
                    if (object2 == null) break block17;
                    RuntimeCostAccounter.recordJump();
                    if (throwable == null) break block15;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
                completableFuture.internalComplete(null, throwable);
            }
        }
    }

    static final class ThenCombine<T, U, V>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final CompletableFuture<? extends U> snd;
        final BiFunction<? super T, ? super U, ? extends V> fn;
        final CompletableFuture<V> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        ThenCombine(CompletableFuture<? extends T> completableFuture, CompletableFuture<? extends U> completableFuture2, BiFunction<? super T, ? super U, ? extends V> biFunction, CompletableFuture<V> completableFuture3, Executor executor) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$Completion.<init>:()V");
            this.src = completableFuture;
            this.snd = completableFuture2;
            this.fn = biFunction;
            this.dst = completableFuture3;
            this.executor = executor;
        }

        @Override
        public final void run() {
            block15: {
                Object t;
                Throwable throwable;
                CompletableFuture<V> completableFuture;
                block17: {
                    Object object;
                    Object object2;
                    Object object3;
                    completableFuture = this.dst;
                    RuntimeCostAccounter.recordJump();
                    if (completableFuture == null) break block15;
                    BiFunction<Object, Object, V> biFunction = this.fn;
                    RuntimeCostAccounter.recordJump();
                    if (biFunction == null) break block15;
                    CompletableFuture<? extends T> completableFuture2 = this.src;
                    RuntimeCostAccounter.recordJump();
                    if (completableFuture2 == null) break block15;
                    Object object4 = completableFuture2.result;
                    RuntimeCostAccounter.recordJump();
                    if (object4 == null) break block15;
                    CompletableFuture<? extends U> completableFuture3 = this.snd;
                    RuntimeCostAccounter.recordJump();
                    if (completableFuture3 == null) break block15;
                    Object object5 = completableFuture3.result;
                    RuntimeCostAccounter.recordJump();
                    if (object5 == null) break block15;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ThenCombine.compareAndSet:(II)Z");
                    boolean bl = this.compareAndSet(0, 1);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block15;
                    boolean bl2 = object4 instanceof AltResult;
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        throwable = ((AltResult)object4).ex;
                        object3 = null;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        throwable = null;
                        object3 = object2 = object4;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (throwable != null) {
                        object = null;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        boolean bl3 = object5 instanceof AltResult;
                        RuntimeCostAccounter.recordJump();
                        if (bl3) {
                            throwable = ((AltResult)object5).ex;
                            object = null;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            object = object2 = object5;
                        }
                    }
                    object2 = this.executor;
                    t = null;
                    RuntimeCostAccounter.recordJump();
                    if (throwable == null) {
                        block14: {
                            try {
                                RuntimeCostAccounter.recordJump();
                                if (object2 != null) {
                                    RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AsyncCombine");
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AsyncCombine.<init>:(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiFunction;Ljava/util/concurrent/CompletableFuture;)V");
                                    AsyncCombine<? super T, ? super U, ? extends V> asyncCombine = new AsyncCombine<T, U, V>(object3, object, biFunction, completableFuture);
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.execAsync:(Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture$Async;)V");
                                    CompletableFuture.execAsync((Executor)object2, asyncCombine);
                                    RuntimeCostAccounter.recordJump();
                                    break block14;
                                }
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiFunction.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                                t = biFunction.apply(object3, object);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                            }
                        }
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordJump();
                    if (object2 == null) break block17;
                    RuntimeCostAccounter.recordJump();
                    if (throwable == null) break block15;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
                completableFuture.internalComplete(t, throwable);
            }
        }
    }

    static final class ThenRun
    extends Completion {
        final CompletableFuture<?> src;
        final Runnable fn;
        final CompletableFuture<Void> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        ThenRun(CompletableFuture<?> completableFuture, Runnable runnable, CompletableFuture<Void> completableFuture2, Executor executor) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$Completion.<init>:()V");
            this.src = completableFuture;
            this.fn = runnable;
            this.dst = completableFuture2;
            this.executor = executor;
        }

        @Override
        public final void run() {
            block11: {
                Throwable throwable;
                CompletableFuture<Void> completableFuture;
                block13: {
                    completableFuture = this.dst;
                    RuntimeCostAccounter.recordJump();
                    if (completableFuture == null) break block11;
                    Runnable runnable = this.fn;
                    RuntimeCostAccounter.recordJump();
                    if (runnable == null) break block11;
                    CompletableFuture<?> completableFuture2 = this.src;
                    RuntimeCostAccounter.recordJump();
                    if (completableFuture2 == null) break block11;
                    Object object = completableFuture2.result;
                    RuntimeCostAccounter.recordJump();
                    if (object == null) break block11;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ThenRun.compareAndSet:(II)Z");
                    boolean bl = this.compareAndSet(0, 1);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block11;
                    boolean bl2 = object instanceof AltResult;
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        throwable = ((AltResult)object).ex;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        throwable = null;
                    }
                    Executor executor = this.executor;
                    RuntimeCostAccounter.recordJump();
                    if (throwable == null) {
                        block10: {
                            try {
                                RuntimeCostAccounter.recordJump();
                                if (executor != null) {
                                    RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AsyncRun");
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AsyncRun.<init>:(Ljava/lang/Runnable;Ljava/util/concurrent/CompletableFuture;)V");
                                    AsyncRun asyncRun = new AsyncRun(runnable, completableFuture);
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.execAsync:(Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture$Async;)V");
                                    CompletableFuture.execAsync(executor, asyncRun);
                                    RuntimeCostAccounter.recordJump();
                                    break block10;
                                }
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runnable.run:()V");
                                runnable.run();
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                            }
                        }
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordJump();
                    if (executor == null) break block13;
                    RuntimeCostAccounter.recordJump();
                    if (throwable == null) break block11;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
                completableFuture.internalComplete(null, throwable);
            }
        }
    }

    static final class ThenAccept<T>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final Consumer<? super T> fn;
        final CompletableFuture<?> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        ThenAccept(CompletableFuture<? extends T> completableFuture, Consumer<? super T> consumer, CompletableFuture<?> completableFuture2, Executor executor) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$Completion.<init>:()V");
            this.src = completableFuture;
            this.fn = consumer;
            this.dst = completableFuture2;
            this.executor = executor;
        }

        @Override
        public final void run() {
            block11: {
                Throwable throwable;
                CompletableFuture<?> completableFuture;
                block13: {
                    Object object;
                    Object object2;
                    completableFuture = this.dst;
                    RuntimeCostAccounter.recordJump();
                    if (completableFuture == null) break block11;
                    Consumer<Object> consumer = this.fn;
                    RuntimeCostAccounter.recordJump();
                    if (consumer == null) break block11;
                    CompletableFuture<? extends T> completableFuture2 = this.src;
                    RuntimeCostAccounter.recordJump();
                    if (completableFuture2 == null) break block11;
                    Object object3 = completableFuture2.result;
                    RuntimeCostAccounter.recordJump();
                    if (object3 == null) break block11;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ThenAccept.compareAndSet:(II)Z");
                    boolean bl = this.compareAndSet(0, 1);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block11;
                    boolean bl2 = object3 instanceof AltResult;
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        throwable = ((AltResult)object3).ex;
                        object2 = null;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        throwable = null;
                        object2 = object = object3;
                    }
                    object = this.executor;
                    RuntimeCostAccounter.recordJump();
                    if (throwable == null) {
                        block10: {
                            try {
                                RuntimeCostAccounter.recordJump();
                                if (object != null) {
                                    RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AsyncAccept");
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AsyncAccept.<init>:(Ljava/lang/Object;Ljava/util/function/Consumer;Ljava/util/concurrent/CompletableFuture;)V");
                                    AsyncAccept<? super T> asyncAccept = new AsyncAccept<T>(object2, consumer, completableFuture);
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.execAsync:(Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture$Async;)V");
                                    CompletableFuture.execAsync((Executor)object, asyncAccept);
                                    RuntimeCostAccounter.recordJump();
                                    break block10;
                                }
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                                consumer.accept(object2);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                            }
                        }
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordJump();
                    if (object == null) break block13;
                    RuntimeCostAccounter.recordJump();
                    if (throwable == null) break block11;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
                completableFuture.internalComplete(null, throwable);
            }
        }
    }

    static final class ThenApply<T, U>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final Function<? super T, ? extends U> fn;
        final CompletableFuture<U> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        ThenApply(CompletableFuture<? extends T> completableFuture, Function<? super T, ? extends U> function, CompletableFuture<U> completableFuture2, Executor executor) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$Completion.<init>:()V");
            this.src = completableFuture;
            this.fn = function;
            this.dst = completableFuture2;
            this.executor = executor;
        }

        @Override
        public final void run() {
            block11: {
                Object t;
                Throwable throwable;
                CompletableFuture<U> completableFuture;
                block13: {
                    Object object;
                    Object object2;
                    completableFuture = this.dst;
                    RuntimeCostAccounter.recordJump();
                    if (completableFuture == null) break block11;
                    Function<Object, U> function = this.fn;
                    RuntimeCostAccounter.recordJump();
                    if (function == null) break block11;
                    CompletableFuture<? extends T> completableFuture2 = this.src;
                    RuntimeCostAccounter.recordJump();
                    if (completableFuture2 == null) break block11;
                    Object object3 = completableFuture2.result;
                    RuntimeCostAccounter.recordJump();
                    if (object3 == null) break block11;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$ThenApply.compareAndSet:(II)Z");
                    boolean bl = this.compareAndSet(0, 1);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block11;
                    boolean bl2 = object3 instanceof AltResult;
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        throwable = ((AltResult)object3).ex;
                        object2 = null;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        throwable = null;
                        object2 = object = object3;
                    }
                    object = this.executor;
                    t = null;
                    RuntimeCostAccounter.recordJump();
                    if (throwable == null) {
                        block10: {
                            try {
                                RuntimeCostAccounter.recordJump();
                                if (object != null) {
                                    RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CompletableFuture$AsyncApply");
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$AsyncApply.<init>:(Ljava/lang/Object;Ljava/util/function/Function;Ljava/util/concurrent/CompletableFuture;)V");
                                    AsyncApply<? super T, ? extends U> asyncApply = new AsyncApply<T, U>(object2, function, completableFuture);
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.execAsync:(Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture$Async;)V");
                                    CompletableFuture.execAsync((Executor)object, asyncApply);
                                    RuntimeCostAccounter.recordJump();
                                    break block10;
                                }
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
                                t = function.apply(object2);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                            }
                        }
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordJump();
                    if (object == null) break block13;
                    RuntimeCostAccounter.recordJump();
                    if (throwable == null) break block11;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
                completableFuture.internalComplete(t, throwable);
            }
        }
    }

    static abstract class Completion
    extends AtomicInteger
    implements Runnable {
        Completion() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.<init>:()V");
        }
    }

    static final class CompletionNode {
        final Completion completion;
        volatile CompletionNode next;

        CompletionNode(Completion completion) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.completion = completion;
        }
    }

    static final class AsyncWhenComplete<T>
    extends Async {
        final T arg1;
        final Throwable arg2;
        final BiConsumer<? super T, ? super Throwable> fn;
        final CompletableFuture<T> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncWhenComplete(T t, Throwable throwable, BiConsumer<? super T, ? super Throwable> biConsumer, CompletableFuture<T> completableFuture) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$Async.<init>:()V");
            this.arg1 = t;
            this.arg2 = throwable;
            this.fn = biConsumer;
            this.dst = completableFuture;
        }

        @Override
        public final boolean exec() {
            block3: {
                Throwable throwable;
                CompletableFuture<T> completableFuture;
                block2: {
                    completableFuture = this.dst;
                    RuntimeCostAccounter.recordJump();
                    if (completableFuture == null) break block3;
                    Object object = completableFuture.result;
                    RuntimeCostAccounter.recordJump();
                    if (object != null) break block3;
                    throwable = this.arg2;
                    try {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiConsumer.accept:(Ljava/lang/Object;Ljava/lang/Object;)V");
                        this.fn.accept(this.arg1, throwable);
                    }
                    catch (Throwable throwable2) {
                        RuntimeCostAccounter.recordJump();
                        if (throwable != null) break block2;
                        throwable = throwable2;
                    }
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
                completableFuture.internalComplete(this.arg1, throwable);
            }
            return true;
        }
    }

    static final class AsyncCompose<T, U>
    extends Async {
        final T arg;
        final Function<? super T, ? extends CompletionStage<U>> fn;
        final CompletableFuture<U> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncCompose(T t, Function<? super T, ? extends CompletionStage<U>> function, CompletableFuture<U> completableFuture) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$Async.<init>:()V");
            this.arg = t;
            this.fn = function;
            this.dst = completableFuture;
        }

        @Override
        public final boolean exec() {
            block11: {
                Object object;
                Throwable throwable;
                CompletableFuture completableFuture;
                Object object2;
                CompletableFuture<U> completableFuture2 = this.dst;
                RuntimeCostAccounter.recordJump();
                if (completableFuture2 == null) break block11;
                Object object3 = completableFuture2.result;
                RuntimeCostAccounter.recordJump();
                if (object3 != null) break block11;
                try {
                    NullPointerException nullPointerException;
                    CompletableFuture completableFuture3;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
                    object2 = this.fn.apply(this.arg);
                    RuntimeCostAccounter.recordJump();
                    if (object2 == null) {
                        completableFuture3 = null;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletionStage.toCompletableFuture:()Ljava/util/concurrent/CompletableFuture;");
                        completableFuture3 = object2.toCompletableFuture();
                    }
                    completableFuture = completableFuture3;
                    RuntimeCostAccounter.recordJump();
                    if (completableFuture == null) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                        nullPointerException = new NullPointerException();
                        RuntimeCostAccounter.recordJump();
                    } else {
                        nullPointerException = null;
                    }
                    throwable = nullPointerException;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    completableFuture = null;
                }
                RuntimeCostAccounter.recordJump();
                RuntimeCostAccounter.recordJump();
                if (throwable != null) {
                    object = null;
                    RuntimeCostAccounter.recordJump();
                } else {
                    object2 = completableFuture.result;
                    RuntimeCostAccounter.recordJump();
                    if (object2 == null) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.access$000:(Ljava/util/concurrent/CompletableFuture;Z)Ljava/lang/Object;");
                        object2 = CompletableFuture.access$000(completableFuture, false);
                    }
                    boolean bl = object2 instanceof AltResult;
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        throwable = ((AltResult)object2).ex;
                        object = null;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        Object object4;
                        object = object4 = object2;
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
                completableFuture2.internalComplete(object, throwable);
            }
            return true;
        }
    }

    static final class AsyncAcceptBoth<T, U>
    extends Async {
        final T arg1;
        final U arg2;
        final BiConsumer<? super T, ? super U> fn;
        final CompletableFuture<?> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncAcceptBoth(T t, U u, BiConsumer<? super T, ? super U> biConsumer, CompletableFuture<?> completableFuture) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$Async.<init>:()V");
            this.arg1 = t;
            this.arg2 = u;
            this.fn = biConsumer;
            this.dst = completableFuture;
        }

        @Override
        public final boolean exec() {
            block2: {
                Throwable throwable;
                CompletableFuture<?> completableFuture = this.dst;
                RuntimeCostAccounter.recordJump();
                if (completableFuture == null) break block2;
                Object object = completableFuture.result;
                RuntimeCostAccounter.recordJump();
                if (object != null) break block2;
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiConsumer.accept:(Ljava/lang/Object;Ljava/lang/Object;)V");
                    this.fn.accept(this.arg1, this.arg2);
                    throwable = null;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                }
                RuntimeCostAccounter.recordJump();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
                completableFuture.internalComplete(null, throwable);
            }
            return true;
        }
    }

    static final class AsyncAccept<T>
    extends Async {
        final T arg;
        final Consumer<? super T> fn;
        final CompletableFuture<?> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncAccept(T t, Consumer<? super T> consumer, CompletableFuture<?> completableFuture) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$Async.<init>:()V");
            this.arg = t;
            this.fn = consumer;
            this.dst = completableFuture;
        }

        @Override
        public final boolean exec() {
            block2: {
                Throwable throwable;
                CompletableFuture<?> completableFuture = this.dst;
                RuntimeCostAccounter.recordJump();
                if (completableFuture == null) break block2;
                Object object = completableFuture.result;
                RuntimeCostAccounter.recordJump();
                if (object != null) break block2;
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                    this.fn.accept(this.arg);
                    throwable = null;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                }
                RuntimeCostAccounter.recordJump();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
                completableFuture.internalComplete(null, throwable);
            }
            return true;
        }
    }

    static final class AsyncCombine<T, U, V>
    extends Async {
        final T arg1;
        final U arg2;
        final BiFunction<? super T, ? super U, ? extends V> fn;
        final CompletableFuture<V> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncCombine(T t, U u, BiFunction<? super T, ? super U, ? extends V> biFunction, CompletableFuture<V> completableFuture) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$Async.<init>:()V");
            this.arg1 = t;
            this.arg2 = u;
            this.fn = biFunction;
            this.dst = completableFuture;
        }

        @Override
        public final boolean exec() {
            block2: {
                Throwable throwable;
                Object t;
                CompletableFuture<V> completableFuture = this.dst;
                RuntimeCostAccounter.recordJump();
                if (completableFuture == null) break block2;
                Object object = completableFuture.result;
                RuntimeCostAccounter.recordJump();
                if (object != null) break block2;
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiFunction.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                    t = this.fn.apply(this.arg1, this.arg2);
                    throwable = null;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    t = null;
                }
                RuntimeCostAccounter.recordJump();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
                completableFuture.internalComplete(t, throwable);
            }
            return true;
        }
    }

    static final class AsyncApply<T, U>
    extends Async {
        final T arg;
        final Function<? super T, ? extends U> fn;
        final CompletableFuture<U> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncApply(T t, Function<? super T, ? extends U> function, CompletableFuture<U> completableFuture) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$Async.<init>:()V");
            this.arg = t;
            this.fn = function;
            this.dst = completableFuture;
        }

        @Override
        public final boolean exec() {
            block2: {
                Throwable throwable;
                Object t;
                CompletableFuture<U> completableFuture = this.dst;
                RuntimeCostAccounter.recordJump();
                if (completableFuture == null) break block2;
                Object object = completableFuture.result;
                RuntimeCostAccounter.recordJump();
                if (object != null) break block2;
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
                    t = this.fn.apply(this.arg);
                    throwable = null;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    t = null;
                }
                RuntimeCostAccounter.recordJump();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
                completableFuture.internalComplete(t, throwable);
            }
            return true;
        }
    }

    static final class AsyncSupply<U>
    extends Async {
        final Supplier<U> fn;
        final CompletableFuture<U> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncSupply(Supplier<U> supplier, CompletableFuture<U> completableFuture) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$Async.<init>:()V");
            this.fn = supplier;
            this.dst = completableFuture;
        }

        @Override
        public final boolean exec() {
            block2: {
                Throwable throwable;
                U u;
                CompletableFuture<U> completableFuture = this.dst;
                RuntimeCostAccounter.recordJump();
                if (completableFuture == null) break block2;
                Object object = completableFuture.result;
                RuntimeCostAccounter.recordJump();
                if (object != null) break block2;
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Supplier.get:()Ljava/lang/Object;");
                    u = this.fn.get();
                    throwable = null;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    u = null;
                }
                RuntimeCostAccounter.recordJump();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
                completableFuture.internalComplete(u, throwable);
            }
            return true;
        }
    }

    static final class AsyncRun
    extends Async {
        final Runnable fn;
        final CompletableFuture<Void> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncRun(Runnable runnable, CompletableFuture<Void> completableFuture) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$Async.<init>:()V");
            this.fn = runnable;
            this.dst = completableFuture;
        }

        @Override
        public final boolean exec() {
            block2: {
                Throwable throwable;
                CompletableFuture<Void> completableFuture = this.dst;
                RuntimeCostAccounter.recordJump();
                if (completableFuture == null) break block2;
                Object object = completableFuture.result;
                RuntimeCostAccounter.recordJump();
                if (object != null) break block2;
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runnable.run:()V");
                    this.fn.run();
                    throwable = null;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                }
                RuntimeCostAccounter.recordJump();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture.internalComplete:(Ljava/lang/Object;Ljava/lang/Throwable;)V");
                completableFuture.internalComplete(null, throwable);
            }
            return true;
        }
    }

    static abstract class Async
    extends ForkJoinTask<Void>
    implements Runnable,
    AsynchronousCompletionTask {
        Async() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.<init>:()V");
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void void_) {
        }

        @Override
        public final void run() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$Async.exec:()Z");
            this.exec();
        }
    }

    public static interface AsynchronousCompletionTask {
    }

    static final class WaitNode
    implements ForkJoinPool.ManagedBlocker {
        long nanos;
        final long deadline;
        volatile int interruptControl;
        volatile Thread thread;
        volatile WaitNode next;

        WaitNode(boolean bl, long l, long l2) {
            int n;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            this.thread = Thread.currentThread();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                n = 1;
                RuntimeCostAccounter.recordJump();
            } else {
                n = 0;
            }
            this.interruptControl = n;
            this.nanos = l;
            this.deadline = l2;
        }

        @Override
        public boolean isReleasable() {
            block6: {
                block7: {
                    RuntimeCostAccounter.recordJump();
                    if (this.thread == null) {
                        return true;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
                    boolean bl = Thread.interrupted();
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        int n = this.interruptControl;
                        this.interruptControl = -1;
                        RuntimeCostAccounter.recordJump();
                        if (n > 0) {
                            return true;
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    if (this.deadline == 0L) break block6;
                    RuntimeCostAccounter.recordJump();
                    if (this.nanos <= 0L) break block7;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
                    this.nanos = this.deadline - System.nanoTime();
                    RuntimeCostAccounter.recordJump();
                    if (this.nanos > 0L) break block6;
                }
                this.thread = null;
                return true;
            }
            return false;
        }

        @Override
        public boolean block() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$WaitNode.isReleasable:()Z");
            boolean bl = this.isReleasable();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return true;
            }
            RuntimeCostAccounter.recordJump();
            if (this.deadline == 0L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.park:(Ljava/lang/Object;)V");
                LockSupport.park(this);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (this.nanos > 0L) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.parkNanos:(Ljava/lang/Object;J)V");
                    LockSupport.parkNanos(this, this.nanos);
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CompletableFuture$WaitNode.isReleasable:()Z");
            return this.isReleasable();
        }
    }

    static final class AltResult {
        final Throwable ex;

        AltResult(Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.ex = throwable;
        }
    }
}

