/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.BufferedReader;
import sandbox.java.io.IOException;
import sandbox.java.io.InputStream;
import sandbox.java.io.InputStreamReader;
import sandbox.java.net.URL;
import sandbox.java.security.AccessControlContext;
import sandbox.java.security.AccessController;
import sandbox.java.security.PrivilegedAction;
import sandbox.java.util.ArrayList;
import sandbox.java.util.Enumeration;
import sandbox.java.util.Iterator;
import sandbox.java.util.LinkedHashMap;
import sandbox.java.util.List;
import sandbox.java.util.Map;
import sandbox.java.util.NoSuchElementException;
import sandbox.java.util.Objects;
import sandbox.java.util.ServiceConfigurationError;
import sandbox.java.util.Set;

public final class ServiceLoader<S>
implements Iterable<S> {
    private static final String PREFIX = "META-INF/services/";
    private final Class<S> service;
    private final ClassLoader loader;
    private final AccessControlContext acc;
    private LinkedHashMap<String, S> providers;
    private LazyIterator lookupIterator;

    public void reload() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedHashMap.clear:()V");
        this.providers.clear();
        RuntimeCostAccounter.recordAllocation((String)"java/util/ServiceLoader$LazyIterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader$LazyIterator.<init>:(Ljava/util/ServiceLoader;Ljava/lang/Class;Ljava/lang/ClassLoader;Ljava/util/ServiceLoader$1;)V");
        this.lookupIterator = new LazyIterator(this, this.service, this.loader, null);
    }

    private ServiceLoader(Class<S> clazz, ClassLoader classLoader) {
        AccessControlContext accessControlContext;
        ClassLoader classLoader2;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/util/LinkedHashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedHashMap.<init>:()V");
        this.providers = new LinkedHashMap();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        this.service = Objects.requireNonNull(clazz, "Service interface cannot be null");
        RuntimeCostAccounter.recordJump();
        if (classLoader == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.getSystemClassLoader:()Ljava/lang/ClassLoader;");
            classLoader2 = ClassLoader.getSystemClassLoader();
            RuntimeCostAccounter.recordJump();
        } else {
            classLoader2 = classLoader;
        }
        this.loader = classLoader2;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.getContext:()Ljava/security/AccessControlContext;");
            accessControlContext = AccessController.getContext();
            RuntimeCostAccounter.recordJump();
        } else {
            accessControlContext = null;
        }
        this.acc = accessControlContext;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.reload:()V");
        this.reload();
    }

    private static void fail(Class<?> clazz, String string, Throwable throwable) throws ServiceConfigurationError {
        RuntimeCostAccounter.recordAllocation((String)"java/util/ServiceConfigurationError");
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
        String string2 = clazz.getName();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(": ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string3 = stringBuilder4.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceConfigurationError.<init>:(Ljava/lang/String;Ljava/lang/Throwable;)V");
        ServiceConfigurationError serviceConfigurationError = new ServiceConfigurationError(string3, throwable);
        RuntimeCostAccounter.recordThrow();
        throw serviceConfigurationError;
    }

    private static void fail(Class<?> clazz, String string) throws ServiceConfigurationError {
        RuntimeCostAccounter.recordAllocation((String)"java/util/ServiceConfigurationError");
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
        String string2 = clazz.getName();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(": ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string3 = stringBuilder4.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceConfigurationError.<init>:(Ljava/lang/String;)V");
        ServiceConfigurationError serviceConfigurationError = new ServiceConfigurationError(string3);
        RuntimeCostAccounter.recordThrow();
        throw serviceConfigurationError;
    }

    private static void fail(Class<?> clazz, URL uRL, int n, String string) throws ServiceConfigurationError {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append(uRL);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(":");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append(": ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder6 = stringBuilder5.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string2 = stringBuilder6.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.fail:(Ljava/lang/Class;Ljava/lang/String;)V");
        ServiceLoader.fail(clazz, string2);
    }

    private int parseLine(Class<?> clazz, URL uRL, BufferedReader bufferedReader, int n, List<String> list) throws IOException, ServiceConfigurationError {
        block11: {
            int n2;
            String string;
            block13: {
                block12: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedReader.readLine:()Ljava/lang/String;");
                    string = bufferedReader.readLine();
                    RuntimeCostAccounter.recordJump();
                    if (string == null) {
                        return -1;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.indexOf:(I)I");
                    int n3 = string.indexOf(35);
                    RuntimeCostAccounter.recordJump();
                    if (n3 >= 0) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
                        string = string.substring(0, n3);
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.trim:()Ljava/lang/String;");
                    string = string.trim();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                    n2 = string.length();
                    RuntimeCostAccounter.recordJump();
                    if (n2 == 0) break block11;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.indexOf:(I)I");
                    int n4 = string.indexOf(32);
                    RuntimeCostAccounter.recordJump();
                    if (n4 >= 0) break block12;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.indexOf:(I)I");
                    int n5 = string.indexOf(9);
                    RuntimeCostAccounter.recordJump();
                    if (n5 < 0) break block13;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.fail:(Ljava/lang/Class;Ljava/net/URL;ILjava/lang/String;)V");
                ServiceLoader.fail(clazz, uRL, n, "Illegal configuration-file syntax");
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.codePointAt:(I)I");
            int n6 = string.codePointAt(0);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.isJavaIdentifierStart:(I)Z");
            boolean bl = Character.isJavaIdentifierStart(n6);
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("Illegal provider-class name: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string2 = stringBuilder3.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.fail:(Ljava/lang/Class;Ljava/net/URL;ILjava/lang/String;)V");
                ServiceLoader.fail(clazz, uRL, n, string2);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.charCount:(I)I");
            int n7 = Character.charCount(n6);
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n7 >= n2) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.codePointAt:(I)I");
                n6 = string.codePointAt(n7);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.isJavaIdentifierPart:(I)Z");
                boolean bl2 = Character.isJavaIdentifierPart(n6);
                RuntimeCostAccounter.recordJump();
                if (!bl2) {
                    RuntimeCostAccounter.recordJump();
                    if (n6 != 46) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder4 = stringBuilder.append("Illegal provider-class name: ");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder5 = stringBuilder4.append(string);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string3 = stringBuilder5.toString();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.fail:(Ljava/lang/Class;Ljava/net/URL;ILjava/lang/String;)V");
                        ServiceLoader.fail(clazz, uRL, n, string3);
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.charCount:(I)I");
                n7 += Character.charCount(n6);
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedHashMap.containsKey:(Ljava/lang/Object;)Z");
            boolean bl3 = this.providers.containsKey(string);
            RuntimeCostAccounter.recordJump();
            if (!bl3) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.contains:(Ljava/lang/Object;)Z");
                boolean bl4 = list.contains(string);
                RuntimeCostAccounter.recordJump();
                if (!bl4) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
                    list.add(string);
                }
            }
        }
        return n + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Iterator<String> parse(Class<?> clazz, URL uRL) throws ServiceConfigurationError {
        ArrayList<String> arrayList;
        block16: {
            BufferedReader bufferedReader;
            InputStream inputStream;
            block14: {
                inputStream = null;
                bufferedReader = null;
                RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
                arrayList = new ArrayList<String>();
                RuntimeCostAccounter.recordMethodCall((String)"java/net/URL.openStream:()Ljava/io/InputStream;");
                inputStream = uRL.openStream();
                RuntimeCostAccounter.recordAllocation((String)"java/io/BufferedReader");
                RuntimeCostAccounter.recordAllocation((String)"java/io/InputStreamReader");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStreamReader.<init>:(Ljava/io/InputStream;Ljava/lang/String;)V");
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedReader.<init>:(Ljava/io/Reader;)V");
                bufferedReader = new BufferedReader(inputStreamReader);
                int n = 1;
                while (true) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.parseLine:(Ljava/lang/Class;Ljava/net/URL;Ljava/io/BufferedReader;ILjava/util/List;)I");
                    n = this.parseLine(clazz, uRL, bufferedReader, n, arrayList);
                    RuntimeCostAccounter.recordJump();
                    if (n < 0) break;
                    RuntimeCostAccounter.recordJump();
                }
                try {
                    RuntimeCostAccounter.recordJump();
                    if (bufferedReader != null) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedReader.close:()V");
                        bufferedReader.close();
                    }
                    RuntimeCostAccounter.recordJump();
                    if (inputStream == null) break block14;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.close:()V");
                    inputStream.close();
                }
                catch (IOException iOException) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.fail:(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Throwable;)V");
                    ServiceLoader.fail(clazz, "Error closing configuration file", iOException);
                    RuntimeCostAccounter.recordJump();
                }
            }
            RuntimeCostAccounter.recordJump();
            break block16;
            break block16;
            catch (IOException iOException) {
                block15: {
                    try {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.fail:(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Throwable;)V");
                        ServiceLoader.fail(clazz, "Error reading configuration file", iOException);
                    }
                    catch (Throwable throwable) {
                        block17: {
                            try {
                                RuntimeCostAccounter.recordJump();
                                if (bufferedReader != null) {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedReader.close:()V");
                                    bufferedReader.close();
                                }
                                RuntimeCostAccounter.recordJump();
                                if (inputStream == null) break block17;
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.close:()V");
                                inputStream.close();
                            }
                            catch (IOException iOException2) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.fail:(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Throwable;)V");
                                ServiceLoader.fail(clazz, "Error closing configuration file", iOException2);
                            }
                        }
                        RuntimeCostAccounter.recordJump();
                        RuntimeCostAccounter.recordThrow();
                        throw throwable;
                    }
                    try {
                        RuntimeCostAccounter.recordJump();
                        if (bufferedReader != null) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedReader.close:()V");
                            bufferedReader.close();
                        }
                        RuntimeCostAccounter.recordJump();
                        if (inputStream == null) break block15;
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.close:()V");
                        inputStream.close();
                    }
                    catch (IOException iOException3) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.fail:(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Throwable;)V");
                        ServiceLoader.fail(clazz, "Error closing configuration file", iOException3);
                        RuntimeCostAccounter.recordJump();
                        break block16;
                    }
                }
                RuntimeCostAccounter.recordJump();
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.iterator:()Ljava/util/Iterator;");
        return arrayList.iterator();
    }

    @Override
    public Iterator<S> iterator() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/ServiceLoader$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader$1.<init>:(Ljava/util/ServiceLoader;)V");
        return new Iterator<S>(){
            Iterator<Map.Entry<String, S>> knownProviders;
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.access$400:(Ljava/util/ServiceLoader;)Ljava/util/LinkedHashMap;");
                LinkedHashMap linkedHashMap = ServiceLoader.this.providers;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedHashMap.entrySet:()Ljava/util/Set;");
                Set set = linkedHashMap.entrySet();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
                this.knownProviders = set.iterator();
            }

            @Override
            public boolean hasNext() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl = this.knownProviders.hasNext();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    return true;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.access$800:(Ljava/util/ServiceLoader;)Ljava/util/ServiceLoader$LazyIterator;");
                LazyIterator lazyIterator = ServiceLoader.this.lookupIterator;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader$LazyIterator.hasNext:()Z");
                return lazyIterator.hasNext();
            }

            @Override
            public S next() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl = this.knownProviders.hasNext();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                    return this.knownProviders.next().getValue();
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.access$800:(Ljava/util/ServiceLoader;)Ljava/util/ServiceLoader$LazyIterator;");
                LazyIterator lazyIterator = ServiceLoader.this.lookupIterator;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader$LazyIterator.next:()Ljava/lang/Object;");
                return lazyIterator.next();
            }

            @Override
            public void remove() {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
                UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
                RuntimeCostAccounter.recordThrow();
                throw unsupportedOperationException;
            }
        };
    }

    public static <S> ServiceLoader<S> load(Class<S> clazz, ClassLoader classLoader) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/ServiceLoader");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.<init>:(Ljava/lang/Class;Ljava/lang/ClassLoader;)V");
        return new ServiceLoader<S>(clazz, classLoader);
    }

    public static <S> ServiceLoader<S> load(Class<S> clazz) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        Thread thread = Thread.currentThread();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.getContextClassLoader:()Ljava/lang/ClassLoader;");
        ClassLoader classLoader = thread.getContextClassLoader();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.load:(Ljava/lang/Class;Ljava/lang/ClassLoader;)Ljava/util/ServiceLoader;");
        return ServiceLoader.load(clazz, classLoader);
    }

    public static <S> ServiceLoader<S> loadInstalled(Class<S> clazz) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.getSystemClassLoader:()Ljava/lang/ClassLoader;");
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        ClassLoader classLoader2 = null;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (classLoader == null) break;
            classLoader2 = classLoader;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.getParent:()Ljava/lang/ClassLoader;");
            classLoader = classLoader.getParent();
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.load:(Ljava/lang/Class;Ljava/lang/ClassLoader;)Ljava/util/ServiceLoader;");
        return ServiceLoader.load(clazz, classLoader2);
    }

    public String toString() {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("java.util.ServiceLoader[");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
        String string = this.service.getName();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append("]");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder4.toString();
    }

    static /* synthetic */ void access$100(Class clazz, String string, Throwable throwable) throws ServiceConfigurationError {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.fail:(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Throwable;)V");
        ServiceLoader.fail(clazz, string, throwable);
    }

    static /* synthetic */ Iterator access$200(ServiceLoader serviceLoader, Class clazz, URL uRL) throws ServiceConfigurationError {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.parse:(Ljava/lang/Class;Ljava/net/URL;)Ljava/util/Iterator;");
        return serviceLoader.parse(clazz, uRL);
    }

    static /* synthetic */ void access$300(Class clazz, String string) throws ServiceConfigurationError {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.fail:(Ljava/lang/Class;Ljava/lang/String;)V");
        ServiceLoader.fail(clazz, string);
    }

    private class LazyIterator
    implements Iterator<S> {
        Class<S> service;
        ClassLoader loader;
        Enumeration<URL> configs;
        Iterator<String> pending;
        String nextName;
        final /* synthetic */ ServiceLoader this$0;

        private LazyIterator(ServiceLoader serviceLoader, Class<S> clazz, ClassLoader classLoader) {
            this.this$0 = serviceLoader;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.configs = null;
            this.pending = null;
            this.nextName = null;
            this.service = clazz;
            this.loader = classLoader;
        }

        private boolean hasNextService() {
            RuntimeCostAccounter.recordJump();
            if (this.nextName != null) {
                return true;
            }
            RuntimeCostAccounter.recordJump();
            if (this.configs == null) {
                block8: {
                    try {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder2 = stringBuilder.append(ServiceLoader.PREFIX);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
                        String string = this.service.getName();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder3 = stringBuilder2.append(string);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string2 = stringBuilder3.toString();
                        RuntimeCostAccounter.recordJump();
                        if (this.loader == null) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.getSystemResources:(Ljava/lang/String;)Ljava/util/Enumeration;");
                            this.configs = ClassLoader.getSystemResources((String)string2);
                            RuntimeCostAccounter.recordJump();
                            break block8;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.getResources:(Ljava/lang/String;)Ljava/util/Enumeration;");
                        this.configs = this.loader.getResources(string2);
                    }
                    catch (IOException iOException) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.access$100:(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Throwable;)V");
                        ServiceLoader.access$100(this.service, "Error locating configuration files", iOException);
                    }
                }
                RuntimeCostAccounter.recordJump();
            }
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (this.pending != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                    boolean bl = this.pending.hasNext();
                    RuntimeCostAccounter.recordJump();
                    if (bl) break;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Enumeration.hasMoreElements:()Z");
                boolean bl = this.configs.hasMoreElements();
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    return false;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Enumeration.nextElement:()Ljava/lang/Object;");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.access$200:(Ljava/util/ServiceLoader;Ljava/lang/Class;Ljava/net/URL;)Ljava/util/Iterator;");
                this.pending = ServiceLoader.access$200(this.this$0, this.service, this.configs.nextElement());
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            this.nextName = this.pending.next();
            return true;
        }

        private S nextService() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader$LazyIterator.hasNextService:()Z");
            boolean bl = this.hasNextService();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                NoSuchElementException noSuchElementException = new NoSuchElementException();
                RuntimeCostAccounter.recordThrow();
                throw noSuchElementException;
            }
            String string = this.nextName;
            this.nextName = null;
            Class<?> clazz = null;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.forName:(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;");
                clazz = Class.forName(string, false, this.loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("Provider ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder3.append(" not found");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string2 = stringBuilder4.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.access$300:(Ljava/lang/Class;Ljava/lang/String;)V");
                ServiceLoader.access$300(this.service, string2);
            }
            RuntimeCostAccounter.recordJump();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.isAssignableFrom:(Ljava/lang/Class;)Z");
            boolean bl2 = this.service.isAssignableFrom(clazz);
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder5 = stringBuilder.append("Provider ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder6 = stringBuilder5.append(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder7 = stringBuilder6.append(" not a subtype");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string3 = stringBuilder7.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.access$300:(Ljava/lang/Class;Ljava/lang/String;)V");
                ServiceLoader.access$300(this.service, string3);
            }
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.newInstance:()Ljava/lang/Object;");
                Object obj = clazz.newInstance();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.cast:(Ljava/lang/Object;)Ljava/lang/Object;");
                Object s = this.service.cast(obj);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.access$400:(Ljava/util/ServiceLoader;)Ljava/util/LinkedHashMap;");
                LinkedHashMap linkedHashMap = this.this$0.providers;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedHashMap.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                linkedHashMap.put(string, s);
                return s;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder8 = stringBuilder.append("Provider ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder9 = stringBuilder8.append(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder10 = stringBuilder9.append(" could not be instantiated");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string4 = stringBuilder10.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.access$100:(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Throwable;)V");
                ServiceLoader.access$100(this.service, string4, throwable);
                RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:()V");
                Error error = new Error();
                RuntimeCostAccounter.recordThrow();
                throw error;
            }
        }

        @Override
        public boolean hasNext() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.access$500:(Ljava/util/ServiceLoader;)Ljava/security/AccessControlContext;");
            AccessControlContext accessControlContext = this.this$0.acc;
            RuntimeCostAccounter.recordJump();
            if (accessControlContext == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader$LazyIterator.hasNextService:()Z");
                return this.hasNextService();
            }
            RuntimeCostAccounter.recordAllocation((String)"java/util/ServiceLoader$LazyIterator$1");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader$LazyIterator$1.<init>:(Ljava/util/ServiceLoader$LazyIterator;)V");
            PrivilegedAction<Boolean> privilegedAction = new PrivilegedAction<Boolean>(){
                {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                }

                public Boolean run() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader$LazyIterator.access$600:(Ljava/util/ServiceLoader$LazyIterator;)Z");
                    boolean bl = LazyIterator.access$600(LazyIterator.this);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Boolean.valueOf:(Z)Ljava/lang/Boolean;");
                    return bl;
                }
            };
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.access$500:(Ljava/util/ServiceLoader;)Ljava/security/AccessControlContext;");
            AccessControlContext accessControlContext2 = this.this$0.acc;
            RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;Ljava/security/AccessControlContext;)Ljava/lang/Object;");
            Boolean bl = (Boolean)AccessController.doPrivileged((PrivilegedAction)privilegedAction, (AccessControlContext)accessControlContext2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Boolean.booleanValue:()Z");
            return bl;
        }

        @Override
        public S next() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.access$500:(Ljava/util/ServiceLoader;)Ljava/security/AccessControlContext;");
            AccessControlContext accessControlContext = this.this$0.acc;
            RuntimeCostAccounter.recordJump();
            if (accessControlContext == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader$LazyIterator.nextService:()Ljava/lang/Object;");
                return this.nextService();
            }
            RuntimeCostAccounter.recordAllocation((String)"java/util/ServiceLoader$LazyIterator$2");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader$LazyIterator$2.<init>:(Ljava/util/ServiceLoader$LazyIterator;)V");
            PrivilegedAction privilegedAction = new PrivilegedAction<S>(){
                {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                }

                public S run() {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader$LazyIterator.access$700:(Ljava/util/ServiceLoader$LazyIterator;)Ljava/lang/Object;");
                    return LazyIterator.access$700(LazyIterator.this);
                }
            };
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.access$500:(Ljava/util/ServiceLoader;)Ljava/security/AccessControlContext;");
            AccessControlContext accessControlContext2 = this.this$0.acc;
            RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;Ljava/security/AccessControlContext;)Ljava/lang/Object;");
            return AccessController.doPrivileged((PrivilegedAction)privilegedAction, (AccessControlContext)accessControlContext2);
        }

        @Override
        public void remove() {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        /* synthetic */ LazyIterator(ServiceLoader serviceLoader, Class clazz, ClassLoader classLoader, 1 var4_4) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader$LazyIterator.<init>:(Ljava/util/ServiceLoader;Ljava/lang/Class;Ljava/lang/ClassLoader;)V");
            this(serviceLoader, clazz, classLoader);
        }

        static /* synthetic */ boolean access$600(LazyIterator lazyIterator) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader$LazyIterator.hasNextService:()Z");
            return lazyIterator.hasNextService();
        }

        static /* synthetic */ Object access$700(LazyIterator lazyIterator) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader$LazyIterator.nextService:()Ljava/lang/Object;");
            return lazyIterator.nextService();
        }
    }
}

