/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.Arrays;
import sandbox.java.util.TimerTask;

class TaskQueue {
    private TimerTask[] queue;
    private int size;
    static final /* synthetic */ boolean $assertionsDisabled;

    TaskQueue() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordArrayAllocation((int)128, (int)8);
        this.queue = new TimerTask[128];
        this.size = 0;
    }

    int size() {
        return this.size;
    }

    void add(TimerTask timerTask) {
        int n = this.queue.length;
        RuntimeCostAccounter.recordJump();
        if (this.size + 1 == n) {
            int n2 = 2 * this.queue.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;I)[Ljava/lang/Object;");
            this.queue = Arrays.copyOf(this.queue, n2);
        }
        this.queue[++this.size] = timerTask;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TaskQueue.fixUp:(I)V");
        this.fixUp(this.size);
    }

    TimerTask getMin() {
        return this.queue[1];
    }

    TimerTask get(int n) {
        return this.queue[n];
    }

    void removeMin() {
        this.queue[1] = this.queue[this.size];
        this.queue[this.size--] = null;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TaskQueue.fixDown:(I)V");
        this.fixDown(1);
    }

    void quickRemove(int n) {
        RuntimeCostAccounter.recordJump();
        if (!$assertionsDisabled) {
            RuntimeCostAccounter.recordJump();
            if (n > this.size) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                AssertionError assertionError = new AssertionError();
                RuntimeCostAccounter.recordThrow();
                throw assertionError;
            }
        }
        this.queue[n] = this.queue[this.size];
        this.queue[this.size--] = null;
    }

    void rescheduleMin(long l) {
        this.queue[1].nextExecutionTime = l;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TaskQueue.fixDown:(I)V");
        this.fixDown(1);
    }

    boolean isEmpty() {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (this.size == 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    void clear() {
        int n = 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n > this.size) break;
            this.queue[n] = null;
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        this.size = 0;
    }

    private void fixUp(int n) {
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n <= 1) break;
            int n2 = n >> 1;
            long l = this.queue[n2].nextExecutionTime - this.queue[n].nextExecutionTime;
            long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l2 <= 0) {
                RuntimeCostAccounter.recordJump();
                break;
            }
            TimerTask timerTask = this.queue[n2];
            this.queue[n2] = this.queue[n];
            this.queue[n] = timerTask;
            n = n2;
            RuntimeCostAccounter.recordJump();
        }
    }

    private void fixDown(int n) {
        while (true) {
            long l;
            int n2 = n << 1;
            RuntimeCostAccounter.recordJump();
            if (n2 > this.size) break;
            RuntimeCostAccounter.recordJump();
            if (n2 <= 0) break;
            RuntimeCostAccounter.recordJump();
            if (n2 < this.size) {
                long l2 = this.queue[n2].nextExecutionTime - this.queue[n2 + 1].nextExecutionTime;
                long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l3 > 0) {
                    ++n2;
                }
            }
            long l4 = (l = this.queue[n].nextExecutionTime - this.queue[n2].nextExecutionTime) == 0L ? 0 : (l < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l4 <= 0) {
                RuntimeCostAccounter.recordJump();
                break;
            }
            TimerTask timerTask = this.queue[n2];
            this.queue[n2] = this.queue[n];
            this.queue[n] = timerTask;
            n = n2;
            RuntimeCostAccounter.recordJump();
        }
    }

    void heapify() {
        int n = this.size / 2;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n < 1) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TaskQueue.fixDown:(I)V");
            this.fixDown(n);
            --n;
            RuntimeCostAccounter.recordJump();
        }
    }

    static {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
        boolean bl2 = TaskQueue.class.desiredAssertionStatus();
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        $assertionsDisabled = bl;
    }
}

