/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.chrono;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.time.Clock;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.Instant;
import sandbox.java.time.LocalDate;
import sandbox.java.time.ZoneId;
import sandbox.java.time.chrono.AbstractChronology;
import sandbox.java.time.chrono.ChronoLocalDate;
import sandbox.java.time.chrono.ChronoLocalDateTime;
import sandbox.java.time.chrono.ChronoZonedDateTime;
import sandbox.java.time.chrono.Era;
import sandbox.java.time.chrono.IsoChronology;
import sandbox.java.time.chrono.JapaneseDate;
import sandbox.java.time.chrono.JapaneseEra;
import sandbox.java.time.format.ResolverStyle;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.ChronoUnit;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalAdjuster;
import sandbox.java.time.temporal.TemporalAdjusters;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.UnsupportedTemporalTypeException;
import sandbox.java.time.temporal.ValueRange;
import sandbox.java.util.Arrays;
import sandbox.java.util.Calendar;
import sandbox.java.util.List;
import sandbox.java.util.Locale;
import sandbox.java.util.Map;
import sandbox.sun.util.calendar.CalendarDate;
import sandbox.sun.util.calendar.CalendarSystem;
import sandbox.sun.util.calendar.LocalGregorianCalendar;

public final class JapaneseChronology
extends AbstractChronology
implements Serializable {
    static final LocalGregorianCalendar JCAL;
    static final Locale LOCALE;
    public static final JapaneseChronology INSTANCE;
    private static final long serialVersionUID = 459996390165777884L;

    private JapaneseChronology() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.<init>:()V");
    }

    @Override
    public String getId() {
        return "Japanese";
    }

    @Override
    public String getCalendarType() {
        return "japanese";
    }

    @Override
    public JapaneseDate date(Era era, int n, int n2, int n3) {
        boolean bl = era instanceof JapaneseEra;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ClassCastException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassCastException.<init>:(Ljava/lang/String;)V");
            ClassCastException classCastException = new ClassCastException("Era must be JapaneseEra");
            RuntimeCostAccounter.recordThrow();
            throw classCastException;
        }
        JapaneseEra japaneseEra = (JapaneseEra)era;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.of:(Ljava/time/chrono/JapaneseEra;III)Ljava/time/chrono/JapaneseDate;");
        return JapaneseDate.of(japaneseEra, n, n2, n3);
    }

    @Override
    public JapaneseDate date(int n, int n2, int n3) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/JapaneseDate");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(III)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.of(n, n2, n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.<init>:(Ljava/time/LocalDate;)V");
        return new JapaneseDate(localDate);
    }

    @Override
    public JapaneseDate dateYearDay(Era era, int n, int n2) {
        JapaneseEra japaneseEra = (JapaneseEra)era;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.ofYearDay:(Ljava/time/chrono/JapaneseEra;II)Ljava/time/chrono/JapaneseDate;");
        return JapaneseDate.ofYearDay(japaneseEra, n, n2);
    }

    @Override
    public JapaneseDate dateYearDay(int n, int n2) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/JapaneseDate");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.ofYearDay:(II)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.ofYearDay(n, n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.<init>:(Ljava/time/LocalDate;)V");
        return new JapaneseDate(localDate);
    }

    @Override
    public JapaneseDate dateEpochDay(long l) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/JapaneseDate");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.ofEpochDay:(J)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.ofEpochDay(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.<init>:(Ljava/time/LocalDate;)V");
        return new JapaneseDate(localDate);
    }

    @Override
    public JapaneseDate dateNow() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.systemDefaultZone:()Ljava/time/Clock;");
        Clock clock = Clock.systemDefaultZone();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.dateNow:(Ljava/time/Clock;)Ljava/time/chrono/JapaneseDate;");
        return this.dateNow(clock);
    }

    @Override
    public JapaneseDate dateNow(ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.system:(Ljava/time/ZoneId;)Ljava/time/Clock;");
        Clock clock = Clock.system(zoneId);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.dateNow:(Ljava/time/Clock;)Ljava/time/chrono/JapaneseDate;");
        return this.dateNow(clock);
    }

    @Override
    public JapaneseDate dateNow(Clock clock) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.now:(Ljava/time/Clock;)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.now(clock);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.date:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/JapaneseDate;");
        return this.date(localDate);
    }

    @Override
    public JapaneseDate date(TemporalAccessor temporalAccessor) {
        boolean bl = temporalAccessor instanceof JapaneseDate;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return (JapaneseDate)temporalAccessor;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/JapaneseDate");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.from(temporalAccessor);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.<init>:(Ljava/time/LocalDate;)V");
        return new JapaneseDate(localDate);
    }

    public ChronoLocalDateTime<JapaneseDate> localDateTime(TemporalAccessor temporalAccessor) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.localDateTime:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/ChronoLocalDateTime;");
        return super.localDateTime(temporalAccessor);
    }

    public ChronoZonedDateTime<JapaneseDate> zonedDateTime(TemporalAccessor temporalAccessor) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.zonedDateTime:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/ChronoZonedDateTime;");
        return super.zonedDateTime(temporalAccessor);
    }

    public ChronoZonedDateTime<JapaneseDate> zonedDateTime(Instant instant, ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.zonedDateTime:(Ljava/time/Instant;Ljava/time/ZoneId;)Ljava/time/chrono/ChronoZonedDateTime;");
        return super.zonedDateTime(instant, zoneId);
    }

    @Override
    public boolean isLeapYear(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoChronology.isLeapYear:(J)Z");
        return IsoChronology.INSTANCE.isLeapYear(l);
    }

    @Override
    public int prolepticYear(Era era, int n) {
        boolean bl = era instanceof JapaneseEra;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ClassCastException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassCastException.<init>:(Ljava/lang/String;)V");
            ClassCastException classCastException = new ClassCastException("Era must be JapaneseEra");
            RuntimeCostAccounter.recordThrow();
            throw classCastException;
        }
        JapaneseEra japaneseEra = (JapaneseEra)era;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.getPrivateEra:()Lsun/util/calendar/Era;");
        sandbox.sun.util.calendar.Era era2 = japaneseEra.getPrivateEra();
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/Era.getSinceDate:()Lsun/util/calendar/CalendarDate;");
        CalendarDate calendarDate = era2.getSinceDate();
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/CalendarDate.getYear:()I");
        int n2 = calendarDate.getYear() + n - 1;
        RuntimeCostAccounter.recordJump();
        if (n == 1) {
            return n2;
        }
        RuntimeCostAccounter.recordJump();
        if (n2 >= -999999999) {
            RuntimeCostAccounter.recordJump();
            if (n2 <= 999999999) {
                RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/LocalGregorianCalendar.newCalendarDate:(Ljava/util/TimeZone;)Lsun/util/calendar/LocalGregorianCalendar$Date;");
                LocalGregorianCalendar.Date date = JCAL.newCalendarDate(null);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.getPrivateEra:()Lsun/util/calendar/Era;");
                sandbox.sun.util.calendar.Era era3 = japaneseEra.getPrivateEra();
                RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/LocalGregorianCalendar$Date.setEra:(Lsun/util/calendar/Era;)Lsun/util/calendar/LocalGregorianCalendar$Date;");
                LocalGregorianCalendar.Date date2 = date.setEra(era3);
                RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/LocalGregorianCalendar$Date.setDate:(III)Lsun/util/calendar/CalendarDate;");
                date2.setDate(n, 1, 1);
                RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/LocalGregorianCalendar.validate:(Lsun/util/calendar/CalendarDate;)Z");
                boolean bl2 = JCAL.validate((CalendarDate)date);
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    return n2;
                }
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
        DateTimeException dateTimeException = new DateTimeException("Invalid yearOfEra value");
        RuntimeCostAccounter.recordThrow();
        throw dateTimeException;
    }

    @Override
    public JapaneseEra eraOf(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.of:(I)Ljava/time/chrono/JapaneseEra;");
        return JapaneseEra.of(n);
    }

    @Override
    public List<Era> eras() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.values:()[Ljava/time/chrono/JapaneseEra;");
        JapaneseEra[] japaneseEraArray = JapaneseEra.values();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.asList:([Ljava/lang/Object;)Ljava/util/List;");
        return Arrays.asList(japaneseEraArray);
    }

    JapaneseEra getCurrentEra() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.values:()[Ljava/time/chrono/JapaneseEra;");
        JapaneseEra[] japaneseEraArray = JapaneseEra.values();
        return japaneseEraArray[japaneseEraArray.length - 1];
    }

    @Override
    public ValueRange range(ChronoField chronoField) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
        switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("Unsupported field: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(chronoField);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder3.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
                UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
                RuntimeCostAccounter.recordThrow();
                throw unsupportedTemporalTypeException;
            }
            case 5: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.getInstance:(Ljava/util/Locale;)Ljava/util/Calendar;");
                Calendar calendar = Calendar.getInstance(LOCALE);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.getCurrentEra:()Ljava/time/chrono/JapaneseEra;");
                JapaneseEra japaneseEra = this.getCurrentEra();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.getPrivateEra:()Lsun/util/calendar/Era;");
                sandbox.sun.util.calendar.Era era = japaneseEra.getPrivateEra();
                RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/Era.getSinceDate:()Lsun/util/calendar/CalendarDate;");
                CalendarDate calendarDate = era.getSinceDate();
                RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/CalendarDate.getYear:()I");
                int n = calendarDate.getYear();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.getGreatestMinimum:(I)I");
                long l = calendar.getGreatestMinimum(1);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.getLeastMaximum:(I)I");
                long l2 = calendar.getLeastMaximum(1) + 1;
                long l3 = 999999999 - n;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJJJ)Ljava/time/temporal/ValueRange;");
                return ValueRange.of(1L, l, l2, l3);
            }
            case 6: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.getInstance:(Ljava/util/Locale;)Ljava/util/Calendar;");
                Calendar calendar = Calendar.getInstance(LOCALE);
                int n = 6;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.getMinimum:(I)I");
                long l = calendar.getMinimum(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.getGreatestMinimum:(I)I");
                long l4 = calendar.getGreatestMinimum(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.getLeastMaximum:(I)I");
                long l5 = calendar.getLeastMaximum(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.getMaximum:(I)I");
                long l6 = calendar.getMaximum(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJJJ)Ljava/time/temporal/ValueRange;");
                return ValueRange.of(l, l4, l5, l6);
            }
            case 7: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getYear:()I");
                long l = JapaneseDate.MEIJI_6_ISODATE.getYear();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
                return ValueRange.of(l, 999999999L);
            }
            case 8: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.getValue:()I");
                long l = JapaneseEra.MEIJI.getValue();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.getCurrentEra:()Ljava/time/chrono/JapaneseEra;");
                JapaneseEra japaneseEra = this.getCurrentEra();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.getValue:()I");
                long l7 = japaneseEra.getValue();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
                return ValueRange.of(l, l7);
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.range:()Ljava/time/temporal/ValueRange;");
        return chronoField.range();
    }

    @Override
    public JapaneseDate resolveDate(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.resolveDate:(Ljava/util/Map;Ljava/time/format/ResolverStyle;)Ljava/time/chrono/ChronoLocalDate;");
        return (JapaneseDate)super.resolveDate(map, resolverStyle);
    }

    @Override
    ChronoLocalDate resolveYearOfEra(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        Long l = map.get(ChronoField.ERA);
        JapaneseEra japaneseEra = null;
        RuntimeCostAccounter.recordJump();
        if (l != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
            ValueRange valueRange = this.range(ChronoField.ERA);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l2 = l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
            int n = valueRange.checkValidIntValue(l2, ChronoField.ERA);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.eraOf:(I)Ljava/time/chrono/JapaneseEra;");
            japaneseEra = this.eraOf(n);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        Long l3 = map.get(ChronoField.YEAR_OF_ERA);
        int n = 0;
        RuntimeCostAccounter.recordJump();
        if (l3 != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
            ValueRange valueRange = this.range(ChronoField.YEAR_OF_ERA);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l4 = l3;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
            n = valueRange.checkValidIntValue(l4, ChronoField.YEAR_OF_ERA);
        }
        RuntimeCostAccounter.recordJump();
        if (japaneseEra == null) {
            RuntimeCostAccounter.recordJump();
            if (l3 != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                boolean bl = map.containsKey(ChronoField.YEAR);
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    RuntimeCostAccounter.recordJump();
                    if (resolverStyle != ResolverStyle.STRICT) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.values:()[Ljava/time/chrono/JapaneseEra;");
                        JapaneseEra[] japaneseEraArray = JapaneseEra.values();
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.values:()[Ljava/time/chrono/JapaneseEra;");
                        japaneseEra = japaneseEraArray[JapaneseEra.values().length - 1];
                    }
                }
            }
        }
        RuntimeCostAccounter.recordJump();
        if (l3 != null) {
            RuntimeCostAccounter.recordJump();
            if (japaneseEra != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                boolean bl = map.containsKey(ChronoField.MONTH_OF_YEAR);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                    boolean bl2 = map.containsKey(ChronoField.DAY_OF_MONTH);
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.resolveYMD:(Ljava/time/chrono/JapaneseEra;ILjava/util/Map;Ljava/time/format/ResolverStyle;)Ljava/time/chrono/ChronoLocalDate;");
                        return this.resolveYMD(japaneseEra, n, map, resolverStyle);
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                boolean bl3 = map.containsKey(ChronoField.DAY_OF_YEAR);
                RuntimeCostAccounter.recordJump();
                if (bl3) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.resolveYD:(Ljava/time/chrono/JapaneseEra;ILjava/util/Map;Ljava/time/format/ResolverStyle;)Ljava/time/chrono/ChronoLocalDate;");
                    return this.resolveYD(japaneseEra, n, map, resolverStyle);
                }
            }
        }
        return null;
    }

    private int prolepticYearLenient(JapaneseEra japaneseEra, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.getPrivateEra:()Lsun/util/calendar/Era;");
        sandbox.sun.util.calendar.Era era = japaneseEra.getPrivateEra();
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/Era.getSinceDate:()Lsun/util/calendar/CalendarDate;");
        CalendarDate calendarDate = era.getSinceDate();
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/CalendarDate.getYear:()I");
        return calendarDate.getYear() + n - 1;
    }

    private ChronoLocalDate resolveYMD(JapaneseEra japaneseEra, int n, Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        int n2;
        int n3;
        block7: {
            JapaneseDate japaneseDate;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            map.remove(ChronoField.ERA);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            map.remove(ChronoField.YEAR_OF_ERA);
            RuntimeCostAccounter.recordJump();
            if (resolverStyle == ResolverStyle.LENIENT) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.prolepticYearLenient:(Ljava/time/chrono/JapaneseEra;I)I");
                int n4 = this.prolepticYearLenient(japaneseEra, n);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                long l = map.remove(ChronoField.MONTH_OF_YEAR);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
                long l2 = Math.subtractExact(l, 1L);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                long l3 = map.remove(ChronoField.DAY_OF_MONTH);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
                long l4 = Math.subtractExact(l3, 1L);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.date:(III)Ljava/time/chrono/JapaneseDate;");
                JapaneseDate japaneseDate2 = this.date(n4, 1, 1);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/JapaneseDate;");
                JapaneseDate japaneseDate3 = japaneseDate2.plus(l2, ChronoUnit.MONTHS);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/JapaneseDate;");
                return japaneseDate3.plus(l4, ChronoUnit.DAYS);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
            ValueRange valueRange = this.range(ChronoField.MONTH_OF_YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l = map.remove(ChronoField.MONTH_OF_YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
            n3 = valueRange.checkValidIntValue(l, ChronoField.MONTH_OF_YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
            ValueRange valueRange2 = this.range(ChronoField.DAY_OF_MONTH);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l5 = map.remove(ChronoField.DAY_OF_MONTH);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
            n2 = valueRange2.checkValidIntValue(l5, ChronoField.DAY_OF_MONTH);
            RuntimeCostAccounter.recordJump();
            if (resolverStyle != ResolverStyle.SMART) break block7;
            RuntimeCostAccounter.recordJump();
            if (n < 1) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("Invalid YearOfEra: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder3.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                DateTimeException dateTimeException = new DateTimeException(string);
                RuntimeCostAccounter.recordThrow();
                throw dateTimeException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.prolepticYearLenient:(Ljava/time/chrono/JapaneseEra;I)I");
            int n5 = this.prolepticYearLenient(japaneseEra, n);
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.date:(III)Ljava/time/chrono/JapaneseDate;");
                japaneseDate = this.date(n5, n3, n2);
            }
            catch (DateTimeException dateTimeException) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.date:(III)Ljava/time/chrono/JapaneseDate;");
                JapaneseDate japaneseDate4 = this.date(n5, n3, 1);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAdjusters.lastDayOfMonth:()Ljava/time/temporal/TemporalAdjuster;");
                TemporalAdjuster temporalAdjuster = TemporalAdjusters.lastDayOfMonth();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.with:(Ljava/time/temporal/TemporalAdjuster;)Ljava/time/chrono/JapaneseDate;");
                japaneseDate = japaneseDate4.with(temporalAdjuster);
            }
            RuntimeCostAccounter.recordJump();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.getEra:()Ljava/time/chrono/JapaneseEra;");
            JapaneseEra japaneseEra2 = japaneseDate.getEra();
            RuntimeCostAccounter.recordJump();
            if (japaneseEra2 != japaneseEra) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.get:(Ljava/time/temporal/TemporalField;)I");
                int n6 = japaneseDate.get(ChronoField.YEAR_OF_ERA);
                RuntimeCostAccounter.recordJump();
                if (n6 > 1) {
                    RuntimeCostAccounter.recordJump();
                    if (n > 1) {
                        RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder4 = stringBuilder.append("Invalid YearOfEra for Era: ");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder5 = stringBuilder4.append(japaneseEra);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder6 = stringBuilder5.append(" ");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder7 = stringBuilder6.append(n);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string = stringBuilder7.toString();
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                        DateTimeException dateTimeException = new DateTimeException(string);
                        RuntimeCostAccounter.recordThrow();
                        throw dateTimeException;
                    }
                }
            }
            return japaneseDate;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.date:(Ljava/time/chrono/Era;III)Ljava/time/chrono/JapaneseDate;");
        return this.date(japaneseEra, n, n3, n2);
    }

    private ChronoLocalDate resolveYD(JapaneseEra japaneseEra, int n, Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
        map.remove(ChronoField.ERA);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
        map.remove(ChronoField.YEAR_OF_ERA);
        RuntimeCostAccounter.recordJump();
        if (resolverStyle == ResolverStyle.LENIENT) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.prolepticYearLenient:(Ljava/time/chrono/JapaneseEra;I)I");
            int n2 = this.prolepticYearLenient(japaneseEra, n);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l = map.remove(ChronoField.DAY_OF_YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
            long l2 = Math.subtractExact(l, 1L);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.dateYearDay:(II)Ljava/time/chrono/JapaneseDate;");
            JapaneseDate japaneseDate = this.dateYearDay(n2, 1);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/JapaneseDate;");
            return japaneseDate.plus(l2, ChronoUnit.DAYS);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange = this.range(ChronoField.DAY_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
        long l = map.remove(ChronoField.DAY_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
        int n3 = valueRange.checkValidIntValue(l, ChronoField.DAY_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.dateYearDay:(Ljava/time/chrono/Era;II)Ljava/time/chrono/JapaneseDate;");
        return this.dateYearDay(japaneseEra, n, n3);
    }

    @Override
    Object writeReplace() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.writeReplace:()Ljava/lang/Object;");
        return super.writeReplace();
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    static {
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/CalendarSystem.forName:(Ljava/lang/String;)Lsun/util/calendar/CalendarSystem;");
        JCAL = (LocalGregorianCalendar)CalendarSystem.forName((String)"japanese");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.forLanguageTag:(Ljava/lang/String;)Ljava/util/Locale;");
        LOCALE = Locale.forLanguageTag("ja-JP-u-ca-japanese");
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/JapaneseChronology");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.<init>:()V");
        INSTANCE = new JapaneseChronology();
    }
}

