#!/usr/bin/env bash
echo "Running in shell $(ps  -ef | grep $$ | grep -v grep)"
NUM_CPU=$(nproc)
if test ${NUM_CPU} -le 8 ; then
  CORDA_CORE_TESTING_FORKS=1
  CORDA_NODE_INT_TESTING_FORKS=1
  CORDA_NODE_TESTING_FORKS=1
  CORDA_INT_TESTING_FORKS=1
  CORDA_TESTING_FORKS=1
elif test ${NUM_CPU} -gt 8 && test ${NUM_CPU} -le 16 ; then
  CORDA_CORE_TESTING_FORKS=2
  CORDA_NODE_INT_TESTING_FORKS=2
  CORDA_NODE_TESTING_FORKS=2
  CORDA_INT_TESTING_FORKS=2
  CORDA_TESTING_FORKS=2
elif test ${NUM_CPU} -gt 16 && test ${NUM_CPU} -le 32 ; then
  CORDA_CORE_TESTING_FORKS=4
  CORDA_NODE_INT_TESTING_FORKS=4
  CORDA_NODE_TESTING_FORKS=4
  CORDA_INT_TESTING_FORKS=2
  CORDA_TESTING_FORKS=2
else
  CORDA_CORE_TESTING_FORKS=8
  CORDA_NODE_INT_TESTING_FORKS=8
  CORDA_NODE_TESTING_FORKS=8
  CORDA_INT_TESTING_FORKS=4
  CORDA_TESTING_FORKS=4
fi
echo "CORDA_CORE_TESTING_FORKS=${CORDA_CORE_TESTING_FORKS}" >> /etc/environment
echo "CORDA_NODE_INT_TESTING_FORKS=${CORDA_NODE_INT_TESTING_FORKS}"  >> /etc/environment
echo "CORDA_NODE_TESTING_FORKS=${CORDA_NODE_TESTING_FORKS}"  >> /etc/environment
echo "CORDA_INT_TESTING_FORKS=${CORDA_INT_TESTING_FORKS}"  >> /etc/environment
echo "CORDA_TESTING_FORKS=${CORDA_TESTING_FORKS}" >> /etc/environment