/*
 * Decompiled with CFR 0.152.
 */
package net.corda.bank.api;

import java.io.Closeable;
import java.util.Currency;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.corda.bank.api.BankOfCordaWebApi;
import net.corda.client.rpc.CordaRPCClient;
import net.corda.client.rpc.CordaRPCConnection;
import net.corda.core.contracts.Amount;
import net.corda.core.identity.Party;
import net.corda.core.messaging.CordaRPCOps;
import net.corda.core.transactions.SignedTransaction;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.core.utilities.NetworkHostAndPort;
import net.corda.core.utilities.OpaqueBytes;
import net.corda.finance.flows.AbstractCashFlow;
import net.corda.finance.flows.CashIssueAndPaymentFlow;
import net.corda.testing.http.HttpApi;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lnet/corda/bank/api/BankOfCordaClientApi;", "", "()V", "BOC_RPC_PWD", "", "BOC_RPC_USER", "requestRPCIssue", "Lnet/corda/core/transactions/SignedTransaction;", "rpcAddress", "Lnet/corda/core/utilities/NetworkHostAndPort;", "params", "Lnet/corda/bank/api/BankOfCordaWebApi$IssueRequestParams;", "requestWebIssue", "", "webAddress", "bank-of-corda-demo"})
public final class BankOfCordaClientApi {
    @NotNull
    public static final String BOC_RPC_USER = "bankUser";
    @NotNull
    public static final String BOC_RPC_PWD = "test";
    public static final BankOfCordaClientApi INSTANCE;

    public final void requestWebIssue(@NotNull NetworkHostAndPort webAddress, @NotNull BankOfCordaWebApi.IssueRequestParams params) {
        Intrinsics.checkParameterIsNotNull((Object)webAddress, (String)"webAddress");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        HttpApi api = HttpApi.Companion.fromHostAndPort$default((HttpApi.Companion)HttpApi.Companion, (NetworkHostAndPort)webAddress, (String)"api/bank", null, null, (int)12, null);
        api.postJson("issue-asset-request", (Object)params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final SignedTransaction requestRPCIssue(@NotNull NetworkHostAndPort rpcAddress, @NotNull BankOfCordaWebApi.IssueRequestParams params) {
        Intrinsics.checkParameterIsNotNull((Object)rpcAddress, (String)"rpcAddress");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        CordaRPCClient client = new CordaRPCClient(rpcAddress, null, 2, null);
        Closeable closeable = (Closeable)client.start(BOC_RPC_USER, BOC_RPC_PWD);
        Throwable throwable = null;
        try {
            void arg0$iv;
            void $receiver$iv;
            byte by;
            byte[] byArray;
            Object v1;
            Amount<Currency> it;
            Object element$iv2;
            Party issueToParty;
            CordaRPCOps rpc;
            block8: {
                CordaRPCConnection connection = (CordaRPCConnection)closeable;
                rpc = connection.getProxy();
                KotlinUtilsKt.getOrThrow$default((Future)((Future)rpc.waitUntilNetworkReady()), null, (int)1, null);
                Party party = rpc.wellKnownPartyFromX500Name(params.getIssueToPartyName());
                if (party == null) {
                    throw (Throwable)new IllegalStateException("Unable to locate " + params.getIssueToPartyName() + " in Network Map Service");
                }
                issueToParty = party;
                Iterable $receiver$iv2 = rpc.notaryIdentities();
                for (Object element$iv2 : $receiver$iv2) {
                    it = (Amount<Currency>)element$iv2;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)params.getNotaryName())) continue;
                    v1 = element$iv2;
                    break block8;
                }
                v1 = null;
            }
            Party party = v1;
            if (party == null) {
                throw (Throwable)new IllegalStateException("Couldn't locate notary " + params.getNotaryName() + " in NetworkMapCache");
            }
            Party notaryLegalIdentity = party;
            boolean anonymous = true;
            element$iv2 = params.getIssuerBankPartyRef();
            int n = 0;
            byte[] byArray2 = byArray = new byte[1];
            OpaqueBytes.Companion companion = OpaqueBytes.Companion;
            byArray[n] = by = Byte.parseByte(element$iv2);
            OpaqueBytes issuerBankPartyRef = companion.of(byArray2);
            element$iv2 = rpc;
            it = params.getAmount();
            Boolean arg3$iv = anonymous;
            SignedTransaction signedTransaction = ((AbstractCashFlow.Result)KotlinUtilsKt.getOrThrow$default((Future)((Future)$receiver$iv.startFlowDynamic(CashIssueAndPaymentFlow.class, new Object[]{arg0$iv, issuerBankPartyRef, issueToParty, arg3$iv, notaryLegalIdentity}).getReturnValue()), null, (int)1, null)).getStx();
            return signedTransaction;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private BankOfCordaClientApi() {
    }

    static {
        BankOfCordaClientApi bankOfCordaClientApi;
        INSTANCE = bankOfCordaClientApi = new BankOfCordaClientApi();
    }
}

