require 'spec_helper'

describe 'invoice_lists/_form.html.haml' do
  let(:group)        {  groups(:bottom_layer_one) }
  let(:person)       {  people(:bottom_member) }
  let(:invoice)      {  group.invoices.build }
  let(:invoice_list) {  InvoiceList.new(group: group, recipient_ids: '1,2', invoice: invoice) }
  let(:dom)          {  Capybara::Node::Simple.new(render) }

  before do
    allow(view).to receive_messages({
      current_user: person,
      parent: group,
      cancel_url: '',
      model_class: InvoiceList,
      entry: invoice_list,
      path_args: [group, invoice_list]
    })

    allow(controller).to receive_messages(current_user: person)
  end

  it 'only renders invoice articles of group' do
    group.invoice_config.update(donation_calculation_year_amount: 1, donation_increase_percentage: 5)
    expect(group.invoice_articles).to have(3).items
    groups(:top_layer).invoice_articles.create!(number: 1, name: 'test')

    expect(dom).to have_select('invoice_item_article', options: [
      "",
      "BEI-JU - Beitrag Kinder",
      "BEI-18 - Beitrag Erwachsene",
      "ABO-NEWS - Abonnement der Mitgliederzeitschrift",
      "Spenden - Variabler Spendenaufruf"
    ])
  end

end
