## OAuth 2.0

Hitobito is an OAuth 2.0 provider, meaning that an external application can authenticate users via hitobito (usually in the form of a "Login via hitobito" feature, similar to Google and Facebook etc.). The external application can then query information about the user or use the [REST API](05_rest_api.md) in the name of the user, if the user has granted this permission. This works without giving the user's password or token to the external application.

### Managing OAuth applications in hitobito
Users with admin privilege on the application root group (e.g. "Bundesebene" or "Dachverband") are allowed to manage the OAuth applications in the global hitobito settings.

Applications must be registered with allowed callback URLs and allowed scopes (see below). The external application is identified by a UId (unique identifier) and an application secret, both of which are generated by hitobito.

#### Scopes
Different external applications need different types of data about their users. Scopes are used to define what information an external application can request and access.

| Scope        | Available user data / functionality       |
| ---          | ---                                       |
| `email`      | id, email                                 |
| `name`       | id, email, firstname, lastname, nickname  |
| `with_roles` | All the profile data, roles within groups |
| `oidc`       | OIDC identity token (userinfo endpoint)   |
| `api`        | All REST APIs                             |

The scope `with_roles` contains most of the profile information, including the fields of the name scope. Multiple scopes can be combined in a single authorization request.

### OAuth flow

#### Make hitobito ask the user for permission
Before an external application can read the user's data, it must first get the approval of the user. To do this, it redirects the user to a hitobito page displaying a confirmation dialogue to the user. The url to this dialogue page has the following parameters:

* `response_type` For the authorization request we always use the value `code`
* `client_id` The UId of the external application, this will be provided to you by your hitobito root group admin
* `redirect_uri` A URL where your application can receive the authorization code once the user grants the permission request. The hitobito root group admin needs to know this URL (or all possible URLs if the external application has multiple) in advance in order to create your `client_id`.
* * The URLs must have the `https://` protocol. Exception: On integration environments only, `localhost` URLs can also be used with `http://` (for testing and development purposes).
* * If you want to only test the OAuth functionality, you can use the special value `urn:ietf:wg:oauth:2.0:oob`, which will display the authorization token instead of redirecting the browser
* `scope` One or more scopes (see above) needed by your application, separated by spaces or `%20`. The hitobito root group admin needs to know this list in advance in order to create your `client_id`

An example of the full URL, where your application could redirect the user for asking permission:
```
https://demo.hitobito.com/oauth/authorize?response_type=code&client_id=df57d88580cd81d2f7ca9974ff5a45dece279a36d4f55fe741502dd3ebb60ba8&redirect_uri=https://my-external-application.ch/callback&scope=email%20name
```

If the user accepts the request, the user's browser will be redirected to the specified redirect URL, with the authorization code in the `code` query parameter. Make sure this is a valid URL in your application. In our example this could be `https://my-external-application.ch/callback?code=2dd87982736ffbd2b68820a2dbcc1f3bd59c5653c5d166339ce68c320f8d83c5`

#### Acquire an access token
The code returned by the authorization request can be used in your application to acquire an access token.

```bash
curl -X POST \
     -H "Accept: application/json" \
     -d "grant_type=authorization_code" \
     -d "client_id=df57d88580cd81d2f7ca9974ff5a45dece279a36d4f55fe741502dd3ebb60ba8" \
     -d "client_secret=2e1a8ef6676e3b9a13a75a7e6ae55879a02b8a5194af010dd8af0eb1a2ca0957" \
     -d "redirect_uri=https://my-external-application.ch/callback" \
     -d "code=2dd87982736ffbd2b68820a2dbcc1f3bd59c5653c5d166339ce68c320f8d83c5" \
     https://demo.hitobito.com/oauth/token
```

* `grant_type` For the token request we use the value `authorization_code`
* `client_id` The UId for the application, ask your hitobito root group admin
* `client_secret` The application secret, ask your hitobito root group admin
* `redirect_uri` Must be the same value as in the authorization request
* `code` The code received from the authorization request

The response will contain the access token (formatted here for readability):
```json
{
  "access_token": "a3922ce7b6776e293c40d1d47a16d3787b860fb31ee7b121793f40492bae309f",
  "token_type": "Bearer",
  "expires_in": 7200,
  "scope": "email name",
  "created_at": 1560862298
}
```

#### Use your access token to get information about the user

The freshly acquired token can be used in the `Authorization` HTTP header when accessing the OAuth profile endpoint. You also have to set the `X-Scope` HTTP header to one of the scopes you requested when asking the user for permission.
```bash
curl -H "Authorization: Bearer a3922ce7b6776e293c40d1d47a16d3787b860fb31ee7b121793f40492bae309f" \
     -H "X-Scope: name" \
     https://demo.hitobito.com/oauth/profile
```

An example response could be (formatted here for readability):
```json
{
  "id": 34,
  "email": "julia@example.com",
  "first_name": "Julia",
  "last_name": "Keller",
  "nickname": "Polka"
}
```

### Accessing the JSON-API

All endpoints from the [JSON API](05_rest_api.md) can be used with a personal OAuth access token, if the token has the `api` scope. There are two possibilities to use the API:

* **Query parameter**: Send `access_token` as query parameter in the URL, and append `.json` to the URL path
```bash
curl "https://demo.hitobito.com/de/groups/1.json?access_token=a3922ce7b6776e293c40d1d47a16d3787b860fb31ee7b121793f40492bae309f"
```

* **Request headers**: Set the following headers on the HTTP request: `Authorization: Bearer <access_token>` and `Accept: application/json`
```bash
curl -H "Authorization: Bearer a3922ce7b6776e293c40d1d47a16d3787b860fb31ee7b121793f40492bae309f" \
     -H "Accept: application/json" \
     https://demo.hitobito.com/de/groups/1
```
