# frozen_string_literal: true

#  Copyright (c) 2021, CVP Schweiz. This file is part of
#  hitobito and licensed under the Affero General Public License version 3
#  or later. See the COPYING file at the top-level directory or at
#  https://github.com/hitobito/hitobito.

class AddPersonDuplicates < ActiveRecord::Migration[6.0]
  def change
    create_table(:person_duplicates) do |t|
      t.integer :person_1_id, null: false
      t.integer :person_2_id, null: false
      t.boolean :ignore, null: false, default: false

      t.timestamps
    end

    add_index(:person_duplicates, [:person_1_id, :person_2_id], unique: true)
  end
end
