import { PivotSheet, S2Options } from '@antv/s2';

fetch(
  'https://gw.alipayobjects.com/os/bmw-prod/2a5dbbc8-d0a7-4d02-b7c9-34f6ca63cff6.json',
)
  .then((res) => res.json())
  .then(async (dataCfg) => {
    const container = document.getElementById('container');

    const s2Options: S2Options = {
      width: 600,
      height: 480,
      interaction: {
        hoverHighlight: false,
      },
      conditions: {
        interval: [
          {
            field: 'number',
            mapping(value, data, cell) {
              const defaultValueRange = cell.getValueRange();

              console.log('默认数据区间:', defaultValueRange);

              return {
                fill: '#80BFFF',
                // 自定义柱状图范围
                isCompare: true,
                // 自定义最大值和最小值
                maxValue: 8000,
                minValue: 300,
                fieldValue: Number(value) > 7900 ? 10 : value,
              };
            },
          },
        ],
      },
    };

    const s2 = new PivotSheet(container, dataCfg, s2Options);

    await s2.render();
  });
