---
title: Table
order: 1
---

This article will introduce the layout process of the schedule, so that readers can more directly understand the internal layout logic of `S2` .

In the process of parsing the layout, the following figure schedule is taken as an example:

<img alt="pivot-mode" src="https://gw.alipayobjects.com/mdn/rms_56cbb2/afts/img/A*PmpvRrcBEbMAAAAAAAAAAAAAARQnAQ" width="600">

## basic concept

The schedule is a basic table without the capability of cross-perspective analysis, so the schedule mainly includes two parts: **column header** and **content area** . Different from the pivot table, the detailed table has no row header and corner header area.

<img alt="s2-table-group" src="https://gw.alipayobjects.com/mdn/rms_56cbb2/afts/img/A*5q2TQJjNy2cAAAAAAAAAAAAAARQnAQ" width="800">

The [column header layout algorithm](/docs/manual/advanced/layout/pivot#%E5%B1%82%E7%BA%A7%E7%BB%93%E6%9E%84) of the schedule and the [on-demand rendering](/docs/manual/advanced/layout/pivot#%E6%8C%89%E9%9C%80%E6%B8%B2%E6%9F%93) of the content area are consistent with the pivot table, so I won’t repeat them here.

## serial number

The serial number column is a column automatically generated by S2 based on the data for the convenience of users, and is used to display the serial number. This column is essentially no different from the content area. But at the style level, it can be individually configured through `theme.rowCell` .

## ranks freeze

The frozen rows and columns will have special treatment in the layout. Simply put, the positioning of the frozen row and column grids is fixed. in:

<img src="https://gw.alipayobjects.com/mdn/rms_56cbb2/afts/img/A*tZkOSqYWVFQAAAAAAAAAAAAAARQnAQ" width="600" alt="preview">

* freeze row (frozenRow) freezes on the y-axis
* Freeze Trailing Row ( frozenTrailingRow ) freezes on the y-axis, and the y-coordinate calculates the layout backwards from the bottom of the table viewport.
* freeze column (frozenCol) to freeze on the x-axis
* The frozen trailing column ( frozenTrailingCol ) is frozen on the x-axis, and the x-coordinate calculates the layout backwards from the far right of the table's viewable area.
