---
title: Internationalization
order: 8
---

`S2` currently has built-`中/英`two sets of copywriting, the default is **Chinese** , [view all files](https://github.com/antvis/S2/tree/next/packages/s2-core/src/common/i18n)

## switch to selected language

Switch the international text by `setLang` , note: it needs to be called before the table is instantiated

*NB. Right now you only can use `en_US`, `zh_CN`, and `ru` built-in locales.*

```ts
import { setLang, PivotSheet } from '@antv/s2'

setLang('en_US')
// setLang('zh_CN')
// setLang('ru_RU');

const s2 = new PivotSheet()
s2.render()
```

## Extended Internationalization Copywriting

Extend the internationalized text through `extendLocale` , note: it needs to be called before the table is instantiated

```ts
import { i18n, extendLocale } from '@antv/s2'

const locale = {
  zh_CN: {
    test: '测试',
  },
  en_US: {
    test: 'test',
  },
  ru_RU: {
    test: 'тест',
  },
};

extendLocale(locale)

// 使用
i18n('test')
```

## some utility methods

```ts
import { i18n, getLocale, getLang, setLang } from '@antv/s2'

// 获取当前语言
getLang()  // 'zh_CN'

// 切换语言
setLang('en_US')

// 获取当前国际化文件
getLocale()

// 国际化函数
i18n('隐藏') // 'Hide'
```

## preview

<img alt="preview" src="https://gw.alipayobjects.com/zos/antfincdn/DtjUoaJDJ/8e06d4f0-5eba-46cf-a3c4-0c8afda25847.png" width="600">

<img alt="preview" src="https://gw.alipayobjects.com/zos/antfincdn/lF%26BCXiWb/39e4d4dc-2c7d-4062-8022-f58a0e9b1feb.png" width="300">

<img alt="preview" src="https://gw.alipayobjects.com/zos/antfincdn/WK9kBFa0M/330117f2-12d0-496b-b756-06c87259a0a5.png" width="300">
