---
title: Base Concept
order: 0
---

This article introduces the basic concepts of pivot tables.

## Introduction

In statistics, a pivot table is a table in matrix format that displays multivariate frequency distributions. They provide a basic picture of the relationship between two variables (or more), which can help discover the interaction between them and help businesses conduct cross-exploration analysis. They are currently one of the most frequently used charts in the field of commercial `BI` analysis. one.

### basic concept

* Measure (Indicator): The value itself, such as price, quantity, etc.
* Dimension: It can be understood as the angle of analyzing data, such as province, type, etc.

### constitute

A pivot table consists of five parts, namely row header, column header, corner header, data cell, and frame, as shown in the following figure:

<img src="https://gw.alipayobjects.com/mdn/rms_56cbb2/afts/img/A*7FRBQr_tE4YAAAAAAAAAAAAAARQnAQ" width="600" alt="preview">

## row header (rowHeader)

The structure of the row header is determined by `s2DataConfig.fields.rows` , which is used for row analysis dimension display. The line head supports two display forms:`平铺模式(grid)` and`树状模式(tree)` .

For example, the line header data configures `province, city` fields

```ts
const s2DataConfig = {
  fields: {
    rows: ['province', 'city']
  }
}
```

Displayed in tiled mode as:

```ts
const s2Options = {
  hierarchyType: 'grid'
}
```

<br>

![row](https://gw.alipayobjects.com/mdn/rms_56cbb2/afts/img/A*p71xTrX3YIEAAAAAAAAAAAAAARQnAQ)

Displayed in tree mode as:

```ts
const s2Options = {
  hierarchyType: 'tree'
}
```

<br>

![column](https://gw.alipayobjects.com/mdn/rms_56cbb2/afts/img/A*zYzLQ5rgzsoAAAAAAAAAAAAAARQnAQ)

## column header (colHeader)

> Note that when it is a detailed table, only columns need to be set.

The structure of the column header is determined by `s2DataConfig.fields.columns` , which is used for column analysis dimension display.

For example, the column header data configures two fields, `type, sub_type` , which are displayed as:

```ts
const s2DataConfig = {
  fields: {
    columns: ['type', 'sub_type']
  }
}
```

<br>

![column](https://gw.alipayobjects.com/mdn/rms_56cbb2/afts/img/A*_uMfQK9VHk4AAAAAAAAAAAAAARQnAQ)

## Corner Header (cornerHeader)

The corner header refers to the upper left corner of the table and plays an important role in the layout of the table.

In the layout of the table, `S2` is extended based on the corner header to calculate the size and coordinates of rows and columns.

Corner headers are also used to display row headers and column header names, such as`省份`and`城市`in the example.

In addition, `S2` also provides custom extensions for scenarios that require custom corner headers, see [cornerCell](/examples/custom/custom-cell#corner-cell) and [cornerHeader](/examples/custom/custom-cell#corner-header) for details.

## Data cell (dataCell)

The data cell is the data area generated by the intersection of the row and column dimension values of the table. Usually, it should be the measurement value, and it is the core data presentation area of the table data analysis.

In the data cell area, we can display basic cross data, use [field tags](/examples/analysis/conditions#text) to assist analysis, and display [derivative indicators such as year-on-](/examples/react-component/sheet/#strategy) year comparisons. You can also customize data cells by customizing `Hooks` . For more information, refer to [dataCell](/examples/custom/custom-cell#data-cell) .

## frame

The frame layout area, located above the other four areas, is used as a spacer frame between areas, or logic such as scroll bars, and shadows of frame interval lines.
