---
title: Style
order: 4
---

## style

object is **required** , *default: null* Function description: style setting

| parameter       | type                                     | required | Defaults | Functional description                                                                                                                                                                                                                                                                                                                                                                                                         |
| --------------- | ---------------------------------------- | -------- | -------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| layoutWidthType | `adaptive` \| `colAdaptive` \| `compact` |          |          | Cell Width Layout Type<br>`adaptive` : Rows and columns are equal in width, equally dividing the entire `Canvas` canvas width<br>`colAdaptive` : Equal width of columns, compact layout of line headers, the remaining width of the column equally divided canvas width minus the width of line headers<br>`compact` : compact row and column layout, when the indicator dimension is small, it cannot cover the entire canvas |
| dataCell        | [DataCell](#dataCell)                    |          |          | Value cell configuration                                                                                                                                                                                                                                                                                                                                                                                                       |
| colCell         | [ColCell](#colCell)                      |          |          | Column header cell configuration                                                                                                                                                                                                                                                                                                                                                                                               |
| rowCell         | [RowCell](#rowCell)                      |          |          | Row header cell configuration                                                                                                                                                                                                                                                                                                                                                                                                  |

### DataCell

object is **required** , *default: null* Function description: Numerical cell configuration

| parameter | illustrate         | type                                                                                    | Defaults | required |
| --------- | ------------------ | --------------------------------------------------------------------------------------- | -------- | -------- |
| width     | cell width         | `number`                                                                                | 96       | -        |
| height    | cell height        | `number`                                                                                | 30       | -        |
| valuesCfg | cell configuration | `{ originalValueField?: string, widthPercent?: number[], showOriginalValue?: boolean }` |          | -        |

### ColCell

object is **required** , *default: null* Function description: Column header cell configuration

| parameter     | illustrate                                                                                                                                                                                                                                                                                                                                                                                                             | type                                  | Defaults | required |
| ------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------- | -------- | -------- |
| width         | Cell width, which can be dynamically set according to the current column header node (leaf nodes are valid)                                                                                                                                                                                                                                                                                                            | `number \| (colNode: Node) => number` | 96       |          |
| height        | Cell height, which can be dynamically set according to the current column header node (leaf nodes are valid)                                                                                                                                                                                                                                                                                                           | `number \| (colNode: Node) => number` | 30       |          |
| widthByField  | Set the width according to the measurement value (drag or preset width scene), `field` corresponds to the `field` or column header id in `s2DataConfig.fields.columns` , [see details](/docs/manual/advanced/custom/cell-size#%E8%B0%83%E6%95%B4%E8%A1%8C%E5%A4%B4%E5%8D%95%E5%85%83%E6%A0%BC%E5%AE%BD%E9%AB%98)                                                                                                       | `Record<string, number>`              | -        |          |
| heightByField | Set the height according to the measurement value (drag or preset height scene), the `field` corresponds to the `field` or column header id in `s2DataConfig.fields.columns` , [see details](/docs/manual/advanced/custom/cell-size#%E8%B0%83%E6%95%B4%E8%A1%8C%E5%A4%B4%E5%8D%95%E5%85%83%E6%A0%BC%E5%AE%BD%E9%AB%98)                                                                                                 | `Record<string, number>`              | -        |          |
| hideValue     | The default value hangs the column header, which will display the column header and the value at the same time, and hide the value to make it more beautiful. (that is, `s2DataConfig.fields.values` and it is only valid for a single value, and it is recommended to use [hidden column headers](https://s2.antv.vision/manual/advanced/interaction/hide-columns#2-%E9%80%8F%E8%A7%86%E8%A1%A8) for multiple values) | `boolean`                             | false    |          |

### RowCell

object is **required** , *default: null* Function description: row header cell configuration

| parameter                | illustrate                                                                                                                                                                                                                                                                                                                                                                             | type                                  | Defaults                   | required |
| ------------------------ | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------- | -------------------------- | -------- |
| width                    | The row cell width can be dynamically set according to the current row header node, and the tree structure is also applicable                                                                                                                                                                                                                                                          | `number \| (rowNode: Node) => number` | Tiles: `96` , Trees: `120` |          |
| height                   | Row cell height, which can be dynamically set according to the current row header node                                                                                                                                                                                                                                                                                                 | `number \| (rowNode: Node) => number` | 30                         |          |
| collapseFields           | Custom folded nodes for row headers in tree mode.<br>Supports two formats: id ( `'root[&] 行头维度值'` ) and dimension field ( `'city'` ). The priority is higher than `collapseAll` and `expandDepth` , and the priority is the lowest when it is set to `null` . [view demo](/examples/basic/pivot#tree)                                                                                  | `Record<string, boolean>`             |                            |          |
| collapseAll              | Whether to collapse all line headers by default in tree structure mode.                                                                                                                                                                                                                                                                                                                | `boolean`                             | `false`                    |          |
| expandDepth              | In the tree structure mode, the row header expands the expanded level by default (the level starts from 0), and when it is set to `null` , the priority is the lowest                                                                                                                                                                                                                  | `number`                              |                            |          |
| showTreeLeafNodeAlignDot | In the tree mode, whether the row header leaf nodes display the hierarchical placeholders                                                                                                                                                                                                                                                                                              | `boolean`                             | `false`                    |          |
| withByField              | Set the width of each line according to `field` . `field` corresponds to the `field` or column header id in `s2DataConfig.fields.rows` , [see details](/docs/manual/advanced/custom/cell-size#%E8%B0%83%E6%95%B4%E8%A1%8C%E5%A4%B4%E5%8D%95%E5%85%83%E6%A0%BC%E5%AE%BD%E9%AB%98)                                                                                                       | `Record<string, number>`              | -                          |          |
| heightByField            | Set the height of each row according to `field` .<br>1. Pivot table: `field` corresponds to `field` or column header id in `s2DataConfig.fields.rows` .<br>2. Detailed table: `field` corresponds to the row number, starting from `1` . [check the details](/docs/manual/advanced/custom/cell-size#%E8%B0%83%E6%95%B4%E8%A1%8C%E5%A4%B4%E5%8D%95%E5%85%83%E6%A0%BC%E5%AE%BD%E9%AB%98) | `Record<string, number>`              | -                          |          |
