---
title: Packages
order: 5
---

:::info{title="提示"}

创建 `S2` 表格有三种方式，基础类版本 `@antv/s2` 和 基于 `@antv/s2` 封装的 `React` 和 `Vue3` 版本：

- `@antv/s2`: 基于 `Canvas` 和 [AntV/G 6.0](https://g.antv.antgroup.com) 开发，提供基本的表格展示/交互等能力。

版本依赖：无

- `@antv/s2-react`: 基于 `React 18`, `@antv/s2`, `antd@5.x` 封装，提供配套的 [分析组件](/manual/basic/analysis/switcher).

版本依赖：

```json
"peerDependencies": {
  "@ant-design/icons": ">=4.7.0",
  "@antv/s2": "^2.0.0-next.1",
  "antd": "^5.0.0",
  "react": ">=16.9.0",
  "react-dom": ">=16.9.0"
}
```

- `@antv/s2-vue`: 基于 `Vue3`, `@antv/s2` , `ant-design-vue@3.x` 封装，提供配套的分析组件。

版本依赖：

```json
"peerDependencies": {
  "@antv/s2": "^2.0.0-next.1",
  "ant-design-vue": "^3.2.0",
  "vue": ">=3.x"
}
```

**也就是说** `@antv/s2` 和**框架无关**，无任何**额外依赖**, 你可以在 `Vue`, `Angular` 等任意框架中使用。
:::

| 版本号  | 稳定版    | 测试版   | 预览版  | 先行版 | 包大小  | 下载量    |
| -------- | ------ | --------- | ---------- | ----------  | ----------  | ------ |
| [@antv/s2](https://github.com/antvis/S2/tree/next/packages/s2-core)        | ![latest](https://img.shields.io/npm/v/@antv/s2/latest.svg?logo=npm)       | ![beta](https://img.shields.io/npm/v/@antv/s2/beta.svg?logo=npm)       | ![alpha](https://img.shields.io/npm/v/@antv/s2/alpha.svg?logo=npm)   |  ![next](https://img.shields.io/npm/v/@antv/s2/next.svg?logo=npm)  | ![size](https://img.badgesize.io/https:/unpkg.com/@antv/s2@latest/dist/index.min.js?label=gzip%20size&compression=gzip)       | ![download](https://img.shields.io/npm/dm/@antv/s2.svg?logo=npm)       |
| [@antv/s2-react](https://github.com/antvis/S2/tree/next/packages/s2-react) | ![latest](https://img.shields.io/npm/v/@antv/s2-react/latest.svg?logo=npm) | ![beta](https://img.shields.io/npm/v/@antv/s2-react/beta.svg?logo=npm) | ![alpha](https://img.shields.io/npm/v/@antv/s2-react/alpha.svg?logo=npm) |  ![next](https://img.shields.io/npm/v/@antv/s2-react/next.svg?logo=npm)| ![size](https://img.badgesize.io/https:/unpkg.com/@antv/s2-react@latest/dist/index.min.js?label=gzip%20size&compression=gzip) | ![download](https://img.shields.io/npm/dm/@antv/s2-react.svg?logo=npm) |
| [@antv/s2-vue](https://github.com/antvis/S2/tree/next/packages/s2-vue)     | ![latest](https://img.shields.io/npm/v/@antv/s2-vue/latest.svg?logo=npm)   | ![beta](https://img.shields.io/npm/v/@antv/s2-vue/beta.svg?logo=npm)   | ![alpha](https://img.shields.io/npm/v/@antv/s2-vue/alpha.svg?logo=npm)  |  ![next](https://img.shields.io/npm/v/@antv/s2-vue/next.svg?logo=npm) | ![size](https://img.badgesize.io/https:/unpkg.com/@antv/s2-vue@latest/dist/index.min.js?label=gzip%20size&compression=gzip)   | ![download](https://img.shields.io/npm/dm/@antv/s2-vue.svg?logo=npm)   |

:::info{title='如何获取新版本发布通知？'}

- 订阅：[https://github.com/antvis/S2/releases.atom](https://github.com/antvis/S2/releases.atom) 来获得新版本发布的通知。
- 加入钉钉交流群，新版本发布后，会通过🤖 群机器人推送。
- `Watch` [S2 代码仓库](https://github.com/antvis/S2), 选择 `Custom - Releases` 来获取消息推送。

![preview](https://mdn.alipayobjects.com/huamei_qa8qxu/afts/img/A*NKYFSKFV_scAAAAAAAAAAAAADmJ7AQ/original)
