---
title: SpreadSheet
order: 1
---

Function description: properties and methods related to form instances. [details](https://github.com/antvis/S2/blob/next/packages/s2-core/src/sheet-type/spread-sheet.ts)

```ts
const s2 = new PivotSheet()

s2.isPivotMode()
```

| parameter                  | illustrate                                                                                                                                                                                       | type                                                                                                                                                                   | Version                                                              |
| -------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------- |
| dom                        | mounted container node                                                                                                                                                                           | `string` \| `HTMLElement`                                                                                                                                              |                                                                      |
| theme                      | theme configuration                                                                                                                                                                              | [S2Theme](/docs/api/general/S2Theme)                                                                                                                                   |                                                                      |
| store                      | some information stored                                                                                                                                                                          | [store](/docs/api/basic-class/store)                                                                                                                                   |                                                                      |
| dataCfg                    | data configuration                                                                                                                                                                               | [S2DataConfig](/docs/api/general/S2DataConfig)                                                                                                                         |                                                                      |
| options                    | table configuration                                                                                                                                                                              | [S2Options](/docs/api/general/S2Options)                                                                                                                               |                                                                      |
| dataSet                    | Tabular Dataset (fields, data, sort)                                                                                                                                                             | [BaseDataSet](/docs/api/basic-class/base-data-set)                                                                                                                     |                                                                      |
| facet                      | current viewable rendering area                                                                                                                                                                  | [BaseFacet](/docs/api/basic-class/base-facet)                                                                                                                          |                                                                      |
| tooltip                    | tooltip                                                                                                                                                                                          | [BaseTooltip](/docs/api/basic-class/base-tooltip)                                                                                                                      |                                                                      |
| container                  | g-canvas example                                                                                                                                                                                 | [Canvas](https://g.antv.vision/zh/docs/api/canvas)                                                                                                                     |                                                                      |
| interaction                | interact                                                                                                                                                                                         | [Interaction](/zh/docs/api/basic-class/interaction)                                                                                                                    |                                                                      |
| hd                  | HD adaptation                                                                                                                                                                                    | [HdAdapter](https://github.com/antvis/S2/blob/next/packages/s2-core/src/ui/hd-adapter/index.ts)                                                                      |                                                                      |
| on                         | event subscription                                                                                                                                                                               | (event: [S2Event](/docs/manual/advanced/interaction/basic) , listener: () => void) => void                                                                             |                                                                      |
| emit                       | event release                                                                                                                                                                                    | (event: [S2Event](/docs/manual/advanced/interaction/basic) , ...args: any\[]) => void                                                                                  |                                                                      |
| getDataSet                 | get dataset                                                                                                                                                                                      | (options: [S2Options](/docs/api/general/S2Options) ) => [BaseDataSet](/docs/api/basic-class/base-data-set)                                                             |                                                                      |
| isPivotMode                | Is it a pivot table                                                                                                                                                                              | `() => boolean`                                                                                                                                                        |                                                                      |
| isHierarchyTreeType        | Is it a tree structure                                                                                                                                                                           | `() => boolean`                                                                                                                                                        |                                                                      |
| isFrozenRowHeader          | Whether it is the state of freezing line header                                                                                                                                                  | `() => boolean`                                                                                                                                                        |                                                                      |
| isTableMode                | Is it a schedule                                                                                                                                                                                 | `() => boolean`                                                                                                                                                        |                                                                      |
| isValueInCols              | Is the value placed at the beginning of the line                                                                                                                                                 | `() => boolean`                                                                                                                                                        |                                                                      |
| clearDrillDownData         | Clear drill down data                                                                                                                                                                            | `(rowNodeId?: string) => void`                                                                                                                                         |                                                                      |
| showTooltip                | show tooltip                                                                                                                                                                                     | (showOptions: [TooltipShowOptions](/docs/api/common/custom-tooltip) ) => void                                                                                          |                                                                      |
| showTooltipWithInfo        | Display tooltip, and display some default information                                                                                                                                            | (event: `CanvasEvent \| MouseEvent` , data: [TooltipData\[\]](/docs/api/common/custom-tooltip) , options?: [TooltipOptions](/docs/api/common/custom-tooltip) ) => void |                                                                      |
| hideTooltip                | hide tooltip                                                                                                                                                                                     | `() => void`                                                                                                                                                           |                                                                      |
| destroyTooltip             | destroy tooltip                                                                                                                                                                                  | `() => void`                                                                                                                                                           |                                                                      |
| registerIcons              | Register custom svg icons (according to `options.customSVGIcons` )                                                                                                                               | `() => void`                                                                                                                                                           |                                                                      |
| setDataCfg                 | Update data configuration                                                                                                                                                                        | (dataCfg: [S2DataConfig](/docs/api/general/S2DataConfig) , reset?: boolean ) => void                                                                                   | The `reset` parameter needs to be used in `@antv/s2^1.34.0` version |
| setOptions                 | Update table configuration                                                                                                                                                                       | (options: [S2Options](/docs/api/general/S2Options) , reset?: boolean) => void                                                                                          | The `reset` parameter needs to be used in `@antv/s2^1.34.0` version |
| render                     | Re-render the table, if `reloadData` = true, the data will be recalculated, `rebuildDataSet` = true, rebuild the data set, `reBuildHiddenColumnsDetail` = true rebuild hidden column information | `(reloadData?: boolean, { rebuildDataSet?: boolean; reBuildHiddenColumnsDetail?: boolean }) => Promise<void>`                                                                   |                                                                      |
| destroy                    | destroy form                                                                                                                                                                                     | `() => void`                                                                                                                                                           |                                                                      |
| setThemeCfg                | Update theme configuration (including theme schema, color palette, theme name)                                                                                                                   | (themeCfg: [ThemeCfg](/docs/api/general/S2Theme/#themecfg) ) => void                                                                                                   |                                                                      |
| setTheme                   | Update theme (only contains theme scheme)                                                                                                                                                        | (theme: [S2Theme](/docs/api/general/S2Theme/#s2theme) ) => void                                                                                                        |                                                                      |
| updatePagination           | update pagination                                                                                                                                                                                | (pagination: [Pagination](/docs/api/general/S2Options#pagination) ) => void                                                                                            |                                                                      |
| changeSheetSize            | Modify table canvas size without reloading data                                                                                                                                                  | `(width?: number, height?: number) => void`                                                                                                                            |                                                                      |
| getLayoutWidthType         | Get the cell width layout type (LayoutWidthType: `adaptive（自适应）` \| `colAdaptive（列自适应）` \| `compact（紧凑）` )                                                                                       | () => `LayoutWidthType`                                                                                                                                                |                                                                      |
| getRowNodes                | Get row header node                                                                                                                                                                              | (level: number) => [Node\[\]](/docs/api/basic-class/node/)                                                                                                             |                                                                      |
| getRowLeafNodes            | Get the row header leaf node                                                                                                                                                                     | () => [Node\[\]](/docs/api/basic-class/node/)                                                                                                                          |                                                                      |
| facet.getColNodes             | Get column head node                                                                                                                                                                             | (level: number) => [Node\[\]](/docs/api/basic-class/node/)                                                                                                             |                                                                      |
| facet.getColLeafNodes         | Get the column head leaf node                                                                                                                                                                    | () => [Node\[\]](/docs/api/basic-class/node/)                                                                                                                          |                                                                      |
| getCell                    | Get the current cell according to event.target                                                                                                                                                   | (target: [EventTarget](https://developer.mozilla.org/zh-CN/docs/Web/API/Event/target) ) => [S2CellType](/docs/api/basic-class/base-cell#s2celltype)                    |                                                                      |
| getCellType                | Get the current cell type according to event.target                                                                                                                                              | (target: [EventTarget](https://developer.mozilla.org/zh-CN/docs/Web/API/Event/target) ) => [CellType](/docs/api/basic-class/base-cell#celltypes)                      |                                                                      |
| getTotalsConfig            | Get Total Subtotal Configuration                                                                                                                                                                 | (dimension: string) => [Total](/docs/api/general/S2Options#totals)                                                                                                     |                                                                      |
| getCanvasElement           | Get the `<canvas/>` HTML element corresponding to the table                                                                                                                                      | () => [HTMLCanvasElement](https://developer.mozilla.org/zh-CN/docs/Web/API/HTMLCanvasElement)                                                                          |                                                                      |
| updateSortMethodMap        | Update the node sorting method map stored in the store, replace is whether to overwrite the last value                                                                                           | (nodeId: string, sortMethod: string, replace?: boolean) => void                                                                                                        |                                                                      |
| getMenuDefaultSelectedKeys | Get the key value of the menu item selected in the tooltip                                                                                                                                       | `(nodeId: string) => string[]`                                                                                                                                         |                                                                      |
| measureText                | Get the measurement information of the text in the canvas                                                                                                                                        | (text: `string` , font: [TextTheme](/docs/api/general/S2Theme#texttheme) ) => [TextMetrics](https://developer.mozilla.org/zh-CN/docs/Web/API/TextMetrics) \| `null`    |                                                                      |
| measureTextWidth           | Get the measured width of the text in the canvas                                                                                                                                                 | (text: `string` , font: [TextTheme](/docs/api/general/S2Theme#texttheme) ) => `number` \| `null`                                                                       |                                                                      |
| measureTextHeight          | Get the measured height of the text in the canvas                                                                                                                                                | (text: `string` , font: [TextTheme](/docs/api/general/S2Theme#texttheme) ) => `number` \| `null`                                                                       |                                                                      |

### S2MountContainer

```ts
type S2MountContainer = string | HTMLElement;
```

### ScrollOffsetConfig

Function description: Scroll offset configuration

```ts
interface ScrollOffsetConfig {
  offsetX?: {
    value: number | undefined;
    animate?: boolean;
  };
  offsetY?: {
    value: number | undefined;
    animate?: boolean;
  };
}
```

### CellType

Function description: cell type

```ts
export enum CellType {
  DATA_CELL = 'dataCell',  // 数值单元格
  ROW_CELL = 'rowCell', // 行头单元格
  COL_CELL = 'colCell', // 列头单元格
  CORNER_CELL = 'cornerCell', // 角头单元格
  MERGED_CELL = 'mergedCell', // 合并后的单元格
}
```

### BBox

Functional Description: Box Model

```ts
type BBox = {
  x: number;
  y: number;
  minX: number;
  minY: number;
  maxX: number;
  maxY: number;
  width: number;
  height: number;
};
```
