import React from 'react';
import type { RadioIconProps } from '../../../common/interface/icon';

export const LeftAlignIcon = React.memo<RadioIconProps>(({ active }) => {
  if (active) {
    return (
      <svg
        className="si"
        width="12px"
        height="10px"
        viewBox="0 0 12 10"
        fill="currentColor"
      >
        <g
          id="设计输出"
          stroke="none"
          strokeWidth="1"
          fill="none"
          fillRule="evenodd"
        >
          <g
            transform="translate(-309.000000, -5352.000000)"
            fill="#3471F9"
            fillRule="nonzero"
            id="编组-31"
          >
            <g transform="translate(127.000000, 4744.000000)">
              <g id="编组-16" transform="translate(28.000000, 569.000000)">
                <g id="编组-15" transform="translate(152.000000, 36.000000)">
                  <g id="编组" transform="translate(2.000000, 3.000000)">
                    <path
                      d="M11.238,1.045 L0.76,1.045 C0.341,1.045 0,0.81 0,0.522 C0,0.234 0.341,0 0.76,0 L11.24,0 C11.659,0 12,0.234 12,0.522 C11.998,0.812 11.659,1.045 11.238,1.045 Z M7.024,4.03 L0.474,4.03 C0.214,4.03 0,3.795 0,3.507 C0,3.219 0.213,2.985 0.475,2.985 L7.025,2.985 C7.287,2.985 7.5,3.219 7.5,3.507 C7.499,3.795 7.287,4.03 7.024,4.03 L7.024,4.03 Z M7.024,7.015 L0.474,7.015 C0.214,7.015 0,6.781 0,6.493 C0,6.205 0.213,5.97 0.475,5.97 L7.025,5.97 C7.287,5.97 7.5,6.205 7.5,6.493 C7.499,6.782 7.287,7.015 7.024,7.015 L7.024,7.015 Z M11.238,10 L0.76,10 C0.341,10 0,9.766 0,9.478 C0,9.19 0.341,8.955 0.76,8.955 L11.24,8.955 C11.659,8.955 12,9.19 12,9.478 C11.998,9.767 11.659,10 11.238,10 Z"
                      id="形状"
                    />
                  </g>
                </g>
              </g>
            </g>
          </g>
        </g>
      </svg>
    );
  }

  return (
    <svg
      className="si"
      width="12px"
      height="10px"
      viewBox="0 0 12 10"
      fill="currentColor"
    >
      <g
        id="设计输出"
        stroke="none"
        strokeWidth="1"
        fill="none"
        fillRule="evenodd"
        opacity="0.45"
      >
        <g
          transform="translate(-269.000000, -5288.000000)"
          fill="#000000"
          fillRule="nonzero"
          id="编组-31"
        >
          <g transform="translate(127.000000, 4744.000000)">
            <g id="编组-16备份" transform="translate(28.000000, 537.000000)">
              <g id="编组-14" transform="translate(112.000000, 4.000000)">
                <g id="编组" transform="translate(2.000000, 3.000000)">
                  <path
                    d="M11.238,1.045 L0.76,1.045 C0.341,1.045 0,0.81 0,0.522 C0,0.234 0.341,0 0.76,0 L11.24,0 C11.659,0 12,0.234 12,0.522 C11.998,0.812 11.659,1.045 11.238,1.045 Z M7.024,4.03 L0.474,4.03 C0.214,4.03 0,3.795 0,3.507 C0,3.219 0.213,2.985 0.475,2.985 L7.025,2.985 C7.287,2.985 7.5,3.219 7.5,3.507 C7.499,3.795 7.287,4.03 7.024,4.03 L7.024,4.03 Z M7.024,7.015 L0.474,7.015 C0.214,7.015 0,6.781 0,6.493 C0,6.205 0.213,5.97 0.475,5.97 L7.025,5.97 C7.287,5.97 7.5,6.205 7.5,6.493 C7.499,6.782 7.287,7.015 7.024,7.015 L7.024,7.015 Z M11.238,10 L0.76,10 C0.341,10 0,9.766 0,9.478 C0,9.19 0.341,8.955 0.76,8.955 L11.24,8.955 C11.659,8.955 12,9.19 12,9.478 C11.998,9.767 11.659,10 11.238,10 Z"
                    id="形状"
                  />
                </g>
              </g>
            </g>
          </g>
        </g>
      </g>
    </svg>
  );
});

export const CenterAlignIcon = React.memo<RadioIconProps>(({ active }) => {
  if (active) {
    return (
      <svg
        className="si"
        width="12px"
        height="11px"
        viewBox="0 0 12 11"
        fill="currentColor"
      >
        <g
          id="设计输出"
          stroke="none"
          strokeWidth="1"
          fill="none"
          fillRule="evenodd"
        >
          <g
            transform="translate(-301.000000, -5288.000000)"
            fill="#3471F9"
            fillRule="nonzero"
            id="编组-31"
          >
            <g transform="translate(127.000000, 4744.000000)">
              <g id="编组-16备份" transform="translate(28.000000, 537.000000)">
                <g id="编组-14" transform="translate(112.000000, 4.000000)">
                  <g id="编组-33" transform="translate(32.000000, 0.000000)">
                    <g id="编组" transform="translate(2.000000, 3.000000)">
                      <path
                        d="M11.238,4.045 L0.76,4.045 C0.341,4.045 0,3.81 0,3.522 C0,3.234 0.341,3 0.76,3 L11.24,3 C11.659,3 12,3.234 12,3.522 C11.998,3.812 11.659,4.045 11.238,4.045 Z M9.024,1.045 L2.474,1.045 C2.214,1.045 2,0.81 2,0.522 C2,0.234 2.213,0 2.475,0 L9.025,0 C9.287,0 9.5,0.234 9.5,0.522 C9.499,0.81 9.287,1.045 9.024,1.045 L9.024,1.045 Z M9.024,7.045 L2.474,7.045 C2.214,7.045 2,6.81 2,6.522 C2,6.234 2.213,6 2.475,6 L9.025,6 C9.287,6 9.5,6.234 9.5,6.522 C9.499,6.812 9.287,7.045 9.024,7.045 L9.024,7.045 Z M11.238,10.045 L0.76,10.045 C0.341,10.045 0,9.81 0,9.522 C0,9.234 0.341,9 0.76,9 L11.24,9 C11.659,9 12,9.234 12,9.522 C11.998,9.812 11.659,10.045 11.238,10.045 Z"
                        id="形状"
                      />
                    </g>
                  </g>
                </g>
              </g>
            </g>
          </g>
        </g>
      </svg>
    );
  }

  return (
    <svg
      className="si"
      width="12px"
      height="11px"
      viewBox="0 0 12 11"
      fill="currentColor"
    >
      <g
        id="设计输出"
        stroke="none"
        strokeWidth="1"
        fill="none"
        fillRule="evenodd"
        opacity="0.45"
      >
        <g
          transform="translate(-341.000000, -5352.000000)"
          fill="#000000"
          fillRule="nonzero"
          id="编组-31"
        >
          <g transform="translate(127.000000, 4744.000000)">
            <g id="编组-16" transform="translate(28.000000, 569.000000)">
              <g id="编组-15" transform="translate(152.000000, 36.000000)">
                <g id="编组-33备份" transform="translate(32.000000, 0.000000)">
                  <g id="编组" transform="translate(2.000000, 3.000000)">
                    <path
                      d="M11.238,4.045 L0.76,4.045 C0.341,4.045 0,3.81 0,3.522 C0,3.234 0.341,3 0.76,3 L11.24,3 C11.659,3 12,3.234 12,3.522 C11.998,3.812 11.659,4.045 11.238,4.045 Z M9.024,1.045 L2.474,1.045 C2.214,1.045 2,0.81 2,0.522 C2,0.234 2.213,0 2.475,0 L9.025,0 C9.287,0 9.5,0.234 9.5,0.522 C9.499,0.81 9.287,1.045 9.024,1.045 L9.024,1.045 Z M9.024,7.045 L2.474,7.045 C2.214,7.045 2,6.81 2,6.522 C2,6.234 2.213,6 2.475,6 L9.025,6 C9.287,6 9.5,6.234 9.5,6.522 C9.499,6.812 9.287,7.045 9.024,7.045 L9.024,7.045 Z M11.238,10.045 L0.76,10.045 C0.341,10.045 0,9.81 0,9.522 C0,9.234 0.341,9 0.76,9 L11.24,9 C11.659,9 12,9.234 12,9.522 C11.998,9.812 11.659,10.045 11.238,10.045 Z"
                      id="形状"
                    />
                  </g>
                </g>
              </g>
            </g>
          </g>
        </g>
      </g>
    </svg>
  );
});

export const RightAlignIcon = React.memo<RadioIconProps>(({ active }) => {
  if (active) {
    return (
      <svg
        className="si"
        width="12px"
        height="10px"
        viewBox="0 0 12 10"
        fill="currentColor"
      >
        <g
          id="设计输出"
          stroke="none"
          strokeWidth="1"
          fill="none"
          fillRule="evenodd"
          opacity="1"
        >
          <g
            transform="translate(-333.000000, -5288.000000)"
            fill="#3471F9"
            fillRule="nonzero"
            id="编组-31"
          >
            <g transform="translate(127.000000, 4744.000000)">
              <g id="编组-16备份" transform="translate(28.000000, 537.000000)">
                <g id="编组-14" transform="translate(112.000000, 4.000000)">
                  <g id="编组-32" transform="translate(64.000000, 0.000000)">
                    <g id="编组" transform="translate(2.000000, 3.000000)">
                      <path
                        d="M0.762,1.045 L11.24,1.045 C11.659,1.045 12,0.81 12,0.522 C12,0.234 11.659,0 11.24,0 L0.76,0 C0.34,0 0,0.234 0,0.522 C0.002,0.812 0.341,1.045 0.762,1.045 Z M4.976,4.03 L11.526,4.03 C11.786,4.03 12,3.795 12,3.507 C12,3.219 11.787,2.985 11.525,2.985 L4.975,2.985 C4.713,2.985 4.5,3.219 4.5,3.507 C4.501,3.795 4.713,4.03 4.976,4.03 Z M4.976,7.015 L11.526,7.015 C11.786,7.015 12,6.781 12,6.493 C12,6.205 11.787,5.97 11.525,5.97 L4.975,5.97 C4.713,5.97 4.5,6.205 4.5,6.493 C4.501,6.782 4.713,7.015 4.976,7.015 Z M0.762,10 L11.24,10 C11.659,10 12,9.766 12,9.478 C12,9.19 11.659,8.955 11.24,8.955 L0.76,8.955 C0.341,8.955 0,9.19 0,9.478 C0.002,9.767 0.341,10 0.762,10 Z"
                        id="形状"
                      />
                    </g>
                  </g>
                </g>
              </g>
            </g>
          </g>
        </g>
      </svg>
    );
  }

  return (
    <svg
      className="si"
      width="12px"
      height="10px"
      viewBox="0 0 12 10"
      fill="currentColor"
    >
      <g
        id="设计输出"
        stroke="none"
        strokeWidth="1"
        fill="none"
        fillRule="evenodd"
        opacity="0.45"
      >
        <g
          transform="translate(-333.000000, -5288.000000)"
          fill="#000000"
          fillRule="nonzero"
          id="编组-31"
        >
          <g transform="translate(127.000000, 4744.000000)">
            <g id="编组-16备份" transform="translate(28.000000, 537.000000)">
              <g id="编组-14" transform="translate(112.000000, 4.000000)">
                <g id="编组-32" transform="translate(64.000000, 0.000000)">
                  <g id="编组" transform="translate(2.000000, 3.000000)">
                    <path
                      d="M0.762,1.045 L11.24,1.045 C11.659,1.045 12,0.81 12,0.522 C12,0.234 11.659,0 11.24,0 L0.76,0 C0.34,0 0,0.234 0,0.522 C0.002,0.812 0.341,1.045 0.762,1.045 Z M4.976,4.03 L11.526,4.03 C11.786,4.03 12,3.795 12,3.507 C12,3.219 11.787,2.985 11.525,2.985 L4.975,2.985 C4.713,2.985 4.5,3.219 4.5,3.507 C4.501,3.795 4.713,4.03 4.976,4.03 Z M4.976,7.015 L11.526,7.015 C11.786,7.015 12,6.781 12,6.493 C12,6.205 11.787,5.97 11.525,5.97 L4.975,5.97 C4.713,5.97 4.5,6.205 4.5,6.493 C4.501,6.782 4.713,7.015 4.976,7.015 Z M0.762,10 L11.24,10 C11.659,10 12,9.766 12,9.478 C12,9.19 11.659,8.955 11.24,8.955 L0.76,8.955 C0.341,8.955 0,9.19 0,9.478 C0.002,9.767 0.341,10 0.762,10 Z"
                      id="形状"
                    />
                  </g>
                </g>
              </g>
            </g>
          </g>
        </g>
      </g>
    </svg>
  );
});
