---
name: 🐛 Bug report
about: Let us know something is wrong.
title: '🐛'
---

<!-- ⚠️ Please fill in the template strictly, otherwise it will be closed directly （请严格按照模板填写，否则直接关闭） -->
<!-- ⚠️ 请严格按照模板填写，否则直接关闭 -->

### 🏷 Version

<!-- Required! -->
<!-- 请填写你实际安装到 node_modules 中的具体版本号，请确保你已经尝试过安装最新版本解决问题，并且本地和官网都能复现该问题，请不要写 `latest`, `1.x` 这种没有意义的版本号 -->
<!-- 请不要写 🙅🏻‍♀️🚫 `latest`, `1.x` -->
<!--
eg.

| Package        | Version |
| -------------- | ------- |
| @antv/s2       |  1.2.0  |
| @antv/s2-react |  1.3.3  |
| @antv/s2-vue   |   -     |

-->

| Package        | Version |
| -------------- | ------- |
| @antv/s2       |         |
| @antv/s2-react |         |
| @antv/s2-vue   |         |

### Sheet Type

<!-- Required! -->
<!-- 请填写你具体使用的表格，这能帮助我们更快的定位问题 -->

- [ ] PivotSheet
- [ ] TableSheet
- [ ] GridAnalysisSheet
- [ ] StrategySheet
- [ ] EditableSheet

### 🖋 Description

<!-- Required! -->
<!-- 请填写你具体的问题描述，请不要惜字如金，尽可能的多提供一些你能想到的有用信息 -->

### ⌨️ Code Snapshots

<!-- Required! -->
<!-- eg. `s2Options` and `s2DataCfg`, or `<SheetComponent {...} />` -->
<!-- 请粘贴你的核心代码片段 （文本形式，而不是图片），包括但不限于 `报错信息`, `s2Options` 等，请不要粘贴你自己的业务代码，请注意使用 markdown code 标签 -->
<!-- 如果你使用官网的在线示例，编辑代码后复现了 Bug，请粘贴你的代码，而不是直接贴一个在线示例的链接，没有任何意义，它不会保存你刚写的代码 -->

### 🔗 Reproduce Link

<!-- eg. use S2 code sandbox template https://codesandbox.io/s/29zle -->
<!-- 请提供一个精简的可复现链接，它可以让我们更快的帮你复现，定位问题，这很重要，尽量避免 gif, 视频等形式 -->

### 🤔 Steps to Reproduce

<!-- Required! -->
<!-- 请不要惜字如金，粘贴一张图或者一句话就草草了事，我们需要你详细的复现步骤，说明这个问题需要怎么样的操作步骤才能复现 -->

### 😊 Expected Behavior

<!-- Required! -->
<!-- 说明这个问题的预期行为，只有你才最了解自己的代码，所以请不要让我们猜，请说明预期，比如：`数据不对，正确应该是：xx`, `布局错误：正确应该是 A 节点在 B 位置` -->

### 😅 Current Behavior

<!-- Required! -->
<!-- 说明这个问题当前行为，比如：`数据不对：杭州市下的小计数据应该是 1, 当前显示成了 2` -->

### 💻 System information

<!-- 请不要写 🙅🏻‍♀️🚫 `latest`, `1.x` -->
<!--
eg.

| Environment |     Info  |
| ------- | ------------- |
| System  |   window 10   |
| Browser | chrome: v91.0 |

-->

| Environment | Info |
| ------- | ------- |
| System  |         |
| Browser |         |
