// +build !ignore_autogenerated

/*
Copyright 2017 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// This file was autogenerated by conversion-gen. Do not edit it manually!

package v1

import (
	v1 "k8s.io/api/core/v1"
	resource "k8s.io/apimachinery/pkg/api/resource"
	meta_v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	types "k8s.io/apimachinery/pkg/types"
	api "k8s.io/kubernetes/pkg/api"
	unsafe "unsafe"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(scheme *runtime.Scheme) error {
	return scheme.AddGeneratedConversionFuncs(
		Convert_v1_AWSElasticBlockStoreVolumeSource_To_api_AWSElasticBlockStoreVolumeSource,
		Convert_api_AWSElasticBlockStoreVolumeSource_To_v1_AWSElasticBlockStoreVolumeSource,
		Convert_v1_Affinity_To_api_Affinity,
		Convert_api_Affinity_To_v1_Affinity,
		Convert_v1_AttachedVolume_To_api_AttachedVolume,
		Convert_api_AttachedVolume_To_v1_AttachedVolume,
		Convert_v1_AvoidPods_To_api_AvoidPods,
		Convert_api_AvoidPods_To_v1_AvoidPods,
		Convert_v1_AzureDiskVolumeSource_To_api_AzureDiskVolumeSource,
		Convert_api_AzureDiskVolumeSource_To_v1_AzureDiskVolumeSource,
		Convert_v1_AzureFilePersistentVolumeSource_To_api_AzureFilePersistentVolumeSource,
		Convert_api_AzureFilePersistentVolumeSource_To_v1_AzureFilePersistentVolumeSource,
		Convert_v1_AzureFileVolumeSource_To_api_AzureFileVolumeSource,
		Convert_api_AzureFileVolumeSource_To_v1_AzureFileVolumeSource,
		Convert_v1_Binding_To_api_Binding,
		Convert_api_Binding_To_v1_Binding,
		Convert_v1_Capabilities_To_api_Capabilities,
		Convert_api_Capabilities_To_v1_Capabilities,
		Convert_v1_CephFSPersistentVolumeSource_To_api_CephFSPersistentVolumeSource,
		Convert_api_CephFSPersistentVolumeSource_To_v1_CephFSPersistentVolumeSource,
		Convert_v1_CephFSVolumeSource_To_api_CephFSVolumeSource,
		Convert_api_CephFSVolumeSource_To_v1_CephFSVolumeSource,
		Convert_v1_CinderVolumeSource_To_api_CinderVolumeSource,
		Convert_api_CinderVolumeSource_To_v1_CinderVolumeSource,
		Convert_v1_ClientIPConfig_To_api_ClientIPConfig,
		Convert_api_ClientIPConfig_To_v1_ClientIPConfig,
		Convert_v1_ComponentCondition_To_api_ComponentCondition,
		Convert_api_ComponentCondition_To_v1_ComponentCondition,
		Convert_v1_ComponentStatus_To_api_ComponentStatus,
		Convert_api_ComponentStatus_To_v1_ComponentStatus,
		Convert_v1_ComponentStatusList_To_api_ComponentStatusList,
		Convert_api_ComponentStatusList_To_v1_ComponentStatusList,
		Convert_v1_ConfigMap_To_api_ConfigMap,
		Convert_api_ConfigMap_To_v1_ConfigMap,
		Convert_v1_ConfigMapEnvSource_To_api_ConfigMapEnvSource,
		Convert_api_ConfigMapEnvSource_To_v1_ConfigMapEnvSource,
		Convert_v1_ConfigMapKeySelector_To_api_ConfigMapKeySelector,
		Convert_api_ConfigMapKeySelector_To_v1_ConfigMapKeySelector,
		Convert_v1_ConfigMapList_To_api_ConfigMapList,
		Convert_api_ConfigMapList_To_v1_ConfigMapList,
		Convert_v1_ConfigMapProjection_To_api_ConfigMapProjection,
		Convert_api_ConfigMapProjection_To_v1_ConfigMapProjection,
		Convert_v1_ConfigMapVolumeSource_To_api_ConfigMapVolumeSource,
		Convert_api_ConfigMapVolumeSource_To_v1_ConfigMapVolumeSource,
		Convert_v1_Container_To_api_Container,
		Convert_api_Container_To_v1_Container,
		Convert_v1_ContainerImage_To_api_ContainerImage,
		Convert_api_ContainerImage_To_v1_ContainerImage,
		Convert_v1_ContainerPort_To_api_ContainerPort,
		Convert_api_ContainerPort_To_v1_ContainerPort,
		Convert_v1_ContainerState_To_api_ContainerState,
		Convert_api_ContainerState_To_v1_ContainerState,
		Convert_v1_ContainerStateRunning_To_api_ContainerStateRunning,
		Convert_api_ContainerStateRunning_To_v1_ContainerStateRunning,
		Convert_v1_ContainerStateTerminated_To_api_ContainerStateTerminated,
		Convert_api_ContainerStateTerminated_To_v1_ContainerStateTerminated,
		Convert_v1_ContainerStateWaiting_To_api_ContainerStateWaiting,
		Convert_api_ContainerStateWaiting_To_v1_ContainerStateWaiting,
		Convert_v1_ContainerStatus_To_api_ContainerStatus,
		Convert_api_ContainerStatus_To_v1_ContainerStatus,
		Convert_v1_DaemonEndpoint_To_api_DaemonEndpoint,
		Convert_api_DaemonEndpoint_To_v1_DaemonEndpoint,
		Convert_v1_DeleteOptions_To_api_DeleteOptions,
		Convert_api_DeleteOptions_To_v1_DeleteOptions,
		Convert_v1_DownwardAPIProjection_To_api_DownwardAPIProjection,
		Convert_api_DownwardAPIProjection_To_v1_DownwardAPIProjection,
		Convert_v1_DownwardAPIVolumeFile_To_api_DownwardAPIVolumeFile,
		Convert_api_DownwardAPIVolumeFile_To_v1_DownwardAPIVolumeFile,
		Convert_v1_DownwardAPIVolumeSource_To_api_DownwardAPIVolumeSource,
		Convert_api_DownwardAPIVolumeSource_To_v1_DownwardAPIVolumeSource,
		Convert_v1_EmptyDirVolumeSource_To_api_EmptyDirVolumeSource,
		Convert_api_EmptyDirVolumeSource_To_v1_EmptyDirVolumeSource,
		Convert_v1_EndpointAddress_To_api_EndpointAddress,
		Convert_api_EndpointAddress_To_v1_EndpointAddress,
		Convert_v1_EndpointPort_To_api_EndpointPort,
		Convert_api_EndpointPort_To_v1_EndpointPort,
		Convert_v1_EndpointSubset_To_api_EndpointSubset,
		Convert_api_EndpointSubset_To_v1_EndpointSubset,
		Convert_v1_Endpoints_To_api_Endpoints,
		Convert_api_Endpoints_To_v1_Endpoints,
		Convert_v1_EndpointsList_To_api_EndpointsList,
		Convert_api_EndpointsList_To_v1_EndpointsList,
		Convert_v1_EnvFromSource_To_api_EnvFromSource,
		Convert_api_EnvFromSource_To_v1_EnvFromSource,
		Convert_v1_EnvVar_To_api_EnvVar,
		Convert_api_EnvVar_To_v1_EnvVar,
		Convert_v1_EnvVarSource_To_api_EnvVarSource,
		Convert_api_EnvVarSource_To_v1_EnvVarSource,
		Convert_v1_Event_To_api_Event,
		Convert_api_Event_To_v1_Event,
		Convert_v1_EventList_To_api_EventList,
		Convert_api_EventList_To_v1_EventList,
		Convert_v1_EventSource_To_api_EventSource,
		Convert_api_EventSource_To_v1_EventSource,
		Convert_v1_ExecAction_To_api_ExecAction,
		Convert_api_ExecAction_To_v1_ExecAction,
		Convert_v1_FCVolumeSource_To_api_FCVolumeSource,
		Convert_api_FCVolumeSource_To_v1_FCVolumeSource,
		Convert_v1_FlexVolumeSource_To_api_FlexVolumeSource,
		Convert_api_FlexVolumeSource_To_v1_FlexVolumeSource,
		Convert_v1_FlockerVolumeSource_To_api_FlockerVolumeSource,
		Convert_api_FlockerVolumeSource_To_v1_FlockerVolumeSource,
		Convert_v1_GCEPersistentDiskVolumeSource_To_api_GCEPersistentDiskVolumeSource,
		Convert_api_GCEPersistentDiskVolumeSource_To_v1_GCEPersistentDiskVolumeSource,
		Convert_v1_GitRepoVolumeSource_To_api_GitRepoVolumeSource,
		Convert_api_GitRepoVolumeSource_To_v1_GitRepoVolumeSource,
		Convert_v1_GlusterfsVolumeSource_To_api_GlusterfsVolumeSource,
		Convert_api_GlusterfsVolumeSource_To_v1_GlusterfsVolumeSource,
		Convert_v1_HTTPGetAction_To_api_HTTPGetAction,
		Convert_api_HTTPGetAction_To_v1_HTTPGetAction,
		Convert_v1_HTTPHeader_To_api_HTTPHeader,
		Convert_api_HTTPHeader_To_v1_HTTPHeader,
		Convert_v1_Handler_To_api_Handler,
		Convert_api_Handler_To_v1_Handler,
		Convert_v1_HostAlias_To_api_HostAlias,
		Convert_api_HostAlias_To_v1_HostAlias,
		Convert_v1_HostPathVolumeSource_To_api_HostPathVolumeSource,
		Convert_api_HostPathVolumeSource_To_v1_HostPathVolumeSource,
		Convert_v1_ISCSIVolumeSource_To_api_ISCSIVolumeSource,
		Convert_api_ISCSIVolumeSource_To_v1_ISCSIVolumeSource,
		Convert_v1_KeyToPath_To_api_KeyToPath,
		Convert_api_KeyToPath_To_v1_KeyToPath,
		Convert_v1_Lifecycle_To_api_Lifecycle,
		Convert_api_Lifecycle_To_v1_Lifecycle,
		Convert_v1_LimitRange_To_api_LimitRange,
		Convert_api_LimitRange_To_v1_LimitRange,
		Convert_v1_LimitRangeItem_To_api_LimitRangeItem,
		Convert_api_LimitRangeItem_To_v1_LimitRangeItem,
		Convert_v1_LimitRangeList_To_api_LimitRangeList,
		Convert_api_LimitRangeList_To_v1_LimitRangeList,
		Convert_v1_LimitRangeSpec_To_api_LimitRangeSpec,
		Convert_api_LimitRangeSpec_To_v1_LimitRangeSpec,
		Convert_v1_List_To_api_List,
		Convert_api_List_To_v1_List,
		Convert_v1_ListOptions_To_api_ListOptions,
		Convert_api_ListOptions_To_v1_ListOptions,
		Convert_v1_LoadBalancerIngress_To_api_LoadBalancerIngress,
		Convert_api_LoadBalancerIngress_To_v1_LoadBalancerIngress,
		Convert_v1_LoadBalancerStatus_To_api_LoadBalancerStatus,
		Convert_api_LoadBalancerStatus_To_v1_LoadBalancerStatus,
		Convert_v1_LocalObjectReference_To_api_LocalObjectReference,
		Convert_api_LocalObjectReference_To_v1_LocalObjectReference,
		Convert_v1_LocalVolumeSource_To_api_LocalVolumeSource,
		Convert_api_LocalVolumeSource_To_v1_LocalVolumeSource,
		Convert_v1_NFSVolumeSource_To_api_NFSVolumeSource,
		Convert_api_NFSVolumeSource_To_v1_NFSVolumeSource,
		Convert_v1_Namespace_To_api_Namespace,
		Convert_api_Namespace_To_v1_Namespace,
		Convert_v1_NamespaceList_To_api_NamespaceList,
		Convert_api_NamespaceList_To_v1_NamespaceList,
		Convert_v1_NamespaceSpec_To_api_NamespaceSpec,
		Convert_api_NamespaceSpec_To_v1_NamespaceSpec,
		Convert_v1_NamespaceStatus_To_api_NamespaceStatus,
		Convert_api_NamespaceStatus_To_v1_NamespaceStatus,
		Convert_v1_Node_To_api_Node,
		Convert_api_Node_To_v1_Node,
		Convert_v1_NodeAddress_To_api_NodeAddress,
		Convert_api_NodeAddress_To_v1_NodeAddress,
		Convert_v1_NodeAffinity_To_api_NodeAffinity,
		Convert_api_NodeAffinity_To_v1_NodeAffinity,
		Convert_v1_NodeCondition_To_api_NodeCondition,
		Convert_api_NodeCondition_To_v1_NodeCondition,
		Convert_v1_NodeConfigSource_To_api_NodeConfigSource,
		Convert_api_NodeConfigSource_To_v1_NodeConfigSource,
		Convert_v1_NodeDaemonEndpoints_To_api_NodeDaemonEndpoints,
		Convert_api_NodeDaemonEndpoints_To_v1_NodeDaemonEndpoints,
		Convert_v1_NodeList_To_api_NodeList,
		Convert_api_NodeList_To_v1_NodeList,
		Convert_v1_NodeProxyOptions_To_api_NodeProxyOptions,
		Convert_api_NodeProxyOptions_To_v1_NodeProxyOptions,
		Convert_v1_NodeResources_To_api_NodeResources,
		Convert_api_NodeResources_To_v1_NodeResources,
		Convert_v1_NodeSelector_To_api_NodeSelector,
		Convert_api_NodeSelector_To_v1_NodeSelector,
		Convert_v1_NodeSelectorRequirement_To_api_NodeSelectorRequirement,
		Convert_api_NodeSelectorRequirement_To_v1_NodeSelectorRequirement,
		Convert_v1_NodeSelectorTerm_To_api_NodeSelectorTerm,
		Convert_api_NodeSelectorTerm_To_v1_NodeSelectorTerm,
		Convert_v1_NodeSpec_To_api_NodeSpec,
		Convert_api_NodeSpec_To_v1_NodeSpec,
		Convert_v1_NodeStatus_To_api_NodeStatus,
		Convert_api_NodeStatus_To_v1_NodeStatus,
		Convert_v1_NodeSystemInfo_To_api_NodeSystemInfo,
		Convert_api_NodeSystemInfo_To_v1_NodeSystemInfo,
		Convert_v1_ObjectFieldSelector_To_api_ObjectFieldSelector,
		Convert_api_ObjectFieldSelector_To_v1_ObjectFieldSelector,
		Convert_v1_ObjectMeta_To_api_ObjectMeta,
		Convert_api_ObjectMeta_To_v1_ObjectMeta,
		Convert_v1_ObjectReference_To_api_ObjectReference,
		Convert_api_ObjectReference_To_v1_ObjectReference,
		Convert_v1_PersistentVolume_To_api_PersistentVolume,
		Convert_api_PersistentVolume_To_v1_PersistentVolume,
		Convert_v1_PersistentVolumeClaim_To_api_PersistentVolumeClaim,
		Convert_api_PersistentVolumeClaim_To_v1_PersistentVolumeClaim,
		Convert_v1_PersistentVolumeClaimCondition_To_api_PersistentVolumeClaimCondition,
		Convert_api_PersistentVolumeClaimCondition_To_v1_PersistentVolumeClaimCondition,
		Convert_v1_PersistentVolumeClaimList_To_api_PersistentVolumeClaimList,
		Convert_api_PersistentVolumeClaimList_To_v1_PersistentVolumeClaimList,
		Convert_v1_PersistentVolumeClaimSpec_To_api_PersistentVolumeClaimSpec,
		Convert_api_PersistentVolumeClaimSpec_To_v1_PersistentVolumeClaimSpec,
		Convert_v1_PersistentVolumeClaimStatus_To_api_PersistentVolumeClaimStatus,
		Convert_api_PersistentVolumeClaimStatus_To_v1_PersistentVolumeClaimStatus,
		Convert_v1_PersistentVolumeClaimVolumeSource_To_api_PersistentVolumeClaimVolumeSource,
		Convert_api_PersistentVolumeClaimVolumeSource_To_v1_PersistentVolumeClaimVolumeSource,
		Convert_v1_PersistentVolumeList_To_api_PersistentVolumeList,
		Convert_api_PersistentVolumeList_To_v1_PersistentVolumeList,
		Convert_v1_PersistentVolumeSource_To_api_PersistentVolumeSource,
		Convert_api_PersistentVolumeSource_To_v1_PersistentVolumeSource,
		Convert_v1_PersistentVolumeSpec_To_api_PersistentVolumeSpec,
		Convert_api_PersistentVolumeSpec_To_v1_PersistentVolumeSpec,
		Convert_v1_PersistentVolumeStatus_To_api_PersistentVolumeStatus,
		Convert_api_PersistentVolumeStatus_To_v1_PersistentVolumeStatus,
		Convert_v1_PhotonPersistentDiskVolumeSource_To_api_PhotonPersistentDiskVolumeSource,
		Convert_api_PhotonPersistentDiskVolumeSource_To_v1_PhotonPersistentDiskVolumeSource,
		Convert_v1_Pod_To_api_Pod,
		Convert_api_Pod_To_v1_Pod,
		Convert_v1_PodAffinity_To_api_PodAffinity,
		Convert_api_PodAffinity_To_v1_PodAffinity,
		Convert_v1_PodAffinityTerm_To_api_PodAffinityTerm,
		Convert_api_PodAffinityTerm_To_v1_PodAffinityTerm,
		Convert_v1_PodAntiAffinity_To_api_PodAntiAffinity,
		Convert_api_PodAntiAffinity_To_v1_PodAntiAffinity,
		Convert_v1_PodAttachOptions_To_api_PodAttachOptions,
		Convert_api_PodAttachOptions_To_v1_PodAttachOptions,
		Convert_v1_PodCondition_To_api_PodCondition,
		Convert_api_PodCondition_To_v1_PodCondition,
		Convert_v1_PodExecOptions_To_api_PodExecOptions,
		Convert_api_PodExecOptions_To_v1_PodExecOptions,
		Convert_v1_PodList_To_api_PodList,
		Convert_api_PodList_To_v1_PodList,
		Convert_v1_PodLogOptions_To_api_PodLogOptions,
		Convert_api_PodLogOptions_To_v1_PodLogOptions,
		Convert_v1_PodPortForwardOptions_To_api_PodPortForwardOptions,
		Convert_api_PodPortForwardOptions_To_v1_PodPortForwardOptions,
		Convert_v1_PodProxyOptions_To_api_PodProxyOptions,
		Convert_api_PodProxyOptions_To_v1_PodProxyOptions,
		Convert_v1_PodSecurityContext_To_api_PodSecurityContext,
		Convert_api_PodSecurityContext_To_v1_PodSecurityContext,
		Convert_v1_PodSignature_To_api_PodSignature,
		Convert_api_PodSignature_To_v1_PodSignature,
		Convert_v1_PodSpec_To_api_PodSpec,
		Convert_api_PodSpec_To_v1_PodSpec,
		Convert_v1_PodStatus_To_api_PodStatus,
		Convert_api_PodStatus_To_v1_PodStatus,
		Convert_v1_PodStatusResult_To_api_PodStatusResult,
		Convert_api_PodStatusResult_To_v1_PodStatusResult,
		Convert_v1_PodTemplate_To_api_PodTemplate,
		Convert_api_PodTemplate_To_v1_PodTemplate,
		Convert_v1_PodTemplateList_To_api_PodTemplateList,
		Convert_api_PodTemplateList_To_v1_PodTemplateList,
		Convert_v1_PodTemplateSpec_To_api_PodTemplateSpec,
		Convert_api_PodTemplateSpec_To_v1_PodTemplateSpec,
		Convert_v1_PortworxVolumeSource_To_api_PortworxVolumeSource,
		Convert_api_PortworxVolumeSource_To_v1_PortworxVolumeSource,
		Convert_v1_Preconditions_To_api_Preconditions,
		Convert_api_Preconditions_To_v1_Preconditions,
		Convert_v1_PreferAvoidPodsEntry_To_api_PreferAvoidPodsEntry,
		Convert_api_PreferAvoidPodsEntry_To_v1_PreferAvoidPodsEntry,
		Convert_v1_PreferredSchedulingTerm_To_api_PreferredSchedulingTerm,
		Convert_api_PreferredSchedulingTerm_To_v1_PreferredSchedulingTerm,
		Convert_v1_Probe_To_api_Probe,
		Convert_api_Probe_To_v1_Probe,
		Convert_v1_ProjectedVolumeSource_To_api_ProjectedVolumeSource,
		Convert_api_ProjectedVolumeSource_To_v1_ProjectedVolumeSource,
		Convert_v1_QuobyteVolumeSource_To_api_QuobyteVolumeSource,
		Convert_api_QuobyteVolumeSource_To_v1_QuobyteVolumeSource,
		Convert_v1_RBDVolumeSource_To_api_RBDVolumeSource,
		Convert_api_RBDVolumeSource_To_v1_RBDVolumeSource,
		Convert_v1_RangeAllocation_To_api_RangeAllocation,
		Convert_api_RangeAllocation_To_v1_RangeAllocation,
		Convert_v1_ReplicationController_To_api_ReplicationController,
		Convert_api_ReplicationController_To_v1_ReplicationController,
		Convert_v1_ReplicationControllerCondition_To_api_ReplicationControllerCondition,
		Convert_api_ReplicationControllerCondition_To_v1_ReplicationControllerCondition,
		Convert_v1_ReplicationControllerList_To_api_ReplicationControllerList,
		Convert_api_ReplicationControllerList_To_v1_ReplicationControllerList,
		Convert_v1_ReplicationControllerSpec_To_api_ReplicationControllerSpec,
		Convert_api_ReplicationControllerSpec_To_v1_ReplicationControllerSpec,
		Convert_v1_ReplicationControllerStatus_To_api_ReplicationControllerStatus,
		Convert_api_ReplicationControllerStatus_To_v1_ReplicationControllerStatus,
		Convert_v1_ResourceFieldSelector_To_api_ResourceFieldSelector,
		Convert_api_ResourceFieldSelector_To_v1_ResourceFieldSelector,
		Convert_v1_ResourceQuota_To_api_ResourceQuota,
		Convert_api_ResourceQuota_To_v1_ResourceQuota,
		Convert_v1_ResourceQuotaList_To_api_ResourceQuotaList,
		Convert_api_ResourceQuotaList_To_v1_ResourceQuotaList,
		Convert_v1_ResourceQuotaSpec_To_api_ResourceQuotaSpec,
		Convert_api_ResourceQuotaSpec_To_v1_ResourceQuotaSpec,
		Convert_v1_ResourceQuotaStatus_To_api_ResourceQuotaStatus,
		Convert_api_ResourceQuotaStatus_To_v1_ResourceQuotaStatus,
		Convert_v1_ResourceRequirements_To_api_ResourceRequirements,
		Convert_api_ResourceRequirements_To_v1_ResourceRequirements,
		Convert_v1_SELinuxOptions_To_api_SELinuxOptions,
		Convert_api_SELinuxOptions_To_v1_SELinuxOptions,
		Convert_v1_ScaleIOVolumeSource_To_api_ScaleIOVolumeSource,
		Convert_api_ScaleIOVolumeSource_To_v1_ScaleIOVolumeSource,
		Convert_v1_Secret_To_api_Secret,
		Convert_api_Secret_To_v1_Secret,
		Convert_v1_SecretEnvSource_To_api_SecretEnvSource,
		Convert_api_SecretEnvSource_To_v1_SecretEnvSource,
		Convert_v1_SecretKeySelector_To_api_SecretKeySelector,
		Convert_api_SecretKeySelector_To_v1_SecretKeySelector,
		Convert_v1_SecretList_To_api_SecretList,
		Convert_api_SecretList_To_v1_SecretList,
		Convert_v1_SecretProjection_To_api_SecretProjection,
		Convert_api_SecretProjection_To_v1_SecretProjection,
		Convert_v1_SecretReference_To_api_SecretReference,
		Convert_api_SecretReference_To_v1_SecretReference,
		Convert_v1_SecretVolumeSource_To_api_SecretVolumeSource,
		Convert_api_SecretVolumeSource_To_v1_SecretVolumeSource,
		Convert_v1_SecurityContext_To_api_SecurityContext,
		Convert_api_SecurityContext_To_v1_SecurityContext,
		Convert_v1_SerializedReference_To_api_SerializedReference,
		Convert_api_SerializedReference_To_v1_SerializedReference,
		Convert_v1_Service_To_api_Service,
		Convert_api_Service_To_v1_Service,
		Convert_v1_ServiceAccount_To_api_ServiceAccount,
		Convert_api_ServiceAccount_To_v1_ServiceAccount,
		Convert_v1_ServiceAccountList_To_api_ServiceAccountList,
		Convert_api_ServiceAccountList_To_v1_ServiceAccountList,
		Convert_v1_ServiceList_To_api_ServiceList,
		Convert_api_ServiceList_To_v1_ServiceList,
		Convert_v1_ServicePort_To_api_ServicePort,
		Convert_api_ServicePort_To_v1_ServicePort,
		Convert_v1_ServiceProxyOptions_To_api_ServiceProxyOptions,
		Convert_api_ServiceProxyOptions_To_v1_ServiceProxyOptions,
		Convert_v1_ServiceSpec_To_api_ServiceSpec,
		Convert_api_ServiceSpec_To_v1_ServiceSpec,
		Convert_v1_ServiceStatus_To_api_ServiceStatus,
		Convert_api_ServiceStatus_To_v1_ServiceStatus,
		Convert_v1_SessionAffinityConfig_To_api_SessionAffinityConfig,
		Convert_api_SessionAffinityConfig_To_v1_SessionAffinityConfig,
		Convert_v1_StorageOSPersistentVolumeSource_To_api_StorageOSPersistentVolumeSource,
		Convert_api_StorageOSPersistentVolumeSource_To_v1_StorageOSPersistentVolumeSource,
		Convert_v1_StorageOSVolumeSource_To_api_StorageOSVolumeSource,
		Convert_api_StorageOSVolumeSource_To_v1_StorageOSVolumeSource,
		Convert_v1_Sysctl_To_api_Sysctl,
		Convert_api_Sysctl_To_v1_Sysctl,
		Convert_v1_TCPSocketAction_To_api_TCPSocketAction,
		Convert_api_TCPSocketAction_To_v1_TCPSocketAction,
		Convert_v1_Taint_To_api_Taint,
		Convert_api_Taint_To_v1_Taint,
		Convert_v1_Toleration_To_api_Toleration,
		Convert_api_Toleration_To_v1_Toleration,
		Convert_v1_Volume_To_api_Volume,
		Convert_api_Volume_To_v1_Volume,
		Convert_v1_VolumeMount_To_api_VolumeMount,
		Convert_api_VolumeMount_To_v1_VolumeMount,
		Convert_v1_VolumeProjection_To_api_VolumeProjection,
		Convert_api_VolumeProjection_To_v1_VolumeProjection,
		Convert_v1_VolumeSource_To_api_VolumeSource,
		Convert_api_VolumeSource_To_v1_VolumeSource,
		Convert_v1_VsphereVirtualDiskVolumeSource_To_api_VsphereVirtualDiskVolumeSource,
		Convert_api_VsphereVirtualDiskVolumeSource_To_v1_VsphereVirtualDiskVolumeSource,
		Convert_v1_WeightedPodAffinityTerm_To_api_WeightedPodAffinityTerm,
		Convert_api_WeightedPodAffinityTerm_To_v1_WeightedPodAffinityTerm,
	)
}

func autoConvert_v1_AWSElasticBlockStoreVolumeSource_To_api_AWSElasticBlockStoreVolumeSource(in *v1.AWSElasticBlockStoreVolumeSource, out *api.AWSElasticBlockStoreVolumeSource, s conversion.Scope) error {
	out.VolumeID = in.VolumeID
	out.FSType = in.FSType
	out.Partition = in.Partition
	out.ReadOnly = in.ReadOnly
	return nil
}

// Convert_v1_AWSElasticBlockStoreVolumeSource_To_api_AWSElasticBlockStoreVolumeSource is an autogenerated conversion function.
func Convert_v1_AWSElasticBlockStoreVolumeSource_To_api_AWSElasticBlockStoreVolumeSource(in *v1.AWSElasticBlockStoreVolumeSource, out *api.AWSElasticBlockStoreVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_AWSElasticBlockStoreVolumeSource_To_api_AWSElasticBlockStoreVolumeSource(in, out, s)
}

func autoConvert_api_AWSElasticBlockStoreVolumeSource_To_v1_AWSElasticBlockStoreVolumeSource(in *api.AWSElasticBlockStoreVolumeSource, out *v1.AWSElasticBlockStoreVolumeSource, s conversion.Scope) error {
	out.VolumeID = in.VolumeID
	out.FSType = in.FSType
	out.Partition = in.Partition
	out.ReadOnly = in.ReadOnly
	return nil
}

// Convert_api_AWSElasticBlockStoreVolumeSource_To_v1_AWSElasticBlockStoreVolumeSource is an autogenerated conversion function.
func Convert_api_AWSElasticBlockStoreVolumeSource_To_v1_AWSElasticBlockStoreVolumeSource(in *api.AWSElasticBlockStoreVolumeSource, out *v1.AWSElasticBlockStoreVolumeSource, s conversion.Scope) error {
	return autoConvert_api_AWSElasticBlockStoreVolumeSource_To_v1_AWSElasticBlockStoreVolumeSource(in, out, s)
}

func autoConvert_v1_Affinity_To_api_Affinity(in *v1.Affinity, out *api.Affinity, s conversion.Scope) error {
	out.NodeAffinity = (*api.NodeAffinity)(unsafe.Pointer(in.NodeAffinity))
	out.PodAffinity = (*api.PodAffinity)(unsafe.Pointer(in.PodAffinity))
	out.PodAntiAffinity = (*api.PodAntiAffinity)(unsafe.Pointer(in.PodAntiAffinity))
	return nil
}

// Convert_v1_Affinity_To_api_Affinity is an autogenerated conversion function.
func Convert_v1_Affinity_To_api_Affinity(in *v1.Affinity, out *api.Affinity, s conversion.Scope) error {
	return autoConvert_v1_Affinity_To_api_Affinity(in, out, s)
}

func autoConvert_api_Affinity_To_v1_Affinity(in *api.Affinity, out *v1.Affinity, s conversion.Scope) error {
	out.NodeAffinity = (*v1.NodeAffinity)(unsafe.Pointer(in.NodeAffinity))
	out.PodAffinity = (*v1.PodAffinity)(unsafe.Pointer(in.PodAffinity))
	out.PodAntiAffinity = (*v1.PodAntiAffinity)(unsafe.Pointer(in.PodAntiAffinity))
	return nil
}

// Convert_api_Affinity_To_v1_Affinity is an autogenerated conversion function.
func Convert_api_Affinity_To_v1_Affinity(in *api.Affinity, out *v1.Affinity, s conversion.Scope) error {
	return autoConvert_api_Affinity_To_v1_Affinity(in, out, s)
}

func autoConvert_v1_AttachedVolume_To_api_AttachedVolume(in *v1.AttachedVolume, out *api.AttachedVolume, s conversion.Scope) error {
	out.Name = api.UniqueVolumeName(in.Name)
	out.DevicePath = in.DevicePath
	return nil
}

// Convert_v1_AttachedVolume_To_api_AttachedVolume is an autogenerated conversion function.
func Convert_v1_AttachedVolume_To_api_AttachedVolume(in *v1.AttachedVolume, out *api.AttachedVolume, s conversion.Scope) error {
	return autoConvert_v1_AttachedVolume_To_api_AttachedVolume(in, out, s)
}

func autoConvert_api_AttachedVolume_To_v1_AttachedVolume(in *api.AttachedVolume, out *v1.AttachedVolume, s conversion.Scope) error {
	out.Name = v1.UniqueVolumeName(in.Name)
	out.DevicePath = in.DevicePath
	return nil
}

// Convert_api_AttachedVolume_To_v1_AttachedVolume is an autogenerated conversion function.
func Convert_api_AttachedVolume_To_v1_AttachedVolume(in *api.AttachedVolume, out *v1.AttachedVolume, s conversion.Scope) error {
	return autoConvert_api_AttachedVolume_To_v1_AttachedVolume(in, out, s)
}

func autoConvert_v1_AvoidPods_To_api_AvoidPods(in *v1.AvoidPods, out *api.AvoidPods, s conversion.Scope) error {
	out.PreferAvoidPods = *(*[]api.PreferAvoidPodsEntry)(unsafe.Pointer(&in.PreferAvoidPods))
	return nil
}

// Convert_v1_AvoidPods_To_api_AvoidPods is an autogenerated conversion function.
func Convert_v1_AvoidPods_To_api_AvoidPods(in *v1.AvoidPods, out *api.AvoidPods, s conversion.Scope) error {
	return autoConvert_v1_AvoidPods_To_api_AvoidPods(in, out, s)
}

func autoConvert_api_AvoidPods_To_v1_AvoidPods(in *api.AvoidPods, out *v1.AvoidPods, s conversion.Scope) error {
	out.PreferAvoidPods = *(*[]v1.PreferAvoidPodsEntry)(unsafe.Pointer(&in.PreferAvoidPods))
	return nil
}

// Convert_api_AvoidPods_To_v1_AvoidPods is an autogenerated conversion function.
func Convert_api_AvoidPods_To_v1_AvoidPods(in *api.AvoidPods, out *v1.AvoidPods, s conversion.Scope) error {
	return autoConvert_api_AvoidPods_To_v1_AvoidPods(in, out, s)
}

func autoConvert_v1_AzureDiskVolumeSource_To_api_AzureDiskVolumeSource(in *v1.AzureDiskVolumeSource, out *api.AzureDiskVolumeSource, s conversion.Scope) error {
	out.DiskName = in.DiskName
	out.DataDiskURI = in.DataDiskURI
	out.CachingMode = (*api.AzureDataDiskCachingMode)(unsafe.Pointer(in.CachingMode))
	out.FSType = (*string)(unsafe.Pointer(in.FSType))
	out.ReadOnly = (*bool)(unsafe.Pointer(in.ReadOnly))
	out.Kind = (*api.AzureDataDiskKind)(unsafe.Pointer(in.Kind))
	return nil
}

// Convert_v1_AzureDiskVolumeSource_To_api_AzureDiskVolumeSource is an autogenerated conversion function.
func Convert_v1_AzureDiskVolumeSource_To_api_AzureDiskVolumeSource(in *v1.AzureDiskVolumeSource, out *api.AzureDiskVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_AzureDiskVolumeSource_To_api_AzureDiskVolumeSource(in, out, s)
}

func autoConvert_api_AzureDiskVolumeSource_To_v1_AzureDiskVolumeSource(in *api.AzureDiskVolumeSource, out *v1.AzureDiskVolumeSource, s conversion.Scope) error {
	out.DiskName = in.DiskName
	out.DataDiskURI = in.DataDiskURI
	out.CachingMode = (*v1.AzureDataDiskCachingMode)(unsafe.Pointer(in.CachingMode))
	out.FSType = (*string)(unsafe.Pointer(in.FSType))
	out.ReadOnly = (*bool)(unsafe.Pointer(in.ReadOnly))
	out.Kind = (*v1.AzureDataDiskKind)(unsafe.Pointer(in.Kind))
	return nil
}

// Convert_api_AzureDiskVolumeSource_To_v1_AzureDiskVolumeSource is an autogenerated conversion function.
func Convert_api_AzureDiskVolumeSource_To_v1_AzureDiskVolumeSource(in *api.AzureDiskVolumeSource, out *v1.AzureDiskVolumeSource, s conversion.Scope) error {
	return autoConvert_api_AzureDiskVolumeSource_To_v1_AzureDiskVolumeSource(in, out, s)
}

func autoConvert_v1_AzureFilePersistentVolumeSource_To_api_AzureFilePersistentVolumeSource(in *v1.AzureFilePersistentVolumeSource, out *api.AzureFilePersistentVolumeSource, s conversion.Scope) error {
	out.SecretName = in.SecretName
	out.ShareName = in.ShareName
	out.ReadOnly = in.ReadOnly
	out.SecretNamespace = (*string)(unsafe.Pointer(in.SecretNamespace))
	return nil
}

// Convert_v1_AzureFilePersistentVolumeSource_To_api_AzureFilePersistentVolumeSource is an autogenerated conversion function.
func Convert_v1_AzureFilePersistentVolumeSource_To_api_AzureFilePersistentVolumeSource(in *v1.AzureFilePersistentVolumeSource, out *api.AzureFilePersistentVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_AzureFilePersistentVolumeSource_To_api_AzureFilePersistentVolumeSource(in, out, s)
}

func autoConvert_api_AzureFilePersistentVolumeSource_To_v1_AzureFilePersistentVolumeSource(in *api.AzureFilePersistentVolumeSource, out *v1.AzureFilePersistentVolumeSource, s conversion.Scope) error {
	out.SecretName = in.SecretName
	out.ShareName = in.ShareName
	out.ReadOnly = in.ReadOnly
	out.SecretNamespace = (*string)(unsafe.Pointer(in.SecretNamespace))
	return nil
}

// Convert_api_AzureFilePersistentVolumeSource_To_v1_AzureFilePersistentVolumeSource is an autogenerated conversion function.
func Convert_api_AzureFilePersistentVolumeSource_To_v1_AzureFilePersistentVolumeSource(in *api.AzureFilePersistentVolumeSource, out *v1.AzureFilePersistentVolumeSource, s conversion.Scope) error {
	return autoConvert_api_AzureFilePersistentVolumeSource_To_v1_AzureFilePersistentVolumeSource(in, out, s)
}

func autoConvert_v1_AzureFileVolumeSource_To_api_AzureFileVolumeSource(in *v1.AzureFileVolumeSource, out *api.AzureFileVolumeSource, s conversion.Scope) error {
	out.SecretName = in.SecretName
	out.ShareName = in.ShareName
	out.ReadOnly = in.ReadOnly
	return nil
}

// Convert_v1_AzureFileVolumeSource_To_api_AzureFileVolumeSource is an autogenerated conversion function.
func Convert_v1_AzureFileVolumeSource_To_api_AzureFileVolumeSource(in *v1.AzureFileVolumeSource, out *api.AzureFileVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_AzureFileVolumeSource_To_api_AzureFileVolumeSource(in, out, s)
}

func autoConvert_api_AzureFileVolumeSource_To_v1_AzureFileVolumeSource(in *api.AzureFileVolumeSource, out *v1.AzureFileVolumeSource, s conversion.Scope) error {
	out.SecretName = in.SecretName
	out.ShareName = in.ShareName
	out.ReadOnly = in.ReadOnly
	return nil
}

// Convert_api_AzureFileVolumeSource_To_v1_AzureFileVolumeSource is an autogenerated conversion function.
func Convert_api_AzureFileVolumeSource_To_v1_AzureFileVolumeSource(in *api.AzureFileVolumeSource, out *v1.AzureFileVolumeSource, s conversion.Scope) error {
	return autoConvert_api_AzureFileVolumeSource_To_v1_AzureFileVolumeSource(in, out, s)
}

func autoConvert_v1_Binding_To_api_Binding(in *v1.Binding, out *api.Binding, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_ObjectReference_To_api_ObjectReference(&in.Target, &out.Target, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_Binding_To_api_Binding is an autogenerated conversion function.
func Convert_v1_Binding_To_api_Binding(in *v1.Binding, out *api.Binding, s conversion.Scope) error {
	return autoConvert_v1_Binding_To_api_Binding(in, out, s)
}

func autoConvert_api_Binding_To_v1_Binding(in *api.Binding, out *v1.Binding, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_api_ObjectReference_To_v1_ObjectReference(&in.Target, &out.Target, s); err != nil {
		return err
	}
	return nil
}

// Convert_api_Binding_To_v1_Binding is an autogenerated conversion function.
func Convert_api_Binding_To_v1_Binding(in *api.Binding, out *v1.Binding, s conversion.Scope) error {
	return autoConvert_api_Binding_To_v1_Binding(in, out, s)
}

func autoConvert_v1_Capabilities_To_api_Capabilities(in *v1.Capabilities, out *api.Capabilities, s conversion.Scope) error {
	out.Add = *(*[]api.Capability)(unsafe.Pointer(&in.Add))
	out.Drop = *(*[]api.Capability)(unsafe.Pointer(&in.Drop))
	return nil
}

// Convert_v1_Capabilities_To_api_Capabilities is an autogenerated conversion function.
func Convert_v1_Capabilities_To_api_Capabilities(in *v1.Capabilities, out *api.Capabilities, s conversion.Scope) error {
	return autoConvert_v1_Capabilities_To_api_Capabilities(in, out, s)
}

func autoConvert_api_Capabilities_To_v1_Capabilities(in *api.Capabilities, out *v1.Capabilities, s conversion.Scope) error {
	out.Add = *(*[]v1.Capability)(unsafe.Pointer(&in.Add))
	out.Drop = *(*[]v1.Capability)(unsafe.Pointer(&in.Drop))
	return nil
}

// Convert_api_Capabilities_To_v1_Capabilities is an autogenerated conversion function.
func Convert_api_Capabilities_To_v1_Capabilities(in *api.Capabilities, out *v1.Capabilities, s conversion.Scope) error {
	return autoConvert_api_Capabilities_To_v1_Capabilities(in, out, s)
}

func autoConvert_v1_CephFSPersistentVolumeSource_To_api_CephFSPersistentVolumeSource(in *v1.CephFSPersistentVolumeSource, out *api.CephFSPersistentVolumeSource, s conversion.Scope) error {
	out.Monitors = *(*[]string)(unsafe.Pointer(&in.Monitors))
	out.Path = in.Path
	out.User = in.User
	out.SecretFile = in.SecretFile
	out.SecretRef = (*api.SecretReference)(unsafe.Pointer(in.SecretRef))
	out.ReadOnly = in.ReadOnly
	return nil
}

// Convert_v1_CephFSPersistentVolumeSource_To_api_CephFSPersistentVolumeSource is an autogenerated conversion function.
func Convert_v1_CephFSPersistentVolumeSource_To_api_CephFSPersistentVolumeSource(in *v1.CephFSPersistentVolumeSource, out *api.CephFSPersistentVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_CephFSPersistentVolumeSource_To_api_CephFSPersistentVolumeSource(in, out, s)
}

func autoConvert_api_CephFSPersistentVolumeSource_To_v1_CephFSPersistentVolumeSource(in *api.CephFSPersistentVolumeSource, out *v1.CephFSPersistentVolumeSource, s conversion.Scope) error {
	out.Monitors = *(*[]string)(unsafe.Pointer(&in.Monitors))
	out.Path = in.Path
	out.User = in.User
	out.SecretFile = in.SecretFile
	out.SecretRef = (*v1.SecretReference)(unsafe.Pointer(in.SecretRef))
	out.ReadOnly = in.ReadOnly
	return nil
}

// Convert_api_CephFSPersistentVolumeSource_To_v1_CephFSPersistentVolumeSource is an autogenerated conversion function.
func Convert_api_CephFSPersistentVolumeSource_To_v1_CephFSPersistentVolumeSource(in *api.CephFSPersistentVolumeSource, out *v1.CephFSPersistentVolumeSource, s conversion.Scope) error {
	return autoConvert_api_CephFSPersistentVolumeSource_To_v1_CephFSPersistentVolumeSource(in, out, s)
}

func autoConvert_v1_CephFSVolumeSource_To_api_CephFSVolumeSource(in *v1.CephFSVolumeSource, out *api.CephFSVolumeSource, s conversion.Scope) error {
	out.Monitors = *(*[]string)(unsafe.Pointer(&in.Monitors))
	out.Path = in.Path
	out.User = in.User
	out.SecretFile = in.SecretFile
	out.SecretRef = (*api.LocalObjectReference)(unsafe.Pointer(in.SecretRef))
	out.ReadOnly = in.ReadOnly
	return nil
}

// Convert_v1_CephFSVolumeSource_To_api_CephFSVolumeSource is an autogenerated conversion function.
func Convert_v1_CephFSVolumeSource_To_api_CephFSVolumeSource(in *v1.CephFSVolumeSource, out *api.CephFSVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_CephFSVolumeSource_To_api_CephFSVolumeSource(in, out, s)
}

func autoConvert_api_CephFSVolumeSource_To_v1_CephFSVolumeSource(in *api.CephFSVolumeSource, out *v1.CephFSVolumeSource, s conversion.Scope) error {
	out.Monitors = *(*[]string)(unsafe.Pointer(&in.Monitors))
	out.Path = in.Path
	out.User = in.User
	out.SecretFile = in.SecretFile
	out.SecretRef = (*v1.LocalObjectReference)(unsafe.Pointer(in.SecretRef))
	out.ReadOnly = in.ReadOnly
	return nil
}

// Convert_api_CephFSVolumeSource_To_v1_CephFSVolumeSource is an autogenerated conversion function.
func Convert_api_CephFSVolumeSource_To_v1_CephFSVolumeSource(in *api.CephFSVolumeSource, out *v1.CephFSVolumeSource, s conversion.Scope) error {
	return autoConvert_api_CephFSVolumeSource_To_v1_CephFSVolumeSource(in, out, s)
}

func autoConvert_v1_CinderVolumeSource_To_api_CinderVolumeSource(in *v1.CinderVolumeSource, out *api.CinderVolumeSource, s conversion.Scope) error {
	out.VolumeID = in.VolumeID
	out.FSType = in.FSType
	out.ReadOnly = in.ReadOnly
	return nil
}

// Convert_v1_CinderVolumeSource_To_api_CinderVolumeSource is an autogenerated conversion function.
func Convert_v1_CinderVolumeSource_To_api_CinderVolumeSource(in *v1.CinderVolumeSource, out *api.CinderVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_CinderVolumeSource_To_api_CinderVolumeSource(in, out, s)
}

func autoConvert_api_CinderVolumeSource_To_v1_CinderVolumeSource(in *api.CinderVolumeSource, out *v1.CinderVolumeSource, s conversion.Scope) error {
	out.VolumeID = in.VolumeID
	out.FSType = in.FSType
	out.ReadOnly = in.ReadOnly
	return nil
}

// Convert_api_CinderVolumeSource_To_v1_CinderVolumeSource is an autogenerated conversion function.
func Convert_api_CinderVolumeSource_To_v1_CinderVolumeSource(in *api.CinderVolumeSource, out *v1.CinderVolumeSource, s conversion.Scope) error {
	return autoConvert_api_CinderVolumeSource_To_v1_CinderVolumeSource(in, out, s)
}

func autoConvert_v1_ClientIPConfig_To_api_ClientIPConfig(in *v1.ClientIPConfig, out *api.ClientIPConfig, s conversion.Scope) error {
	out.TimeoutSeconds = (*int32)(unsafe.Pointer(in.TimeoutSeconds))
	return nil
}

// Convert_v1_ClientIPConfig_To_api_ClientIPConfig is an autogenerated conversion function.
func Convert_v1_ClientIPConfig_To_api_ClientIPConfig(in *v1.ClientIPConfig, out *api.ClientIPConfig, s conversion.Scope) error {
	return autoConvert_v1_ClientIPConfig_To_api_ClientIPConfig(in, out, s)
}

func autoConvert_api_ClientIPConfig_To_v1_ClientIPConfig(in *api.ClientIPConfig, out *v1.ClientIPConfig, s conversion.Scope) error {
	out.TimeoutSeconds = (*int32)(unsafe.Pointer(in.TimeoutSeconds))
	return nil
}

// Convert_api_ClientIPConfig_To_v1_ClientIPConfig is an autogenerated conversion function.
func Convert_api_ClientIPConfig_To_v1_ClientIPConfig(in *api.ClientIPConfig, out *v1.ClientIPConfig, s conversion.Scope) error {
	return autoConvert_api_ClientIPConfig_To_v1_ClientIPConfig(in, out, s)
}

func autoConvert_v1_ComponentCondition_To_api_ComponentCondition(in *v1.ComponentCondition, out *api.ComponentCondition, s conversion.Scope) error {
	out.Type = api.ComponentConditionType(in.Type)
	out.Status = api.ConditionStatus(in.Status)
	out.Message = in.Message
	out.Error = in.Error
	return nil
}

// Convert_v1_ComponentCondition_To_api_ComponentCondition is an autogenerated conversion function.
func Convert_v1_ComponentCondition_To_api_ComponentCondition(in *v1.ComponentCondition, out *api.ComponentCondition, s conversion.Scope) error {
	return autoConvert_v1_ComponentCondition_To_api_ComponentCondition(in, out, s)
}

func autoConvert_api_ComponentCondition_To_v1_ComponentCondition(in *api.ComponentCondition, out *v1.ComponentCondition, s conversion.Scope) error {
	out.Type = v1.ComponentConditionType(in.Type)
	out.Status = v1.ConditionStatus(in.Status)
	out.Message = in.Message
	out.Error = in.Error
	return nil
}

// Convert_api_ComponentCondition_To_v1_ComponentCondition is an autogenerated conversion function.
func Convert_api_ComponentCondition_To_v1_ComponentCondition(in *api.ComponentCondition, out *v1.ComponentCondition, s conversion.Scope) error {
	return autoConvert_api_ComponentCondition_To_v1_ComponentCondition(in, out, s)
}

func autoConvert_v1_ComponentStatus_To_api_ComponentStatus(in *v1.ComponentStatus, out *api.ComponentStatus, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Conditions = *(*[]api.ComponentCondition)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1_ComponentStatus_To_api_ComponentStatus is an autogenerated conversion function.
func Convert_v1_ComponentStatus_To_api_ComponentStatus(in *v1.ComponentStatus, out *api.ComponentStatus, s conversion.Scope) error {
	return autoConvert_v1_ComponentStatus_To_api_ComponentStatus(in, out, s)
}

func autoConvert_api_ComponentStatus_To_v1_ComponentStatus(in *api.ComponentStatus, out *v1.ComponentStatus, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Conditions = *(*[]v1.ComponentCondition)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_api_ComponentStatus_To_v1_ComponentStatus is an autogenerated conversion function.
func Convert_api_ComponentStatus_To_v1_ComponentStatus(in *api.ComponentStatus, out *v1.ComponentStatus, s conversion.Scope) error {
	return autoConvert_api_ComponentStatus_To_v1_ComponentStatus(in, out, s)
}

func autoConvert_v1_ComponentStatusList_To_api_ComponentStatusList(in *v1.ComponentStatusList, out *api.ComponentStatusList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]api.ComponentStatus)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1_ComponentStatusList_To_api_ComponentStatusList is an autogenerated conversion function.
func Convert_v1_ComponentStatusList_To_api_ComponentStatusList(in *v1.ComponentStatusList, out *api.ComponentStatusList, s conversion.Scope) error {
	return autoConvert_v1_ComponentStatusList_To_api_ComponentStatusList(in, out, s)
}

func autoConvert_api_ComponentStatusList_To_v1_ComponentStatusList(in *api.ComponentStatusList, out *v1.ComponentStatusList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1.ComponentStatus)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_api_ComponentStatusList_To_v1_ComponentStatusList is an autogenerated conversion function.
func Convert_api_ComponentStatusList_To_v1_ComponentStatusList(in *api.ComponentStatusList, out *v1.ComponentStatusList, s conversion.Scope) error {
	return autoConvert_api_ComponentStatusList_To_v1_ComponentStatusList(in, out, s)
}

func autoConvert_v1_ConfigMap_To_api_ConfigMap(in *v1.ConfigMap, out *api.ConfigMap, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Data = *(*map[string]string)(unsafe.Pointer(&in.Data))
	return nil
}

// Convert_v1_ConfigMap_To_api_ConfigMap is an autogenerated conversion function.
func Convert_v1_ConfigMap_To_api_ConfigMap(in *v1.ConfigMap, out *api.ConfigMap, s conversion.Scope) error {
	return autoConvert_v1_ConfigMap_To_api_ConfigMap(in, out, s)
}

func autoConvert_api_ConfigMap_To_v1_ConfigMap(in *api.ConfigMap, out *v1.ConfigMap, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Data = *(*map[string]string)(unsafe.Pointer(&in.Data))
	return nil
}

// Convert_api_ConfigMap_To_v1_ConfigMap is an autogenerated conversion function.
func Convert_api_ConfigMap_To_v1_ConfigMap(in *api.ConfigMap, out *v1.ConfigMap, s conversion.Scope) error {
	return autoConvert_api_ConfigMap_To_v1_ConfigMap(in, out, s)
}

func autoConvert_v1_ConfigMapEnvSource_To_api_ConfigMapEnvSource(in *v1.ConfigMapEnvSource, out *api.ConfigMapEnvSource, s conversion.Scope) error {
	if err := Convert_v1_LocalObjectReference_To_api_LocalObjectReference(&in.LocalObjectReference, &out.LocalObjectReference, s); err != nil {
		return err
	}
	out.Optional = (*bool)(unsafe.Pointer(in.Optional))
	return nil
}

// Convert_v1_ConfigMapEnvSource_To_api_ConfigMapEnvSource is an autogenerated conversion function.
func Convert_v1_ConfigMapEnvSource_To_api_ConfigMapEnvSource(in *v1.ConfigMapEnvSource, out *api.ConfigMapEnvSource, s conversion.Scope) error {
	return autoConvert_v1_ConfigMapEnvSource_To_api_ConfigMapEnvSource(in, out, s)
}

func autoConvert_api_ConfigMapEnvSource_To_v1_ConfigMapEnvSource(in *api.ConfigMapEnvSource, out *v1.ConfigMapEnvSource, s conversion.Scope) error {
	if err := Convert_api_LocalObjectReference_To_v1_LocalObjectReference(&in.LocalObjectReference, &out.LocalObjectReference, s); err != nil {
		return err
	}
	out.Optional = (*bool)(unsafe.Pointer(in.Optional))
	return nil
}

// Convert_api_ConfigMapEnvSource_To_v1_ConfigMapEnvSource is an autogenerated conversion function.
func Convert_api_ConfigMapEnvSource_To_v1_ConfigMapEnvSource(in *api.ConfigMapEnvSource, out *v1.ConfigMapEnvSource, s conversion.Scope) error {
	return autoConvert_api_ConfigMapEnvSource_To_v1_ConfigMapEnvSource(in, out, s)
}

func autoConvert_v1_ConfigMapKeySelector_To_api_ConfigMapKeySelector(in *v1.ConfigMapKeySelector, out *api.ConfigMapKeySelector, s conversion.Scope) error {
	if err := Convert_v1_LocalObjectReference_To_api_LocalObjectReference(&in.LocalObjectReference, &out.LocalObjectReference, s); err != nil {
		return err
	}
	out.Key = in.Key
	out.Optional = (*bool)(unsafe.Pointer(in.Optional))
	return nil
}

// Convert_v1_ConfigMapKeySelector_To_api_ConfigMapKeySelector is an autogenerated conversion function.
func Convert_v1_ConfigMapKeySelector_To_api_ConfigMapKeySelector(in *v1.ConfigMapKeySelector, out *api.ConfigMapKeySelector, s conversion.Scope) error {
	return autoConvert_v1_ConfigMapKeySelector_To_api_ConfigMapKeySelector(in, out, s)
}

func autoConvert_api_ConfigMapKeySelector_To_v1_ConfigMapKeySelector(in *api.ConfigMapKeySelector, out *v1.ConfigMapKeySelector, s conversion.Scope) error {
	if err := Convert_api_LocalObjectReference_To_v1_LocalObjectReference(&in.LocalObjectReference, &out.LocalObjectReference, s); err != nil {
		return err
	}
	out.Key = in.Key
	out.Optional = (*bool)(unsafe.Pointer(in.Optional))
	return nil
}

// Convert_api_ConfigMapKeySelector_To_v1_ConfigMapKeySelector is an autogenerated conversion function.
func Convert_api_ConfigMapKeySelector_To_v1_ConfigMapKeySelector(in *api.ConfigMapKeySelector, out *v1.ConfigMapKeySelector, s conversion.Scope) error {
	return autoConvert_api_ConfigMapKeySelector_To_v1_ConfigMapKeySelector(in, out, s)
}

func autoConvert_v1_ConfigMapList_To_api_ConfigMapList(in *v1.ConfigMapList, out *api.ConfigMapList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]api.ConfigMap)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1_ConfigMapList_To_api_ConfigMapList is an autogenerated conversion function.
func Convert_v1_ConfigMapList_To_api_ConfigMapList(in *v1.ConfigMapList, out *api.ConfigMapList, s conversion.Scope) error {
	return autoConvert_v1_ConfigMapList_To_api_ConfigMapList(in, out, s)
}

func autoConvert_api_ConfigMapList_To_v1_ConfigMapList(in *api.ConfigMapList, out *v1.ConfigMapList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1.ConfigMap)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_api_ConfigMapList_To_v1_ConfigMapList is an autogenerated conversion function.
func Convert_api_ConfigMapList_To_v1_ConfigMapList(in *api.ConfigMapList, out *v1.ConfigMapList, s conversion.Scope) error {
	return autoConvert_api_ConfigMapList_To_v1_ConfigMapList(in, out, s)
}

func autoConvert_v1_ConfigMapProjection_To_api_ConfigMapProjection(in *v1.ConfigMapProjection, out *api.ConfigMapProjection, s conversion.Scope) error {
	if err := Convert_v1_LocalObjectReference_To_api_LocalObjectReference(&in.LocalObjectReference, &out.LocalObjectReference, s); err != nil {
		return err
	}
	out.Items = *(*[]api.KeyToPath)(unsafe.Pointer(&in.Items))
	out.Optional = (*bool)(unsafe.Pointer(in.Optional))
	return nil
}

// Convert_v1_ConfigMapProjection_To_api_ConfigMapProjection is an autogenerated conversion function.
func Convert_v1_ConfigMapProjection_To_api_ConfigMapProjection(in *v1.ConfigMapProjection, out *api.ConfigMapProjection, s conversion.Scope) error {
	return autoConvert_v1_ConfigMapProjection_To_api_ConfigMapProjection(in, out, s)
}

func autoConvert_api_ConfigMapProjection_To_v1_ConfigMapProjection(in *api.ConfigMapProjection, out *v1.ConfigMapProjection, s conversion.Scope) error {
	if err := Convert_api_LocalObjectReference_To_v1_LocalObjectReference(&in.LocalObjectReference, &out.LocalObjectReference, s); err != nil {
		return err
	}
	out.Items = *(*[]v1.KeyToPath)(unsafe.Pointer(&in.Items))
	out.Optional = (*bool)(unsafe.Pointer(in.Optional))
	return nil
}

// Convert_api_ConfigMapProjection_To_v1_ConfigMapProjection is an autogenerated conversion function.
func Convert_api_ConfigMapProjection_To_v1_ConfigMapProjection(in *api.ConfigMapProjection, out *v1.ConfigMapProjection, s conversion.Scope) error {
	return autoConvert_api_ConfigMapProjection_To_v1_ConfigMapProjection(in, out, s)
}

func autoConvert_v1_ConfigMapVolumeSource_To_api_ConfigMapVolumeSource(in *v1.ConfigMapVolumeSource, out *api.ConfigMapVolumeSource, s conversion.Scope) error {
	if err := Convert_v1_LocalObjectReference_To_api_LocalObjectReference(&in.LocalObjectReference, &out.LocalObjectReference, s); err != nil {
		return err
	}
	out.Items = *(*[]api.KeyToPath)(unsafe.Pointer(&in.Items))
	out.DefaultMode = (*int32)(unsafe.Pointer(in.DefaultMode))
	out.Optional = (*bool)(unsafe.Pointer(in.Optional))
	return nil
}

// Convert_v1_ConfigMapVolumeSource_To_api_ConfigMapVolumeSource is an autogenerated conversion function.
func Convert_v1_ConfigMapVolumeSource_To_api_ConfigMapVolumeSource(in *v1.ConfigMapVolumeSource, out *api.ConfigMapVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_ConfigMapVolumeSource_To_api_ConfigMapVolumeSource(in, out, s)
}

func autoConvert_api_ConfigMapVolumeSource_To_v1_ConfigMapVolumeSource(in *api.ConfigMapVolumeSource, out *v1.ConfigMapVolumeSource, s conversion.Scope) error {
	if err := Convert_api_LocalObjectReference_To_v1_LocalObjectReference(&in.LocalObjectReference, &out.LocalObjectReference, s); err != nil {
		return err
	}
	out.Items = *(*[]v1.KeyToPath)(unsafe.Pointer(&in.Items))
	out.DefaultMode = (*int32)(unsafe.Pointer(in.DefaultMode))
	out.Optional = (*bool)(unsafe.Pointer(in.Optional))
	return nil
}

// Convert_api_ConfigMapVolumeSource_To_v1_ConfigMapVolumeSource is an autogenerated conversion function.
func Convert_api_ConfigMapVolumeSource_To_v1_ConfigMapVolumeSource(in *api.ConfigMapVolumeSource, out *v1.ConfigMapVolumeSource, s conversion.Scope) error {
	return autoConvert_api_ConfigMapVolumeSource_To_v1_ConfigMapVolumeSource(in, out, s)
}

func autoConvert_v1_Container_To_api_Container(in *v1.Container, out *api.Container, s conversion.Scope) error {
	out.Name = in.Name
	out.Image = in.Image
	out.Command = *(*[]string)(unsafe.Pointer(&in.Command))
	out.Args = *(*[]string)(unsafe.Pointer(&in.Args))
	out.WorkingDir = in.WorkingDir
	out.Ports = *(*[]api.ContainerPort)(unsafe.Pointer(&in.Ports))
	out.EnvFrom = *(*[]api.EnvFromSource)(unsafe.Pointer(&in.EnvFrom))
	out.Env = *(*[]api.EnvVar)(unsafe.Pointer(&in.Env))
	if err := Convert_v1_ResourceRequirements_To_api_ResourceRequirements(&in.Resources, &out.Resources, s); err != nil {
		return err
	}
	out.VolumeMounts = *(*[]api.VolumeMount)(unsafe.Pointer(&in.VolumeMounts))
	out.LivenessProbe = (*api.Probe)(unsafe.Pointer(in.LivenessProbe))
	out.ReadinessProbe = (*api.Probe)(unsafe.Pointer(in.ReadinessProbe))
	out.Lifecycle = (*api.Lifecycle)(unsafe.Pointer(in.Lifecycle))
	out.TerminationMessagePath = in.TerminationMessagePath
	out.TerminationMessagePolicy = api.TerminationMessagePolicy(in.TerminationMessagePolicy)
	out.ImagePullPolicy = api.PullPolicy(in.ImagePullPolicy)
	if in.SecurityContext != nil {
		in, out := &in.SecurityContext, &out.SecurityContext
		*out = new(api.SecurityContext)
		if err := Convert_v1_SecurityContext_To_api_SecurityContext(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.SecurityContext = nil
	}
	out.Stdin = in.Stdin
	out.StdinOnce = in.StdinOnce
	out.TTY = in.TTY
	return nil
}

// Convert_v1_Container_To_api_Container is an autogenerated conversion function.
func Convert_v1_Container_To_api_Container(in *v1.Container, out *api.Container, s conversion.Scope) error {
	return autoConvert_v1_Container_To_api_Container(in, out, s)
}

func autoConvert_api_Container_To_v1_Container(in *api.Container, out *v1.Container, s conversion.Scope) error {
	out.Name = in.Name
	out.Image = in.Image
	out.Command = *(*[]string)(unsafe.Pointer(&in.Command))
	out.Args = *(*[]string)(unsafe.Pointer(&in.Args))
	out.WorkingDir = in.WorkingDir
	out.Ports = *(*[]v1.ContainerPort)(unsafe.Pointer(&in.Ports))
	out.EnvFrom = *(*[]v1.EnvFromSource)(unsafe.Pointer(&in.EnvFrom))
	out.Env = *(*[]v1.EnvVar)(unsafe.Pointer(&in.Env))
	if err := Convert_api_ResourceRequirements_To_v1_ResourceRequirements(&in.Resources, &out.Resources, s); err != nil {
		return err
	}
	out.VolumeMounts = *(*[]v1.VolumeMount)(unsafe.Pointer(&in.VolumeMounts))
	out.LivenessProbe = (*v1.Probe)(unsafe.Pointer(in.LivenessProbe))
	out.ReadinessProbe = (*v1.Probe)(unsafe.Pointer(in.ReadinessProbe))
	out.Lifecycle = (*v1.Lifecycle)(unsafe.Pointer(in.Lifecycle))
	out.TerminationMessagePath = in.TerminationMessagePath
	out.TerminationMessagePolicy = v1.TerminationMessagePolicy(in.TerminationMessagePolicy)
	out.ImagePullPolicy = v1.PullPolicy(in.ImagePullPolicy)
	if in.SecurityContext != nil {
		in, out := &in.SecurityContext, &out.SecurityContext
		*out = new(v1.SecurityContext)
		if err := Convert_api_SecurityContext_To_v1_SecurityContext(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.SecurityContext = nil
	}
	out.Stdin = in.Stdin
	out.StdinOnce = in.StdinOnce
	out.TTY = in.TTY
	return nil
}

// Convert_api_Container_To_v1_Container is an autogenerated conversion function.
func Convert_api_Container_To_v1_Container(in *api.Container, out *v1.Container, s conversion.Scope) error {
	return autoConvert_api_Container_To_v1_Container(in, out, s)
}

func autoConvert_v1_ContainerImage_To_api_ContainerImage(in *v1.ContainerImage, out *api.ContainerImage, s conversion.Scope) error {
	out.Names = *(*[]string)(unsafe.Pointer(&in.Names))
	out.SizeBytes = in.SizeBytes
	return nil
}

// Convert_v1_ContainerImage_To_api_ContainerImage is an autogenerated conversion function.
func Convert_v1_ContainerImage_To_api_ContainerImage(in *v1.ContainerImage, out *api.ContainerImage, s conversion.Scope) error {
	return autoConvert_v1_ContainerImage_To_api_ContainerImage(in, out, s)
}

func autoConvert_api_ContainerImage_To_v1_ContainerImage(in *api.ContainerImage, out *v1.ContainerImage, s conversion.Scope) error {
	out.Names = *(*[]string)(unsafe.Pointer(&in.Names))
	out.SizeBytes = in.SizeBytes
	return nil
}

// Convert_api_ContainerImage_To_v1_ContainerImage is an autogenerated conversion function.
func Convert_api_ContainerImage_To_v1_ContainerImage(in *api.ContainerImage, out *v1.ContainerImage, s conversion.Scope) error {
	return autoConvert_api_ContainerImage_To_v1_ContainerImage(in, out, s)
}

func autoConvert_v1_ContainerPort_To_api_ContainerPort(in *v1.ContainerPort, out *api.ContainerPort, s conversion.Scope) error {
	out.Name = in.Name
	out.HostPort = in.HostPort
	out.ContainerPort = in.ContainerPort
	out.Protocol = api.Protocol(in.Protocol)
	out.HostIP = in.HostIP
	return nil
}

// Convert_v1_ContainerPort_To_api_ContainerPort is an autogenerated conversion function.
func Convert_v1_ContainerPort_To_api_ContainerPort(in *v1.ContainerPort, out *api.ContainerPort, s conversion.Scope) error {
	return autoConvert_v1_ContainerPort_To_api_ContainerPort(in, out, s)
}

func autoConvert_api_ContainerPort_To_v1_ContainerPort(in *api.ContainerPort, out *v1.ContainerPort, s conversion.Scope) error {
	out.Name = in.Name
	out.HostPort = in.HostPort
	out.ContainerPort = in.ContainerPort
	out.Protocol = v1.Protocol(in.Protocol)
	out.HostIP = in.HostIP
	return nil
}

// Convert_api_ContainerPort_To_v1_ContainerPort is an autogenerated conversion function.
func Convert_api_ContainerPort_To_v1_ContainerPort(in *api.ContainerPort, out *v1.ContainerPort, s conversion.Scope) error {
	return autoConvert_api_ContainerPort_To_v1_ContainerPort(in, out, s)
}

func autoConvert_v1_ContainerState_To_api_ContainerState(in *v1.ContainerState, out *api.ContainerState, s conversion.Scope) error {
	out.Waiting = (*api.ContainerStateWaiting)(unsafe.Pointer(in.Waiting))
	out.Running = (*api.ContainerStateRunning)(unsafe.Pointer(in.Running))
	out.Terminated = (*api.ContainerStateTerminated)(unsafe.Pointer(in.Terminated))
	return nil
}

// Convert_v1_ContainerState_To_api_ContainerState is an autogenerated conversion function.
func Convert_v1_ContainerState_To_api_ContainerState(in *v1.ContainerState, out *api.ContainerState, s conversion.Scope) error {
	return autoConvert_v1_ContainerState_To_api_ContainerState(in, out, s)
}

func autoConvert_api_ContainerState_To_v1_ContainerState(in *api.ContainerState, out *v1.ContainerState, s conversion.Scope) error {
	out.Waiting = (*v1.ContainerStateWaiting)(unsafe.Pointer(in.Waiting))
	out.Running = (*v1.ContainerStateRunning)(unsafe.Pointer(in.Running))
	out.Terminated = (*v1.ContainerStateTerminated)(unsafe.Pointer(in.Terminated))
	return nil
}

// Convert_api_ContainerState_To_v1_ContainerState is an autogenerated conversion function.
func Convert_api_ContainerState_To_v1_ContainerState(in *api.ContainerState, out *v1.ContainerState, s conversion.Scope) error {
	return autoConvert_api_ContainerState_To_v1_ContainerState(in, out, s)
}

func autoConvert_v1_ContainerStateRunning_To_api_ContainerStateRunning(in *v1.ContainerStateRunning, out *api.ContainerStateRunning, s conversion.Scope) error {
	out.StartedAt = in.StartedAt
	return nil
}

// Convert_v1_ContainerStateRunning_To_api_ContainerStateRunning is an autogenerated conversion function.
func Convert_v1_ContainerStateRunning_To_api_ContainerStateRunning(in *v1.ContainerStateRunning, out *api.ContainerStateRunning, s conversion.Scope) error {
	return autoConvert_v1_ContainerStateRunning_To_api_ContainerStateRunning(in, out, s)
}

func autoConvert_api_ContainerStateRunning_To_v1_ContainerStateRunning(in *api.ContainerStateRunning, out *v1.ContainerStateRunning, s conversion.Scope) error {
	out.StartedAt = in.StartedAt
	return nil
}

// Convert_api_ContainerStateRunning_To_v1_ContainerStateRunning is an autogenerated conversion function.
func Convert_api_ContainerStateRunning_To_v1_ContainerStateRunning(in *api.ContainerStateRunning, out *v1.ContainerStateRunning, s conversion.Scope) error {
	return autoConvert_api_ContainerStateRunning_To_v1_ContainerStateRunning(in, out, s)
}

func autoConvert_v1_ContainerStateTerminated_To_api_ContainerStateTerminated(in *v1.ContainerStateTerminated, out *api.ContainerStateTerminated, s conversion.Scope) error {
	out.ExitCode = in.ExitCode
	out.Signal = in.Signal
	out.Reason = in.Reason
	out.Message = in.Message
	out.StartedAt = in.StartedAt
	out.FinishedAt = in.FinishedAt
	out.ContainerID = in.ContainerID
	return nil
}

// Convert_v1_ContainerStateTerminated_To_api_ContainerStateTerminated is an autogenerated conversion function.
func Convert_v1_ContainerStateTerminated_To_api_ContainerStateTerminated(in *v1.ContainerStateTerminated, out *api.ContainerStateTerminated, s conversion.Scope) error {
	return autoConvert_v1_ContainerStateTerminated_To_api_ContainerStateTerminated(in, out, s)
}

func autoConvert_api_ContainerStateTerminated_To_v1_ContainerStateTerminated(in *api.ContainerStateTerminated, out *v1.ContainerStateTerminated, s conversion.Scope) error {
	out.ExitCode = in.ExitCode
	out.Signal = in.Signal
	out.Reason = in.Reason
	out.Message = in.Message
	out.StartedAt = in.StartedAt
	out.FinishedAt = in.FinishedAt
	out.ContainerID = in.ContainerID
	return nil
}

// Convert_api_ContainerStateTerminated_To_v1_ContainerStateTerminated is an autogenerated conversion function.
func Convert_api_ContainerStateTerminated_To_v1_ContainerStateTerminated(in *api.ContainerStateTerminated, out *v1.ContainerStateTerminated, s conversion.Scope) error {
	return autoConvert_api_ContainerStateTerminated_To_v1_ContainerStateTerminated(in, out, s)
}

func autoConvert_v1_ContainerStateWaiting_To_api_ContainerStateWaiting(in *v1.ContainerStateWaiting, out *api.ContainerStateWaiting, s conversion.Scope) error {
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1_ContainerStateWaiting_To_api_ContainerStateWaiting is an autogenerated conversion function.
func Convert_v1_ContainerStateWaiting_To_api_ContainerStateWaiting(in *v1.ContainerStateWaiting, out *api.ContainerStateWaiting, s conversion.Scope) error {
	return autoConvert_v1_ContainerStateWaiting_To_api_ContainerStateWaiting(in, out, s)
}

func autoConvert_api_ContainerStateWaiting_To_v1_ContainerStateWaiting(in *api.ContainerStateWaiting, out *v1.ContainerStateWaiting, s conversion.Scope) error {
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_api_ContainerStateWaiting_To_v1_ContainerStateWaiting is an autogenerated conversion function.
func Convert_api_ContainerStateWaiting_To_v1_ContainerStateWaiting(in *api.ContainerStateWaiting, out *v1.ContainerStateWaiting, s conversion.Scope) error {
	return autoConvert_api_ContainerStateWaiting_To_v1_ContainerStateWaiting(in, out, s)
}

func autoConvert_v1_ContainerStatus_To_api_ContainerStatus(in *v1.ContainerStatus, out *api.ContainerStatus, s conversion.Scope) error {
	out.Name = in.Name
	if err := Convert_v1_ContainerState_To_api_ContainerState(&in.State, &out.State, s); err != nil {
		return err
	}
	if err := Convert_v1_ContainerState_To_api_ContainerState(&in.LastTerminationState, &out.LastTerminationState, s); err != nil {
		return err
	}
	out.Ready = in.Ready
	out.RestartCount = in.RestartCount
	out.Image = in.Image
	out.ImageID = in.ImageID
	out.ContainerID = in.ContainerID
	return nil
}

// Convert_v1_ContainerStatus_To_api_ContainerStatus is an autogenerated conversion function.
func Convert_v1_ContainerStatus_To_api_ContainerStatus(in *v1.ContainerStatus, out *api.ContainerStatus, s conversion.Scope) error {
	return autoConvert_v1_ContainerStatus_To_api_ContainerStatus(in, out, s)
}

func autoConvert_api_ContainerStatus_To_v1_ContainerStatus(in *api.ContainerStatus, out *v1.ContainerStatus, s conversion.Scope) error {
	out.Name = in.Name
	if err := Convert_api_ContainerState_To_v1_ContainerState(&in.State, &out.State, s); err != nil {
		return err
	}
	if err := Convert_api_ContainerState_To_v1_ContainerState(&in.LastTerminationState, &out.LastTerminationState, s); err != nil {
		return err
	}
	out.Ready = in.Ready
	out.RestartCount = in.RestartCount
	out.Image = in.Image
	out.ImageID = in.ImageID
	out.ContainerID = in.ContainerID
	return nil
}

// Convert_api_ContainerStatus_To_v1_ContainerStatus is an autogenerated conversion function.
func Convert_api_ContainerStatus_To_v1_ContainerStatus(in *api.ContainerStatus, out *v1.ContainerStatus, s conversion.Scope) error {
	return autoConvert_api_ContainerStatus_To_v1_ContainerStatus(in, out, s)
}

func autoConvert_v1_DaemonEndpoint_To_api_DaemonEndpoint(in *v1.DaemonEndpoint, out *api.DaemonEndpoint, s conversion.Scope) error {
	out.Port = in.Port
	return nil
}

// Convert_v1_DaemonEndpoint_To_api_DaemonEndpoint is an autogenerated conversion function.
func Convert_v1_DaemonEndpoint_To_api_DaemonEndpoint(in *v1.DaemonEndpoint, out *api.DaemonEndpoint, s conversion.Scope) error {
	return autoConvert_v1_DaemonEndpoint_To_api_DaemonEndpoint(in, out, s)
}

func autoConvert_api_DaemonEndpoint_To_v1_DaemonEndpoint(in *api.DaemonEndpoint, out *v1.DaemonEndpoint, s conversion.Scope) error {
	out.Port = in.Port
	return nil
}

// Convert_api_DaemonEndpoint_To_v1_DaemonEndpoint is an autogenerated conversion function.
func Convert_api_DaemonEndpoint_To_v1_DaemonEndpoint(in *api.DaemonEndpoint, out *v1.DaemonEndpoint, s conversion.Scope) error {
	return autoConvert_api_DaemonEndpoint_To_v1_DaemonEndpoint(in, out, s)
}

func autoConvert_v1_DeleteOptions_To_api_DeleteOptions(in *v1.DeleteOptions, out *api.DeleteOptions, s conversion.Scope) error {
	out.GracePeriodSeconds = (*int64)(unsafe.Pointer(in.GracePeriodSeconds))
	out.Preconditions = (*api.Preconditions)(unsafe.Pointer(in.Preconditions))
	out.OrphanDependents = (*bool)(unsafe.Pointer(in.OrphanDependents))
	out.PropagationPolicy = (*api.DeletionPropagation)(unsafe.Pointer(in.PropagationPolicy))
	return nil
}

// Convert_v1_DeleteOptions_To_api_DeleteOptions is an autogenerated conversion function.
func Convert_v1_DeleteOptions_To_api_DeleteOptions(in *v1.DeleteOptions, out *api.DeleteOptions, s conversion.Scope) error {
	return autoConvert_v1_DeleteOptions_To_api_DeleteOptions(in, out, s)
}

func autoConvert_api_DeleteOptions_To_v1_DeleteOptions(in *api.DeleteOptions, out *v1.DeleteOptions, s conversion.Scope) error {
	out.GracePeriodSeconds = (*int64)(unsafe.Pointer(in.GracePeriodSeconds))
	out.Preconditions = (*v1.Preconditions)(unsafe.Pointer(in.Preconditions))
	out.OrphanDependents = (*bool)(unsafe.Pointer(in.OrphanDependents))
	out.PropagationPolicy = (*v1.DeletionPropagation)(unsafe.Pointer(in.PropagationPolicy))
	return nil
}

// Convert_api_DeleteOptions_To_v1_DeleteOptions is an autogenerated conversion function.
func Convert_api_DeleteOptions_To_v1_DeleteOptions(in *api.DeleteOptions, out *v1.DeleteOptions, s conversion.Scope) error {
	return autoConvert_api_DeleteOptions_To_v1_DeleteOptions(in, out, s)
}

func autoConvert_v1_DownwardAPIProjection_To_api_DownwardAPIProjection(in *v1.DownwardAPIProjection, out *api.DownwardAPIProjection, s conversion.Scope) error {
	out.Items = *(*[]api.DownwardAPIVolumeFile)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1_DownwardAPIProjection_To_api_DownwardAPIProjection is an autogenerated conversion function.
func Convert_v1_DownwardAPIProjection_To_api_DownwardAPIProjection(in *v1.DownwardAPIProjection, out *api.DownwardAPIProjection, s conversion.Scope) error {
	return autoConvert_v1_DownwardAPIProjection_To_api_DownwardAPIProjection(in, out, s)
}

func autoConvert_api_DownwardAPIProjection_To_v1_DownwardAPIProjection(in *api.DownwardAPIProjection, out *v1.DownwardAPIProjection, s conversion.Scope) error {
	out.Items = *(*[]v1.DownwardAPIVolumeFile)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_api_DownwardAPIProjection_To_v1_DownwardAPIProjection is an autogenerated conversion function.
func Convert_api_DownwardAPIProjection_To_v1_DownwardAPIProjection(in *api.DownwardAPIProjection, out *v1.DownwardAPIProjection, s conversion.Scope) error {
	return autoConvert_api_DownwardAPIProjection_To_v1_DownwardAPIProjection(in, out, s)
}

func autoConvert_v1_DownwardAPIVolumeFile_To_api_DownwardAPIVolumeFile(in *v1.DownwardAPIVolumeFile, out *api.DownwardAPIVolumeFile, s conversion.Scope) error {
	out.Path = in.Path
	out.FieldRef = (*api.ObjectFieldSelector)(unsafe.Pointer(in.FieldRef))
	out.ResourceFieldRef = (*api.ResourceFieldSelector)(unsafe.Pointer(in.ResourceFieldRef))
	out.Mode = (*int32)(unsafe.Pointer(in.Mode))
	return nil
}

// Convert_v1_DownwardAPIVolumeFile_To_api_DownwardAPIVolumeFile is an autogenerated conversion function.
func Convert_v1_DownwardAPIVolumeFile_To_api_DownwardAPIVolumeFile(in *v1.DownwardAPIVolumeFile, out *api.DownwardAPIVolumeFile, s conversion.Scope) error {
	return autoConvert_v1_DownwardAPIVolumeFile_To_api_DownwardAPIVolumeFile(in, out, s)
}

func autoConvert_api_DownwardAPIVolumeFile_To_v1_DownwardAPIVolumeFile(in *api.DownwardAPIVolumeFile, out *v1.DownwardAPIVolumeFile, s conversion.Scope) error {
	out.Path = in.Path
	out.FieldRef = (*v1.ObjectFieldSelector)(unsafe.Pointer(in.FieldRef))
	out.ResourceFieldRef = (*v1.ResourceFieldSelector)(unsafe.Pointer(in.ResourceFieldRef))
	out.Mode = (*int32)(unsafe.Pointer(in.Mode))
	return nil
}

// Convert_api_DownwardAPIVolumeFile_To_v1_DownwardAPIVolumeFile is an autogenerated conversion function.
func Convert_api_DownwardAPIVolumeFile_To_v1_DownwardAPIVolumeFile(in *api.DownwardAPIVolumeFile, out *v1.DownwardAPIVolumeFile, s conversion.Scope) error {
	return autoConvert_api_DownwardAPIVolumeFile_To_v1_DownwardAPIVolumeFile(in, out, s)
}

func autoConvert_v1_DownwardAPIVolumeSource_To_api_DownwardAPIVolumeSource(in *v1.DownwardAPIVolumeSource, out *api.DownwardAPIVolumeSource, s conversion.Scope) error {
	out.Items = *(*[]api.DownwardAPIVolumeFile)(unsafe.Pointer(&in.Items))
	out.DefaultMode = (*int32)(unsafe.Pointer(in.DefaultMode))
	return nil
}

// Convert_v1_DownwardAPIVolumeSource_To_api_DownwardAPIVolumeSource is an autogenerated conversion function.
func Convert_v1_DownwardAPIVolumeSource_To_api_DownwardAPIVolumeSource(in *v1.DownwardAPIVolumeSource, out *api.DownwardAPIVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_DownwardAPIVolumeSource_To_api_DownwardAPIVolumeSource(in, out, s)
}

func autoConvert_api_DownwardAPIVolumeSource_To_v1_DownwardAPIVolumeSource(in *api.DownwardAPIVolumeSource, out *v1.DownwardAPIVolumeSource, s conversion.Scope) error {
	out.Items = *(*[]v1.DownwardAPIVolumeFile)(unsafe.Pointer(&in.Items))
	out.DefaultMode = (*int32)(unsafe.Pointer(in.DefaultMode))
	return nil
}

// Convert_api_DownwardAPIVolumeSource_To_v1_DownwardAPIVolumeSource is an autogenerated conversion function.
func Convert_api_DownwardAPIVolumeSource_To_v1_DownwardAPIVolumeSource(in *api.DownwardAPIVolumeSource, out *v1.DownwardAPIVolumeSource, s conversion.Scope) error {
	return autoConvert_api_DownwardAPIVolumeSource_To_v1_DownwardAPIVolumeSource(in, out, s)
}

func autoConvert_v1_EmptyDirVolumeSource_To_api_EmptyDirVolumeSource(in *v1.EmptyDirVolumeSource, out *api.EmptyDirVolumeSource, s conversion.Scope) error {
	out.Medium = api.StorageMedium(in.Medium)
	out.SizeLimit = (*resource.Quantity)(unsafe.Pointer(in.SizeLimit))
	return nil
}

// Convert_v1_EmptyDirVolumeSource_To_api_EmptyDirVolumeSource is an autogenerated conversion function.
func Convert_v1_EmptyDirVolumeSource_To_api_EmptyDirVolumeSource(in *v1.EmptyDirVolumeSource, out *api.EmptyDirVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_EmptyDirVolumeSource_To_api_EmptyDirVolumeSource(in, out, s)
}

func autoConvert_api_EmptyDirVolumeSource_To_v1_EmptyDirVolumeSource(in *api.EmptyDirVolumeSource, out *v1.EmptyDirVolumeSource, s conversion.Scope) error {
	out.Medium = v1.StorageMedium(in.Medium)
	out.SizeLimit = (*resource.Quantity)(unsafe.Pointer(in.SizeLimit))
	return nil
}

// Convert_api_EmptyDirVolumeSource_To_v1_EmptyDirVolumeSource is an autogenerated conversion function.
func Convert_api_EmptyDirVolumeSource_To_v1_EmptyDirVolumeSource(in *api.EmptyDirVolumeSource, out *v1.EmptyDirVolumeSource, s conversion.Scope) error {
	return autoConvert_api_EmptyDirVolumeSource_To_v1_EmptyDirVolumeSource(in, out, s)
}

func autoConvert_v1_EndpointAddress_To_api_EndpointAddress(in *v1.EndpointAddress, out *api.EndpointAddress, s conversion.Scope) error {
	out.IP = in.IP
	out.Hostname = in.Hostname
	out.NodeName = (*string)(unsafe.Pointer(in.NodeName))
	out.TargetRef = (*api.ObjectReference)(unsafe.Pointer(in.TargetRef))
	return nil
}

// Convert_v1_EndpointAddress_To_api_EndpointAddress is an autogenerated conversion function.
func Convert_v1_EndpointAddress_To_api_EndpointAddress(in *v1.EndpointAddress, out *api.EndpointAddress, s conversion.Scope) error {
	return autoConvert_v1_EndpointAddress_To_api_EndpointAddress(in, out, s)
}

func autoConvert_api_EndpointAddress_To_v1_EndpointAddress(in *api.EndpointAddress, out *v1.EndpointAddress, s conversion.Scope) error {
	out.IP = in.IP
	out.Hostname = in.Hostname
	out.NodeName = (*string)(unsafe.Pointer(in.NodeName))
	out.TargetRef = (*v1.ObjectReference)(unsafe.Pointer(in.TargetRef))
	return nil
}

// Convert_api_EndpointAddress_To_v1_EndpointAddress is an autogenerated conversion function.
func Convert_api_EndpointAddress_To_v1_EndpointAddress(in *api.EndpointAddress, out *v1.EndpointAddress, s conversion.Scope) error {
	return autoConvert_api_EndpointAddress_To_v1_EndpointAddress(in, out, s)
}

func autoConvert_v1_EndpointPort_To_api_EndpointPort(in *v1.EndpointPort, out *api.EndpointPort, s conversion.Scope) error {
	out.Name = in.Name
	out.Port = in.Port
	out.Protocol = api.Protocol(in.Protocol)
	return nil
}

// Convert_v1_EndpointPort_To_api_EndpointPort is an autogenerated conversion function.
func Convert_v1_EndpointPort_To_api_EndpointPort(in *v1.EndpointPort, out *api.EndpointPort, s conversion.Scope) error {
	return autoConvert_v1_EndpointPort_To_api_EndpointPort(in, out, s)
}

func autoConvert_api_EndpointPort_To_v1_EndpointPort(in *api.EndpointPort, out *v1.EndpointPort, s conversion.Scope) error {
	out.Name = in.Name
	out.Port = in.Port
	out.Protocol = v1.Protocol(in.Protocol)
	return nil
}

// Convert_api_EndpointPort_To_v1_EndpointPort is an autogenerated conversion function.
func Convert_api_EndpointPort_To_v1_EndpointPort(in *api.EndpointPort, out *v1.EndpointPort, s conversion.Scope) error {
	return autoConvert_api_EndpointPort_To_v1_EndpointPort(in, out, s)
}

func autoConvert_v1_EndpointSubset_To_api_EndpointSubset(in *v1.EndpointSubset, out *api.EndpointSubset, s conversion.Scope) error {
	out.Addresses = *(*[]api.EndpointAddress)(unsafe.Pointer(&in.Addresses))
	out.NotReadyAddresses = *(*[]api.EndpointAddress)(unsafe.Pointer(&in.NotReadyAddresses))
	out.Ports = *(*[]api.EndpointPort)(unsafe.Pointer(&in.Ports))
	return nil
}

// Convert_v1_EndpointSubset_To_api_EndpointSubset is an autogenerated conversion function.
func Convert_v1_EndpointSubset_To_api_EndpointSubset(in *v1.EndpointSubset, out *api.EndpointSubset, s conversion.Scope) error {
	return autoConvert_v1_EndpointSubset_To_api_EndpointSubset(in, out, s)
}

func autoConvert_api_EndpointSubset_To_v1_EndpointSubset(in *api.EndpointSubset, out *v1.EndpointSubset, s conversion.Scope) error {
	out.Addresses = *(*[]v1.EndpointAddress)(unsafe.Pointer(&in.Addresses))
	out.NotReadyAddresses = *(*[]v1.EndpointAddress)(unsafe.Pointer(&in.NotReadyAddresses))
	out.Ports = *(*[]v1.EndpointPort)(unsafe.Pointer(&in.Ports))
	return nil
}

// Convert_api_EndpointSubset_To_v1_EndpointSubset is an autogenerated conversion function.
func Convert_api_EndpointSubset_To_v1_EndpointSubset(in *api.EndpointSubset, out *v1.EndpointSubset, s conversion.Scope) error {
	return autoConvert_api_EndpointSubset_To_v1_EndpointSubset(in, out, s)
}

func autoConvert_v1_Endpoints_To_api_Endpoints(in *v1.Endpoints, out *api.Endpoints, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Subsets = *(*[]api.EndpointSubset)(unsafe.Pointer(&in.Subsets))
	return nil
}

// Convert_v1_Endpoints_To_api_Endpoints is an autogenerated conversion function.
func Convert_v1_Endpoints_To_api_Endpoints(in *v1.Endpoints, out *api.Endpoints, s conversion.Scope) error {
	return autoConvert_v1_Endpoints_To_api_Endpoints(in, out, s)
}

func autoConvert_api_Endpoints_To_v1_Endpoints(in *api.Endpoints, out *v1.Endpoints, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Subsets = *(*[]v1.EndpointSubset)(unsafe.Pointer(&in.Subsets))
	return nil
}

// Convert_api_Endpoints_To_v1_Endpoints is an autogenerated conversion function.
func Convert_api_Endpoints_To_v1_Endpoints(in *api.Endpoints, out *v1.Endpoints, s conversion.Scope) error {
	return autoConvert_api_Endpoints_To_v1_Endpoints(in, out, s)
}

func autoConvert_v1_EndpointsList_To_api_EndpointsList(in *v1.EndpointsList, out *api.EndpointsList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]api.Endpoints)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1_EndpointsList_To_api_EndpointsList is an autogenerated conversion function.
func Convert_v1_EndpointsList_To_api_EndpointsList(in *v1.EndpointsList, out *api.EndpointsList, s conversion.Scope) error {
	return autoConvert_v1_EndpointsList_To_api_EndpointsList(in, out, s)
}

func autoConvert_api_EndpointsList_To_v1_EndpointsList(in *api.EndpointsList, out *v1.EndpointsList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1.Endpoints)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_api_EndpointsList_To_v1_EndpointsList is an autogenerated conversion function.
func Convert_api_EndpointsList_To_v1_EndpointsList(in *api.EndpointsList, out *v1.EndpointsList, s conversion.Scope) error {
	return autoConvert_api_EndpointsList_To_v1_EndpointsList(in, out, s)
}

func autoConvert_v1_EnvFromSource_To_api_EnvFromSource(in *v1.EnvFromSource, out *api.EnvFromSource, s conversion.Scope) error {
	out.Prefix = in.Prefix
	out.ConfigMapRef = (*api.ConfigMapEnvSource)(unsafe.Pointer(in.ConfigMapRef))
	out.SecretRef = (*api.SecretEnvSource)(unsafe.Pointer(in.SecretRef))
	return nil
}

// Convert_v1_EnvFromSource_To_api_EnvFromSource is an autogenerated conversion function.
func Convert_v1_EnvFromSource_To_api_EnvFromSource(in *v1.EnvFromSource, out *api.EnvFromSource, s conversion.Scope) error {
	return autoConvert_v1_EnvFromSource_To_api_EnvFromSource(in, out, s)
}

func autoConvert_api_EnvFromSource_To_v1_EnvFromSource(in *api.EnvFromSource, out *v1.EnvFromSource, s conversion.Scope) error {
	out.Prefix = in.Prefix
	out.ConfigMapRef = (*v1.ConfigMapEnvSource)(unsafe.Pointer(in.ConfigMapRef))
	out.SecretRef = (*v1.SecretEnvSource)(unsafe.Pointer(in.SecretRef))
	return nil
}

// Convert_api_EnvFromSource_To_v1_EnvFromSource is an autogenerated conversion function.
func Convert_api_EnvFromSource_To_v1_EnvFromSource(in *api.EnvFromSource, out *v1.EnvFromSource, s conversion.Scope) error {
	return autoConvert_api_EnvFromSource_To_v1_EnvFromSource(in, out, s)
}

func autoConvert_v1_EnvVar_To_api_EnvVar(in *v1.EnvVar, out *api.EnvVar, s conversion.Scope) error {
	out.Name = in.Name
	out.Value = in.Value
	out.ValueFrom = (*api.EnvVarSource)(unsafe.Pointer(in.ValueFrom))
	return nil
}

// Convert_v1_EnvVar_To_api_EnvVar is an autogenerated conversion function.
func Convert_v1_EnvVar_To_api_EnvVar(in *v1.EnvVar, out *api.EnvVar, s conversion.Scope) error {
	return autoConvert_v1_EnvVar_To_api_EnvVar(in, out, s)
}

func autoConvert_api_EnvVar_To_v1_EnvVar(in *api.EnvVar, out *v1.EnvVar, s conversion.Scope) error {
	out.Name = in.Name
	out.Value = in.Value
	out.ValueFrom = (*v1.EnvVarSource)(unsafe.Pointer(in.ValueFrom))
	return nil
}

// Convert_api_EnvVar_To_v1_EnvVar is an autogenerated conversion function.
func Convert_api_EnvVar_To_v1_EnvVar(in *api.EnvVar, out *v1.EnvVar, s conversion.Scope) error {
	return autoConvert_api_EnvVar_To_v1_EnvVar(in, out, s)
}

func autoConvert_v1_EnvVarSource_To_api_EnvVarSource(in *v1.EnvVarSource, out *api.EnvVarSource, s conversion.Scope) error {
	out.FieldRef = (*api.ObjectFieldSelector)(unsafe.Pointer(in.FieldRef))
	out.ResourceFieldRef = (*api.ResourceFieldSelector)(unsafe.Pointer(in.ResourceFieldRef))
	out.ConfigMapKeyRef = (*api.ConfigMapKeySelector)(unsafe.Pointer(in.ConfigMapKeyRef))
	out.SecretKeyRef = (*api.SecretKeySelector)(unsafe.Pointer(in.SecretKeyRef))
	return nil
}

// Convert_v1_EnvVarSource_To_api_EnvVarSource is an autogenerated conversion function.
func Convert_v1_EnvVarSource_To_api_EnvVarSource(in *v1.EnvVarSource, out *api.EnvVarSource, s conversion.Scope) error {
	return autoConvert_v1_EnvVarSource_To_api_EnvVarSource(in, out, s)
}

func autoConvert_api_EnvVarSource_To_v1_EnvVarSource(in *api.EnvVarSource, out *v1.EnvVarSource, s conversion.Scope) error {
	out.FieldRef = (*v1.ObjectFieldSelector)(unsafe.Pointer(in.FieldRef))
	out.ResourceFieldRef = (*v1.ResourceFieldSelector)(unsafe.Pointer(in.ResourceFieldRef))
	out.ConfigMapKeyRef = (*v1.ConfigMapKeySelector)(unsafe.Pointer(in.ConfigMapKeyRef))
	out.SecretKeyRef = (*v1.SecretKeySelector)(unsafe.Pointer(in.SecretKeyRef))
	return nil
}

// Convert_api_EnvVarSource_To_v1_EnvVarSource is an autogenerated conversion function.
func Convert_api_EnvVarSource_To_v1_EnvVarSource(in *api.EnvVarSource, out *v1.EnvVarSource, s conversion.Scope) error {
	return autoConvert_api_EnvVarSource_To_v1_EnvVarSource(in, out, s)
}

func autoConvert_v1_Event_To_api_Event(in *v1.Event, out *api.Event, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_ObjectReference_To_api_ObjectReference(&in.InvolvedObject, &out.InvolvedObject, s); err != nil {
		return err
	}
	out.Reason = in.Reason
	out.Message = in.Message
	if err := Convert_v1_EventSource_To_api_EventSource(&in.Source, &out.Source, s); err != nil {
		return err
	}
	out.FirstTimestamp = in.FirstTimestamp
	out.LastTimestamp = in.LastTimestamp
	out.Count = in.Count
	out.Type = in.Type
	return nil
}

// Convert_v1_Event_To_api_Event is an autogenerated conversion function.
func Convert_v1_Event_To_api_Event(in *v1.Event, out *api.Event, s conversion.Scope) error {
	return autoConvert_v1_Event_To_api_Event(in, out, s)
}

func autoConvert_api_Event_To_v1_Event(in *api.Event, out *v1.Event, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_api_ObjectReference_To_v1_ObjectReference(&in.InvolvedObject, &out.InvolvedObject, s); err != nil {
		return err
	}
	out.Reason = in.Reason
	out.Message = in.Message
	if err := Convert_api_EventSource_To_v1_EventSource(&in.Source, &out.Source, s); err != nil {
		return err
	}
	out.FirstTimestamp = in.FirstTimestamp
	out.LastTimestamp = in.LastTimestamp
	out.Count = in.Count
	out.Type = in.Type
	return nil
}

// Convert_api_Event_To_v1_Event is an autogenerated conversion function.
func Convert_api_Event_To_v1_Event(in *api.Event, out *v1.Event, s conversion.Scope) error {
	return autoConvert_api_Event_To_v1_Event(in, out, s)
}

func autoConvert_v1_EventList_To_api_EventList(in *v1.EventList, out *api.EventList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]api.Event)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1_EventList_To_api_EventList is an autogenerated conversion function.
func Convert_v1_EventList_To_api_EventList(in *v1.EventList, out *api.EventList, s conversion.Scope) error {
	return autoConvert_v1_EventList_To_api_EventList(in, out, s)
}

func autoConvert_api_EventList_To_v1_EventList(in *api.EventList, out *v1.EventList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1.Event)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_api_EventList_To_v1_EventList is an autogenerated conversion function.
func Convert_api_EventList_To_v1_EventList(in *api.EventList, out *v1.EventList, s conversion.Scope) error {
	return autoConvert_api_EventList_To_v1_EventList(in, out, s)
}

func autoConvert_v1_EventSource_To_api_EventSource(in *v1.EventSource, out *api.EventSource, s conversion.Scope) error {
	out.Component = in.Component
	out.Host = in.Host
	return nil
}

// Convert_v1_EventSource_To_api_EventSource is an autogenerated conversion function.
func Convert_v1_EventSource_To_api_EventSource(in *v1.EventSource, out *api.EventSource, s conversion.Scope) error {
	return autoConvert_v1_EventSource_To_api_EventSource(in, out, s)
}

func autoConvert_api_EventSource_To_v1_EventSource(in *api.EventSource, out *v1.EventSource, s conversion.Scope) error {
	out.Component = in.Component
	out.Host = in.Host
	return nil
}

// Convert_api_EventSource_To_v1_EventSource is an autogenerated conversion function.
func Convert_api_EventSource_To_v1_EventSource(in *api.EventSource, out *v1.EventSource, s conversion.Scope) error {
	return autoConvert_api_EventSource_To_v1_EventSource(in, out, s)
}

func autoConvert_v1_ExecAction_To_api_ExecAction(in *v1.ExecAction, out *api.ExecAction, s conversion.Scope) error {
	out.Command = *(*[]string)(unsafe.Pointer(&in.Command))
	return nil
}

// Convert_v1_ExecAction_To_api_ExecAction is an autogenerated conversion function.
func Convert_v1_ExecAction_To_api_ExecAction(in *v1.ExecAction, out *api.ExecAction, s conversion.Scope) error {
	return autoConvert_v1_ExecAction_To_api_ExecAction(in, out, s)
}

func autoConvert_api_ExecAction_To_v1_ExecAction(in *api.ExecAction, out *v1.ExecAction, s conversion.Scope) error {
	out.Command = *(*[]string)(unsafe.Pointer(&in.Command))
	return nil
}

// Convert_api_ExecAction_To_v1_ExecAction is an autogenerated conversion function.
func Convert_api_ExecAction_To_v1_ExecAction(in *api.ExecAction, out *v1.ExecAction, s conversion.Scope) error {
	return autoConvert_api_ExecAction_To_v1_ExecAction(in, out, s)
}

func autoConvert_v1_FCVolumeSource_To_api_FCVolumeSource(in *v1.FCVolumeSource, out *api.FCVolumeSource, s conversion.Scope) error {
	out.TargetWWNs = *(*[]string)(unsafe.Pointer(&in.TargetWWNs))
	out.Lun = (*int32)(unsafe.Pointer(in.Lun))
	out.FSType = in.FSType
	out.ReadOnly = in.ReadOnly
	out.WWIDs = *(*[]string)(unsafe.Pointer(&in.WWIDs))
	return nil
}

// Convert_v1_FCVolumeSource_To_api_FCVolumeSource is an autogenerated conversion function.
func Convert_v1_FCVolumeSource_To_api_FCVolumeSource(in *v1.FCVolumeSource, out *api.FCVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_FCVolumeSource_To_api_FCVolumeSource(in, out, s)
}

func autoConvert_api_FCVolumeSource_To_v1_FCVolumeSource(in *api.FCVolumeSource, out *v1.FCVolumeSource, s conversion.Scope) error {
	out.TargetWWNs = *(*[]string)(unsafe.Pointer(&in.TargetWWNs))
	out.Lun = (*int32)(unsafe.Pointer(in.Lun))
	out.FSType = in.FSType
	out.ReadOnly = in.ReadOnly
	out.WWIDs = *(*[]string)(unsafe.Pointer(&in.WWIDs))
	return nil
}

// Convert_api_FCVolumeSource_To_v1_FCVolumeSource is an autogenerated conversion function.
func Convert_api_FCVolumeSource_To_v1_FCVolumeSource(in *api.FCVolumeSource, out *v1.FCVolumeSource, s conversion.Scope) error {
	return autoConvert_api_FCVolumeSource_To_v1_FCVolumeSource(in, out, s)
}

func autoConvert_v1_FlexVolumeSource_To_api_FlexVolumeSource(in *v1.FlexVolumeSource, out *api.FlexVolumeSource, s conversion.Scope) error {
	out.Driver = in.Driver
	out.FSType = in.FSType
	out.SecretRef = (*api.LocalObjectReference)(unsafe.Pointer(in.SecretRef))
	out.ReadOnly = in.ReadOnly
	out.Options = *(*map[string]string)(unsafe.Pointer(&in.Options))
	return nil
}

// Convert_v1_FlexVolumeSource_To_api_FlexVolumeSource is an autogenerated conversion function.
func Convert_v1_FlexVolumeSource_To_api_FlexVolumeSource(in *v1.FlexVolumeSource, out *api.FlexVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_FlexVolumeSource_To_api_FlexVolumeSource(in, out, s)
}

func autoConvert_api_FlexVolumeSource_To_v1_FlexVolumeSource(in *api.FlexVolumeSource, out *v1.FlexVolumeSource, s conversion.Scope) error {
	out.Driver = in.Driver
	out.FSType = in.FSType
	out.SecretRef = (*v1.LocalObjectReference)(unsafe.Pointer(in.SecretRef))
	out.ReadOnly = in.ReadOnly
	out.Options = *(*map[string]string)(unsafe.Pointer(&in.Options))
	return nil
}

// Convert_api_FlexVolumeSource_To_v1_FlexVolumeSource is an autogenerated conversion function.
func Convert_api_FlexVolumeSource_To_v1_FlexVolumeSource(in *api.FlexVolumeSource, out *v1.FlexVolumeSource, s conversion.Scope) error {
	return autoConvert_api_FlexVolumeSource_To_v1_FlexVolumeSource(in, out, s)
}

func autoConvert_v1_FlockerVolumeSource_To_api_FlockerVolumeSource(in *v1.FlockerVolumeSource, out *api.FlockerVolumeSource, s conversion.Scope) error {
	out.DatasetName = in.DatasetName
	out.DatasetUUID = in.DatasetUUID
	return nil
}

// Convert_v1_FlockerVolumeSource_To_api_FlockerVolumeSource is an autogenerated conversion function.
func Convert_v1_FlockerVolumeSource_To_api_FlockerVolumeSource(in *v1.FlockerVolumeSource, out *api.FlockerVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_FlockerVolumeSource_To_api_FlockerVolumeSource(in, out, s)
}

func autoConvert_api_FlockerVolumeSource_To_v1_FlockerVolumeSource(in *api.FlockerVolumeSource, out *v1.FlockerVolumeSource, s conversion.Scope) error {
	out.DatasetName = in.DatasetName
	out.DatasetUUID = in.DatasetUUID
	return nil
}

// Convert_api_FlockerVolumeSource_To_v1_FlockerVolumeSource is an autogenerated conversion function.
func Convert_api_FlockerVolumeSource_To_v1_FlockerVolumeSource(in *api.FlockerVolumeSource, out *v1.FlockerVolumeSource, s conversion.Scope) error {
	return autoConvert_api_FlockerVolumeSource_To_v1_FlockerVolumeSource(in, out, s)
}

func autoConvert_v1_GCEPersistentDiskVolumeSource_To_api_GCEPersistentDiskVolumeSource(in *v1.GCEPersistentDiskVolumeSource, out *api.GCEPersistentDiskVolumeSource, s conversion.Scope) error {
	out.PDName = in.PDName
	out.FSType = in.FSType
	out.Partition = in.Partition
	out.ReadOnly = in.ReadOnly
	return nil
}

// Convert_v1_GCEPersistentDiskVolumeSource_To_api_GCEPersistentDiskVolumeSource is an autogenerated conversion function.
func Convert_v1_GCEPersistentDiskVolumeSource_To_api_GCEPersistentDiskVolumeSource(in *v1.GCEPersistentDiskVolumeSource, out *api.GCEPersistentDiskVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_GCEPersistentDiskVolumeSource_To_api_GCEPersistentDiskVolumeSource(in, out, s)
}

func autoConvert_api_GCEPersistentDiskVolumeSource_To_v1_GCEPersistentDiskVolumeSource(in *api.GCEPersistentDiskVolumeSource, out *v1.GCEPersistentDiskVolumeSource, s conversion.Scope) error {
	out.PDName = in.PDName
	out.FSType = in.FSType
	out.Partition = in.Partition
	out.ReadOnly = in.ReadOnly
	return nil
}

// Convert_api_GCEPersistentDiskVolumeSource_To_v1_GCEPersistentDiskVolumeSource is an autogenerated conversion function.
func Convert_api_GCEPersistentDiskVolumeSource_To_v1_GCEPersistentDiskVolumeSource(in *api.GCEPersistentDiskVolumeSource, out *v1.GCEPersistentDiskVolumeSource, s conversion.Scope) error {
	return autoConvert_api_GCEPersistentDiskVolumeSource_To_v1_GCEPersistentDiskVolumeSource(in, out, s)
}

func autoConvert_v1_GitRepoVolumeSource_To_api_GitRepoVolumeSource(in *v1.GitRepoVolumeSource, out *api.GitRepoVolumeSource, s conversion.Scope) error {
	out.Repository = in.Repository
	out.Revision = in.Revision
	out.Directory = in.Directory
	return nil
}

// Convert_v1_GitRepoVolumeSource_To_api_GitRepoVolumeSource is an autogenerated conversion function.
func Convert_v1_GitRepoVolumeSource_To_api_GitRepoVolumeSource(in *v1.GitRepoVolumeSource, out *api.GitRepoVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_GitRepoVolumeSource_To_api_GitRepoVolumeSource(in, out, s)
}

func autoConvert_api_GitRepoVolumeSource_To_v1_GitRepoVolumeSource(in *api.GitRepoVolumeSource, out *v1.GitRepoVolumeSource, s conversion.Scope) error {
	out.Repository = in.Repository
	out.Revision = in.Revision
	out.Directory = in.Directory
	return nil
}

// Convert_api_GitRepoVolumeSource_To_v1_GitRepoVolumeSource is an autogenerated conversion function.
func Convert_api_GitRepoVolumeSource_To_v1_GitRepoVolumeSource(in *api.GitRepoVolumeSource, out *v1.GitRepoVolumeSource, s conversion.Scope) error {
	return autoConvert_api_GitRepoVolumeSource_To_v1_GitRepoVolumeSource(in, out, s)
}

func autoConvert_v1_GlusterfsVolumeSource_To_api_GlusterfsVolumeSource(in *v1.GlusterfsVolumeSource, out *api.GlusterfsVolumeSource, s conversion.Scope) error {
	out.EndpointsName = in.EndpointsName
	out.Path = in.Path
	out.ReadOnly = in.ReadOnly
	return nil
}

// Convert_v1_GlusterfsVolumeSource_To_api_GlusterfsVolumeSource is an autogenerated conversion function.
func Convert_v1_GlusterfsVolumeSource_To_api_GlusterfsVolumeSource(in *v1.GlusterfsVolumeSource, out *api.GlusterfsVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_GlusterfsVolumeSource_To_api_GlusterfsVolumeSource(in, out, s)
}

func autoConvert_api_GlusterfsVolumeSource_To_v1_GlusterfsVolumeSource(in *api.GlusterfsVolumeSource, out *v1.GlusterfsVolumeSource, s conversion.Scope) error {
	out.EndpointsName = in.EndpointsName
	out.Path = in.Path
	out.ReadOnly = in.ReadOnly
	return nil
}

// Convert_api_GlusterfsVolumeSource_To_v1_GlusterfsVolumeSource is an autogenerated conversion function.
func Convert_api_GlusterfsVolumeSource_To_v1_GlusterfsVolumeSource(in *api.GlusterfsVolumeSource, out *v1.GlusterfsVolumeSource, s conversion.Scope) error {
	return autoConvert_api_GlusterfsVolumeSource_To_v1_GlusterfsVolumeSource(in, out, s)
}

func autoConvert_v1_HTTPGetAction_To_api_HTTPGetAction(in *v1.HTTPGetAction, out *api.HTTPGetAction, s conversion.Scope) error {
	out.Path = in.Path
	out.Port = in.Port
	out.Host = in.Host
	out.Scheme = api.URIScheme(in.Scheme)
	out.HTTPHeaders = *(*[]api.HTTPHeader)(unsafe.Pointer(&in.HTTPHeaders))
	return nil
}

// Convert_v1_HTTPGetAction_To_api_HTTPGetAction is an autogenerated conversion function.
func Convert_v1_HTTPGetAction_To_api_HTTPGetAction(in *v1.HTTPGetAction, out *api.HTTPGetAction, s conversion.Scope) error {
	return autoConvert_v1_HTTPGetAction_To_api_HTTPGetAction(in, out, s)
}

func autoConvert_api_HTTPGetAction_To_v1_HTTPGetAction(in *api.HTTPGetAction, out *v1.HTTPGetAction, s conversion.Scope) error {
	out.Path = in.Path
	out.Port = in.Port
	out.Host = in.Host
	out.Scheme = v1.URIScheme(in.Scheme)
	out.HTTPHeaders = *(*[]v1.HTTPHeader)(unsafe.Pointer(&in.HTTPHeaders))
	return nil
}

// Convert_api_HTTPGetAction_To_v1_HTTPGetAction is an autogenerated conversion function.
func Convert_api_HTTPGetAction_To_v1_HTTPGetAction(in *api.HTTPGetAction, out *v1.HTTPGetAction, s conversion.Scope) error {
	return autoConvert_api_HTTPGetAction_To_v1_HTTPGetAction(in, out, s)
}

func autoConvert_v1_HTTPHeader_To_api_HTTPHeader(in *v1.HTTPHeader, out *api.HTTPHeader, s conversion.Scope) error {
	out.Name = in.Name
	out.Value = in.Value
	return nil
}

// Convert_v1_HTTPHeader_To_api_HTTPHeader is an autogenerated conversion function.
func Convert_v1_HTTPHeader_To_api_HTTPHeader(in *v1.HTTPHeader, out *api.HTTPHeader, s conversion.Scope) error {
	return autoConvert_v1_HTTPHeader_To_api_HTTPHeader(in, out, s)
}

func autoConvert_api_HTTPHeader_To_v1_HTTPHeader(in *api.HTTPHeader, out *v1.HTTPHeader, s conversion.Scope) error {
	out.Name = in.Name
	out.Value = in.Value
	return nil
}

// Convert_api_HTTPHeader_To_v1_HTTPHeader is an autogenerated conversion function.
func Convert_api_HTTPHeader_To_v1_HTTPHeader(in *api.HTTPHeader, out *v1.HTTPHeader, s conversion.Scope) error {
	return autoConvert_api_HTTPHeader_To_v1_HTTPHeader(in, out, s)
}

func autoConvert_v1_Handler_To_api_Handler(in *v1.Handler, out *api.Handler, s conversion.Scope) error {
	out.Exec = (*api.ExecAction)(unsafe.Pointer(in.Exec))
	out.HTTPGet = (*api.HTTPGetAction)(unsafe.Pointer(in.HTTPGet))
	out.TCPSocket = (*api.TCPSocketAction)(unsafe.Pointer(in.TCPSocket))
	return nil
}

// Convert_v1_Handler_To_api_Handler is an autogenerated conversion function.
func Convert_v1_Handler_To_api_Handler(in *v1.Handler, out *api.Handler, s conversion.Scope) error {
	return autoConvert_v1_Handler_To_api_Handler(in, out, s)
}

func autoConvert_api_Handler_To_v1_Handler(in *api.Handler, out *v1.Handler, s conversion.Scope) error {
	out.Exec = (*v1.ExecAction)(unsafe.Pointer(in.Exec))
	out.HTTPGet = (*v1.HTTPGetAction)(unsafe.Pointer(in.HTTPGet))
	out.TCPSocket = (*v1.TCPSocketAction)(unsafe.Pointer(in.TCPSocket))
	return nil
}

// Convert_api_Handler_To_v1_Handler is an autogenerated conversion function.
func Convert_api_Handler_To_v1_Handler(in *api.Handler, out *v1.Handler, s conversion.Scope) error {
	return autoConvert_api_Handler_To_v1_Handler(in, out, s)
}

func autoConvert_v1_HostAlias_To_api_HostAlias(in *v1.HostAlias, out *api.HostAlias, s conversion.Scope) error {
	out.IP = in.IP
	out.Hostnames = *(*[]string)(unsafe.Pointer(&in.Hostnames))
	return nil
}

// Convert_v1_HostAlias_To_api_HostAlias is an autogenerated conversion function.
func Convert_v1_HostAlias_To_api_HostAlias(in *v1.HostAlias, out *api.HostAlias, s conversion.Scope) error {
	return autoConvert_v1_HostAlias_To_api_HostAlias(in, out, s)
}

func autoConvert_api_HostAlias_To_v1_HostAlias(in *api.HostAlias, out *v1.HostAlias, s conversion.Scope) error {
	out.IP = in.IP
	out.Hostnames = *(*[]string)(unsafe.Pointer(&in.Hostnames))
	return nil
}

// Convert_api_HostAlias_To_v1_HostAlias is an autogenerated conversion function.
func Convert_api_HostAlias_To_v1_HostAlias(in *api.HostAlias, out *v1.HostAlias, s conversion.Scope) error {
	return autoConvert_api_HostAlias_To_v1_HostAlias(in, out, s)
}

func autoConvert_v1_HostPathVolumeSource_To_api_HostPathVolumeSource(in *v1.HostPathVolumeSource, out *api.HostPathVolumeSource, s conversion.Scope) error {
	out.Path = in.Path
	out.Type = (*api.HostPathType)(unsafe.Pointer(in.Type))
	return nil
}

// Convert_v1_HostPathVolumeSource_To_api_HostPathVolumeSource is an autogenerated conversion function.
func Convert_v1_HostPathVolumeSource_To_api_HostPathVolumeSource(in *v1.HostPathVolumeSource, out *api.HostPathVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_HostPathVolumeSource_To_api_HostPathVolumeSource(in, out, s)
}

func autoConvert_api_HostPathVolumeSource_To_v1_HostPathVolumeSource(in *api.HostPathVolumeSource, out *v1.HostPathVolumeSource, s conversion.Scope) error {
	out.Path = in.Path
	out.Type = (*v1.HostPathType)(unsafe.Pointer(in.Type))
	return nil
}

// Convert_api_HostPathVolumeSource_To_v1_HostPathVolumeSource is an autogenerated conversion function.
func Convert_api_HostPathVolumeSource_To_v1_HostPathVolumeSource(in *api.HostPathVolumeSource, out *v1.HostPathVolumeSource, s conversion.Scope) error {
	return autoConvert_api_HostPathVolumeSource_To_v1_HostPathVolumeSource(in, out, s)
}

func autoConvert_v1_ISCSIVolumeSource_To_api_ISCSIVolumeSource(in *v1.ISCSIVolumeSource, out *api.ISCSIVolumeSource, s conversion.Scope) error {
	out.TargetPortal = in.TargetPortal
	out.IQN = in.IQN
	out.Lun = in.Lun
	out.ISCSIInterface = in.ISCSIInterface
	out.FSType = in.FSType
	out.ReadOnly = in.ReadOnly
	out.Portals = *(*[]string)(unsafe.Pointer(&in.Portals))
	out.DiscoveryCHAPAuth = in.DiscoveryCHAPAuth
	out.SessionCHAPAuth = in.SessionCHAPAuth
	out.SecretRef = (*api.LocalObjectReference)(unsafe.Pointer(in.SecretRef))
	out.InitiatorName = (*string)(unsafe.Pointer(in.InitiatorName))
	return nil
}

// Convert_v1_ISCSIVolumeSource_To_api_ISCSIVolumeSource is an autogenerated conversion function.
func Convert_v1_ISCSIVolumeSource_To_api_ISCSIVolumeSource(in *v1.ISCSIVolumeSource, out *api.ISCSIVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_ISCSIVolumeSource_To_api_ISCSIVolumeSource(in, out, s)
}

func autoConvert_api_ISCSIVolumeSource_To_v1_ISCSIVolumeSource(in *api.ISCSIVolumeSource, out *v1.ISCSIVolumeSource, s conversion.Scope) error {
	out.TargetPortal = in.TargetPortal
	out.IQN = in.IQN
	out.Lun = in.Lun
	out.ISCSIInterface = in.ISCSIInterface
	out.FSType = in.FSType
	out.ReadOnly = in.ReadOnly
	out.Portals = *(*[]string)(unsafe.Pointer(&in.Portals))
	out.DiscoveryCHAPAuth = in.DiscoveryCHAPAuth
	out.SessionCHAPAuth = in.SessionCHAPAuth
	out.SecretRef = (*v1.LocalObjectReference)(unsafe.Pointer(in.SecretRef))
	out.InitiatorName = (*string)(unsafe.Pointer(in.InitiatorName))
	return nil
}

// Convert_api_ISCSIVolumeSource_To_v1_ISCSIVolumeSource is an autogenerated conversion function.
func Convert_api_ISCSIVolumeSource_To_v1_ISCSIVolumeSource(in *api.ISCSIVolumeSource, out *v1.ISCSIVolumeSource, s conversion.Scope) error {
	return autoConvert_api_ISCSIVolumeSource_To_v1_ISCSIVolumeSource(in, out, s)
}

func autoConvert_v1_KeyToPath_To_api_KeyToPath(in *v1.KeyToPath, out *api.KeyToPath, s conversion.Scope) error {
	out.Key = in.Key
	out.Path = in.Path
	out.Mode = (*int32)(unsafe.Pointer(in.Mode))
	return nil
}

// Convert_v1_KeyToPath_To_api_KeyToPath is an autogenerated conversion function.
func Convert_v1_KeyToPath_To_api_KeyToPath(in *v1.KeyToPath, out *api.KeyToPath, s conversion.Scope) error {
	return autoConvert_v1_KeyToPath_To_api_KeyToPath(in, out, s)
}

func autoConvert_api_KeyToPath_To_v1_KeyToPath(in *api.KeyToPath, out *v1.KeyToPath, s conversion.Scope) error {
	out.Key = in.Key
	out.Path = in.Path
	out.Mode = (*int32)(unsafe.Pointer(in.Mode))
	return nil
}

// Convert_api_KeyToPath_To_v1_KeyToPath is an autogenerated conversion function.
func Convert_api_KeyToPath_To_v1_KeyToPath(in *api.KeyToPath, out *v1.KeyToPath, s conversion.Scope) error {
	return autoConvert_api_KeyToPath_To_v1_KeyToPath(in, out, s)
}

func autoConvert_v1_Lifecycle_To_api_Lifecycle(in *v1.Lifecycle, out *api.Lifecycle, s conversion.Scope) error {
	out.PostStart = (*api.Handler)(unsafe.Pointer(in.PostStart))
	out.PreStop = (*api.Handler)(unsafe.Pointer(in.PreStop))
	return nil
}

// Convert_v1_Lifecycle_To_api_Lifecycle is an autogenerated conversion function.
func Convert_v1_Lifecycle_To_api_Lifecycle(in *v1.Lifecycle, out *api.Lifecycle, s conversion.Scope) error {
	return autoConvert_v1_Lifecycle_To_api_Lifecycle(in, out, s)
}

func autoConvert_api_Lifecycle_To_v1_Lifecycle(in *api.Lifecycle, out *v1.Lifecycle, s conversion.Scope) error {
	out.PostStart = (*v1.Handler)(unsafe.Pointer(in.PostStart))
	out.PreStop = (*v1.Handler)(unsafe.Pointer(in.PreStop))
	return nil
}

// Convert_api_Lifecycle_To_v1_Lifecycle is an autogenerated conversion function.
func Convert_api_Lifecycle_To_v1_Lifecycle(in *api.Lifecycle, out *v1.Lifecycle, s conversion.Scope) error {
	return autoConvert_api_Lifecycle_To_v1_Lifecycle(in, out, s)
}

func autoConvert_v1_LimitRange_To_api_LimitRange(in *v1.LimitRange, out *api.LimitRange, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_LimitRangeSpec_To_api_LimitRangeSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_LimitRange_To_api_LimitRange is an autogenerated conversion function.
func Convert_v1_LimitRange_To_api_LimitRange(in *v1.LimitRange, out *api.LimitRange, s conversion.Scope) error {
	return autoConvert_v1_LimitRange_To_api_LimitRange(in, out, s)
}

func autoConvert_api_LimitRange_To_v1_LimitRange(in *api.LimitRange, out *v1.LimitRange, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_api_LimitRangeSpec_To_v1_LimitRangeSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_api_LimitRange_To_v1_LimitRange is an autogenerated conversion function.
func Convert_api_LimitRange_To_v1_LimitRange(in *api.LimitRange, out *v1.LimitRange, s conversion.Scope) error {
	return autoConvert_api_LimitRange_To_v1_LimitRange(in, out, s)
}

func autoConvert_v1_LimitRangeItem_To_api_LimitRangeItem(in *v1.LimitRangeItem, out *api.LimitRangeItem, s conversion.Scope) error {
	out.Type = api.LimitType(in.Type)
	out.Max = *(*api.ResourceList)(unsafe.Pointer(&in.Max))
	out.Min = *(*api.ResourceList)(unsafe.Pointer(&in.Min))
	out.Default = *(*api.ResourceList)(unsafe.Pointer(&in.Default))
	out.DefaultRequest = *(*api.ResourceList)(unsafe.Pointer(&in.DefaultRequest))
	out.MaxLimitRequestRatio = *(*api.ResourceList)(unsafe.Pointer(&in.MaxLimitRequestRatio))
	return nil
}

// Convert_v1_LimitRangeItem_To_api_LimitRangeItem is an autogenerated conversion function.
func Convert_v1_LimitRangeItem_To_api_LimitRangeItem(in *v1.LimitRangeItem, out *api.LimitRangeItem, s conversion.Scope) error {
	return autoConvert_v1_LimitRangeItem_To_api_LimitRangeItem(in, out, s)
}

func autoConvert_api_LimitRangeItem_To_v1_LimitRangeItem(in *api.LimitRangeItem, out *v1.LimitRangeItem, s conversion.Scope) error {
	out.Type = v1.LimitType(in.Type)
	out.Max = *(*v1.ResourceList)(unsafe.Pointer(&in.Max))
	out.Min = *(*v1.ResourceList)(unsafe.Pointer(&in.Min))
	out.Default = *(*v1.ResourceList)(unsafe.Pointer(&in.Default))
	out.DefaultRequest = *(*v1.ResourceList)(unsafe.Pointer(&in.DefaultRequest))
	out.MaxLimitRequestRatio = *(*v1.ResourceList)(unsafe.Pointer(&in.MaxLimitRequestRatio))
	return nil
}

// Convert_api_LimitRangeItem_To_v1_LimitRangeItem is an autogenerated conversion function.
func Convert_api_LimitRangeItem_To_v1_LimitRangeItem(in *api.LimitRangeItem, out *v1.LimitRangeItem, s conversion.Scope) error {
	return autoConvert_api_LimitRangeItem_To_v1_LimitRangeItem(in, out, s)
}

func autoConvert_v1_LimitRangeList_To_api_LimitRangeList(in *v1.LimitRangeList, out *api.LimitRangeList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]api.LimitRange)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1_LimitRangeList_To_api_LimitRangeList is an autogenerated conversion function.
func Convert_v1_LimitRangeList_To_api_LimitRangeList(in *v1.LimitRangeList, out *api.LimitRangeList, s conversion.Scope) error {
	return autoConvert_v1_LimitRangeList_To_api_LimitRangeList(in, out, s)
}

func autoConvert_api_LimitRangeList_To_v1_LimitRangeList(in *api.LimitRangeList, out *v1.LimitRangeList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1.LimitRange)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_api_LimitRangeList_To_v1_LimitRangeList is an autogenerated conversion function.
func Convert_api_LimitRangeList_To_v1_LimitRangeList(in *api.LimitRangeList, out *v1.LimitRangeList, s conversion.Scope) error {
	return autoConvert_api_LimitRangeList_To_v1_LimitRangeList(in, out, s)
}

func autoConvert_v1_LimitRangeSpec_To_api_LimitRangeSpec(in *v1.LimitRangeSpec, out *api.LimitRangeSpec, s conversion.Scope) error {
	out.Limits = *(*[]api.LimitRangeItem)(unsafe.Pointer(&in.Limits))
	return nil
}

// Convert_v1_LimitRangeSpec_To_api_LimitRangeSpec is an autogenerated conversion function.
func Convert_v1_LimitRangeSpec_To_api_LimitRangeSpec(in *v1.LimitRangeSpec, out *api.LimitRangeSpec, s conversion.Scope) error {
	return autoConvert_v1_LimitRangeSpec_To_api_LimitRangeSpec(in, out, s)
}

func autoConvert_api_LimitRangeSpec_To_v1_LimitRangeSpec(in *api.LimitRangeSpec, out *v1.LimitRangeSpec, s conversion.Scope) error {
	out.Limits = *(*[]v1.LimitRangeItem)(unsafe.Pointer(&in.Limits))
	return nil
}

// Convert_api_LimitRangeSpec_To_v1_LimitRangeSpec is an autogenerated conversion function.
func Convert_api_LimitRangeSpec_To_v1_LimitRangeSpec(in *api.LimitRangeSpec, out *v1.LimitRangeSpec, s conversion.Scope) error {
	return autoConvert_api_LimitRangeSpec_To_v1_LimitRangeSpec(in, out, s)
}

func autoConvert_v1_List_To_api_List(in *v1.List, out *api.List, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]runtime.Object, len(*in))
		for i := range *in {
			if err := runtime.Convert_runtime_RawExtension_To_runtime_Object(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_List_To_api_List is an autogenerated conversion function.
func Convert_v1_List_To_api_List(in *v1.List, out *api.List, s conversion.Scope) error {
	return autoConvert_v1_List_To_api_List(in, out, s)
}

func autoConvert_api_List_To_v1_List(in *api.List, out *v1.List, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]runtime.RawExtension, len(*in))
		for i := range *in {
			if err := runtime.Convert_runtime_Object_To_runtime_RawExtension(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_api_List_To_v1_List is an autogenerated conversion function.
func Convert_api_List_To_v1_List(in *api.List, out *v1.List, s conversion.Scope) error {
	return autoConvert_api_List_To_v1_List(in, out, s)
}

func autoConvert_v1_ListOptions_To_api_ListOptions(in *v1.ListOptions, out *api.ListOptions, s conversion.Scope) error {
	if err := meta_v1.Convert_string_To_labels_Selector(&in.LabelSelector, &out.LabelSelector, s); err != nil {
		return err
	}
	if err := meta_v1.Convert_string_To_fields_Selector(&in.FieldSelector, &out.FieldSelector, s); err != nil {
		return err
	}
	out.IncludeUninitialized = in.IncludeUninitialized
	out.Watch = in.Watch
	out.ResourceVersion = in.ResourceVersion
	out.TimeoutSeconds = (*int64)(unsafe.Pointer(in.TimeoutSeconds))
	return nil
}

// Convert_v1_ListOptions_To_api_ListOptions is an autogenerated conversion function.
func Convert_v1_ListOptions_To_api_ListOptions(in *v1.ListOptions, out *api.ListOptions, s conversion.Scope) error {
	return autoConvert_v1_ListOptions_To_api_ListOptions(in, out, s)
}

func autoConvert_api_ListOptions_To_v1_ListOptions(in *api.ListOptions, out *v1.ListOptions, s conversion.Scope) error {
	if err := meta_v1.Convert_labels_Selector_To_string(&in.LabelSelector, &out.LabelSelector, s); err != nil {
		return err
	}
	if err := meta_v1.Convert_fields_Selector_To_string(&in.FieldSelector, &out.FieldSelector, s); err != nil {
		return err
	}
	out.IncludeUninitialized = in.IncludeUninitialized
	out.Watch = in.Watch
	out.ResourceVersion = in.ResourceVersion
	out.TimeoutSeconds = (*int64)(unsafe.Pointer(in.TimeoutSeconds))
	return nil
}

// Convert_api_ListOptions_To_v1_ListOptions is an autogenerated conversion function.
func Convert_api_ListOptions_To_v1_ListOptions(in *api.ListOptions, out *v1.ListOptions, s conversion.Scope) error {
	return autoConvert_api_ListOptions_To_v1_ListOptions(in, out, s)
}

func autoConvert_v1_LoadBalancerIngress_To_api_LoadBalancerIngress(in *v1.LoadBalancerIngress, out *api.LoadBalancerIngress, s conversion.Scope) error {
	out.IP = in.IP
	out.Hostname = in.Hostname
	return nil
}

// Convert_v1_LoadBalancerIngress_To_api_LoadBalancerIngress is an autogenerated conversion function.
func Convert_v1_LoadBalancerIngress_To_api_LoadBalancerIngress(in *v1.LoadBalancerIngress, out *api.LoadBalancerIngress, s conversion.Scope) error {
	return autoConvert_v1_LoadBalancerIngress_To_api_LoadBalancerIngress(in, out, s)
}

func autoConvert_api_LoadBalancerIngress_To_v1_LoadBalancerIngress(in *api.LoadBalancerIngress, out *v1.LoadBalancerIngress, s conversion.Scope) error {
	out.IP = in.IP
	out.Hostname = in.Hostname
	return nil
}

// Convert_api_LoadBalancerIngress_To_v1_LoadBalancerIngress is an autogenerated conversion function.
func Convert_api_LoadBalancerIngress_To_v1_LoadBalancerIngress(in *api.LoadBalancerIngress, out *v1.LoadBalancerIngress, s conversion.Scope) error {
	return autoConvert_api_LoadBalancerIngress_To_v1_LoadBalancerIngress(in, out, s)
}

func autoConvert_v1_LoadBalancerStatus_To_api_LoadBalancerStatus(in *v1.LoadBalancerStatus, out *api.LoadBalancerStatus, s conversion.Scope) error {
	out.Ingress = *(*[]api.LoadBalancerIngress)(unsafe.Pointer(&in.Ingress))
	return nil
}

// Convert_v1_LoadBalancerStatus_To_api_LoadBalancerStatus is an autogenerated conversion function.
func Convert_v1_LoadBalancerStatus_To_api_LoadBalancerStatus(in *v1.LoadBalancerStatus, out *api.LoadBalancerStatus, s conversion.Scope) error {
	return autoConvert_v1_LoadBalancerStatus_To_api_LoadBalancerStatus(in, out, s)
}

func autoConvert_api_LoadBalancerStatus_To_v1_LoadBalancerStatus(in *api.LoadBalancerStatus, out *v1.LoadBalancerStatus, s conversion.Scope) error {
	out.Ingress = *(*[]v1.LoadBalancerIngress)(unsafe.Pointer(&in.Ingress))
	return nil
}

// Convert_api_LoadBalancerStatus_To_v1_LoadBalancerStatus is an autogenerated conversion function.
func Convert_api_LoadBalancerStatus_To_v1_LoadBalancerStatus(in *api.LoadBalancerStatus, out *v1.LoadBalancerStatus, s conversion.Scope) error {
	return autoConvert_api_LoadBalancerStatus_To_v1_LoadBalancerStatus(in, out, s)
}

func autoConvert_v1_LocalObjectReference_To_api_LocalObjectReference(in *v1.LocalObjectReference, out *api.LocalObjectReference, s conversion.Scope) error {
	out.Name = in.Name
	return nil
}

// Convert_v1_LocalObjectReference_To_api_LocalObjectReference is an autogenerated conversion function.
func Convert_v1_LocalObjectReference_To_api_LocalObjectReference(in *v1.LocalObjectReference, out *api.LocalObjectReference, s conversion.Scope) error {
	return autoConvert_v1_LocalObjectReference_To_api_LocalObjectReference(in, out, s)
}

func autoConvert_api_LocalObjectReference_To_v1_LocalObjectReference(in *api.LocalObjectReference, out *v1.LocalObjectReference, s conversion.Scope) error {
	out.Name = in.Name
	return nil
}

// Convert_api_LocalObjectReference_To_v1_LocalObjectReference is an autogenerated conversion function.
func Convert_api_LocalObjectReference_To_v1_LocalObjectReference(in *api.LocalObjectReference, out *v1.LocalObjectReference, s conversion.Scope) error {
	return autoConvert_api_LocalObjectReference_To_v1_LocalObjectReference(in, out, s)
}

func autoConvert_v1_LocalVolumeSource_To_api_LocalVolumeSource(in *v1.LocalVolumeSource, out *api.LocalVolumeSource, s conversion.Scope) error {
	out.Path = in.Path
	return nil
}

// Convert_v1_LocalVolumeSource_To_api_LocalVolumeSource is an autogenerated conversion function.
func Convert_v1_LocalVolumeSource_To_api_LocalVolumeSource(in *v1.LocalVolumeSource, out *api.LocalVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_LocalVolumeSource_To_api_LocalVolumeSource(in, out, s)
}

func autoConvert_api_LocalVolumeSource_To_v1_LocalVolumeSource(in *api.LocalVolumeSource, out *v1.LocalVolumeSource, s conversion.Scope) error {
	out.Path = in.Path
	return nil
}

// Convert_api_LocalVolumeSource_To_v1_LocalVolumeSource is an autogenerated conversion function.
func Convert_api_LocalVolumeSource_To_v1_LocalVolumeSource(in *api.LocalVolumeSource, out *v1.LocalVolumeSource, s conversion.Scope) error {
	return autoConvert_api_LocalVolumeSource_To_v1_LocalVolumeSource(in, out, s)
}

func autoConvert_v1_NFSVolumeSource_To_api_NFSVolumeSource(in *v1.NFSVolumeSource, out *api.NFSVolumeSource, s conversion.Scope) error {
	out.Server = in.Server
	out.Path = in.Path
	out.ReadOnly = in.ReadOnly
	return nil
}

// Convert_v1_NFSVolumeSource_To_api_NFSVolumeSource is an autogenerated conversion function.
func Convert_v1_NFSVolumeSource_To_api_NFSVolumeSource(in *v1.NFSVolumeSource, out *api.NFSVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_NFSVolumeSource_To_api_NFSVolumeSource(in, out, s)
}

func autoConvert_api_NFSVolumeSource_To_v1_NFSVolumeSource(in *api.NFSVolumeSource, out *v1.NFSVolumeSource, s conversion.Scope) error {
	out.Server = in.Server
	out.Path = in.Path
	out.ReadOnly = in.ReadOnly
	return nil
}

// Convert_api_NFSVolumeSource_To_v1_NFSVolumeSource is an autogenerated conversion function.
func Convert_api_NFSVolumeSource_To_v1_NFSVolumeSource(in *api.NFSVolumeSource, out *v1.NFSVolumeSource, s conversion.Scope) error {
	return autoConvert_api_NFSVolumeSource_To_v1_NFSVolumeSource(in, out, s)
}

func autoConvert_v1_Namespace_To_api_Namespace(in *v1.Namespace, out *api.Namespace, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_NamespaceSpec_To_api_NamespaceSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_NamespaceStatus_To_api_NamespaceStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_Namespace_To_api_Namespace is an autogenerated conversion function.
func Convert_v1_Namespace_To_api_Namespace(in *v1.Namespace, out *api.Namespace, s conversion.Scope) error {
	return autoConvert_v1_Namespace_To_api_Namespace(in, out, s)
}

func autoConvert_api_Namespace_To_v1_Namespace(in *api.Namespace, out *v1.Namespace, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_api_NamespaceSpec_To_v1_NamespaceSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_api_NamespaceStatus_To_v1_NamespaceStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_api_Namespace_To_v1_Namespace is an autogenerated conversion function.
func Convert_api_Namespace_To_v1_Namespace(in *api.Namespace, out *v1.Namespace, s conversion.Scope) error {
	return autoConvert_api_Namespace_To_v1_Namespace(in, out, s)
}

func autoConvert_v1_NamespaceList_To_api_NamespaceList(in *v1.NamespaceList, out *api.NamespaceList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]api.Namespace)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1_NamespaceList_To_api_NamespaceList is an autogenerated conversion function.
func Convert_v1_NamespaceList_To_api_NamespaceList(in *v1.NamespaceList, out *api.NamespaceList, s conversion.Scope) error {
	return autoConvert_v1_NamespaceList_To_api_NamespaceList(in, out, s)
}

func autoConvert_api_NamespaceList_To_v1_NamespaceList(in *api.NamespaceList, out *v1.NamespaceList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1.Namespace)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_api_NamespaceList_To_v1_NamespaceList is an autogenerated conversion function.
func Convert_api_NamespaceList_To_v1_NamespaceList(in *api.NamespaceList, out *v1.NamespaceList, s conversion.Scope) error {
	return autoConvert_api_NamespaceList_To_v1_NamespaceList(in, out, s)
}

func autoConvert_v1_NamespaceSpec_To_api_NamespaceSpec(in *v1.NamespaceSpec, out *api.NamespaceSpec, s conversion.Scope) error {
	out.Finalizers = *(*[]api.FinalizerName)(unsafe.Pointer(&in.Finalizers))
	return nil
}

// Convert_v1_NamespaceSpec_To_api_NamespaceSpec is an autogenerated conversion function.
func Convert_v1_NamespaceSpec_To_api_NamespaceSpec(in *v1.NamespaceSpec, out *api.NamespaceSpec, s conversion.Scope) error {
	return autoConvert_v1_NamespaceSpec_To_api_NamespaceSpec(in, out, s)
}

func autoConvert_api_NamespaceSpec_To_v1_NamespaceSpec(in *api.NamespaceSpec, out *v1.NamespaceSpec, s conversion.Scope) error {
	out.Finalizers = *(*[]v1.FinalizerName)(unsafe.Pointer(&in.Finalizers))
	return nil
}

// Convert_api_NamespaceSpec_To_v1_NamespaceSpec is an autogenerated conversion function.
func Convert_api_NamespaceSpec_To_v1_NamespaceSpec(in *api.NamespaceSpec, out *v1.NamespaceSpec, s conversion.Scope) error {
	return autoConvert_api_NamespaceSpec_To_v1_NamespaceSpec(in, out, s)
}

func autoConvert_v1_NamespaceStatus_To_api_NamespaceStatus(in *v1.NamespaceStatus, out *api.NamespaceStatus, s conversion.Scope) error {
	out.Phase = api.NamespacePhase(in.Phase)
	return nil
}

// Convert_v1_NamespaceStatus_To_api_NamespaceStatus is an autogenerated conversion function.
func Convert_v1_NamespaceStatus_To_api_NamespaceStatus(in *v1.NamespaceStatus, out *api.NamespaceStatus, s conversion.Scope) error {
	return autoConvert_v1_NamespaceStatus_To_api_NamespaceStatus(in, out, s)
}

func autoConvert_api_NamespaceStatus_To_v1_NamespaceStatus(in *api.NamespaceStatus, out *v1.NamespaceStatus, s conversion.Scope) error {
	out.Phase = v1.NamespacePhase(in.Phase)
	return nil
}

// Convert_api_NamespaceStatus_To_v1_NamespaceStatus is an autogenerated conversion function.
func Convert_api_NamespaceStatus_To_v1_NamespaceStatus(in *api.NamespaceStatus, out *v1.NamespaceStatus, s conversion.Scope) error {
	return autoConvert_api_NamespaceStatus_To_v1_NamespaceStatus(in, out, s)
}

func autoConvert_v1_Node_To_api_Node(in *v1.Node, out *api.Node, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_NodeSpec_To_api_NodeSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_NodeStatus_To_api_NodeStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_Node_To_api_Node is an autogenerated conversion function.
func Convert_v1_Node_To_api_Node(in *v1.Node, out *api.Node, s conversion.Scope) error {
	return autoConvert_v1_Node_To_api_Node(in, out, s)
}

func autoConvert_api_Node_To_v1_Node(in *api.Node, out *v1.Node, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_api_NodeSpec_To_v1_NodeSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_api_NodeStatus_To_v1_NodeStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_api_Node_To_v1_Node is an autogenerated conversion function.
func Convert_api_Node_To_v1_Node(in *api.Node, out *v1.Node, s conversion.Scope) error {
	return autoConvert_api_Node_To_v1_Node(in, out, s)
}

func autoConvert_v1_NodeAddress_To_api_NodeAddress(in *v1.NodeAddress, out *api.NodeAddress, s conversion.Scope) error {
	out.Type = api.NodeAddressType(in.Type)
	out.Address = in.Address
	return nil
}

// Convert_v1_NodeAddress_To_api_NodeAddress is an autogenerated conversion function.
func Convert_v1_NodeAddress_To_api_NodeAddress(in *v1.NodeAddress, out *api.NodeAddress, s conversion.Scope) error {
	return autoConvert_v1_NodeAddress_To_api_NodeAddress(in, out, s)
}

func autoConvert_api_NodeAddress_To_v1_NodeAddress(in *api.NodeAddress, out *v1.NodeAddress, s conversion.Scope) error {
	out.Type = v1.NodeAddressType(in.Type)
	out.Address = in.Address
	return nil
}

// Convert_api_NodeAddress_To_v1_NodeAddress is an autogenerated conversion function.
func Convert_api_NodeAddress_To_v1_NodeAddress(in *api.NodeAddress, out *v1.NodeAddress, s conversion.Scope) error {
	return autoConvert_api_NodeAddress_To_v1_NodeAddress(in, out, s)
}

func autoConvert_v1_NodeAffinity_To_api_NodeAffinity(in *v1.NodeAffinity, out *api.NodeAffinity, s conversion.Scope) error {
	out.RequiredDuringSchedulingIgnoredDuringExecution = (*api.NodeSelector)(unsafe.Pointer(in.RequiredDuringSchedulingIgnoredDuringExecution))
	out.PreferredDuringSchedulingIgnoredDuringExecution = *(*[]api.PreferredSchedulingTerm)(unsafe.Pointer(&in.PreferredDuringSchedulingIgnoredDuringExecution))
	return nil
}

// Convert_v1_NodeAffinity_To_api_NodeAffinity is an autogenerated conversion function.
func Convert_v1_NodeAffinity_To_api_NodeAffinity(in *v1.NodeAffinity, out *api.NodeAffinity, s conversion.Scope) error {
	return autoConvert_v1_NodeAffinity_To_api_NodeAffinity(in, out, s)
}

func autoConvert_api_NodeAffinity_To_v1_NodeAffinity(in *api.NodeAffinity, out *v1.NodeAffinity, s conversion.Scope) error {
	out.RequiredDuringSchedulingIgnoredDuringExecution = (*v1.NodeSelector)(unsafe.Pointer(in.RequiredDuringSchedulingIgnoredDuringExecution))
	out.PreferredDuringSchedulingIgnoredDuringExecution = *(*[]v1.PreferredSchedulingTerm)(unsafe.Pointer(&in.PreferredDuringSchedulingIgnoredDuringExecution))
	return nil
}

// Convert_api_NodeAffinity_To_v1_NodeAffinity is an autogenerated conversion function.
func Convert_api_NodeAffinity_To_v1_NodeAffinity(in *api.NodeAffinity, out *v1.NodeAffinity, s conversion.Scope) error {
	return autoConvert_api_NodeAffinity_To_v1_NodeAffinity(in, out, s)
}

func autoConvert_v1_NodeCondition_To_api_NodeCondition(in *v1.NodeCondition, out *api.NodeCondition, s conversion.Scope) error {
	out.Type = api.NodeConditionType(in.Type)
	out.Status = api.ConditionStatus(in.Status)
	out.LastHeartbeatTime = in.LastHeartbeatTime
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1_NodeCondition_To_api_NodeCondition is an autogenerated conversion function.
func Convert_v1_NodeCondition_To_api_NodeCondition(in *v1.NodeCondition, out *api.NodeCondition, s conversion.Scope) error {
	return autoConvert_v1_NodeCondition_To_api_NodeCondition(in, out, s)
}

func autoConvert_api_NodeCondition_To_v1_NodeCondition(in *api.NodeCondition, out *v1.NodeCondition, s conversion.Scope) error {
	out.Type = v1.NodeConditionType(in.Type)
	out.Status = v1.ConditionStatus(in.Status)
	out.LastHeartbeatTime = in.LastHeartbeatTime
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_api_NodeCondition_To_v1_NodeCondition is an autogenerated conversion function.
func Convert_api_NodeCondition_To_v1_NodeCondition(in *api.NodeCondition, out *v1.NodeCondition, s conversion.Scope) error {
	return autoConvert_api_NodeCondition_To_v1_NodeCondition(in, out, s)
}

func autoConvert_v1_NodeConfigSource_To_api_NodeConfigSource(in *v1.NodeConfigSource, out *api.NodeConfigSource, s conversion.Scope) error {
	out.ConfigMapRef = (*api.ObjectReference)(unsafe.Pointer(in.ConfigMapRef))
	return nil
}

// Convert_v1_NodeConfigSource_To_api_NodeConfigSource is an autogenerated conversion function.
func Convert_v1_NodeConfigSource_To_api_NodeConfigSource(in *v1.NodeConfigSource, out *api.NodeConfigSource, s conversion.Scope) error {
	return autoConvert_v1_NodeConfigSource_To_api_NodeConfigSource(in, out, s)
}

func autoConvert_api_NodeConfigSource_To_v1_NodeConfigSource(in *api.NodeConfigSource, out *v1.NodeConfigSource, s conversion.Scope) error {
	out.ConfigMapRef = (*v1.ObjectReference)(unsafe.Pointer(in.ConfigMapRef))
	return nil
}

// Convert_api_NodeConfigSource_To_v1_NodeConfigSource is an autogenerated conversion function.
func Convert_api_NodeConfigSource_To_v1_NodeConfigSource(in *api.NodeConfigSource, out *v1.NodeConfigSource, s conversion.Scope) error {
	return autoConvert_api_NodeConfigSource_To_v1_NodeConfigSource(in, out, s)
}

func autoConvert_v1_NodeDaemonEndpoints_To_api_NodeDaemonEndpoints(in *v1.NodeDaemonEndpoints, out *api.NodeDaemonEndpoints, s conversion.Scope) error {
	if err := Convert_v1_DaemonEndpoint_To_api_DaemonEndpoint(&in.KubeletEndpoint, &out.KubeletEndpoint, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_NodeDaemonEndpoints_To_api_NodeDaemonEndpoints is an autogenerated conversion function.
func Convert_v1_NodeDaemonEndpoints_To_api_NodeDaemonEndpoints(in *v1.NodeDaemonEndpoints, out *api.NodeDaemonEndpoints, s conversion.Scope) error {
	return autoConvert_v1_NodeDaemonEndpoints_To_api_NodeDaemonEndpoints(in, out, s)
}

func autoConvert_api_NodeDaemonEndpoints_To_v1_NodeDaemonEndpoints(in *api.NodeDaemonEndpoints, out *v1.NodeDaemonEndpoints, s conversion.Scope) error {
	if err := Convert_api_DaemonEndpoint_To_v1_DaemonEndpoint(&in.KubeletEndpoint, &out.KubeletEndpoint, s); err != nil {
		return err
	}
	return nil
}

// Convert_api_NodeDaemonEndpoints_To_v1_NodeDaemonEndpoints is an autogenerated conversion function.
func Convert_api_NodeDaemonEndpoints_To_v1_NodeDaemonEndpoints(in *api.NodeDaemonEndpoints, out *v1.NodeDaemonEndpoints, s conversion.Scope) error {
	return autoConvert_api_NodeDaemonEndpoints_To_v1_NodeDaemonEndpoints(in, out, s)
}

func autoConvert_v1_NodeList_To_api_NodeList(in *v1.NodeList, out *api.NodeList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]api.Node)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1_NodeList_To_api_NodeList is an autogenerated conversion function.
func Convert_v1_NodeList_To_api_NodeList(in *v1.NodeList, out *api.NodeList, s conversion.Scope) error {
	return autoConvert_v1_NodeList_To_api_NodeList(in, out, s)
}

func autoConvert_api_NodeList_To_v1_NodeList(in *api.NodeList, out *v1.NodeList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1.Node)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_api_NodeList_To_v1_NodeList is an autogenerated conversion function.
func Convert_api_NodeList_To_v1_NodeList(in *api.NodeList, out *v1.NodeList, s conversion.Scope) error {
	return autoConvert_api_NodeList_To_v1_NodeList(in, out, s)
}

func autoConvert_v1_NodeProxyOptions_To_api_NodeProxyOptions(in *v1.NodeProxyOptions, out *api.NodeProxyOptions, s conversion.Scope) error {
	out.Path = in.Path
	return nil
}

// Convert_v1_NodeProxyOptions_To_api_NodeProxyOptions is an autogenerated conversion function.
func Convert_v1_NodeProxyOptions_To_api_NodeProxyOptions(in *v1.NodeProxyOptions, out *api.NodeProxyOptions, s conversion.Scope) error {
	return autoConvert_v1_NodeProxyOptions_To_api_NodeProxyOptions(in, out, s)
}

func autoConvert_api_NodeProxyOptions_To_v1_NodeProxyOptions(in *api.NodeProxyOptions, out *v1.NodeProxyOptions, s conversion.Scope) error {
	out.Path = in.Path
	return nil
}

// Convert_api_NodeProxyOptions_To_v1_NodeProxyOptions is an autogenerated conversion function.
func Convert_api_NodeProxyOptions_To_v1_NodeProxyOptions(in *api.NodeProxyOptions, out *v1.NodeProxyOptions, s conversion.Scope) error {
	return autoConvert_api_NodeProxyOptions_To_v1_NodeProxyOptions(in, out, s)
}

func autoConvert_v1_NodeResources_To_api_NodeResources(in *v1.NodeResources, out *api.NodeResources, s conversion.Scope) error {
	out.Capacity = *(*api.ResourceList)(unsafe.Pointer(&in.Capacity))
	return nil
}

// Convert_v1_NodeResources_To_api_NodeResources is an autogenerated conversion function.
func Convert_v1_NodeResources_To_api_NodeResources(in *v1.NodeResources, out *api.NodeResources, s conversion.Scope) error {
	return autoConvert_v1_NodeResources_To_api_NodeResources(in, out, s)
}

func autoConvert_api_NodeResources_To_v1_NodeResources(in *api.NodeResources, out *v1.NodeResources, s conversion.Scope) error {
	out.Capacity = *(*v1.ResourceList)(unsafe.Pointer(&in.Capacity))
	return nil
}

// Convert_api_NodeResources_To_v1_NodeResources is an autogenerated conversion function.
func Convert_api_NodeResources_To_v1_NodeResources(in *api.NodeResources, out *v1.NodeResources, s conversion.Scope) error {
	return autoConvert_api_NodeResources_To_v1_NodeResources(in, out, s)
}

func autoConvert_v1_NodeSelector_To_api_NodeSelector(in *v1.NodeSelector, out *api.NodeSelector, s conversion.Scope) error {
	out.NodeSelectorTerms = *(*[]api.NodeSelectorTerm)(unsafe.Pointer(&in.NodeSelectorTerms))
	return nil
}

// Convert_v1_NodeSelector_To_api_NodeSelector is an autogenerated conversion function.
func Convert_v1_NodeSelector_To_api_NodeSelector(in *v1.NodeSelector, out *api.NodeSelector, s conversion.Scope) error {
	return autoConvert_v1_NodeSelector_To_api_NodeSelector(in, out, s)
}

func autoConvert_api_NodeSelector_To_v1_NodeSelector(in *api.NodeSelector, out *v1.NodeSelector, s conversion.Scope) error {
	out.NodeSelectorTerms = *(*[]v1.NodeSelectorTerm)(unsafe.Pointer(&in.NodeSelectorTerms))
	return nil
}

// Convert_api_NodeSelector_To_v1_NodeSelector is an autogenerated conversion function.
func Convert_api_NodeSelector_To_v1_NodeSelector(in *api.NodeSelector, out *v1.NodeSelector, s conversion.Scope) error {
	return autoConvert_api_NodeSelector_To_v1_NodeSelector(in, out, s)
}

func autoConvert_v1_NodeSelectorRequirement_To_api_NodeSelectorRequirement(in *v1.NodeSelectorRequirement, out *api.NodeSelectorRequirement, s conversion.Scope) error {
	out.Key = in.Key
	out.Operator = api.NodeSelectorOperator(in.Operator)
	out.Values = *(*[]string)(unsafe.Pointer(&in.Values))
	return nil
}

// Convert_v1_NodeSelectorRequirement_To_api_NodeSelectorRequirement is an autogenerated conversion function.
func Convert_v1_NodeSelectorRequirement_To_api_NodeSelectorRequirement(in *v1.NodeSelectorRequirement, out *api.NodeSelectorRequirement, s conversion.Scope) error {
	return autoConvert_v1_NodeSelectorRequirement_To_api_NodeSelectorRequirement(in, out, s)
}

func autoConvert_api_NodeSelectorRequirement_To_v1_NodeSelectorRequirement(in *api.NodeSelectorRequirement, out *v1.NodeSelectorRequirement, s conversion.Scope) error {
	out.Key = in.Key
	out.Operator = v1.NodeSelectorOperator(in.Operator)
	out.Values = *(*[]string)(unsafe.Pointer(&in.Values))
	return nil
}

// Convert_api_NodeSelectorRequirement_To_v1_NodeSelectorRequirement is an autogenerated conversion function.
func Convert_api_NodeSelectorRequirement_To_v1_NodeSelectorRequirement(in *api.NodeSelectorRequirement, out *v1.NodeSelectorRequirement, s conversion.Scope) error {
	return autoConvert_api_NodeSelectorRequirement_To_v1_NodeSelectorRequirement(in, out, s)
}

func autoConvert_v1_NodeSelectorTerm_To_api_NodeSelectorTerm(in *v1.NodeSelectorTerm, out *api.NodeSelectorTerm, s conversion.Scope) error {
	out.MatchExpressions = *(*[]api.NodeSelectorRequirement)(unsafe.Pointer(&in.MatchExpressions))
	return nil
}

// Convert_v1_NodeSelectorTerm_To_api_NodeSelectorTerm is an autogenerated conversion function.
func Convert_v1_NodeSelectorTerm_To_api_NodeSelectorTerm(in *v1.NodeSelectorTerm, out *api.NodeSelectorTerm, s conversion.Scope) error {
	return autoConvert_v1_NodeSelectorTerm_To_api_NodeSelectorTerm(in, out, s)
}

func autoConvert_api_NodeSelectorTerm_To_v1_NodeSelectorTerm(in *api.NodeSelectorTerm, out *v1.NodeSelectorTerm, s conversion.Scope) error {
	out.MatchExpressions = *(*[]v1.NodeSelectorRequirement)(unsafe.Pointer(&in.MatchExpressions))
	return nil
}

// Convert_api_NodeSelectorTerm_To_v1_NodeSelectorTerm is an autogenerated conversion function.
func Convert_api_NodeSelectorTerm_To_v1_NodeSelectorTerm(in *api.NodeSelectorTerm, out *v1.NodeSelectorTerm, s conversion.Scope) error {
	return autoConvert_api_NodeSelectorTerm_To_v1_NodeSelectorTerm(in, out, s)
}

func autoConvert_v1_NodeSpec_To_api_NodeSpec(in *v1.NodeSpec, out *api.NodeSpec, s conversion.Scope) error {
	out.PodCIDR = in.PodCIDR
	out.ExternalID = in.ExternalID
	out.ProviderID = in.ProviderID
	out.Unschedulable = in.Unschedulable
	out.Taints = *(*[]api.Taint)(unsafe.Pointer(&in.Taints))
	out.ConfigSource = (*api.NodeConfigSource)(unsafe.Pointer(in.ConfigSource))
	return nil
}

// Convert_v1_NodeSpec_To_api_NodeSpec is an autogenerated conversion function.
func Convert_v1_NodeSpec_To_api_NodeSpec(in *v1.NodeSpec, out *api.NodeSpec, s conversion.Scope) error {
	return autoConvert_v1_NodeSpec_To_api_NodeSpec(in, out, s)
}

func autoConvert_api_NodeSpec_To_v1_NodeSpec(in *api.NodeSpec, out *v1.NodeSpec, s conversion.Scope) error {
	out.PodCIDR = in.PodCIDR
	out.ExternalID = in.ExternalID
	out.ProviderID = in.ProviderID
	out.Unschedulable = in.Unschedulable
	out.Taints = *(*[]v1.Taint)(unsafe.Pointer(&in.Taints))
	out.ConfigSource = (*v1.NodeConfigSource)(unsafe.Pointer(in.ConfigSource))
	return nil
}

// Convert_api_NodeSpec_To_v1_NodeSpec is an autogenerated conversion function.
func Convert_api_NodeSpec_To_v1_NodeSpec(in *api.NodeSpec, out *v1.NodeSpec, s conversion.Scope) error {
	return autoConvert_api_NodeSpec_To_v1_NodeSpec(in, out, s)
}

func autoConvert_v1_NodeStatus_To_api_NodeStatus(in *v1.NodeStatus, out *api.NodeStatus, s conversion.Scope) error {
	out.Capacity = *(*api.ResourceList)(unsafe.Pointer(&in.Capacity))
	out.Allocatable = *(*api.ResourceList)(unsafe.Pointer(&in.Allocatable))
	out.Phase = api.NodePhase(in.Phase)
	out.Conditions = *(*[]api.NodeCondition)(unsafe.Pointer(&in.Conditions))
	out.Addresses = *(*[]api.NodeAddress)(unsafe.Pointer(&in.Addresses))
	if err := Convert_v1_NodeDaemonEndpoints_To_api_NodeDaemonEndpoints(&in.DaemonEndpoints, &out.DaemonEndpoints, s); err != nil {
		return err
	}
	if err := Convert_v1_NodeSystemInfo_To_api_NodeSystemInfo(&in.NodeInfo, &out.NodeInfo, s); err != nil {
		return err
	}
	out.Images = *(*[]api.ContainerImage)(unsafe.Pointer(&in.Images))
	out.VolumesInUse = *(*[]api.UniqueVolumeName)(unsafe.Pointer(&in.VolumesInUse))
	out.VolumesAttached = *(*[]api.AttachedVolume)(unsafe.Pointer(&in.VolumesAttached))
	return nil
}

// Convert_v1_NodeStatus_To_api_NodeStatus is an autogenerated conversion function.
func Convert_v1_NodeStatus_To_api_NodeStatus(in *v1.NodeStatus, out *api.NodeStatus, s conversion.Scope) error {
	return autoConvert_v1_NodeStatus_To_api_NodeStatus(in, out, s)
}

func autoConvert_api_NodeStatus_To_v1_NodeStatus(in *api.NodeStatus, out *v1.NodeStatus, s conversion.Scope) error {
	out.Capacity = *(*v1.ResourceList)(unsafe.Pointer(&in.Capacity))
	out.Allocatable = *(*v1.ResourceList)(unsafe.Pointer(&in.Allocatable))
	out.Phase = v1.NodePhase(in.Phase)
	out.Conditions = *(*[]v1.NodeCondition)(unsafe.Pointer(&in.Conditions))
	out.Addresses = *(*[]v1.NodeAddress)(unsafe.Pointer(&in.Addresses))
	if err := Convert_api_NodeDaemonEndpoints_To_v1_NodeDaemonEndpoints(&in.DaemonEndpoints, &out.DaemonEndpoints, s); err != nil {
		return err
	}
	if err := Convert_api_NodeSystemInfo_To_v1_NodeSystemInfo(&in.NodeInfo, &out.NodeInfo, s); err != nil {
		return err
	}
	out.Images = *(*[]v1.ContainerImage)(unsafe.Pointer(&in.Images))
	out.VolumesInUse = *(*[]v1.UniqueVolumeName)(unsafe.Pointer(&in.VolumesInUse))
	out.VolumesAttached = *(*[]v1.AttachedVolume)(unsafe.Pointer(&in.VolumesAttached))
	return nil
}

// Convert_api_NodeStatus_To_v1_NodeStatus is an autogenerated conversion function.
func Convert_api_NodeStatus_To_v1_NodeStatus(in *api.NodeStatus, out *v1.NodeStatus, s conversion.Scope) error {
	return autoConvert_api_NodeStatus_To_v1_NodeStatus(in, out, s)
}

func autoConvert_v1_NodeSystemInfo_To_api_NodeSystemInfo(in *v1.NodeSystemInfo, out *api.NodeSystemInfo, s conversion.Scope) error {
	out.MachineID = in.MachineID
	out.SystemUUID = in.SystemUUID
	out.BootID = in.BootID
	out.KernelVersion = in.KernelVersion
	out.OSImage = in.OSImage
	out.ContainerRuntimeVersion = in.ContainerRuntimeVersion
	out.KubeletVersion = in.KubeletVersion
	out.KubeProxyVersion = in.KubeProxyVersion
	out.OperatingSystem = in.OperatingSystem
	out.Architecture = in.Architecture
	return nil
}

// Convert_v1_NodeSystemInfo_To_api_NodeSystemInfo is an autogenerated conversion function.
func Convert_v1_NodeSystemInfo_To_api_NodeSystemInfo(in *v1.NodeSystemInfo, out *api.NodeSystemInfo, s conversion.Scope) error {
	return autoConvert_v1_NodeSystemInfo_To_api_NodeSystemInfo(in, out, s)
}

func autoConvert_api_NodeSystemInfo_To_v1_NodeSystemInfo(in *api.NodeSystemInfo, out *v1.NodeSystemInfo, s conversion.Scope) error {
	out.MachineID = in.MachineID
	out.SystemUUID = in.SystemUUID
	out.BootID = in.BootID
	out.KernelVersion = in.KernelVersion
	out.OSImage = in.OSImage
	out.ContainerRuntimeVersion = in.ContainerRuntimeVersion
	out.KubeletVersion = in.KubeletVersion
	out.KubeProxyVersion = in.KubeProxyVersion
	out.OperatingSystem = in.OperatingSystem
	out.Architecture = in.Architecture
	return nil
}

// Convert_api_NodeSystemInfo_To_v1_NodeSystemInfo is an autogenerated conversion function.
func Convert_api_NodeSystemInfo_To_v1_NodeSystemInfo(in *api.NodeSystemInfo, out *v1.NodeSystemInfo, s conversion.Scope) error {
	return autoConvert_api_NodeSystemInfo_To_v1_NodeSystemInfo(in, out, s)
}

func autoConvert_v1_ObjectFieldSelector_To_api_ObjectFieldSelector(in *v1.ObjectFieldSelector, out *api.ObjectFieldSelector, s conversion.Scope) error {
	out.APIVersion = in.APIVersion
	out.FieldPath = in.FieldPath
	return nil
}

// Convert_v1_ObjectFieldSelector_To_api_ObjectFieldSelector is an autogenerated conversion function.
func Convert_v1_ObjectFieldSelector_To_api_ObjectFieldSelector(in *v1.ObjectFieldSelector, out *api.ObjectFieldSelector, s conversion.Scope) error {
	return autoConvert_v1_ObjectFieldSelector_To_api_ObjectFieldSelector(in, out, s)
}

func autoConvert_api_ObjectFieldSelector_To_v1_ObjectFieldSelector(in *api.ObjectFieldSelector, out *v1.ObjectFieldSelector, s conversion.Scope) error {
	out.APIVersion = in.APIVersion
	out.FieldPath = in.FieldPath
	return nil
}

// Convert_api_ObjectFieldSelector_To_v1_ObjectFieldSelector is an autogenerated conversion function.
func Convert_api_ObjectFieldSelector_To_v1_ObjectFieldSelector(in *api.ObjectFieldSelector, out *v1.ObjectFieldSelector, s conversion.Scope) error {
	return autoConvert_api_ObjectFieldSelector_To_v1_ObjectFieldSelector(in, out, s)
}

func autoConvert_v1_ObjectMeta_To_api_ObjectMeta(in *v1.ObjectMeta, out *api.ObjectMeta, s conversion.Scope) error {
	out.Name = in.Name
	out.GenerateName = in.GenerateName
	out.Namespace = in.Namespace
	out.SelfLink = in.SelfLink
	out.UID = types.UID(in.UID)
	out.ResourceVersion = in.ResourceVersion
	out.Generation = in.Generation
	out.CreationTimestamp = in.CreationTimestamp
	out.DeletionTimestamp = (*meta_v1.Time)(unsafe.Pointer(in.DeletionTimestamp))
	out.DeletionGracePeriodSeconds = (*int64)(unsafe.Pointer(in.DeletionGracePeriodSeconds))
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	out.OwnerReferences = *(*[]meta_v1.OwnerReference)(unsafe.Pointer(&in.OwnerReferences))
	out.Initializers = (*meta_v1.Initializers)(unsafe.Pointer(in.Initializers))
	out.Finalizers = *(*[]string)(unsafe.Pointer(&in.Finalizers))
	out.ClusterName = in.ClusterName
	return nil
}

// Convert_v1_ObjectMeta_To_api_ObjectMeta is an autogenerated conversion function.
func Convert_v1_ObjectMeta_To_api_ObjectMeta(in *v1.ObjectMeta, out *api.ObjectMeta, s conversion.Scope) error {
	return autoConvert_v1_ObjectMeta_To_api_ObjectMeta(in, out, s)
}

func autoConvert_api_ObjectMeta_To_v1_ObjectMeta(in *api.ObjectMeta, out *v1.ObjectMeta, s conversion.Scope) error {
	out.Name = in.Name
	out.GenerateName = in.GenerateName
	out.Namespace = in.Namespace
	out.SelfLink = in.SelfLink
	out.UID = types.UID(in.UID)
	out.ResourceVersion = in.ResourceVersion
	out.Generation = in.Generation
	out.CreationTimestamp = in.CreationTimestamp
	out.DeletionTimestamp = (*meta_v1.Time)(unsafe.Pointer(in.DeletionTimestamp))
	out.DeletionGracePeriodSeconds = (*int64)(unsafe.Pointer(in.DeletionGracePeriodSeconds))
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	out.OwnerReferences = *(*[]meta_v1.OwnerReference)(unsafe.Pointer(&in.OwnerReferences))
	out.Initializers = (*meta_v1.Initializers)(unsafe.Pointer(in.Initializers))
	out.Finalizers = *(*[]string)(unsafe.Pointer(&in.Finalizers))
	out.ClusterName = in.ClusterName
	return nil
}

// Convert_api_ObjectMeta_To_v1_ObjectMeta is an autogenerated conversion function.
func Convert_api_ObjectMeta_To_v1_ObjectMeta(in *api.ObjectMeta, out *v1.ObjectMeta, s conversion.Scope) error {
	return autoConvert_api_ObjectMeta_To_v1_ObjectMeta(in, out, s)
}

func autoConvert_v1_ObjectReference_To_api_ObjectReference(in *v1.ObjectReference, out *api.ObjectReference, s conversion.Scope) error {
	out.Kind = in.Kind
	out.Namespace = in.Namespace
	out.Name = in.Name
	out.UID = types.UID(in.UID)
	out.APIVersion = in.APIVersion
	out.ResourceVersion = in.ResourceVersion
	out.FieldPath = in.FieldPath
	return nil
}

// Convert_v1_ObjectReference_To_api_ObjectReference is an autogenerated conversion function.
func Convert_v1_ObjectReference_To_api_ObjectReference(in *v1.ObjectReference, out *api.ObjectReference, s conversion.Scope) error {
	return autoConvert_v1_ObjectReference_To_api_ObjectReference(in, out, s)
}

func autoConvert_api_ObjectReference_To_v1_ObjectReference(in *api.ObjectReference, out *v1.ObjectReference, s conversion.Scope) error {
	out.Kind = in.Kind
	out.Namespace = in.Namespace
	out.Name = in.Name
	out.UID = types.UID(in.UID)
	out.APIVersion = in.APIVersion
	out.ResourceVersion = in.ResourceVersion
	out.FieldPath = in.FieldPath
	return nil
}

// Convert_api_ObjectReference_To_v1_ObjectReference is an autogenerated conversion function.
func Convert_api_ObjectReference_To_v1_ObjectReference(in *api.ObjectReference, out *v1.ObjectReference, s conversion.Scope) error {
	return autoConvert_api_ObjectReference_To_v1_ObjectReference(in, out, s)
}

func autoConvert_v1_PersistentVolume_To_api_PersistentVolume(in *v1.PersistentVolume, out *api.PersistentVolume, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_PersistentVolumeSpec_To_api_PersistentVolumeSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_PersistentVolumeStatus_To_api_PersistentVolumeStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_PersistentVolume_To_api_PersistentVolume is an autogenerated conversion function.
func Convert_v1_PersistentVolume_To_api_PersistentVolume(in *v1.PersistentVolume, out *api.PersistentVolume, s conversion.Scope) error {
	return autoConvert_v1_PersistentVolume_To_api_PersistentVolume(in, out, s)
}

func autoConvert_api_PersistentVolume_To_v1_PersistentVolume(in *api.PersistentVolume, out *v1.PersistentVolume, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_api_PersistentVolumeSpec_To_v1_PersistentVolumeSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_api_PersistentVolumeStatus_To_v1_PersistentVolumeStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_api_PersistentVolume_To_v1_PersistentVolume is an autogenerated conversion function.
func Convert_api_PersistentVolume_To_v1_PersistentVolume(in *api.PersistentVolume, out *v1.PersistentVolume, s conversion.Scope) error {
	return autoConvert_api_PersistentVolume_To_v1_PersistentVolume(in, out, s)
}

func autoConvert_v1_PersistentVolumeClaim_To_api_PersistentVolumeClaim(in *v1.PersistentVolumeClaim, out *api.PersistentVolumeClaim, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_PersistentVolumeClaimSpec_To_api_PersistentVolumeClaimSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_PersistentVolumeClaimStatus_To_api_PersistentVolumeClaimStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_PersistentVolumeClaim_To_api_PersistentVolumeClaim is an autogenerated conversion function.
func Convert_v1_PersistentVolumeClaim_To_api_PersistentVolumeClaim(in *v1.PersistentVolumeClaim, out *api.PersistentVolumeClaim, s conversion.Scope) error {
	return autoConvert_v1_PersistentVolumeClaim_To_api_PersistentVolumeClaim(in, out, s)
}

func autoConvert_api_PersistentVolumeClaim_To_v1_PersistentVolumeClaim(in *api.PersistentVolumeClaim, out *v1.PersistentVolumeClaim, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_api_PersistentVolumeClaimSpec_To_v1_PersistentVolumeClaimSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_api_PersistentVolumeClaimStatus_To_v1_PersistentVolumeClaimStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_api_PersistentVolumeClaim_To_v1_PersistentVolumeClaim is an autogenerated conversion function.
func Convert_api_PersistentVolumeClaim_To_v1_PersistentVolumeClaim(in *api.PersistentVolumeClaim, out *v1.PersistentVolumeClaim, s conversion.Scope) error {
	return autoConvert_api_PersistentVolumeClaim_To_v1_PersistentVolumeClaim(in, out, s)
}

func autoConvert_v1_PersistentVolumeClaimCondition_To_api_PersistentVolumeClaimCondition(in *v1.PersistentVolumeClaimCondition, out *api.PersistentVolumeClaimCondition, s conversion.Scope) error {
	out.Type = api.PersistentVolumeClaimConditionType(in.Type)
	out.Status = api.ConditionStatus(in.Status)
	out.LastProbeTime = in.LastProbeTime
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1_PersistentVolumeClaimCondition_To_api_PersistentVolumeClaimCondition is an autogenerated conversion function.
func Convert_v1_PersistentVolumeClaimCondition_To_api_PersistentVolumeClaimCondition(in *v1.PersistentVolumeClaimCondition, out *api.PersistentVolumeClaimCondition, s conversion.Scope) error {
	return autoConvert_v1_PersistentVolumeClaimCondition_To_api_PersistentVolumeClaimCondition(in, out, s)
}

func autoConvert_api_PersistentVolumeClaimCondition_To_v1_PersistentVolumeClaimCondition(in *api.PersistentVolumeClaimCondition, out *v1.PersistentVolumeClaimCondition, s conversion.Scope) error {
	out.Type = v1.PersistentVolumeClaimConditionType(in.Type)
	out.Status = v1.ConditionStatus(in.Status)
	out.LastProbeTime = in.LastProbeTime
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_api_PersistentVolumeClaimCondition_To_v1_PersistentVolumeClaimCondition is an autogenerated conversion function.
func Convert_api_PersistentVolumeClaimCondition_To_v1_PersistentVolumeClaimCondition(in *api.PersistentVolumeClaimCondition, out *v1.PersistentVolumeClaimCondition, s conversion.Scope) error {
	return autoConvert_api_PersistentVolumeClaimCondition_To_v1_PersistentVolumeClaimCondition(in, out, s)
}

func autoConvert_v1_PersistentVolumeClaimList_To_api_PersistentVolumeClaimList(in *v1.PersistentVolumeClaimList, out *api.PersistentVolumeClaimList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]api.PersistentVolumeClaim)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1_PersistentVolumeClaimList_To_api_PersistentVolumeClaimList is an autogenerated conversion function.
func Convert_v1_PersistentVolumeClaimList_To_api_PersistentVolumeClaimList(in *v1.PersistentVolumeClaimList, out *api.PersistentVolumeClaimList, s conversion.Scope) error {
	return autoConvert_v1_PersistentVolumeClaimList_To_api_PersistentVolumeClaimList(in, out, s)
}

func autoConvert_api_PersistentVolumeClaimList_To_v1_PersistentVolumeClaimList(in *api.PersistentVolumeClaimList, out *v1.PersistentVolumeClaimList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1.PersistentVolumeClaim)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_api_PersistentVolumeClaimList_To_v1_PersistentVolumeClaimList is an autogenerated conversion function.
func Convert_api_PersistentVolumeClaimList_To_v1_PersistentVolumeClaimList(in *api.PersistentVolumeClaimList, out *v1.PersistentVolumeClaimList, s conversion.Scope) error {
	return autoConvert_api_PersistentVolumeClaimList_To_v1_PersistentVolumeClaimList(in, out, s)
}

func autoConvert_v1_PersistentVolumeClaimSpec_To_api_PersistentVolumeClaimSpec(in *v1.PersistentVolumeClaimSpec, out *api.PersistentVolumeClaimSpec, s conversion.Scope) error {
	out.AccessModes = *(*[]api.PersistentVolumeAccessMode)(unsafe.Pointer(&in.AccessModes))
	out.Selector = (*meta_v1.LabelSelector)(unsafe.Pointer(in.Selector))
	if err := Convert_v1_ResourceRequirements_To_api_ResourceRequirements(&in.Resources, &out.Resources, s); err != nil {
		return err
	}
	out.VolumeName = in.VolumeName
	out.StorageClassName = (*string)(unsafe.Pointer(in.StorageClassName))
	return nil
}

// Convert_v1_PersistentVolumeClaimSpec_To_api_PersistentVolumeClaimSpec is an autogenerated conversion function.
func Convert_v1_PersistentVolumeClaimSpec_To_api_PersistentVolumeClaimSpec(in *v1.PersistentVolumeClaimSpec, out *api.PersistentVolumeClaimSpec, s conversion.Scope) error {
	return autoConvert_v1_PersistentVolumeClaimSpec_To_api_PersistentVolumeClaimSpec(in, out, s)
}

func autoConvert_api_PersistentVolumeClaimSpec_To_v1_PersistentVolumeClaimSpec(in *api.PersistentVolumeClaimSpec, out *v1.PersistentVolumeClaimSpec, s conversion.Scope) error {
	out.AccessModes = *(*[]v1.PersistentVolumeAccessMode)(unsafe.Pointer(&in.AccessModes))
	out.Selector = (*meta_v1.LabelSelector)(unsafe.Pointer(in.Selector))
	if err := Convert_api_ResourceRequirements_To_v1_ResourceRequirements(&in.Resources, &out.Resources, s); err != nil {
		return err
	}
	out.VolumeName = in.VolumeName
	out.StorageClassName = (*string)(unsafe.Pointer(in.StorageClassName))
	return nil
}

// Convert_api_PersistentVolumeClaimSpec_To_v1_PersistentVolumeClaimSpec is an autogenerated conversion function.
func Convert_api_PersistentVolumeClaimSpec_To_v1_PersistentVolumeClaimSpec(in *api.PersistentVolumeClaimSpec, out *v1.PersistentVolumeClaimSpec, s conversion.Scope) error {
	return autoConvert_api_PersistentVolumeClaimSpec_To_v1_PersistentVolumeClaimSpec(in, out, s)
}

func autoConvert_v1_PersistentVolumeClaimStatus_To_api_PersistentVolumeClaimStatus(in *v1.PersistentVolumeClaimStatus, out *api.PersistentVolumeClaimStatus, s conversion.Scope) error {
	out.Phase = api.PersistentVolumeClaimPhase(in.Phase)
	out.AccessModes = *(*[]api.PersistentVolumeAccessMode)(unsafe.Pointer(&in.AccessModes))
	out.Capacity = *(*api.ResourceList)(unsafe.Pointer(&in.Capacity))
	out.Conditions = *(*[]api.PersistentVolumeClaimCondition)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1_PersistentVolumeClaimStatus_To_api_PersistentVolumeClaimStatus is an autogenerated conversion function.
func Convert_v1_PersistentVolumeClaimStatus_To_api_PersistentVolumeClaimStatus(in *v1.PersistentVolumeClaimStatus, out *api.PersistentVolumeClaimStatus, s conversion.Scope) error {
	return autoConvert_v1_PersistentVolumeClaimStatus_To_api_PersistentVolumeClaimStatus(in, out, s)
}

func autoConvert_api_PersistentVolumeClaimStatus_To_v1_PersistentVolumeClaimStatus(in *api.PersistentVolumeClaimStatus, out *v1.PersistentVolumeClaimStatus, s conversion.Scope) error {
	out.Phase = v1.PersistentVolumeClaimPhase(in.Phase)
	out.AccessModes = *(*[]v1.PersistentVolumeAccessMode)(unsafe.Pointer(&in.AccessModes))
	out.Capacity = *(*v1.ResourceList)(unsafe.Pointer(&in.Capacity))
	out.Conditions = *(*[]v1.PersistentVolumeClaimCondition)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_api_PersistentVolumeClaimStatus_To_v1_PersistentVolumeClaimStatus is an autogenerated conversion function.
func Convert_api_PersistentVolumeClaimStatus_To_v1_PersistentVolumeClaimStatus(in *api.PersistentVolumeClaimStatus, out *v1.PersistentVolumeClaimStatus, s conversion.Scope) error {
	return autoConvert_api_PersistentVolumeClaimStatus_To_v1_PersistentVolumeClaimStatus(in, out, s)
}

func autoConvert_v1_PersistentVolumeClaimVolumeSource_To_api_PersistentVolumeClaimVolumeSource(in *v1.PersistentVolumeClaimVolumeSource, out *api.PersistentVolumeClaimVolumeSource, s conversion.Scope) error {
	out.ClaimName = in.ClaimName
	out.ReadOnly = in.ReadOnly
	return nil
}

// Convert_v1_PersistentVolumeClaimVolumeSource_To_api_PersistentVolumeClaimVolumeSource is an autogenerated conversion function.
func Convert_v1_PersistentVolumeClaimVolumeSource_To_api_PersistentVolumeClaimVolumeSource(in *v1.PersistentVolumeClaimVolumeSource, out *api.PersistentVolumeClaimVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_PersistentVolumeClaimVolumeSource_To_api_PersistentVolumeClaimVolumeSource(in, out, s)
}

func autoConvert_api_PersistentVolumeClaimVolumeSource_To_v1_PersistentVolumeClaimVolumeSource(in *api.PersistentVolumeClaimVolumeSource, out *v1.PersistentVolumeClaimVolumeSource, s conversion.Scope) error {
	out.ClaimName = in.ClaimName
	out.ReadOnly = in.ReadOnly
	return nil
}

// Convert_api_PersistentVolumeClaimVolumeSource_To_v1_PersistentVolumeClaimVolumeSource is an autogenerated conversion function.
func Convert_api_PersistentVolumeClaimVolumeSource_To_v1_PersistentVolumeClaimVolumeSource(in *api.PersistentVolumeClaimVolumeSource, out *v1.PersistentVolumeClaimVolumeSource, s conversion.Scope) error {
	return autoConvert_api_PersistentVolumeClaimVolumeSource_To_v1_PersistentVolumeClaimVolumeSource(in, out, s)
}

func autoConvert_v1_PersistentVolumeList_To_api_PersistentVolumeList(in *v1.PersistentVolumeList, out *api.PersistentVolumeList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]api.PersistentVolume, len(*in))
		for i := range *in {
			if err := Convert_v1_PersistentVolume_To_api_PersistentVolume(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_PersistentVolumeList_To_api_PersistentVolumeList is an autogenerated conversion function.
func Convert_v1_PersistentVolumeList_To_api_PersistentVolumeList(in *v1.PersistentVolumeList, out *api.PersistentVolumeList, s conversion.Scope) error {
	return autoConvert_v1_PersistentVolumeList_To_api_PersistentVolumeList(in, out, s)
}

func autoConvert_api_PersistentVolumeList_To_v1_PersistentVolumeList(in *api.PersistentVolumeList, out *v1.PersistentVolumeList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1.PersistentVolume, len(*in))
		for i := range *in {
			if err := Convert_api_PersistentVolume_To_v1_PersistentVolume(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_api_PersistentVolumeList_To_v1_PersistentVolumeList is an autogenerated conversion function.
func Convert_api_PersistentVolumeList_To_v1_PersistentVolumeList(in *api.PersistentVolumeList, out *v1.PersistentVolumeList, s conversion.Scope) error {
	return autoConvert_api_PersistentVolumeList_To_v1_PersistentVolumeList(in, out, s)
}

func autoConvert_v1_PersistentVolumeSource_To_api_PersistentVolumeSource(in *v1.PersistentVolumeSource, out *api.PersistentVolumeSource, s conversion.Scope) error {
	out.GCEPersistentDisk = (*api.GCEPersistentDiskVolumeSource)(unsafe.Pointer(in.GCEPersistentDisk))
	out.AWSElasticBlockStore = (*api.AWSElasticBlockStoreVolumeSource)(unsafe.Pointer(in.AWSElasticBlockStore))
	out.HostPath = (*api.HostPathVolumeSource)(unsafe.Pointer(in.HostPath))
	out.Glusterfs = (*api.GlusterfsVolumeSource)(unsafe.Pointer(in.Glusterfs))
	out.NFS = (*api.NFSVolumeSource)(unsafe.Pointer(in.NFS))
	out.RBD = (*api.RBDVolumeSource)(unsafe.Pointer(in.RBD))
	out.ISCSI = (*api.ISCSIVolumeSource)(unsafe.Pointer(in.ISCSI))
	out.Cinder = (*api.CinderVolumeSource)(unsafe.Pointer(in.Cinder))
	out.CephFS = (*api.CephFSPersistentVolumeSource)(unsafe.Pointer(in.CephFS))
	out.FC = (*api.FCVolumeSource)(unsafe.Pointer(in.FC))
	out.Flocker = (*api.FlockerVolumeSource)(unsafe.Pointer(in.Flocker))
	out.FlexVolume = (*api.FlexVolumeSource)(unsafe.Pointer(in.FlexVolume))
	out.AzureFile = (*api.AzureFilePersistentVolumeSource)(unsafe.Pointer(in.AzureFile))
	out.VsphereVolume = (*api.VsphereVirtualDiskVolumeSource)(unsafe.Pointer(in.VsphereVolume))
	out.Quobyte = (*api.QuobyteVolumeSource)(unsafe.Pointer(in.Quobyte))
	out.AzureDisk = (*api.AzureDiskVolumeSource)(unsafe.Pointer(in.AzureDisk))
	out.PhotonPersistentDisk = (*api.PhotonPersistentDiskVolumeSource)(unsafe.Pointer(in.PhotonPersistentDisk))
	out.PortworxVolume = (*api.PortworxVolumeSource)(unsafe.Pointer(in.PortworxVolume))
	out.ScaleIO = (*api.ScaleIOVolumeSource)(unsafe.Pointer(in.ScaleIO))
	out.Local = (*api.LocalVolumeSource)(unsafe.Pointer(in.Local))
	out.StorageOS = (*api.StorageOSPersistentVolumeSource)(unsafe.Pointer(in.StorageOS))
	return nil
}

// Convert_v1_PersistentVolumeSource_To_api_PersistentVolumeSource is an autogenerated conversion function.
func Convert_v1_PersistentVolumeSource_To_api_PersistentVolumeSource(in *v1.PersistentVolumeSource, out *api.PersistentVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_PersistentVolumeSource_To_api_PersistentVolumeSource(in, out, s)
}

func autoConvert_api_PersistentVolumeSource_To_v1_PersistentVolumeSource(in *api.PersistentVolumeSource, out *v1.PersistentVolumeSource, s conversion.Scope) error {
	out.GCEPersistentDisk = (*v1.GCEPersistentDiskVolumeSource)(unsafe.Pointer(in.GCEPersistentDisk))
	out.AWSElasticBlockStore = (*v1.AWSElasticBlockStoreVolumeSource)(unsafe.Pointer(in.AWSElasticBlockStore))
	out.HostPath = (*v1.HostPathVolumeSource)(unsafe.Pointer(in.HostPath))
	out.Glusterfs = (*v1.GlusterfsVolumeSource)(unsafe.Pointer(in.Glusterfs))
	out.NFS = (*v1.NFSVolumeSource)(unsafe.Pointer(in.NFS))
	out.RBD = (*v1.RBDVolumeSource)(unsafe.Pointer(in.RBD))
	out.Quobyte = (*v1.QuobyteVolumeSource)(unsafe.Pointer(in.Quobyte))
	out.ISCSI = (*v1.ISCSIVolumeSource)(unsafe.Pointer(in.ISCSI))
	out.FlexVolume = (*v1.FlexVolumeSource)(unsafe.Pointer(in.FlexVolume))
	out.Cinder = (*v1.CinderVolumeSource)(unsafe.Pointer(in.Cinder))
	out.CephFS = (*v1.CephFSPersistentVolumeSource)(unsafe.Pointer(in.CephFS))
	out.FC = (*v1.FCVolumeSource)(unsafe.Pointer(in.FC))
	out.Flocker = (*v1.FlockerVolumeSource)(unsafe.Pointer(in.Flocker))
	out.AzureFile = (*v1.AzureFilePersistentVolumeSource)(unsafe.Pointer(in.AzureFile))
	out.VsphereVolume = (*v1.VsphereVirtualDiskVolumeSource)(unsafe.Pointer(in.VsphereVolume))
	out.AzureDisk = (*v1.AzureDiskVolumeSource)(unsafe.Pointer(in.AzureDisk))
	out.PhotonPersistentDisk = (*v1.PhotonPersistentDiskVolumeSource)(unsafe.Pointer(in.PhotonPersistentDisk))
	out.PortworxVolume = (*v1.PortworxVolumeSource)(unsafe.Pointer(in.PortworxVolume))
	out.ScaleIO = (*v1.ScaleIOVolumeSource)(unsafe.Pointer(in.ScaleIO))
	out.Local = (*v1.LocalVolumeSource)(unsafe.Pointer(in.Local))
	out.StorageOS = (*v1.StorageOSPersistentVolumeSource)(unsafe.Pointer(in.StorageOS))
	return nil
}

// Convert_api_PersistentVolumeSource_To_v1_PersistentVolumeSource is an autogenerated conversion function.
func Convert_api_PersistentVolumeSource_To_v1_PersistentVolumeSource(in *api.PersistentVolumeSource, out *v1.PersistentVolumeSource, s conversion.Scope) error {
	return autoConvert_api_PersistentVolumeSource_To_v1_PersistentVolumeSource(in, out, s)
}

func autoConvert_v1_PersistentVolumeSpec_To_api_PersistentVolumeSpec(in *v1.PersistentVolumeSpec, out *api.PersistentVolumeSpec, s conversion.Scope) error {
	out.Capacity = *(*api.ResourceList)(unsafe.Pointer(&in.Capacity))
	if err := Convert_v1_PersistentVolumeSource_To_api_PersistentVolumeSource(&in.PersistentVolumeSource, &out.PersistentVolumeSource, s); err != nil {
		return err
	}
	out.AccessModes = *(*[]api.PersistentVolumeAccessMode)(unsafe.Pointer(&in.AccessModes))
	out.ClaimRef = (*api.ObjectReference)(unsafe.Pointer(in.ClaimRef))
	out.PersistentVolumeReclaimPolicy = api.PersistentVolumeReclaimPolicy(in.PersistentVolumeReclaimPolicy)
	out.StorageClassName = in.StorageClassName
	out.MountOptions = *(*[]string)(unsafe.Pointer(&in.MountOptions))
	return nil
}

// Convert_v1_PersistentVolumeSpec_To_api_PersistentVolumeSpec is an autogenerated conversion function.
func Convert_v1_PersistentVolumeSpec_To_api_PersistentVolumeSpec(in *v1.PersistentVolumeSpec, out *api.PersistentVolumeSpec, s conversion.Scope) error {
	return autoConvert_v1_PersistentVolumeSpec_To_api_PersistentVolumeSpec(in, out, s)
}

func autoConvert_api_PersistentVolumeSpec_To_v1_PersistentVolumeSpec(in *api.PersistentVolumeSpec, out *v1.PersistentVolumeSpec, s conversion.Scope) error {
	out.Capacity = *(*v1.ResourceList)(unsafe.Pointer(&in.Capacity))
	if err := Convert_api_PersistentVolumeSource_To_v1_PersistentVolumeSource(&in.PersistentVolumeSource, &out.PersistentVolumeSource, s); err != nil {
		return err
	}
	out.AccessModes = *(*[]v1.PersistentVolumeAccessMode)(unsafe.Pointer(&in.AccessModes))
	out.ClaimRef = (*v1.ObjectReference)(unsafe.Pointer(in.ClaimRef))
	out.PersistentVolumeReclaimPolicy = v1.PersistentVolumeReclaimPolicy(in.PersistentVolumeReclaimPolicy)
	out.StorageClassName = in.StorageClassName
	out.MountOptions = *(*[]string)(unsafe.Pointer(&in.MountOptions))
	return nil
}

// Convert_api_PersistentVolumeSpec_To_v1_PersistentVolumeSpec is an autogenerated conversion function.
func Convert_api_PersistentVolumeSpec_To_v1_PersistentVolumeSpec(in *api.PersistentVolumeSpec, out *v1.PersistentVolumeSpec, s conversion.Scope) error {
	return autoConvert_api_PersistentVolumeSpec_To_v1_PersistentVolumeSpec(in, out, s)
}

func autoConvert_v1_PersistentVolumeStatus_To_api_PersistentVolumeStatus(in *v1.PersistentVolumeStatus, out *api.PersistentVolumeStatus, s conversion.Scope) error {
	out.Phase = api.PersistentVolumePhase(in.Phase)
	out.Message = in.Message
	out.Reason = in.Reason
	return nil
}

// Convert_v1_PersistentVolumeStatus_To_api_PersistentVolumeStatus is an autogenerated conversion function.
func Convert_v1_PersistentVolumeStatus_To_api_PersistentVolumeStatus(in *v1.PersistentVolumeStatus, out *api.PersistentVolumeStatus, s conversion.Scope) error {
	return autoConvert_v1_PersistentVolumeStatus_To_api_PersistentVolumeStatus(in, out, s)
}

func autoConvert_api_PersistentVolumeStatus_To_v1_PersistentVolumeStatus(in *api.PersistentVolumeStatus, out *v1.PersistentVolumeStatus, s conversion.Scope) error {
	out.Phase = v1.PersistentVolumePhase(in.Phase)
	out.Message = in.Message
	out.Reason = in.Reason
	return nil
}

// Convert_api_PersistentVolumeStatus_To_v1_PersistentVolumeStatus is an autogenerated conversion function.
func Convert_api_PersistentVolumeStatus_To_v1_PersistentVolumeStatus(in *api.PersistentVolumeStatus, out *v1.PersistentVolumeStatus, s conversion.Scope) error {
	return autoConvert_api_PersistentVolumeStatus_To_v1_PersistentVolumeStatus(in, out, s)
}

func autoConvert_v1_PhotonPersistentDiskVolumeSource_To_api_PhotonPersistentDiskVolumeSource(in *v1.PhotonPersistentDiskVolumeSource, out *api.PhotonPersistentDiskVolumeSource, s conversion.Scope) error {
	out.PdID = in.PdID
	out.FSType = in.FSType
	return nil
}

// Convert_v1_PhotonPersistentDiskVolumeSource_To_api_PhotonPersistentDiskVolumeSource is an autogenerated conversion function.
func Convert_v1_PhotonPersistentDiskVolumeSource_To_api_PhotonPersistentDiskVolumeSource(in *v1.PhotonPersistentDiskVolumeSource, out *api.PhotonPersistentDiskVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_PhotonPersistentDiskVolumeSource_To_api_PhotonPersistentDiskVolumeSource(in, out, s)
}

func autoConvert_api_PhotonPersistentDiskVolumeSource_To_v1_PhotonPersistentDiskVolumeSource(in *api.PhotonPersistentDiskVolumeSource, out *v1.PhotonPersistentDiskVolumeSource, s conversion.Scope) error {
	out.PdID = in.PdID
	out.FSType = in.FSType
	return nil
}

// Convert_api_PhotonPersistentDiskVolumeSource_To_v1_PhotonPersistentDiskVolumeSource is an autogenerated conversion function.
func Convert_api_PhotonPersistentDiskVolumeSource_To_v1_PhotonPersistentDiskVolumeSource(in *api.PhotonPersistentDiskVolumeSource, out *v1.PhotonPersistentDiskVolumeSource, s conversion.Scope) error {
	return autoConvert_api_PhotonPersistentDiskVolumeSource_To_v1_PhotonPersistentDiskVolumeSource(in, out, s)
}

func autoConvert_v1_Pod_To_api_Pod(in *v1.Pod, out *api.Pod, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_PodSpec_To_api_PodSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_PodStatus_To_api_PodStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_Pod_To_api_Pod is an autogenerated conversion function.
func Convert_v1_Pod_To_api_Pod(in *v1.Pod, out *api.Pod, s conversion.Scope) error {
	return autoConvert_v1_Pod_To_api_Pod(in, out, s)
}

func autoConvert_api_Pod_To_v1_Pod(in *api.Pod, out *v1.Pod, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_api_PodSpec_To_v1_PodSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_api_PodStatus_To_v1_PodStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1_PodAffinity_To_api_PodAffinity(in *v1.PodAffinity, out *api.PodAffinity, s conversion.Scope) error {
	out.RequiredDuringSchedulingIgnoredDuringExecution = *(*[]api.PodAffinityTerm)(unsafe.Pointer(&in.RequiredDuringSchedulingIgnoredDuringExecution))
	out.PreferredDuringSchedulingIgnoredDuringExecution = *(*[]api.WeightedPodAffinityTerm)(unsafe.Pointer(&in.PreferredDuringSchedulingIgnoredDuringExecution))
	return nil
}

// Convert_v1_PodAffinity_To_api_PodAffinity is an autogenerated conversion function.
func Convert_v1_PodAffinity_To_api_PodAffinity(in *v1.PodAffinity, out *api.PodAffinity, s conversion.Scope) error {
	return autoConvert_v1_PodAffinity_To_api_PodAffinity(in, out, s)
}

func autoConvert_api_PodAffinity_To_v1_PodAffinity(in *api.PodAffinity, out *v1.PodAffinity, s conversion.Scope) error {
	out.RequiredDuringSchedulingIgnoredDuringExecution = *(*[]v1.PodAffinityTerm)(unsafe.Pointer(&in.RequiredDuringSchedulingIgnoredDuringExecution))
	out.PreferredDuringSchedulingIgnoredDuringExecution = *(*[]v1.WeightedPodAffinityTerm)(unsafe.Pointer(&in.PreferredDuringSchedulingIgnoredDuringExecution))
	return nil
}

// Convert_api_PodAffinity_To_v1_PodAffinity is an autogenerated conversion function.
func Convert_api_PodAffinity_To_v1_PodAffinity(in *api.PodAffinity, out *v1.PodAffinity, s conversion.Scope) error {
	return autoConvert_api_PodAffinity_To_v1_PodAffinity(in, out, s)
}

func autoConvert_v1_PodAffinityTerm_To_api_PodAffinityTerm(in *v1.PodAffinityTerm, out *api.PodAffinityTerm, s conversion.Scope) error {
	out.LabelSelector = (*meta_v1.LabelSelector)(unsafe.Pointer(in.LabelSelector))
	out.Namespaces = *(*[]string)(unsafe.Pointer(&in.Namespaces))
	out.TopologyKey = in.TopologyKey
	return nil
}

// Convert_v1_PodAffinityTerm_To_api_PodAffinityTerm is an autogenerated conversion function.
func Convert_v1_PodAffinityTerm_To_api_PodAffinityTerm(in *v1.PodAffinityTerm, out *api.PodAffinityTerm, s conversion.Scope) error {
	return autoConvert_v1_PodAffinityTerm_To_api_PodAffinityTerm(in, out, s)
}

func autoConvert_api_PodAffinityTerm_To_v1_PodAffinityTerm(in *api.PodAffinityTerm, out *v1.PodAffinityTerm, s conversion.Scope) error {
	out.LabelSelector = (*meta_v1.LabelSelector)(unsafe.Pointer(in.LabelSelector))
	out.Namespaces = *(*[]string)(unsafe.Pointer(&in.Namespaces))
	out.TopologyKey = in.TopologyKey
	return nil
}

// Convert_api_PodAffinityTerm_To_v1_PodAffinityTerm is an autogenerated conversion function.
func Convert_api_PodAffinityTerm_To_v1_PodAffinityTerm(in *api.PodAffinityTerm, out *v1.PodAffinityTerm, s conversion.Scope) error {
	return autoConvert_api_PodAffinityTerm_To_v1_PodAffinityTerm(in, out, s)
}

func autoConvert_v1_PodAntiAffinity_To_api_PodAntiAffinity(in *v1.PodAntiAffinity, out *api.PodAntiAffinity, s conversion.Scope) error {
	out.RequiredDuringSchedulingIgnoredDuringExecution = *(*[]api.PodAffinityTerm)(unsafe.Pointer(&in.RequiredDuringSchedulingIgnoredDuringExecution))
	out.PreferredDuringSchedulingIgnoredDuringExecution = *(*[]api.WeightedPodAffinityTerm)(unsafe.Pointer(&in.PreferredDuringSchedulingIgnoredDuringExecution))
	return nil
}

// Convert_v1_PodAntiAffinity_To_api_PodAntiAffinity is an autogenerated conversion function.
func Convert_v1_PodAntiAffinity_To_api_PodAntiAffinity(in *v1.PodAntiAffinity, out *api.PodAntiAffinity, s conversion.Scope) error {
	return autoConvert_v1_PodAntiAffinity_To_api_PodAntiAffinity(in, out, s)
}

func autoConvert_api_PodAntiAffinity_To_v1_PodAntiAffinity(in *api.PodAntiAffinity, out *v1.PodAntiAffinity, s conversion.Scope) error {
	out.RequiredDuringSchedulingIgnoredDuringExecution = *(*[]v1.PodAffinityTerm)(unsafe.Pointer(&in.RequiredDuringSchedulingIgnoredDuringExecution))
	out.PreferredDuringSchedulingIgnoredDuringExecution = *(*[]v1.WeightedPodAffinityTerm)(unsafe.Pointer(&in.PreferredDuringSchedulingIgnoredDuringExecution))
	return nil
}

// Convert_api_PodAntiAffinity_To_v1_PodAntiAffinity is an autogenerated conversion function.
func Convert_api_PodAntiAffinity_To_v1_PodAntiAffinity(in *api.PodAntiAffinity, out *v1.PodAntiAffinity, s conversion.Scope) error {
	return autoConvert_api_PodAntiAffinity_To_v1_PodAntiAffinity(in, out, s)
}

func autoConvert_v1_PodAttachOptions_To_api_PodAttachOptions(in *v1.PodAttachOptions, out *api.PodAttachOptions, s conversion.Scope) error {
	out.Stdin = in.Stdin
	out.Stdout = in.Stdout
	out.Stderr = in.Stderr
	out.TTY = in.TTY
	out.Container = in.Container
	return nil
}

// Convert_v1_PodAttachOptions_To_api_PodAttachOptions is an autogenerated conversion function.
func Convert_v1_PodAttachOptions_To_api_PodAttachOptions(in *v1.PodAttachOptions, out *api.PodAttachOptions, s conversion.Scope) error {
	return autoConvert_v1_PodAttachOptions_To_api_PodAttachOptions(in, out, s)
}

func autoConvert_api_PodAttachOptions_To_v1_PodAttachOptions(in *api.PodAttachOptions, out *v1.PodAttachOptions, s conversion.Scope) error {
	out.Stdin = in.Stdin
	out.Stdout = in.Stdout
	out.Stderr = in.Stderr
	out.TTY = in.TTY
	out.Container = in.Container
	return nil
}

// Convert_api_PodAttachOptions_To_v1_PodAttachOptions is an autogenerated conversion function.
func Convert_api_PodAttachOptions_To_v1_PodAttachOptions(in *api.PodAttachOptions, out *v1.PodAttachOptions, s conversion.Scope) error {
	return autoConvert_api_PodAttachOptions_To_v1_PodAttachOptions(in, out, s)
}

func autoConvert_v1_PodCondition_To_api_PodCondition(in *v1.PodCondition, out *api.PodCondition, s conversion.Scope) error {
	out.Type = api.PodConditionType(in.Type)
	out.Status = api.ConditionStatus(in.Status)
	out.LastProbeTime = in.LastProbeTime
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1_PodCondition_To_api_PodCondition is an autogenerated conversion function.
func Convert_v1_PodCondition_To_api_PodCondition(in *v1.PodCondition, out *api.PodCondition, s conversion.Scope) error {
	return autoConvert_v1_PodCondition_To_api_PodCondition(in, out, s)
}

func autoConvert_api_PodCondition_To_v1_PodCondition(in *api.PodCondition, out *v1.PodCondition, s conversion.Scope) error {
	out.Type = v1.PodConditionType(in.Type)
	out.Status = v1.ConditionStatus(in.Status)
	out.LastProbeTime = in.LastProbeTime
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_api_PodCondition_To_v1_PodCondition is an autogenerated conversion function.
func Convert_api_PodCondition_To_v1_PodCondition(in *api.PodCondition, out *v1.PodCondition, s conversion.Scope) error {
	return autoConvert_api_PodCondition_To_v1_PodCondition(in, out, s)
}

func autoConvert_v1_PodExecOptions_To_api_PodExecOptions(in *v1.PodExecOptions, out *api.PodExecOptions, s conversion.Scope) error {
	out.Stdin = in.Stdin
	out.Stdout = in.Stdout
	out.Stderr = in.Stderr
	out.TTY = in.TTY
	out.Container = in.Container
	out.Command = *(*[]string)(unsafe.Pointer(&in.Command))
	return nil
}

// Convert_v1_PodExecOptions_To_api_PodExecOptions is an autogenerated conversion function.
func Convert_v1_PodExecOptions_To_api_PodExecOptions(in *v1.PodExecOptions, out *api.PodExecOptions, s conversion.Scope) error {
	return autoConvert_v1_PodExecOptions_To_api_PodExecOptions(in, out, s)
}

func autoConvert_api_PodExecOptions_To_v1_PodExecOptions(in *api.PodExecOptions, out *v1.PodExecOptions, s conversion.Scope) error {
	out.Stdin = in.Stdin
	out.Stdout = in.Stdout
	out.Stderr = in.Stderr
	out.TTY = in.TTY
	out.Container = in.Container
	out.Command = *(*[]string)(unsafe.Pointer(&in.Command))
	return nil
}

// Convert_api_PodExecOptions_To_v1_PodExecOptions is an autogenerated conversion function.
func Convert_api_PodExecOptions_To_v1_PodExecOptions(in *api.PodExecOptions, out *v1.PodExecOptions, s conversion.Scope) error {
	return autoConvert_api_PodExecOptions_To_v1_PodExecOptions(in, out, s)
}

func autoConvert_v1_PodList_To_api_PodList(in *v1.PodList, out *api.PodList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]api.Pod, len(*in))
		for i := range *in {
			if err := Convert_v1_Pod_To_api_Pod(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_PodList_To_api_PodList is an autogenerated conversion function.
func Convert_v1_PodList_To_api_PodList(in *v1.PodList, out *api.PodList, s conversion.Scope) error {
	return autoConvert_v1_PodList_To_api_PodList(in, out, s)
}

func autoConvert_api_PodList_To_v1_PodList(in *api.PodList, out *v1.PodList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1.Pod, len(*in))
		for i := range *in {
			if err := Convert_api_Pod_To_v1_Pod(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_api_PodList_To_v1_PodList is an autogenerated conversion function.
func Convert_api_PodList_To_v1_PodList(in *api.PodList, out *v1.PodList, s conversion.Scope) error {
	return autoConvert_api_PodList_To_v1_PodList(in, out, s)
}

func autoConvert_v1_PodLogOptions_To_api_PodLogOptions(in *v1.PodLogOptions, out *api.PodLogOptions, s conversion.Scope) error {
	out.Container = in.Container
	out.Follow = in.Follow
	out.Previous = in.Previous
	out.SinceSeconds = (*int64)(unsafe.Pointer(in.SinceSeconds))
	out.SinceTime = (*meta_v1.Time)(unsafe.Pointer(in.SinceTime))
	out.Timestamps = in.Timestamps
	out.TailLines = (*int64)(unsafe.Pointer(in.TailLines))
	out.LimitBytes = (*int64)(unsafe.Pointer(in.LimitBytes))
	return nil
}

// Convert_v1_PodLogOptions_To_api_PodLogOptions is an autogenerated conversion function.
func Convert_v1_PodLogOptions_To_api_PodLogOptions(in *v1.PodLogOptions, out *api.PodLogOptions, s conversion.Scope) error {
	return autoConvert_v1_PodLogOptions_To_api_PodLogOptions(in, out, s)
}

func autoConvert_api_PodLogOptions_To_v1_PodLogOptions(in *api.PodLogOptions, out *v1.PodLogOptions, s conversion.Scope) error {
	out.Container = in.Container
	out.Follow = in.Follow
	out.Previous = in.Previous
	out.SinceSeconds = (*int64)(unsafe.Pointer(in.SinceSeconds))
	out.SinceTime = (*meta_v1.Time)(unsafe.Pointer(in.SinceTime))
	out.Timestamps = in.Timestamps
	out.TailLines = (*int64)(unsafe.Pointer(in.TailLines))
	out.LimitBytes = (*int64)(unsafe.Pointer(in.LimitBytes))
	return nil
}

// Convert_api_PodLogOptions_To_v1_PodLogOptions is an autogenerated conversion function.
func Convert_api_PodLogOptions_To_v1_PodLogOptions(in *api.PodLogOptions, out *v1.PodLogOptions, s conversion.Scope) error {
	return autoConvert_api_PodLogOptions_To_v1_PodLogOptions(in, out, s)
}

func autoConvert_v1_PodPortForwardOptions_To_api_PodPortForwardOptions(in *v1.PodPortForwardOptions, out *api.PodPortForwardOptions, s conversion.Scope) error {
	out.Ports = *(*[]int32)(unsafe.Pointer(&in.Ports))
	return nil
}

// Convert_v1_PodPortForwardOptions_To_api_PodPortForwardOptions is an autogenerated conversion function.
func Convert_v1_PodPortForwardOptions_To_api_PodPortForwardOptions(in *v1.PodPortForwardOptions, out *api.PodPortForwardOptions, s conversion.Scope) error {
	return autoConvert_v1_PodPortForwardOptions_To_api_PodPortForwardOptions(in, out, s)
}

func autoConvert_api_PodPortForwardOptions_To_v1_PodPortForwardOptions(in *api.PodPortForwardOptions, out *v1.PodPortForwardOptions, s conversion.Scope) error {
	out.Ports = *(*[]int32)(unsafe.Pointer(&in.Ports))
	return nil
}

// Convert_api_PodPortForwardOptions_To_v1_PodPortForwardOptions is an autogenerated conversion function.
func Convert_api_PodPortForwardOptions_To_v1_PodPortForwardOptions(in *api.PodPortForwardOptions, out *v1.PodPortForwardOptions, s conversion.Scope) error {
	return autoConvert_api_PodPortForwardOptions_To_v1_PodPortForwardOptions(in, out, s)
}

func autoConvert_v1_PodProxyOptions_To_api_PodProxyOptions(in *v1.PodProxyOptions, out *api.PodProxyOptions, s conversion.Scope) error {
	out.Path = in.Path
	return nil
}

// Convert_v1_PodProxyOptions_To_api_PodProxyOptions is an autogenerated conversion function.
func Convert_v1_PodProxyOptions_To_api_PodProxyOptions(in *v1.PodProxyOptions, out *api.PodProxyOptions, s conversion.Scope) error {
	return autoConvert_v1_PodProxyOptions_To_api_PodProxyOptions(in, out, s)
}

func autoConvert_api_PodProxyOptions_To_v1_PodProxyOptions(in *api.PodProxyOptions, out *v1.PodProxyOptions, s conversion.Scope) error {
	out.Path = in.Path
	return nil
}

// Convert_api_PodProxyOptions_To_v1_PodProxyOptions is an autogenerated conversion function.
func Convert_api_PodProxyOptions_To_v1_PodProxyOptions(in *api.PodProxyOptions, out *v1.PodProxyOptions, s conversion.Scope) error {
	return autoConvert_api_PodProxyOptions_To_v1_PodProxyOptions(in, out, s)
}

func autoConvert_v1_PodSecurityContext_To_api_PodSecurityContext(in *v1.PodSecurityContext, out *api.PodSecurityContext, s conversion.Scope) error {
	out.SELinuxOptions = (*api.SELinuxOptions)(unsafe.Pointer(in.SELinuxOptions))
	out.RunAsUser = (*int64)(unsafe.Pointer(in.RunAsUser))
	out.RunAsNonRoot = (*bool)(unsafe.Pointer(in.RunAsNonRoot))
	out.SupplementalGroups = *(*[]int64)(unsafe.Pointer(&in.SupplementalGroups))
	out.FSGroup = (*int64)(unsafe.Pointer(in.FSGroup))
	return nil
}

func autoConvert_api_PodSecurityContext_To_v1_PodSecurityContext(in *api.PodSecurityContext, out *v1.PodSecurityContext, s conversion.Scope) error {
	// INFO: in.HostNetwork opted out of conversion generation
	// INFO: in.HostPID opted out of conversion generation
	// INFO: in.HostIPC opted out of conversion generation
	out.SELinuxOptions = (*v1.SELinuxOptions)(unsafe.Pointer(in.SELinuxOptions))
	out.RunAsUser = (*int64)(unsafe.Pointer(in.RunAsUser))
	out.RunAsNonRoot = (*bool)(unsafe.Pointer(in.RunAsNonRoot))
	out.SupplementalGroups = *(*[]int64)(unsafe.Pointer(&in.SupplementalGroups))
	out.FSGroup = (*int64)(unsafe.Pointer(in.FSGroup))
	return nil
}

func autoConvert_v1_PodSignature_To_api_PodSignature(in *v1.PodSignature, out *api.PodSignature, s conversion.Scope) error {
	out.PodController = (*meta_v1.OwnerReference)(unsafe.Pointer(in.PodController))
	return nil
}

// Convert_v1_PodSignature_To_api_PodSignature is an autogenerated conversion function.
func Convert_v1_PodSignature_To_api_PodSignature(in *v1.PodSignature, out *api.PodSignature, s conversion.Scope) error {
	return autoConvert_v1_PodSignature_To_api_PodSignature(in, out, s)
}

func autoConvert_api_PodSignature_To_v1_PodSignature(in *api.PodSignature, out *v1.PodSignature, s conversion.Scope) error {
	out.PodController = (*meta_v1.OwnerReference)(unsafe.Pointer(in.PodController))
	return nil
}

// Convert_api_PodSignature_To_v1_PodSignature is an autogenerated conversion function.
func Convert_api_PodSignature_To_v1_PodSignature(in *api.PodSignature, out *v1.PodSignature, s conversion.Scope) error {
	return autoConvert_api_PodSignature_To_v1_PodSignature(in, out, s)
}

func autoConvert_v1_PodSpec_To_api_PodSpec(in *v1.PodSpec, out *api.PodSpec, s conversion.Scope) error {
	if in.Volumes != nil {
		in, out := &in.Volumes, &out.Volumes
		*out = make([]api.Volume, len(*in))
		for i := range *in {
			if err := Convert_v1_Volume_To_api_Volume(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Volumes = nil
	}
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]api.Container, len(*in))
		for i := range *in {
			if err := Convert_v1_Container_To_api_Container(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.InitContainers = nil
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]api.Container, len(*in))
		for i := range *in {
			if err := Convert_v1_Container_To_api_Container(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Containers = nil
	}
	out.RestartPolicy = api.RestartPolicy(in.RestartPolicy)
	out.TerminationGracePeriodSeconds = (*int64)(unsafe.Pointer(in.TerminationGracePeriodSeconds))
	out.ActiveDeadlineSeconds = (*int64)(unsafe.Pointer(in.ActiveDeadlineSeconds))
	out.DNSPolicy = api.DNSPolicy(in.DNSPolicy)
	out.NodeSelector = *(*map[string]string)(unsafe.Pointer(&in.NodeSelector))
	out.ServiceAccountName = in.ServiceAccountName
	// INFO: in.DeprecatedServiceAccount opted out of conversion generation
	out.AutomountServiceAccountToken = (*bool)(unsafe.Pointer(in.AutomountServiceAccountToken))
	out.NodeName = in.NodeName
	// INFO: in.HostNetwork opted out of conversion generation
	// INFO: in.HostPID opted out of conversion generation
	// INFO: in.HostIPC opted out of conversion generation
	if in.SecurityContext != nil {
		in, out := &in.SecurityContext, &out.SecurityContext
		*out = new(api.PodSecurityContext)
		if err := Convert_v1_PodSecurityContext_To_api_PodSecurityContext(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.SecurityContext = nil
	}
	out.ImagePullSecrets = *(*[]api.LocalObjectReference)(unsafe.Pointer(&in.ImagePullSecrets))
	out.Hostname = in.Hostname
	out.Subdomain = in.Subdomain
	out.Affinity = (*api.Affinity)(unsafe.Pointer(in.Affinity))
	out.SchedulerName = in.SchedulerName
	out.Tolerations = *(*[]api.Toleration)(unsafe.Pointer(&in.Tolerations))
	out.HostAliases = *(*[]api.HostAlias)(unsafe.Pointer(&in.HostAliases))
	out.PriorityClassName = in.PriorityClassName
	out.Priority = (*int32)(unsafe.Pointer(in.Priority))
	return nil
}

func autoConvert_api_PodSpec_To_v1_PodSpec(in *api.PodSpec, out *v1.PodSpec, s conversion.Scope) error {
	if in.Volumes != nil {
		in, out := &in.Volumes, &out.Volumes
		*out = make([]v1.Volume, len(*in))
		for i := range *in {
			if err := Convert_api_Volume_To_v1_Volume(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Volumes = nil
	}
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]v1.Container, len(*in))
		for i := range *in {
			if err := Convert_api_Container_To_v1_Container(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.InitContainers = nil
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]v1.Container, len(*in))
		for i := range *in {
			if err := Convert_api_Container_To_v1_Container(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Containers = nil
	}
	out.RestartPolicy = v1.RestartPolicy(in.RestartPolicy)
	out.TerminationGracePeriodSeconds = (*int64)(unsafe.Pointer(in.TerminationGracePeriodSeconds))
	out.ActiveDeadlineSeconds = (*int64)(unsafe.Pointer(in.ActiveDeadlineSeconds))
	out.DNSPolicy = v1.DNSPolicy(in.DNSPolicy)
	out.NodeSelector = *(*map[string]string)(unsafe.Pointer(&in.NodeSelector))
	out.ServiceAccountName = in.ServiceAccountName
	out.AutomountServiceAccountToken = (*bool)(unsafe.Pointer(in.AutomountServiceAccountToken))
	out.NodeName = in.NodeName
	if in.SecurityContext != nil {
		in, out := &in.SecurityContext, &out.SecurityContext
		*out = new(v1.PodSecurityContext)
		if err := Convert_api_PodSecurityContext_To_v1_PodSecurityContext(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.SecurityContext = nil
	}
	out.ImagePullSecrets = *(*[]v1.LocalObjectReference)(unsafe.Pointer(&in.ImagePullSecrets))
	out.Hostname = in.Hostname
	out.Subdomain = in.Subdomain
	out.Affinity = (*v1.Affinity)(unsafe.Pointer(in.Affinity))
	out.SchedulerName = in.SchedulerName
	out.Tolerations = *(*[]v1.Toleration)(unsafe.Pointer(&in.Tolerations))
	out.HostAliases = *(*[]v1.HostAlias)(unsafe.Pointer(&in.HostAliases))
	out.PriorityClassName = in.PriorityClassName
	out.Priority = (*int32)(unsafe.Pointer(in.Priority))
	return nil
}

func autoConvert_v1_PodStatus_To_api_PodStatus(in *v1.PodStatus, out *api.PodStatus, s conversion.Scope) error {
	out.Phase = api.PodPhase(in.Phase)
	out.Conditions = *(*[]api.PodCondition)(unsafe.Pointer(&in.Conditions))
	out.Message = in.Message
	out.Reason = in.Reason
	out.HostIP = in.HostIP
	out.PodIP = in.PodIP
	out.StartTime = (*meta_v1.Time)(unsafe.Pointer(in.StartTime))
	out.InitContainerStatuses = *(*[]api.ContainerStatus)(unsafe.Pointer(&in.InitContainerStatuses))
	out.ContainerStatuses = *(*[]api.ContainerStatus)(unsafe.Pointer(&in.ContainerStatuses))
	out.QOSClass = api.PodQOSClass(in.QOSClass)
	return nil
}

// Convert_v1_PodStatus_To_api_PodStatus is an autogenerated conversion function.
func Convert_v1_PodStatus_To_api_PodStatus(in *v1.PodStatus, out *api.PodStatus, s conversion.Scope) error {
	return autoConvert_v1_PodStatus_To_api_PodStatus(in, out, s)
}

func autoConvert_api_PodStatus_To_v1_PodStatus(in *api.PodStatus, out *v1.PodStatus, s conversion.Scope) error {
	out.Phase = v1.PodPhase(in.Phase)
	out.Conditions = *(*[]v1.PodCondition)(unsafe.Pointer(&in.Conditions))
	out.Message = in.Message
	out.Reason = in.Reason
	out.HostIP = in.HostIP
	out.PodIP = in.PodIP
	out.StartTime = (*meta_v1.Time)(unsafe.Pointer(in.StartTime))
	out.QOSClass = v1.PodQOSClass(in.QOSClass)
	out.InitContainerStatuses = *(*[]v1.ContainerStatus)(unsafe.Pointer(&in.InitContainerStatuses))
	out.ContainerStatuses = *(*[]v1.ContainerStatus)(unsafe.Pointer(&in.ContainerStatuses))
	return nil
}

// Convert_api_PodStatus_To_v1_PodStatus is an autogenerated conversion function.
func Convert_api_PodStatus_To_v1_PodStatus(in *api.PodStatus, out *v1.PodStatus, s conversion.Scope) error {
	return autoConvert_api_PodStatus_To_v1_PodStatus(in, out, s)
}

func autoConvert_v1_PodStatusResult_To_api_PodStatusResult(in *v1.PodStatusResult, out *api.PodStatusResult, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_PodStatus_To_api_PodStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_PodStatusResult_To_api_PodStatusResult is an autogenerated conversion function.
func Convert_v1_PodStatusResult_To_api_PodStatusResult(in *v1.PodStatusResult, out *api.PodStatusResult, s conversion.Scope) error {
	return autoConvert_v1_PodStatusResult_To_api_PodStatusResult(in, out, s)
}

func autoConvert_api_PodStatusResult_To_v1_PodStatusResult(in *api.PodStatusResult, out *v1.PodStatusResult, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_api_PodStatus_To_v1_PodStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_api_PodStatusResult_To_v1_PodStatusResult is an autogenerated conversion function.
func Convert_api_PodStatusResult_To_v1_PodStatusResult(in *api.PodStatusResult, out *v1.PodStatusResult, s conversion.Scope) error {
	return autoConvert_api_PodStatusResult_To_v1_PodStatusResult(in, out, s)
}

func autoConvert_v1_PodTemplate_To_api_PodTemplate(in *v1.PodTemplate, out *api.PodTemplate, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_PodTemplateSpec_To_api_PodTemplateSpec(&in.Template, &out.Template, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_PodTemplate_To_api_PodTemplate is an autogenerated conversion function.
func Convert_v1_PodTemplate_To_api_PodTemplate(in *v1.PodTemplate, out *api.PodTemplate, s conversion.Scope) error {
	return autoConvert_v1_PodTemplate_To_api_PodTemplate(in, out, s)
}

func autoConvert_api_PodTemplate_To_v1_PodTemplate(in *api.PodTemplate, out *v1.PodTemplate, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_api_PodTemplateSpec_To_v1_PodTemplateSpec(&in.Template, &out.Template, s); err != nil {
		return err
	}
	return nil
}

// Convert_api_PodTemplate_To_v1_PodTemplate is an autogenerated conversion function.
func Convert_api_PodTemplate_To_v1_PodTemplate(in *api.PodTemplate, out *v1.PodTemplate, s conversion.Scope) error {
	return autoConvert_api_PodTemplate_To_v1_PodTemplate(in, out, s)
}

func autoConvert_v1_PodTemplateList_To_api_PodTemplateList(in *v1.PodTemplateList, out *api.PodTemplateList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]api.PodTemplate, len(*in))
		for i := range *in {
			if err := Convert_v1_PodTemplate_To_api_PodTemplate(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_PodTemplateList_To_api_PodTemplateList is an autogenerated conversion function.
func Convert_v1_PodTemplateList_To_api_PodTemplateList(in *v1.PodTemplateList, out *api.PodTemplateList, s conversion.Scope) error {
	return autoConvert_v1_PodTemplateList_To_api_PodTemplateList(in, out, s)
}

func autoConvert_api_PodTemplateList_To_v1_PodTemplateList(in *api.PodTemplateList, out *v1.PodTemplateList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1.PodTemplate, len(*in))
		for i := range *in {
			if err := Convert_api_PodTemplate_To_v1_PodTemplate(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_api_PodTemplateList_To_v1_PodTemplateList is an autogenerated conversion function.
func Convert_api_PodTemplateList_To_v1_PodTemplateList(in *api.PodTemplateList, out *v1.PodTemplateList, s conversion.Scope) error {
	return autoConvert_api_PodTemplateList_To_v1_PodTemplateList(in, out, s)
}

func autoConvert_v1_PodTemplateSpec_To_api_PodTemplateSpec(in *v1.PodTemplateSpec, out *api.PodTemplateSpec, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_PodSpec_To_api_PodSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_api_PodTemplateSpec_To_v1_PodTemplateSpec(in *api.PodTemplateSpec, out *v1.PodTemplateSpec, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_api_PodSpec_To_v1_PodSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1_PortworxVolumeSource_To_api_PortworxVolumeSource(in *v1.PortworxVolumeSource, out *api.PortworxVolumeSource, s conversion.Scope) error {
	out.VolumeID = in.VolumeID
	out.FSType = in.FSType
	out.ReadOnly = in.ReadOnly
	return nil
}

// Convert_v1_PortworxVolumeSource_To_api_PortworxVolumeSource is an autogenerated conversion function.
func Convert_v1_PortworxVolumeSource_To_api_PortworxVolumeSource(in *v1.PortworxVolumeSource, out *api.PortworxVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_PortworxVolumeSource_To_api_PortworxVolumeSource(in, out, s)
}

func autoConvert_api_PortworxVolumeSource_To_v1_PortworxVolumeSource(in *api.PortworxVolumeSource, out *v1.PortworxVolumeSource, s conversion.Scope) error {
	out.VolumeID = in.VolumeID
	out.FSType = in.FSType
	out.ReadOnly = in.ReadOnly
	return nil
}

// Convert_api_PortworxVolumeSource_To_v1_PortworxVolumeSource is an autogenerated conversion function.
func Convert_api_PortworxVolumeSource_To_v1_PortworxVolumeSource(in *api.PortworxVolumeSource, out *v1.PortworxVolumeSource, s conversion.Scope) error {
	return autoConvert_api_PortworxVolumeSource_To_v1_PortworxVolumeSource(in, out, s)
}

func autoConvert_v1_Preconditions_To_api_Preconditions(in *v1.Preconditions, out *api.Preconditions, s conversion.Scope) error {
	out.UID = (*types.UID)(unsafe.Pointer(in.UID))
	return nil
}

// Convert_v1_Preconditions_To_api_Preconditions is an autogenerated conversion function.
func Convert_v1_Preconditions_To_api_Preconditions(in *v1.Preconditions, out *api.Preconditions, s conversion.Scope) error {
	return autoConvert_v1_Preconditions_To_api_Preconditions(in, out, s)
}

func autoConvert_api_Preconditions_To_v1_Preconditions(in *api.Preconditions, out *v1.Preconditions, s conversion.Scope) error {
	out.UID = (*types.UID)(unsafe.Pointer(in.UID))
	return nil
}

// Convert_api_Preconditions_To_v1_Preconditions is an autogenerated conversion function.
func Convert_api_Preconditions_To_v1_Preconditions(in *api.Preconditions, out *v1.Preconditions, s conversion.Scope) error {
	return autoConvert_api_Preconditions_To_v1_Preconditions(in, out, s)
}

func autoConvert_v1_PreferAvoidPodsEntry_To_api_PreferAvoidPodsEntry(in *v1.PreferAvoidPodsEntry, out *api.PreferAvoidPodsEntry, s conversion.Scope) error {
	if err := Convert_v1_PodSignature_To_api_PodSignature(&in.PodSignature, &out.PodSignature, s); err != nil {
		return err
	}
	out.EvictionTime = in.EvictionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1_PreferAvoidPodsEntry_To_api_PreferAvoidPodsEntry is an autogenerated conversion function.
func Convert_v1_PreferAvoidPodsEntry_To_api_PreferAvoidPodsEntry(in *v1.PreferAvoidPodsEntry, out *api.PreferAvoidPodsEntry, s conversion.Scope) error {
	return autoConvert_v1_PreferAvoidPodsEntry_To_api_PreferAvoidPodsEntry(in, out, s)
}

func autoConvert_api_PreferAvoidPodsEntry_To_v1_PreferAvoidPodsEntry(in *api.PreferAvoidPodsEntry, out *v1.PreferAvoidPodsEntry, s conversion.Scope) error {
	if err := Convert_api_PodSignature_To_v1_PodSignature(&in.PodSignature, &out.PodSignature, s); err != nil {
		return err
	}
	out.EvictionTime = in.EvictionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_api_PreferAvoidPodsEntry_To_v1_PreferAvoidPodsEntry is an autogenerated conversion function.
func Convert_api_PreferAvoidPodsEntry_To_v1_PreferAvoidPodsEntry(in *api.PreferAvoidPodsEntry, out *v1.PreferAvoidPodsEntry, s conversion.Scope) error {
	return autoConvert_api_PreferAvoidPodsEntry_To_v1_PreferAvoidPodsEntry(in, out, s)
}

func autoConvert_v1_PreferredSchedulingTerm_To_api_PreferredSchedulingTerm(in *v1.PreferredSchedulingTerm, out *api.PreferredSchedulingTerm, s conversion.Scope) error {
	out.Weight = in.Weight
	if err := Convert_v1_NodeSelectorTerm_To_api_NodeSelectorTerm(&in.Preference, &out.Preference, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_PreferredSchedulingTerm_To_api_PreferredSchedulingTerm is an autogenerated conversion function.
func Convert_v1_PreferredSchedulingTerm_To_api_PreferredSchedulingTerm(in *v1.PreferredSchedulingTerm, out *api.PreferredSchedulingTerm, s conversion.Scope) error {
	return autoConvert_v1_PreferredSchedulingTerm_To_api_PreferredSchedulingTerm(in, out, s)
}

func autoConvert_api_PreferredSchedulingTerm_To_v1_PreferredSchedulingTerm(in *api.PreferredSchedulingTerm, out *v1.PreferredSchedulingTerm, s conversion.Scope) error {
	out.Weight = in.Weight
	if err := Convert_api_NodeSelectorTerm_To_v1_NodeSelectorTerm(&in.Preference, &out.Preference, s); err != nil {
		return err
	}
	return nil
}

// Convert_api_PreferredSchedulingTerm_To_v1_PreferredSchedulingTerm is an autogenerated conversion function.
func Convert_api_PreferredSchedulingTerm_To_v1_PreferredSchedulingTerm(in *api.PreferredSchedulingTerm, out *v1.PreferredSchedulingTerm, s conversion.Scope) error {
	return autoConvert_api_PreferredSchedulingTerm_To_v1_PreferredSchedulingTerm(in, out, s)
}

func autoConvert_v1_Probe_To_api_Probe(in *v1.Probe, out *api.Probe, s conversion.Scope) error {
	if err := Convert_v1_Handler_To_api_Handler(&in.Handler, &out.Handler, s); err != nil {
		return err
	}
	out.InitialDelaySeconds = in.InitialDelaySeconds
	out.TimeoutSeconds = in.TimeoutSeconds
	out.PeriodSeconds = in.PeriodSeconds
	out.SuccessThreshold = in.SuccessThreshold
	out.FailureThreshold = in.FailureThreshold
	return nil
}

// Convert_v1_Probe_To_api_Probe is an autogenerated conversion function.
func Convert_v1_Probe_To_api_Probe(in *v1.Probe, out *api.Probe, s conversion.Scope) error {
	return autoConvert_v1_Probe_To_api_Probe(in, out, s)
}

func autoConvert_api_Probe_To_v1_Probe(in *api.Probe, out *v1.Probe, s conversion.Scope) error {
	if err := Convert_api_Handler_To_v1_Handler(&in.Handler, &out.Handler, s); err != nil {
		return err
	}
	out.InitialDelaySeconds = in.InitialDelaySeconds
	out.TimeoutSeconds = in.TimeoutSeconds
	out.PeriodSeconds = in.PeriodSeconds
	out.SuccessThreshold = in.SuccessThreshold
	out.FailureThreshold = in.FailureThreshold
	return nil
}

// Convert_api_Probe_To_v1_Probe is an autogenerated conversion function.
func Convert_api_Probe_To_v1_Probe(in *api.Probe, out *v1.Probe, s conversion.Scope) error {
	return autoConvert_api_Probe_To_v1_Probe(in, out, s)
}

func autoConvert_v1_ProjectedVolumeSource_To_api_ProjectedVolumeSource(in *v1.ProjectedVolumeSource, out *api.ProjectedVolumeSource, s conversion.Scope) error {
	out.Sources = *(*[]api.VolumeProjection)(unsafe.Pointer(&in.Sources))
	out.DefaultMode = (*int32)(unsafe.Pointer(in.DefaultMode))
	return nil
}

// Convert_v1_ProjectedVolumeSource_To_api_ProjectedVolumeSource is an autogenerated conversion function.
func Convert_v1_ProjectedVolumeSource_To_api_ProjectedVolumeSource(in *v1.ProjectedVolumeSource, out *api.ProjectedVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_ProjectedVolumeSource_To_api_ProjectedVolumeSource(in, out, s)
}

func autoConvert_api_ProjectedVolumeSource_To_v1_ProjectedVolumeSource(in *api.ProjectedVolumeSource, out *v1.ProjectedVolumeSource, s conversion.Scope) error {
	out.Sources = *(*[]v1.VolumeProjection)(unsafe.Pointer(&in.Sources))
	out.DefaultMode = (*int32)(unsafe.Pointer(in.DefaultMode))
	return nil
}

// Convert_api_ProjectedVolumeSource_To_v1_ProjectedVolumeSource is an autogenerated conversion function.
func Convert_api_ProjectedVolumeSource_To_v1_ProjectedVolumeSource(in *api.ProjectedVolumeSource, out *v1.ProjectedVolumeSource, s conversion.Scope) error {
	return autoConvert_api_ProjectedVolumeSource_To_v1_ProjectedVolumeSource(in, out, s)
}

func autoConvert_v1_QuobyteVolumeSource_To_api_QuobyteVolumeSource(in *v1.QuobyteVolumeSource, out *api.QuobyteVolumeSource, s conversion.Scope) error {
	out.Registry = in.Registry
	out.Volume = in.Volume
	out.ReadOnly = in.ReadOnly
	out.User = in.User
	out.Group = in.Group
	return nil
}

// Convert_v1_QuobyteVolumeSource_To_api_QuobyteVolumeSource is an autogenerated conversion function.
func Convert_v1_QuobyteVolumeSource_To_api_QuobyteVolumeSource(in *v1.QuobyteVolumeSource, out *api.QuobyteVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_QuobyteVolumeSource_To_api_QuobyteVolumeSource(in, out, s)
}

func autoConvert_api_QuobyteVolumeSource_To_v1_QuobyteVolumeSource(in *api.QuobyteVolumeSource, out *v1.QuobyteVolumeSource, s conversion.Scope) error {
	out.Registry = in.Registry
	out.Volume = in.Volume
	out.ReadOnly = in.ReadOnly
	out.User = in.User
	out.Group = in.Group
	return nil
}

// Convert_api_QuobyteVolumeSource_To_v1_QuobyteVolumeSource is an autogenerated conversion function.
func Convert_api_QuobyteVolumeSource_To_v1_QuobyteVolumeSource(in *api.QuobyteVolumeSource, out *v1.QuobyteVolumeSource, s conversion.Scope) error {
	return autoConvert_api_QuobyteVolumeSource_To_v1_QuobyteVolumeSource(in, out, s)
}

func autoConvert_v1_RBDVolumeSource_To_api_RBDVolumeSource(in *v1.RBDVolumeSource, out *api.RBDVolumeSource, s conversion.Scope) error {
	out.CephMonitors = *(*[]string)(unsafe.Pointer(&in.CephMonitors))
	out.RBDImage = in.RBDImage
	out.FSType = in.FSType
	out.RBDPool = in.RBDPool
	out.RadosUser = in.RadosUser
	out.Keyring = in.Keyring
	out.SecretRef = (*api.LocalObjectReference)(unsafe.Pointer(in.SecretRef))
	out.ReadOnly = in.ReadOnly
	return nil
}

// Convert_v1_RBDVolumeSource_To_api_RBDVolumeSource is an autogenerated conversion function.
func Convert_v1_RBDVolumeSource_To_api_RBDVolumeSource(in *v1.RBDVolumeSource, out *api.RBDVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_RBDVolumeSource_To_api_RBDVolumeSource(in, out, s)
}

func autoConvert_api_RBDVolumeSource_To_v1_RBDVolumeSource(in *api.RBDVolumeSource, out *v1.RBDVolumeSource, s conversion.Scope) error {
	out.CephMonitors = *(*[]string)(unsafe.Pointer(&in.CephMonitors))
	out.RBDImage = in.RBDImage
	out.FSType = in.FSType
	out.RBDPool = in.RBDPool
	out.RadosUser = in.RadosUser
	out.Keyring = in.Keyring
	out.SecretRef = (*v1.LocalObjectReference)(unsafe.Pointer(in.SecretRef))
	out.ReadOnly = in.ReadOnly
	return nil
}

// Convert_api_RBDVolumeSource_To_v1_RBDVolumeSource is an autogenerated conversion function.
func Convert_api_RBDVolumeSource_To_v1_RBDVolumeSource(in *api.RBDVolumeSource, out *v1.RBDVolumeSource, s conversion.Scope) error {
	return autoConvert_api_RBDVolumeSource_To_v1_RBDVolumeSource(in, out, s)
}

func autoConvert_v1_RangeAllocation_To_api_RangeAllocation(in *v1.RangeAllocation, out *api.RangeAllocation, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Range = in.Range
	out.Data = *(*[]byte)(unsafe.Pointer(&in.Data))
	return nil
}

// Convert_v1_RangeAllocation_To_api_RangeAllocation is an autogenerated conversion function.
func Convert_v1_RangeAllocation_To_api_RangeAllocation(in *v1.RangeAllocation, out *api.RangeAllocation, s conversion.Scope) error {
	return autoConvert_v1_RangeAllocation_To_api_RangeAllocation(in, out, s)
}

func autoConvert_api_RangeAllocation_To_v1_RangeAllocation(in *api.RangeAllocation, out *v1.RangeAllocation, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Range = in.Range
	out.Data = *(*[]byte)(unsafe.Pointer(&in.Data))
	return nil
}

// Convert_api_RangeAllocation_To_v1_RangeAllocation is an autogenerated conversion function.
func Convert_api_RangeAllocation_To_v1_RangeAllocation(in *api.RangeAllocation, out *v1.RangeAllocation, s conversion.Scope) error {
	return autoConvert_api_RangeAllocation_To_v1_RangeAllocation(in, out, s)
}

func autoConvert_v1_ReplicationController_To_api_ReplicationController(in *v1.ReplicationController, out *api.ReplicationController, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_ReplicationControllerSpec_To_api_ReplicationControllerSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_ReplicationControllerStatus_To_api_ReplicationControllerStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ReplicationController_To_api_ReplicationController is an autogenerated conversion function.
func Convert_v1_ReplicationController_To_api_ReplicationController(in *v1.ReplicationController, out *api.ReplicationController, s conversion.Scope) error {
	return autoConvert_v1_ReplicationController_To_api_ReplicationController(in, out, s)
}

func autoConvert_api_ReplicationController_To_v1_ReplicationController(in *api.ReplicationController, out *v1.ReplicationController, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_api_ReplicationControllerSpec_To_v1_ReplicationControllerSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_api_ReplicationControllerStatus_To_v1_ReplicationControllerStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_api_ReplicationController_To_v1_ReplicationController is an autogenerated conversion function.
func Convert_api_ReplicationController_To_v1_ReplicationController(in *api.ReplicationController, out *v1.ReplicationController, s conversion.Scope) error {
	return autoConvert_api_ReplicationController_To_v1_ReplicationController(in, out, s)
}

func autoConvert_v1_ReplicationControllerCondition_To_api_ReplicationControllerCondition(in *v1.ReplicationControllerCondition, out *api.ReplicationControllerCondition, s conversion.Scope) error {
	out.Type = api.ReplicationControllerConditionType(in.Type)
	out.Status = api.ConditionStatus(in.Status)
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1_ReplicationControllerCondition_To_api_ReplicationControllerCondition is an autogenerated conversion function.
func Convert_v1_ReplicationControllerCondition_To_api_ReplicationControllerCondition(in *v1.ReplicationControllerCondition, out *api.ReplicationControllerCondition, s conversion.Scope) error {
	return autoConvert_v1_ReplicationControllerCondition_To_api_ReplicationControllerCondition(in, out, s)
}

func autoConvert_api_ReplicationControllerCondition_To_v1_ReplicationControllerCondition(in *api.ReplicationControllerCondition, out *v1.ReplicationControllerCondition, s conversion.Scope) error {
	out.Type = v1.ReplicationControllerConditionType(in.Type)
	out.Status = v1.ConditionStatus(in.Status)
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_api_ReplicationControllerCondition_To_v1_ReplicationControllerCondition is an autogenerated conversion function.
func Convert_api_ReplicationControllerCondition_To_v1_ReplicationControllerCondition(in *api.ReplicationControllerCondition, out *v1.ReplicationControllerCondition, s conversion.Scope) error {
	return autoConvert_api_ReplicationControllerCondition_To_v1_ReplicationControllerCondition(in, out, s)
}

func autoConvert_v1_ReplicationControllerList_To_api_ReplicationControllerList(in *v1.ReplicationControllerList, out *api.ReplicationControllerList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]api.ReplicationController, len(*in))
		for i := range *in {
			if err := Convert_v1_ReplicationController_To_api_ReplicationController(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_ReplicationControllerList_To_api_ReplicationControllerList is an autogenerated conversion function.
func Convert_v1_ReplicationControllerList_To_api_ReplicationControllerList(in *v1.ReplicationControllerList, out *api.ReplicationControllerList, s conversion.Scope) error {
	return autoConvert_v1_ReplicationControllerList_To_api_ReplicationControllerList(in, out, s)
}

func autoConvert_api_ReplicationControllerList_To_v1_ReplicationControllerList(in *api.ReplicationControllerList, out *v1.ReplicationControllerList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1.ReplicationController, len(*in))
		for i := range *in {
			if err := Convert_api_ReplicationController_To_v1_ReplicationController(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_api_ReplicationControllerList_To_v1_ReplicationControllerList is an autogenerated conversion function.
func Convert_api_ReplicationControllerList_To_v1_ReplicationControllerList(in *api.ReplicationControllerList, out *v1.ReplicationControllerList, s conversion.Scope) error {
	return autoConvert_api_ReplicationControllerList_To_v1_ReplicationControllerList(in, out, s)
}

func autoConvert_v1_ReplicationControllerSpec_To_api_ReplicationControllerSpec(in *v1.ReplicationControllerSpec, out *api.ReplicationControllerSpec, s conversion.Scope) error {
	if err := meta_v1.Convert_Pointer_int32_To_int32(&in.Replicas, &out.Replicas, s); err != nil {
		return err
	}
	out.MinReadySeconds = in.MinReadySeconds
	out.Selector = *(*map[string]string)(unsafe.Pointer(&in.Selector))
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(api.PodTemplateSpec)
		if err := Convert_v1_PodTemplateSpec_To_api_PodTemplateSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Template = nil
	}
	return nil
}

func autoConvert_api_ReplicationControllerSpec_To_v1_ReplicationControllerSpec(in *api.ReplicationControllerSpec, out *v1.ReplicationControllerSpec, s conversion.Scope) error {
	if err := meta_v1.Convert_int32_To_Pointer_int32(&in.Replicas, &out.Replicas, s); err != nil {
		return err
	}
	out.MinReadySeconds = in.MinReadySeconds
	out.Selector = *(*map[string]string)(unsafe.Pointer(&in.Selector))
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(v1.PodTemplateSpec)
		if err := Convert_api_PodTemplateSpec_To_v1_PodTemplateSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Template = nil
	}
	return nil
}

func autoConvert_v1_ReplicationControllerStatus_To_api_ReplicationControllerStatus(in *v1.ReplicationControllerStatus, out *api.ReplicationControllerStatus, s conversion.Scope) error {
	out.Replicas = in.Replicas
	out.FullyLabeledReplicas = in.FullyLabeledReplicas
	out.ReadyReplicas = in.ReadyReplicas
	out.AvailableReplicas = in.AvailableReplicas
	out.ObservedGeneration = in.ObservedGeneration
	out.Conditions = *(*[]api.ReplicationControllerCondition)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1_ReplicationControllerStatus_To_api_ReplicationControllerStatus is an autogenerated conversion function.
func Convert_v1_ReplicationControllerStatus_To_api_ReplicationControllerStatus(in *v1.ReplicationControllerStatus, out *api.ReplicationControllerStatus, s conversion.Scope) error {
	return autoConvert_v1_ReplicationControllerStatus_To_api_ReplicationControllerStatus(in, out, s)
}

func autoConvert_api_ReplicationControllerStatus_To_v1_ReplicationControllerStatus(in *api.ReplicationControllerStatus, out *v1.ReplicationControllerStatus, s conversion.Scope) error {
	out.Replicas = in.Replicas
	out.FullyLabeledReplicas = in.FullyLabeledReplicas
	out.ReadyReplicas = in.ReadyReplicas
	out.AvailableReplicas = in.AvailableReplicas
	out.ObservedGeneration = in.ObservedGeneration
	out.Conditions = *(*[]v1.ReplicationControllerCondition)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_api_ReplicationControllerStatus_To_v1_ReplicationControllerStatus is an autogenerated conversion function.
func Convert_api_ReplicationControllerStatus_To_v1_ReplicationControllerStatus(in *api.ReplicationControllerStatus, out *v1.ReplicationControllerStatus, s conversion.Scope) error {
	return autoConvert_api_ReplicationControllerStatus_To_v1_ReplicationControllerStatus(in, out, s)
}

func autoConvert_v1_ResourceFieldSelector_To_api_ResourceFieldSelector(in *v1.ResourceFieldSelector, out *api.ResourceFieldSelector, s conversion.Scope) error {
	out.ContainerName = in.ContainerName
	out.Resource = in.Resource
	out.Divisor = in.Divisor
	return nil
}

// Convert_v1_ResourceFieldSelector_To_api_ResourceFieldSelector is an autogenerated conversion function.
func Convert_v1_ResourceFieldSelector_To_api_ResourceFieldSelector(in *v1.ResourceFieldSelector, out *api.ResourceFieldSelector, s conversion.Scope) error {
	return autoConvert_v1_ResourceFieldSelector_To_api_ResourceFieldSelector(in, out, s)
}

func autoConvert_api_ResourceFieldSelector_To_v1_ResourceFieldSelector(in *api.ResourceFieldSelector, out *v1.ResourceFieldSelector, s conversion.Scope) error {
	out.ContainerName = in.ContainerName
	out.Resource = in.Resource
	out.Divisor = in.Divisor
	return nil
}

// Convert_api_ResourceFieldSelector_To_v1_ResourceFieldSelector is an autogenerated conversion function.
func Convert_api_ResourceFieldSelector_To_v1_ResourceFieldSelector(in *api.ResourceFieldSelector, out *v1.ResourceFieldSelector, s conversion.Scope) error {
	return autoConvert_api_ResourceFieldSelector_To_v1_ResourceFieldSelector(in, out, s)
}

func autoConvert_v1_ResourceQuota_To_api_ResourceQuota(in *v1.ResourceQuota, out *api.ResourceQuota, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_ResourceQuotaSpec_To_api_ResourceQuotaSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_ResourceQuotaStatus_To_api_ResourceQuotaStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ResourceQuota_To_api_ResourceQuota is an autogenerated conversion function.
func Convert_v1_ResourceQuota_To_api_ResourceQuota(in *v1.ResourceQuota, out *api.ResourceQuota, s conversion.Scope) error {
	return autoConvert_v1_ResourceQuota_To_api_ResourceQuota(in, out, s)
}

func autoConvert_api_ResourceQuota_To_v1_ResourceQuota(in *api.ResourceQuota, out *v1.ResourceQuota, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_api_ResourceQuotaSpec_To_v1_ResourceQuotaSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_api_ResourceQuotaStatus_To_v1_ResourceQuotaStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_api_ResourceQuota_To_v1_ResourceQuota is an autogenerated conversion function.
func Convert_api_ResourceQuota_To_v1_ResourceQuota(in *api.ResourceQuota, out *v1.ResourceQuota, s conversion.Scope) error {
	return autoConvert_api_ResourceQuota_To_v1_ResourceQuota(in, out, s)
}

func autoConvert_v1_ResourceQuotaList_To_api_ResourceQuotaList(in *v1.ResourceQuotaList, out *api.ResourceQuotaList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]api.ResourceQuota)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1_ResourceQuotaList_To_api_ResourceQuotaList is an autogenerated conversion function.
func Convert_v1_ResourceQuotaList_To_api_ResourceQuotaList(in *v1.ResourceQuotaList, out *api.ResourceQuotaList, s conversion.Scope) error {
	return autoConvert_v1_ResourceQuotaList_To_api_ResourceQuotaList(in, out, s)
}

func autoConvert_api_ResourceQuotaList_To_v1_ResourceQuotaList(in *api.ResourceQuotaList, out *v1.ResourceQuotaList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1.ResourceQuota)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_api_ResourceQuotaList_To_v1_ResourceQuotaList is an autogenerated conversion function.
func Convert_api_ResourceQuotaList_To_v1_ResourceQuotaList(in *api.ResourceQuotaList, out *v1.ResourceQuotaList, s conversion.Scope) error {
	return autoConvert_api_ResourceQuotaList_To_v1_ResourceQuotaList(in, out, s)
}

func autoConvert_v1_ResourceQuotaSpec_To_api_ResourceQuotaSpec(in *v1.ResourceQuotaSpec, out *api.ResourceQuotaSpec, s conversion.Scope) error {
	out.Hard = *(*api.ResourceList)(unsafe.Pointer(&in.Hard))
	out.Scopes = *(*[]api.ResourceQuotaScope)(unsafe.Pointer(&in.Scopes))
	return nil
}

// Convert_v1_ResourceQuotaSpec_To_api_ResourceQuotaSpec is an autogenerated conversion function.
func Convert_v1_ResourceQuotaSpec_To_api_ResourceQuotaSpec(in *v1.ResourceQuotaSpec, out *api.ResourceQuotaSpec, s conversion.Scope) error {
	return autoConvert_v1_ResourceQuotaSpec_To_api_ResourceQuotaSpec(in, out, s)
}

func autoConvert_api_ResourceQuotaSpec_To_v1_ResourceQuotaSpec(in *api.ResourceQuotaSpec, out *v1.ResourceQuotaSpec, s conversion.Scope) error {
	out.Hard = *(*v1.ResourceList)(unsafe.Pointer(&in.Hard))
	out.Scopes = *(*[]v1.ResourceQuotaScope)(unsafe.Pointer(&in.Scopes))
	return nil
}

// Convert_api_ResourceQuotaSpec_To_v1_ResourceQuotaSpec is an autogenerated conversion function.
func Convert_api_ResourceQuotaSpec_To_v1_ResourceQuotaSpec(in *api.ResourceQuotaSpec, out *v1.ResourceQuotaSpec, s conversion.Scope) error {
	return autoConvert_api_ResourceQuotaSpec_To_v1_ResourceQuotaSpec(in, out, s)
}

func autoConvert_v1_ResourceQuotaStatus_To_api_ResourceQuotaStatus(in *v1.ResourceQuotaStatus, out *api.ResourceQuotaStatus, s conversion.Scope) error {
	out.Hard = *(*api.ResourceList)(unsafe.Pointer(&in.Hard))
	out.Used = *(*api.ResourceList)(unsafe.Pointer(&in.Used))
	return nil
}

// Convert_v1_ResourceQuotaStatus_To_api_ResourceQuotaStatus is an autogenerated conversion function.
func Convert_v1_ResourceQuotaStatus_To_api_ResourceQuotaStatus(in *v1.ResourceQuotaStatus, out *api.ResourceQuotaStatus, s conversion.Scope) error {
	return autoConvert_v1_ResourceQuotaStatus_To_api_ResourceQuotaStatus(in, out, s)
}

func autoConvert_api_ResourceQuotaStatus_To_v1_ResourceQuotaStatus(in *api.ResourceQuotaStatus, out *v1.ResourceQuotaStatus, s conversion.Scope) error {
	out.Hard = *(*v1.ResourceList)(unsafe.Pointer(&in.Hard))
	out.Used = *(*v1.ResourceList)(unsafe.Pointer(&in.Used))
	return nil
}

// Convert_api_ResourceQuotaStatus_To_v1_ResourceQuotaStatus is an autogenerated conversion function.
func Convert_api_ResourceQuotaStatus_To_v1_ResourceQuotaStatus(in *api.ResourceQuotaStatus, out *v1.ResourceQuotaStatus, s conversion.Scope) error {
	return autoConvert_api_ResourceQuotaStatus_To_v1_ResourceQuotaStatus(in, out, s)
}

func autoConvert_v1_ResourceRequirements_To_api_ResourceRequirements(in *v1.ResourceRequirements, out *api.ResourceRequirements, s conversion.Scope) error {
	out.Limits = *(*api.ResourceList)(unsafe.Pointer(&in.Limits))
	out.Requests = *(*api.ResourceList)(unsafe.Pointer(&in.Requests))
	return nil
}

// Convert_v1_ResourceRequirements_To_api_ResourceRequirements is an autogenerated conversion function.
func Convert_v1_ResourceRequirements_To_api_ResourceRequirements(in *v1.ResourceRequirements, out *api.ResourceRequirements, s conversion.Scope) error {
	return autoConvert_v1_ResourceRequirements_To_api_ResourceRequirements(in, out, s)
}

func autoConvert_api_ResourceRequirements_To_v1_ResourceRequirements(in *api.ResourceRequirements, out *v1.ResourceRequirements, s conversion.Scope) error {
	out.Limits = *(*v1.ResourceList)(unsafe.Pointer(&in.Limits))
	out.Requests = *(*v1.ResourceList)(unsafe.Pointer(&in.Requests))
	return nil
}

// Convert_api_ResourceRequirements_To_v1_ResourceRequirements is an autogenerated conversion function.
func Convert_api_ResourceRequirements_To_v1_ResourceRequirements(in *api.ResourceRequirements, out *v1.ResourceRequirements, s conversion.Scope) error {
	return autoConvert_api_ResourceRequirements_To_v1_ResourceRequirements(in, out, s)
}

func autoConvert_v1_SELinuxOptions_To_api_SELinuxOptions(in *v1.SELinuxOptions, out *api.SELinuxOptions, s conversion.Scope) error {
	out.User = in.User
	out.Role = in.Role
	out.Type = in.Type
	out.Level = in.Level
	return nil
}

// Convert_v1_SELinuxOptions_To_api_SELinuxOptions is an autogenerated conversion function.
func Convert_v1_SELinuxOptions_To_api_SELinuxOptions(in *v1.SELinuxOptions, out *api.SELinuxOptions, s conversion.Scope) error {
	return autoConvert_v1_SELinuxOptions_To_api_SELinuxOptions(in, out, s)
}

func autoConvert_api_SELinuxOptions_To_v1_SELinuxOptions(in *api.SELinuxOptions, out *v1.SELinuxOptions, s conversion.Scope) error {
	out.User = in.User
	out.Role = in.Role
	out.Type = in.Type
	out.Level = in.Level
	return nil
}

// Convert_api_SELinuxOptions_To_v1_SELinuxOptions is an autogenerated conversion function.
func Convert_api_SELinuxOptions_To_v1_SELinuxOptions(in *api.SELinuxOptions, out *v1.SELinuxOptions, s conversion.Scope) error {
	return autoConvert_api_SELinuxOptions_To_v1_SELinuxOptions(in, out, s)
}

func autoConvert_v1_ScaleIOVolumeSource_To_api_ScaleIOVolumeSource(in *v1.ScaleIOVolumeSource, out *api.ScaleIOVolumeSource, s conversion.Scope) error {
	out.Gateway = in.Gateway
	out.System = in.System
	out.SecretRef = (*api.LocalObjectReference)(unsafe.Pointer(in.SecretRef))
	out.SSLEnabled = in.SSLEnabled
	out.ProtectionDomain = in.ProtectionDomain
	out.StoragePool = in.StoragePool
	out.StorageMode = in.StorageMode
	out.VolumeName = in.VolumeName
	out.FSType = in.FSType
	out.ReadOnly = in.ReadOnly
	return nil
}

// Convert_v1_ScaleIOVolumeSource_To_api_ScaleIOVolumeSource is an autogenerated conversion function.
func Convert_v1_ScaleIOVolumeSource_To_api_ScaleIOVolumeSource(in *v1.ScaleIOVolumeSource, out *api.ScaleIOVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_ScaleIOVolumeSource_To_api_ScaleIOVolumeSource(in, out, s)
}

func autoConvert_api_ScaleIOVolumeSource_To_v1_ScaleIOVolumeSource(in *api.ScaleIOVolumeSource, out *v1.ScaleIOVolumeSource, s conversion.Scope) error {
	out.Gateway = in.Gateway
	out.System = in.System
	out.SecretRef = (*v1.LocalObjectReference)(unsafe.Pointer(in.SecretRef))
	out.SSLEnabled = in.SSLEnabled
	out.ProtectionDomain = in.ProtectionDomain
	out.StoragePool = in.StoragePool
	out.StorageMode = in.StorageMode
	out.VolumeName = in.VolumeName
	out.FSType = in.FSType
	out.ReadOnly = in.ReadOnly
	return nil
}

// Convert_api_ScaleIOVolumeSource_To_v1_ScaleIOVolumeSource is an autogenerated conversion function.
func Convert_api_ScaleIOVolumeSource_To_v1_ScaleIOVolumeSource(in *api.ScaleIOVolumeSource, out *v1.ScaleIOVolumeSource, s conversion.Scope) error {
	return autoConvert_api_ScaleIOVolumeSource_To_v1_ScaleIOVolumeSource(in, out, s)
}

func autoConvert_v1_Secret_To_api_Secret(in *v1.Secret, out *api.Secret, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Data = *(*map[string][]byte)(unsafe.Pointer(&in.Data))
	// INFO: in.StringData opted out of conversion generation
	out.Type = api.SecretType(in.Type)
	return nil
}

func autoConvert_api_Secret_To_v1_Secret(in *api.Secret, out *v1.Secret, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Data = *(*map[string][]byte)(unsafe.Pointer(&in.Data))
	out.Type = v1.SecretType(in.Type)
	return nil
}

// Convert_api_Secret_To_v1_Secret is an autogenerated conversion function.
func Convert_api_Secret_To_v1_Secret(in *api.Secret, out *v1.Secret, s conversion.Scope) error {
	return autoConvert_api_Secret_To_v1_Secret(in, out, s)
}

func autoConvert_v1_SecretEnvSource_To_api_SecretEnvSource(in *v1.SecretEnvSource, out *api.SecretEnvSource, s conversion.Scope) error {
	if err := Convert_v1_LocalObjectReference_To_api_LocalObjectReference(&in.LocalObjectReference, &out.LocalObjectReference, s); err != nil {
		return err
	}
	out.Optional = (*bool)(unsafe.Pointer(in.Optional))
	return nil
}

// Convert_v1_SecretEnvSource_To_api_SecretEnvSource is an autogenerated conversion function.
func Convert_v1_SecretEnvSource_To_api_SecretEnvSource(in *v1.SecretEnvSource, out *api.SecretEnvSource, s conversion.Scope) error {
	return autoConvert_v1_SecretEnvSource_To_api_SecretEnvSource(in, out, s)
}

func autoConvert_api_SecretEnvSource_To_v1_SecretEnvSource(in *api.SecretEnvSource, out *v1.SecretEnvSource, s conversion.Scope) error {
	if err := Convert_api_LocalObjectReference_To_v1_LocalObjectReference(&in.LocalObjectReference, &out.LocalObjectReference, s); err != nil {
		return err
	}
	out.Optional = (*bool)(unsafe.Pointer(in.Optional))
	return nil
}

// Convert_api_SecretEnvSource_To_v1_SecretEnvSource is an autogenerated conversion function.
func Convert_api_SecretEnvSource_To_v1_SecretEnvSource(in *api.SecretEnvSource, out *v1.SecretEnvSource, s conversion.Scope) error {
	return autoConvert_api_SecretEnvSource_To_v1_SecretEnvSource(in, out, s)
}

func autoConvert_v1_SecretKeySelector_To_api_SecretKeySelector(in *v1.SecretKeySelector, out *api.SecretKeySelector, s conversion.Scope) error {
	if err := Convert_v1_LocalObjectReference_To_api_LocalObjectReference(&in.LocalObjectReference, &out.LocalObjectReference, s); err != nil {
		return err
	}
	out.Key = in.Key
	out.Optional = (*bool)(unsafe.Pointer(in.Optional))
	return nil
}

// Convert_v1_SecretKeySelector_To_api_SecretKeySelector is an autogenerated conversion function.
func Convert_v1_SecretKeySelector_To_api_SecretKeySelector(in *v1.SecretKeySelector, out *api.SecretKeySelector, s conversion.Scope) error {
	return autoConvert_v1_SecretKeySelector_To_api_SecretKeySelector(in, out, s)
}

func autoConvert_api_SecretKeySelector_To_v1_SecretKeySelector(in *api.SecretKeySelector, out *v1.SecretKeySelector, s conversion.Scope) error {
	if err := Convert_api_LocalObjectReference_To_v1_LocalObjectReference(&in.LocalObjectReference, &out.LocalObjectReference, s); err != nil {
		return err
	}
	out.Key = in.Key
	out.Optional = (*bool)(unsafe.Pointer(in.Optional))
	return nil
}

// Convert_api_SecretKeySelector_To_v1_SecretKeySelector is an autogenerated conversion function.
func Convert_api_SecretKeySelector_To_v1_SecretKeySelector(in *api.SecretKeySelector, out *v1.SecretKeySelector, s conversion.Scope) error {
	return autoConvert_api_SecretKeySelector_To_v1_SecretKeySelector(in, out, s)
}

func autoConvert_v1_SecretList_To_api_SecretList(in *v1.SecretList, out *api.SecretList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]api.Secret, len(*in))
		for i := range *in {
			if err := Convert_v1_Secret_To_api_Secret(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_SecretList_To_api_SecretList is an autogenerated conversion function.
func Convert_v1_SecretList_To_api_SecretList(in *v1.SecretList, out *api.SecretList, s conversion.Scope) error {
	return autoConvert_v1_SecretList_To_api_SecretList(in, out, s)
}

func autoConvert_api_SecretList_To_v1_SecretList(in *api.SecretList, out *v1.SecretList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1.Secret, len(*in))
		for i := range *in {
			if err := Convert_api_Secret_To_v1_Secret(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_api_SecretList_To_v1_SecretList is an autogenerated conversion function.
func Convert_api_SecretList_To_v1_SecretList(in *api.SecretList, out *v1.SecretList, s conversion.Scope) error {
	return autoConvert_api_SecretList_To_v1_SecretList(in, out, s)
}

func autoConvert_v1_SecretProjection_To_api_SecretProjection(in *v1.SecretProjection, out *api.SecretProjection, s conversion.Scope) error {
	if err := Convert_v1_LocalObjectReference_To_api_LocalObjectReference(&in.LocalObjectReference, &out.LocalObjectReference, s); err != nil {
		return err
	}
	out.Items = *(*[]api.KeyToPath)(unsafe.Pointer(&in.Items))
	out.Optional = (*bool)(unsafe.Pointer(in.Optional))
	return nil
}

// Convert_v1_SecretProjection_To_api_SecretProjection is an autogenerated conversion function.
func Convert_v1_SecretProjection_To_api_SecretProjection(in *v1.SecretProjection, out *api.SecretProjection, s conversion.Scope) error {
	return autoConvert_v1_SecretProjection_To_api_SecretProjection(in, out, s)
}

func autoConvert_api_SecretProjection_To_v1_SecretProjection(in *api.SecretProjection, out *v1.SecretProjection, s conversion.Scope) error {
	if err := Convert_api_LocalObjectReference_To_v1_LocalObjectReference(&in.LocalObjectReference, &out.LocalObjectReference, s); err != nil {
		return err
	}
	out.Items = *(*[]v1.KeyToPath)(unsafe.Pointer(&in.Items))
	out.Optional = (*bool)(unsafe.Pointer(in.Optional))
	return nil
}

// Convert_api_SecretProjection_To_v1_SecretProjection is an autogenerated conversion function.
func Convert_api_SecretProjection_To_v1_SecretProjection(in *api.SecretProjection, out *v1.SecretProjection, s conversion.Scope) error {
	return autoConvert_api_SecretProjection_To_v1_SecretProjection(in, out, s)
}

func autoConvert_v1_SecretReference_To_api_SecretReference(in *v1.SecretReference, out *api.SecretReference, s conversion.Scope) error {
	out.Name = in.Name
	out.Namespace = in.Namespace
	return nil
}

// Convert_v1_SecretReference_To_api_SecretReference is an autogenerated conversion function.
func Convert_v1_SecretReference_To_api_SecretReference(in *v1.SecretReference, out *api.SecretReference, s conversion.Scope) error {
	return autoConvert_v1_SecretReference_To_api_SecretReference(in, out, s)
}

func autoConvert_api_SecretReference_To_v1_SecretReference(in *api.SecretReference, out *v1.SecretReference, s conversion.Scope) error {
	out.Name = in.Name
	out.Namespace = in.Namespace
	return nil
}

// Convert_api_SecretReference_To_v1_SecretReference is an autogenerated conversion function.
func Convert_api_SecretReference_To_v1_SecretReference(in *api.SecretReference, out *v1.SecretReference, s conversion.Scope) error {
	return autoConvert_api_SecretReference_To_v1_SecretReference(in, out, s)
}

func autoConvert_v1_SecretVolumeSource_To_api_SecretVolumeSource(in *v1.SecretVolumeSource, out *api.SecretVolumeSource, s conversion.Scope) error {
	out.SecretName = in.SecretName
	out.Items = *(*[]api.KeyToPath)(unsafe.Pointer(&in.Items))
	out.DefaultMode = (*int32)(unsafe.Pointer(in.DefaultMode))
	out.Optional = (*bool)(unsafe.Pointer(in.Optional))
	return nil
}

// Convert_v1_SecretVolumeSource_To_api_SecretVolumeSource is an autogenerated conversion function.
func Convert_v1_SecretVolumeSource_To_api_SecretVolumeSource(in *v1.SecretVolumeSource, out *api.SecretVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_SecretVolumeSource_To_api_SecretVolumeSource(in, out, s)
}

func autoConvert_api_SecretVolumeSource_To_v1_SecretVolumeSource(in *api.SecretVolumeSource, out *v1.SecretVolumeSource, s conversion.Scope) error {
	out.SecretName = in.SecretName
	out.Items = *(*[]v1.KeyToPath)(unsafe.Pointer(&in.Items))
	out.DefaultMode = (*int32)(unsafe.Pointer(in.DefaultMode))
	out.Optional = (*bool)(unsafe.Pointer(in.Optional))
	return nil
}

// Convert_api_SecretVolumeSource_To_v1_SecretVolumeSource is an autogenerated conversion function.
func Convert_api_SecretVolumeSource_To_v1_SecretVolumeSource(in *api.SecretVolumeSource, out *v1.SecretVolumeSource, s conversion.Scope) error {
	return autoConvert_api_SecretVolumeSource_To_v1_SecretVolumeSource(in, out, s)
}

func autoConvert_v1_SecurityContext_To_api_SecurityContext(in *v1.SecurityContext, out *api.SecurityContext, s conversion.Scope) error {
	out.Capabilities = (*api.Capabilities)(unsafe.Pointer(in.Capabilities))
	out.Privileged = (*bool)(unsafe.Pointer(in.Privileged))
	out.SELinuxOptions = (*api.SELinuxOptions)(unsafe.Pointer(in.SELinuxOptions))
	out.RunAsUser = (*int64)(unsafe.Pointer(in.RunAsUser))
	out.RunAsNonRoot = (*bool)(unsafe.Pointer(in.RunAsNonRoot))
	out.ReadOnlyRootFilesystem = (*bool)(unsafe.Pointer(in.ReadOnlyRootFilesystem))
	out.AllowPrivilegeEscalation = (*bool)(unsafe.Pointer(in.AllowPrivilegeEscalation))
	return nil
}

// Convert_v1_SecurityContext_To_api_SecurityContext is an autogenerated conversion function.
func Convert_v1_SecurityContext_To_api_SecurityContext(in *v1.SecurityContext, out *api.SecurityContext, s conversion.Scope) error {
	return autoConvert_v1_SecurityContext_To_api_SecurityContext(in, out, s)
}

func autoConvert_api_SecurityContext_To_v1_SecurityContext(in *api.SecurityContext, out *v1.SecurityContext, s conversion.Scope) error {
	out.Capabilities = (*v1.Capabilities)(unsafe.Pointer(in.Capabilities))
	out.Privileged = (*bool)(unsafe.Pointer(in.Privileged))
	out.SELinuxOptions = (*v1.SELinuxOptions)(unsafe.Pointer(in.SELinuxOptions))
	out.RunAsUser = (*int64)(unsafe.Pointer(in.RunAsUser))
	out.RunAsNonRoot = (*bool)(unsafe.Pointer(in.RunAsNonRoot))
	out.ReadOnlyRootFilesystem = (*bool)(unsafe.Pointer(in.ReadOnlyRootFilesystem))
	out.AllowPrivilegeEscalation = (*bool)(unsafe.Pointer(in.AllowPrivilegeEscalation))
	return nil
}

func autoConvert_v1_SerializedReference_To_api_SerializedReference(in *v1.SerializedReference, out *api.SerializedReference, s conversion.Scope) error {
	if err := Convert_v1_ObjectReference_To_api_ObjectReference(&in.Reference, &out.Reference, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_SerializedReference_To_api_SerializedReference is an autogenerated conversion function.
func Convert_v1_SerializedReference_To_api_SerializedReference(in *v1.SerializedReference, out *api.SerializedReference, s conversion.Scope) error {
	return autoConvert_v1_SerializedReference_To_api_SerializedReference(in, out, s)
}

func autoConvert_api_SerializedReference_To_v1_SerializedReference(in *api.SerializedReference, out *v1.SerializedReference, s conversion.Scope) error {
	if err := Convert_api_ObjectReference_To_v1_ObjectReference(&in.Reference, &out.Reference, s); err != nil {
		return err
	}
	return nil
}

// Convert_api_SerializedReference_To_v1_SerializedReference is an autogenerated conversion function.
func Convert_api_SerializedReference_To_v1_SerializedReference(in *api.SerializedReference, out *v1.SerializedReference, s conversion.Scope) error {
	return autoConvert_api_SerializedReference_To_v1_SerializedReference(in, out, s)
}

func autoConvert_v1_Service_To_api_Service(in *v1.Service, out *api.Service, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_ServiceSpec_To_api_ServiceSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_ServiceStatus_To_api_ServiceStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_Service_To_api_Service is an autogenerated conversion function.
func Convert_v1_Service_To_api_Service(in *v1.Service, out *api.Service, s conversion.Scope) error {
	return autoConvert_v1_Service_To_api_Service(in, out, s)
}

func autoConvert_api_Service_To_v1_Service(in *api.Service, out *v1.Service, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_api_ServiceSpec_To_v1_ServiceSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_api_ServiceStatus_To_v1_ServiceStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_api_Service_To_v1_Service is an autogenerated conversion function.
func Convert_api_Service_To_v1_Service(in *api.Service, out *v1.Service, s conversion.Scope) error {
	return autoConvert_api_Service_To_v1_Service(in, out, s)
}

func autoConvert_v1_ServiceAccount_To_api_ServiceAccount(in *v1.ServiceAccount, out *api.ServiceAccount, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Secrets = *(*[]api.ObjectReference)(unsafe.Pointer(&in.Secrets))
	out.ImagePullSecrets = *(*[]api.LocalObjectReference)(unsafe.Pointer(&in.ImagePullSecrets))
	out.AutomountServiceAccountToken = (*bool)(unsafe.Pointer(in.AutomountServiceAccountToken))
	return nil
}

// Convert_v1_ServiceAccount_To_api_ServiceAccount is an autogenerated conversion function.
func Convert_v1_ServiceAccount_To_api_ServiceAccount(in *v1.ServiceAccount, out *api.ServiceAccount, s conversion.Scope) error {
	return autoConvert_v1_ServiceAccount_To_api_ServiceAccount(in, out, s)
}

func autoConvert_api_ServiceAccount_To_v1_ServiceAccount(in *api.ServiceAccount, out *v1.ServiceAccount, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Secrets = *(*[]v1.ObjectReference)(unsafe.Pointer(&in.Secrets))
	out.ImagePullSecrets = *(*[]v1.LocalObjectReference)(unsafe.Pointer(&in.ImagePullSecrets))
	out.AutomountServiceAccountToken = (*bool)(unsafe.Pointer(in.AutomountServiceAccountToken))
	return nil
}

// Convert_api_ServiceAccount_To_v1_ServiceAccount is an autogenerated conversion function.
func Convert_api_ServiceAccount_To_v1_ServiceAccount(in *api.ServiceAccount, out *v1.ServiceAccount, s conversion.Scope) error {
	return autoConvert_api_ServiceAccount_To_v1_ServiceAccount(in, out, s)
}

func autoConvert_v1_ServiceAccountList_To_api_ServiceAccountList(in *v1.ServiceAccountList, out *api.ServiceAccountList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]api.ServiceAccount)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1_ServiceAccountList_To_api_ServiceAccountList is an autogenerated conversion function.
func Convert_v1_ServiceAccountList_To_api_ServiceAccountList(in *v1.ServiceAccountList, out *api.ServiceAccountList, s conversion.Scope) error {
	return autoConvert_v1_ServiceAccountList_To_api_ServiceAccountList(in, out, s)
}

func autoConvert_api_ServiceAccountList_To_v1_ServiceAccountList(in *api.ServiceAccountList, out *v1.ServiceAccountList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1.ServiceAccount)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_api_ServiceAccountList_To_v1_ServiceAccountList is an autogenerated conversion function.
func Convert_api_ServiceAccountList_To_v1_ServiceAccountList(in *api.ServiceAccountList, out *v1.ServiceAccountList, s conversion.Scope) error {
	return autoConvert_api_ServiceAccountList_To_v1_ServiceAccountList(in, out, s)
}

func autoConvert_v1_ServiceList_To_api_ServiceList(in *v1.ServiceList, out *api.ServiceList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]api.Service, len(*in))
		for i := range *in {
			if err := Convert_v1_Service_To_api_Service(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_ServiceList_To_api_ServiceList is an autogenerated conversion function.
func Convert_v1_ServiceList_To_api_ServiceList(in *v1.ServiceList, out *api.ServiceList, s conversion.Scope) error {
	return autoConvert_v1_ServiceList_To_api_ServiceList(in, out, s)
}

func autoConvert_api_ServiceList_To_v1_ServiceList(in *api.ServiceList, out *v1.ServiceList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1.Service, len(*in))
		for i := range *in {
			if err := Convert_api_Service_To_v1_Service(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_api_ServiceList_To_v1_ServiceList is an autogenerated conversion function.
func Convert_api_ServiceList_To_v1_ServiceList(in *api.ServiceList, out *v1.ServiceList, s conversion.Scope) error {
	return autoConvert_api_ServiceList_To_v1_ServiceList(in, out, s)
}

func autoConvert_v1_ServicePort_To_api_ServicePort(in *v1.ServicePort, out *api.ServicePort, s conversion.Scope) error {
	out.Name = in.Name
	out.Protocol = api.Protocol(in.Protocol)
	out.Port = in.Port
	out.TargetPort = in.TargetPort
	out.NodePort = in.NodePort
	return nil
}

// Convert_v1_ServicePort_To_api_ServicePort is an autogenerated conversion function.
func Convert_v1_ServicePort_To_api_ServicePort(in *v1.ServicePort, out *api.ServicePort, s conversion.Scope) error {
	return autoConvert_v1_ServicePort_To_api_ServicePort(in, out, s)
}

func autoConvert_api_ServicePort_To_v1_ServicePort(in *api.ServicePort, out *v1.ServicePort, s conversion.Scope) error {
	out.Name = in.Name
	out.Protocol = v1.Protocol(in.Protocol)
	out.Port = in.Port
	out.TargetPort = in.TargetPort
	out.NodePort = in.NodePort
	return nil
}

// Convert_api_ServicePort_To_v1_ServicePort is an autogenerated conversion function.
func Convert_api_ServicePort_To_v1_ServicePort(in *api.ServicePort, out *v1.ServicePort, s conversion.Scope) error {
	return autoConvert_api_ServicePort_To_v1_ServicePort(in, out, s)
}

func autoConvert_v1_ServiceProxyOptions_To_api_ServiceProxyOptions(in *v1.ServiceProxyOptions, out *api.ServiceProxyOptions, s conversion.Scope) error {
	out.Path = in.Path
	return nil
}

// Convert_v1_ServiceProxyOptions_To_api_ServiceProxyOptions is an autogenerated conversion function.
func Convert_v1_ServiceProxyOptions_To_api_ServiceProxyOptions(in *v1.ServiceProxyOptions, out *api.ServiceProxyOptions, s conversion.Scope) error {
	return autoConvert_v1_ServiceProxyOptions_To_api_ServiceProxyOptions(in, out, s)
}

func autoConvert_api_ServiceProxyOptions_To_v1_ServiceProxyOptions(in *api.ServiceProxyOptions, out *v1.ServiceProxyOptions, s conversion.Scope) error {
	out.Path = in.Path
	return nil
}

// Convert_api_ServiceProxyOptions_To_v1_ServiceProxyOptions is an autogenerated conversion function.
func Convert_api_ServiceProxyOptions_To_v1_ServiceProxyOptions(in *api.ServiceProxyOptions, out *v1.ServiceProxyOptions, s conversion.Scope) error {
	return autoConvert_api_ServiceProxyOptions_To_v1_ServiceProxyOptions(in, out, s)
}

func autoConvert_v1_ServiceSpec_To_api_ServiceSpec(in *v1.ServiceSpec, out *api.ServiceSpec, s conversion.Scope) error {
	out.Ports = *(*[]api.ServicePort)(unsafe.Pointer(&in.Ports))
	out.Selector = *(*map[string]string)(unsafe.Pointer(&in.Selector))
	out.ClusterIP = in.ClusterIP
	out.Type = api.ServiceType(in.Type)
	out.ExternalIPs = *(*[]string)(unsafe.Pointer(&in.ExternalIPs))
	out.SessionAffinity = api.ServiceAffinity(in.SessionAffinity)
	out.LoadBalancerIP = in.LoadBalancerIP
	out.LoadBalancerSourceRanges = *(*[]string)(unsafe.Pointer(&in.LoadBalancerSourceRanges))
	out.ExternalName = in.ExternalName
	out.ExternalTrafficPolicy = api.ServiceExternalTrafficPolicyType(in.ExternalTrafficPolicy)
	out.HealthCheckNodePort = in.HealthCheckNodePort
	out.PublishNotReadyAddresses = in.PublishNotReadyAddresses
	out.SessionAffinityConfig = (*api.SessionAffinityConfig)(unsafe.Pointer(in.SessionAffinityConfig))
	return nil
}

// Convert_v1_ServiceSpec_To_api_ServiceSpec is an autogenerated conversion function.
func Convert_v1_ServiceSpec_To_api_ServiceSpec(in *v1.ServiceSpec, out *api.ServiceSpec, s conversion.Scope) error {
	return autoConvert_v1_ServiceSpec_To_api_ServiceSpec(in, out, s)
}

func autoConvert_api_ServiceSpec_To_v1_ServiceSpec(in *api.ServiceSpec, out *v1.ServiceSpec, s conversion.Scope) error {
	out.Type = v1.ServiceType(in.Type)
	out.Ports = *(*[]v1.ServicePort)(unsafe.Pointer(&in.Ports))
	out.Selector = *(*map[string]string)(unsafe.Pointer(&in.Selector))
	out.ClusterIP = in.ClusterIP
	out.ExternalName = in.ExternalName
	out.ExternalIPs = *(*[]string)(unsafe.Pointer(&in.ExternalIPs))
	out.LoadBalancerIP = in.LoadBalancerIP
	out.SessionAffinity = v1.ServiceAffinity(in.SessionAffinity)
	out.SessionAffinityConfig = (*v1.SessionAffinityConfig)(unsafe.Pointer(in.SessionAffinityConfig))
	out.LoadBalancerSourceRanges = *(*[]string)(unsafe.Pointer(&in.LoadBalancerSourceRanges))
	out.ExternalTrafficPolicy = v1.ServiceExternalTrafficPolicyType(in.ExternalTrafficPolicy)
	out.HealthCheckNodePort = in.HealthCheckNodePort
	out.PublishNotReadyAddresses = in.PublishNotReadyAddresses
	return nil
}

// Convert_api_ServiceSpec_To_v1_ServiceSpec is an autogenerated conversion function.
func Convert_api_ServiceSpec_To_v1_ServiceSpec(in *api.ServiceSpec, out *v1.ServiceSpec, s conversion.Scope) error {
	return autoConvert_api_ServiceSpec_To_v1_ServiceSpec(in, out, s)
}

func autoConvert_v1_ServiceStatus_To_api_ServiceStatus(in *v1.ServiceStatus, out *api.ServiceStatus, s conversion.Scope) error {
	if err := Convert_v1_LoadBalancerStatus_To_api_LoadBalancerStatus(&in.LoadBalancer, &out.LoadBalancer, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ServiceStatus_To_api_ServiceStatus is an autogenerated conversion function.
func Convert_v1_ServiceStatus_To_api_ServiceStatus(in *v1.ServiceStatus, out *api.ServiceStatus, s conversion.Scope) error {
	return autoConvert_v1_ServiceStatus_To_api_ServiceStatus(in, out, s)
}

func autoConvert_api_ServiceStatus_To_v1_ServiceStatus(in *api.ServiceStatus, out *v1.ServiceStatus, s conversion.Scope) error {
	if err := Convert_api_LoadBalancerStatus_To_v1_LoadBalancerStatus(&in.LoadBalancer, &out.LoadBalancer, s); err != nil {
		return err
	}
	return nil
}

// Convert_api_ServiceStatus_To_v1_ServiceStatus is an autogenerated conversion function.
func Convert_api_ServiceStatus_To_v1_ServiceStatus(in *api.ServiceStatus, out *v1.ServiceStatus, s conversion.Scope) error {
	return autoConvert_api_ServiceStatus_To_v1_ServiceStatus(in, out, s)
}

func autoConvert_v1_SessionAffinityConfig_To_api_SessionAffinityConfig(in *v1.SessionAffinityConfig, out *api.SessionAffinityConfig, s conversion.Scope) error {
	out.ClientIP = (*api.ClientIPConfig)(unsafe.Pointer(in.ClientIP))
	return nil
}

// Convert_v1_SessionAffinityConfig_To_api_SessionAffinityConfig is an autogenerated conversion function.
func Convert_v1_SessionAffinityConfig_To_api_SessionAffinityConfig(in *v1.SessionAffinityConfig, out *api.SessionAffinityConfig, s conversion.Scope) error {
	return autoConvert_v1_SessionAffinityConfig_To_api_SessionAffinityConfig(in, out, s)
}

func autoConvert_api_SessionAffinityConfig_To_v1_SessionAffinityConfig(in *api.SessionAffinityConfig, out *v1.SessionAffinityConfig, s conversion.Scope) error {
	out.ClientIP = (*v1.ClientIPConfig)(unsafe.Pointer(in.ClientIP))
	return nil
}

// Convert_api_SessionAffinityConfig_To_v1_SessionAffinityConfig is an autogenerated conversion function.
func Convert_api_SessionAffinityConfig_To_v1_SessionAffinityConfig(in *api.SessionAffinityConfig, out *v1.SessionAffinityConfig, s conversion.Scope) error {
	return autoConvert_api_SessionAffinityConfig_To_v1_SessionAffinityConfig(in, out, s)
}

func autoConvert_v1_StorageOSPersistentVolumeSource_To_api_StorageOSPersistentVolumeSource(in *v1.StorageOSPersistentVolumeSource, out *api.StorageOSPersistentVolumeSource, s conversion.Scope) error {
	out.VolumeName = in.VolumeName
	out.VolumeNamespace = in.VolumeNamespace
	out.FSType = in.FSType
	out.ReadOnly = in.ReadOnly
	out.SecretRef = (*api.ObjectReference)(unsafe.Pointer(in.SecretRef))
	return nil
}

// Convert_v1_StorageOSPersistentVolumeSource_To_api_StorageOSPersistentVolumeSource is an autogenerated conversion function.
func Convert_v1_StorageOSPersistentVolumeSource_To_api_StorageOSPersistentVolumeSource(in *v1.StorageOSPersistentVolumeSource, out *api.StorageOSPersistentVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_StorageOSPersistentVolumeSource_To_api_StorageOSPersistentVolumeSource(in, out, s)
}

func autoConvert_api_StorageOSPersistentVolumeSource_To_v1_StorageOSPersistentVolumeSource(in *api.StorageOSPersistentVolumeSource, out *v1.StorageOSPersistentVolumeSource, s conversion.Scope) error {
	out.VolumeName = in.VolumeName
	out.VolumeNamespace = in.VolumeNamespace
	out.FSType = in.FSType
	out.ReadOnly = in.ReadOnly
	out.SecretRef = (*v1.ObjectReference)(unsafe.Pointer(in.SecretRef))
	return nil
}

// Convert_api_StorageOSPersistentVolumeSource_To_v1_StorageOSPersistentVolumeSource is an autogenerated conversion function.
func Convert_api_StorageOSPersistentVolumeSource_To_v1_StorageOSPersistentVolumeSource(in *api.StorageOSPersistentVolumeSource, out *v1.StorageOSPersistentVolumeSource, s conversion.Scope) error {
	return autoConvert_api_StorageOSPersistentVolumeSource_To_v1_StorageOSPersistentVolumeSource(in, out, s)
}

func autoConvert_v1_StorageOSVolumeSource_To_api_StorageOSVolumeSource(in *v1.StorageOSVolumeSource, out *api.StorageOSVolumeSource, s conversion.Scope) error {
	out.VolumeName = in.VolumeName
	out.VolumeNamespace = in.VolumeNamespace
	out.FSType = in.FSType
	out.ReadOnly = in.ReadOnly
	out.SecretRef = (*api.LocalObjectReference)(unsafe.Pointer(in.SecretRef))
	return nil
}

// Convert_v1_StorageOSVolumeSource_To_api_StorageOSVolumeSource is an autogenerated conversion function.
func Convert_v1_StorageOSVolumeSource_To_api_StorageOSVolumeSource(in *v1.StorageOSVolumeSource, out *api.StorageOSVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_StorageOSVolumeSource_To_api_StorageOSVolumeSource(in, out, s)
}

func autoConvert_api_StorageOSVolumeSource_To_v1_StorageOSVolumeSource(in *api.StorageOSVolumeSource, out *v1.StorageOSVolumeSource, s conversion.Scope) error {
	out.VolumeName = in.VolumeName
	out.VolumeNamespace = in.VolumeNamespace
	out.FSType = in.FSType
	out.ReadOnly = in.ReadOnly
	out.SecretRef = (*v1.LocalObjectReference)(unsafe.Pointer(in.SecretRef))
	return nil
}

// Convert_api_StorageOSVolumeSource_To_v1_StorageOSVolumeSource is an autogenerated conversion function.
func Convert_api_StorageOSVolumeSource_To_v1_StorageOSVolumeSource(in *api.StorageOSVolumeSource, out *v1.StorageOSVolumeSource, s conversion.Scope) error {
	return autoConvert_api_StorageOSVolumeSource_To_v1_StorageOSVolumeSource(in, out, s)
}

func autoConvert_v1_Sysctl_To_api_Sysctl(in *v1.Sysctl, out *api.Sysctl, s conversion.Scope) error {
	out.Name = in.Name
	out.Value = in.Value
	return nil
}

// Convert_v1_Sysctl_To_api_Sysctl is an autogenerated conversion function.
func Convert_v1_Sysctl_To_api_Sysctl(in *v1.Sysctl, out *api.Sysctl, s conversion.Scope) error {
	return autoConvert_v1_Sysctl_To_api_Sysctl(in, out, s)
}

func autoConvert_api_Sysctl_To_v1_Sysctl(in *api.Sysctl, out *v1.Sysctl, s conversion.Scope) error {
	out.Name = in.Name
	out.Value = in.Value
	return nil
}

// Convert_api_Sysctl_To_v1_Sysctl is an autogenerated conversion function.
func Convert_api_Sysctl_To_v1_Sysctl(in *api.Sysctl, out *v1.Sysctl, s conversion.Scope) error {
	return autoConvert_api_Sysctl_To_v1_Sysctl(in, out, s)
}

func autoConvert_v1_TCPSocketAction_To_api_TCPSocketAction(in *v1.TCPSocketAction, out *api.TCPSocketAction, s conversion.Scope) error {
	out.Port = in.Port
	out.Host = in.Host
	return nil
}

// Convert_v1_TCPSocketAction_To_api_TCPSocketAction is an autogenerated conversion function.
func Convert_v1_TCPSocketAction_To_api_TCPSocketAction(in *v1.TCPSocketAction, out *api.TCPSocketAction, s conversion.Scope) error {
	return autoConvert_v1_TCPSocketAction_To_api_TCPSocketAction(in, out, s)
}

func autoConvert_api_TCPSocketAction_To_v1_TCPSocketAction(in *api.TCPSocketAction, out *v1.TCPSocketAction, s conversion.Scope) error {
	out.Port = in.Port
	out.Host = in.Host
	return nil
}

// Convert_api_TCPSocketAction_To_v1_TCPSocketAction is an autogenerated conversion function.
func Convert_api_TCPSocketAction_To_v1_TCPSocketAction(in *api.TCPSocketAction, out *v1.TCPSocketAction, s conversion.Scope) error {
	return autoConvert_api_TCPSocketAction_To_v1_TCPSocketAction(in, out, s)
}

func autoConvert_v1_Taint_To_api_Taint(in *v1.Taint, out *api.Taint, s conversion.Scope) error {
	out.Key = in.Key
	out.Value = in.Value
	out.Effect = api.TaintEffect(in.Effect)
	out.TimeAdded = in.TimeAdded
	return nil
}

// Convert_v1_Taint_To_api_Taint is an autogenerated conversion function.
func Convert_v1_Taint_To_api_Taint(in *v1.Taint, out *api.Taint, s conversion.Scope) error {
	return autoConvert_v1_Taint_To_api_Taint(in, out, s)
}

func autoConvert_api_Taint_To_v1_Taint(in *api.Taint, out *v1.Taint, s conversion.Scope) error {
	out.Key = in.Key
	out.Value = in.Value
	out.Effect = v1.TaintEffect(in.Effect)
	out.TimeAdded = in.TimeAdded
	return nil
}

// Convert_api_Taint_To_v1_Taint is an autogenerated conversion function.
func Convert_api_Taint_To_v1_Taint(in *api.Taint, out *v1.Taint, s conversion.Scope) error {
	return autoConvert_api_Taint_To_v1_Taint(in, out, s)
}

func autoConvert_v1_Toleration_To_api_Toleration(in *v1.Toleration, out *api.Toleration, s conversion.Scope) error {
	out.Key = in.Key
	out.Operator = api.TolerationOperator(in.Operator)
	out.Value = in.Value
	out.Effect = api.TaintEffect(in.Effect)
	out.TolerationSeconds = (*int64)(unsafe.Pointer(in.TolerationSeconds))
	return nil
}

// Convert_v1_Toleration_To_api_Toleration is an autogenerated conversion function.
func Convert_v1_Toleration_To_api_Toleration(in *v1.Toleration, out *api.Toleration, s conversion.Scope) error {
	return autoConvert_v1_Toleration_To_api_Toleration(in, out, s)
}

func autoConvert_api_Toleration_To_v1_Toleration(in *api.Toleration, out *v1.Toleration, s conversion.Scope) error {
	out.Key = in.Key
	out.Operator = v1.TolerationOperator(in.Operator)
	out.Value = in.Value
	out.Effect = v1.TaintEffect(in.Effect)
	out.TolerationSeconds = (*int64)(unsafe.Pointer(in.TolerationSeconds))
	return nil
}

// Convert_api_Toleration_To_v1_Toleration is an autogenerated conversion function.
func Convert_api_Toleration_To_v1_Toleration(in *api.Toleration, out *v1.Toleration, s conversion.Scope) error {
	return autoConvert_api_Toleration_To_v1_Toleration(in, out, s)
}

func autoConvert_v1_Volume_To_api_Volume(in *v1.Volume, out *api.Volume, s conversion.Scope) error {
	out.Name = in.Name
	if err := Convert_v1_VolumeSource_To_api_VolumeSource(&in.VolumeSource, &out.VolumeSource, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_Volume_To_api_Volume is an autogenerated conversion function.
func Convert_v1_Volume_To_api_Volume(in *v1.Volume, out *api.Volume, s conversion.Scope) error {
	return autoConvert_v1_Volume_To_api_Volume(in, out, s)
}

func autoConvert_api_Volume_To_v1_Volume(in *api.Volume, out *v1.Volume, s conversion.Scope) error {
	out.Name = in.Name
	if err := Convert_api_VolumeSource_To_v1_VolumeSource(&in.VolumeSource, &out.VolumeSource, s); err != nil {
		return err
	}
	return nil
}

// Convert_api_Volume_To_v1_Volume is an autogenerated conversion function.
func Convert_api_Volume_To_v1_Volume(in *api.Volume, out *v1.Volume, s conversion.Scope) error {
	return autoConvert_api_Volume_To_v1_Volume(in, out, s)
}

func autoConvert_v1_VolumeMount_To_api_VolumeMount(in *v1.VolumeMount, out *api.VolumeMount, s conversion.Scope) error {
	out.Name = in.Name
	out.ReadOnly = in.ReadOnly
	out.MountPath = in.MountPath
	out.SubPath = in.SubPath
	out.MountPropagation = (*api.MountPropagationMode)(unsafe.Pointer(in.MountPropagation))
	return nil
}

// Convert_v1_VolumeMount_To_api_VolumeMount is an autogenerated conversion function.
func Convert_v1_VolumeMount_To_api_VolumeMount(in *v1.VolumeMount, out *api.VolumeMount, s conversion.Scope) error {
	return autoConvert_v1_VolumeMount_To_api_VolumeMount(in, out, s)
}

func autoConvert_api_VolumeMount_To_v1_VolumeMount(in *api.VolumeMount, out *v1.VolumeMount, s conversion.Scope) error {
	out.Name = in.Name
	out.ReadOnly = in.ReadOnly
	out.MountPath = in.MountPath
	out.SubPath = in.SubPath
	out.MountPropagation = (*v1.MountPropagationMode)(unsafe.Pointer(in.MountPropagation))
	return nil
}

// Convert_api_VolumeMount_To_v1_VolumeMount is an autogenerated conversion function.
func Convert_api_VolumeMount_To_v1_VolumeMount(in *api.VolumeMount, out *v1.VolumeMount, s conversion.Scope) error {
	return autoConvert_api_VolumeMount_To_v1_VolumeMount(in, out, s)
}

func autoConvert_v1_VolumeProjection_To_api_VolumeProjection(in *v1.VolumeProjection, out *api.VolumeProjection, s conversion.Scope) error {
	out.Secret = (*api.SecretProjection)(unsafe.Pointer(in.Secret))
	out.DownwardAPI = (*api.DownwardAPIProjection)(unsafe.Pointer(in.DownwardAPI))
	out.ConfigMap = (*api.ConfigMapProjection)(unsafe.Pointer(in.ConfigMap))
	return nil
}

// Convert_v1_VolumeProjection_To_api_VolumeProjection is an autogenerated conversion function.
func Convert_v1_VolumeProjection_To_api_VolumeProjection(in *v1.VolumeProjection, out *api.VolumeProjection, s conversion.Scope) error {
	return autoConvert_v1_VolumeProjection_To_api_VolumeProjection(in, out, s)
}

func autoConvert_api_VolumeProjection_To_v1_VolumeProjection(in *api.VolumeProjection, out *v1.VolumeProjection, s conversion.Scope) error {
	out.Secret = (*v1.SecretProjection)(unsafe.Pointer(in.Secret))
	out.DownwardAPI = (*v1.DownwardAPIProjection)(unsafe.Pointer(in.DownwardAPI))
	out.ConfigMap = (*v1.ConfigMapProjection)(unsafe.Pointer(in.ConfigMap))
	return nil
}

// Convert_api_VolumeProjection_To_v1_VolumeProjection is an autogenerated conversion function.
func Convert_api_VolumeProjection_To_v1_VolumeProjection(in *api.VolumeProjection, out *v1.VolumeProjection, s conversion.Scope) error {
	return autoConvert_api_VolumeProjection_To_v1_VolumeProjection(in, out, s)
}

func autoConvert_v1_VolumeSource_To_api_VolumeSource(in *v1.VolumeSource, out *api.VolumeSource, s conversion.Scope) error {
	out.HostPath = (*api.HostPathVolumeSource)(unsafe.Pointer(in.HostPath))
	out.EmptyDir = (*api.EmptyDirVolumeSource)(unsafe.Pointer(in.EmptyDir))
	out.GCEPersistentDisk = (*api.GCEPersistentDiskVolumeSource)(unsafe.Pointer(in.GCEPersistentDisk))
	out.AWSElasticBlockStore = (*api.AWSElasticBlockStoreVolumeSource)(unsafe.Pointer(in.AWSElasticBlockStore))
	out.GitRepo = (*api.GitRepoVolumeSource)(unsafe.Pointer(in.GitRepo))
	out.Secret = (*api.SecretVolumeSource)(unsafe.Pointer(in.Secret))
	out.NFS = (*api.NFSVolumeSource)(unsafe.Pointer(in.NFS))
	out.ISCSI = (*api.ISCSIVolumeSource)(unsafe.Pointer(in.ISCSI))
	out.Glusterfs = (*api.GlusterfsVolumeSource)(unsafe.Pointer(in.Glusterfs))
	out.PersistentVolumeClaim = (*api.PersistentVolumeClaimVolumeSource)(unsafe.Pointer(in.PersistentVolumeClaim))
	out.RBD = (*api.RBDVolumeSource)(unsafe.Pointer(in.RBD))
	out.FlexVolume = (*api.FlexVolumeSource)(unsafe.Pointer(in.FlexVolume))
	out.Cinder = (*api.CinderVolumeSource)(unsafe.Pointer(in.Cinder))
	out.CephFS = (*api.CephFSVolumeSource)(unsafe.Pointer(in.CephFS))
	out.Flocker = (*api.FlockerVolumeSource)(unsafe.Pointer(in.Flocker))
	out.DownwardAPI = (*api.DownwardAPIVolumeSource)(unsafe.Pointer(in.DownwardAPI))
	out.FC = (*api.FCVolumeSource)(unsafe.Pointer(in.FC))
	out.AzureFile = (*api.AzureFileVolumeSource)(unsafe.Pointer(in.AzureFile))
	out.ConfigMap = (*api.ConfigMapVolumeSource)(unsafe.Pointer(in.ConfigMap))
	out.VsphereVolume = (*api.VsphereVirtualDiskVolumeSource)(unsafe.Pointer(in.VsphereVolume))
	out.Quobyte = (*api.QuobyteVolumeSource)(unsafe.Pointer(in.Quobyte))
	out.AzureDisk = (*api.AzureDiskVolumeSource)(unsafe.Pointer(in.AzureDisk))
	out.PhotonPersistentDisk = (*api.PhotonPersistentDiskVolumeSource)(unsafe.Pointer(in.PhotonPersistentDisk))
	out.Projected = (*api.ProjectedVolumeSource)(unsafe.Pointer(in.Projected))
	out.PortworxVolume = (*api.PortworxVolumeSource)(unsafe.Pointer(in.PortworxVolume))
	out.ScaleIO = (*api.ScaleIOVolumeSource)(unsafe.Pointer(in.ScaleIO))
	out.StorageOS = (*api.StorageOSVolumeSource)(unsafe.Pointer(in.StorageOS))
	return nil
}

// Convert_v1_VolumeSource_To_api_VolumeSource is an autogenerated conversion function.
func Convert_v1_VolumeSource_To_api_VolumeSource(in *v1.VolumeSource, out *api.VolumeSource, s conversion.Scope) error {
	return autoConvert_v1_VolumeSource_To_api_VolumeSource(in, out, s)
}

func autoConvert_api_VolumeSource_To_v1_VolumeSource(in *api.VolumeSource, out *v1.VolumeSource, s conversion.Scope) error {
	out.HostPath = (*v1.HostPathVolumeSource)(unsafe.Pointer(in.HostPath))
	out.EmptyDir = (*v1.EmptyDirVolumeSource)(unsafe.Pointer(in.EmptyDir))
	out.GCEPersistentDisk = (*v1.GCEPersistentDiskVolumeSource)(unsafe.Pointer(in.GCEPersistentDisk))
	out.AWSElasticBlockStore = (*v1.AWSElasticBlockStoreVolumeSource)(unsafe.Pointer(in.AWSElasticBlockStore))
	out.GitRepo = (*v1.GitRepoVolumeSource)(unsafe.Pointer(in.GitRepo))
	out.Secret = (*v1.SecretVolumeSource)(unsafe.Pointer(in.Secret))
	out.NFS = (*v1.NFSVolumeSource)(unsafe.Pointer(in.NFS))
	out.ISCSI = (*v1.ISCSIVolumeSource)(unsafe.Pointer(in.ISCSI))
	out.Glusterfs = (*v1.GlusterfsVolumeSource)(unsafe.Pointer(in.Glusterfs))
	out.PersistentVolumeClaim = (*v1.PersistentVolumeClaimVolumeSource)(unsafe.Pointer(in.PersistentVolumeClaim))
	out.RBD = (*v1.RBDVolumeSource)(unsafe.Pointer(in.RBD))
	out.Quobyte = (*v1.QuobyteVolumeSource)(unsafe.Pointer(in.Quobyte))
	out.FlexVolume = (*v1.FlexVolumeSource)(unsafe.Pointer(in.FlexVolume))
	out.Cinder = (*v1.CinderVolumeSource)(unsafe.Pointer(in.Cinder))
	out.CephFS = (*v1.CephFSVolumeSource)(unsafe.Pointer(in.CephFS))
	out.Flocker = (*v1.FlockerVolumeSource)(unsafe.Pointer(in.Flocker))
	out.DownwardAPI = (*v1.DownwardAPIVolumeSource)(unsafe.Pointer(in.DownwardAPI))
	out.FC = (*v1.FCVolumeSource)(unsafe.Pointer(in.FC))
	out.AzureFile = (*v1.AzureFileVolumeSource)(unsafe.Pointer(in.AzureFile))
	out.ConfigMap = (*v1.ConfigMapVolumeSource)(unsafe.Pointer(in.ConfigMap))
	out.VsphereVolume = (*v1.VsphereVirtualDiskVolumeSource)(unsafe.Pointer(in.VsphereVolume))
	out.AzureDisk = (*v1.AzureDiskVolumeSource)(unsafe.Pointer(in.AzureDisk))
	out.PhotonPersistentDisk = (*v1.PhotonPersistentDiskVolumeSource)(unsafe.Pointer(in.PhotonPersistentDisk))
	out.Projected = (*v1.ProjectedVolumeSource)(unsafe.Pointer(in.Projected))
	out.PortworxVolume = (*v1.PortworxVolumeSource)(unsafe.Pointer(in.PortworxVolume))
	out.ScaleIO = (*v1.ScaleIOVolumeSource)(unsafe.Pointer(in.ScaleIO))
	out.StorageOS = (*v1.StorageOSVolumeSource)(unsafe.Pointer(in.StorageOS))
	return nil
}

// Convert_api_VolumeSource_To_v1_VolumeSource is an autogenerated conversion function.
func Convert_api_VolumeSource_To_v1_VolumeSource(in *api.VolumeSource, out *v1.VolumeSource, s conversion.Scope) error {
	return autoConvert_api_VolumeSource_To_v1_VolumeSource(in, out, s)
}

func autoConvert_v1_VsphereVirtualDiskVolumeSource_To_api_VsphereVirtualDiskVolumeSource(in *v1.VsphereVirtualDiskVolumeSource, out *api.VsphereVirtualDiskVolumeSource, s conversion.Scope) error {
	out.VolumePath = in.VolumePath
	out.FSType = in.FSType
	out.StoragePolicyName = in.StoragePolicyName
	out.StoragePolicyID = in.StoragePolicyID
	return nil
}

// Convert_v1_VsphereVirtualDiskVolumeSource_To_api_VsphereVirtualDiskVolumeSource is an autogenerated conversion function.
func Convert_v1_VsphereVirtualDiskVolumeSource_To_api_VsphereVirtualDiskVolumeSource(in *v1.VsphereVirtualDiskVolumeSource, out *api.VsphereVirtualDiskVolumeSource, s conversion.Scope) error {
	return autoConvert_v1_VsphereVirtualDiskVolumeSource_To_api_VsphereVirtualDiskVolumeSource(in, out, s)
}

func autoConvert_api_VsphereVirtualDiskVolumeSource_To_v1_VsphereVirtualDiskVolumeSource(in *api.VsphereVirtualDiskVolumeSource, out *v1.VsphereVirtualDiskVolumeSource, s conversion.Scope) error {
	out.VolumePath = in.VolumePath
	out.FSType = in.FSType
	out.StoragePolicyName = in.StoragePolicyName
	out.StoragePolicyID = in.StoragePolicyID
	return nil
}

// Convert_api_VsphereVirtualDiskVolumeSource_To_v1_VsphereVirtualDiskVolumeSource is an autogenerated conversion function.
func Convert_api_VsphereVirtualDiskVolumeSource_To_v1_VsphereVirtualDiskVolumeSource(in *api.VsphereVirtualDiskVolumeSource, out *v1.VsphereVirtualDiskVolumeSource, s conversion.Scope) error {
	return autoConvert_api_VsphereVirtualDiskVolumeSource_To_v1_VsphereVirtualDiskVolumeSource(in, out, s)
}

func autoConvert_v1_WeightedPodAffinityTerm_To_api_WeightedPodAffinityTerm(in *v1.WeightedPodAffinityTerm, out *api.WeightedPodAffinityTerm, s conversion.Scope) error {
	out.Weight = in.Weight
	if err := Convert_v1_PodAffinityTerm_To_api_PodAffinityTerm(&in.PodAffinityTerm, &out.PodAffinityTerm, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_WeightedPodAffinityTerm_To_api_WeightedPodAffinityTerm is an autogenerated conversion function.
func Convert_v1_WeightedPodAffinityTerm_To_api_WeightedPodAffinityTerm(in *v1.WeightedPodAffinityTerm, out *api.WeightedPodAffinityTerm, s conversion.Scope) error {
	return autoConvert_v1_WeightedPodAffinityTerm_To_api_WeightedPodAffinityTerm(in, out, s)
}

func autoConvert_api_WeightedPodAffinityTerm_To_v1_WeightedPodAffinityTerm(in *api.WeightedPodAffinityTerm, out *v1.WeightedPodAffinityTerm, s conversion.Scope) error {
	out.Weight = in.Weight
	if err := Convert_api_PodAffinityTerm_To_v1_PodAffinityTerm(&in.PodAffinityTerm, &out.PodAffinityTerm, s); err != nil {
		return err
	}
	return nil
}

// Convert_api_WeightedPodAffinityTerm_To_v1_WeightedPodAffinityTerm is an autogenerated conversion function.
func Convert_api_WeightedPodAffinityTerm_To_v1_WeightedPodAffinityTerm(in *api.WeightedPodAffinityTerm, out *v1.WeightedPodAffinityTerm, s conversion.Scope) error {
	return autoConvert_api_WeightedPodAffinityTerm_To_v1_WeightedPodAffinityTerm(in, out, s)
}
