/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.everit.json.schema.FormatValidator;
import org.everit.json.schema.StringSchema;
import org.everit.json.schema.loader.JsonValue;
import org.everit.json.schema.loader.LoadingState;
import org.everit.json.schema.loader.SpecificationVersion;

public class StringSchemaLoader {
    private LoadingState ls;
    private Map<String, FormatValidator> formatValidators;
    private boolean useDefault;

    @Deprecated
    public StringSchemaLoader(LoadingState ls) {
        this(ls, SpecificationVersion.DRAFT_4.defaultFormatValidators());
    }

    StringSchemaLoader(LoadingState ls, Map<String, FormatValidator> formatValidators) {
        this.ls = Objects.requireNonNull(ls, "ls cannot be null");
        this.formatValidators = Collections.unmodifiableMap(Objects.requireNonNull(formatValidators, "formatValidators cannot be null"));
    }

    public StringSchema.Builder load() {
        StringSchema.Builder builder = StringSchema.builder();
        this.ls.schemaJson().maybe("minLength").map(JsonValue::requireInteger).ifPresent(builder::minLength);
        this.ls.schemaJson().maybe("maxLength").map(JsonValue::requireInteger).ifPresent(builder::maxLength);
        this.ls.schemaJson().maybe("pattern").map(JsonValue::requireString).map(this.ls.config.regexpFactory::createHandler).ifPresent(builder::pattern);
        this.ls.schemaJson().maybe("format").map(JsonValue::requireString).ifPresent(format -> this.addFormatValidator(builder, (String)format));
        return builder;
    }

    private void addFormatValidator(StringSchema.Builder builder, String formatName) {
        FormatValidator formatValidator = this.formatValidators.get(formatName);
        if (formatValidator != null) {
            builder.formatValidator(formatValidator);
        }
    }
}

