# 🏔 Onwards
Notes about what currently breaks 💥 and what could be better tomorrow.
- [x] Lists spacing is broken
- [x] Nested lists are not formatted correctly
- [x] Errors are global, but should be local
- [x] Printing a var
- [x] Switch to fast serialization using Nippy
- [x] Store results as CAS files, only write when needed
- [x] Don't thaw result if it's already in memory
- [x] Don't cache things that are fast to evaluate
- [x] Handle conditional read in cljc files
- [x] Add README
- [x] Markdown should support Nextjournal Flavored Markdown including:
- [x] TODO lists 😹
- [x] Inline Formulas $E^2=m^2+\vec{p}^2$
- [x] Fix analyzer error for aliases requires w/o ns (e.g. in viewers notebooks)
## 🕵🏻‍♀️ Viewers
- [x] Make viewer api open with predicates
- [x] Make viewer registration local on namespace
- [x] Make js-only viewers like plotly & vega work
- [x] Fix maps
- [x] Sort maps
- [x] Lazy seqs
- [x] Fix Rule 30 maps
- [x] Drop vector brackets when lazy load map element
- [x] Review viewer registration api
- [x] Simplify viewer api (drop `view-as` & change argument order in `with-viewer`/`s`)
- [x] Fix seeing map with blob-id in Rule 30 notebook
- [x] Turn `with-viewers` into a macro and make it take same unquoted form as `set-viewers!`
- [x] Consistently use `Fn+Form` to carry viewer functions
- [x] Make map-viewer pass down options to select map-entry renderer for children and remove viewer from Rule 30
- [x] Drop lazy loading attempts in plotly + vega viewers
- [x] Keep expanded state when lazy loading
- [x] Move update opts fn to viewer map
- [x] Restrict string length + enable lazy loading
- [x] Let the viewer opt into pagination
- [x] A browser refresh is currently needed to reset a viewer override like in `notebooks/rule_30.clj`, otherwise it will carry over the viewer override to other notebooks that do no specify an override
- [x] Evaluation error messages are poorly formatted
- [x] `first-generation` in `notebooks/rule_30.clj` renders incorrectly because of pagination type coercion from vector to list
- [x] `(def r (range 100))` in `notebooks/pagination.clj` shows incorrect `count`
- [x] Printing of very large values
### 👁 More Viewers
- [ ] Binary / Hex
- [x] Image
## 🚀 Private Beta
- [x] Move to non-jit compiled tailwind stylesheet, purging doesn't work nicely with custom viewers
- [x] Make static build work
- [x] Review caching api
- [x] Change `:clerk/no-cache` to `:nextjournal.clerk/no-cache`
- [x] Move public viewer api to `nextjournal.clerk` and use `(:require [nextjournal.clerk :as clerk])` in all example notebooks
## 💒 Open Source Release
- [x] Allow to pin notebook
- [x] Release to maven & invite contributors
- [x] Fix error when describing Datomic entities
- [x] Limit description to make large datasets work
- [x] Debug & fix extra calls to inspect / rendering
- [x] Setup up static builds
- [x] Fix [link](#) style when code cell uses markdown viewer
- [x] Do pass over README
- [x] Add CHANGELOG
- [x] Release 0.2
- [x] Make github repo public
## 🛠 Up Next
- [x] Let consumers (SICMUitls) extend sci ns by putting it into an atom
- [x] Support setting `:nextjournal.clerk/no-cache` on namespaces as well
- [x] Datafy or Metadata viewer via `:transform-fn`
- [x] Persist viewer expansion state across reloads
- [x] Show eval error in overlay to persist scroll state when it disappears
- [x] Improve feedback when viewer errors
- [x] Verify viewer caching behaviour
- [x] Fix dark mode for string viewer
- [x] Release 0.6
- [x] Make code cells scroll horizontally scrollable and add minimum width of 80 chars
- [x] Extend reach of viewer api to whole notebook (including the root node)
- [x] Make viewer api more functional
- [x] Let `:transform-fn` act on wrapped-value and use it to also replace `:fetch-fn`
- [x] Try using `:update-viewers-fn` for markdown node
- [x] Minimize re-rendering when updating notebook
- [ ] Throw on re-definitions
- [x] Throw when referencing no longer available / deleted var
- [x] Allow multiple defs per top-level forms
- [x] Restore `*ns*` after hashing / eval
- [x] Support setting `:nextjournal.clerk/cache` forms to control caching behaviour
- [x] Add `clerk/image` (name tbd) viewer supporting links and embedded images
- [x] Derefenced Clojure atoms should get value semantics in dependency graph
- [x] Support evaluating `(quote 'code 'in 'backticks)` in markdown
- [x] Make it more obvious that results can be expanded
- [x] Set expanded state depending on shape (width) of the data
- [x] Allow to control viewer expansion state programmatically
- [x] Support cherry as alternative js evaluator
- [x] Make `doc-url` work in live app using `v/clerk-eval` with homepage, 404 and symbol links
- [x] Build static build on CI
- [x] Hook up new table viewer
- [x] Status log
- [x] Rename `:nextjournal.clerk/opts` to `:nextjournal.clerk/render-opts`
- [ ] Improve page load performance of large documents like book (probably by evaluating each `:render-fn` only once)
- [ ] Introduce window/session concept to support opening concurrent documents
- [ ] Introduce per-session/connection state for sync
- [ ] Make clerk sync recomputations more granular (only recompute deps of changed atom)
- [ ] Global config with consistent inheritance to ns, expression
- [ ] Tap & eval viewer window
- [ ] Add multiviewer to default viewers
- [ ] Make stacktraces clickable
- [ ] Mark uncacheable results in browser window including explanation
- [ ] Add CAS storage option for static builds
- [ ] Improve performance of analysis & presentation
## 📖 Book Updates
- [ ] Explain `render-opts` and `viewer-opts` in book
- [ ] Add sync atoms to book
- [x] Add tap inspector to book
- [ ] Add customizing clerk: markdown backtick eval example to book
- [ ] Add example for cross-document table of contents
## 💡 Ideas
- [ ] Hook up distributed caching using CAS + cloud bucket
