/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.stream;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.AbstractMap;
import sandbox.java.util.AbstractSet;
import sandbox.java.util.ArrayList;
import sandbox.java.util.Arrays;
import sandbox.java.util.Collection;
import sandbox.java.util.Collections;
import sandbox.java.util.Comparator;
import sandbox.java.util.DoubleSummaryStatistics;
import sandbox.java.util.EnumSet;
import sandbox.java.util.HashMap;
import sandbox.java.util.HashSet;
import sandbox.java.util.IntSummaryStatistics;
import sandbox.java.util.Iterator;
import sandbox.java.util.List;
import sandbox.java.util.LongSummaryStatistics;
import sandbox.java.util.Map;
import sandbox.java.util.Objects;
import sandbox.java.util.Optional;
import sandbox.java.util.Set;
import sandbox.java.util.StringJoiner;
import sandbox.java.util.concurrent.ConcurrentHashMap;
import sandbox.java.util.concurrent.ConcurrentMap;
import sandbox.java.util.function.BiConsumer;
import sandbox.java.util.function.BiFunction;
import sandbox.java.util.function.BinaryOperator;
import sandbox.java.util.function.Consumer;
import sandbox.java.util.function.Function;
import sandbox.java.util.function.Predicate;
import sandbox.java.util.function.Supplier;
import sandbox.java.util.function.ToDoubleFunction;
import sandbox.java.util.function.ToIntFunction;
import sandbox.java.util.function.ToLongFunction;
import sandbox.java.util.stream.Collector;

public final class Collectors {
    static final Set<Collector.Characteristics> CH_CONCURRENT_ID;
    static final Set<Collector.Characteristics> CH_CONCURRENT_NOID;
    static final Set<Collector.Characteristics> CH_ID;
    static final Set<Collector.Characteristics> CH_UNORDERED_ID;
    static final Set<Collector.Characteristics> CH_NOID;

    private Collectors() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (object, object2) -> {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
            Object[] objectArray = new Object[]{object};
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
            String string = String.format("Duplicate key %s", objectArray);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
            IllegalStateException illegalStateException = new IllegalStateException(string);
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        };
    }

    private static <I, R> Function<I, R> castingIdentity() {
        return object -> object;
    }

    public static <T, C extends Collection<T>> Collector<T, ?, C> toCollection(Supplier<C> supplier) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$CollectorImpl");
        BiConsumer<Collection, Object> biConsumer = Collection::add;
        BinaryOperator binaryOperator = (collection, collection2) -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.addAll:(Ljava/util/Collection;)Z");
            collection.addAll(collection2);
            return collection;
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$CollectorImpl.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;Ljava/util/Set;)V");
        return new CollectorImpl(supplier, biConsumer, binaryOperator, CH_ID);
    }

    public static <T> Collector<T, ?, List<T>> toList() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$CollectorImpl");
        Supplier<List> supplier = ArrayList::new;
        BiConsumer<List, Object> biConsumer = List::add;
        BinaryOperator binaryOperator = (list, list2) -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.addAll:(Ljava/util/Collection;)Z");
            list.addAll(list2);
            return list;
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$CollectorImpl.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;Ljava/util/Set;)V");
        return new CollectorImpl(supplier, biConsumer, binaryOperator, CH_ID);
    }

    public static <T> Collector<T, ?, Set<T>> toSet() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$CollectorImpl");
        Supplier<Set> supplier = HashSet::new;
        BiConsumer<Set, Object> biConsumer = Set::add;
        BinaryOperator binaryOperator = (set, set2) -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.addAll:(Ljava/util/Collection;)Z");
            set.addAll(set2);
            return set;
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$CollectorImpl.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;Ljava/util/Set;)V");
        return new CollectorImpl(supplier, biConsumer, binaryOperator, CH_UNORDERED_ID);
    }

    public static Collector<CharSequence, ?, String> joining() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$CollectorImpl");
        Supplier<StringBuilder> supplier = StringBuilder::new;
        BiConsumer<StringBuilder, CharSequence> biConsumer = StringBuilder::append;
        BinaryOperator binaryOperator = (stringBuilder, stringBuilder2) -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/CharSequence;)Ljava/lang/StringBuilder;");
            stringBuilder.append((CharSequence)stringBuilder2);
            return stringBuilder;
        };
        Function<StringBuilder, String> function = StringBuilder::toString;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$CollectorImpl.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;Ljava/util/function/Function;Ljava/util/Set;)V");
        return new CollectorImpl<CharSequence, StringBuilder, String>(supplier, biConsumer, binaryOperator, function, CH_NOID);
    }

    public static Collector<CharSequence, ?, String> joining(CharSequence charSequence) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.joining:(Ljava/lang/CharSequence;Ljava/lang/CharSequence;Ljava/lang/CharSequence;)Ljava/util/stream/Collector;");
        return Collectors.joining(charSequence, "", "");
    }

    public static Collector<CharSequence, ?, String> joining(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$CollectorImpl");
        Supplier<StringJoiner> supplier = () -> {
            RuntimeCostAccounter.recordAllocation((String)"java/util/StringJoiner");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/StringJoiner.<init>:(Ljava/lang/CharSequence;Ljava/lang/CharSequence;Ljava/lang/CharSequence;)V");
            return new StringJoiner(charSequence, charSequence2, charSequence3);
        };
        BiConsumer<StringJoiner, CharSequence> biConsumer = StringJoiner::add;
        BinaryOperator binaryOperator = StringJoiner::merge;
        Function<StringJoiner, String> function = StringJoiner::toString;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$CollectorImpl.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;Ljava/util/function/Function;Ljava/util/Set;)V");
        return new CollectorImpl<CharSequence, StringJoiner, String>(supplier, biConsumer, binaryOperator, function, CH_NOID);
    }

    private static <K, V, M extends Map<K, V>> BinaryOperator<M> mapMerger(BinaryOperator<V> binaryOperator) {
        return (map, map2) -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.entrySet:()Ljava/util/Set;");
            Set set = map2.entrySet();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
            Iterator iterator = set.iterator();
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl = iterator.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                Map.Entry entry = iterator.next();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                Object k = entry.getKey();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                Object v = entry.getValue();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.merge:(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;");
                map.merge(k, v, binaryOperator);
                RuntimeCostAccounter.recordJump();
            }
            return map;
        };
    }

    public static <T, U, A, R> Collector<T, ?, R> mapping(Function<? super T, ? extends U> function, Collector<? super U, A, R> collector) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.accumulator:()Ljava/util/function/BiConsumer;");
        BiConsumer biConsumer = collector.accumulator();
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$CollectorImpl");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.supplier:()Ljava/util/function/Supplier;");
        Supplier<A> supplier = collector.supplier();
        BiConsumer<Object, Object> biConsumer2 = (object, object2) -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
            Object r = function.apply(object2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiConsumer.accept:(Ljava/lang/Object;Ljava/lang/Object;)V");
            biConsumer.accept((Object)object, (Object)r);
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.combiner:()Ljava/util/function/BinaryOperator;");
        BinaryOperator<A> binaryOperator = collector.combiner();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.finisher:()Ljava/util/function/Function;");
        Function<A, R> function2 = collector.finisher();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.characteristics:()Ljava/util/Set;");
        Set<Collector.Characteristics> set = collector.characteristics();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$CollectorImpl.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;Ljava/util/function/Function;Ljava/util/Set;)V");
        return new CollectorImpl<Object, Object, R>(supplier, biConsumer2, binaryOperator, function2, set);
    }

    public static <T, A, R, RR> Collector<T, A, RR> collectingAndThen(Collector<T, A, R> collector, Function<R, RR> function) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.characteristics:()Ljava/util/Set;");
        Set<Collector.Characteristics> set = collector.characteristics();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.contains:(Ljava/lang/Object;)Z");
        boolean bl = set.contains((Object)Collector.Characteristics.IDENTITY_FINISH);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.size:()I");
            int n = set.size();
            RuntimeCostAccounter.recordJump();
            if (n == 1) {
                set = CH_NOID;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.copyOf:(Ljava/util/Collection;)Ljava/util/EnumSet;");
                set = EnumSet.copyOf(set);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.remove:(Ljava/lang/Object;)Z");
                set.remove((Object)Collector.Characteristics.IDENTITY_FINISH);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.unmodifiableSet:(Ljava/util/Set;)Ljava/util/Set;");
                set = Collections.unmodifiableSet(set);
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$CollectorImpl");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.supplier:()Ljava/util/function/Supplier;");
        Supplier<A> supplier = collector.supplier();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.accumulator:()Ljava/util/function/BiConsumer;");
        BiConsumer<A, T> biConsumer = collector.accumulator();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.combiner:()Ljava/util/function/BinaryOperator;");
        BinaryOperator<A> binaryOperator = collector.combiner();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.finisher:()Ljava/util/function/Function;");
        Function<A, R> function2 = collector.finisher();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.andThen:(Ljava/util/function/Function;)Ljava/util/function/Function;");
        Function<A, RR> function3 = function2.andThen(function);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$CollectorImpl.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;Ljava/util/function/Function;Ljava/util/Set;)V");
        return new CollectorImpl<T, A, RR>(supplier, biConsumer, binaryOperator, function3, set);
    }

    public static <T> Collector<T, ?, Long> counting() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        Long l = 0L;
        Function<Object, Long> function = object -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
            return 1L;
        };
        BinaryOperator binaryOperator = Long::sum;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.reducing:(Ljava/lang/Object;Ljava/util/function/Function;Ljava/util/function/BinaryOperator;)Ljava/util/stream/Collector;");
        return Collectors.reducing(l, function, binaryOperator);
    }

    public static <T> Collector<T, ?, Optional<T>> minBy(Comparator<? super T> comparator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BinaryOperator.minBy:(Ljava/util/Comparator;)Ljava/util/function/BinaryOperator;");
        BinaryOperator<? super T> binaryOperator = BinaryOperator.minBy(comparator);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.reducing:(Ljava/util/function/BinaryOperator;)Ljava/util/stream/Collector;");
        return Collectors.reducing(binaryOperator);
    }

    public static <T> Collector<T, ?, Optional<T>> maxBy(Comparator<? super T> comparator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BinaryOperator.maxBy:(Ljava/util/Comparator;)Ljava/util/function/BinaryOperator;");
        BinaryOperator<? super T> binaryOperator = BinaryOperator.maxBy(comparator);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.reducing:(Ljava/util/function/BinaryOperator;)Ljava/util/stream/Collector;");
        return Collectors.reducing(binaryOperator);
    }

    public static <T> Collector<T, ?, Integer> summingInt(ToIntFunction<? super T> toIntFunction) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$CollectorImpl");
        Supplier<int[]> supplier = () -> {
            RuntimeCostAccounter.recordArrayAllocation((int)1, (int)4);
            return new int[1];
        };
        BiConsumer<int[], Object> biConsumer = (nArray, object) -> {
            int n = nArray[0];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/ToIntFunction.applyAsInt:(Ljava/lang/Object;)I");
            nArray[0] = n + toIntFunction.applyAsInt(object);
        };
        BinaryOperator binaryOperator = (nArray, nArray2) -> {
            nArray[0] = nArray[0] + nArray2[0];
            return nArray;
        };
        Function<int[], Integer> function = nArray -> {
            int n = nArray[0];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
            return n;
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$CollectorImpl.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;Ljava/util/function/Function;Ljava/util/Set;)V");
        return new CollectorImpl<Object, int[], Integer>(supplier, biConsumer, binaryOperator, function, CH_NOID);
    }

    public static <T> Collector<T, ?, Long> summingLong(ToLongFunction<? super T> toLongFunction) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$CollectorImpl");
        Supplier<long[]> supplier = () -> {
            RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
            return new long[1];
        };
        BiConsumer<long[], Object> biConsumer = (lArray, object) -> {
            long l = lArray[0];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/ToLongFunction.applyAsLong:(Ljava/lang/Object;)J");
            lArray[0] = l + toLongFunction.applyAsLong(object);
        };
        BinaryOperator binaryOperator = (lArray, lArray2) -> {
            lArray[0] = lArray[0] + lArray2[0];
            return lArray;
        };
        Function<long[], Long> function = lArray -> {
            long l = lArray[0];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
            return l;
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$CollectorImpl.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;Ljava/util/function/Function;Ljava/util/Set;)V");
        return new CollectorImpl<Object, long[], Long>(supplier, biConsumer, binaryOperator, function, CH_NOID);
    }

    public static <T> Collector<T, ?, Double> summingDouble(ToDoubleFunction<? super T> toDoubleFunction) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$CollectorImpl");
        Supplier<double[]> supplier = () -> {
            RuntimeCostAccounter.recordArrayAllocation((int)3, (int)8);
            return new double[3];
        };
        BiConsumer<double[], Object> biConsumer = (dArray, object) -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/ToDoubleFunction.applyAsDouble:(Ljava/lang/Object;)D");
            double d = toDoubleFunction.applyAsDouble(object);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.sumWithCompensation:([DD)[D");
            Collectors.sumWithCompensation(dArray, d);
            double d2 = dArray[2];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/ToDoubleFunction.applyAsDouble:(Ljava/lang/Object;)D");
            dArray[2] = d2 + toDoubleFunction.applyAsDouble(object);
        };
        BinaryOperator binaryOperator = (dArray, dArray2) -> {
            double d = dArray2[0];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.sumWithCompensation:([DD)[D");
            Collectors.sumWithCompensation(dArray, d);
            dArray[2] = dArray[2] + dArray2[2];
            double d2 = dArray2[1];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.sumWithCompensation:([DD)[D");
            return Collectors.sumWithCompensation(dArray, d2);
        };
        Function<double[], Double> function = dArray -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.computeFinalSum:([D)D");
            double d = Collectors.computeFinalSum(dArray);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.valueOf:(D)Ljava/lang/Double;");
            return d;
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$CollectorImpl.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;Ljava/util/function/Function;Ljava/util/Set;)V");
        return new CollectorImpl<Object, double[], Double>(supplier, biConsumer, binaryOperator, function, CH_NOID);
    }

    static double[] sumWithCompensation(double[] dArray, double d) {
        double d2 = d - dArray[1];
        double d3 = dArray[0];
        double d4 = d3 + d2;
        dArray[1] = d4 - d3 - d2;
        dArray[0] = d4;
        return dArray;
    }

    static double computeFinalSum(double[] dArray) {
        double d = dArray[0] + dArray[1];
        double d2 = dArray[dArray.length - 1];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.isNaN:(D)Z");
        boolean bl = Double.isNaN(d);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.isInfinite:(D)Z");
            boolean bl2 = Double.isInfinite(d2);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                return d2;
            }
        }
        return d;
    }

    public static <T> Collector<T, ?, Double> averagingInt(ToIntFunction<? super T> toIntFunction) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$CollectorImpl");
        Supplier<long[]> supplier = () -> {
            RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
            return new long[2];
        };
        BiConsumer<long[], Object> biConsumer = (lArray, object) -> {
            long l = lArray[0];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/ToIntFunction.applyAsInt:(Ljava/lang/Object;)I");
            lArray[0] = l + (long)toIntFunction.applyAsInt(object);
            lArray[1] = lArray[1] + 1L;
        };
        BinaryOperator binaryOperator = (lArray, lArray2) -> {
            lArray[0] = lArray[0] + lArray2[0];
            lArray[1] = lArray[1] + lArray2[1];
            return lArray;
        };
        Function<long[], Double> function = lArray -> {
            double d;
            long l = lArray[1] - 0L;
            long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l2 == false) {
                d = 0.0;
                RuntimeCostAccounter.recordJump();
            } else {
                d = (double)lArray[0] / (double)lArray[1];
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.valueOf:(D)Ljava/lang/Double;");
            return d;
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$CollectorImpl.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;Ljava/util/function/Function;Ljava/util/Set;)V");
        return new CollectorImpl<Object, long[], Double>(supplier, biConsumer, binaryOperator, function, CH_NOID);
    }

    public static <T> Collector<T, ?, Double> averagingLong(ToLongFunction<? super T> toLongFunction) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$CollectorImpl");
        Supplier<long[]> supplier = () -> {
            RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
            return new long[2];
        };
        BiConsumer<long[], Object> biConsumer = (lArray, object) -> {
            long l = lArray[0];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/ToLongFunction.applyAsLong:(Ljava/lang/Object;)J");
            lArray[0] = l + toLongFunction.applyAsLong(object);
            lArray[1] = lArray[1] + 1L;
        };
        BinaryOperator binaryOperator = (lArray, lArray2) -> {
            lArray[0] = lArray[0] + lArray2[0];
            lArray[1] = lArray[1] + lArray2[1];
            return lArray;
        };
        Function<long[], Double> function = lArray -> {
            double d;
            long l = lArray[1] - 0L;
            long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l2 == false) {
                d = 0.0;
                RuntimeCostAccounter.recordJump();
            } else {
                d = (double)lArray[0] / (double)lArray[1];
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.valueOf:(D)Ljava/lang/Double;");
            return d;
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$CollectorImpl.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;Ljava/util/function/Function;Ljava/util/Set;)V");
        return new CollectorImpl<Object, long[], Double>(supplier, biConsumer, binaryOperator, function, CH_NOID);
    }

    public static <T> Collector<T, ?, Double> averagingDouble(ToDoubleFunction<? super T> toDoubleFunction) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$CollectorImpl");
        Supplier<double[]> supplier = () -> {
            RuntimeCostAccounter.recordArrayAllocation((int)4, (int)8);
            return new double[4];
        };
        BiConsumer<double[], Object> biConsumer = (dArray, object) -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/ToDoubleFunction.applyAsDouble:(Ljava/lang/Object;)D");
            double d = toDoubleFunction.applyAsDouble(object);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.sumWithCompensation:([DD)[D");
            Collectors.sumWithCompensation(dArray, d);
            dArray[2] = dArray[2] + 1.0;
            double d2 = dArray[3];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/ToDoubleFunction.applyAsDouble:(Ljava/lang/Object;)D");
            dArray[3] = d2 + toDoubleFunction.applyAsDouble(object);
        };
        BinaryOperator binaryOperator = (dArray, dArray2) -> {
            double d = dArray2[0];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.sumWithCompensation:([DD)[D");
            Collectors.sumWithCompensation(dArray, d);
            double d2 = dArray2[1];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.sumWithCompensation:([DD)[D");
            Collectors.sumWithCompensation(dArray, d2);
            dArray[2] = dArray[2] + dArray2[2];
            dArray[3] = dArray[3] + dArray2[3];
            return dArray;
        };
        Function<double[], Double> function = dArray -> {
            double d;
            double d2 = dArray[2] - 0.0;
            double d3 = d2 == 0.0 ? 0 : (d2 > 0.0 ? 1 : -1);
            RuntimeCostAccounter.recordJump();
            if (d3 == false) {
                d = 0.0;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.computeFinalSum:([D)D");
                d = Collectors.computeFinalSum(dArray) / dArray[2];
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.valueOf:(D)Ljava/lang/Double;");
            return d;
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$CollectorImpl.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;Ljava/util/function/Function;Ljava/util/Set;)V");
        return new CollectorImpl<Object, double[], Double>(supplier, biConsumer, binaryOperator, function, CH_NOID);
    }

    public static <T> Collector<T, ?, T> reducing(T t, BinaryOperator<T> binaryOperator) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$CollectorImpl");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.boxSupplier:(Ljava/lang/Object;)Ljava/util/function/Supplier;");
        Supplier<T[]> supplier = Collectors.boxSupplier(t);
        BiConsumer<Object[], Object> biConsumer = (objectArray, object) -> {
            Object object2 = objectArray[0];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BinaryOperator.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            objectArray[0] = binaryOperator.apply(object2, object);
        };
        BinaryOperator binaryOperator2 = (objectArray, objectArray2) -> {
            Object object = objectArray[0];
            Object object2 = objectArray2[0];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BinaryOperator.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            objectArray[0] = binaryOperator.apply(object, object2);
            return objectArray;
        };
        Function<Object[], Object> function = objectArray -> objectArray[0];
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$CollectorImpl.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;Ljava/util/function/Function;Ljava/util/Set;)V");
        return new CollectorImpl<Object, Object[], Object>(supplier, biConsumer, binaryOperator2, function, CH_NOID);
    }

    private static <T> Supplier<T[]> boxSupplier(T t) {
        return () -> {
            RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
            return new Object[]{t};
        };
    }

    public static <T> Collector<T, ?, Optional<T>> reducing(BinaryOperator<T> binaryOperator) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$CollectorImpl");
        class OptionalBox
        implements Consumer<T> {
            T value;
            boolean present;
            final /* synthetic */ BinaryOperator val$op;

            OptionalBox(BinaryOperator binaryOperator) {
                this.val$op = binaryOperator;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                this.value = null;
                this.present = false;
            }

            @Override
            public void accept(T t) {
                RuntimeCostAccounter.recordJump();
                if (this.present) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BinaryOperator.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                    this.value = this.val$op.apply(this.value, t);
                    RuntimeCostAccounter.recordJump();
                } else {
                    this.value = t;
                    this.present = true;
                }
            }
        }
        Supplier<OptionalBox> supplier = () -> {
            RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$1OptionalBox");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$1OptionalBox.<init>:(Ljava/util/function/BinaryOperator;)V");
            return new OptionalBox(binaryOperator);
        };
        BiConsumer<OptionalBox, Object> biConsumer = OptionalBox::accept;
        BinaryOperator binaryOperator2 = (optionalBox, optionalBox2) -> {
            boolean bl = optionalBox2.present;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                Object t = optionalBox2.value;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$1OptionalBox.accept:(Ljava/lang/Object;)V");
                optionalBox.accept(t);
            }
            return optionalBox;
        };
        Function<OptionalBox, Optional> function = optionalBox -> {
            Object t = optionalBox.value;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Optional.ofNullable:(Ljava/lang/Object;)Ljava/util/Optional;");
            return Optional.ofNullable(t);
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$CollectorImpl.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;Ljava/util/function/Function;Ljava/util/Set;)V");
        return new CollectorImpl<Object, OptionalBox, Optional>(supplier, biConsumer, binaryOperator2, function, CH_NOID);
    }

    public static <T, U> Collector<T, ?, U> reducing(U u, Function<? super T, ? extends U> function, BinaryOperator<U> binaryOperator) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$CollectorImpl");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.boxSupplier:(Ljava/lang/Object;)Ljava/util/function/Supplier;");
        Supplier<U[]> supplier = Collectors.boxSupplier(u);
        BiConsumer<Object[], Object> biConsumer = (objectArray, object) -> {
            Object object2 = objectArray[0];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
            Object r = function.apply(object);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BinaryOperator.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            objectArray[0] = binaryOperator.apply(object2, r);
        };
        BinaryOperator binaryOperator2 = (objectArray, objectArray2) -> {
            Object object = objectArray[0];
            Object object2 = objectArray2[0];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BinaryOperator.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            objectArray[0] = binaryOperator.apply(object, object2);
            return objectArray;
        };
        Function<Object[], Object> function2 = objectArray -> objectArray[0];
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$CollectorImpl.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;Ljava/util/function/Function;Ljava/util/Set;)V");
        return new CollectorImpl<Object, Object[], Object>(supplier, biConsumer, binaryOperator2, function2, CH_NOID);
    }

    public static <T, K> Collector<T, ?, Map<K, List<T>>> groupingBy(Function<? super T, ? extends K> function) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.toList:()Ljava/util/stream/Collector;");
        Collector<T, ?, List<T>> collector = Collectors.toList();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.groupingBy:(Ljava/util/function/Function;Ljava/util/stream/Collector;)Ljava/util/stream/Collector;");
        return Collectors.groupingBy(function, collector);
    }

    public static <T, K, A, D> Collector<T, ?, Map<K, D>> groupingBy(Function<? super T, ? extends K> function, Collector<? super T, A, D> collector) {
        Supplier<Map> supplier = HashMap::new;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.groupingBy:(Ljava/util/function/Function;Ljava/util/function/Supplier;Ljava/util/stream/Collector;)Ljava/util/stream/Collector;");
        return Collectors.groupingBy(function, supplier, collector);
    }

    public static <T, K, D, A, M extends Map<K, D>> Collector<T, ?, M> groupingBy(Function<? super T, ? extends K> function, Supplier<M> supplier, Collector<? super T, A, D> collector) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.supplier:()Ljava/util/function/Supplier;");
        Supplier supplier2 = collector.supplier();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.accumulator:()Ljava/util/function/BiConsumer;");
        BiConsumer biConsumer = collector.accumulator();
        BiConsumer<Map, Object> biConsumer2 = (map, object2) -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
            Object r = function.apply(object2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
            Object r2 = Objects.requireNonNull(r, "element cannot be mapped to a null key");
            Function<Object, Object> function2 = object -> {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Supplier.get:()Ljava/lang/Object;");
                return supplier2.get();
            };
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.computeIfAbsent:(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;");
            Object object3 = map.computeIfAbsent(r2, function2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiConsumer.accept:(Ljava/lang/Object;Ljava/lang/Object;)V");
            biConsumer.accept(object3, object2);
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.combiner:()Ljava/util/function/BinaryOperator;");
        BinaryOperator<A> binaryOperator = collector.combiner();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.mapMerger:(Ljava/util/function/BinaryOperator;)Ljava/util/function/BinaryOperator;");
        BinaryOperator<M> binaryOperator2 = Collectors.mapMerger(binaryOperator);
        Supplier<M> supplier3 = supplier;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.characteristics:()Ljava/util/Set;");
        Set<Collector.Characteristics> set = collector.characteristics();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.contains:(Ljava/lang/Object;)Z");
        boolean bl = set.contains((Object)Collector.Characteristics.IDENTITY_FINISH);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$CollectorImpl");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$CollectorImpl.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;Ljava/util/Set;)V");
            return new CollectorImpl(supplier3, biConsumer2, binaryOperator2, CH_ID);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.finisher:()Ljava/util/function/Function;");
        Function function2 = collector.finisher();
        Function<Map, Map> function3 = map -> {
            BiFunction<Object, Object, Object> biFunction = (object, object2) -> {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
                return function2.apply(object2);
            };
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.replaceAll:(Ljava/util/function/BiFunction;)V");
            map.replaceAll(biFunction);
            Map map2 = map;
            return map2;
        };
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$CollectorImpl");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$CollectorImpl.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;Ljava/util/function/Function;Ljava/util/Set;)V");
        return new CollectorImpl<Object, Map, Map>(supplier3, biConsumer2, binaryOperator2, function3, CH_NOID);
    }

    public static <T, K> Collector<T, ?, ConcurrentMap<K, List<T>>> groupingByConcurrent(Function<? super T, ? extends K> function) {
        Supplier<ConcurrentMap> supplier = ConcurrentHashMap::new;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.toList:()Ljava/util/stream/Collector;");
        Collector<T, ?, List<T>> collector = Collectors.toList();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.groupingByConcurrent:(Ljava/util/function/Function;Ljava/util/function/Supplier;Ljava/util/stream/Collector;)Ljava/util/stream/Collector;");
        return Collectors.groupingByConcurrent(function, supplier, collector);
    }

    public static <T, K, A, D> Collector<T, ?, ConcurrentMap<K, D>> groupingByConcurrent(Function<? super T, ? extends K> function, Collector<? super T, A, D> collector) {
        Supplier<ConcurrentMap> supplier = ConcurrentHashMap::new;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.groupingByConcurrent:(Ljava/util/function/Function;Ljava/util/function/Supplier;Ljava/util/stream/Collector;)Ljava/util/stream/Collector;");
        return Collectors.groupingByConcurrent(function, supplier, collector);
    }

    public static <T, K, A, D, M extends ConcurrentMap<K, D>> Collector<T, ?, M> groupingByConcurrent(Function<? super T, ? extends K> function, Supplier<M> supplier, Collector<? super T, A, D> collector) {
        BiConsumer<ConcurrentMap, Object> biConsumer;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.supplier:()Ljava/util/function/Supplier;");
        Supplier supplier2 = collector.supplier();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.accumulator:()Ljava/util/function/BiConsumer;");
        BiConsumer biConsumer2 = collector.accumulator();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.combiner:()Ljava/util/function/BinaryOperator;");
        BinaryOperator<A> binaryOperator = collector.combiner();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.mapMerger:(Ljava/util/function/BinaryOperator;)Ljava/util/function/BinaryOperator;");
        BinaryOperator<M> binaryOperator2 = Collectors.mapMerger(binaryOperator);
        Supplier<M> supplier3 = supplier;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.characteristics:()Ljava/util/Set;");
        Set<Collector.Characteristics> set = collector.characteristics();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.contains:(Ljava/lang/Object;)Z");
        boolean bl = set.contains((Object)Collector.Characteristics.CONCURRENT);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            biConsumer = (concurrentMap, object2) -> {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
                Object r = function.apply(object2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                Object r2 = Objects.requireNonNull(r, "element cannot be mapped to a null key");
                Function<Object, Object> function2 = object -> {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Supplier.get:()Ljava/lang/Object;");
                    return supplier2.get();
                };
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.computeIfAbsent:(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;");
                Object object3 = concurrentMap.computeIfAbsent(r2, function2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiConsumer.accept:(Ljava/lang/Object;Ljava/lang/Object;)V");
                biConsumer2.accept(object3, object2);
            };
            RuntimeCostAccounter.recordJump();
        } else {
            biConsumer = (concurrentMap, object2) -> {
                Object object3;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
                Object r = function.apply(object2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                Object r2 = Objects.requireNonNull(r, "element cannot be mapped to a null key");
                Function<Object, Object> function2 = object -> {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Supplier.get:()Ljava/lang/Object;");
                    return supplier2.get();
                };
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.computeIfAbsent:(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;");
                Object object4 = object3 = concurrentMap.computeIfAbsent(r2, function2);
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiConsumer.accept:(Ljava/lang/Object;Ljava/lang/Object;)V");
                    biConsumer2.accept(object3, object2);
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
                RuntimeCostAccounter.recordJump();
            };
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.characteristics:()Ljava/util/Set;");
        Set<Collector.Characteristics> set2 = collector.characteristics();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.contains:(Ljava/lang/Object;)Z");
        boolean bl2 = set2.contains((Object)Collector.Characteristics.IDENTITY_FINISH);
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$CollectorImpl");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$CollectorImpl.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;Ljava/util/Set;)V");
            return new CollectorImpl(supplier3, biConsumer, binaryOperator2, CH_CONCURRENT_ID);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.finisher:()Ljava/util/function/Function;");
        Function function2 = collector.finisher();
        Function<ConcurrentMap, ConcurrentMap> function3 = concurrentMap -> {
            BiFunction<Object, Object, Object> biFunction = (object, object2) -> {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
                return function2.apply(object2);
            };
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.replaceAll:(Ljava/util/function/BiFunction;)V");
            concurrentMap.replaceAll(biFunction);
            ConcurrentMap concurrentMap2 = concurrentMap;
            return concurrentMap2;
        };
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$CollectorImpl");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$CollectorImpl.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;Ljava/util/function/Function;Ljava/util/Set;)V");
        return new CollectorImpl<Object, ConcurrentMap, ConcurrentMap>(supplier3, biConsumer, binaryOperator2, function3, CH_CONCURRENT_NOID);
    }

    public static <T> Collector<T, ?, Map<Boolean, List<T>>> partitioningBy(Predicate<? super T> predicate) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.toList:()Ljava/util/stream/Collector;");
        Collector<T, ?, List<T>> collector = Collectors.toList();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.partitioningBy:(Ljava/util/function/Predicate;Ljava/util/stream/Collector;)Ljava/util/stream/Collector;");
        return Collectors.partitioningBy(predicate, collector);
    }

    public static <T, D, A> Collector<T, ?, Map<Boolean, D>> partitioningBy(Predicate<? super T> predicate, Collector<? super T, A, D> collector) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.accumulator:()Ljava/util/function/BiConsumer;");
        BiConsumer biConsumer = collector.accumulator();
        BiConsumer<Partition, Object> biConsumer2 = (partition, object) -> {
            Object t;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Predicate.test:(Ljava/lang/Object;)Z");
            boolean bl = predicate.test(object);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                t = partition.forTrue;
                RuntimeCostAccounter.recordJump();
            } else {
                t = partition.forFalse;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiConsumer.accept:(Ljava/lang/Object;Ljava/lang/Object;)V");
            biConsumer.accept((Object)t, (Object)object);
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.combiner:()Ljava/util/function/BinaryOperator;");
        BinaryOperator binaryOperator = collector.combiner();
        BinaryOperator binaryOperator2 = (partition, partition2) -> {
            RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$Partition");
            Object t = partition.forTrue;
            Object t2 = partition2.forTrue;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BinaryOperator.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            Object r = binaryOperator.apply(t, t2);
            Object t3 = partition.forFalse;
            Object t4 = partition2.forFalse;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BinaryOperator.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            Object r2 = binaryOperator.apply(t3, t4);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$Partition.<init>:(Ljava/lang/Object;Ljava/lang/Object;)V");
            return new Partition(r, r2);
        };
        Supplier<Partition> supplier = () -> {
            RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$Partition");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.supplier:()Ljava/util/function/Supplier;");
            Supplier supplier = collector.supplier();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Supplier.get:()Ljava/lang/Object;");
            Object a = supplier.get();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.supplier:()Ljava/util/function/Supplier;");
            Supplier supplier2 = collector.supplier();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Supplier.get:()Ljava/lang/Object;");
            Object a2 = supplier2.get();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$Partition.<init>:(Ljava/lang/Object;Ljava/lang/Object;)V");
            return new Partition(a, a2);
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.characteristics:()Ljava/util/Set;");
        Set<Collector.Characteristics> set = collector.characteristics();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.contains:(Ljava/lang/Object;)Z");
        boolean bl = set.contains((Object)Collector.Characteristics.IDENTITY_FINISH);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$CollectorImpl");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$CollectorImpl.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;Ljava/util/Set;)V");
            return new CollectorImpl(supplier, biConsumer2, binaryOperator2, CH_ID);
        }
        Function<Partition, Map> function = partition -> {
            RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$Partition");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.finisher:()Ljava/util/function/Function;");
            Function function = collector.finisher();
            Object t = partition.forTrue;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
            Object r = function.apply(t);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.finisher:()Ljava/util/function/Function;");
            Function function2 = collector.finisher();
            Object t2 = partition.forFalse;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
            Object r2 = function2.apply(t2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$Partition.<init>:(Ljava/lang/Object;Ljava/lang/Object;)V");
            return new Partition(r, r2);
        };
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$CollectorImpl");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$CollectorImpl.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;Ljava/util/function/Function;Ljava/util/Set;)V");
        return new CollectorImpl<Object, Partition, Map>(supplier, biConsumer2, binaryOperator2, function, CH_NOID);
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toMap(Function<? super T, ? extends K> function, Function<? super T, ? extends U> function2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.throwingMerger:()Ljava/util/function/BinaryOperator;");
        BinaryOperator<T> binaryOperator = Collectors.throwingMerger();
        Supplier<Map> supplier = HashMap::new;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.toMap:(Ljava/util/function/Function;Ljava/util/function/Function;Ljava/util/function/BinaryOperator;Ljava/util/function/Supplier;)Ljava/util/stream/Collector;");
        return Collectors.toMap(function, function2, binaryOperator, supplier);
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toMap(Function<? super T, ? extends K> function, Function<? super T, ? extends U> function2, BinaryOperator<U> binaryOperator) {
        Supplier<Map> supplier = HashMap::new;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.toMap:(Ljava/util/function/Function;Ljava/util/function/Function;Ljava/util/function/BinaryOperator;Ljava/util/function/Supplier;)Ljava/util/stream/Collector;");
        return Collectors.toMap(function, function2, binaryOperator, supplier);
    }

    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toMap(Function<? super T, ? extends K> function, Function<? super T, ? extends U> function2, BinaryOperator<U> binaryOperator, Supplier<M> supplier) {
        BiConsumer<Map, Object> biConsumer = (map, object) -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
            Object r = function.apply(object);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
            Object r2 = function2.apply(object);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.merge:(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;");
            map.merge(r, r2, binaryOperator);
        };
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$CollectorImpl");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.mapMerger:(Ljava/util/function/BinaryOperator;)Ljava/util/function/BinaryOperator;");
        BinaryOperator<M> binaryOperator2 = Collectors.mapMerger(binaryOperator);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$CollectorImpl.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;Ljava/util/Set;)V");
        return new CollectorImpl(supplier, biConsumer, binaryOperator2, CH_ID);
    }

    public static <T, K, U> Collector<T, ?, ConcurrentMap<K, U>> toConcurrentMap(Function<? super T, ? extends K> function, Function<? super T, ? extends U> function2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.throwingMerger:()Ljava/util/function/BinaryOperator;");
        BinaryOperator<T> binaryOperator = Collectors.throwingMerger();
        Supplier<ConcurrentMap> supplier = ConcurrentHashMap::new;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.toConcurrentMap:(Ljava/util/function/Function;Ljava/util/function/Function;Ljava/util/function/BinaryOperator;Ljava/util/function/Supplier;)Ljava/util/stream/Collector;");
        return Collectors.toConcurrentMap(function, function2, binaryOperator, supplier);
    }

    public static <T, K, U> Collector<T, ?, ConcurrentMap<K, U>> toConcurrentMap(Function<? super T, ? extends K> function, Function<? super T, ? extends U> function2, BinaryOperator<U> binaryOperator) {
        Supplier<ConcurrentMap> supplier = ConcurrentHashMap::new;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.toConcurrentMap:(Ljava/util/function/Function;Ljava/util/function/Function;Ljava/util/function/BinaryOperator;Ljava/util/function/Supplier;)Ljava/util/stream/Collector;");
        return Collectors.toConcurrentMap(function, function2, binaryOperator, supplier);
    }

    public static <T, K, U, M extends ConcurrentMap<K, U>> Collector<T, ?, M> toConcurrentMap(Function<? super T, ? extends K> function, Function<? super T, ? extends U> function2, BinaryOperator<U> binaryOperator, Supplier<M> supplier) {
        BiConsumer<ConcurrentMap, Object> biConsumer = (concurrentMap, object) -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
            Object r = function.apply(object);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
            Object r2 = function2.apply(object);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.merge:(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;");
            concurrentMap.merge(r, r2, binaryOperator);
        };
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$CollectorImpl");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.mapMerger:(Ljava/util/function/BinaryOperator;)Ljava/util/function/BinaryOperator;");
        BinaryOperator<M> binaryOperator2 = Collectors.mapMerger(binaryOperator);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$CollectorImpl.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;Ljava/util/Set;)V");
        return new CollectorImpl(supplier, biConsumer, binaryOperator2, CH_CONCURRENT_ID);
    }

    public static <T> Collector<T, ?, IntSummaryStatistics> summarizingInt(ToIntFunction<? super T> toIntFunction) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$CollectorImpl");
        Supplier<IntSummaryStatistics> supplier = IntSummaryStatistics::new;
        BiConsumer<IntSummaryStatistics, Object> biConsumer = (intSummaryStatistics, object) -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/ToIntFunction.applyAsInt:(Ljava/lang/Object;)I");
            int n = toIntFunction.applyAsInt(object);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/IntSummaryStatistics.accept:(I)V");
            intSummaryStatistics.accept(n);
        };
        BinaryOperator binaryOperator = (intSummaryStatistics, intSummaryStatistics2) -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/IntSummaryStatistics.combine:(Ljava/util/IntSummaryStatistics;)V");
            intSummaryStatistics.combine((IntSummaryStatistics)intSummaryStatistics2);
            return intSummaryStatistics;
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$CollectorImpl.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;Ljava/util/Set;)V");
        return new CollectorImpl(supplier, biConsumer, binaryOperator, CH_ID);
    }

    public static <T> Collector<T, ?, LongSummaryStatistics> summarizingLong(ToLongFunction<? super T> toLongFunction) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$CollectorImpl");
        Supplier<LongSummaryStatistics> supplier = LongSummaryStatistics::new;
        BiConsumer<LongSummaryStatistics, Object> biConsumer = (longSummaryStatistics, object) -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/ToLongFunction.applyAsLong:(Ljava/lang/Object;)J");
            long l = toLongFunction.applyAsLong(object);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LongSummaryStatistics.accept:(J)V");
            longSummaryStatistics.accept(l);
        };
        BinaryOperator binaryOperator = (longSummaryStatistics, longSummaryStatistics2) -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LongSummaryStatistics.combine:(Ljava/util/LongSummaryStatistics;)V");
            longSummaryStatistics.combine((LongSummaryStatistics)longSummaryStatistics2);
            return longSummaryStatistics;
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$CollectorImpl.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;Ljava/util/Set;)V");
        return new CollectorImpl(supplier, biConsumer, binaryOperator, CH_ID);
    }

    public static <T> Collector<T, ?, DoubleSummaryStatistics> summarizingDouble(ToDoubleFunction<? super T> toDoubleFunction) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$CollectorImpl");
        Supplier<DoubleSummaryStatistics> supplier = DoubleSummaryStatistics::new;
        BiConsumer<DoubleSummaryStatistics, Object> biConsumer = (doubleSummaryStatistics, object) -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/ToDoubleFunction.applyAsDouble:(Ljava/lang/Object;)D");
            double d = toDoubleFunction.applyAsDouble(object);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/DoubleSummaryStatistics.accept:(D)V");
            doubleSummaryStatistics.accept(d);
        };
        BinaryOperator binaryOperator = (doubleSummaryStatistics, doubleSummaryStatistics2) -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/DoubleSummaryStatistics.combine:(Ljava/util/DoubleSummaryStatistics;)V");
            doubleSummaryStatistics.combine((DoubleSummaryStatistics)doubleSummaryStatistics2);
            return doubleSummaryStatistics;
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$CollectorImpl.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;Ljava/util/Set;)V");
        return new CollectorImpl(supplier, biConsumer, binaryOperator, CH_ID);
    }

    static /* synthetic */ Function access$000() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.castingIdentity:()Ljava/util/function/Function;");
        return Collectors.castingIdentity();
    }

    static {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.of:(Ljava/lang/Enum;Ljava/lang/Enum;Ljava/lang/Enum;)Ljava/util/EnumSet;");
        EnumSet<Collector.Characteristics> enumSet = EnumSet.of(Collector.Characteristics.CONCURRENT, Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.unmodifiableSet:(Ljava/util/Set;)Ljava/util/Set;");
        CH_CONCURRENT_ID = Collections.unmodifiableSet(enumSet);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.of:(Ljava/lang/Enum;Ljava/lang/Enum;)Ljava/util/EnumSet;");
        EnumSet<Collector.Characteristics> enumSet2 = EnumSet.of(Collector.Characteristics.CONCURRENT, Collector.Characteristics.UNORDERED);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.unmodifiableSet:(Ljava/util/Set;)Ljava/util/Set;");
        CH_CONCURRENT_NOID = Collections.unmodifiableSet(enumSet2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.of:(Ljava/lang/Enum;)Ljava/util/EnumSet;");
        EnumSet<Collector.Characteristics> enumSet3 = EnumSet.of(Collector.Characteristics.IDENTITY_FINISH);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.unmodifiableSet:(Ljava/util/Set;)Ljava/util/Set;");
        CH_ID = Collections.unmodifiableSet(enumSet3);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.of:(Ljava/lang/Enum;Ljava/lang/Enum;)Ljava/util/EnumSet;");
        EnumSet<Collector.Characteristics> enumSet4 = EnumSet.of(Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.unmodifiableSet:(Ljava/util/Set;)Ljava/util/Set;");
        CH_UNORDERED_ID = Collections.unmodifiableSet(enumSet4);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.emptySet:()Ljava/util/Set;");
        CH_NOID = Collections.emptySet();
    }

    private static final class Partition<T>
    extends AbstractMap<Boolean, T>
    implements Map<Boolean, T> {
        final T forTrue;
        final T forFalse;

        Partition(T t, T t2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap.<init>:()V");
            this.forTrue = t;
            this.forFalse = t2;
        }

        @Override
        public Set<Map.Entry<Boolean, T>> entrySet() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Collectors$Partition$1");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$Partition$1.<init>:(Ljava/util/stream/Collectors$Partition;)V");
            return new AbstractSet<Map.Entry<Boolean, T>>(){
                {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractSet.<init>:()V");
                }

                @Override
                public Iterator<Map.Entry<Boolean, T>> iterator() {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/AbstractMap$SimpleImmutableEntry");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Boolean.valueOf:(Z)Ljava/lang/Boolean;");
                    Boolean bl = false;
                    Object t = forFalse;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap$SimpleImmutableEntry.<init>:(Ljava/lang/Object;Ljava/lang/Object;)V");
                    AbstractMap.SimpleImmutableEntry simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry(bl, t);
                    RuntimeCostAccounter.recordAllocation((String)"java/util/AbstractMap$SimpleImmutableEntry");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Boolean.valueOf:(Z)Ljava/lang/Boolean;");
                    Boolean bl2 = true;
                    Object t2 = forTrue;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap$SimpleImmutableEntry.<init>:(Ljava/lang/Object;Ljava/lang/Object;)V");
                    AbstractMap.SimpleImmutableEntry simpleImmutableEntry2 = new AbstractMap.SimpleImmutableEntry(bl2, t2);
                    RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
                    Map.Entry[] entryArray = new Map.Entry[]{simpleImmutableEntry, simpleImmutableEntry2};
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.asList:([Ljava/lang/Object;)Ljava/util/List;");
                    List<Map.Entry> list = Arrays.asList(entryArray);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/List.iterator:()Ljava/util/Iterator;");
                    return list.iterator();
                }

                @Override
                public int size() {
                    return 2;
                }
            };
        }
    }

    static class CollectorImpl<T, A, R>
    implements Collector<T, A, R> {
        private final Supplier<A> supplier;
        private final BiConsumer<A, T> accumulator;
        private final BinaryOperator<A> combiner;
        private final Function<A, R> finisher;
        private final Set<Collector.Characteristics> characteristics;

        CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> biConsumer, BinaryOperator<A> binaryOperator, Function<A, R> function, Set<Collector.Characteristics> set) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.supplier = supplier;
            this.accumulator = biConsumer;
            this.combiner = binaryOperator;
            this.finisher = function;
            this.characteristics = set;
        }

        CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> biConsumer, BinaryOperator<A> binaryOperator, Set<Collector.Characteristics> set) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors.access$000:()Ljava/util/function/Function;");
            Function function = Collectors.access$000();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collectors$CollectorImpl.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;Ljava/util/function/Function;Ljava/util/Set;)V");
            this(supplier, biConsumer, binaryOperator, function, set);
        }

        @Override
        public BiConsumer<A, T> accumulator() {
            return this.accumulator;
        }

        @Override
        public Supplier<A> supplier() {
            return this.supplier;
        }

        @Override
        public BinaryOperator<A> combiner() {
            return this.combiner;
        }

        @Override
        public Function<A, R> finisher() {
            return this.finisher;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return this.characteristics;
        }
    }
}

