/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent.atomic;

import java.lang.reflect.Field;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.Serializable;
import sandbox.java.util.function.BinaryOperator;
import sandbox.java.util.function.UnaryOperator;
import sandbox.sun.misc.Unsafe;

public class AtomicReference<V>
implements Serializable {
    private static final long serialVersionUID = -1848883965231344442L;
    private static final Unsafe unsafe;
    private static final long valueOffset;
    private volatile V value;

    public AtomicReference(V v) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.value = v;
    }

    public AtomicReference() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
    }

    public final V get() {
        return this.value;
    }

    public final void set(V v) {
        this.value = v;
    }

    public final void lazySet(V v) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putOrderedObject:(Ljava/lang/Object;JLjava/lang/Object;)V");
        unsafe.putOrderedObject((Object)this, valueOffset, v);
    }

    public final boolean compareAndSet(V v, V v2) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
        return unsafe.compareAndSwapObject((Object)this, valueOffset, v, v2);
    }

    public final boolean weakCompareAndSet(V v, V v2) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
        return unsafe.compareAndSwapObject((Object)this, valueOffset, v, v2);
    }

    public final V getAndSet(V v) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getAndSetObject:(Ljava/lang/Object;JLjava/lang/Object;)Ljava/lang/Object;");
        return (V)unsafe.getAndSetObject((Object)this, valueOffset, v);
    }

    public final V getAndUpdate(UnaryOperator<V> unaryOperator) {
        V v;
        boolean bl;
        do {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReference.get:()Ljava/lang/Object;");
            v = this.get();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/UnaryOperator.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
            Object r = unaryOperator.apply(v);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReference.compareAndSet:(Ljava/lang/Object;Ljava/lang/Object;)Z");
            bl = this.compareAndSet(v, r);
            RuntimeCostAccounter.recordJump();
        } while (!bl);
        return v;
    }

    public final V updateAndGet(UnaryOperator<V> unaryOperator) {
        Object r;
        boolean bl;
        do {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReference.get:()Ljava/lang/Object;");
            V v = this.get();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/UnaryOperator.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
            r = unaryOperator.apply(v);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReference.compareAndSet:(Ljava/lang/Object;Ljava/lang/Object;)Z");
            bl = this.compareAndSet(v, r);
            RuntimeCostAccounter.recordJump();
        } while (!bl);
        return (V)r;
    }

    public final V getAndAccumulate(V v, BinaryOperator<V> binaryOperator) {
        V v2;
        boolean bl;
        do {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReference.get:()Ljava/lang/Object;");
            v2 = this.get();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BinaryOperator.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            Object r = binaryOperator.apply(v2, v);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReference.compareAndSet:(Ljava/lang/Object;Ljava/lang/Object;)Z");
            bl = this.compareAndSet(v2, r);
            RuntimeCostAccounter.recordJump();
        } while (!bl);
        return v2;
    }

    public final V accumulateAndGet(V v, BinaryOperator<V> binaryOperator) {
        Object r;
        boolean bl;
        do {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReference.get:()Ljava/lang/Object;");
            V v2 = this.get();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BinaryOperator.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            r = binaryOperator.apply(v2, v);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReference.compareAndSet:(Ljava/lang/Object;Ljava/lang/Object;)Z");
            bl = this.compareAndSet(v2, r);
            RuntimeCostAccounter.recordJump();
        } while (!bl);
        return (V)r;
    }

    public String toString() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReference.get:()Ljava/lang/Object;");
        V v = this.get();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.valueOf:(Ljava/lang/Object;)Ljava/lang/String;");
        return String.valueOf(v);
    }

    static {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getUnsafe:()Lsun/misc/Unsafe;");
        unsafe = Unsafe.getUnsafe();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field = AtomicReference.class.getDeclaredField("value");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            valueOffset = unsafe.objectFieldOffset(field);
        }
        catch (Exception exception) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/Throwable;)V");
            Error error = new Error(exception);
            RuntimeCostAccounter.recordThrow();
            throw error;
        }
        RuntimeCostAccounter.recordJump();
    }
}

