/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent;

import java.lang.reflect.Field;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.ObjectOutputStream;
import sandbox.java.io.Serializable;
import sandbox.java.util.AbstractQueue;
import sandbox.java.util.Arrays;
import sandbox.java.util.Collection;
import sandbox.java.util.Comparator;
import sandbox.java.util.Iterator;
import sandbox.java.util.NoSuchElementException;
import sandbox.java.util.PriorityQueue;
import sandbox.java.util.SortedSet;
import sandbox.java.util.Spliterator;
import sandbox.java.util.concurrent.BlockingQueue;
import sandbox.java.util.concurrent.TimeUnit;
import sandbox.java.util.concurrent.locks.Condition;
import sandbox.java.util.concurrent.locks.ReentrantLock;
import sandbox.java.util.function.Consumer;
import sandbox.sun.misc.Unsafe;

public class PriorityBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    private static final long serialVersionUID = 5595510919245408276L;
    private static final int DEFAULT_INITIAL_CAPACITY = 11;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private transient Object[] queue;
    private transient int size;
    private transient Comparator<? super E> comparator;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private volatile transient int allocationSpinLock;
    private PriorityQueue<E> q;
    private static final Unsafe UNSAFE;
    private static final long allocationSpinLockOffset;

    public PriorityBlockingQueue() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.<init>:(ILjava/util/Comparator;)V");
        this(11, null);
    }

    public PriorityBlockingQueue(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.<init>:(ILjava/util/Comparator;)V");
        this(n, null);
    }

    public PriorityBlockingQueue(int n, Comparator<? super E> comparator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractQueue.<init>:()V");
        RuntimeCostAccounter.recordJump();
        if (n < 1) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/ReentrantLock");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.<init>:()V");
        this.lock = new ReentrantLock();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.newCondition:()Ljava/util/concurrent/locks/Condition;");
        this.notEmpty = this.lock.newCondition();
        this.comparator = comparator;
        int n2 = n;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
        this.queue = new Object[n2];
    }

    public PriorityBlockingQueue(Collection<? extends E> collection) {
        int n;
        Object[] objectArray;
        boolean bl;
        block11: {
            block12: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractQueue.<init>:()V");
                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/ReentrantLock");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.<init>:()V");
                this.lock = new ReentrantLock();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.newCondition:()Ljava/util/concurrent/locks/Condition;");
                this.notEmpty = this.lock.newCondition();
                bl = true;
                boolean bl2 = true;
                boolean bl3 = collection instanceof SortedSet;
                RuntimeCostAccounter.recordJump();
                if (bl3) {
                    objectArray = (SortedSet)collection;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedSet.comparator:()Ljava/util/Comparator;");
                    this.comparator = objectArray.comparator();
                    bl = false;
                    RuntimeCostAccounter.recordJump();
                } else {
                    boolean bl4 = collection instanceof PriorityBlockingQueue;
                    RuntimeCostAccounter.recordJump();
                    if (bl4) {
                        objectArray = (PriorityBlockingQueue)collection;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.comparator:()Ljava/util/Comparator;");
                        this.comparator = objectArray.comparator();
                        bl2 = false;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                        Class<?> clazz = objectArray.getClass();
                        RuntimeCostAccounter.recordJump();
                        if (clazz == PriorityBlockingQueue.class) {
                            bl = false;
                        }
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.toArray:()[Ljava/lang/Object;");
                objectArray = collection.toArray();
                n = objectArray.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                Class<?> clazz = objectArray.getClass();
                RuntimeCostAccounter.recordJump();
                if (clazz != Object[].class) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;ILjava/lang/Class;)[Ljava/lang/Object;");
                    objectArray = Arrays.copyOf(objectArray, n, Object[].class);
                }
                RuntimeCostAccounter.recordJump();
                if (!bl2) break block11;
                RuntimeCostAccounter.recordJump();
                if (n == 1) break block12;
                RuntimeCostAccounter.recordJump();
                if (this.comparator == null) break block11;
            }
            int n2 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n2 >= n) break;
                Object object = objectArray[n2];
                RuntimeCostAccounter.recordJump();
                if (object == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                    NullPointerException nullPointerException = new NullPointerException();
                    RuntimeCostAccounter.recordThrow();
                    throw nullPointerException;
                }
                ++n2;
                RuntimeCostAccounter.recordJump();
            }
        }
        this.queue = objectArray;
        this.size = n;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.heapify:()V");
            this.heapify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryGrow(Object[] objectArray, int n) {
        Object[] objectArray2;
        block12: {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            this.lock.unlock();
            objectArray2 = null;
            RuntimeCostAccounter.recordJump();
            if (this.allocationSpinLock != 0) break block12;
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
            boolean bl = UNSAFE.compareAndSwapInt((Object)this, allocationSpinLockOffset, 0, 1);
            RuntimeCostAccounter.recordJump();
            if (!bl) break block12;
            try {
                int n2;
                block13: {
                    block15: {
                        block14: {
                            int n3;
                            RuntimeCostAccounter.recordJump();
                            if (n < 64) {
                                n3 = n + 2;
                                RuntimeCostAccounter.recordJump();
                            } else {
                                n3 = n >> 1;
                            }
                            n2 = n + n3;
                            RuntimeCostAccounter.recordJump();
                            if (n2 - 0x7FFFFFF7 <= 0) break block13;
                            int n4 = n + 1;
                            RuntimeCostAccounter.recordJump();
                            if (n4 < 0) break block14;
                            RuntimeCostAccounter.recordJump();
                            if (n4 <= 0x7FFFFFF7) break block15;
                        }
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/OutOfMemoryError");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/OutOfMemoryError.<init>:()V");
                        OutOfMemoryError outOfMemoryError = new OutOfMemoryError();
                        RuntimeCostAccounter.recordThrow();
                        throw outOfMemoryError;
                    }
                    n2 = 0x7FFFFFF7;
                }
                RuntimeCostAccounter.recordJump();
                if (n2 > n) {
                    RuntimeCostAccounter.recordJump();
                    if (this.queue == objectArray) {
                        int n5 = n2;
                        RuntimeCostAccounter.recordArrayAllocation((int)n5, (int)8);
                        objectArray2 = new Object[n5];
                    }
                }
                this.allocationSpinLock = 0;
            }
            catch (Throwable throwable) {
                this.allocationSpinLock = 0;
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (objectArray2 == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.yield:()V");
            Thread.yield();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        this.lock.lock();
        RuntimeCostAccounter.recordJump();
        if (objectArray2 != null) {
            RuntimeCostAccounter.recordJump();
            if (this.queue == objectArray) {
                this.queue = objectArray2;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                System.arraycopy(objectArray, 0, objectArray2, 0, n);
            }
        }
    }

    private E dequeue() {
        int n = this.size - 1;
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            return null;
        }
        Object[] objectArray = this.queue;
        Object object = objectArray[0];
        Object object2 = objectArray[n];
        objectArray[n] = null;
        Comparator<? super E> comparator = this.comparator;
        RuntimeCostAccounter.recordJump();
        if (comparator == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.siftDownComparable:(ILjava/lang/Object;[Ljava/lang/Object;I)V");
            PriorityBlockingQueue.siftDownComparable(0, object2, objectArray, n);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.siftDownUsingComparator:(ILjava/lang/Object;[Ljava/lang/Object;ILjava/util/Comparator;)V");
            PriorityBlockingQueue.siftDownUsingComparator(0, object2, objectArray, n, comparator);
        }
        this.size = n;
        return (E)object;
    }

    private static <T> void siftUpComparable(int n, T t, Object[] objectArray) {
        Comparable comparable = (Comparable)t;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n <= 0) break;
            int n2 = n - 1 >>> 1;
            Object object = objectArray[n2];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Comparable.compareTo:(Ljava/lang/Object;)I");
            int n3 = comparable.compareTo(object);
            RuntimeCostAccounter.recordJump();
            if (n3 >= 0) {
                RuntimeCostAccounter.recordJump();
                break;
            }
            objectArray[n] = object;
            n = n2;
            RuntimeCostAccounter.recordJump();
        }
        objectArray[n] = comparable;
    }

    private static <T> void siftUpUsingComparator(int n, T t, Object[] objectArray, Comparator<? super T> comparator) {
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n <= 0) break;
            int n2 = n - 1 >>> 1;
            Object object = objectArray[n2];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
            int n3 = comparator.compare(t, object);
            RuntimeCostAccounter.recordJump();
            if (n3 >= 0) {
                RuntimeCostAccounter.recordJump();
                break;
            }
            objectArray[n] = object;
            n = n2;
            RuntimeCostAccounter.recordJump();
        }
        objectArray[n] = t;
    }

    private static <T> void siftDownComparable(int n, T t, Object[] objectArray, int n2) {
        RuntimeCostAccounter.recordJump();
        if (n2 > 0) {
            Comparable comparable = (Comparable)t;
            int n3 = n2 >>> 1;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n >= n3) break;
                int n4 = (n << 1) + 1;
                Object object = objectArray[n4];
                int n5 = n4 + 1;
                RuntimeCostAccounter.recordJump();
                if (n5 < n2) {
                    Comparable comparable2 = (Comparable)object;
                    Object object2 = objectArray[n5];
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Comparable.compareTo:(Ljava/lang/Object;)I");
                    int n6 = comparable2.compareTo(object2);
                    RuntimeCostAccounter.recordJump();
                    if (n6 > 0) {
                        n4 = n5;
                        object = objectArray[n4];
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Comparable.compareTo:(Ljava/lang/Object;)I");
                int n7 = comparable.compareTo(object);
                RuntimeCostAccounter.recordJump();
                if (n7 <= 0) {
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                objectArray[n] = object;
                n = n4;
                RuntimeCostAccounter.recordJump();
            }
            objectArray[n] = comparable;
        }
    }

    private static <T> void siftDownUsingComparator(int n, T t, Object[] objectArray, int n2, Comparator<? super T> comparator) {
        RuntimeCostAccounter.recordJump();
        if (n2 > 0) {
            int n3 = n2 >>> 1;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n >= n3) break;
                int n4 = (n << 1) + 1;
                Object object = objectArray[n4];
                int n5 = n4 + 1;
                RuntimeCostAccounter.recordJump();
                if (n5 < n2) {
                    Object object2 = objectArray[n5];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
                    int n6 = comparator.compare(object, object2);
                    RuntimeCostAccounter.recordJump();
                    if (n6 > 0) {
                        n4 = n5;
                        object = objectArray[n4];
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
                int n7 = comparator.compare(t, object);
                RuntimeCostAccounter.recordJump();
                if (n7 <= 0) {
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                objectArray[n] = object;
                n = n4;
                RuntimeCostAccounter.recordJump();
            }
            objectArray[n] = t;
        }
    }

    private void heapify() {
        Object[] objectArray = this.queue;
        int n = this.size;
        int n2 = (n >>> 1) - 1;
        Comparator<? super E> comparator = this.comparator;
        RuntimeCostAccounter.recordJump();
        if (comparator == null) {
            int n3 = n2;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n3 < 0) break;
                Object object = objectArray[n3];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.siftDownComparable:(ILjava/lang/Object;[Ljava/lang/Object;I)V");
                PriorityBlockingQueue.siftDownComparable(n3, object, objectArray, n);
                --n3;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
        } else {
            int n4 = n2;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n4 < 0) break;
                Object object = objectArray[n4];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.siftDownUsingComparator:(ILjava/lang/Object;[Ljava/lang/Object;ILjava/util/Comparator;)V");
                PriorityBlockingQueue.siftDownUsingComparator(n4, object, objectArray, n, comparator);
                --n4;
                RuntimeCostAccounter.recordJump();
            }
        }
    }

    @Override
    public boolean add(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.offer:(Ljava/lang/Object;)Z");
        return this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        Object[] objectArray;
        int n;
        RuntimeCostAccounter.recordJump();
        if (e == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        while (true) {
            n = this.size;
            objectArray = this.queue;
            int n2 = this.queue.length;
            RuntimeCostAccounter.recordJump();
            if (n < n2) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.tryGrow:([Ljava/lang/Object;I)V");
            this.tryGrow(objectArray, n2);
            RuntimeCostAccounter.recordJump();
        }
        try {
            Comparator<? super E> comparator = this.comparator;
            RuntimeCostAccounter.recordJump();
            if (comparator == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.siftUpComparable:(ILjava/lang/Object;[Ljava/lang/Object;)V");
                PriorityBlockingQueue.siftUpComparable(n, e, objectArray);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.siftUpUsingComparator:(ILjava/lang/Object;[Ljava/lang/Object;Ljava/util/Comparator;)V");
                PriorityBlockingQueue.siftUpUsingComparator(n, e, objectArray, comparator);
            }
            this.size = n + 1;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
            this.notEmpty.signal();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
        return true;
    }

    @Override
    public void put(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.offer:(Ljava/lang/Object;)Z");
        this.offer(e);
    }

    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.offer:(Ljava/lang/Object;)Z");
        return this.offer(e);
    }

    @Override
    public E poll() {
        E e;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.dequeue:()Ljava/lang/Object;");
            e = this.dequeue();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return e;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E take() throws InterruptedException {
        E e;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lockInterruptibly:()V");
        reentrantLock.lockInterruptibly();
        try {
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.dequeue:()Ljava/lang/Object;");
                e = this.dequeue();
                RuntimeCostAccounter.recordJump();
                if (e == null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.await:()V");
                    this.notEmpty.await();
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E poll(long l, TimeUnit timeUnit) throws InterruptedException {
        E e;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toNanos:(J)J");
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lockInterruptibly:()V");
        reentrantLock.lockInterruptibly();
        try {
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.dequeue:()Ljava/lang/Object;");
                e = this.dequeue();
                RuntimeCostAccounter.recordJump();
                if (e == null) {
                    RuntimeCostAccounter.recordJump();
                    if (l2 > 0L) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.awaitNanos:(J)J");
                        l2 = this.notEmpty.awaitNanos(l2);
                        RuntimeCostAccounter.recordJump();
                        continue;
                    }
                }
                break;
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
        return e;
    }

    @Override
    public E peek() {
        Object object;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            Object object2;
            RuntimeCostAccounter.recordJump();
            if (this.size == 0) {
                object2 = null;
                RuntimeCostAccounter.recordJump();
            } else {
                object2 = this.queue[0];
            }
            object = object2;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return (E)object;
    }

    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public int size() {
        int n;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            n = this.size;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return n;
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    private int indexOf(Object object) {
        RuntimeCostAccounter.recordJump();
        if (object != null) {
            Object[] objectArray = this.queue;
            int n = this.size;
            int n2 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n2 >= n) break;
                Object object2 = objectArray[n2];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl = object.equals(object2);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    return n2;
                }
                ++n2;
                RuntimeCostAccounter.recordJump();
            }
        }
        return -1;
    }

    private void removeAt(int n) {
        Object[] objectArray = this.queue;
        int n2 = this.size - 1;
        RuntimeCostAccounter.recordJump();
        if (n2 == n) {
            objectArray[n] = null;
            RuntimeCostAccounter.recordJump();
        } else {
            Object object = objectArray[n2];
            objectArray[n2] = null;
            Comparator<? super E> comparator = this.comparator;
            RuntimeCostAccounter.recordJump();
            if (comparator == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.siftDownComparable:(ILjava/lang/Object;[Ljava/lang/Object;I)V");
                PriorityBlockingQueue.siftDownComparable(n, object, objectArray, n2);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.siftDownUsingComparator:(ILjava/lang/Object;[Ljava/lang/Object;ILjava/util/Comparator;)V");
                PriorityBlockingQueue.siftDownUsingComparator(n, object, objectArray, n2, comparator);
            }
            Object object2 = objectArray[n];
            RuntimeCostAccounter.recordJump();
            if (object2 == object) {
                RuntimeCostAccounter.recordJump();
                if (comparator == null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.siftUpComparable:(ILjava/lang/Object;[Ljava/lang/Object;)V");
                    PriorityBlockingQueue.siftUpComparable(n, object, objectArray);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.siftUpUsingComparator:(ILjava/lang/Object;[Ljava/lang/Object;Ljava/util/Comparator;)V");
                    PriorityBlockingQueue.siftUpUsingComparator(n, object, objectArray, comparator);
                }
            }
        }
        this.size = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        int n;
        ReentrantLock reentrantLock;
        block3: {
            boolean bl;
            reentrantLock = this.lock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.indexOf:(Ljava/lang/Object;)I");
                n = this.indexOf(object);
                RuntimeCostAccounter.recordJump();
                if (n != -1) break block3;
                bl = false;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            return bl;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.removeAt:(I)V");
        this.removeAt(n);
        boolean bl = true;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeEQ(Object object) {
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            Object[] objectArray = this.queue;
            int n = 0;
            int n2 = this.size;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n >= n2) break;
                Object object2 = objectArray[n];
                RuntimeCostAccounter.recordJump();
                if (object == object2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.removeAt:(I)V");
                    this.removeAt(n);
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                ++n;
                RuntimeCostAccounter.recordJump();
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object object) {
        boolean bl;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            boolean bl2;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.indexOf:(Ljava/lang/Object;)I");
            int n = this.indexOf(object);
            RuntimeCostAccounter.recordJump();
            if (n != -1) {
                bl2 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return bl;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;I)[Ljava/lang/Object;");
            objectArray = Arrays.copyOf(this.queue, this.size);
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        String string;
        int n;
        ReentrantLock reentrantLock;
        block7: {
            reentrantLock = this.lock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            n = this.size;
            RuntimeCostAccounter.recordJump();
            if (n != 0) break block7;
            String string2 = "[]";
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            return string2;
        }
        try {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            stringBuilder.append('[');
            int n2 = 0;
            while (true) {
                Object object;
                RuntimeCostAccounter.recordJump();
                if (n2 >= n) break;
                Object object2 = this.queue[n2];
                RuntimeCostAccounter.recordJump();
                if (object2 == this) {
                    object = "(this Collection)";
                    RuntimeCostAccounter.recordJump();
                } else {
                    object = object2;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                stringBuilder.append(object);
                RuntimeCostAccounter.recordJump();
                if (n2 != n - 1) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder2 = stringBuilder.append(',');
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                    stringBuilder2.append(' ');
                }
                ++n2;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder.append(']');
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            string = stringBuilder3.toString();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return string;
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.drainTo:(Ljava/util/Collection;I)I");
        return this.drainTo(collection, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        int n2;
        RuntimeCostAccounter.recordJump();
        if (collection == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordJump();
        if (collection == this) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        if (n <= 0) {
            return 0;
        }
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
            int n3 = Math.min(this.size, n);
            n2 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n2 >= n3) break;
                Object object = this.queue[0];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.add:(Ljava/lang/Object;)Z");
                collection.add(object);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.dequeue:()Ljava/lang/Object;");
                this.dequeue();
                ++n2;
                RuntimeCostAccounter.recordJump();
            }
            n2 = n3;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void clear() {
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            Object[] objectArray = this.queue;
            int n = this.size;
            this.size = 0;
            int n2 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n2 < n) {
                    objectArray[n2] = null;
                    ++n2;
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] TArray) {
        int n;
        ReentrantLock reentrantLock;
        block4: {
            T[] TArray2;
            reentrantLock = this.lock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            try {
                n = this.size;
                int n2 = TArray.length;
                RuntimeCostAccounter.recordJump();
                if (n2 >= n) break block4;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                Class<?> clazz = TArray.getClass();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;ILjava/lang/Class;)[Ljava/lang/Object;");
                TArray2 = Arrays.copyOf(this.queue, this.size, clazz);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            return TArray2;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
        System.arraycopy(this.queue, 0, TArray, 0, n);
        int n3 = TArray.length;
        RuntimeCostAccounter.recordJump();
        if (n3 > n) {
            TArray[n] = null;
        }
        T[] TArray3 = TArray;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return TArray3;
    }

    @Override
    public Iterator<E> iterator() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/PriorityBlockingQueue$Itr");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.toArray:()[Ljava/lang/Object;");
        Object[] objectArray = this.toArray();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue$Itr.<init>:(Ljava/util/concurrent/PriorityBlockingQueue;[Ljava/lang/Object;)V");
        return new Itr(objectArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        this.lock.lock();
        try {
            RuntimeCostAccounter.recordAllocation((String)"java/util/PriorityQueue");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
            int n = Math.max(this.size, 1);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.<init>:(ILjava/util/Comparator;)V");
            this.q = new PriorityQueue<E>(n, this.comparator);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.addAll:(Ljava/util/Collection;)Z");
            this.q.addAll(this);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.defaultWriteObject:()V");
            objectOutputStream.defaultWriteObject();
            this.q = null;
        }
        catch (Throwable throwable) {
            this.q = null;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            this.lock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        this.lock.unlock();
        RuntimeCostAccounter.recordJump();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.defaultReadObject:()V");
            objectInputStream.defaultReadObject();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.size:()I");
            int n = this.q.size();
            RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
            this.queue = new Object[n];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.comparator:()Ljava/util/Comparator;");
            this.comparator = this.q.comparator();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.addAll:(Ljava/util/Collection;)Z");
            this.addAll(this.q);
            this.q = null;
        }
        catch (Throwable throwable) {
            this.q = null;
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    @Override
    public Spliterator<E> spliterator() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/PriorityBlockingQueue$PBQSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue$PBQSpliterator.<init>:(Ljava/util/concurrent/PriorityBlockingQueue;[Ljava/lang/Object;II)V");
        return new PBQSpliterator(this, null, 0, -1);
    }

    static {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getUnsafe:()Lsun/misc/Unsafe;");
            UNSAFE = Unsafe.getUnsafe();
            Class<PriorityBlockingQueue> clazz = PriorityBlockingQueue.class;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field = clazz.getDeclaredField("allocationSpinLock");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            allocationSpinLockOffset = UNSAFE.objectFieldOffset(field);
        }
        catch (Exception exception) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/Throwable;)V");
            Error error = new Error(exception);
            RuntimeCostAccounter.recordThrow();
            throw error;
        }
        RuntimeCostAccounter.recordJump();
    }

    static final class PBQSpliterator<E>
    implements Spliterator<E> {
        final PriorityBlockingQueue<E> queue;
        Object[] array;
        int index;
        int fence;

        PBQSpliterator(PriorityBlockingQueue<E> priorityBlockingQueue, Object[] objectArray, int n, int n2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.queue = priorityBlockingQueue;
            this.array = objectArray;
            this.index = n;
            this.fence = n2;
        }

        final int getFence() {
            int n = this.fence;
            RuntimeCostAccounter.recordJump();
            if (n < 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.toArray:()[Ljava/lang/Object;");
                this.array = this.queue.toArray();
                n = this.fence = this.array.length;
            }
            return n;
        }

        @Override
        public Spliterator<E> trySplit() {
            PBQSpliterator<E> pBQSpliterator;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue$PBQSpliterator.getFence:()I");
            int n = this.getFence();
            int n2 = this.index;
            int n3 = n2 + n >>> 1;
            RuntimeCostAccounter.recordJump();
            if (n2 >= n3) {
                pBQSpliterator = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/PriorityBlockingQueue$PBQSpliterator");
                this.index = n3;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue$PBQSpliterator.<init>:(Ljava/util/concurrent/PriorityBlockingQueue;[Ljava/lang/Object;II)V");
                PBQSpliterator<E> pBQSpliterator2 = new PBQSpliterator<E>(this.queue, this.array, n2, this.index);
                pBQSpliterator = pBQSpliterator2;
            }
            return pBQSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> consumer) {
            RuntimeCostAccounter.recordJump();
            if (consumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            Object[] objectArray = this.array;
            RuntimeCostAccounter.recordJump();
            if (this.array == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.toArray:()[Ljava/lang/Object;");
                objectArray = this.queue.toArray();
                this.fence = objectArray.length;
            }
            int n = this.fence;
            int n2 = objectArray.length;
            RuntimeCostAccounter.recordJump();
            if (n <= n2) {
                int n3 = this.index;
                RuntimeCostAccounter.recordJump();
                if (n3 >= 0) {
                    this.index = n;
                    RuntimeCostAccounter.recordJump();
                    if (n3 < this.index) {
                        do {
                            Object object = objectArray[n3];
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                            consumer.accept(object);
                            RuntimeCostAccounter.recordJump();
                        } while (++n3 < n);
                    }
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> consumer) {
            RuntimeCostAccounter.recordJump();
            if (consumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue$PBQSpliterator.getFence:()I");
            int n = this.getFence();
            RuntimeCostAccounter.recordJump();
            if (n > this.index) {
                RuntimeCostAccounter.recordJump();
                if (this.index >= 0) {
                    Object object = this.array[this.index++];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                    consumer.accept(object);
                    return true;
                }
            }
            return false;
        }

        @Override
        public long estimateSize() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue$PBQSpliterator.getFence:()I");
            return this.getFence() - this.index;
        }

        @Override
        public int characteristics() {
            return 16704;
        }
    }

    final class Itr
    implements Iterator<E> {
        final Object[] array;
        int cursor;
        int lastRet;

        Itr(Object[] objectArray) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.lastRet = -1;
            this.array = objectArray;
        }

        @Override
        public boolean hasNext() {
            boolean bl;
            int n = this.array.length;
            RuntimeCostAccounter.recordJump();
            if (this.cursor < n) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public E next() {
            int n = this.array.length;
            RuntimeCostAccounter.recordJump();
            if (this.cursor >= n) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                NoSuchElementException noSuchElementException = new NoSuchElementException();
                RuntimeCostAccounter.recordThrow();
                throw noSuchElementException;
            }
            this.lastRet = this.cursor;
            return this.array[this.cursor++];
        }

        @Override
        public void remove() {
            RuntimeCostAccounter.recordJump();
            if (this.lastRet < 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
                IllegalStateException illegalStateException = new IllegalStateException();
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            Object object = this.array[this.lastRet];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/PriorityBlockingQueue.removeEQ:(Ljava/lang/Object;)V");
            PriorityBlockingQueue.this.removeEQ(object);
            this.lastRet = -1;
        }
    }
}

