/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent;

import java.lang.reflect.Array;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.ObjectOutputStream;
import sandbox.java.io.Serializable;
import sandbox.java.util.AbstractQueue;
import sandbox.java.util.Collection;
import sandbox.java.util.Iterator;
import sandbox.java.util.NoSuchElementException;
import sandbox.java.util.Spliterator;
import sandbox.java.util.Spliterators;
import sandbox.java.util.concurrent.BlockingDeque;
import sandbox.java.util.concurrent.TimeUnit;
import sandbox.java.util.concurrent.locks.Condition;
import sandbox.java.util.concurrent.locks.ReentrantLock;
import sandbox.java.util.function.Consumer;

public class LinkedBlockingDeque<E>
extends AbstractQueue<E>
implements BlockingDeque<E>,
Serializable {
    private static final long serialVersionUID = -387911632671998426L;
    transient Node<E> first;
    transient Node<E> last;
    private transient int count;
    private final int capacity;
    final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;

    public LinkedBlockingDeque() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.<init>:(I)V");
        this(Integer.MAX_VALUE);
    }

    public LinkedBlockingDeque(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractQueue.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/ReentrantLock");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.<init>:()V");
        this.lock = new ReentrantLock();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.newCondition:()Ljava/util/concurrent/locks/Condition;");
        this.notEmpty = this.lock.newCondition();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.newCondition:()Ljava/util/concurrent/locks/Condition;");
        this.notFull = this.lock.newCondition();
        RuntimeCostAccounter.recordJump();
        if (n <= 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        this.capacity = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LinkedBlockingDeque(Collection<? extends E> collection) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.<init>:(I)V");
        this(Integer.MAX_VALUE);
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
            Iterator<E> iterator = collection.iterator();
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl = iterator.hasNext();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                    E e = iterator.next();
                    RuntimeCostAccounter.recordJump();
                    if (e == null) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                        NullPointerException nullPointerException = new NullPointerException();
                        RuntimeCostAccounter.recordThrow();
                        throw nullPointerException;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/LinkedBlockingDeque$Node");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque$Node.<init>:(Ljava/lang/Object;)V");
                    Node<E> node = new Node<E>(e);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.linkLast:(Ljava/util/concurrent/LinkedBlockingDeque$Node;)Z");
                    boolean bl2 = super.linkLast(node);
                    RuntimeCostAccounter.recordJump();
                    if (!bl2) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                        IllegalStateException illegalStateException = new IllegalStateException("Deque full");
                        RuntimeCostAccounter.recordThrow();
                        throw illegalStateException;
                    }
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
    }

    private boolean linkFirst(Node<E> node) {
        RuntimeCostAccounter.recordJump();
        if (this.count >= this.capacity) {
            return false;
        }
        Node<E> node2 = this.first;
        node.next = node2;
        this.first = node;
        RuntimeCostAccounter.recordJump();
        if (this.last == null) {
            this.last = node;
            RuntimeCostAccounter.recordJump();
        } else {
            node2.prev = node;
        }
        ++this.count;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
        this.notEmpty.signal();
        return true;
    }

    private boolean linkLast(Node<E> node) {
        RuntimeCostAccounter.recordJump();
        if (this.count >= this.capacity) {
            return false;
        }
        Node<E> node2 = this.last;
        node.prev = node2;
        this.last = node;
        RuntimeCostAccounter.recordJump();
        if (this.first == null) {
            this.first = node;
            RuntimeCostAccounter.recordJump();
        } else {
            node2.next = node;
        }
        ++this.count;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
        this.notEmpty.signal();
        return true;
    }

    private E unlinkFirst() {
        Node<E> node = this.first;
        RuntimeCostAccounter.recordJump();
        if (node == null) {
            return null;
        }
        Node node2 = node.next;
        Object e = node.item;
        node.item = null;
        node.next = node;
        this.first = node2;
        RuntimeCostAccounter.recordJump();
        if (node2 == null) {
            this.last = null;
            RuntimeCostAccounter.recordJump();
        } else {
            node2.prev = null;
        }
        --this.count;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
        this.notFull.signal();
        return e;
    }

    private E unlinkLast() {
        Node<E> node = this.last;
        RuntimeCostAccounter.recordJump();
        if (node == null) {
            return null;
        }
        Node node2 = node.prev;
        Object e = node.item;
        node.item = null;
        node.prev = node;
        this.last = node2;
        RuntimeCostAccounter.recordJump();
        if (node2 == null) {
            this.first = null;
            RuntimeCostAccounter.recordJump();
        } else {
            node2.next = null;
        }
        --this.count;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
        this.notFull.signal();
        return e;
    }

    void unlink(Node<E> node) {
        Node node2 = node.prev;
        Node node3 = node.next;
        RuntimeCostAccounter.recordJump();
        if (node2 == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.unlinkFirst:()Ljava/lang/Object;");
            this.unlinkFirst();
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordJump();
            if (node3 == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.unlinkLast:()Ljava/lang/Object;");
                this.unlinkLast();
                RuntimeCostAccounter.recordJump();
            } else {
                node2.next = node3;
                node3.prev = node2;
                node.item = null;
                --this.count;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
                this.notFull.signal();
            }
        }
    }

    @Override
    public void addFirst(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.offerFirst:(Ljava/lang/Object;)Z");
        boolean bl = this.offerFirst(e);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
            IllegalStateException illegalStateException = new IllegalStateException("Deque full");
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
    }

    @Override
    public void addLast(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.offerLast:(Ljava/lang/Object;)Z");
        boolean bl = this.offerLast(e);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
            IllegalStateException illegalStateException = new IllegalStateException("Deque full");
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerFirst(E e) {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (e == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/LinkedBlockingDeque$Node");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque$Node.<init>:(Ljava/lang/Object;)V");
        Node<E> node = new Node<E>(e);
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.linkFirst:(Ljava/util/concurrent/LinkedBlockingDeque$Node;)Z");
            bl = this.linkFirst(node);
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerLast(E e) {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (e == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/LinkedBlockingDeque$Node");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque$Node.<init>:(Ljava/lang/Object;)V");
        Node<E> node = new Node<E>(e);
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.linkLast:(Ljava/util/concurrent/LinkedBlockingDeque$Node;)Z");
            bl = this.linkLast(node);
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void putFirst(E e) throws InterruptedException {
        RuntimeCostAccounter.recordJump();
        if (e == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/LinkedBlockingDeque$Node");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque$Node.<init>:(Ljava/lang/Object;)V");
        Node<E> node = new Node<E>(e);
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.linkFirst:(Ljava/util/concurrent/LinkedBlockingDeque$Node;)Z");
                boolean bl = this.linkFirst(node);
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.await:()V");
                    this.notFull.await();
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void putLast(E e) throws InterruptedException {
        RuntimeCostAccounter.recordJump();
        if (e == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/LinkedBlockingDeque$Node");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque$Node.<init>:(Ljava/lang/Object;)V");
        Node<E> node = new Node<E>(e);
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.linkLast:(Ljava/util/concurrent/LinkedBlockingDeque$Node;)Z");
                boolean bl = this.linkLast(node);
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.await:()V");
                    this.notFull.await();
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean offerFirst(E var1_1, long var2_2, TimeUnit var4_3) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean offerLast(E var1_1, long var2_2, TimeUnit var4_3) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public E removeFirst() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.pollFirst:()Ljava/lang/Object;");
        E e = this.pollFirst();
        RuntimeCostAccounter.recordJump();
        if (e == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
            NoSuchElementException noSuchElementException = new NoSuchElementException();
            RuntimeCostAccounter.recordThrow();
            throw noSuchElementException;
        }
        return e;
    }

    @Override
    public E removeLast() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.pollLast:()Ljava/lang/Object;");
        E e = this.pollLast();
        RuntimeCostAccounter.recordJump();
        if (e == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
            NoSuchElementException noSuchElementException = new NoSuchElementException();
            RuntimeCostAccounter.recordThrow();
            throw noSuchElementException;
        }
        return e;
    }

    @Override
    public E pollFirst() {
        E e;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.unlinkFirst:()Ljava/lang/Object;");
            e = this.unlinkFirst();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return e;
    }

    @Override
    public E pollLast() {
        E e;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.unlinkLast:()Ljava/lang/Object;");
            e = this.unlinkLast();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E takeFirst() throws InterruptedException {
        E e;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            E e2;
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.unlinkFirst:()Ljava/lang/Object;");
                e2 = this.unlinkFirst();
                RuntimeCostAccounter.recordJump();
                if (e2 != null) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.await:()V");
                this.notEmpty.await();
                RuntimeCostAccounter.recordJump();
            }
            e = e2;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E takeLast() throws InterruptedException {
        E e;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            E e2;
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.unlinkLast:()Ljava/lang/Object;");
                e2 = this.unlinkLast();
                RuntimeCostAccounter.recordJump();
                if (e2 != null) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.await:()V");
                this.notEmpty.await();
                RuntimeCostAccounter.recordJump();
            }
            e = e2;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return e;
    }

    /*
     * Exception decompiling
     */
    @Override
    public E pollFirst(long var1_1, TimeUnit var3_2) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public E pollLast(long var1_1, TimeUnit var3_2) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public E getFirst() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.peekFirst:()Ljava/lang/Object;");
        E e = this.peekFirst();
        RuntimeCostAccounter.recordJump();
        if (e == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
            NoSuchElementException noSuchElementException = new NoSuchElementException();
            RuntimeCostAccounter.recordThrow();
            throw noSuchElementException;
        }
        return e;
    }

    @Override
    public E getLast() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.peekLast:()Ljava/lang/Object;");
        E e = this.peekLast();
        RuntimeCostAccounter.recordJump();
        if (e == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
            NoSuchElementException noSuchElementException = new NoSuchElementException();
            RuntimeCostAccounter.recordThrow();
            throw noSuchElementException;
        }
        return e;
    }

    @Override
    public E peekFirst() {
        E e;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            E e2;
            RuntimeCostAccounter.recordJump();
            if (this.first == null) {
                e2 = null;
                RuntimeCostAccounter.recordJump();
            } else {
                e2 = this.first.item;
            }
            e = e2;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return e;
    }

    @Override
    public E peekLast() {
        E e;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            E e2;
            RuntimeCostAccounter.recordJump();
            if (this.last == null) {
                e2 = null;
                RuntimeCostAccounter.recordJump();
            } else {
                e2 = this.last.item;
            }
            e = e2;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean removeFirstOccurrence(Object object) {
        boolean bl;
        ReentrantLock reentrantLock;
        block6: {
            boolean bl2;
            RuntimeCostAccounter.recordJump();
            if (object == null) {
                return false;
            }
            reentrantLock = this.lock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            try {
                Node<E> node = this.first;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (node == null) break;
                    Object e = node.item;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                    boolean bl3 = object.equals(e);
                    RuntimeCostAccounter.recordJump();
                    if (bl3) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.unlink:(Ljava/util/concurrent/LinkedBlockingDeque$Node;)V");
                        this.unlink(node);
                        bl = true;
                        break block6;
                    }
                    node = node.next;
                    RuntimeCostAccounter.recordJump();
                }
                bl2 = false;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            return bl2;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean removeLastOccurrence(Object object) {
        boolean bl;
        ReentrantLock reentrantLock;
        block6: {
            boolean bl2;
            RuntimeCostAccounter.recordJump();
            if (object == null) {
                return false;
            }
            reentrantLock = this.lock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            try {
                Node<E> node = this.last;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (node == null) break;
                    Object e = node.item;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                    boolean bl3 = object.equals(e);
                    RuntimeCostAccounter.recordJump();
                    if (bl3) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.unlink:(Ljava/util/concurrent/LinkedBlockingDeque$Node;)V");
                        this.unlink(node);
                        bl = true;
                        break block6;
                    }
                    node = node.prev;
                    RuntimeCostAccounter.recordJump();
                }
                bl2 = false;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            return bl2;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return bl;
    }

    @Override
    public boolean add(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.addLast:(Ljava/lang/Object;)V");
        this.addLast(e);
        return true;
    }

    @Override
    public boolean offer(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.offerLast:(Ljava/lang/Object;)Z");
        return this.offerLast(e);
    }

    @Override
    public void put(E e) throws InterruptedException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.putLast:(Ljava/lang/Object;)V");
        this.putLast(e);
    }

    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) throws InterruptedException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.offerLast:(Ljava/lang/Object;JLjava/util/concurrent/TimeUnit;)Z");
        return this.offerLast(e, l, timeUnit);
    }

    @Override
    public E remove() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.removeFirst:()Ljava/lang/Object;");
        return this.removeFirst();
    }

    @Override
    public E poll() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.pollFirst:()Ljava/lang/Object;");
        return this.pollFirst();
    }

    @Override
    public E take() throws InterruptedException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.takeFirst:()Ljava/lang/Object;");
        return this.takeFirst();
    }

    @Override
    public E poll(long l, TimeUnit timeUnit) throws InterruptedException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.pollFirst:(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;");
        return this.pollFirst(l, timeUnit);
    }

    @Override
    public E element() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.getFirst:()Ljava/lang/Object;");
        return this.getFirst();
    }

    @Override
    public E peek() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.peekFirst:()Ljava/lang/Object;");
        return this.peekFirst();
    }

    @Override
    public int remainingCapacity() {
        int n;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            n = this.capacity - this.count;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return n;
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.drainTo:(Ljava/util/Collection;I)I");
        return this.drainTo(collection, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        int n2;
        RuntimeCostAccounter.recordJump();
        if (collection == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordJump();
        if (collection == this) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        if (n <= 0) {
            return 0;
        }
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
            int n3 = Math.min(n, this.count);
            n2 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n2 >= n3) break;
                Object e = this.first.item;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.add:(Ljava/lang/Object;)Z");
                collection.add(e);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.unlinkFirst:()Ljava/lang/Object;");
                this.unlinkFirst();
                ++n2;
                RuntimeCostAccounter.recordJump();
            }
            n2 = n3;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return n2;
    }

    @Override
    public void push(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.addFirst:(Ljava/lang/Object;)V");
        this.addFirst(e);
    }

    @Override
    public E pop() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.removeFirst:()Ljava/lang/Object;");
        return this.removeFirst();
    }

    @Override
    public boolean remove(Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.removeFirstOccurrence:(Ljava/lang/Object;)Z");
        return this.removeFirstOccurrence(object);
    }

    @Override
    public int size() {
        int n;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            n = this.count;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean contains(Object object) {
        boolean bl;
        ReentrantLock reentrantLock;
        block6: {
            boolean bl2;
            RuntimeCostAccounter.recordJump();
            if (object == null) {
                return false;
            }
            reentrantLock = this.lock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            try {
                Node<E> node = this.first;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (node == null) break;
                    Object e = node.item;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                    boolean bl3 = object.equals(e);
                    RuntimeCostAccounter.recordJump();
                    if (bl3) {
                        bl = true;
                        break block6;
                    }
                    node = node.next;
                    RuntimeCostAccounter.recordJump();
                }
                bl2 = false;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            return bl2;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object object;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            int n = this.count;
            RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
            Object[] objectArray = new Object[n];
            int n2 = 0;
            object = this.first;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (object == null) break;
                objectArray[n2++] = object.item;
                object = object.next;
                RuntimeCostAccounter.recordJump();
            }
            object = objectArray;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] objectArray) {
        Object object;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            int n = objectArray.length;
            RuntimeCostAccounter.recordJump();
            if (n < this.count) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                Class<?> clazz = objectArray.getClass();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getComponentType:()Ljava/lang/Class;");
                Class<?> clazz2 = clazz.getComponentType();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/reflect/Array.newInstance:(Ljava/lang/Class;I)Ljava/lang/Object;");
                objectArray = (Object[])Array.newInstance(clazz2, this.count);
            }
            int n2 = 0;
            object = this.first;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (object == null) break;
                objectArray[n2++] = object.item;
                object = object.next;
                RuntimeCostAccounter.recordJump();
            }
            int n3 = objectArray.length;
            RuntimeCostAccounter.recordJump();
            if (n3 > n2) {
                objectArray[n2] = null;
            }
            object = objectArray;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return object;
    }

    @Override
    public String toString() {
        String string;
        StringBuilder stringBuilder;
        Node<E> node;
        ReentrantLock reentrantLock;
        block7: {
            reentrantLock = this.lock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            node = this.first;
            RuntimeCostAccounter.recordJump();
            if (node != null) break block7;
            String string2 = "[]";
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            return string2;
        }
        try {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            stringBuilder.append('[');
            while (true) {
                String string3;
                Object e = node.item;
                RuntimeCostAccounter.recordJump();
                if (e == this) {
                    string3 = "(this Collection)";
                    RuntimeCostAccounter.recordJump();
                } else {
                    string3 = e;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                stringBuilder.append((Object)string3);
                node = node.next;
                RuntimeCostAccounter.recordJump();
                if (node != null) break block8;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append(']');
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                string = stringBuilder2.toString();
                break;
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        {
            block8: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                return string;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder.append(',');
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            stringBuilder3.append(' ');
            RuntimeCostAccounter.recordJump();
            continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            Node<E> node = this.first;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (node == null) break;
                node.item = null;
                Node node2 = node.next;
                node.prev = null;
                node.next = null;
                node = node2;
                RuntimeCostAccounter.recordJump();
            }
            this.last = null;
            this.first = null;
            this.count = 0;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signalAll:()V");
            this.notFull.signalAll();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
    }

    @Override
    public Iterator<E> iterator() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/LinkedBlockingDeque$Itr");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque$Itr.<init>:(Ljava/util/concurrent/LinkedBlockingDeque;Ljava/util/concurrent/LinkedBlockingDeque$1;)V");
        return new Itr(this, null);
    }

    @Override
    public Iterator<E> descendingIterator() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/LinkedBlockingDeque$DescendingItr");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque$DescendingItr.<init>:(Ljava/util/concurrent/LinkedBlockingDeque;Ljava/util/concurrent/LinkedBlockingDeque$1;)V");
        return new DescendingItr(this, null);
    }

    @Override
    public Spliterator<E> spliterator() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/LinkedBlockingDeque$LBDSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque$LBDSpliterator.<init>:(Ljava/util/concurrent/LinkedBlockingDeque;)V");
        return new LBDSpliterator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.defaultWriteObject:()V");
            objectOutputStream.defaultWriteObject();
            Node<E> node = this.first;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (node == null) break;
                Object e = node.item;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeObject:(Ljava/lang/Object;)V");
                objectOutputStream.writeObject(e);
                node = node.next;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeObject:(Ljava/lang/Object;)V");
            objectOutputStream.writeObject(null);
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.defaultReadObject:()V");
        objectInputStream.defaultReadObject();
        this.count = 0;
        this.first = null;
        this.last = null;
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readObject:()Ljava/lang/Object;");
            Object object = objectInputStream.readObject();
            RuntimeCostAccounter.recordJump();
            if (object == null) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.add:(Ljava/lang/Object;)Z");
            this.add(object);
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
    }

    static final class LBDSpliterator<E>
    implements Spliterator<E> {
        static final int MAX_BATCH = 0x2000000;
        final LinkedBlockingDeque<E> queue;
        Node<E> current;
        int batch;
        boolean exhausted;
        long est;

        LBDSpliterator(LinkedBlockingDeque<E> linkedBlockingDeque) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.queue = linkedBlockingDeque;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.size:()I");
            this.est = linkedBlockingDeque.size();
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Spliterator<E> trySplit() {
            block18: {
                Node<E> node;
                int n;
                LinkedBlockingDeque<E> linkedBlockingDeque;
                block19: {
                    int n2;
                    linkedBlockingDeque = this.queue;
                    int n3 = this.batch;
                    RuntimeCostAccounter.recordJump();
                    if (n3 <= 0) {
                        n2 = 1;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordJump();
                        if (n3 >= 0x2000000) {
                            n2 = 0x2000000;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            n2 = n3 + 1;
                        }
                    }
                    n = n2;
                    RuntimeCostAccounter.recordJump();
                    if (this.exhausted) break block18;
                    node = this.current;
                    RuntimeCostAccounter.recordJump();
                    if (node != null) break block19;
                    node = linkedBlockingDeque.first;
                    RuntimeCostAccounter.recordJump();
                    if (node == null) break block18;
                }
                Node node2 = node.next;
                RuntimeCostAccounter.recordJump();
                if (node2 != null) {
                    Node<E> node3;
                    int n4;
                    ReentrantLock reentrantLock;
                    Object[] objectArray;
                    block17: {
                        int n5 = n;
                        RuntimeCostAccounter.recordArrayAllocation((int)n5, (int)8);
                        objectArray = new Object[n5];
                        reentrantLock = linkedBlockingDeque.lock;
                        n4 = 0;
                        node3 = this.current;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
                        reentrantLock.lock();
                        try {
                            RuntimeCostAccounter.recordJump();
                            if (node3 == null) {
                                node3 = linkedBlockingDeque.first;
                                RuntimeCostAccounter.recordJump();
                                if (node3 == null) break block17;
                            }
                            do {
                                objectArray[n4] = node3.item;
                                RuntimeCostAccounter.recordJump();
                                if (objectArray[n4] != null) {
                                    ++n4;
                                }
                                node3 = node3.next;
                                RuntimeCostAccounter.recordJump();
                                if (node3 == null) break;
                                RuntimeCostAccounter.recordJump();
                            } while (n4 < n);
                        }
                        catch (Throwable throwable) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                            reentrantLock.unlock();
                            RuntimeCostAccounter.recordThrow();
                            throw throwable;
                        }
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                    reentrantLock.unlock();
                    RuntimeCostAccounter.recordJump();
                    this.current = node3;
                    RuntimeCostAccounter.recordJump();
                    if (this.current == null) {
                        this.est = 0L;
                        this.exhausted = true;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordJump();
                        if ((this.est -= (long)n4) < 0L) {
                            this.est = 0L;
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    if (n4 > 0) {
                        this.batch = n4;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.spliterator:([Ljava/lang/Object;III)Ljava/util/Spliterator;");
                        return Spliterators.spliterator(objectArray, 0, n4, 4368);
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void forEachRemaining(Consumer<? super E> consumer) {
            block7: {
                RuntimeCostAccounter.recordJump();
                if (consumer == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                    NullPointerException nullPointerException = new NullPointerException();
                    RuntimeCostAccounter.recordThrow();
                    throw nullPointerException;
                }
                LinkedBlockingDeque<E> linkedBlockingDeque = this.queue;
                ReentrantLock reentrantLock = linkedBlockingDeque.lock;
                RuntimeCostAccounter.recordJump();
                if (this.exhausted) break block7;
                this.exhausted = true;
                Node<E> node = this.current;
                do {
                    block8: {
                        Object t;
                        block6: {
                            t = null;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
                            reentrantLock.lock();
                            try {
                                RuntimeCostAccounter.recordJump();
                                if (node == null) {
                                    node = linkedBlockingDeque.first;
                                }
                                do {
                                    RuntimeCostAccounter.recordJump();
                                    if (node == null) break block6;
                                    t = node.item;
                                    node = node.next;
                                    RuntimeCostAccounter.recordJump();
                                } while (t == null);
                                RuntimeCostAccounter.recordJump();
                            }
                            catch (Throwable throwable) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                                reentrantLock.unlock();
                                RuntimeCostAccounter.recordThrow();
                                throw throwable;
                            }
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                        reentrantLock.unlock();
                        RuntimeCostAccounter.recordJump();
                        RuntimeCostAccounter.recordJump();
                        if (t == null) break block8;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                        consumer.accept(t);
                    }
                    RuntimeCostAccounter.recordJump();
                } while (node != null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean tryAdvance(Consumer<? super E> consumer) {
            block7: {
                Object t;
                block8: {
                    ReentrantLock reentrantLock;
                    block6: {
                        RuntimeCostAccounter.recordJump();
                        if (consumer == null) {
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                            NullPointerException nullPointerException = new NullPointerException();
                            RuntimeCostAccounter.recordThrow();
                            throw nullPointerException;
                        }
                        LinkedBlockingDeque<E> linkedBlockingDeque = this.queue;
                        reentrantLock = linkedBlockingDeque.lock;
                        RuntimeCostAccounter.recordJump();
                        if (this.exhausted) break block7;
                        t = null;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
                        reentrantLock.lock();
                        try {
                            RuntimeCostAccounter.recordJump();
                            if (this.current == null) {
                                this.current = linkedBlockingDeque.first;
                            }
                            do {
                                RuntimeCostAccounter.recordJump();
                                if (this.current == null) break block6;
                                t = this.current.item;
                                this.current = this.current.next;
                                RuntimeCostAccounter.recordJump();
                            } while (t == null);
                            RuntimeCostAccounter.recordJump();
                        }
                        catch (Throwable throwable) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                            reentrantLock.unlock();
                            RuntimeCostAccounter.recordThrow();
                            throw throwable;
                        }
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                    reentrantLock.unlock();
                    RuntimeCostAccounter.recordJump();
                    RuntimeCostAccounter.recordJump();
                    if (this.current != null) break block8;
                    this.exhausted = true;
                }
                RuntimeCostAccounter.recordJump();
                if (t != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                    consumer.accept(t);
                    return true;
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return 4368;
        }
    }

    private class DescendingItr
    extends AbstractItr {
        final /* synthetic */ LinkedBlockingDeque this$0;

        private DescendingItr(LinkedBlockingDeque linkedBlockingDeque) {
            this.this$0 = linkedBlockingDeque;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque$AbstractItr.<init>:(Ljava/util/concurrent/LinkedBlockingDeque;)V");
        }

        @Override
        Node<E> firstNode() {
            return this.this$0.last;
        }

        @Override
        Node<E> nextNode(Node<E> node) {
            return node.prev;
        }

        /* synthetic */ DescendingItr(LinkedBlockingDeque linkedBlockingDeque, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque$DescendingItr.<init>:(Ljava/util/concurrent/LinkedBlockingDeque;)V");
            this(linkedBlockingDeque);
        }
    }

    private class Itr
    extends AbstractItr {
        final /* synthetic */ LinkedBlockingDeque this$0;

        private Itr(LinkedBlockingDeque linkedBlockingDeque) {
            this.this$0 = linkedBlockingDeque;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque$AbstractItr.<init>:(Ljava/util/concurrent/LinkedBlockingDeque;)V");
        }

        @Override
        Node<E> firstNode() {
            return this.this$0.first;
        }

        @Override
        Node<E> nextNode(Node<E> node) {
            return node.next;
        }

        /* synthetic */ Itr(LinkedBlockingDeque linkedBlockingDeque, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque$Itr.<init>:(Ljava/util/concurrent/LinkedBlockingDeque;)V");
            this(linkedBlockingDeque);
        }
    }

    private abstract class AbstractItr
    implements Iterator<E> {
        Node<E> next;
        E nextItem;
        private Node<E> lastRet;

        abstract Node<E> firstNode();

        abstract Node<E> nextNode(Node<E> var1);

        AbstractItr() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            ReentrantLock reentrantLock = LinkedBlockingDeque.this.lock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            try {
                Object v0;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque$AbstractItr.firstNode:()Ljava/util/concurrent/LinkedBlockingDeque$Node;");
                this.next = this.firstNode();
                RuntimeCostAccounter.recordJump();
                if (this.next == null) {
                    v0 = null;
                    RuntimeCostAccounter.recordJump();
                } else {
                    v0 = this.next.item;
                }
                this.nextItem = v0;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordJump();
        }

        private Node<E> succ(Node<E> node) {
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque$AbstractItr.nextNode:(Ljava/util/concurrent/LinkedBlockingDeque$Node;)Ljava/util/concurrent/LinkedBlockingDeque$Node;");
                Node node2 = this.nextNode(node);
                RuntimeCostAccounter.recordJump();
                if (node2 == null) {
                    return null;
                }
                Object e = node2.item;
                RuntimeCostAccounter.recordJump();
                if (e != null) {
                    return node2;
                }
                RuntimeCostAccounter.recordJump();
                if (node2 == node) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque$AbstractItr.firstNode:()Ljava/util/concurrent/LinkedBlockingDeque$Node;");
                    return this.firstNode();
                }
                node = node2;
                RuntimeCostAccounter.recordJump();
            }
        }

        void advance() {
            ReentrantLock reentrantLock = LinkedBlockingDeque.this.lock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            try {
                Object v0;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque$AbstractItr.succ:(Ljava/util/concurrent/LinkedBlockingDeque$Node;)Ljava/util/concurrent/LinkedBlockingDeque$Node;");
                this.next = this.succ(this.next);
                RuntimeCostAccounter.recordJump();
                if (this.next == null) {
                    v0 = null;
                    RuntimeCostAccounter.recordJump();
                } else {
                    v0 = this.next.item;
                }
                this.nextItem = v0;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordJump();
        }

        @Override
        public boolean hasNext() {
            boolean bl;
            RuntimeCostAccounter.recordJump();
            if (this.next != null) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public E next() {
            RuntimeCostAccounter.recordJump();
            if (this.next == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                NoSuchElementException noSuchElementException = new NoSuchElementException();
                RuntimeCostAccounter.recordThrow();
                throw noSuchElementException;
            }
            this.lastRet = this.next;
            Object e = this.nextItem;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque$AbstractItr.advance:()V");
            this.advance();
            return e;
        }

        @Override
        public void remove() {
            Node node = this.lastRet;
            RuntimeCostAccounter.recordJump();
            if (node == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
                IllegalStateException illegalStateException = new IllegalStateException();
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            this.lastRet = null;
            ReentrantLock reentrantLock = LinkedBlockingDeque.this.lock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            try {
                Object e = node.item;
                RuntimeCostAccounter.recordJump();
                if (e != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingDeque.unlink:(Ljava/util/concurrent/LinkedBlockingDeque$Node;)V");
                    LinkedBlockingDeque.this.unlink(node);
                }
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordJump();
        }
    }

    static final class Node<E> {
        E item;
        Node<E> prev;
        Node<E> next;

        Node(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.item = e;
        }
    }
}

