/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent;

import java.lang.reflect.Field;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.concurrent.Callable;
import sandbox.java.util.concurrent.CancellationException;
import sandbox.java.util.concurrent.ExecutionException;
import sandbox.java.util.concurrent.Executors;
import sandbox.java.util.concurrent.RunnableFuture;
import sandbox.java.util.concurrent.TimeUnit;
import sandbox.java.util.concurrent.TimeoutException;
import sandbox.java.util.concurrent.locks.LockSupport;
import sandbox.sun.misc.Unsafe;

public class FutureTask<V>
implements RunnableFuture<V> {
    private volatile int state;
    private static final int NEW = 0;
    private static final int COMPLETING = 1;
    private static final int NORMAL = 2;
    private static final int EXCEPTIONAL = 3;
    private static final int CANCELLED = 4;
    private static final int INTERRUPTING = 5;
    private static final int INTERRUPTED = 6;
    private Callable<V> callable;
    private Object outcome;
    private volatile Thread runner;
    private volatile WaitNode waiters;
    private static final Unsafe UNSAFE;
    private static final long stateOffset;
    private static final long runnerOffset;
    private static final long waitersOffset;

    private V report(int n) throws ExecutionException {
        Object object = this.outcome;
        RuntimeCostAccounter.recordJump();
        if (n == 2) {
            return (V)object;
        }
        RuntimeCostAccounter.recordJump();
        if (n >= 4) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CancellationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CancellationException.<init>:()V");
            CancellationException cancellationException = new CancellationException();
            RuntimeCostAccounter.recordThrow();
            throw cancellationException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ExecutionException");
        Throwable throwable = (Throwable)object;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ExecutionException.<init>:(Ljava/lang/Throwable;)V");
        ExecutionException executionException = new ExecutionException(throwable);
        RuntimeCostAccounter.recordThrow();
        throw executionException;
    }

    public FutureTask(Callable<V> callable) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordJump();
        if (callable == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        this.callable = callable;
        this.state = 0;
    }

    public FutureTask(Runnable runnable, V v) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors.callable:(Ljava/lang/Runnable;Ljava/lang/Object;)Ljava/util/concurrent/Callable;");
        this.callable = Executors.callable(runnable, v);
        this.state = 0;
    }

    @Override
    public boolean isCancelled() {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (this.state >= 4) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isDone() {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (this.state != 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean bl) {
        block9: {
            block12: {
                block11: {
                    int n;
                    RuntimeCostAccounter.recordJump();
                    if (this.state != 0) break block11;
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        n = 5;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        n = 4;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
                    boolean bl2 = UNSAFE.compareAndSwapInt((Object)this, stateOffset, 0, n);
                    RuntimeCostAccounter.recordJump();
                    if (bl2) break block12;
                }
                return false;
            }
            try {
                block10: {
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block9;
                    try {
                        Thread thread = this.runner;
                        RuntimeCostAccounter.recordJump();
                        if (thread == null) break block10;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupt:()V");
                        thread.interrupt();
                    }
                    catch (Throwable throwable) {
                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putOrderedInt:(Ljava/lang/Object;JI)V");
                        UNSAFE.putOrderedInt((Object)this, stateOffset, 6);
                        RuntimeCostAccounter.recordThrow();
                        throw throwable;
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putOrderedInt:(Ljava/lang/Object;JI)V");
                UNSAFE.putOrderedInt((Object)this, stateOffset, 6);
                RuntimeCostAccounter.recordJump();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/FutureTask.finishCompletion:()V");
                this.finishCompletion();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/FutureTask.finishCompletion:()V");
        this.finishCompletion();
        RuntimeCostAccounter.recordJump();
        return true;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        int n = this.state;
        RuntimeCostAccounter.recordJump();
        if (n <= 1) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/FutureTask.awaitDone:(ZJ)I");
            n = this.awaitDone(false, 0L);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/FutureTask.report:(I)Ljava/lang/Object;");
        return this.report(n);
    }

    @Override
    public V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        RuntimeCostAccounter.recordJump();
        if (timeUnit == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        int n = this.state;
        RuntimeCostAccounter.recordJump();
        if (n <= 1) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toNanos:(J)J");
            long l2 = timeUnit.toNanos(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/FutureTask.awaitDone:(ZJ)I");
            n = this.awaitDone(true, l2);
            RuntimeCostAccounter.recordJump();
            if (n <= 1) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/TimeoutException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeoutException.<init>:()V");
                TimeoutException timeoutException = new TimeoutException();
                RuntimeCostAccounter.recordThrow();
                throw timeoutException;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/FutureTask.report:(I)Ljava/lang/Object;");
        return this.report(n);
    }

    protected void done() {
    }

    protected void set(V v) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
        boolean bl = UNSAFE.compareAndSwapInt((Object)this, stateOffset, 0, 1);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            this.outcome = v;
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putOrderedInt:(Ljava/lang/Object;JI)V");
            UNSAFE.putOrderedInt((Object)this, stateOffset, 2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/FutureTask.finishCompletion:()V");
            this.finishCompletion();
        }
    }

    protected void setException(Throwable throwable) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
        boolean bl = UNSAFE.compareAndSwapInt((Object)this, stateOffset, 0, 1);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            this.outcome = throwable;
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putOrderedInt:(Ljava/lang/Object;JI)V");
            UNSAFE.putOrderedInt((Object)this, stateOffset, 3);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/FutureTask.finishCompletion:()V");
            this.finishCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n;
        block12: {
            block11: {
                RuntimeCostAccounter.recordJump();
                if (this.state != 0) break block11;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                Thread thread = Thread.currentThread();
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                boolean bl = UNSAFE.compareAndSwapObject((Object)this, runnerOffset, null, (Object)thread);
                RuntimeCostAccounter.recordJump();
                if (bl) break block12;
            }
            return;
        }
        try {
            block13: {
                boolean bl;
                V v;
                Callable<V> callable = this.callable;
                RuntimeCostAccounter.recordJump();
                if (callable == null) break block13;
                RuntimeCostAccounter.recordJump();
                if (this.state != 0) break block13;
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Callable.call:()Ljava/lang/Object;");
                    v = callable.call();
                    bl = true;
                }
                catch (Throwable throwable) {
                    v = null;
                    bl = false;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/FutureTask.setException:(Ljava/lang/Throwable;)V");
                    this.setException(throwable);
                }
                RuntimeCostAccounter.recordJump();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/FutureTask.set:(Ljava/lang/Object;)V");
                    this.set(v);
                }
            }
            this.runner = null;
            n = this.state;
        }
        catch (Throwable throwable) {
            this.runner = null;
            int n2 = this.state;
            RuntimeCostAccounter.recordJump();
            if (n2 >= 5) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/FutureTask.handlePossibleCancellationInterrupt:(I)V");
                this.handlePossibleCancellationInterrupt(n2);
            }
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
        if (n >= 5) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/FutureTask.handlePossibleCancellationInterrupt:(I)V");
            this.handlePossibleCancellationInterrupt(n);
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean runAndReset() {
        RuntimeCostAccounter.recordJump();
        if (this.state != 0) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        Thread thread = Thread.currentThread();
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
        boolean bl = UNSAFE.compareAndSwapObject((Object)this, runnerOffset, null, (Object)thread);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return false;
        }
        boolean bl2 = false;
        int n = this.state;
        try {
            Callable<V> callable = this.callable;
            RuntimeCostAccounter.recordJump();
            if (callable != null) {
                RuntimeCostAccounter.recordJump();
                if (n == 0) {
                    try {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Callable.call:()Ljava/lang/Object;");
                        callable.call();
                        bl2 = true;
                    }
                    catch (Throwable throwable) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/FutureTask.setException:(Ljava/lang/Throwable;)V");
                        this.setException(throwable);
                    }
                    RuntimeCostAccounter.recordJump();
                }
            }
            this.runner = null;
            n = this.state;
        }
        catch (Throwable throwable) {
            this.runner = null;
            n = this.state;
            RuntimeCostAccounter.recordJump();
            if (n >= 5) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/FutureTask.handlePossibleCancellationInterrupt:(I)V");
                this.handlePossibleCancellationInterrupt(n);
            }
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
        if (n >= 5) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/FutureTask.handlePossibleCancellationInterrupt:(I)V");
            this.handlePossibleCancellationInterrupt(n);
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (!bl2) return false;
        RuntimeCostAccounter.recordJump();
        if (n != 0) return false;
        boolean bl3 = true;
        RuntimeCostAccounter.recordJump();
        return bl3;
    }

    private void handlePossibleCancellationInterrupt(int n) {
        RuntimeCostAccounter.recordJump();
        if (n == 5) {
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (this.state != 5) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.yield:()V");
                Thread.yield();
                RuntimeCostAccounter.recordJump();
            }
        }
    }

    private void finishCompletion() {
        block4: {
            WaitNode waitNode;
            boolean bl;
            do {
                waitNode = this.waiters;
                RuntimeCostAccounter.recordJump();
                if (waitNode == null) break block4;
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                bl = UNSAFE.compareAndSwapObject((Object)this, waitersOffset, (Object)waitNode, null);
                RuntimeCostAccounter.recordJump();
            } while (!bl);
            while (true) {
                Thread thread = waitNode.thread;
                RuntimeCostAccounter.recordJump();
                if (thread != null) {
                    waitNode.thread = null;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.unpark:(Ljava/lang/Thread;)V");
                    LockSupport.unpark(thread);
                }
                WaitNode waitNode2 = waitNode.next;
                RuntimeCostAccounter.recordJump();
                if (waitNode2 == null) {
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                waitNode.next = null;
                waitNode = waitNode2;
                RuntimeCostAccounter.recordJump();
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/FutureTask.done:()V");
        this.done();
        this.callable = null;
    }

    private int awaitDone(boolean bl, long l) throws InterruptedException {
        long l2;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
            l2 = System.nanoTime() + l;
            RuntimeCostAccounter.recordJump();
        } else {
            l2 = 0L;
        }
        long l3 = l2;
        WaitNode waitNode = null;
        boolean bl2 = false;
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
            boolean bl3 = Thread.interrupted();
            RuntimeCostAccounter.recordJump();
            if (bl3) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/FutureTask.removeWaiter:(Ljava/util/concurrent/FutureTask$WaitNode;)V");
                this.removeWaiter(waitNode);
                RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
                InterruptedException interruptedException = new InterruptedException();
                RuntimeCostAccounter.recordThrow();
                throw interruptedException;
            }
            int n = this.state;
            RuntimeCostAccounter.recordJump();
            if (n > 1) {
                RuntimeCostAccounter.recordJump();
                if (waitNode != null) {
                    waitNode.thread = null;
                }
                return n;
            }
            RuntimeCostAccounter.recordJump();
            if (n == 1) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.yield:()V");
                Thread.yield();
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (waitNode == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/FutureTask$WaitNode");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/FutureTask$WaitNode.<init>:()V");
                    waitNode = new WaitNode();
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (!bl2) {
                        waitNode.next = this.waiters;
                        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                        bl2 = UNSAFE.compareAndSwapObject((Object)this, waitersOffset, (Object)waitNode.next, (Object)waitNode);
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordJump();
                        if (bl) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
                            l = l3 - System.nanoTime();
                            RuntimeCostAccounter.recordJump();
                            if (l <= 0L) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/FutureTask.removeWaiter:(Ljava/util/concurrent/FutureTask$WaitNode;)V");
                                this.removeWaiter(waitNode);
                                return this.state;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.parkNanos:(Ljava/lang/Object;J)V");
                            LockSupport.parkNanos(this, l);
                            RuntimeCostAccounter.recordJump();
                        } else {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.park:(Ljava/lang/Object;)V");
                            LockSupport.park(this);
                        }
                    }
                }
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    private void removeWaiter(WaitNode waitNode) {
        block8: {
            RuntimeCostAccounter.recordJump();
            if (waitNode == null) break block8;
            waitNode.thread = null;
            block0: while (true) {
                WaitNode waitNode2 = null;
                WaitNode waitNode3 = this.waiters;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (waitNode3 == null) break block0;
                    WaitNode waitNode4 = waitNode3.next;
                    Thread thread = waitNode3.thread;
                    RuntimeCostAccounter.recordJump();
                    if (thread != null) {
                        waitNode2 = waitNode3;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordJump();
                        if (waitNode2 != null) {
                            waitNode2.next = waitNode4;
                            Thread thread2 = waitNode2.thread;
                            RuntimeCostAccounter.recordJump();
                            if (thread2 == null) {
                                RuntimeCostAccounter.recordJump();
                                continue block0;
                            }
                        } else {
                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                            boolean bl = UNSAFE.compareAndSwapObject((Object)this, waitersOffset, (Object)waitNode3, (Object)waitNode4);
                            RuntimeCostAccounter.recordJump();
                            if (!bl) {
                                RuntimeCostAccounter.recordJump();
                                continue block0;
                            }
                        }
                    }
                    waitNode3 = waitNode4;
                    RuntimeCostAccounter.recordJump();
                }
                break;
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    static {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getUnsafe:()Lsun/misc/Unsafe;");
            UNSAFE = Unsafe.getUnsafe();
            Class<FutureTask> clazz = FutureTask.class;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field = clazz.getDeclaredField("state");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            stateOffset = UNSAFE.objectFieldOffset(field);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field2 = clazz.getDeclaredField("runner");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            runnerOffset = UNSAFE.objectFieldOffset(field2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field3 = clazz.getDeclaredField("waiters");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            waitersOffset = UNSAFE.objectFieldOffset(field3);
        }
        catch (Exception exception) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/Throwable;)V");
            Error error = new Error(exception);
            RuntimeCostAccounter.recordThrow();
            throw error;
        }
        RuntimeCostAccounter.recordJump();
    }

    static final class WaitNode {
        volatile Thread thread;
        volatile WaitNode next;

        WaitNode() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            this.thread = Thread.currentThread();
        }
    }
}

