/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.NoSuchElementException;
import sandbox.java.util.Objects;
import sandbox.java.util.function.Consumer;
import sandbox.java.util.function.Function;
import sandbox.java.util.function.Predicate;
import sandbox.java.util.function.Supplier;

public final class Optional<T> {
    private static final Optional<?> EMPTY;
    private final T value;

    private Optional() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.value = null;
    }

    public static <T> Optional<T> empty() {
        Optional<?> optional = EMPTY;
        return optional;
    }

    private Optional(T t) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        this.value = Objects.requireNonNull(t);
    }

    public static <T> Optional<T> of(T t) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Optional");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Optional.<init>:(Ljava/lang/Object;)V");
        return new Optional<T>(t);
    }

    public static <T> Optional<T> ofNullable(T t) {
        Optional<T> optional;
        RuntimeCostAccounter.recordJump();
        if (t == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Optional.empty:()Ljava/util/Optional;");
            optional = Optional.empty();
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Optional.of:(Ljava/lang/Object;)Ljava/util/Optional;");
            optional = Optional.of(t);
        }
        return optional;
    }

    public T get() {
        RuntimeCostAccounter.recordJump();
        if (this.value == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:(Ljava/lang/String;)V");
            NoSuchElementException noSuchElementException = new NoSuchElementException("No value present");
            RuntimeCostAccounter.recordThrow();
            throw noSuchElementException;
        }
        return this.value;
    }

    public boolean isPresent() {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (this.value != null) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public void ifPresent(Consumer<? super T> consumer) {
        RuntimeCostAccounter.recordJump();
        if (this.value != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
            consumer.accept(this.value);
        }
    }

    public Optional<T> filter(Predicate<? super T> predicate) {
        Optional<T> optional;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(predicate);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Optional.isPresent:()Z");
        boolean bl = this.isPresent();
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return this;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Predicate.test:(Ljava/lang/Object;)Z");
        boolean bl2 = predicate.test(this.value);
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            optional = this;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Optional.empty:()Ljava/util/Optional;");
            optional = Optional.empty();
        }
        return optional;
    }

    public <U> Optional<U> map(Function<? super T, ? extends U> function) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(function);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Optional.isPresent:()Z");
        boolean bl = this.isPresent();
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Optional.empty:()Ljava/util/Optional;");
            return Optional.empty();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
        U u = function.apply(this.value);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Optional.ofNullable:(Ljava/lang/Object;)Ljava/util/Optional;");
        return Optional.ofNullable(u);
    }

    public <U> Optional<U> flatMap(Function<? super T, Optional<U>> function) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(function);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Optional.isPresent:()Z");
        boolean bl = this.isPresent();
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Optional.empty:()Ljava/util/Optional;");
            return Optional.empty();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
        Optional<U> optional = function.apply(this.value);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        return Objects.requireNonNull(optional);
    }

    public T orElse(T t) {
        T t2;
        RuntimeCostAccounter.recordJump();
        if (this.value != null) {
            t2 = this.value;
            RuntimeCostAccounter.recordJump();
        } else {
            t2 = t;
        }
        return t2;
    }

    public T orElseGet(Supplier<? extends T> supplier) {
        T t;
        RuntimeCostAccounter.recordJump();
        if (this.value != null) {
            t = this.value;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Supplier.get:()Ljava/lang/Object;");
            t = supplier.get();
        }
        return t;
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> supplier) throws X {
        RuntimeCostAccounter.recordJump();
        if (this.value != null) {
            return this.value;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Supplier.get:()Ljava/lang/Object;");
        Throwable throwable = (Throwable)supplier.get();
        RuntimeCostAccounter.recordThrow();
        throw throwable;
    }

    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl = object instanceof Optional;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return false;
        }
        Optional optional = (Optional)object;
        T t = optional.value;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.equals:(Ljava/lang/Object;Ljava/lang/Object;)Z");
        return Objects.equals(this.value, t);
    }

    public int hashCode() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.hashCode:(Ljava/lang/Object;)I");
        return Objects.hashCode(this.value);
    }

    public String toString() {
        String string;
        RuntimeCostAccounter.recordJump();
        if (this.value != null) {
            RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
            Object[] objectArray = new Object[]{this.value};
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
            string = String.format("Optional[%s]", objectArray);
            RuntimeCostAccounter.recordJump();
        } else {
            string = "Optional.empty";
        }
        return string;
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Optional");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Optional.<init>:()V");
        EMPTY = new Optional();
    }
}

