/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.temporal;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.DayOfWeek;
import sandbox.java.time.chrono.ChronoLocalDate;
import sandbox.java.time.chrono.Chronology;
import sandbox.java.time.format.ResolverStyle;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.ChronoUnit;
import sandbox.java.time.temporal.IsoFields;
import sandbox.java.time.temporal.Temporal;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.TemporalUnit;
import sandbox.java.time.temporal.ValueRange;
import sandbox.java.util.Locale;
import sandbox.java.util.Map;
import sandbox.java.util.Objects;
import sandbox.java.util.ResourceBundle;
import sandbox.java.util.concurrent.ConcurrentHashMap;
import sandbox.java.util.concurrent.ConcurrentMap;
import sandbox.sun.util.locale.provider.CalendarDataUtility;
import sandbox.sun.util.locale.provider.LocaleProviderAdapter;
import sandbox.sun.util.locale.provider.LocaleResources;

public final class WeekFields
implements Serializable {
    private static final ConcurrentMap<String, WeekFields> CACHE;
    public static final WeekFields ISO;
    public static final WeekFields SUNDAY_START;
    public static final TemporalUnit WEEK_BASED_YEARS;
    private static final long serialVersionUID = -1177360819670808121L;
    private final DayOfWeek firstDayOfWeek;
    private final int minimalDays;
    private final transient TemporalField dayOfWeek;
    private final transient TemporalField weekOfMonth;
    private final transient TemporalField weekOfYear;
    private final transient TemporalField weekOfWeekBasedYear;
    private final transient TemporalField weekBasedYear;

    public static WeekFields of(Locale locale) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(locale, "locale");
        RuntimeCostAccounter.recordAllocation((String)"java/util/Locale");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getLanguage:()Ljava/lang/String;");
        String string = locale.getLanguage();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getCountry:()Ljava/lang/String;");
        String string2 = locale.getCountry();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.<init>:(Ljava/lang/String;Ljava/lang/String;)V");
        locale = new Locale(string, string2);
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/CalendarDataUtility.retrieveFirstDayOfWeek:(Ljava/util/Locale;)I");
        int n = CalendarDataUtility.retrieveFirstDayOfWeek((Locale)locale);
        long l = n - 1;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/DayOfWeek.plus:(J)Ljava/time/DayOfWeek;");
        DayOfWeek dayOfWeek = DayOfWeek.SUNDAY.plus(l);
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/CalendarDataUtility.retrieveMinimalDaysInFirstWeek:(Ljava/util/Locale;)I");
        int n2 = CalendarDataUtility.retrieveMinimalDaysInFirstWeek((Locale)locale);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.of:(Ljava/time/DayOfWeek;I)Ljava/time/temporal/WeekFields;");
        return WeekFields.of(dayOfWeek, n2);
    }

    public static WeekFields of(DayOfWeek dayOfWeek, int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/DayOfWeek.toString:()Ljava/lang/String;");
        String string = dayOfWeek.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string2 = stringBuilder3.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        WeekFields weekFields = (WeekFields)CACHE.get(string2);
        RuntimeCostAccounter.recordJump();
        if (weekFields == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/WeekFields");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.<init>:(Ljava/time/DayOfWeek;I)V");
            weekFields = new WeekFields(dayOfWeek, n);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.putIfAbsent:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            CACHE.putIfAbsent(string2, weekFields);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
            weekFields = (WeekFields)CACHE.get(string2);
        }
        return weekFields;
    }

    private WeekFields(DayOfWeek dayOfWeek, int n) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.ofDayOfWeekField:(Ljava/time/temporal/WeekFields;)Ljava/time/temporal/WeekFields$ComputedDayOfField;");
                this.dayOfWeek = ComputedDayOfField.ofDayOfWeekField(this);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.ofWeekOfMonthField:(Ljava/time/temporal/WeekFields;)Ljava/time/temporal/WeekFields$ComputedDayOfField;");
                this.weekOfMonth = ComputedDayOfField.ofWeekOfMonthField(this);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.ofWeekOfYearField:(Ljava/time/temporal/WeekFields;)Ljava/time/temporal/WeekFields$ComputedDayOfField;");
                this.weekOfYear = ComputedDayOfField.ofWeekOfYearField(this);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.ofWeekOfWeekBasedYearField:(Ljava/time/temporal/WeekFields;)Ljava/time/temporal/WeekFields$ComputedDayOfField;");
                this.weekOfWeekBasedYear = ComputedDayOfField.ofWeekOfWeekBasedYearField(this);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.ofWeekBasedYearField:(Ljava/time/temporal/WeekFields;)Ljava/time/temporal/WeekFields$ComputedDayOfField;");
                this.weekBasedYear = ComputedDayOfField.ofWeekBasedYearField(this);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                Objects.requireNonNull(dayOfWeek, "firstDayOfWeek");
                RuntimeCostAccounter.recordJump();
                if (n < 1) break block2;
                RuntimeCostAccounter.recordJump();
                if (n <= 7) break block3;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Minimal number of days is invalid");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        this.firstDayOfWeek = dayOfWeek;
        this.minimalDays = n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, InvalidObjectException {
        block5: {
            block4: {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.defaultReadObject:()V");
                objectInputStream.defaultReadObject();
                RuntimeCostAccounter.recordJump();
                if (this.firstDayOfWeek == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
                    InvalidObjectException invalidObjectException = new InvalidObjectException("firstDayOfWeek is null");
                    RuntimeCostAccounter.recordThrow();
                    throw invalidObjectException;
                }
                RuntimeCostAccounter.recordJump();
                if (this.minimalDays < 1) break block4;
                RuntimeCostAccounter.recordJump();
                if (this.minimalDays <= 7) break block5;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
            InvalidObjectException invalidObjectException = new InvalidObjectException("Minimal number of days is invalid");
            RuntimeCostAccounter.recordThrow();
            throw invalidObjectException;
        }
    }

    private Object readResolve() throws InvalidObjectException {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.of:(Ljava/time/DayOfWeek;I)Ljava/time/temporal/WeekFields;");
            return WeekFields.of(this.firstDayOfWeek, this.minimalDays);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Invalid serialized WeekFields: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.getMessage:()Ljava/lang/String;");
            String string = illegalArgumentException.getMessage();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
            InvalidObjectException invalidObjectException = new InvalidObjectException(string2);
            RuntimeCostAccounter.recordThrow();
            throw invalidObjectException;
        }
    }

    public DayOfWeek getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public int getMinimalDaysInFirstWeek() {
        return this.minimalDays;
    }

    public TemporalField dayOfWeek() {
        return this.dayOfWeek;
    }

    public TemporalField weekOfMonth() {
        return this.weekOfMonth;
    }

    public TemporalField weekOfYear() {
        return this.weekOfYear;
    }

    public TemporalField weekOfWeekBasedYear() {
        return this.weekOfWeekBasedYear;
    }

    public TemporalField weekBasedYear() {
        return this.weekBasedYear;
    }

    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl = object instanceof WeekFields;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            boolean bl2;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.hashCode:()I");
            int n = this.hashCode();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.hashCode:()I");
            int n2 = object.hashCode();
            RuntimeCostAccounter.recordJump();
            if (n == n2) {
                bl2 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl2 = false;
            }
            return bl2;
        }
        return false;
    }

    public int hashCode() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/DayOfWeek.ordinal:()I");
        return this.firstDayOfWeek.ordinal() * 7 + this.minimalDays;
    }

    public String toString() {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("WeekFields[");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(this.firstDayOfWeek);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append(',');
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append(this.minimalDays);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder6 = stringBuilder5.append(']');
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder6.toString();
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ConcurrentHashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.<init>:(IFI)V");
        CACHE = new ConcurrentHashMap<String, WeekFields>(4, 0.75f, 2);
        RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/WeekFields");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.<init>:(Ljava/time/DayOfWeek;I)V");
        ISO = new WeekFields(DayOfWeek.MONDAY, 4);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.of:(Ljava/time/DayOfWeek;I)Ljava/time/temporal/WeekFields;");
        SUNDAY_START = WeekFields.of(DayOfWeek.SUNDAY, 1);
        WEEK_BASED_YEARS = IsoFields.WEEK_BASED_YEARS;
    }

    static class ComputedDayOfField
    implements TemporalField {
        private final String name;
        private final WeekFields weekDef;
        private final TemporalUnit baseUnit;
        private final TemporalUnit rangeUnit;
        private final ValueRange range;
        private static final ValueRange DAY_OF_WEEK_RANGE;
        private static final ValueRange WEEK_OF_MONTH_RANGE;
        private static final ValueRange WEEK_OF_YEAR_RANGE;
        private static final ValueRange WEEK_OF_WEEK_BASED_YEAR_RANGE;

        static ComputedDayOfField ofDayOfWeekField(WeekFields weekFields) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/WeekFields$ComputedDayOfField");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.<init>:(Ljava/lang/String;Ljava/time/temporal/WeekFields;Ljava/time/temporal/TemporalUnit;Ljava/time/temporal/TemporalUnit;Ljava/time/temporal/ValueRange;)V");
            return new ComputedDayOfField("DayOfWeek", weekFields, ChronoUnit.DAYS, ChronoUnit.WEEKS, DAY_OF_WEEK_RANGE);
        }

        static ComputedDayOfField ofWeekOfMonthField(WeekFields weekFields) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/WeekFields$ComputedDayOfField");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.<init>:(Ljava/lang/String;Ljava/time/temporal/WeekFields;Ljava/time/temporal/TemporalUnit;Ljava/time/temporal/TemporalUnit;Ljava/time/temporal/ValueRange;)V");
            return new ComputedDayOfField("WeekOfMonth", weekFields, ChronoUnit.WEEKS, ChronoUnit.MONTHS, WEEK_OF_MONTH_RANGE);
        }

        static ComputedDayOfField ofWeekOfYearField(WeekFields weekFields) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/WeekFields$ComputedDayOfField");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.<init>:(Ljava/lang/String;Ljava/time/temporal/WeekFields;Ljava/time/temporal/TemporalUnit;Ljava/time/temporal/TemporalUnit;Ljava/time/temporal/ValueRange;)V");
            return new ComputedDayOfField("WeekOfYear", weekFields, ChronoUnit.WEEKS, ChronoUnit.YEARS, WEEK_OF_YEAR_RANGE);
        }

        static ComputedDayOfField ofWeekOfWeekBasedYearField(WeekFields weekFields) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/WeekFields$ComputedDayOfField");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.<init>:(Ljava/lang/String;Ljava/time/temporal/WeekFields;Ljava/time/temporal/TemporalUnit;Ljava/time/temporal/TemporalUnit;Ljava/time/temporal/ValueRange;)V");
            return new ComputedDayOfField("WeekOfWeekBasedYear", weekFields, ChronoUnit.WEEKS, IsoFields.WEEK_BASED_YEARS, WEEK_OF_WEEK_BASED_YEAR_RANGE);
        }

        static ComputedDayOfField ofWeekBasedYearField(WeekFields weekFields) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/WeekFields$ComputedDayOfField");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.range:()Ljava/time/temporal/ValueRange;");
            ValueRange valueRange = ChronoField.YEAR.range();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.<init>:(Ljava/lang/String;Ljava/time/temporal/WeekFields;Ljava/time/temporal/TemporalUnit;Ljava/time/temporal/TemporalUnit;Ljava/time/temporal/ValueRange;)V");
            return new ComputedDayOfField("WeekBasedYear", weekFields, IsoFields.WEEK_BASED_YEARS, ChronoUnit.FOREVER, valueRange);
        }

        private ChronoLocalDate ofWeekBasedYear(Chronology chronology, int n, int n2, int n3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.date:(III)Ljava/time/chrono/ChronoLocalDate;");
            ChronoLocalDate chronoLocalDate = chronology.date(n, 1, 1);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.localizedDayOfWeek:(Ljava/time/temporal/TemporalAccessor;)I");
            int n4 = this.localizedDayOfWeek(chronoLocalDate);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.startOfWeekOffset:(II)I");
            int n5 = this.startOfWeekOffset(1, n4);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.lengthOfYear:()I");
            int n6 = chronoLocalDate.lengthOfYear();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.getMinimalDaysInFirstWeek:()I");
            int n7 = n6 + this.weekDef.getMinimalDaysInFirstWeek();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.computeWeek:(II)I");
            int n8 = this.computeWeek(n5, n7);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
            n2 = Math.min(n2, n8 - 1);
            int n9 = -n5 + (n3 - 1) + (n2 - 1) * 7;
            long l = n9;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
            return chronoLocalDate.plus(l, ChronoUnit.DAYS);
        }

        private ComputedDayOfField(String string, WeekFields weekFields, TemporalUnit temporalUnit, TemporalUnit temporalUnit2, ValueRange valueRange) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.name = string;
            this.weekDef = weekFields;
            this.baseUnit = temporalUnit;
            this.rangeUnit = temporalUnit2;
            this.range = valueRange;
        }

        @Override
        public long getFrom(TemporalAccessor temporalAccessor) {
            RuntimeCostAccounter.recordJump();
            if (this.rangeUnit == ChronoUnit.WEEKS) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.localizedDayOfWeek:(Ljava/time/temporal/TemporalAccessor;)I");
                return this.localizedDayOfWeek(temporalAccessor);
            }
            RuntimeCostAccounter.recordJump();
            if (this.rangeUnit == ChronoUnit.MONTHS) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.localizedWeekOfMonth:(Ljava/time/temporal/TemporalAccessor;)J");
                return this.localizedWeekOfMonth(temporalAccessor);
            }
            RuntimeCostAccounter.recordJump();
            if (this.rangeUnit == ChronoUnit.YEARS) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.localizedWeekOfYear:(Ljava/time/temporal/TemporalAccessor;)J");
                return this.localizedWeekOfYear(temporalAccessor);
            }
            RuntimeCostAccounter.recordJump();
            if (this.rangeUnit == WEEK_BASED_YEARS) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.localizedWeekOfWeekBasedYear:(Ljava/time/temporal/TemporalAccessor;)I");
                return this.localizedWeekOfWeekBasedYear(temporalAccessor);
            }
            RuntimeCostAccounter.recordJump();
            if (this.rangeUnit == ChronoUnit.FOREVER) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.localizedWeekBasedYear:(Ljava/time/temporal/TemporalAccessor;)I");
                return this.localizedWeekBasedYear(temporalAccessor);
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("unreachable, rangeUnit: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(this.rangeUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(", this: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(this);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder5.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
            IllegalStateException illegalStateException = new IllegalStateException(string);
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }

        private int localizedDayOfWeek(TemporalAccessor temporalAccessor) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.getFirstDayOfWeek:()Ljava/time/DayOfWeek;");
            DayOfWeek dayOfWeek = this.weekDef.getFirstDayOfWeek();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DayOfWeek.getValue:()I");
            int n = dayOfWeek.getValue();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.get:(Ljava/time/temporal/TemporalField;)I");
            int n2 = temporalAccessor.get(ChronoField.DAY_OF_WEEK);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorMod:(II)I");
            return Math.floorMod(n2 - n, 7) + 1;
        }

        private int localizedDayOfWeek(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.getFirstDayOfWeek:()Ljava/time/DayOfWeek;");
            DayOfWeek dayOfWeek = this.weekDef.getFirstDayOfWeek();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DayOfWeek.getValue:()I");
            int n2 = dayOfWeek.getValue();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorMod:(II)I");
            return Math.floorMod(n - n2, 7) + 1;
        }

        private long localizedWeekOfMonth(TemporalAccessor temporalAccessor) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.localizedDayOfWeek:(Ljava/time/temporal/TemporalAccessor;)I");
            int n = this.localizedDayOfWeek(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.get:(Ljava/time/temporal/TemporalField;)I");
            int n2 = temporalAccessor.get(ChronoField.DAY_OF_MONTH);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.startOfWeekOffset:(II)I");
            int n3 = this.startOfWeekOffset(n2, n);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.computeWeek:(II)I");
            return this.computeWeek(n3, n2);
        }

        private long localizedWeekOfYear(TemporalAccessor temporalAccessor) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.localizedDayOfWeek:(Ljava/time/temporal/TemporalAccessor;)I");
            int n = this.localizedDayOfWeek(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.get:(Ljava/time/temporal/TemporalField;)I");
            int n2 = temporalAccessor.get(ChronoField.DAY_OF_YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.startOfWeekOffset:(II)I");
            int n3 = this.startOfWeekOffset(n2, n);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.computeWeek:(II)I");
            return this.computeWeek(n3, n2);
        }

        private int localizedWeekBasedYear(TemporalAccessor temporalAccessor) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.localizedDayOfWeek:(Ljava/time/temporal/TemporalAccessor;)I");
            int n = this.localizedDayOfWeek(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.get:(Ljava/time/temporal/TemporalField;)I");
            int n2 = temporalAccessor.get(ChronoField.YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.get:(Ljava/time/temporal/TemporalField;)I");
            int n3 = temporalAccessor.get(ChronoField.DAY_OF_YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.startOfWeekOffset:(II)I");
            int n4 = this.startOfWeekOffset(n3, n);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.computeWeek:(II)I");
            int n5 = this.computeWeek(n4, n3);
            RuntimeCostAccounter.recordJump();
            if (n5 == 0) {
                return n2 - 1;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
            ValueRange valueRange = temporalAccessor.range(ChronoField.DAY_OF_YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMaximum:()J");
            int n6 = (int)valueRange.getMaximum();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.getMinimalDaysInFirstWeek:()I");
            int n7 = n6 + this.weekDef.getMinimalDaysInFirstWeek();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.computeWeek:(II)I");
            int n8 = this.computeWeek(n4, n7);
            RuntimeCostAccounter.recordJump();
            if (n5 >= n8) {
                return n2 + 1;
            }
            return n2;
        }

        private int localizedWeekOfWeekBasedYear(TemporalAccessor temporalAccessor) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.localizedDayOfWeek:(Ljava/time/temporal/TemporalAccessor;)I");
            int n = this.localizedDayOfWeek(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.get:(Ljava/time/temporal/TemporalField;)I");
            int n2 = temporalAccessor.get(ChronoField.DAY_OF_YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.startOfWeekOffset:(II)I");
            int n3 = this.startOfWeekOffset(n2, n);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.computeWeek:(II)I");
            int n4 = this.computeWeek(n3, n2);
            RuntimeCostAccounter.recordJump();
            if (n4 == 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/Chronology;");
                Chronology chronology = Chronology.from(temporalAccessor);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.date:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/ChronoLocalDate;");
                ChronoLocalDate chronoLocalDate = chronology.date(temporalAccessor);
                long l = n2;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.minus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
                chronoLocalDate = chronoLocalDate.minus(l, ChronoUnit.DAYS);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.localizedWeekOfWeekBasedYear:(Ljava/time/temporal/TemporalAccessor;)I");
                return this.localizedWeekOfWeekBasedYear(chronoLocalDate);
            }
            RuntimeCostAccounter.recordJump();
            if (n4 > 50) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
                ValueRange valueRange = temporalAccessor.range(ChronoField.DAY_OF_YEAR);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMaximum:()J");
                int n5 = (int)valueRange.getMaximum();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.getMinimalDaysInFirstWeek:()I");
                int n6 = n5 + this.weekDef.getMinimalDaysInFirstWeek();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.computeWeek:(II)I");
                int n7 = this.computeWeek(n3, n6);
                RuntimeCostAccounter.recordJump();
                if (n4 >= n7) {
                    n4 = n4 - n7 + 1;
                }
            }
            return n4;
        }

        private int startOfWeekOffset(int n, int n2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorMod:(II)I");
            int n3 = Math.floorMod(n - n2, 7);
            int n4 = -n3;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.getMinimalDaysInFirstWeek:()I");
            int n5 = this.weekDef.getMinimalDaysInFirstWeek();
            RuntimeCostAccounter.recordJump();
            if (n3 + 1 > n5) {
                n4 = 7 - n3;
            }
            return n4;
        }

        private int computeWeek(int n, int n2) {
            return (7 + n + (n2 - 1)) / 7;
        }

        @Override
        public <R extends Temporal> R adjustInto(R r, long l) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
            int n = this.range.checkValidIntValue(l, this);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.get:(Ljava/time/temporal/TemporalField;)I");
            int n2 = r.get(this);
            RuntimeCostAccounter.recordJump();
            if (n == n2) {
                return r;
            }
            RuntimeCostAccounter.recordJump();
            if (this.rangeUnit == ChronoUnit.FOREVER) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.access$000:(Ljava/time/temporal/WeekFields;)Ljava/time/temporal/TemporalField;");
                TemporalField temporalField = this.weekDef.dayOfWeek;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.get:(Ljava/time/temporal/TemporalField;)I");
                int n3 = r.get(temporalField);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.access$100:(Ljava/time/temporal/WeekFields;)Ljava/time/temporal/TemporalField;");
                TemporalField temporalField2 = this.weekDef.weekOfWeekBasedYear;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.get:(Ljava/time/temporal/TemporalField;)I");
                int n4 = r.get(temporalField2);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/Chronology;");
                Chronology chronology = Chronology.from(r);
                int n5 = (int)l;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.ofWeekBasedYear:(Ljava/time/chrono/Chronology;III)Ljava/time/chrono/ChronoLocalDate;");
                return (R)this.ofWeekBasedYear(chronology, n5, n4, n3);
            }
            long l2 = n - n2;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
            return (R)r.plus(l2, this.baseUnit);
        }

        @Override
        public ChronoLocalDate resolve(Map<TemporalField, Long> map, TemporalAccessor temporalAccessor, ResolverStyle resolverStyle) {
            block11: {
                Chronology chronology;
                int n;
                block12: {
                    block10: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                        long l = map.get(this);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.toIntExact:(J)I");
                        int n2 = Math.toIntExact(l);
                        RuntimeCostAccounter.recordJump();
                        if (this.rangeUnit == ChronoUnit.WEEKS) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
                            int n3 = this.range.checkValidIntValue(l, this);
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.getFirstDayOfWeek:()Ljava/time/DayOfWeek;");
                            DayOfWeek dayOfWeek = this.weekDef.getFirstDayOfWeek();
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/DayOfWeek.getValue:()I");
                            int n4 = dayOfWeek.getValue();
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorMod:(II)I");
                            long l2 = Math.floorMod(n4 - 1 + (n3 - 1), 7) + 1;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
                            map.remove(this);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                            Long l3 = l2;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                            map.put(ChronoField.DAY_OF_WEEK, l3);
                            return null;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                        boolean bl = map.containsKey(ChronoField.DAY_OF_WEEK);
                        RuntimeCostAccounter.recordJump();
                        if (!bl) {
                            return null;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                        long l4 = map.get(ChronoField.DAY_OF_WEEK);
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidIntValue:(J)I");
                        int n5 = ChronoField.DAY_OF_WEEK.checkValidIntValue(l4);
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.localizedDayOfWeek:(I)I");
                        n = this.localizedDayOfWeek(n5);
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/Chronology;");
                        chronology = Chronology.from(temporalAccessor);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                        boolean bl2 = map.containsKey(ChronoField.YEAR);
                        RuntimeCostAccounter.recordJump();
                        if (!bl2) break block10;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                        long l5 = map.get(ChronoField.YEAR);
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidIntValue:(J)I");
                        int n6 = ChronoField.YEAR.checkValidIntValue(l5);
                        RuntimeCostAccounter.recordJump();
                        if (this.rangeUnit == ChronoUnit.MONTHS) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                            boolean bl3 = map.containsKey(ChronoField.MONTH_OF_YEAR);
                            RuntimeCostAccounter.recordJump();
                            if (bl3) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                                long l6 = map.get(ChronoField.MONTH_OF_YEAR);
                                long l7 = n2;
                                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.resolveWoM:(Ljava/util/Map;Ljava/time/chrono/Chronology;IJJILjava/time/format/ResolverStyle;)Ljava/time/chrono/ChronoLocalDate;");
                                return this.resolveWoM(map, chronology, n6, l6, l7, n, resolverStyle);
                            }
                        }
                        RuntimeCostAccounter.recordJump();
                        if (this.rangeUnit == ChronoUnit.YEARS) {
                            long l8 = n2;
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.resolveWoY:(Ljava/util/Map;Ljava/time/chrono/Chronology;IJILjava/time/format/ResolverStyle;)Ljava/time/chrono/ChronoLocalDate;");
                            return this.resolveWoY(map, chronology, n6, l8, n, resolverStyle);
                        }
                        RuntimeCostAccounter.recordJump();
                        break block11;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (this.rangeUnit == WEEK_BASED_YEARS) break block12;
                    RuntimeCostAccounter.recordJump();
                    if (this.rangeUnit != ChronoUnit.FOREVER) break block11;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.access$200:(Ljava/time/temporal/WeekFields;)Ljava/time/temporal/TemporalField;");
                TemporalField temporalField = this.weekDef.weekBasedYear;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                boolean bl = map.containsKey(temporalField);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.access$100:(Ljava/time/temporal/WeekFields;)Ljava/time/temporal/TemporalField;");
                    TemporalField temporalField2 = this.weekDef.weekOfWeekBasedYear;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                    boolean bl4 = map.containsKey(temporalField2);
                    RuntimeCostAccounter.recordJump();
                    if (bl4) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.resolveWBY:(Ljava/util/Map;Ljava/time/chrono/Chronology;ILjava/time/format/ResolverStyle;)Ljava/time/chrono/ChronoLocalDate;");
                        return this.resolveWBY(map, chronology, n, resolverStyle);
                    }
                }
            }
            return null;
        }

        private ChronoLocalDate resolveWoM(Map<TemporalField, Long> map, Chronology chronology, int n, long l, long l2, int n2, ResolverStyle resolverStyle) {
            ChronoLocalDate chronoLocalDate;
            RuntimeCostAccounter.recordJump();
            if (resolverStyle == ResolverStyle.LENIENT) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.date:(III)Ljava/time/chrono/ChronoLocalDate;");
                ChronoLocalDate chronoLocalDate2 = chronology.date(n, 1, 1);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
                long l3 = Math.subtractExact(l, 1L);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
                chronoLocalDate = chronoLocalDate2.plus(l3, ChronoUnit.MONTHS);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.localizedWeekOfMonth:(Ljava/time/temporal/TemporalAccessor;)J");
                long l4 = this.localizedWeekOfMonth(chronoLocalDate);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
                long l5 = Math.subtractExact(l2, l4);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.localizedDayOfWeek:(Ljava/time/temporal/TemporalAccessor;)I");
                int n3 = n2 - this.localizedDayOfWeek(chronoLocalDate);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                long l6 = Math.multiplyExact(l5, 7L);
                long l7 = n3;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
                long l8 = Math.addExact(l6, l7);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
                chronoLocalDate = chronoLocalDate.plus(l8, ChronoUnit.DAYS);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidIntValue:(J)I");
                int n4 = ChronoField.MONTH_OF_YEAR.checkValidIntValue(l);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.date:(III)Ljava/time/chrono/ChronoLocalDate;");
                chronoLocalDate = chronology.date(n, n4, 1);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
                int n5 = this.range.checkValidIntValue(l2, this);
                long l9 = n5;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.localizedWeekOfMonth:(Ljava/time/temporal/TemporalAccessor;)J");
                int n6 = (int)(l9 - this.localizedWeekOfMonth(chronoLocalDate));
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.localizedDayOfWeek:(Ljava/time/temporal/TemporalAccessor;)I");
                int n7 = n2 - this.localizedDayOfWeek(chronoLocalDate);
                long l10 = n6 * 7 + n7;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
                chronoLocalDate = chronoLocalDate.plus(l10, ChronoUnit.DAYS);
                RuntimeCostAccounter.recordJump();
                if (resolverStyle == ResolverStyle.STRICT) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getLong:(Ljava/time/temporal/TemporalField;)J");
                    long l11 = chronoLocalDate.getLong(ChronoField.MONTH_OF_YEAR) - l;
                    long l12 = l11 == 0L ? 0 : (l11 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l12 != false) {
                        RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                        DateTimeException dateTimeException = new DateTimeException("Strict mode rejected resolved date as it is in a different month");
                        RuntimeCostAccounter.recordThrow();
                        throw dateTimeException;
                    }
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            map.remove(this);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            map.remove(ChronoField.YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            map.remove(ChronoField.MONTH_OF_YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            map.remove(ChronoField.DAY_OF_WEEK);
            return chronoLocalDate;
        }

        private ChronoLocalDate resolveWoY(Map<TemporalField, Long> map, Chronology chronology, int n, long l, int n2, ResolverStyle resolverStyle) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.date:(III)Ljava/time/chrono/ChronoLocalDate;");
            ChronoLocalDate chronoLocalDate = chronology.date(n, 1, 1);
            RuntimeCostAccounter.recordJump();
            if (resolverStyle == ResolverStyle.LENIENT) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.localizedWeekOfYear:(Ljava/time/temporal/TemporalAccessor;)J");
                long l2 = this.localizedWeekOfYear(chronoLocalDate);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
                long l3 = Math.subtractExact(l, l2);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.localizedDayOfWeek:(Ljava/time/temporal/TemporalAccessor;)I");
                int n3 = n2 - this.localizedDayOfWeek(chronoLocalDate);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                long l4 = Math.multiplyExact(l3, 7L);
                long l5 = n3;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
                long l6 = Math.addExact(l4, l5);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
                chronoLocalDate = chronoLocalDate.plus(l6, ChronoUnit.DAYS);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
                int n4 = this.range.checkValidIntValue(l, this);
                long l7 = n4;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.localizedWeekOfYear:(Ljava/time/temporal/TemporalAccessor;)J");
                int n5 = (int)(l7 - this.localizedWeekOfYear(chronoLocalDate));
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.localizedDayOfWeek:(Ljava/time/temporal/TemporalAccessor;)I");
                int n6 = n2 - this.localizedDayOfWeek(chronoLocalDate);
                long l8 = n5 * 7 + n6;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
                chronoLocalDate = chronoLocalDate.plus(l8, ChronoUnit.DAYS);
                RuntimeCostAccounter.recordJump();
                if (resolverStyle == ResolverStyle.STRICT) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getLong:(Ljava/time/temporal/TemporalField;)J");
                    long l9 = chronoLocalDate.getLong(ChronoField.YEAR) - (long)n;
                    long l10 = l9 == 0L ? 0 : (l9 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l10 != false) {
                        RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                        DateTimeException dateTimeException = new DateTimeException("Strict mode rejected resolved date as it is in a different year");
                        RuntimeCostAccounter.recordThrow();
                        throw dateTimeException;
                    }
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            map.remove(this);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            map.remove(ChronoField.YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            map.remove(ChronoField.DAY_OF_WEEK);
            return chronoLocalDate;
        }

        private ChronoLocalDate resolveWBY(Map<TemporalField, Long> map, Chronology chronology, int n, ResolverStyle resolverStyle) {
            ChronoLocalDate chronoLocalDate;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.access$200:(Ljava/time/temporal/WeekFields;)Ljava/time/temporal/TemporalField;");
            TemporalField temporalField = this.weekDef.weekBasedYear;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.range:()Ljava/time/temporal/ValueRange;");
            ValueRange valueRange = temporalField.range();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.access$200:(Ljava/time/temporal/WeekFields;)Ljava/time/temporal/TemporalField;");
            TemporalField temporalField2 = this.weekDef.weekBasedYear;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l = map.get(temporalField2);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.access$200:(Ljava/time/temporal/WeekFields;)Ljava/time/temporal/TemporalField;");
            TemporalField temporalField3 = this.weekDef.weekBasedYear;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
            int n2 = valueRange.checkValidIntValue(l, temporalField3);
            RuntimeCostAccounter.recordJump();
            if (resolverStyle == ResolverStyle.LENIENT) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.ofWeekBasedYear:(Ljava/time/chrono/Chronology;III)Ljava/time/chrono/ChronoLocalDate;");
                chronoLocalDate = this.ofWeekBasedYear(chronology, n2, 1, n);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.access$100:(Ljava/time/temporal/WeekFields;)Ljava/time/temporal/TemporalField;");
                TemporalField temporalField4 = this.weekDef.weekOfWeekBasedYear;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                long l2 = map.get(temporalField4);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
                long l3 = Math.subtractExact(l2, 1L);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
                chronoLocalDate = chronoLocalDate.plus(l3, ChronoUnit.WEEKS);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.access$100:(Ljava/time/temporal/WeekFields;)Ljava/time/temporal/TemporalField;");
                TemporalField temporalField5 = this.weekDef.weekOfWeekBasedYear;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.range:()Ljava/time/temporal/ValueRange;");
                ValueRange valueRange2 = temporalField5.range();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.access$100:(Ljava/time/temporal/WeekFields;)Ljava/time/temporal/TemporalField;");
                TemporalField temporalField6 = this.weekDef.weekOfWeekBasedYear;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                long l4 = map.get(temporalField6);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.access$100:(Ljava/time/temporal/WeekFields;)Ljava/time/temporal/TemporalField;");
                TemporalField temporalField7 = this.weekDef.weekOfWeekBasedYear;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
                int n3 = valueRange2.checkValidIntValue(l4, temporalField7);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.ofWeekBasedYear:(Ljava/time/chrono/Chronology;III)Ljava/time/chrono/ChronoLocalDate;");
                chronoLocalDate = this.ofWeekBasedYear(chronology, n2, n3, n);
                RuntimeCostAccounter.recordJump();
                if (resolverStyle == ResolverStyle.STRICT) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.localizedWeekBasedYear:(Ljava/time/temporal/TemporalAccessor;)I");
                    int n4 = this.localizedWeekBasedYear(chronoLocalDate);
                    RuntimeCostAccounter.recordJump();
                    if (n4 != n2) {
                        RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                        DateTimeException dateTimeException = new DateTimeException("Strict mode rejected resolved date as it is in a different week-based-year");
                        RuntimeCostAccounter.recordThrow();
                        throw dateTimeException;
                    }
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            map.remove(this);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.access$200:(Ljava/time/temporal/WeekFields;)Ljava/time/temporal/TemporalField;");
            TemporalField temporalField8 = this.weekDef.weekBasedYear;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            map.remove(temporalField8);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.access$100:(Ljava/time/temporal/WeekFields;)Ljava/time/temporal/TemporalField;");
            TemporalField temporalField9 = this.weekDef.weekOfWeekBasedYear;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            map.remove(temporalField9);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            map.remove(ChronoField.DAY_OF_WEEK);
            return chronoLocalDate;
        }

        @Override
        public String getDisplayName(Locale locale) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
            Objects.requireNonNull(locale, "locale");
            RuntimeCostAccounter.recordJump();
            if (this.rangeUnit == ChronoUnit.YEARS) {
                String string;
                RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleProviderAdapter.getResourceBundleBased:()Lsun/util/locale/provider/LocaleProviderAdapter;");
                LocaleProviderAdapter localeProviderAdapter = LocaleProviderAdapter.getResourceBundleBased();
                RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleProviderAdapter.getLocaleResources:(Ljava/util/Locale;)Lsun/util/locale/provider/LocaleResources;");
                LocaleResources localeResources = localeProviderAdapter.getLocaleResources(locale);
                RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleResources.getJavaTimeFormatData:()Ljava/util/ResourceBundle;");
                ResourceBundle resourceBundle = localeResources.getJavaTimeFormatData();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ResourceBundle.containsKey:(Ljava/lang/String;)Z");
                boolean bl = resourceBundle.containsKey("field.week");
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ResourceBundle.getString:(Ljava/lang/String;)Ljava/lang/String;");
                    string = resourceBundle.getString("field.week");
                    RuntimeCostAccounter.recordJump();
                } else {
                    string = this.name;
                }
                return string;
            }
            return this.name;
        }

        @Override
        public TemporalUnit getBaseUnit() {
            return this.baseUnit;
        }

        @Override
        public TemporalUnit getRangeUnit() {
            return this.rangeUnit;
        }

        @Override
        public boolean isDateBased() {
            return true;
        }

        @Override
        public boolean isTimeBased() {
            return false;
        }

        @Override
        public ValueRange range() {
            return this.range;
        }

        @Override
        public boolean isSupportedBy(TemporalAccessor temporalAccessor) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.isSupported:(Ljava/time/temporal/TemporalField;)Z");
            boolean bl = temporalAccessor.isSupported(ChronoField.DAY_OF_WEEK);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordJump();
                if (this.rangeUnit == ChronoUnit.WEEKS) {
                    return true;
                }
                RuntimeCostAccounter.recordJump();
                if (this.rangeUnit == ChronoUnit.MONTHS) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.isSupported:(Ljava/time/temporal/TemporalField;)Z");
                    return temporalAccessor.isSupported(ChronoField.DAY_OF_MONTH);
                }
                RuntimeCostAccounter.recordJump();
                if (this.rangeUnit == ChronoUnit.YEARS) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.isSupported:(Ljava/time/temporal/TemporalField;)Z");
                    return temporalAccessor.isSupported(ChronoField.DAY_OF_YEAR);
                }
                RuntimeCostAccounter.recordJump();
                if (this.rangeUnit == WEEK_BASED_YEARS) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.isSupported:(Ljava/time/temporal/TemporalField;)Z");
                    return temporalAccessor.isSupported(ChronoField.DAY_OF_YEAR);
                }
                RuntimeCostAccounter.recordJump();
                if (this.rangeUnit == ChronoUnit.FOREVER) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.isSupported:(Ljava/time/temporal/TemporalField;)Z");
                    return temporalAccessor.isSupported(ChronoField.YEAR);
                }
            }
            return false;
        }

        @Override
        public ValueRange rangeRefinedBy(TemporalAccessor temporalAccessor) {
            RuntimeCostAccounter.recordJump();
            if (this.rangeUnit == ChronoUnit.WEEKS) {
                return this.range;
            }
            RuntimeCostAccounter.recordJump();
            if (this.rangeUnit == ChronoUnit.MONTHS) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.rangeByWeek:(Ljava/time/temporal/TemporalAccessor;Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
                return this.rangeByWeek(temporalAccessor, ChronoField.DAY_OF_MONTH);
            }
            RuntimeCostAccounter.recordJump();
            if (this.rangeUnit == ChronoUnit.YEARS) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.rangeByWeek:(Ljava/time/temporal/TemporalAccessor;Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
                return this.rangeByWeek(temporalAccessor, ChronoField.DAY_OF_YEAR);
            }
            RuntimeCostAccounter.recordJump();
            if (this.rangeUnit == WEEK_BASED_YEARS) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.rangeWeekOfWeekBasedYear:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/temporal/ValueRange;");
                return this.rangeWeekOfWeekBasedYear(temporalAccessor);
            }
            RuntimeCostAccounter.recordJump();
            if (this.rangeUnit == ChronoUnit.FOREVER) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.range:()Ljava/time/temporal/ValueRange;");
                return ChronoField.YEAR.range();
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("unreachable, rangeUnit: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(this.rangeUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(", this: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(this);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder5.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
            IllegalStateException illegalStateException = new IllegalStateException(string);
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }

        private ValueRange rangeByWeek(TemporalAccessor temporalAccessor, TemporalField temporalField) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.localizedDayOfWeek:(Ljava/time/temporal/TemporalAccessor;)I");
            int n = this.localizedDayOfWeek(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.get:(Ljava/time/temporal/TemporalField;)I");
            int n2 = temporalAccessor.get(temporalField);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.startOfWeekOffset:(II)I");
            int n3 = this.startOfWeekOffset(n2, n);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
            ValueRange valueRange = temporalAccessor.range(temporalField);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMinimum:()J");
            int n4 = (int)valueRange.getMinimum();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.computeWeek:(II)I");
            long l = this.computeWeek(n3, n4);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMaximum:()J");
            int n5 = (int)valueRange.getMaximum();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.computeWeek:(II)I");
            long l2 = this.computeWeek(n3, n5);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
            return ValueRange.of(l, l2);
        }

        private ValueRange rangeWeekOfWeekBasedYear(TemporalAccessor temporalAccessor) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.isSupported:(Ljava/time/temporal/TemporalField;)Z");
            boolean bl = temporalAccessor.isSupported(ChronoField.DAY_OF_YEAR);
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                return WEEK_OF_YEAR_RANGE;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.localizedDayOfWeek:(Ljava/time/temporal/TemporalAccessor;)I");
            int n = this.localizedDayOfWeek(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.get:(Ljava/time/temporal/TemporalField;)I");
            int n2 = temporalAccessor.get(ChronoField.DAY_OF_YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.startOfWeekOffset:(II)I");
            int n3 = this.startOfWeekOffset(n2, n);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.computeWeek:(II)I");
            int n4 = this.computeWeek(n3, n2);
            RuntimeCostAccounter.recordJump();
            if (n4 == 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/Chronology;");
                Chronology chronology = Chronology.from(temporalAccessor);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.date:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/ChronoLocalDate;");
                ChronoLocalDate chronoLocalDate = chronology.date(temporalAccessor);
                long l = n2 + 7;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.minus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
                chronoLocalDate = chronoLocalDate.minus(l, ChronoUnit.DAYS);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.rangeWeekOfWeekBasedYear:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/temporal/ValueRange;");
                return this.rangeWeekOfWeekBasedYear(chronoLocalDate);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
            ValueRange valueRange = temporalAccessor.range(ChronoField.DAY_OF_YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMaximum:()J");
            int n5 = (int)valueRange.getMaximum();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.getMinimalDaysInFirstWeek:()I");
            int n6 = n5 + this.weekDef.getMinimalDaysInFirstWeek();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.computeWeek:(II)I");
            int n7 = this.computeWeek(n3, n6);
            RuntimeCostAccounter.recordJump();
            if (n4 >= n7) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/Chronology;");
                Chronology chronology = Chronology.from(temporalAccessor);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.date:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/ChronoLocalDate;");
                ChronoLocalDate chronoLocalDate = chronology.date(temporalAccessor);
                long l = n5 - n2 + 1 + 7;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
                chronoLocalDate = chronoLocalDate.plus(l, ChronoUnit.DAYS);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields$ComputedDayOfField.rangeWeekOfWeekBasedYear:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/temporal/ValueRange;");
                return this.rangeWeekOfWeekBasedYear(chronoLocalDate);
            }
            long l = n7 - 1;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
            return ValueRange.of(1L, l);
        }

        @Override
        public String toString() {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append(this.name);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append("[");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.toString:()Ljava/lang/String;");
            String string = this.weekDef.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append("]");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder5.toString();
        }

        static {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
            DAY_OF_WEEK_RANGE = ValueRange.of(1L, 7L);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJJJ)Ljava/time/temporal/ValueRange;");
            WEEK_OF_MONTH_RANGE = ValueRange.of(0L, 1L, 4L, 6L);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJJJ)Ljava/time/temporal/ValueRange;");
            WEEK_OF_YEAR_RANGE = ValueRange.of(0L, 1L, 52L, 54L);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJJ)Ljava/time/temporal/ValueRange;");
            WEEK_OF_WEEK_BASED_YEAR_RANGE = ValueRange.of(1L, 52L, 53L);
        }
    }
}

