/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.chrono;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.LocalTime;
import sandbox.java.time.ZoneId;
import sandbox.java.time.ZoneOffset;
import sandbox.java.time.chrono.AbstractChronology;
import sandbox.java.time.chrono.ChronoLocalDateImpl;
import sandbox.java.time.chrono.ChronoLocalDateTime;
import sandbox.java.time.chrono.ChronoLocalDateTimeImpl;
import sandbox.java.time.chrono.ChronoPeriod;
import sandbox.java.time.chrono.Chronology;
import sandbox.java.time.chrono.Era;
import sandbox.java.time.format.DateTimeFormatter;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.ChronoUnit;
import sandbox.java.time.temporal.Temporal;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalAdjuster;
import sandbox.java.time.temporal.TemporalAmount;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.TemporalQueries;
import sandbox.java.time.temporal.TemporalQuery;
import sandbox.java.time.temporal.TemporalUnit;
import sandbox.java.time.temporal.UnsupportedTemporalTypeException;
import sandbox.java.util.Comparator;
import sandbox.java.util.Objects;

public interface ChronoLocalDate
extends Temporal,
TemporalAdjuster,
Comparable<ChronoLocalDate> {
    public static Comparator<ChronoLocalDate> timeLineOrder() {
        return AbstractChronology.DATE_ORDER;
    }

    public static ChronoLocalDate from(TemporalAccessor temporalAccessor) {
        boolean bl = temporalAccessor instanceof ChronoLocalDate;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return (ChronoLocalDate)temporalAccessor;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalAccessor, "temporal");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.chronology:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<Chronology> temporalQuery = TemporalQueries.chronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        Chronology chronology = temporalAccessor.query(temporalQuery);
        RuntimeCostAccounter.recordJump();
        if (chronology == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unable to obtain ChronoLocalDate from TemporalAccessor: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = temporalAccessor.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(clazz);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException(string);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.date:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/ChronoLocalDate;");
        return chronology.date(temporalAccessor);
    }

    public Chronology getChronology();

    default public Era getEra() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.get:(Ljava/time/temporal/TemporalField;)I");
        int n = this.get(ChronoField.ERA);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.eraOf:(I)Ljava/time/chrono/Era;");
        return chronology.eraOf(n);
    }

    default public boolean isLeapYear() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getLong:(Ljava/time/temporal/TemporalField;)J");
        long l = this.getLong(ChronoField.YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.isLeapYear:(J)Z");
        return chronology.isLeapYear(l);
    }

    public int lengthOfMonth();

    default public int lengthOfYear() {
        int n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.isLeapYear:()Z");
        boolean bl = this.isLeapYear();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            n = 366;
            RuntimeCostAccounter.recordJump();
        } else {
            n = 365;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    default public boolean isSupported(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.isDateBased:()Z");
            return temporalField.isDateBased();
        }
        RuntimeCostAccounter.recordJump();
        if (temporalField == null) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.isSupportedBy:(Ljava/time/temporal/TemporalAccessor;)Z");
        boolean bl2 = temporalField.isSupportedBy(this);
        RuntimeCostAccounter.recordJump();
        if (!bl2) return false;
        boolean bl3 = true;
        RuntimeCostAccounter.recordJump();
        return bl3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    default public boolean isSupported(TemporalUnit temporalUnit) {
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.isDateBased:()Z");
            return temporalUnit.isDateBased();
        }
        RuntimeCostAccounter.recordJump();
        if (temporalUnit == null) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.isSupportedBy:(Ljava/time/temporal/Temporal;)Z");
        boolean bl2 = temporalUnit.isSupportedBy(this);
        RuntimeCostAccounter.recordJump();
        if (!bl2) return false;
        boolean bl3 = true;
        RuntimeCostAccounter.recordJump();
        return bl3;
    }

    @Override
    default public ChronoLocalDate with(TemporalAdjuster temporalAdjuster) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.with:(Ljava/time/temporal/TemporalAdjuster;)Ljava/time/temporal/Temporal;");
        Temporal temporal = Temporal.super.with(temporalAdjuster);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.ensureValid:(Ljava/time/chrono/Chronology;Ljava/time/temporal/Temporal;)Ljava/time/chrono/ChronoLocalDate;");
        return ChronoLocalDateImpl.ensureValid(chronology, temporal);
    }

    @Override
    default public ChronoLocalDate with(TemporalField temporalField, long l) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported field: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalField);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.adjustInto:(Ljava/time/temporal/Temporal;J)Ljava/time/temporal/Temporal;");
        ChronoLocalDate chronoLocalDate = temporalField.adjustInto(this, l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.ensureValid:(Ljava/time/chrono/Chronology;Ljava/time/temporal/Temporal;)Ljava/time/chrono/ChronoLocalDate;");
        return ChronoLocalDateImpl.ensureValid(chronology, chronoLocalDate);
    }

    @Override
    default public ChronoLocalDate plus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.plus:(Ljava/time/temporal/TemporalAmount;)Ljava/time/temporal/Temporal;");
        Temporal temporal = Temporal.super.plus(temporalAmount);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.ensureValid:(Ljava/time/chrono/Chronology;Ljava/time/temporal/Temporal;)Ljava/time/chrono/ChronoLocalDate;");
        return ChronoLocalDateImpl.ensureValid(chronology, temporal);
    }

    @Override
    default public ChronoLocalDate plus(long l, TemporalUnit temporalUnit) {
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported unit: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.addTo:(Ljava/time/temporal/Temporal;J)Ljava/time/temporal/Temporal;");
        ChronoLocalDate chronoLocalDate = temporalUnit.addTo(this, l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.ensureValid:(Ljava/time/chrono/Chronology;Ljava/time/temporal/Temporal;)Ljava/time/chrono/ChronoLocalDate;");
        return ChronoLocalDateImpl.ensureValid(chronology, chronoLocalDate);
    }

    @Override
    default public ChronoLocalDate minus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.minus:(Ljava/time/temporal/TemporalAmount;)Ljava/time/temporal/Temporal;");
        Temporal temporal = Temporal.super.minus(temporalAmount);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.ensureValid:(Ljava/time/chrono/Chronology;Ljava/time/temporal/Temporal;)Ljava/time/chrono/ChronoLocalDate;");
        return ChronoLocalDateImpl.ensureValid(chronology, temporal);
    }

    @Override
    default public ChronoLocalDate minus(long l, TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.minus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
        Temporal temporal = Temporal.super.minus(l, temporalUnit);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.ensureValid:(Ljava/time/chrono/Chronology;Ljava/time/temporal/Temporal;)Ljava/time/chrono/ChronoLocalDate;");
        return ChronoLocalDateImpl.ensureValid(chronology, temporal);
    }

    @Override
    default public <R> R query(TemporalQuery<R> temporalQuery) {
        block7: {
            block6: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.zoneId:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<ZoneId> temporalQuery2 = TemporalQueries.zoneId();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery == temporalQuery2) break block6;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.zone:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<ZoneId> temporalQuery3 = TemporalQueries.zone();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery == temporalQuery3) break block6;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.offset:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<ZoneOffset> temporalQuery4 = TemporalQueries.offset();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery != temporalQuery4) break block7;
            }
            return null;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.localTime:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<LocalTime> temporalQuery5 = TemporalQueries.localTime();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery5) {
            return null;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.chronology:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<Chronology> temporalQuery6 = TemporalQueries.chronology();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery6) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getChronology:()Ljava/time/chrono/Chronology;");
            return (R)this.getChronology();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.precision:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<TemporalUnit> temporalQuery7 = TemporalQueries.precision();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery7) {
            return (R)ChronoUnit.DAYS;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQuery.queryFrom:(Ljava/time/temporal/TemporalAccessor;)Ljava/lang/Object;");
        return temporalQuery.queryFrom(this);
    }

    @Override
    default public Temporal adjustInto(Temporal temporal) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.toEpochDay:()J");
        long l = this.toEpochDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/temporal/Temporal;");
        return temporal.with(ChronoField.EPOCH_DAY, l);
    }

    @Override
    public long until(Temporal var1, TemporalUnit var2);

    public ChronoPeriod until(ChronoLocalDate var1);

    default public String format(DateTimeFormatter dateTimeFormatter) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.format:(Ljava/time/temporal/TemporalAccessor;)Ljava/lang/String;");
        return dateTimeFormatter.format(this);
    }

    default public ChronoLocalDateTime<?> atTime(LocalTime localTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.of:(Ljava/time/chrono/ChronoLocalDate;Ljava/time/LocalTime;)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
        return ChronoLocalDateTimeImpl.of(this, localTime);
    }

    default public long toEpochDay() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getLong:(Ljava/time/temporal/TemporalField;)J");
        return this.getLong(ChronoField.EPOCH_DAY);
    }

    @Override
    default public int compareTo(ChronoLocalDate chronoLocalDate) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.toEpochDay:()J");
        long l = this.toEpochDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.toEpochDay:()J");
        long l2 = chronoLocalDate.toEpochDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.compare:(JJ)I");
        int n = Long.compare(l, l2);
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getChronology:()Ljava/time/chrono/Chronology;");
            Chronology chronology = this.getChronology();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getChronology:()Ljava/time/chrono/Chronology;");
            Chronology chronology2 = chronoLocalDate.getChronology();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.compareTo:(Ljava/time/chrono/Chronology;)I");
            n = chronology.compareTo(chronology2);
        }
        return n;
    }

    default public boolean isAfter(ChronoLocalDate chronoLocalDate) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.toEpochDay:()J");
        long l = this.toEpochDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.toEpochDay:()J");
        long l2 = l - chronoLocalDate.toEpochDay();
        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l3 > 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    default public boolean isBefore(ChronoLocalDate chronoLocalDate) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.toEpochDay:()J");
        long l = this.toEpochDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.toEpochDay:()J");
        long l2 = l - chronoLocalDate.toEpochDay();
        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l3 < 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    default public boolean isEqual(ChronoLocalDate chronoLocalDate) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.toEpochDay:()J");
        long l = this.toEpochDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.toEpochDay:()J");
        long l2 = l - chronoLocalDate.toEpochDay();
        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l3 == false) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean equals(Object var1);

    public int hashCode();

    public String toString();
}

