/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.test;

import co.paralleluniverse.common.util.Debug;
import java.util.Arrays;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class TestUtil {
    public static final TestRule WATCHMAN = new TestWatcher(){

        protected void starting(Description desc) {
            if (Debug.isDebug()) {
                System.out.println("STARTING TEST " + desc.getMethodName());
                Debug.record(0, (Object)("STARTING TEST " + desc.getMethodName()));
            }
        }

        public void failed(Throwable e, Description desc) {
            System.out.println("FAILED TEST " + desc.getMethodName() + ": " + e.getMessage());
            e.printStackTrace(System.err);
            if (Debug.isDebug() && !(e instanceof OutOfMemoryError)) {
                Debug.record(0, (Object)("EXCEPTION IN THREAD " + Thread.currentThread().getName() + ": " + e + " - " + Arrays.toString(e.getStackTrace())));
                Debug.dumpRecorder("quasar." + desc.getClassName() + "." + desc.getMethodName() + ".dump");
            }
        }

        protected void succeeded(Description desc) {
            Debug.record(0, (Object)("DONE TEST " + desc.getMethodName()));
        }
    };
}

