/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.io.serialization.kryo;

import co.paralleluniverse.io.serialization.kryo.KryoSerializer;
import co.paralleluniverse.io.serialization.kryo.KryoUtil;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Externalizable;
import java.io.IOException;

public class ExternalizableKryoSerializer<T extends Externalizable>
extends Serializer<T> {
    private static final KryoSerializer ks = new KryoSerializer();

    public void write(Kryo kryo, Output output, T obj) {
        try {
            obj.writeExternal(KryoUtil.asObjectOutput(output, kryo));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public T read(Kryo kryo, Input input, Class<T> type) {
        try {
            Externalizable obj = (Externalizable)kryo.newInstance(type);
            obj.readExternal(KryoUtil.asObjectInput(input, kryo));
            return (T)obj;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
    }
}

