// Copyright (c) 2014-2020 The Khronos Group Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and/or associated documentation files (the "Materials"),
// to deal in the Materials without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Materials, and to permit persons to whom the
// Materials are furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Materials.
//
// MODIFICATIONS TO THIS FILE MAY MEAN IT NO LONGER ACCURATELY REFLECTS KHRONOS
// STANDARDS. THE UNMODIFIED, NORMATIVE VERSIONS OF KHRONOS SPECIFICATIONS AND
// HEADER INFORMATION ARE LOCATED AT https://www.khronos.org/registry/
//
// THE MATERIALS ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM,OUT OF OR IN CONNECTION WITH THE MATERIALS OR THE USE OR OTHER DEALINGS
// IN THE MATERIALS.

// This header is automatically generated by the same tool that creates
// the Binary Section of the SPIR-V specification.

// Enumeration tokens for SPIR-V, in various styles:
//   C, C++, C++11, JSON, Lua, Python, C#, D
//
// - C will have tokens with a "Spv" prefix, e.g.: SpvSourceLanguageGLSL
// - C++ will have tokens in the "spv" name space, e.g.: spv::SourceLanguageGLSL
// - C++11 will use enum classes in the spv namespace, e.g.: spv::SourceLanguage::GLSL
// - Lua will use tables, e.g.: spv.SourceLanguage.GLSL
// - Python will use dictionaries, e.g.: spv['SourceLanguage']['GLSL']
// - C# will use enum classes in the Specification class located in the "Spv" namespace,
//     e.g.: Spv.Specification.SourceLanguage.GLSL
// - D will have tokens under the "spv" module, e.g: spv.SourceLanguage.GLSL
//
// Some tokens act like mask values, which can be OR'd together,
// while others are mutually exclusive.  The mask-like ones have
// "Mask" in their name, and a parallel enum that has the shift
// amount (1 << x) for each corresponding enumerant.

#ifndef spirv_11_HPP
#define spirv_11_HPP

namespace spv11 {

typedef unsigned int Id;

// #define SPV_VERSION 0x10500
// #define SPV_REVISION 4

static const unsigned int MagicNumber = 0x07230203;
static const unsigned int Version = 0x00010500;
static const unsigned int Revision = 4;
static const unsigned int OpCodeMask = 0xffff;
static const unsigned int WordCountShift = 16;

enum class SourceLanguage : unsigned {
    Unknown = 0,
    ESSL = 1,
    GLSL = 2,
    OpenCL_C = 3,
    OpenCL_CPP = 4,
    HLSL = 5,
    Max = 0x7fffffff,
};

enum class ExecutionModel : unsigned {
    Vertex = 0,
    TessellationControl = 1,
    TessellationEvaluation = 2,
    Geometry = 3,
    Fragment = 4,
    GLCompute = 5,
    Kernel = 6,
    TaskNV = 5267,
    MeshNV = 5268,
    RayGenerationKHR = 5313,
    RayGenerationNV = 5313,
    IntersectionKHR = 5314,
    IntersectionNV = 5314,
    AnyHitKHR = 5315,
    AnyHitNV = 5315,
    ClosestHitKHR = 5316,
    ClosestHitNV = 5316,
    MissKHR = 5317,
    MissNV = 5317,
    CallableKHR = 5318,
    CallableNV = 5318,
    Max = 0x7fffffff,
};

enum class AddressingModel : unsigned {
    Logical = 0,
    Physical32 = 1,
    Physical64 = 2,
    PhysicalStorageBuffer64 = 5348,
    PhysicalStorageBuffer64EXT = 5348,
    Max = 0x7fffffff,
};

enum class MemoryModel : unsigned {
    Simple = 0,
    GLSL450 = 1,
    OpenCL = 2,
    Vulkan = 3,
    VulkanKHR = 3,
    Max = 0x7fffffff,
};

enum class ExecutionMode : unsigned {
    Invocations = 0,
    SpacingEqual = 1,
    SpacingFractionalEven = 2,
    SpacingFractionalOdd = 3,
    VertexOrderCw = 4,
    VertexOrderCcw = 5,
    PixelCenterInteger = 6,
    OriginUpperLeft = 7,
    OriginLowerLeft = 8,
    EarlyFragmentTests = 9,
    PointMode = 10,
    Xfb = 11,
    DepthReplacing = 12,
    DepthGreater = 14,
    DepthLess = 15,
    DepthUnchanged = 16,
    LocalSize = 17,
    LocalSizeHint = 18,
    InputPoints = 19,
    InputLines = 20,
    InputLinesAdjacency = 21,
    Triangles = 22,
    InputTrianglesAdjacency = 23,
    Quads = 24,
    Isolines = 25,
    OutputVertices = 26,
    OutputPoints = 27,
    OutputLineStrip = 28,
    OutputTriangleStrip = 29,
    VecTypeHint = 30,
    ContractionOff = 31,
    Initializer = 33,
    Finalizer = 34,
    SubgroupSize = 35,
    SubgroupsPerWorkgroup = 36,
    SubgroupsPerWorkgroupId = 37,
    LocalSizeId = 38,
    LocalSizeHintId = 39,
    PostDepthCoverage = 4446,
    DenormPreserve = 4459,
    DenormFlushToZero = 4460,
    SignedZeroInfNanPreserve = 4461,
    RoundingModeRTE = 4462,
    RoundingModeRTZ = 4463,
    StencilRefReplacingEXT = 5027,
    OutputLinesNV = 5269,
    OutputPrimitivesNV = 5270,
    DerivativeGroupQuadsNV = 5289,
    DerivativeGroupLinearNV = 5290,
    OutputTrianglesNV = 5298,
    PixelInterlockOrderedEXT = 5366,
    PixelInterlockUnorderedEXT = 5367,
    SampleInterlockOrderedEXT = 5368,
    SampleInterlockUnorderedEXT = 5369,
    ShadingRateInterlockOrderedEXT = 5370,
    ShadingRateInterlockUnorderedEXT = 5371,
    MaxWorkgroupSizeINTEL = 5893,
    MaxWorkDimINTEL = 5894,
    NoGlobalOffsetINTEL = 5895,
    NumSIMDWorkitemsINTEL = 5896,
    Max = 0x7fffffff,
};

enum class StorageClass : unsigned {
    UniformConstant = 0,
    Input = 1,
    Uniform = 2,
    Output = 3,
    Workgroup = 4,
    CrossWorkgroup = 5,
    Private = 6,
    Function = 7,
    Generic = 8,
    PushConstant = 9,
    AtomicCounter = 10,
    Image = 11,
    StorageBuffer = 12,
    CallableDataKHR = 5328,
    CallableDataNV = 5328,
    IncomingCallableDataKHR = 5329,
    IncomingCallableDataNV = 5329,
    RayPayloadKHR = 5338,
    RayPayloadNV = 5338,
    HitAttributeKHR = 5339,
    HitAttributeNV = 5339,
    IncomingRayPayloadKHR = 5342,
    IncomingRayPayloadNV = 5342,
    ShaderRecordBufferKHR = 5343,
    ShaderRecordBufferNV = 5343,
    PhysicalStorageBuffer = 5349,
    PhysicalStorageBufferEXT = 5349,
    CodeSectionINTEL = 5605,
    Max = 0x7fffffff,
};

enum class Dim : unsigned {
    Dim1D = 0,
    Dim2D = 1,
    Dim3D = 2,
    Cube = 3,
    Rect = 4,
    Buffer = 5,
    SubpassData = 6,
    Max = 0x7fffffff,
};

enum class SamplerAddressingMode : unsigned {
    None = 0,
    ClampToEdge = 1,
    Clamp = 2,
    Repeat = 3,
    RepeatMirrored = 4,
    Max = 0x7fffffff,
};

enum class SamplerFilterMode : unsigned {
    Nearest = 0,
    Linear = 1,
    Max = 0x7fffffff,
};

enum class ImageFormat : unsigned {
    Unknown = 0,
    Rgba32f = 1,
    Rgba16f = 2,
    R32f = 3,
    Rgba8 = 4,
    Rgba8Snorm = 5,
    Rg32f = 6,
    Rg16f = 7,
    R11fG11fB10f = 8,
    R16f = 9,
    Rgba16 = 10,
    Rgb10A2 = 11,
    Rg16 = 12,
    Rg8 = 13,
    R16 = 14,
    R8 = 15,
    Rgba16Snorm = 16,
    Rg16Snorm = 17,
    Rg8Snorm = 18,
    R16Snorm = 19,
    R8Snorm = 20,
    Rgba32i = 21,
    Rgba16i = 22,
    Rgba8i = 23,
    R32i = 24,
    Rg32i = 25,
    Rg16i = 26,
    Rg8i = 27,
    R16i = 28,
    R8i = 29,
    Rgba32ui = 30,
    Rgba16ui = 31,
    Rgba8ui = 32,
    R32ui = 33,
    Rgb10a2ui = 34,
    Rg32ui = 35,
    Rg16ui = 36,
    Rg8ui = 37,
    R16ui = 38,
    R8ui = 39,
    R64ui = 40,
    R64i = 41,
    Max = 0x7fffffff,
};

enum class ImageChannelOrder : unsigned {
    R = 0,
    A = 1,
    RG = 2,
    RA = 3,
    RGB = 4,
    RGBA = 5,
    BGRA = 6,
    ARGB = 7,
    Intensity = 8,
    Luminance = 9,
    Rx = 10,
    RGx = 11,
    RGBx = 12,
    Depth = 13,
    DepthStencil = 14,
    sRGB = 15,
    sRGBx = 16,
    sRGBA = 17,
    sBGRA = 18,
    ABGR = 19,
    Max = 0x7fffffff,
};

enum class ImageChannelDataType : unsigned {
    SnormInt8 = 0,
    SnormInt16 = 1,
    UnormInt8 = 2,
    UnormInt16 = 3,
    UnormShort565 = 4,
    UnormShort555 = 5,
    UnormInt101010 = 6,
    SignedInt8 = 7,
    SignedInt16 = 8,
    SignedInt32 = 9,
    UnsignedInt8 = 10,
    UnsignedInt16 = 11,
    UnsignedInt32 = 12,
    HalfFloat = 13,
    Float = 14,
    UnormInt24 = 15,
    UnormInt101010_2 = 16,
    Max = 0x7fffffff,
};

enum class ImageOperandsShift : unsigned {
    Bias = 0,
    Lod = 1,
    Grad = 2,
    ConstOffset = 3,
    Offset = 4,
    ConstOffsets = 5,
    Sample = 6,
    MinLod = 7,
    MakeTexelAvailable = 8,
    MakeTexelAvailableKHR = 8,
    MakeTexelVisible = 9,
    MakeTexelVisibleKHR = 9,
    NonPrivateTexel = 10,
    NonPrivateTexelKHR = 10,
    VolatileTexel = 11,
    VolatileTexelKHR = 11,
    SignExtend = 12,
    ZeroExtend = 13,
    Max = 0x7fffffff,
};

enum class ImageOperandsMask : unsigned {
    MaskNone = 0,
    Bias = 0x00000001,
    Lod = 0x00000002,
    Grad = 0x00000004,
    ConstOffset = 0x00000008,
    Offset = 0x00000010,
    ConstOffsets = 0x00000020,
    Sample = 0x00000040,
    MinLod = 0x00000080,
    MakeTexelAvailable = 0x00000100,
    MakeTexelAvailableKHR = 0x00000100,
    MakeTexelVisible = 0x00000200,
    MakeTexelVisibleKHR = 0x00000200,
    NonPrivateTexel = 0x00000400,
    NonPrivateTexelKHR = 0x00000400,
    VolatileTexel = 0x00000800,
    VolatileTexelKHR = 0x00000800,
    SignExtend = 0x00001000,
    ZeroExtend = 0x00002000,
};

enum class FPFastMathModeShift : unsigned {
    NotNaN = 0,
    NotInf = 1,
    NSZ = 2,
    AllowRecip = 3,
    Fast = 4,
    Max = 0x7fffffff,
};

enum class FPFastMathModeMask : unsigned {
    MaskNone = 0,
    NotNaN = 0x00000001,
    NotInf = 0x00000002,
    NSZ = 0x00000004,
    AllowRecip = 0x00000008,
    Fast = 0x00000010,
};

enum class FPRoundingMode : unsigned {
    RTE = 0,
    RTZ = 1,
    RTP = 2,
    RTN = 3,
    Max = 0x7fffffff,
};

enum class LinkageType : unsigned {
    Export = 0,
    Import = 1,
    Max = 0x7fffffff,
};

enum class AccessQualifier : unsigned {
    ReadOnly = 0,
    WriteOnly = 1,
    ReadWrite = 2,
    Max = 0x7fffffff,
};

enum class FunctionParameterAttribute : unsigned {
    Zext = 0,
    Sext = 1,
    ByVal = 2,
    Sret = 3,
    NoAlias = 4,
    NoCapture = 5,
    NoWrite = 6,
    NoReadWrite = 7,
    Max = 0x7fffffff,
};

enum class Decoration : unsigned {
    RelaxedPrecision = 0,
    SpecId = 1,
    Block = 2,
    BufferBlock = 3,
    RowMajor = 4,
    ColMajor = 5,
    ArrayStride = 6,
    MatrixStride = 7,
    GLSLShared = 8,
    GLSLPacked = 9,
    CPacked = 10,
    BuiltIn = 11,
    NoPerspective = 13,
    Flat = 14,
    Patch = 15,
    Centroid = 16,
    Sample = 17,
    Invariant = 18,
    Restrict = 19,
    Aliased = 20,
    Volatile = 21,
    Constant = 22,
    Coherent = 23,
    NonWritable = 24,
    NonReadable = 25,
    Uniform = 26,
    UniformId = 27,
    SaturatedConversion = 28,
    Stream = 29,
    Location = 30,
    Component = 31,
    Index = 32,
    Binding = 33,
    DescriptorSet = 34,
    Offset = 35,
    XfbBuffer = 36,
    XfbStride = 37,
    FuncParamAttr = 38,
    FPRoundingMode = 39,
    FPFastMathMode = 40,
    LinkageAttributes = 41,
    NoContraction = 42,
    InputAttachmentIndex = 43,
    Alignment = 44,
    MaxByteOffset = 45,
    AlignmentId = 46,
    MaxByteOffsetId = 47,
    NoSignedWrap = 4469,
    NoUnsignedWrap = 4470,
    ExplicitInterpAMD = 4999,
    OverrideCoverageNV = 5248,
    PassthroughNV = 5250,
    ViewportRelativeNV = 5252,
    SecondaryViewportRelativeNV = 5256,
    PerPrimitiveNV = 5271,
    PerViewNV = 5272,
    PerTaskNV = 5273,
    PerVertexNV = 5285,
    NonUniform = 5300,
    NonUniformEXT = 5300,
    RestrictPointer = 5355,
    RestrictPointerEXT = 5355,
    AliasedPointer = 5356,
    AliasedPointerEXT = 5356,
    ReferencedIndirectlyINTEL = 5602,
    CounterBuffer = 5634,
    HlslCounterBufferGOOGLE = 5634,
    HlslSemanticGOOGLE = 5635,
    UserSemantic = 5635,
    UserTypeGOOGLE = 5636,
    RegisterINTEL = 5825,
    MemoryINTEL = 5826,
    NumbanksINTEL = 5827,
    BankwidthINTEL = 5828,
    MaxPrivateCopiesINTEL = 5829,
    SinglepumpINTEL = 5830,
    DoublepumpINTEL = 5831,
    MaxReplicatesINTEL = 5832,
    SimpleDualPortINTEL = 5833,
    MergeINTEL = 5834,
    BankBitsINTEL = 5835,
    ForcePow2DepthINTEL = 5836,
    Max = 0x7fffffff,
};

enum class BuiltIn : unsigned {
    Position = 0,
    PointSize = 1,
    ClipDistance = 3,
    CullDistance = 4,
    VertexId = 5,
    InstanceId = 6,
    PrimitiveId = 7,
    InvocationId = 8,
    Layer = 9,
    ViewportIndex = 10,
    TessLevelOuter = 11,
    TessLevelInner = 12,
    TessCoord = 13,
    PatchVertices = 14,
    FragCoord = 15,
    PointCoord = 16,
    FrontFacing = 17,
    SampleId = 18,
    SamplePosition = 19,
    SampleMask = 20,
    FragDepth = 22,
    HelperInvocation = 23,
    NumWorkgroups = 24,
    WorkgroupSize = 25,
    WorkgroupId = 26,
    LocalInvocationId = 27,
    GlobalInvocationId = 28,
    LocalInvocationIndex = 29,
    WorkDim = 30,
    GlobalSize = 31,
    EnqueuedWorkgroupSize = 32,
    GlobalOffset = 33,
    GlobalLinearId = 34,
    SubgroupSize = 36,
    SubgroupMaxSize = 37,
    NumSubgroups = 38,
    NumEnqueuedSubgroups = 39,
    SubgroupId = 40,
    SubgroupLocalInvocationId = 41,
    VertexIndex = 42,
    InstanceIndex = 43,
    SubgroupEqMask = 4416,
    SubgroupEqMaskKHR = 4416,
    SubgroupGeMask = 4417,
    SubgroupGeMaskKHR = 4417,
    SubgroupGtMask = 4418,
    SubgroupGtMaskKHR = 4418,
    SubgroupLeMask = 4419,
    SubgroupLeMaskKHR = 4419,
    SubgroupLtMask = 4420,
    SubgroupLtMaskKHR = 4420,
    BaseVertex = 4424,
    BaseInstance = 4425,
    DrawIndex = 4426,
    PrimitiveShadingRateKHR = 4432,
    DeviceIndex = 4438,
    ViewIndex = 4440,
    ShadingRateKHR = 4444,
    BaryCoordNoPerspAMD = 4992,
    BaryCoordNoPerspCentroidAMD = 4993,
    BaryCoordNoPerspSampleAMD = 4994,
    BaryCoordSmoothAMD = 4995,
    BaryCoordSmoothCentroidAMD = 4996,
    BaryCoordSmoothSampleAMD = 4997,
    BaryCoordPullModelAMD = 4998,
    FragStencilRefEXT = 5014,
    ViewportMaskNV = 5253,
    SecondaryPositionNV = 5257,
    SecondaryViewportMaskNV = 5258,
    PositionPerViewNV = 5261,
    ViewportMaskPerViewNV = 5262,
    FullyCoveredEXT = 5264,
    TaskCountNV = 5274,
    PrimitiveCountNV = 5275,
    PrimitiveIndicesNV = 5276,
    ClipDistancePerViewNV = 5277,
    CullDistancePerViewNV = 5278,
    LayerPerViewNV = 5279,
    MeshViewCountNV = 5280,
    MeshViewIndicesNV = 5281,
    BaryCoordNV = 5286,
    BaryCoordNoPerspNV = 5287,
    FragSizeEXT = 5292,
    FragmentSizeNV = 5292,
    FragInvocationCountEXT = 5293,
    InvocationsPerPixelNV = 5293,
    LaunchIdKHR = 5319,
    LaunchIdNV = 5319,
    LaunchSizeKHR = 5320,
    LaunchSizeNV = 5320,
    WorldRayOriginKHR = 5321,
    WorldRayOriginNV = 5321,
    WorldRayDirectionKHR = 5322,
    WorldRayDirectionNV = 5322,
    ObjectRayOriginKHR = 5323,
    ObjectRayOriginNV = 5323,
    ObjectRayDirectionKHR = 5324,
    ObjectRayDirectionNV = 5324,
    RayTminKHR = 5325,
    RayTminNV = 5325,
    RayTmaxKHR = 5326,
    RayTmaxNV = 5326,
    InstanceCustomIndexKHR = 5327,
    InstanceCustomIndexNV = 5327,
    ObjectToWorldKHR = 5330,
    ObjectToWorldNV = 5330,
    WorldToObjectKHR = 5331,
    WorldToObjectNV = 5331,
    HitTNV = 5332,
    HitKindKHR = 5333,
    HitKindNV = 5333,
    IncomingRayFlagsKHR = 5351,
    IncomingRayFlagsNV = 5351,
    RayGeometryIndexKHR = 5352,
    WarpsPerSMNV = 5374,
    SMCountNV = 5375,
    WarpIDNV = 5376,
    SMIDNV = 5377,
    Max = 0x7fffffff,
};

enum class SelectionControlShift : unsigned {
    Flatten = 0,
    DontFlatten = 1,
    Max = 0x7fffffff,
};

enum class SelectionControlMask : unsigned {
    MaskNone = 0,
    Flatten = 0x00000001,
    DontFlatten = 0x00000002,
};

enum class LoopControlShift : unsigned {
    Unroll = 0,
    DontUnroll = 1,
    DependencyInfinite = 2,
    DependencyLength = 3,
    MinIterations = 4,
    MaxIterations = 5,
    IterationMultiple = 6,
    PeelCount = 7,
    PartialCount = 8,
    InitiationIntervalINTEL = 16,
    MaxConcurrencyINTEL = 17,
    DependencyArrayINTEL = 18,
    PipelineEnableINTEL = 19,
    LoopCoalesceINTEL = 20,
    MaxInterleavingINTEL = 21,
    SpeculatedIterationsINTEL = 22,
    Max = 0x7fffffff,
};

enum class LoopControlMask : unsigned {
    MaskNone = 0,
    Unroll = 0x00000001,
    DontUnroll = 0x00000002,
    DependencyInfinite = 0x00000004,
    DependencyLength = 0x00000008,
    MinIterations = 0x00000010,
    MaxIterations = 0x00000020,
    IterationMultiple = 0x00000040,
    PeelCount = 0x00000080,
    PartialCount = 0x00000100,
    InitiationIntervalINTEL = 0x00010000,
    MaxConcurrencyINTEL = 0x00020000,
    DependencyArrayINTEL = 0x00040000,
    PipelineEnableINTEL = 0x00080000,
    LoopCoalesceINTEL = 0x00100000,
    MaxInterleavingINTEL = 0x00200000,
    SpeculatedIterationsINTEL = 0x00400000,
};

enum class FunctionControlShift : unsigned {
    Inline = 0,
    DontInline = 1,
    Pure = 2,
    Const = 3,
    Max = 0x7fffffff,
};

enum class FunctionControlMask : unsigned {
    MaskNone = 0,
    Inline = 0x00000001,
    DontInline = 0x00000002,
    Pure = 0x00000004,
    Const = 0x00000008,
};

enum class MemorySemanticsShift : unsigned {
    Acquire = 1,
    Release = 2,
    AcquireRelease = 3,
    SequentiallyConsistent = 4,
    UniformMemory = 6,
    SubgroupMemory = 7,
    WorkgroupMemory = 8,
    CrossWorkgroupMemory = 9,
    AtomicCounterMemory = 10,
    ImageMemory = 11,
    OutputMemory = 12,
    OutputMemoryKHR = 12,
    MakeAvailable = 13,
    MakeAvailableKHR = 13,
    MakeVisible = 14,
    MakeVisibleKHR = 14,
    Volatile = 15,
    Max = 0x7fffffff,
};

enum class MemorySemanticsMask : unsigned {
    MaskNone = 0,
    Acquire = 0x00000002,
    Release = 0x00000004,
    AcquireRelease = 0x00000008,
    SequentiallyConsistent = 0x00000010,
    UniformMemory = 0x00000040,
    SubgroupMemory = 0x00000080,
    WorkgroupMemory = 0x00000100,
    CrossWorkgroupMemory = 0x00000200,
    AtomicCounterMemory = 0x00000400,
    ImageMemory = 0x00000800,
    OutputMemory = 0x00001000,
    OutputMemoryKHR = 0x00001000,
    MakeAvailable = 0x00002000,
    MakeAvailableKHR = 0x00002000,
    MakeVisible = 0x00004000,
    MakeVisibleKHR = 0x00004000,
    Volatile = 0x00008000,
};

enum class MemoryAccessShift : unsigned {
    Volatile = 0,
    Aligned = 1,
    Nontemporal = 2,
    MakePointerAvailable = 3,
    MakePointerAvailableKHR = 3,
    MakePointerVisible = 4,
    MakePointerVisibleKHR = 4,
    NonPrivatePointer = 5,
    NonPrivatePointerKHR = 5,
    Max = 0x7fffffff,
};

enum class MemoryAccessMask : unsigned {
    MaskNone = 0,
    Volatile = 0x00000001,
    Aligned = 0x00000002,
    Nontemporal = 0x00000004,
    MakePointerAvailable = 0x00000008,
    MakePointerAvailableKHR = 0x00000008,
    MakePointerVisible = 0x00000010,
    MakePointerVisibleKHR = 0x00000010,
    NonPrivatePointer = 0x00000020,
    NonPrivatePointerKHR = 0x00000020,
};

enum class Scope : unsigned {
    CrossDevice = 0,
    Device = 1,
    Workgroup = 2,
    Subgroup = 3,
    Invocation = 4,
    QueueFamily = 5,
    QueueFamilyKHR = 5,
    ShaderCallKHR = 6,
    Max = 0x7fffffff,
};

enum class GroupOperation : unsigned {
    Reduce = 0,
    InclusiveScan = 1,
    ExclusiveScan = 2,
    ClusteredReduce = 3,
    PartitionedReduceNV = 6,
    PartitionedInclusiveScanNV = 7,
    PartitionedExclusiveScanNV = 8,
    Max = 0x7fffffff,
};

enum class KernelEnqueueFlags : unsigned {
    NoWait = 0,
    WaitKernel = 1,
    WaitWorkGroup = 2,
    Max = 0x7fffffff,
};

enum class KernelProfilingInfoShift : unsigned {
    CmdExecTime = 0,
    Max = 0x7fffffff,
};

enum class KernelProfilingInfoMask : unsigned {
    MaskNone = 0,
    CmdExecTime = 0x00000001,
};

enum class Capability : unsigned {
    Matrix = 0,
    Shader = 1,
    Geometry = 2,
    Tessellation = 3,
    Addresses = 4,
    Linkage = 5,
    Kernel = 6,
    Vector16 = 7,
    Float16Buffer = 8,
    Float16 = 9,
    Float64 = 10,
    Int64 = 11,
    Int64Atomics = 12,
    ImageBasic = 13,
    ImageReadWrite = 14,
    ImageMipmap = 15,
    Pipes = 17,
    Groups = 18,
    DeviceEnqueue = 19,
    LiteralSampler = 20,
    AtomicStorage = 21,
    Int16 = 22,
    TessellationPointSize = 23,
    GeometryPointSize = 24,
    ImageGatherExtended = 25,
    StorageImageMultisample = 27,
    UniformBufferArrayDynamicIndexing = 28,
    SampledImageArrayDynamicIndexing = 29,
    StorageBufferArrayDynamicIndexing = 30,
    StorageImageArrayDynamicIndexing = 31,
    ClipDistance = 32,
    CullDistance = 33,
    ImageCubeArray = 34,
    SampleRateShading = 35,
    ImageRect = 36,
    SampledRect = 37,
    GenericPointer = 38,
    Int8 = 39,
    InputAttachment = 40,
    SparseResidency = 41,
    MinLod = 42,
    Sampled1D = 43,
    Image1D = 44,
    SampledCubeArray = 45,
    SampledBuffer = 46,
    ImageBuffer = 47,
    ImageMSArray = 48,
    StorageImageExtendedFormats = 49,
    ImageQuery = 50,
    DerivativeControl = 51,
    InterpolationFunction = 52,
    TransformFeedback = 53,
    GeometryStreams = 54,
    StorageImageReadWithoutFormat = 55,
    StorageImageWriteWithoutFormat = 56,
    MultiViewport = 57,
    SubgroupDispatch = 58,
    NamedBarrier = 59,
    PipeStorage = 60,
    GroupNonUniform = 61,
    GroupNonUniformVote = 62,
    GroupNonUniformArithmetic = 63,
    GroupNonUniformBallot = 64,
    GroupNonUniformShuffle = 65,
    GroupNonUniformShuffleRelative = 66,
    GroupNonUniformClustered = 67,
    GroupNonUniformQuad = 68,
    ShaderLayer = 69,
    ShaderViewportIndex = 70,
    FragmentShadingRateKHR = 4422,
    SubgroupBallotKHR = 4423,
    DrawParameters = 4427,
    SubgroupVoteKHR = 4431,
    StorageBuffer16BitAccess = 4433,
    StorageUniformBufferBlock16 = 4433,
    StorageUniform16 = 4434,
    UniformAndStorageBuffer16BitAccess = 4434,
    StoragePushConstant16 = 4435,
    StorageInputOutput16 = 4436,
    DeviceGroup = 4437,
    MultiView = 4439,
    VariablePointersStorageBuffer = 4441,
    VariablePointers = 4442,
    AtomicStorageOps = 4445,
    SampleMaskPostDepthCoverage = 4447,
    StorageBuffer8BitAccess = 4448,
    UniformAndStorageBuffer8BitAccess = 4449,
    StoragePushConstant8 = 4450,
    DenormPreserve = 4464,
    DenormFlushToZero = 4465,
    SignedZeroInfNanPreserve = 4466,
    RoundingModeRTE = 4467,
    RoundingModeRTZ = 4468,
    RayQueryProvisionalKHR = 4471,
    RayQueryKHR = 4472,
    RayTraversalPrimitiveCullingKHR = 4478,
    RayTracingKHR = 4479,
    Float16ImageAMD = 5008,
    ImageGatherBiasLodAMD = 5009,
    FragmentMaskAMD = 5010,
    StencilExportEXT = 5013,
    ImageReadWriteLodAMD = 5015,
    Int64ImageEXT = 5016,
    ShaderClockKHR = 5055,
    SampleMaskOverrideCoverageNV = 5249,
    GeometryShaderPassthroughNV = 5251,
    ShaderViewportIndexLayerEXT = 5254,
    ShaderViewportIndexLayerNV = 5254,
    ShaderViewportMaskNV = 5255,
    ShaderStereoViewNV = 5259,
    PerViewAttributesNV = 5260,
    FragmentFullyCoveredEXT = 5265,
    MeshShadingNV = 5266,
    ImageFootprintNV = 5282,
    FragmentBarycentricNV = 5284,
    ComputeDerivativeGroupQuadsNV = 5288,
    FragmentDensityEXT = 5291,
    ShadingRateNV = 5291,
    GroupNonUniformPartitionedNV = 5297,
    ShaderNonUniform = 5301,
    ShaderNonUniformEXT = 5301,
    RuntimeDescriptorArray = 5302,
    RuntimeDescriptorArrayEXT = 5302,
    InputAttachmentArrayDynamicIndexing = 5303,
    InputAttachmentArrayDynamicIndexingEXT = 5303,
    UniformTexelBufferArrayDynamicIndexing = 5304,
    UniformTexelBufferArrayDynamicIndexingEXT = 5304,
    StorageTexelBufferArrayDynamicIndexing = 5305,
    StorageTexelBufferArrayDynamicIndexingEXT = 5305,
    UniformBufferArrayNonUniformIndexing = 5306,
    UniformBufferArrayNonUniformIndexingEXT = 5306,
    SampledImageArrayNonUniformIndexing = 5307,
    SampledImageArrayNonUniformIndexingEXT = 5307,
    StorageBufferArrayNonUniformIndexing = 5308,
    StorageBufferArrayNonUniformIndexingEXT = 5308,
    StorageImageArrayNonUniformIndexing = 5309,
    StorageImageArrayNonUniformIndexingEXT = 5309,
    InputAttachmentArrayNonUniformIndexing = 5310,
    InputAttachmentArrayNonUniformIndexingEXT = 5310,
    UniformTexelBufferArrayNonUniformIndexing = 5311,
    UniformTexelBufferArrayNonUniformIndexingEXT = 5311,
    StorageTexelBufferArrayNonUniformIndexing = 5312,
    StorageTexelBufferArrayNonUniformIndexingEXT = 5312,
    RayTracingNV = 5340,
    VulkanMemoryModel = 5345,
    VulkanMemoryModelKHR = 5345,
    VulkanMemoryModelDeviceScope = 5346,
    VulkanMemoryModelDeviceScopeKHR = 5346,
    PhysicalStorageBufferAddresses = 5347,
    PhysicalStorageBufferAddressesEXT = 5347,
    ComputeDerivativeGroupLinearNV = 5350,
    RayTracingProvisionalKHR = 5353,
    CooperativeMatrixNV = 5357,
    FragmentShaderSampleInterlockEXT = 5363,
    FragmentShaderShadingRateInterlockEXT = 5372,
    ShaderSMBuiltinsNV = 5373,
    FragmentShaderPixelInterlockEXT = 5378,
    DemoteToHelperInvocationEXT = 5379,
    SubgroupShuffleINTEL = 5568,
    SubgroupBufferBlockIOINTEL = 5569,
    SubgroupImageBlockIOINTEL = 5570,
    SubgroupImageMediaBlockIOINTEL = 5579,
    IntegerFunctions2INTEL = 5584,
    FunctionPointersINTEL = 5603,
    IndirectReferencesINTEL = 5604,
    SubgroupAvcMotionEstimationINTEL = 5696,
    SubgroupAvcMotionEstimationIntraINTEL = 5697,
    SubgroupAvcMotionEstimationChromaINTEL = 5698,
    FPGAMemoryAttributesINTEL = 5824,
    UnstructuredLoopControlsINTEL = 5886,
    FPGALoopControlsINTEL = 5888,
    KernelAttributesINTEL = 5892,
    FPGAKernelAttributesINTEL = 5897,
    BlockingPipesINTEL = 5945,
    FPGARegINTEL = 5948,
    AtomicFloat32AddEXT = 6033,
    AtomicFloat64AddEXT = 6034,
    Max = 0x7fffffff,
};

enum class RayFlagsShift : unsigned {
    OpaqueKHR = 0,
    NoOpaqueKHR = 1,
    TerminateOnFirstHitKHR = 2,
    SkipClosestHitShaderKHR = 3,
    CullBackFacingTrianglesKHR = 4,
    CullFrontFacingTrianglesKHR = 5,
    CullOpaqueKHR = 6,
    CullNoOpaqueKHR = 7,
    SkipTrianglesKHR = 8,
    SkipAABBsKHR = 9,
    Max = 0x7fffffff,
};

enum class RayFlagsMask : unsigned {
    MaskNone = 0,
    OpaqueKHR = 0x00000001,
    NoOpaqueKHR = 0x00000002,
    TerminateOnFirstHitKHR = 0x00000004,
    SkipClosestHitShaderKHR = 0x00000008,
    CullBackFacingTrianglesKHR = 0x00000010,
    CullFrontFacingTrianglesKHR = 0x00000020,
    CullOpaqueKHR = 0x00000040,
    CullNoOpaqueKHR = 0x00000080,
    SkipTrianglesKHR = 0x00000100,
    SkipAABBsKHR = 0x00000200,
};

enum class RayQueryIntersection : unsigned {
    RayQueryCandidateIntersectionKHR = 0,
    RayQueryCommittedIntersectionKHR = 1,
    Max = 0x7fffffff,
};

enum class RayQueryCommittedIntersectionType : unsigned {
    RayQueryCommittedIntersectionNoneKHR = 0,
    RayQueryCommittedIntersectionTriangleKHR = 1,
    RayQueryCommittedIntersectionGeneratedKHR = 2,
    Max = 0x7fffffff,
};

enum class RayQueryCandidateIntersectionType : unsigned {
    RayQueryCandidateIntersectionTriangleKHR = 0,
    RayQueryCandidateIntersectionAABBKHR = 1,
    Max = 0x7fffffff,
};

enum class FragmentShadingRateShift : unsigned {
    Vertical2Pixels = 0,
    Vertical4Pixels = 1,
    Horizontal2Pixels = 2,
    Horizontal4Pixels = 3,
    Max = 0x7fffffff,
};

enum class FragmentShadingRateMask : unsigned {
    MaskNone = 0,
    Vertical2Pixels = 0x00000001,
    Vertical4Pixels = 0x00000002,
    Horizontal2Pixels = 0x00000004,
    Horizontal4Pixels = 0x00000008,
};

enum class Op : unsigned {
    OpNop = 0,
    OpUndef = 1,
    OpSourceContinued = 2,
    OpSource = 3,
    OpSourceExtension = 4,
    OpName = 5,
    OpMemberName = 6,
    OpString = 7,
    OpLine = 8,
    OpExtension = 10,
    OpExtInstImport = 11,
    OpExtInst = 12,
    OpMemoryModel = 14,
    OpEntryPoint = 15,
    OpExecutionMode = 16,
    OpCapability = 17,
    OpTypeVoid = 19,
    OpTypeBool = 20,
    OpTypeInt = 21,
    OpTypeFloat = 22,
    OpTypeVector = 23,
    OpTypeMatrix = 24,
    OpTypeImage = 25,
    OpTypeSampler = 26,
    OpTypeSampledImage = 27,
    OpTypeArray = 28,
    OpTypeRuntimeArray = 29,
    OpTypeStruct = 30,
    OpTypeOpaque = 31,
    OpTypePointer = 32,
    OpTypeFunction = 33,
    OpTypeEvent = 34,
    OpTypeDeviceEvent = 35,
    OpTypeReserveId = 36,
    OpTypeQueue = 37,
    OpTypePipe = 38,
    OpTypeForwardPointer = 39,
    OpConstantTrue = 41,
    OpConstantFalse = 42,
    OpConstant = 43,
    OpConstantComposite = 44,
    OpConstantSampler = 45,
    OpConstantNull = 46,
    OpSpecConstantTrue = 48,
    OpSpecConstantFalse = 49,
    OpSpecConstant = 50,
    OpSpecConstantComposite = 51,
    OpSpecConstantOp = 52,
    OpFunction = 54,
    OpFunctionParameter = 55,
    OpFunctionEnd = 56,
    OpFunctionCall = 57,
    OpVariable = 59,
    OpImageTexelPointer = 60,
    OpLoad = 61,
    OpStore = 62,
    OpCopyMemory = 63,
    OpCopyMemorySized = 64,
    OpAccessChain = 65,
    OpInBoundsAccessChain = 66,
    OpPtrAccessChain = 67,
    OpArrayLength = 68,
    OpGenericPtrMemSemantics = 69,
    OpInBoundsPtrAccessChain = 70,
    OpDecorate = 71,
    OpMemberDecorate = 72,
    OpDecorationGroup = 73,
    OpGroupDecorate = 74,
    OpGroupMemberDecorate = 75,
    OpVectorExtractDynamic = 77,
    OpVectorInsertDynamic = 78,
    OpVectorShuffle = 79,
    OpCompositeConstruct = 80,
    OpCompositeExtract = 81,
    OpCompositeInsert = 82,
    OpCopyObject = 83,
    OpTranspose = 84,
    OpSampledImage = 86,
    OpImageSampleImplicitLod = 87,
    OpImageSampleExplicitLod = 88,
    OpImageSampleDrefImplicitLod = 89,
    OpImageSampleDrefExplicitLod = 90,
    OpImageSampleProjImplicitLod = 91,
    OpImageSampleProjExplicitLod = 92,
    OpImageSampleProjDrefImplicitLod = 93,
    OpImageSampleProjDrefExplicitLod = 94,
    OpImageFetch = 95,
    OpImageGather = 96,
    OpImageDrefGather = 97,
    OpImageRead = 98,
    OpImageWrite = 99,
    OpImage = 100,
    OpImageQueryFormat = 101,
    OpImageQueryOrder = 102,
    OpImageQuerySizeLod = 103,
    OpImageQuerySize = 104,
    OpImageQueryLod = 105,
    OpImageQueryLevels = 106,
    OpImageQuerySamples = 107,
    OpConvertFToU = 109,
    OpConvertFToS = 110,
    OpConvertSToF = 111,
    OpConvertUToF = 112,
    OpUConvert = 113,
    OpSConvert = 114,
    OpFConvert = 115,
    OpQuantizeToF16 = 116,
    OpConvertPtrToU = 117,
    OpSatConvertSToU = 118,
    OpSatConvertUToS = 119,
    OpConvertUToPtr = 120,
    OpPtrCastToGeneric = 121,
    OpGenericCastToPtr = 122,
    OpGenericCastToPtrExplicit = 123,
    OpBitcast = 124,
    OpSNegate = 126,
    OpFNegate = 127,
    OpIAdd = 128,
    OpFAdd = 129,
    OpISub = 130,
    OpFSub = 131,
    OpIMul = 132,
    OpFMul = 133,
    OpUDiv = 134,
    OpSDiv = 135,
    OpFDiv = 136,
    OpUMod = 137,
    OpSRem = 138,
    OpSMod = 139,
    OpFRem = 140,
    OpFMod = 141,
    OpVectorTimesScalar = 142,
    OpMatrixTimesScalar = 143,
    OpVectorTimesMatrix = 144,
    OpMatrixTimesVector = 145,
    OpMatrixTimesMatrix = 146,
    OpOuterProduct = 147,
    OpDot = 148,
    OpIAddCarry = 149,
    OpISubBorrow = 150,
    OpUMulExtended = 151,
    OpSMulExtended = 152,
    OpAny = 154,
    OpAll = 155,
    OpIsNan = 156,
    OpIsInf = 157,
    OpIsFinite = 158,
    OpIsNormal = 159,
    OpSignBitSet = 160,
    OpLessOrGreater = 161,
    OpOrdered = 162,
    OpUnordered = 163,
    OpLogicalEqual = 164,
    OpLogicalNotEqual = 165,
    OpLogicalOr = 166,
    OpLogicalAnd = 167,
    OpLogicalNot = 168,
    OpSelect = 169,
    OpIEqual = 170,
    OpINotEqual = 171,
    OpUGreaterThan = 172,
    OpSGreaterThan = 173,
    OpUGreaterThanEqual = 174,
    OpSGreaterThanEqual = 175,
    OpULessThan = 176,
    OpSLessThan = 177,
    OpULessThanEqual = 178,
    OpSLessThanEqual = 179,
    OpFOrdEqual = 180,
    OpFUnordEqual = 181,
    OpFOrdNotEqual = 182,
    OpFUnordNotEqual = 183,
    OpFOrdLessThan = 184,
    OpFUnordLessThan = 185,
    OpFOrdGreaterThan = 186,
    OpFUnordGreaterThan = 187,
    OpFOrdLessThanEqual = 188,
    OpFUnordLessThanEqual = 189,
    OpFOrdGreaterThanEqual = 190,
    OpFUnordGreaterThanEqual = 191,
    OpShiftRightLogical = 194,
    OpShiftRightArithmetic = 195,
    OpShiftLeftLogical = 196,
    OpBitwiseOr = 197,
    OpBitwiseXor = 198,
    OpBitwiseAnd = 199,
    OpNot = 200,
    OpBitFieldInsert = 201,
    OpBitFieldSExtract = 202,
    OpBitFieldUExtract = 203,
    OpBitReverse = 204,
    OpBitCount = 205,
    OpDPdx = 207,
    OpDPdy = 208,
    OpFwidth = 209,
    OpDPdxFine = 210,
    OpDPdyFine = 211,
    OpFwidthFine = 212,
    OpDPdxCoarse = 213,
    OpDPdyCoarse = 214,
    OpFwidthCoarse = 215,
    OpEmitVertex = 218,
    OpEndPrimitive = 219,
    OpEmitStreamVertex = 220,
    OpEndStreamPrimitive = 221,
    OpControlBarrier = 224,
    OpMemoryBarrier = 225,
    OpAtomicLoad = 227,
    OpAtomicStore = 228,
    OpAtomicExchange = 229,
    OpAtomicCompareExchange = 230,
    OpAtomicCompareExchangeWeak = 231,
    OpAtomicIIncrement = 232,
    OpAtomicIDecrement = 233,
    OpAtomicIAdd = 234,
    OpAtomicISub = 235,
    OpAtomicSMin = 236,
    OpAtomicUMin = 237,
    OpAtomicSMax = 238,
    OpAtomicUMax = 239,
    OpAtomicAnd = 240,
    OpAtomicOr = 241,
    OpAtomicXor = 242,
    OpPhi = 245,
    OpLoopMerge = 246,
    OpSelectionMerge = 247,
    OpLabel = 248,
    OpBranch = 249,
    OpBranchConditional = 250,
    OpSwitch = 251,
    OpKill = 252,
    OpReturn = 253,
    OpReturnValue = 254,
    OpUnreachable = 255,
    OpLifetimeStart = 256,
    OpLifetimeStop = 257,
    OpGroupAsyncCopy = 259,
    OpGroupWaitEvents = 260,
    OpGroupAll = 261,
    OpGroupAny = 262,
    OpGroupBroadcast = 263,
    OpGroupIAdd = 264,
    OpGroupFAdd = 265,
    OpGroupFMin = 266,
    OpGroupUMin = 267,
    OpGroupSMin = 268,
    OpGroupFMax = 269,
    OpGroupUMax = 270,
    OpGroupSMax = 271,
    OpReadPipe = 274,
    OpWritePipe = 275,
    OpReservedReadPipe = 276,
    OpReservedWritePipe = 277,
    OpReserveReadPipePackets = 278,
    OpReserveWritePipePackets = 279,
    OpCommitReadPipe = 280,
    OpCommitWritePipe = 281,
    OpIsValidReserveId = 282,
    OpGetNumPipePackets = 283,
    OpGetMaxPipePackets = 284,
    OpGroupReserveReadPipePackets = 285,
    OpGroupReserveWritePipePackets = 286,
    OpGroupCommitReadPipe = 287,
    OpGroupCommitWritePipe = 288,
    OpEnqueueMarker = 291,
    OpEnqueueKernel = 292,
    OpGetKernelNDrangeSubGroupCount = 293,
    OpGetKernelNDrangeMaxSubGroupSize = 294,
    OpGetKernelWorkGroupSize = 295,
    OpGetKernelPreferredWorkGroupSizeMultiple = 296,
    OpRetainEvent = 297,
    OpReleaseEvent = 298,
    OpCreateUserEvent = 299,
    OpIsValidEvent = 300,
    OpSetUserEventStatus = 301,
    OpCaptureEventProfilingInfo = 302,
    OpGetDefaultQueue = 303,
    OpBuildNDRange = 304,
    OpImageSparseSampleImplicitLod = 305,
    OpImageSparseSampleExplicitLod = 306,
    OpImageSparseSampleDrefImplicitLod = 307,
    OpImageSparseSampleDrefExplicitLod = 308,
    OpImageSparseSampleProjImplicitLod = 309,
    OpImageSparseSampleProjExplicitLod = 310,
    OpImageSparseSampleProjDrefImplicitLod = 311,
    OpImageSparseSampleProjDrefExplicitLod = 312,
    OpImageSparseFetch = 313,
    OpImageSparseGather = 314,
    OpImageSparseDrefGather = 315,
    OpImageSparseTexelsResident = 316,
    OpNoLine = 317,
    OpAtomicFlagTestAndSet = 318,
    OpAtomicFlagClear = 319,
    OpImageSparseRead = 320,
    OpSizeOf = 321,
    OpTypePipeStorage = 322,
    OpConstantPipeStorage = 323,
    OpCreatePipeFromPipeStorage = 324,
    OpGetKernelLocalSizeForSubgroupCount = 325,
    OpGetKernelMaxNumSubgroups = 326,
    OpTypeNamedBarrier = 327,
    OpNamedBarrierInitialize = 328,
    OpMemoryNamedBarrier = 329,
    OpModuleProcessed = 330,
    OpExecutionModeId = 331,
    OpDecorateId = 332,
    OpGroupNonUniformElect = 333,
    OpGroupNonUniformAll = 334,
    OpGroupNonUniformAny = 335,
    OpGroupNonUniformAllEqual = 336,
    OpGroupNonUniformBroadcast = 337,
    OpGroupNonUniformBroadcastFirst = 338,
    OpGroupNonUniformBallot = 339,
    OpGroupNonUniformInverseBallot = 340,
    OpGroupNonUniformBallotBitExtract = 341,
    OpGroupNonUniformBallotBitCount = 342,
    OpGroupNonUniformBallotFindLSB = 343,
    OpGroupNonUniformBallotFindMSB = 344,
    OpGroupNonUniformShuffle = 345,
    OpGroupNonUniformShuffleXor = 346,
    OpGroupNonUniformShuffleUp = 347,
    OpGroupNonUniformShuffleDown = 348,
    OpGroupNonUniformIAdd = 349,
    OpGroupNonUniformFAdd = 350,
    OpGroupNonUniformIMul = 351,
    OpGroupNonUniformFMul = 352,
    OpGroupNonUniformSMin = 353,
    OpGroupNonUniformUMin = 354,
    OpGroupNonUniformFMin = 355,
    OpGroupNonUniformSMax = 356,
    OpGroupNonUniformUMax = 357,
    OpGroupNonUniformFMax = 358,
    OpGroupNonUniformBitwiseAnd = 359,
    OpGroupNonUniformBitwiseOr = 360,
    OpGroupNonUniformBitwiseXor = 361,
    OpGroupNonUniformLogicalAnd = 362,
    OpGroupNonUniformLogicalOr = 363,
    OpGroupNonUniformLogicalXor = 364,
    OpGroupNonUniformQuadBroadcast = 365,
    OpGroupNonUniformQuadSwap = 366,
    OpCopyLogical = 400,
    OpPtrEqual = 401,
    OpPtrNotEqual = 402,
    OpPtrDiff = 403,
    OpTerminateInvocation = 4416,
    OpSubgroupBallotKHR = 4421,
    OpSubgroupFirstInvocationKHR = 4422,
    OpSubgroupAllKHR = 4428,
    OpSubgroupAnyKHR = 4429,
    OpSubgroupAllEqualKHR = 4430,
    OpSubgroupReadInvocationKHR = 4432,
    OpTraceRayKHR = 4445,
    OpExecuteCallableKHR = 4446,
    OpConvertUToAccelerationStructureKHR = 4447,
    OpIgnoreIntersectionKHR = 4448,
    OpTerminateRayKHR = 4449,
    OpTypeRayQueryKHR = 4472,
    OpRayQueryInitializeKHR = 4473,
    OpRayQueryTerminateKHR = 4474,
    OpRayQueryGenerateIntersectionKHR = 4475,
    OpRayQueryConfirmIntersectionKHR = 4476,
    OpRayQueryProceedKHR = 4477,
    OpRayQueryGetIntersectionTypeKHR = 4479,
    OpGroupIAddNonUniformAMD = 5000,
    OpGroupFAddNonUniformAMD = 5001,
    OpGroupFMinNonUniformAMD = 5002,
    OpGroupUMinNonUniformAMD = 5003,
    OpGroupSMinNonUniformAMD = 5004,
    OpGroupFMaxNonUniformAMD = 5005,
    OpGroupUMaxNonUniformAMD = 5006,
    OpGroupSMaxNonUniformAMD = 5007,
    OpFragmentMaskFetchAMD = 5011,
    OpFragmentFetchAMD = 5012,
    OpReadClockKHR = 5056,
    OpImageSampleFootprintNV = 5283,
    OpGroupNonUniformPartitionNV = 5296,
    OpWritePackedPrimitiveIndices4x8NV = 5299,
    OpReportIntersectionKHR = 5334,
    OpReportIntersectionNV = 5334,
    OpIgnoreIntersectionNV = 5335,
    OpTerminateRayNV = 5336,
    OpTraceNV = 5337,
    OpTypeAccelerationStructureKHR = 5341,
    OpTypeAccelerationStructureNV = 5341,
    OpExecuteCallableNV = 5344,
    OpTypeCooperativeMatrixNV = 5358,
    OpCooperativeMatrixLoadNV = 5359,
    OpCooperativeMatrixStoreNV = 5360,
    OpCooperativeMatrixMulAddNV = 5361,
    OpCooperativeMatrixLengthNV = 5362,
    OpBeginInvocationInterlockEXT = 5364,
    OpEndInvocationInterlockEXT = 5365,
    OpDemoteToHelperInvocationEXT = 5380,
    OpIsHelperInvocationEXT = 5381,
    OpSubgroupShuffleINTEL = 5571,
    OpSubgroupShuffleDownINTEL = 5572,
    OpSubgroupShuffleUpINTEL = 5573,
    OpSubgroupShuffleXorINTEL = 5574,
    OpSubgroupBlockReadINTEL = 5575,
    OpSubgroupBlockWriteINTEL = 5576,
    OpSubgroupImageBlockReadINTEL = 5577,
    OpSubgroupImageBlockWriteINTEL = 5578,
    OpSubgroupImageMediaBlockReadINTEL = 5580,
    OpSubgroupImageMediaBlockWriteINTEL = 5581,
    OpUCountLeadingZerosINTEL = 5585,
    OpUCountTrailingZerosINTEL = 5586,
    OpAbsISubINTEL = 5587,
    OpAbsUSubINTEL = 5588,
    OpIAddSatINTEL = 5589,
    OpUAddSatINTEL = 5590,
    OpIAverageINTEL = 5591,
    OpUAverageINTEL = 5592,
    OpIAverageRoundedINTEL = 5593,
    OpUAverageRoundedINTEL = 5594,
    OpISubSatINTEL = 5595,
    OpUSubSatINTEL = 5596,
    OpIMul32x16INTEL = 5597,
    OpUMul32x16INTEL = 5598,
    OpFunctionPointerINTEL = 5600,
    OpFunctionPointerCallINTEL = 5601,
    OpDecorateString = 5632,
    OpDecorateStringGOOGLE = 5632,
    OpMemberDecorateString = 5633,
    OpMemberDecorateStringGOOGLE = 5633,
    OpVmeImageINTEL = 5699,
    OpTypeVmeImageINTEL = 5700,
    OpTypeAvcImePayloadINTEL = 5701,
    OpTypeAvcRefPayloadINTEL = 5702,
    OpTypeAvcSicPayloadINTEL = 5703,
    OpTypeAvcMcePayloadINTEL = 5704,
    OpTypeAvcMceResultINTEL = 5705,
    OpTypeAvcImeResultINTEL = 5706,
    OpTypeAvcImeResultSingleReferenceStreamoutINTEL = 5707,
    OpTypeAvcImeResultDualReferenceStreamoutINTEL = 5708,
    OpTypeAvcImeSingleReferenceStreaminINTEL = 5709,
    OpTypeAvcImeDualReferenceStreaminINTEL = 5710,
    OpTypeAvcRefResultINTEL = 5711,
    OpTypeAvcSicResultINTEL = 5712,
    OpSubgroupAvcMceGetDefaultInterBaseMultiReferencePenaltyINTEL = 5713,
    OpSubgroupAvcMceSetInterBaseMultiReferencePenaltyINTEL = 5714,
    OpSubgroupAvcMceGetDefaultInterShapePenaltyINTEL = 5715,
    OpSubgroupAvcMceSetInterShapePenaltyINTEL = 5716,
    OpSubgroupAvcMceGetDefaultInterDirectionPenaltyINTEL = 5717,
    OpSubgroupAvcMceSetInterDirectionPenaltyINTEL = 5718,
    OpSubgroupAvcMceGetDefaultIntraLumaShapePenaltyINTEL = 5719,
    OpSubgroupAvcMceGetDefaultInterMotionVectorCostTableINTEL = 5720,
    OpSubgroupAvcMceGetDefaultHighPenaltyCostTableINTEL = 5721,
    OpSubgroupAvcMceGetDefaultMediumPenaltyCostTableINTEL = 5722,
    OpSubgroupAvcMceGetDefaultLowPenaltyCostTableINTEL = 5723,
    OpSubgroupAvcMceSetMotionVectorCostFunctionINTEL = 5724,
    OpSubgroupAvcMceGetDefaultIntraLumaModePenaltyINTEL = 5725,
    OpSubgroupAvcMceGetDefaultNonDcLumaIntraPenaltyINTEL = 5726,
    OpSubgroupAvcMceGetDefaultIntraChromaModeBasePenaltyINTEL = 5727,
    OpSubgroupAvcMceSetAcOnlyHaarINTEL = 5728,
    OpSubgroupAvcMceSetSourceInterlacedFieldPolarityINTEL = 5729,
    OpSubgroupAvcMceSetSingleReferenceInterlacedFieldPolarityINTEL = 5730,
    OpSubgroupAvcMceSetDualReferenceInterlacedFieldPolaritiesINTEL = 5731,
    OpSubgroupAvcMceConvertToImePayloadINTEL = 5732,
    OpSubgroupAvcMceConvertToImeResultINTEL = 5733,
    OpSubgroupAvcMceConvertToRefPayloadINTEL = 5734,
    OpSubgroupAvcMceConvertToRefResultINTEL = 5735,
    OpSubgroupAvcMceConvertToSicPayloadINTEL = 5736,
    OpSubgroupAvcMceConvertToSicResultINTEL = 5737,
    OpSubgroupAvcMceGetMotionVectorsINTEL = 5738,
    OpSubgroupAvcMceGetInterDistortionsINTEL = 5739,
    OpSubgroupAvcMceGetBestInterDistortionsINTEL = 5740,
    OpSubgroupAvcMceGetInterMajorShapeINTEL = 5741,
    OpSubgroupAvcMceGetInterMinorShapeINTEL = 5742,
    OpSubgroupAvcMceGetInterDirectionsINTEL = 5743,
    OpSubgroupAvcMceGetInterMotionVectorCountINTEL = 5744,
    OpSubgroupAvcMceGetInterReferenceIdsINTEL = 5745,
    OpSubgroupAvcMceGetInterReferenceInterlacedFieldPolaritiesINTEL = 5746,
    OpSubgroupAvcImeInitializeINTEL = 5747,
    OpSubgroupAvcImeSetSingleReferenceINTEL = 5748,
    OpSubgroupAvcImeSetDualReferenceINTEL = 5749,
    OpSubgroupAvcImeRefWindowSizeINTEL = 5750,
    OpSubgroupAvcImeAdjustRefOffsetINTEL = 5751,
    OpSubgroupAvcImeConvertToMcePayloadINTEL = 5752,
    OpSubgroupAvcImeSetMaxMotionVectorCountINTEL = 5753,
    OpSubgroupAvcImeSetUnidirectionalMixDisableINTEL = 5754,
    OpSubgroupAvcImeSetEarlySearchTerminationThresholdINTEL = 5755,
    OpSubgroupAvcImeSetWeightedSadINTEL = 5756,
    OpSubgroupAvcImeEvaluateWithSingleReferenceINTEL = 5757,
    OpSubgroupAvcImeEvaluateWithDualReferenceINTEL = 5758,
    OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminINTEL = 5759,
    OpSubgroupAvcImeEvaluateWithDualReferenceStreaminINTEL = 5760,
    OpSubgroupAvcImeEvaluateWithSingleReferenceStreamoutINTEL = 5761,
    OpSubgroupAvcImeEvaluateWithDualReferenceStreamoutINTEL = 5762,
    OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminoutINTEL = 5763,
    OpSubgroupAvcImeEvaluateWithDualReferenceStreaminoutINTEL = 5764,
    OpSubgroupAvcImeConvertToMceResultINTEL = 5765,
    OpSubgroupAvcImeGetSingleReferenceStreaminINTEL = 5766,
    OpSubgroupAvcImeGetDualReferenceStreaminINTEL = 5767,
    OpSubgroupAvcImeStripSingleReferenceStreamoutINTEL = 5768,
    OpSubgroupAvcImeStripDualReferenceStreamoutINTEL = 5769,
    OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeMotionVectorsINTEL = 5770,
    OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeDistortionsINTEL = 5771,
    OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeReferenceIdsINTEL = 5772,
    OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeMotionVectorsINTEL = 5773,
    OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeDistortionsINTEL = 5774,
    OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeReferenceIdsINTEL = 5775,
    OpSubgroupAvcImeGetBorderReachedINTEL = 5776,
    OpSubgroupAvcImeGetTruncatedSearchIndicationINTEL = 5777,
    OpSubgroupAvcImeGetUnidirectionalEarlySearchTerminationINTEL = 5778,
    OpSubgroupAvcImeGetWeightingPatternMinimumMotionVectorINTEL = 5779,
    OpSubgroupAvcImeGetWeightingPatternMinimumDistortionINTEL = 5780,
    OpSubgroupAvcFmeInitializeINTEL = 5781,
    OpSubgroupAvcBmeInitializeINTEL = 5782,
    OpSubgroupAvcRefConvertToMcePayloadINTEL = 5783,
    OpSubgroupAvcRefSetBidirectionalMixDisableINTEL = 5784,
    OpSubgroupAvcRefSetBilinearFilterEnableINTEL = 5785,
    OpSubgroupAvcRefEvaluateWithSingleReferenceINTEL = 5786,
    OpSubgroupAvcRefEvaluateWithDualReferenceINTEL = 5787,
    OpSubgroupAvcRefEvaluateWithMultiReferenceINTEL = 5788,
    OpSubgroupAvcRefEvaluateWithMultiReferenceInterlacedINTEL = 5789,
    OpSubgroupAvcRefConvertToMceResultINTEL = 5790,
    OpSubgroupAvcSicInitializeINTEL = 5791,
    OpSubgroupAvcSicConfigureSkcINTEL = 5792,
    OpSubgroupAvcSicConfigureIpeLumaINTEL = 5793,
    OpSubgroupAvcSicConfigureIpeLumaChromaINTEL = 5794,
    OpSubgroupAvcSicGetMotionVectorMaskINTEL = 5795,
    OpSubgroupAvcSicConvertToMcePayloadINTEL = 5796,
    OpSubgroupAvcSicSetIntraLumaShapePenaltyINTEL = 5797,
    OpSubgroupAvcSicSetIntraLumaModeCostFunctionINTEL = 5798,
    OpSubgroupAvcSicSetIntraChromaModeCostFunctionINTEL = 5799,
    OpSubgroupAvcSicSetBilinearFilterEnableINTEL = 5800,
    OpSubgroupAvcSicSetSkcForwardTransformEnableINTEL = 5801,
    OpSubgroupAvcSicSetBlockBasedRawSkipSadINTEL = 5802,
    OpSubgroupAvcSicEvaluateIpeINTEL = 5803,
    OpSubgroupAvcSicEvaluateWithSingleReferenceINTEL = 5804,
    OpSubgroupAvcSicEvaluateWithDualReferenceINTEL = 5805,
    OpSubgroupAvcSicEvaluateWithMultiReferenceINTEL = 5806,
    OpSubgroupAvcSicEvaluateWithMultiReferenceInterlacedINTEL = 5807,
    OpSubgroupAvcSicConvertToMceResultINTEL = 5808,
    OpSubgroupAvcSicGetIpeLumaShapeINTEL = 5809,
    OpSubgroupAvcSicGetBestIpeLumaDistortionINTEL = 5810,
    OpSubgroupAvcSicGetBestIpeChromaDistortionINTEL = 5811,
    OpSubgroupAvcSicGetPackedIpeLumaModesINTEL = 5812,
    OpSubgroupAvcSicGetIpeChromaModeINTEL = 5813,
    OpSubgroupAvcSicGetPackedSkcLumaCountThresholdINTEL = 5814,
    OpSubgroupAvcSicGetPackedSkcLumaSumThresholdINTEL = 5815,
    OpSubgroupAvcSicGetInterRawSadsINTEL = 5816,
    OpLoopControlINTEL = 5887,
    OpReadPipeBlockingINTEL = 5946,
    OpWritePipeBlockingINTEL = 5947,
    OpFPGARegINTEL = 5949,
    OpRayQueryGetRayTMinKHR = 6016,
    OpRayQueryGetRayFlagsKHR = 6017,
    OpRayQueryGetIntersectionTKHR = 6018,
    OpRayQueryGetIntersectionInstanceCustomIndexKHR = 6019,
    OpRayQueryGetIntersectionInstanceIdKHR = 6020,
    OpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR = 6021,
    OpRayQueryGetIntersectionGeometryIndexKHR = 6022,
    OpRayQueryGetIntersectionPrimitiveIndexKHR = 6023,
    OpRayQueryGetIntersectionBarycentricsKHR = 6024,
    OpRayQueryGetIntersectionFrontFaceKHR = 6025,
    OpRayQueryGetIntersectionCandidateAABBOpaqueKHR = 6026,
    OpRayQueryGetIntersectionObjectRayDirectionKHR = 6027,
    OpRayQueryGetIntersectionObjectRayOriginKHR = 6028,
    OpRayQueryGetWorldRayDirectionKHR = 6029,
    OpRayQueryGetWorldRayOriginKHR = 6030,
    OpRayQueryGetIntersectionObjectToWorldKHR = 6031,
    OpRayQueryGetIntersectionWorldToObjectKHR = 6032,
    OpAtomicFAddEXT = 6035,
    Max = 0x7fffffff,
};

#ifdef SPV_ENABLE_UTILITY_CODE
inline void HasResultAndType(Op opcode, bool *hasResult, bool *hasResultType) {
    *hasResult = *hasResultType = false;
    switch (opcode) {
    default: /* unknown opcode */ break;
    case Op::OpNop: *hasResult = false; *hasResultType = false; break;
    case Op::OpUndef: *hasResult = true; *hasResultType = true; break;
    case Op::OpSourceContinued: *hasResult = false; *hasResultType = false; break;
    case Op::OpSource: *hasResult = false; *hasResultType = false; break;
    case Op::OpSourceExtension: *hasResult = false; *hasResultType = false; break;
    case Op::OpName: *hasResult = false; *hasResultType = false; break;
    case Op::OpMemberName: *hasResult = false; *hasResultType = false; break;
    case Op::OpString: *hasResult = true; *hasResultType = false; break;
    case Op::OpLine: *hasResult = false; *hasResultType = false; break;
    case Op::OpExtension: *hasResult = false; *hasResultType = false; break;
    case Op::OpExtInstImport: *hasResult = true; *hasResultType = false; break;
    case Op::OpExtInst: *hasResult = true; *hasResultType = true; break;
    case Op::OpMemoryModel: *hasResult = false; *hasResultType = false; break;
    case Op::OpEntryPoint: *hasResult = false; *hasResultType = false; break;
    case Op::OpExecutionMode: *hasResult = false; *hasResultType = false; break;
    case Op::OpCapability: *hasResult = false; *hasResultType = false; break;
    case Op::OpTypeVoid: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeBool: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeInt: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeFloat: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeVector: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeMatrix: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeImage: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeSampler: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeSampledImage: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeArray: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeRuntimeArray: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeStruct: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeOpaque: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypePointer: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeFunction: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeEvent: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeDeviceEvent: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeReserveId: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeQueue: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypePipe: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeForwardPointer: *hasResult = false; *hasResultType = false; break;
    case Op::OpConstantTrue: *hasResult = true; *hasResultType = true; break;
    case Op::OpConstantFalse: *hasResult = true; *hasResultType = true; break;
    case Op::OpConstant: *hasResult = true; *hasResultType = true; break;
    case Op::OpConstantComposite: *hasResult = true; *hasResultType = true; break;
    case Op::OpConstantSampler: *hasResult = true; *hasResultType = true; break;
    case Op::OpConstantNull: *hasResult = true; *hasResultType = true; break;
    case Op::OpSpecConstantTrue: *hasResult = true; *hasResultType = true; break;
    case Op::OpSpecConstantFalse: *hasResult = true; *hasResultType = true; break;
    case Op::OpSpecConstant: *hasResult = true; *hasResultType = true; break;
    case Op::OpSpecConstantComposite: *hasResult = true; *hasResultType = true; break;
    case Op::OpSpecConstantOp: *hasResult = true; *hasResultType = true; break;
    case Op::OpFunction: *hasResult = true; *hasResultType = true; break;
    case Op::OpFunctionParameter: *hasResult = true; *hasResultType = true; break;
    case Op::OpFunctionEnd: *hasResult = false; *hasResultType = false; break;
    case Op::OpFunctionCall: *hasResult = true; *hasResultType = true; break;
    case Op::OpVariable: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageTexelPointer: *hasResult = true; *hasResultType = true; break;
    case Op::OpLoad: *hasResult = true; *hasResultType = true; break;
    case Op::OpStore: *hasResult = false; *hasResultType = false; break;
    case Op::OpCopyMemory: *hasResult = false; *hasResultType = false; break;
    case Op::OpCopyMemorySized: *hasResult = false; *hasResultType = false; break;
    case Op::OpAccessChain: *hasResult = true; *hasResultType = true; break;
    case Op::OpInBoundsAccessChain: *hasResult = true; *hasResultType = true; break;
    case Op::OpPtrAccessChain: *hasResult = true; *hasResultType = true; break;
    case Op::OpArrayLength: *hasResult = true; *hasResultType = true; break;
    case Op::OpGenericPtrMemSemantics: *hasResult = true; *hasResultType = true; break;
    case Op::OpInBoundsPtrAccessChain: *hasResult = true; *hasResultType = true; break;
    case Op::OpDecorate: *hasResult = false; *hasResultType = false; break;
    case Op::OpMemberDecorate: *hasResult = false; *hasResultType = false; break;
    case Op::OpDecorationGroup: *hasResult = true; *hasResultType = false; break;
    case Op::OpGroupDecorate: *hasResult = false; *hasResultType = false; break;
    case Op::OpGroupMemberDecorate: *hasResult = false; *hasResultType = false; break;
    case Op::OpVectorExtractDynamic: *hasResult = true; *hasResultType = true; break;
    case Op::OpVectorInsertDynamic: *hasResult = true; *hasResultType = true; break;
    case Op::OpVectorShuffle: *hasResult = true; *hasResultType = true; break;
    case Op::OpCompositeConstruct: *hasResult = true; *hasResultType = true; break;
    case Op::OpCompositeExtract: *hasResult = true; *hasResultType = true; break;
    case Op::OpCompositeInsert: *hasResult = true; *hasResultType = true; break;
    case Op::OpCopyObject: *hasResult = true; *hasResultType = true; break;
    case Op::OpTranspose: *hasResult = true; *hasResultType = true; break;
    case Op::OpSampledImage: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageSampleImplicitLod: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageSampleExplicitLod: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageSampleDrefImplicitLod: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageSampleDrefExplicitLod: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageSampleProjImplicitLod: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageSampleProjExplicitLod: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageSampleProjDrefImplicitLod: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageSampleProjDrefExplicitLod: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageFetch: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageGather: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageDrefGather: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageRead: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageWrite: *hasResult = false; *hasResultType = false; break;
    case Op::OpImage: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageQueryFormat: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageQueryOrder: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageQuerySizeLod: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageQuerySize: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageQueryLod: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageQueryLevels: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageQuerySamples: *hasResult = true; *hasResultType = true; break;
    case Op::OpConvertFToU: *hasResult = true; *hasResultType = true; break;
    case Op::OpConvertFToS: *hasResult = true; *hasResultType = true; break;
    case Op::OpConvertSToF: *hasResult = true; *hasResultType = true; break;
    case Op::OpConvertUToF: *hasResult = true; *hasResultType = true; break;
    case Op::OpUConvert: *hasResult = true; *hasResultType = true; break;
    case Op::OpSConvert: *hasResult = true; *hasResultType = true; break;
    case Op::OpFConvert: *hasResult = true; *hasResultType = true; break;
    case Op::OpQuantizeToF16: *hasResult = true; *hasResultType = true; break;
    case Op::OpConvertPtrToU: *hasResult = true; *hasResultType = true; break;
    case Op::OpSatConvertSToU: *hasResult = true; *hasResultType = true; break;
    case Op::OpSatConvertUToS: *hasResult = true; *hasResultType = true; break;
    case Op::OpConvertUToPtr: *hasResult = true; *hasResultType = true; break;
    case Op::OpPtrCastToGeneric: *hasResult = true; *hasResultType = true; break;
    case Op::OpGenericCastToPtr: *hasResult = true; *hasResultType = true; break;
    case Op::OpGenericCastToPtrExplicit: *hasResult = true; *hasResultType = true; break;
    case Op::OpBitcast: *hasResult = true; *hasResultType = true; break;
    case Op::OpSNegate: *hasResult = true; *hasResultType = true; break;
    case Op::OpFNegate: *hasResult = true; *hasResultType = true; break;
    case Op::OpIAdd: *hasResult = true; *hasResultType = true; break;
    case Op::OpFAdd: *hasResult = true; *hasResultType = true; break;
    case Op::OpISub: *hasResult = true; *hasResultType = true; break;
    case Op::OpFSub: *hasResult = true; *hasResultType = true; break;
    case Op::OpIMul: *hasResult = true; *hasResultType = true; break;
    case Op::OpFMul: *hasResult = true; *hasResultType = true; break;
    case Op::OpUDiv: *hasResult = true; *hasResultType = true; break;
    case Op::OpSDiv: *hasResult = true; *hasResultType = true; break;
    case Op::OpFDiv: *hasResult = true; *hasResultType = true; break;
    case Op::OpUMod: *hasResult = true; *hasResultType = true; break;
    case Op::OpSRem: *hasResult = true; *hasResultType = true; break;
    case Op::OpSMod: *hasResult = true; *hasResultType = true; break;
    case Op::OpFRem: *hasResult = true; *hasResultType = true; break;
    case Op::OpFMod: *hasResult = true; *hasResultType = true; break;
    case Op::OpVectorTimesScalar: *hasResult = true; *hasResultType = true; break;
    case Op::OpMatrixTimesScalar: *hasResult = true; *hasResultType = true; break;
    case Op::OpVectorTimesMatrix: *hasResult = true; *hasResultType = true; break;
    case Op::OpMatrixTimesVector: *hasResult = true; *hasResultType = true; break;
    case Op::OpMatrixTimesMatrix: *hasResult = true; *hasResultType = true; break;
    case Op::OpOuterProduct: *hasResult = true; *hasResultType = true; break;
    case Op::OpDot: *hasResult = true; *hasResultType = true; break;
    case Op::OpIAddCarry: *hasResult = true; *hasResultType = true; break;
    case Op::OpISubBorrow: *hasResult = true; *hasResultType = true; break;
    case Op::OpUMulExtended: *hasResult = true; *hasResultType = true; break;
    case Op::OpSMulExtended: *hasResult = true; *hasResultType = true; break;
    case Op::OpAny: *hasResult = true; *hasResultType = true; break;
    case Op::OpAll: *hasResult = true; *hasResultType = true; break;
    case Op::OpIsNan: *hasResult = true; *hasResultType = true; break;
    case Op::OpIsInf: *hasResult = true; *hasResultType = true; break;
    case Op::OpIsFinite: *hasResult = true; *hasResultType = true; break;
    case Op::OpIsNormal: *hasResult = true; *hasResultType = true; break;
    case Op::OpSignBitSet: *hasResult = true; *hasResultType = true; break;
    case Op::OpLessOrGreater: *hasResult = true; *hasResultType = true; break;
    case Op::OpOrdered: *hasResult = true; *hasResultType = true; break;
    case Op::OpUnordered: *hasResult = true; *hasResultType = true; break;
    case Op::OpLogicalEqual: *hasResult = true; *hasResultType = true; break;
    case Op::OpLogicalNotEqual: *hasResult = true; *hasResultType = true; break;
    case Op::OpLogicalOr: *hasResult = true; *hasResultType = true; break;
    case Op::OpLogicalAnd: *hasResult = true; *hasResultType = true; break;
    case Op::OpLogicalNot: *hasResult = true; *hasResultType = true; break;
    case Op::OpSelect: *hasResult = true; *hasResultType = true; break;
    case Op::OpIEqual: *hasResult = true; *hasResultType = true; break;
    case Op::OpINotEqual: *hasResult = true; *hasResultType = true; break;
    case Op::OpUGreaterThan: *hasResult = true; *hasResultType = true; break;
    case Op::OpSGreaterThan: *hasResult = true; *hasResultType = true; break;
    case Op::OpUGreaterThanEqual: *hasResult = true; *hasResultType = true; break;
    case Op::OpSGreaterThanEqual: *hasResult = true; *hasResultType = true; break;
    case Op::OpULessThan: *hasResult = true; *hasResultType = true; break;
    case Op::OpSLessThan: *hasResult = true; *hasResultType = true; break;
    case Op::OpULessThanEqual: *hasResult = true; *hasResultType = true; break;
    case Op::OpSLessThanEqual: *hasResult = true; *hasResultType = true; break;
    case Op::OpFOrdEqual: *hasResult = true; *hasResultType = true; break;
    case Op::OpFUnordEqual: *hasResult = true; *hasResultType = true; break;
    case Op::OpFOrdNotEqual: *hasResult = true; *hasResultType = true; break;
    case Op::OpFUnordNotEqual: *hasResult = true; *hasResultType = true; break;
    case Op::OpFOrdLessThan: *hasResult = true; *hasResultType = true; break;
    case Op::OpFUnordLessThan: *hasResult = true; *hasResultType = true; break;
    case Op::OpFOrdGreaterThan: *hasResult = true; *hasResultType = true; break;
    case Op::OpFUnordGreaterThan: *hasResult = true; *hasResultType = true; break;
    case Op::OpFOrdLessThanEqual: *hasResult = true; *hasResultType = true; break;
    case Op::OpFUnordLessThanEqual: *hasResult = true; *hasResultType = true; break;
    case Op::OpFOrdGreaterThanEqual: *hasResult = true; *hasResultType = true; break;
    case Op::OpFUnordGreaterThanEqual: *hasResult = true; *hasResultType = true; break;
    case Op::OpShiftRightLogical: *hasResult = true; *hasResultType = true; break;
    case Op::OpShiftRightArithmetic: *hasResult = true; *hasResultType = true; break;
    case Op::OpShiftLeftLogical: *hasResult = true; *hasResultType = true; break;
    case Op::OpBitwiseOr: *hasResult = true; *hasResultType = true; break;
    case Op::OpBitwiseXor: *hasResult = true; *hasResultType = true; break;
    case Op::OpBitwiseAnd: *hasResult = true; *hasResultType = true; break;
    case Op::OpNot: *hasResult = true; *hasResultType = true; break;
    case Op::OpBitFieldInsert: *hasResult = true; *hasResultType = true; break;
    case Op::OpBitFieldSExtract: *hasResult = true; *hasResultType = true; break;
    case Op::OpBitFieldUExtract: *hasResult = true; *hasResultType = true; break;
    case Op::OpBitReverse: *hasResult = true; *hasResultType = true; break;
    case Op::OpBitCount: *hasResult = true; *hasResultType = true; break;
    case Op::OpDPdx: *hasResult = true; *hasResultType = true; break;
    case Op::OpDPdy: *hasResult = true; *hasResultType = true; break;
    case Op::OpFwidth: *hasResult = true; *hasResultType = true; break;
    case Op::OpDPdxFine: *hasResult = true; *hasResultType = true; break;
    case Op::OpDPdyFine: *hasResult = true; *hasResultType = true; break;
    case Op::OpFwidthFine: *hasResult = true; *hasResultType = true; break;
    case Op::OpDPdxCoarse: *hasResult = true; *hasResultType = true; break;
    case Op::OpDPdyCoarse: *hasResult = true; *hasResultType = true; break;
    case Op::OpFwidthCoarse: *hasResult = true; *hasResultType = true; break;
    case Op::OpEmitVertex: *hasResult = false; *hasResultType = false; break;
    case Op::OpEndPrimitive: *hasResult = false; *hasResultType = false; break;
    case Op::OpEmitStreamVertex: *hasResult = false; *hasResultType = false; break;
    case Op::OpEndStreamPrimitive: *hasResult = false; *hasResultType = false; break;
    case Op::OpControlBarrier: *hasResult = false; *hasResultType = false; break;
    case Op::OpMemoryBarrier: *hasResult = false; *hasResultType = false; break;
    case Op::OpAtomicLoad: *hasResult = true; *hasResultType = true; break;
    case Op::OpAtomicStore: *hasResult = false; *hasResultType = false; break;
    case Op::OpAtomicExchange: *hasResult = true; *hasResultType = true; break;
    case Op::OpAtomicCompareExchange: *hasResult = true; *hasResultType = true; break;
    case Op::OpAtomicCompareExchangeWeak: *hasResult = true; *hasResultType = true; break;
    case Op::OpAtomicIIncrement: *hasResult = true; *hasResultType = true; break;
    case Op::OpAtomicIDecrement: *hasResult = true; *hasResultType = true; break;
    case Op::OpAtomicIAdd: *hasResult = true; *hasResultType = true; break;
    case Op::OpAtomicISub: *hasResult = true; *hasResultType = true; break;
    case Op::OpAtomicSMin: *hasResult = true; *hasResultType = true; break;
    case Op::OpAtomicUMin: *hasResult = true; *hasResultType = true; break;
    case Op::OpAtomicSMax: *hasResult = true; *hasResultType = true; break;
    case Op::OpAtomicUMax: *hasResult = true; *hasResultType = true; break;
    case Op::OpAtomicAnd: *hasResult = true; *hasResultType = true; break;
    case Op::OpAtomicOr: *hasResult = true; *hasResultType = true; break;
    case Op::OpAtomicXor: *hasResult = true; *hasResultType = true; break;
    case Op::OpPhi: *hasResult = true; *hasResultType = true; break;
    case Op::OpLoopMerge: *hasResult = false; *hasResultType = false; break;
    case Op::OpSelectionMerge: *hasResult = false; *hasResultType = false; break;
    case Op::OpLabel: *hasResult = true; *hasResultType = false; break;
    case Op::OpBranch: *hasResult = false; *hasResultType = false; break;
    case Op::OpBranchConditional: *hasResult = false; *hasResultType = false; break;
    case Op::OpSwitch: *hasResult = false; *hasResultType = false; break;
    case Op::OpKill: *hasResult = false; *hasResultType = false; break;
    case Op::OpReturn: *hasResult = false; *hasResultType = false; break;
    case Op::OpReturnValue: *hasResult = false; *hasResultType = false; break;
    case Op::OpUnreachable: *hasResult = false; *hasResultType = false; break;
    case Op::OpLifetimeStart: *hasResult = false; *hasResultType = false; break;
    case Op::OpLifetimeStop: *hasResult = false; *hasResultType = false; break;
    case Op::OpGroupAsyncCopy: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupWaitEvents: *hasResult = false; *hasResultType = false; break;
    case Op::OpGroupAll: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupAny: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupBroadcast: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupIAdd: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupFAdd: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupFMin: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupUMin: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupSMin: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupFMax: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupUMax: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupSMax: *hasResult = true; *hasResultType = true; break;
    case Op::OpReadPipe: *hasResult = true; *hasResultType = true; break;
    case Op::OpWritePipe: *hasResult = true; *hasResultType = true; break;
    case Op::OpReservedReadPipe: *hasResult = true; *hasResultType = true; break;
    case Op::OpReservedWritePipe: *hasResult = true; *hasResultType = true; break;
    case Op::OpReserveReadPipePackets: *hasResult = true; *hasResultType = true; break;
    case Op::OpReserveWritePipePackets: *hasResult = true; *hasResultType = true; break;
    case Op::OpCommitReadPipe: *hasResult = false; *hasResultType = false; break;
    case Op::OpCommitWritePipe: *hasResult = false; *hasResultType = false; break;
    case Op::OpIsValidReserveId: *hasResult = true; *hasResultType = true; break;
    case Op::OpGetNumPipePackets: *hasResult = true; *hasResultType = true; break;
    case Op::OpGetMaxPipePackets: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupReserveReadPipePackets: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupReserveWritePipePackets: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupCommitReadPipe: *hasResult = false; *hasResultType = false; break;
    case Op::OpGroupCommitWritePipe: *hasResult = false; *hasResultType = false; break;
    case Op::OpEnqueueMarker: *hasResult = true; *hasResultType = true; break;
    case Op::OpEnqueueKernel: *hasResult = true; *hasResultType = true; break;
    case Op::OpGetKernelNDrangeSubGroupCount: *hasResult = true; *hasResultType = true; break;
    case Op::OpGetKernelNDrangeMaxSubGroupSize: *hasResult = true; *hasResultType = true; break;
    case Op::OpGetKernelWorkGroupSize: *hasResult = true; *hasResultType = true; break;
    case Op::OpGetKernelPreferredWorkGroupSizeMultiple: *hasResult = true; *hasResultType = true; break;
    case Op::OpRetainEvent: *hasResult = false; *hasResultType = false; break;
    case Op::OpReleaseEvent: *hasResult = false; *hasResultType = false; break;
    case Op::OpCreateUserEvent: *hasResult = true; *hasResultType = true; break;
    case Op::OpIsValidEvent: *hasResult = true; *hasResultType = true; break;
    case Op::OpSetUserEventStatus: *hasResult = false; *hasResultType = false; break;
    case Op::OpCaptureEventProfilingInfo: *hasResult = false; *hasResultType = false; break;
    case Op::OpGetDefaultQueue: *hasResult = true; *hasResultType = true; break;
    case Op::OpBuildNDRange: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageSparseSampleImplicitLod: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageSparseSampleExplicitLod: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageSparseSampleDrefImplicitLod: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageSparseSampleDrefExplicitLod: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageSparseSampleProjImplicitLod: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageSparseSampleProjExplicitLod: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageSparseSampleProjDrefImplicitLod: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageSparseSampleProjDrefExplicitLod: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageSparseFetch: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageSparseGather: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageSparseDrefGather: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageSparseTexelsResident: *hasResult = true; *hasResultType = true; break;
    case Op::OpNoLine: *hasResult = false; *hasResultType = false; break;
    case Op::OpAtomicFlagTestAndSet: *hasResult = true; *hasResultType = true; break;
    case Op::OpAtomicFlagClear: *hasResult = false; *hasResultType = false; break;
    case Op::OpImageSparseRead: *hasResult = true; *hasResultType = true; break;
    case Op::OpSizeOf: *hasResult = true; *hasResultType = true; break;
    case Op::OpTypePipeStorage: *hasResult = true; *hasResultType = false; break;
    case Op::OpConstantPipeStorage: *hasResult = true; *hasResultType = true; break;
    case Op::OpCreatePipeFromPipeStorage: *hasResult = true; *hasResultType = true; break;
    case Op::OpGetKernelLocalSizeForSubgroupCount: *hasResult = true; *hasResultType = true; break;
    case Op::OpGetKernelMaxNumSubgroups: *hasResult = true; *hasResultType = true; break;
    case Op::OpTypeNamedBarrier: *hasResult = true; *hasResultType = false; break;
    case Op::OpNamedBarrierInitialize: *hasResult = true; *hasResultType = true; break;
    case Op::OpMemoryNamedBarrier: *hasResult = false; *hasResultType = false; break;
    case Op::OpModuleProcessed: *hasResult = false; *hasResultType = false; break;
    case Op::OpExecutionModeId: *hasResult = false; *hasResultType = false; break;
    case Op::OpDecorateId: *hasResult = false; *hasResultType = false; break;
    case Op::OpGroupNonUniformElect: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformAll: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformAny: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformAllEqual: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformBroadcast: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformBroadcastFirst: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformBallot: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformInverseBallot: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformBallotBitExtract: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformBallotBitCount: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformBallotFindLSB: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformBallotFindMSB: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformShuffle: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformShuffleXor: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformShuffleUp: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformShuffleDown: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformIAdd: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformFAdd: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformIMul: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformFMul: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformSMin: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformUMin: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformFMin: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformSMax: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformUMax: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformFMax: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformBitwiseAnd: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformBitwiseOr: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformBitwiseXor: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformLogicalAnd: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformLogicalOr: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformLogicalXor: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformQuadBroadcast: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformQuadSwap: *hasResult = true; *hasResultType = true; break;
    case Op::OpCopyLogical: *hasResult = true; *hasResultType = true; break;
    case Op::OpPtrEqual: *hasResult = true; *hasResultType = true; break;
    case Op::OpPtrNotEqual: *hasResult = true; *hasResultType = true; break;
    case Op::OpPtrDiff: *hasResult = true; *hasResultType = true; break;
    case Op::OpTerminateInvocation: *hasResult = false; *hasResultType = false; break;
    case Op::OpSubgroupBallotKHR: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupFirstInvocationKHR: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAllKHR: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAnyKHR: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAllEqualKHR: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupReadInvocationKHR: *hasResult = true; *hasResultType = true; break;
    case Op::OpTraceRayKHR: *hasResult = false; *hasResultType = false; break;
    case Op::OpExecuteCallableKHR: *hasResult = false; *hasResultType = false; break;
    case Op::OpConvertUToAccelerationStructureKHR: *hasResult = true; *hasResultType = true; break;
    case Op::OpIgnoreIntersectionKHR: *hasResult = false; *hasResultType = false; break;
    case Op::OpTerminateRayKHR: *hasResult = false; *hasResultType = false; break;
    case Op::OpTypeRayQueryKHR: *hasResult = true; *hasResultType = false; break;
    case Op::OpRayQueryInitializeKHR: *hasResult = false; *hasResultType = false; break;
    case Op::OpRayQueryTerminateKHR: *hasResult = false; *hasResultType = false; break;
    case Op::OpRayQueryGenerateIntersectionKHR: *hasResult = false; *hasResultType = false; break;
    case Op::OpRayQueryConfirmIntersectionKHR: *hasResult = false; *hasResultType = false; break;
    case Op::OpRayQueryProceedKHR: *hasResult = true; *hasResultType = true; break;
    case Op::OpRayQueryGetIntersectionTypeKHR: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupIAddNonUniformAMD: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupFAddNonUniformAMD: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupFMinNonUniformAMD: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupUMinNonUniformAMD: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupSMinNonUniformAMD: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupFMaxNonUniformAMD: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupUMaxNonUniformAMD: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupSMaxNonUniformAMD: *hasResult = true; *hasResultType = true; break;
    case Op::OpFragmentMaskFetchAMD: *hasResult = true; *hasResultType = true; break;
    case Op::OpFragmentFetchAMD: *hasResult = true; *hasResultType = true; break;
    case Op::OpReadClockKHR: *hasResult = true; *hasResultType = true; break;
    case Op::OpImageSampleFootprintNV: *hasResult = true; *hasResultType = true; break;
    case Op::OpGroupNonUniformPartitionNV: *hasResult = true; *hasResultType = true; break;
    case Op::OpWritePackedPrimitiveIndices4x8NV: *hasResult = false; *hasResultType = false; break;
    case Op::OpReportIntersectionNV: *hasResult = true; *hasResultType = true; break;
    case Op::OpIgnoreIntersectionNV: *hasResult = false; *hasResultType = false; break;
    case Op::OpTerminateRayNV: *hasResult = false; *hasResultType = false; break;
    case Op::OpTraceNV: *hasResult = false; *hasResultType = false; break;
    case Op::OpTypeAccelerationStructureNV: *hasResult = true; *hasResultType = false; break;
    case Op::OpExecuteCallableNV: *hasResult = false; *hasResultType = false; break;
    case Op::OpTypeCooperativeMatrixNV: *hasResult = true; *hasResultType = false; break;
    case Op::OpCooperativeMatrixLoadNV: *hasResult = true; *hasResultType = true; break;
    case Op::OpCooperativeMatrixStoreNV: *hasResult = false; *hasResultType = false; break;
    case Op::OpCooperativeMatrixMulAddNV: *hasResult = true; *hasResultType = true; break;
    case Op::OpCooperativeMatrixLengthNV: *hasResult = true; *hasResultType = true; break;
    case Op::OpBeginInvocationInterlockEXT: *hasResult = false; *hasResultType = false; break;
    case Op::OpEndInvocationInterlockEXT: *hasResult = false; *hasResultType = false; break;
    case Op::OpDemoteToHelperInvocationEXT: *hasResult = false; *hasResultType = false; break;
    case Op::OpIsHelperInvocationEXT: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupShuffleINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupShuffleDownINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupShuffleUpINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupShuffleXorINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupBlockReadINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupBlockWriteINTEL: *hasResult = false; *hasResultType = false; break;
    case Op::OpSubgroupImageBlockReadINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupImageBlockWriteINTEL: *hasResult = false; *hasResultType = false; break;
    case Op::OpSubgroupImageMediaBlockReadINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupImageMediaBlockWriteINTEL: *hasResult = false; *hasResultType = false; break;
    case Op::OpUCountLeadingZerosINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpUCountTrailingZerosINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpAbsISubINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpAbsUSubINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpIAddSatINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpUAddSatINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpIAverageINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpUAverageINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpIAverageRoundedINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpUAverageRoundedINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpISubSatINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpUSubSatINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpIMul32x16INTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpUMul32x16INTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpFunctionPointerINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpFunctionPointerCallINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpDecorateString: *hasResult = false; *hasResultType = false; break;
    case Op::OpMemberDecorateString: *hasResult = false; *hasResultType = false; break;
    case Op::OpVmeImageINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpTypeVmeImageINTEL: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeAvcImePayloadINTEL: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeAvcRefPayloadINTEL: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeAvcSicPayloadINTEL: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeAvcMcePayloadINTEL: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeAvcMceResultINTEL: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeAvcImeResultINTEL: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeAvcImeResultSingleReferenceStreamoutINTEL: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeAvcImeResultDualReferenceStreamoutINTEL: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeAvcImeSingleReferenceStreaminINTEL: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeAvcImeDualReferenceStreaminINTEL: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeAvcRefResultINTEL: *hasResult = true; *hasResultType = false; break;
    case Op::OpTypeAvcSicResultINTEL: *hasResult = true; *hasResultType = false; break;
    case Op::OpSubgroupAvcMceGetDefaultInterBaseMultiReferencePenaltyINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceSetInterBaseMultiReferencePenaltyINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceGetDefaultInterShapePenaltyINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceSetInterShapePenaltyINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceGetDefaultInterDirectionPenaltyINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceSetInterDirectionPenaltyINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceGetDefaultIntraLumaShapePenaltyINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceGetDefaultInterMotionVectorCostTableINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceGetDefaultHighPenaltyCostTableINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceGetDefaultMediumPenaltyCostTableINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceGetDefaultLowPenaltyCostTableINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceSetMotionVectorCostFunctionINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceGetDefaultIntraLumaModePenaltyINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceGetDefaultNonDcLumaIntraPenaltyINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceGetDefaultIntraChromaModeBasePenaltyINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceSetAcOnlyHaarINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceSetSourceInterlacedFieldPolarityINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceSetSingleReferenceInterlacedFieldPolarityINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceSetDualReferenceInterlacedFieldPolaritiesINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceConvertToImePayloadINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceConvertToImeResultINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceConvertToRefPayloadINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceConvertToRefResultINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceConvertToSicPayloadINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceConvertToSicResultINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceGetMotionVectorsINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceGetInterDistortionsINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceGetBestInterDistortionsINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceGetInterMajorShapeINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceGetInterMinorShapeINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceGetInterDirectionsINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceGetInterMotionVectorCountINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceGetInterReferenceIdsINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcMceGetInterReferenceInterlacedFieldPolaritiesINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeInitializeINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeSetSingleReferenceINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeSetDualReferenceINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeRefWindowSizeINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeAdjustRefOffsetINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeConvertToMcePayloadINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeSetMaxMotionVectorCountINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeSetUnidirectionalMixDisableINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeSetEarlySearchTerminationThresholdINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeSetWeightedSadINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeEvaluateWithSingleReferenceINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeEvaluateWithDualReferenceINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeEvaluateWithDualReferenceStreaminINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeEvaluateWithSingleReferenceStreamoutINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeEvaluateWithDualReferenceStreamoutINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminoutINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeEvaluateWithDualReferenceStreaminoutINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeConvertToMceResultINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeGetSingleReferenceStreaminINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeGetDualReferenceStreaminINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeStripSingleReferenceStreamoutINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeStripDualReferenceStreamoutINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeMotionVectorsINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeDistortionsINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeReferenceIdsINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeMotionVectorsINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeDistortionsINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeReferenceIdsINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeGetBorderReachedINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeGetTruncatedSearchIndicationINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeGetUnidirectionalEarlySearchTerminationINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeGetWeightingPatternMinimumMotionVectorINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcImeGetWeightingPatternMinimumDistortionINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcFmeInitializeINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcBmeInitializeINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcRefConvertToMcePayloadINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcRefSetBidirectionalMixDisableINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcRefSetBilinearFilterEnableINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcRefEvaluateWithSingleReferenceINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcRefEvaluateWithDualReferenceINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcRefEvaluateWithMultiReferenceINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcRefEvaluateWithMultiReferenceInterlacedINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcRefConvertToMceResultINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcSicInitializeINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcSicConfigureSkcINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcSicConfigureIpeLumaINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcSicConfigureIpeLumaChromaINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcSicGetMotionVectorMaskINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcSicConvertToMcePayloadINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcSicSetIntraLumaShapePenaltyINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcSicSetIntraLumaModeCostFunctionINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcSicSetIntraChromaModeCostFunctionINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcSicSetBilinearFilterEnableINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcSicSetSkcForwardTransformEnableINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcSicSetBlockBasedRawSkipSadINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcSicEvaluateIpeINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcSicEvaluateWithSingleReferenceINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcSicEvaluateWithDualReferenceINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcSicEvaluateWithMultiReferenceINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcSicEvaluateWithMultiReferenceInterlacedINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcSicConvertToMceResultINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcSicGetIpeLumaShapeINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcSicGetBestIpeLumaDistortionINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcSicGetBestIpeChromaDistortionINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcSicGetPackedIpeLumaModesINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcSicGetIpeChromaModeINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcSicGetPackedSkcLumaCountThresholdINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcSicGetPackedSkcLumaSumThresholdINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpSubgroupAvcSicGetInterRawSadsINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpLoopControlINTEL: *hasResult = false; *hasResultType = false; break;
    case Op::OpReadPipeBlockingINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpWritePipeBlockingINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpFPGARegINTEL: *hasResult = true; *hasResultType = true; break;
    case Op::OpRayQueryGetRayTMinKHR: *hasResult = true; *hasResultType = true; break;
    case Op::OpRayQueryGetRayFlagsKHR: *hasResult = true; *hasResultType = true; break;
    case Op::OpRayQueryGetIntersectionTKHR: *hasResult = true; *hasResultType = true; break;
    case Op::OpRayQueryGetIntersectionInstanceCustomIndexKHR: *hasResult = true; *hasResultType = true; break;
    case Op::OpRayQueryGetIntersectionInstanceIdKHR: *hasResult = true; *hasResultType = true; break;
    case Op::OpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR: *hasResult = true; *hasResultType = true; break;
    case Op::OpRayQueryGetIntersectionGeometryIndexKHR: *hasResult = true; *hasResultType = true; break;
    case Op::OpRayQueryGetIntersectionPrimitiveIndexKHR: *hasResult = true; *hasResultType = true; break;
    case Op::OpRayQueryGetIntersectionBarycentricsKHR: *hasResult = true; *hasResultType = true; break;
    case Op::OpRayQueryGetIntersectionFrontFaceKHR: *hasResult = true; *hasResultType = true; break;
    case Op::OpRayQueryGetIntersectionCandidateAABBOpaqueKHR: *hasResult = true; *hasResultType = true; break;
    case Op::OpRayQueryGetIntersectionObjectRayDirectionKHR: *hasResult = true; *hasResultType = true; break;
    case Op::OpRayQueryGetIntersectionObjectRayOriginKHR: *hasResult = true; *hasResultType = true; break;
    case Op::OpRayQueryGetWorldRayDirectionKHR: *hasResult = true; *hasResultType = true; break;
    case Op::OpRayQueryGetWorldRayOriginKHR: *hasResult = true; *hasResultType = true; break;
    case Op::OpRayQueryGetIntersectionObjectToWorldKHR: *hasResult = true; *hasResultType = true; break;
    case Op::OpRayQueryGetIntersectionWorldToObjectKHR: *hasResult = true; *hasResultType = true; break;
    case Op::OpAtomicFAddEXT: *hasResult = true; *hasResultType = true; break;
    }
}
#endif /* SPV_ENABLE_UTILITY_CODE */

// Overload operator| for mask bit combining

inline ImageOperandsMask operator|(ImageOperandsMask a, ImageOperandsMask b) { return ImageOperandsMask(unsigned(a) | unsigned(b)); }
inline FPFastMathModeMask operator|(FPFastMathModeMask a, FPFastMathModeMask b) { return FPFastMathModeMask(unsigned(a) | unsigned(b)); }
inline SelectionControlMask operator|(SelectionControlMask a, SelectionControlMask b) { return SelectionControlMask(unsigned(a) | unsigned(b)); }
inline LoopControlMask operator|(LoopControlMask a, LoopControlMask b) { return LoopControlMask(unsigned(a) | unsigned(b)); }
inline FunctionControlMask operator|(FunctionControlMask a, FunctionControlMask b) { return FunctionControlMask(unsigned(a) | unsigned(b)); }
inline MemorySemanticsMask operator|(MemorySemanticsMask a, MemorySemanticsMask b) { return MemorySemanticsMask(unsigned(a) | unsigned(b)); }
inline MemoryAccessMask operator|(MemoryAccessMask a, MemoryAccessMask b) { return MemoryAccessMask(unsigned(a) | unsigned(b)); }
inline KernelProfilingInfoMask operator|(KernelProfilingInfoMask a, KernelProfilingInfoMask b) { return KernelProfilingInfoMask(unsigned(a) | unsigned(b)); }
inline RayFlagsMask operator|(RayFlagsMask a, RayFlagsMask b) { return RayFlagsMask(unsigned(a) | unsigned(b)); }
inline FragmentShadingRateMask operator|(FragmentShadingRateMask a, FragmentShadingRateMask b) { return FragmentShadingRateMask(unsigned(a) | unsigned(b)); }

}  // end namespace spv

#endif  // #ifndef spirv_HPP


