---
title: 'UI Kit'
description: 'UI Kit is for module authors to build a custom view.'
---

::callout
We suggest you to read the [Module Authors Guide](/module/guide) first.
::

DevTools UI Kit is for module authors to build the custom view with the similiar look and feel as built-in DevTools UI. The source code can be found under [`packages/devtools-ui-kit`](https://github.com/nuxt/devtools/tree/main/packages/devtools-ui-kit).

## Installation

We recommend to use the [Starter Template](/module/guide#starter-template) for authoring a DevTools integration for your module, which has the set up built in and ready to use.

### Manual Install

```bash
npm i @nuxt/devtools-ui-kit
```

```ts
export default defineNuxtConfig({
  modules: [
    '@nuxt/devtools-ui-kit'
  ]
})
```

## Usage

Under the hood, `@nuxt/devtools-ui-kit` is an unbundled component library powered by [UnoCSS](https://github.com/unocss/unocss) and [VueUse](https://vueuse.org/). Components are auto imported.

In this library, we introduced the `n` attribute for every component to customize the styles and variations. For example, to make a red button:

```html
<NButton n="red" />
```

to make it larger, add the size specifier (`sm`, `md`, `lg` or `xl`) the `n` attribute:

```html
<NButton n="red xl" />
```

You can apply the same specifiers to any other component, for example:

```html
<NCheckbox n="red xl" />
```

Apply it to parent components could make a local theme scope

```html
<NCard n="green-500">
  <!-- both of them are themed green -->
  <NCheckbox>i accept the terms & conditions</NCheckbox>
  <NButton>Submit</NButton>
</NCard>
```

Please check our [Online Demo](https://ui-kit.devtools.nuxtjs.org/) for more components usages.

## Components

Check [all components](https://github.com/nuxt/devtools/blob/main/packages/devtools-ui-kit/src/components).

## Theming

Powered by [UnoCSS](https://github.com/antfu/unocss), you can use Tailwind/Windi CSS utilities to quickly customize the look and feel of components.

It's also possible to override the default theme globally, for example:

```ts
// nuxt.config.js
export default defineNuxtConfig({
  modules: [
    '@nuxt/devtools-ui-kit'
  ],
  unocss: {
    shortcuts: {
      'n-button-base': 'border n-border-base rounded shadow-sm op80 !outline-none',
      'n-button-hover': 'op100 !border-context text-context',
      'n-button-active': 'n-active-base bg-context/5',
    }
  }
})
```

You can find all the default values and available entries in [src/unocss.ts](https://github.com/nuxt/devtools/blob/main/packages/devtools-ui-kit/src/unocss.ts).
