---
title: Composables
description: Open or control Nuxt DevTools with the useNuxtDevtools composable.
---

In case you might want to open or control the Nuxt DevTools in your application on development, a composable `useNuxtDevtools` is registered with auto-import.

```vue
<script setup>
// Returns undefined in production mode or when the DevTools are not enabled
const devtoolsClient = useNuxtDevTools() // NuxtDevToolsHostClient | undefined
</script>

<template>
  <button
    v-if="devtoolsClient"
    @click="devtoolsClient.devtools.navigate('/modules/components')"
  >
    <!-- Open the DevTools and navigate to the components tab -->
    Open DevTools
  </button>
</template>
```

When you have auto-import disabled, you can also import it explicitly:

```ts
import { useNuxtDevTools } from '#imports'
```

Checkout it's type definition for more available methods.
