---
title: Features
description: Discover all the features the Nuxt Devtools can offer.
---

You can learn more in our [roadmap](https://github.com/nuxt/devtools/discussions/31).

## Overview

Shows a quick overview of your app, including the Nuxt version (which if it’s not up to date you can easily update it), Vue version, pages, components, imports, modules and plugins that you are using, and your app’s loading time and more!

<img width="1284" src="https://user-images.githubusercontent.com/11247099/217670797-12c33a03-ca4f-490d-a18a-ab9008b89c15.png">

## Pages

Pages tab shows your current routes with some useful information such as what layout or middleware it has, and provides a quick way to navigate between pages. You can also use the textbox to see how each route is matched.

<img width="1284" src="https://user-images.githubusercontent.com/11247099/217670804-e48482af-de37-47be-88d8-d9515e796d5f.png">

## Components

Components tab shows all the components you are using in your app and where they are from. You can also search for them and go to the source code.

<img width="1284" src="https://user-images.githubusercontent.com/11247099/217670805-726eafd1-5364-4b11-9c2b-9253d068e7e3.png">

Components tab also has a Graph view which you can toggle.
Graph view also shows the relationship between components, and knows the dependencies of each component.

<img width="1284" src="https://user-images.githubusercontent.com/11247099/217670806-fb39aeff-3881-44e5-b9c8-6c757f5925fc.png">

You can also inspect your app's DOM tree and see which component is rendering it. Finding the place to make changes are much easier.

<img width="1284" src="https://user-images.githubusercontent.com/11247099/217670809-7dcb4198-5a74-4818-95b1-b62ea6c04a6c.png">

## Imports

Imports tab shows all the auto-imports registered to Nuxt. You can see which files are importing them, and where they are from. Some entries can also provide short descriptions and documentation links.

<img width="1284" src="https://user-images.githubusercontent.com/11247099/217670811-fa7c7249-5a21-48c9-abe8-ca02b2518a3a.png">

## Modules

Modules tab shows all the modules you have installed and their information such as the module’s github repository, documentation, version and …

<img width="1284" src="https://user-images.githubusercontent.com/11247099/217670813-ce3da4b6-269c-430e-abb5-a2263ffe4938.png">

You can install or even remove any Nuxt module with one-click!

## Assets

Assets tab shows your files from the Public directory, you can see the information of selected file with some helpful actions.

You can also upload files with Drag & Drop ability

## Terminals

Terminals tab shows the active terminal processes.

## Runtime Config

Runtime Config tab shows all the runtime config of your project, with the ability to edit them.

## Payload

Payloads tab shows all the state and data payloads of your project.

## Build Analyze

In the Build Analyze tab, you can run analyze build and see the bundle size of your project. it saves the report so you can compare the bundle size in different builds.

## Open Graph

Open Graph tab is to help you with SEO, it shows you a Social Preview Card for twitter, facebook and linkedIn for your page. It also provides missing SEO tags with the ability to copy code snippets.

## Plugins

Plugins tab shows all the plugins your project is using, with some information such as plugin's initialization time.

## Server Routes

Server Routes tab shows all nitro routes in your project. It provides a playground to send and test your endpoints.

## Storage

Storage tab shows all the nitro storage in your project. You can create, edit, and delete files.

Learn more about [Nitro Storage](https://nitro.unjs.io/guide/storage)

## Tasks

Tasks tab shows all nitro tasks in your project. You can pass task payloads, run them, and see the task results.

Learn more about [Nitro Tasks](https://nitro.build/guide/tasks)

## VS Code Server

The VS Code Server integration in Nuxt DevTools enhances your development experience by bringing the power of Visual Studio Code directly into your browser. With this feature, you can seamlessly edit and debug your Nuxt projects using the familiar interface of VS Code.

Nuxt DevTools supports the following ways of integrating with VS Code:

### Connecting to an existing code-server instance

Set `reuseExistingServer` to true in runtime config for `devtools/vscode` and set the `port` option to specify a port (defalts to 3080):

```ts [nuxt.config.ts]
export default defineNuxtConfig({
  devtools: {
    vscode: {
      reuseExistingServer: true,
      port: 3090
    }
  }
})
```

### Running a code-server instance locally

You can use either the [Microsoft Visual Studio Code Server](https://code.visualstudio.com/docs/remote/vscode-server) (via the `code` or `code-server` cli tools) or the [Coder VS Code Server](https://coder.com/docs/code-server/latest/install) (via the `code-server` cli tool) by setting the `codeServer` parameter under `devtools/vscode` in the runtime configuration.

Options for the codeServer parameter are:
|Type|Option|
|----|------|
|MS Code CLI|`ms-code-cli`|
|MS Code Server|`ms-code-server`|
|Coder Code Server|`coder-code-server`|

You can set the `port` parameter to listen on a specific port (default 3080) and you can set the `host` parameter if you need to listen on a particular host interface (useful for devcontainers or docker containers that listen on ipv6 by default).

**Example**:

```ts [nuxt.config.ts]
export default defineNuxtConfig({
  devtools: {
    vscode: {
      codeServer: 'ms-code-server',
      host: '0.0.0.0',
      port: 3090
    }
  }
})
```

### Remotely via a MS VS Code server tunnel

Set the `mode` option in `devtools/vscode` runtime configuration to `tunnel`. You can set the name of the tunnel to connect to using the `tunnel` option under `devtools/vscode/tunnel` in runtime configuration)

```ts [nuxt.config.ts]
export default defineNuxtConfig({
  devtools: {
    vscode: {
      mode: 'tunnel',
      tunnel: {
        name: 'my-tunnel-name'
      }
    }
  }
})
```

### Code Server Installation Instructions

To get started with Microsoft VS Code Server, follow the installation instructions provided by [Microsoft Visual Studio Code Server](https://code.visualstudio.com/docs/remote/vscode-server)

To get started with Coder Code Server, follow the installation instructions provided by [Code Server Installation Guide](https://coder.com/docs/code-server/latest/install)

For more information on the benefits and features of VS Code Server, refer to [the official Visual Studio Code blog](https://code.visualstudio.com/blogs/2022/07/07/vscode-server)

## Hooks

Hooks tab can help you to monitor the time spent in each hook. It can be helpful to find performance bottlenecks.

<img width="1284" src="https://user-images.githubusercontent.com/11247099/217670815-80ec0ec3-7df1-4a07-96fb-4161fb6562a7.png">

## Virtual Files

Virtual Files tab shows the virtual files generated by Nuxt to support the conventions.

<img width="1284" src="https://user-images.githubusercontent.com/11247099/217670817-abb0315a-6d92-4c5e-a4da-2327f22e0e8b.png">

## Inspect

Inspect expose the [`vite-plugin-inspect`](https://github.com/antfu/vite-plugin-inspect) integration, allowing you to inspect transformation steps of Vite.

<img width="1284" src="https://user-images.githubusercontent.com/11247099/217670818-77f91135-7318-462e-9148-4ad504c82555.png">

## Settings

Settings tab allows you to configure the DevTools to your needs. you can hide tabs, change tabs order, scale, theme and more...

## Nuxt Icon

Nuxt Icon is the first item on sidebar, located at the top left corner of the DevTools. It gives you a quick access to some useful features such as `Toggle Theme`, `Settings`, `Split Screen`, `Popup`, `Refresh Data`, `Refresh Page`. you can simply click on it and see the them yourself.

### Command Palette

Command Palette is a quick way to access some useful features of the DevTools such as easy navigation, run commands and Nuxt Documentations. You can open it with `Ctrl+K` or `Cmd+K` shortcut.

### Split Screen

Split Screen is a useful feature to use multiple tabs at the same time. You can open it from `Command Palette` or by clicking the `Nuxt Icon` in the top left corner of the DevTools and activate it from there.

### Popup

Popup is very useful for those who has a second screen, you can open it by clicking the `Nuxt Icon` in the top left corner of the DevTools and activate it from there.
