---
title: Getting Started
description: Using Nuxt DevTools in your Nuxt project is only a command away.
---

## Installation

::callout
Nuxt DevTools v2 requires **Nuxt v3.15.0 or higher**.
::

### Auto Install

You just need to go to your `nuxt.config` file and set `devtools` to `true`:

```ts [nuxt.config.ts]
export default defineNuxtConfig({
  devtools: { enabled: true },
})
```

Nuxt will automatically install the DevTools module for you.

### Install using Nuxi

You can opt-in Nuxt DevTools per-project by going to the project root and run:

```bash
npx nuxi@latest devtools enable
```

### Open the DevTools Panel

Restart your Nuxt server and open your app in browser. Click the Nuxt icon on the bottom (or press <kbd>Shift</kbd> + <kbd>Alt</kbd> / <kbd>⇧ Shift</kbd> + <kbd>⌥ Option</kbd> + <kbd>D</kbd>) to toggle the DevTools.

::callout
If you using `nvm` or other Node version managers, we suggest to run the enable command again after switching Node version.
::

Similarly, you can disable it per-project by running:

```bash
npx nuxi@latest devtools disable
```

### Install Manually

Nuxt DevTools is currently provided as a module (might be changed in the future). If you prefer, you can also install it locally, which will be activated for all your team members.

```bash
npm i -D @nuxt/devtools
```

```ts [nuxt.config.ts]
export default defineNuxtConfig({
  modules: [
    '@nuxt/devtools',
  ],
})
```

### Nightly Release Channel

Similar to [Nuxt's Nightly Channel](https://nuxt.com/docs/guide/going-further/nightly-release-channel), DevTools also offers a nightly release channel, that automatically releases for every commit to `main` branch.

You can opt-in to the nightly release channel by running:

```diff
{
  "devDependencies": {
--    "@nuxt/devtools": "^0.1.0"
++    "@nuxt/devtools": "npm:@nuxt/devtools-nightly@latest"
  }
}
```

Remove lockfile (`package-lock.json`, `yarn.lock`, or `pnpm-lock.yaml`) and reinstall dependencies.

### Module Options

To configure Nuxt DevTools, you can pass the `devtools` options.

```ts [nuxt.config.ts]
export default defineNuxtConfig({
  devtools: {
    // Enable devtools (default: true)
    enabled: true,
    // VS Code Server options
    vscode: {},
    // ...other options
  }
})
```

For all options available, please refer to TSDocs in your IDE, or the [type definition file](https://github.com/nuxt/devtools/blob/main/packages/devtools-kit/src/_types/options.ts#L6).
