/*
 * Decompiled with CFR 0.152.
 */
package com.mentorgen.tools.profile;

import com.mentorgen.tools.profile.instrument.clfilter.ClassLoaderFilter;
import com.mentorgen.tools.profile.output.ProfileDump;
import com.mentorgen.tools.profile.runtime.Profile;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sourceforge.jiprof.instrument.clfilter.GenericClassLoaderFilter;

public class Controller
implements Runnable {
    private static final String DEFAULT_PROFILE = "on";
    private static final String DEFAULT_REMOVE = "off";
    private static final String DEFAULT_PORT = "15599";
    private static final String DEFAULT_MAX_THREAD_DEPTH = "-1";
    private static final String DEFAULT_THREAD_COMPACT_THRESHOLD = "10";
    private static final String DEFAULT_MAX_METHOD_COUNT = "-1";
    private static final String DEFAULT_METHOD_COMPACT_THRESHOLD = "10";
    private static final String DEFAULT_FILE = "profile.txt";
    private static final String DEFAULT_OBJECT_ALLOC = "off";
    private static final String DEFAULT_PROFILER_CLASS = "com.mentorgen.tools.profile.runtime.Profile";
    private static final String ON = "on";
    public static final int UNLIMITED = -1;
    private static final String START = "start";
    private static final String STOP = "stop";
    private static final String DUMP = "dump";
    private static final String FILE = "file";
    private static final String CLEAR = "clear";
    private static final String FINISH = "finish";
    private static final String DEBUGON = "debugon";
    private static final String DEBUGOFF = "debugoff";
    private static final String REPLACEEXCLUDELIST = "replaceexcludelist";
    private static final String GETEXCLUDELIST = "getexcludelist";
    private static final String REPLACEINCLUDELIST = "replaceincludelist";
    private static final String GETINCLUDELIST = "getincludelist";
    private static final String GETCLASSLOADERSBYNAME = "getclassloadersbyname";
    private static final String REPLACECLASSLOADERSBYNAME = "replaceclassloadersbyname";
    public static boolean _profile;
    public static boolean _remote;
    public static int _port;
    public static int _threadDepth;
    public static int _methodCount;
    public static String _fileName;
    public static String[] _excludeList;
    public static String[] _includeList;
    public static String[] _acceptClassLoadersByName;
    public static boolean _compactThreadDepth;
    public static boolean _compactMethodCount;
    public static int _compactThreadThreshold;
    public static int _compactMethodThreshold;
    public static boolean _trackObjectAlloc;
    public static ClassLoaderFilter _filter;
    public static OutputType _outputType;
    public static boolean _debug;
    public static String _profiler;
    public static boolean _outputMethodSignatures;
    public static TimeResolution _timeResoltion;
    public static boolean _outputSummaryOnly;
    public static Class[] _acceptClassLoaders;
    public static int _instrumentCount;
    private ServerSocket _socket;

    private static String[] parseList(String string, boolean bl) {
        String[] stringArray;
        if (string == null || string.length() == 0 || string.equals("null")) {
            return new String[0];
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            if (bl) {
                arrayList.add(stringArray.replace('.', '/'));
                continue;
            }
            arrayList.add(stringArray);
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private static String getProperty(Properties properties, String string, String string2) {
        String string3 = properties.getProperty(string, string2);
        System.out.print(string);
        System.out.print(": ");
        System.out.println(string3);
        return string3;
    }

    public void setFileName(String string) {
        _fileName = string;
    }

    private void printStringArray(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        for (String string : stringArray) {
            stringBuilder.append(string.replace("/", "."));
            stringBuilder.append(',');
        }
        System.out.println(stringBuilder.toString().substring(0, stringBuilder.length() - 1));
    }

    @Override
    public void run() {
        try {
            this._socket = new ServerSocket(_port);
            while (true) {
                String string;
                char c;
                Socket socket = this._socket.accept();
                socket.setSoTimeout(5000);
                InputStream inputStream = socket.getInputStream();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                StringBuffer stringBuffer = new StringBuffer();
                while ((c = (char)bufferedInputStream.read()) != '\r') {
                    stringBuffer.append(c);
                }
                String string2 = stringBuffer.toString();
                System.out.println(string2);
                if (string2.startsWith(START)) {
                    this.start();
                } else if (string2.startsWith(STOP)) {
                    this.stop();
                } else if (string2.startsWith(DUMP)) {
                    ProfileDump.dump();
                } else if (string2.startsWith(CLEAR)) {
                    Profile.init();
                } else if (string2.startsWith(FILE)) {
                    _fileName = string = string2.substring(string2.indexOf(32) + 1);
                } else if (string2.startsWith(GETCLASSLOADERSBYNAME)) {
                    System.out.println("Current class loaders by name:");
                    this.printStringArray(_acceptClassLoadersByName);
                } else if (string2.startsWith(REPLACECLASSLOADERSBYNAME)) {
                    if (_profile) {
                        this.stop();
                        ProfileDump.dump();
                    }
                    string = string2.substring(string2.indexOf(32) + 1);
                    _acceptClassLoadersByName = Controller.parseList(string, false);
                    System.out.print("New class loaders by name:");
                    this.printStringArray(_acceptClassLoadersByName);
                } else if (string2.startsWith(GETEXCLUDELIST)) {
                    System.out.println("Current exclude list:");
                    this.printStringArray(_excludeList);
                } else if (string2.startsWith(REPLACEEXCLUDELIST)) {
                    if (_profile) {
                        this.stop();
                        ProfileDump.dump();
                    }
                    string = string2.substring(string2.indexOf(32) + 1);
                    _excludeList = Controller.parseList(string, true);
                    System.out.println("New exclude list:");
                    this.printStringArray(_excludeList);
                    Profile.init();
                } else if (string2.startsWith(GETINCLUDELIST)) {
                    System.out.println("Current include list:");
                    this.printStringArray(_includeList);
                } else if (string2.startsWith(REPLACEINCLUDELIST)) {
                    if (_profile) {
                        this.stop();
                        ProfileDump.dump();
                    }
                    string = string2.substring(string2.indexOf(32) + 1);
                    _includeList = Controller.parseList(string, true);
                    System.out.println("New include list:");
                    this.printStringArray(_includeList);
                    Profile.init();
                } else if (string2.startsWith(DEBUGON)) {
                    _debug = true;
                } else if (string2.startsWith(DEBUGOFF)) {
                    _debug = false;
                } else if (string2.startsWith(FINISH)) {
                    this.stop();
                    ProfileDump.dump();
                    Profile.init();
                }
                socket.close();
            }
        }
        catch (SocketException socketException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
    }

    public void close() throws IOException {
        System.err.println("Controller -- shuttingdown");
        if (_remote && this._socket != null && !this._socket.isClosed()) {
            this._socket.close();
        }
    }

    public void start() {
        if (_instrumentCount == 0) {
            System.err.println("Warning: a request has been made to start the profiler but no classes have been instrumented. Possible reasons: ");
            System.err.println("1. All the classes that have been classloaded have been \"excluded\". Check the exclude property in the current profile properties file.");
            System.err.println("2. No appropriate class loader filter has been provided (see \"ClassLoaderFilter.x\" in the current profile properties file.) If no appropriate filter can be found, the standard filter is used. Thisfilter is really only useful for stand-alone applications. Make sure your environment has a ClassLoaderFilter and that your profile properties file is configured correctly.");
            System.err.println("3. Sometimes when Tomcat is launched from within Eclipse, Tomcat, for some reason, will start using the appication classloader (the one that stand-alone apps use) to classload the webapp rather than the web app classloader that it should use. One thing that you can try to get around this odd behavior is to not run Tomcat in debug mode (Window > Perferences > Tomcat > JVM settings : Don't run Tomcat in debug mode.) If this doesn't work, you could try removing the webapp classlaoder filter from your profile properties file.");
        }
        Profile.clear();
        _profile = true;
    }

    public void stop() {
        if (_instrumentCount == 0) {
            System.err.println("No classes have been instrumented for profiling. There should be a previous message to this effect which outlines why this is happening.");
        }
        Profile.shutdown();
    }

    static {
        Object object;
        int n;
        _compactThreadDepth = false;
        _compactMethodCount = false;
        _trackObjectAlloc = false;
        _outputType = OutputType.Text;
        _debug = false;
        _outputMethodSignatures = false;
        _outputSummaryOnly = false;
        _instrumentCount = 0;
        Properties properties = new Properties();
        String string = System.getProperty("profile.properties");
        if (string != null) {
            try {
                properties.load(new FileInputStream(string));
            }
            catch (IOException iOException) {
                System.err.print("Unable to open ");
                System.err.print(string);
                System.err.println(". Using the defaults.");
            }
        }
        String string2 = Controller.getProperty(properties, "profiler", "on");
        String string3 = Controller.getProperty(properties, "remote", "off");
        String string4 = Controller.getProperty(properties, "port", DEFAULT_PORT);
        String string5 = Controller.getProperty(properties, "thread-depth", "-1");
        String string6 = Controller.getProperty(properties, "thread.compact.threshold.ms", "10");
        String string7 = Controller.getProperty(properties, "max-method-count", "-1");
        String string8 = Controller.getProperty(properties, "method.compact.threshold.ms", "10");
        String string9 = Controller.getProperty(properties, FILE, DEFAULT_FILE);
        String string10 = Controller.getProperty(properties, "track.object.alloc", "off");
        String string11 = Controller.getProperty(properties, "output", "text");
        String string12 = Controller.getProperty(properties, "debug", "off");
        String string13 = Controller.getProperty(properties, "profiler-class", DEFAULT_PROFILER_CLASS);
        String string14 = Controller.getProperty(properties, "output-method-signatures", "no");
        String string15 = Controller.getProperty(properties, "clock-resolution", "ms");
        String string16 = Controller.getProperty(properties, "output-summary-only", "no");
        _profile = string2.equals("on");
        _remote = string3.equals("on");
        _port = Integer.parseInt(string4);
        _compactThreadThreshold = Integer.parseInt(string6);
        _compactMethodThreshold = Integer.parseInt(string8);
        if ("compact".equals(string5.trim())) {
            _compactThreadDepth = true;
        } else {
            _threadDepth = Integer.parseInt(string5);
        }
        if ("compact".equals(string7.trim())) {
            _compactMethodCount = true;
        } else {
            _methodCount = Integer.parseInt(string7);
        }
        if ("on".equalsIgnoreCase(string10.trim())) {
            _trackObjectAlloc = true;
        }
        if ("on".equalsIgnoreCase(string12.trim())) {
            _debug = true;
        }
        if ("yes".equalsIgnoreCase(string14)) {
            _outputMethodSignatures = true;
        }
        if ("text".equalsIgnoreCase(string11.trim())) {
            _outputType = OutputType.Text;
        } else if ("xml".equalsIgnoreCase(string11.trim())) {
            _outputType = OutputType.XML;
        } else if ("both".equalsIgnoreCase(string11.trim())) {
            _outputType = OutputType.Both;
        }
        _timeResoltion = "ms".equalsIgnoreCase(string15) ? TimeResolution.ms : TimeResolution.ns;
        if ("yes".equalsIgnoreCase(string16)) {
            _outputSummaryOnly = true;
        }
        _fileName = string9;
        String string17 = properties.getProperty("exclude");
        String string18 = properties.getProperty("include");
        System.out.print("exclude:");
        System.out.println(string17);
        if (string18 != null && string18.length() > 0) {
            System.out.print("include:");
            System.out.println(string18);
        }
        _excludeList = Controller.parseList(string17, true);
        _includeList = Controller.parseList(string18, true);
        String string19 = properties.getProperty("accept-class-loaders-byname");
        if (string19 != null && string19.length() > 0) {
            System.out.println("Class loaders by name:");
            System.out.println(string19);
        }
        _acceptClassLoadersByName = Controller.parseList(properties.getProperty("accept-class-loaders-byname"), false);
        String[] stringArray = Controller.parseList(properties.getProperty("accept-class-loaders", ClassLoader.getSystemClassLoader().getClass().getName()), false);
        _acceptClassLoaders = new Class[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            try {
                Controller._acceptClassLoaders[n] = Class.forName(stringArray[n]);
                System.out.println("Accept ClassLoader: " + _acceptClassLoaders[n].getName());
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("UNKNOWN CLASSLOADER: " + stringArray[n]);
                System.err.println("Using the system classloader instead");
                Controller._acceptClassLoaders[n] = ClassLoader.getSystemClassLoader().getClass();
            }
        }
        n = 1;
        while (true) {
            object = new StringBuffer("ClassLoaderFilter.");
            ((StringBuffer)object).append(n);
            String string20 = Controller.getProperty(properties, ((StringBuffer)object).toString(), null);
            if (string20 == null) break;
            try {
                ClassLoaderFilter classLoaderFilter = (ClassLoaderFilter)Class.forName(string20).newInstance();
                if (classLoaderFilter.canFilter()) {
                    _filter = classLoaderFilter;
                    break;
                }
            }
            catch (Exception exception) {
                System.err.print("Could not instantiate ClassLoaderFilter ");
                System.err.println(string20);
            }
            ++n;
        }
        if (_filter == null) {
            System.err.println("Using the generic class loader filter.");
            _filter = new GenericClassLoaderFilter();
        }
        _profiler = string13.replace('.', '/');
        try {
            Class<?> clazz = Class.forName(string13);
            object = clazz.getMethod("initProfiler", new Class[0]);
            ((Method)object).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            System.err.println("Unable to invoke init on Profiler class.");
        }
        System.out.println("------------------");
    }

    public static enum TimeResolution {
        ms,
        ns;

    }

    public static enum OutputType {
        Text,
        XML,
        Both;

    }
}

