NumBBO/CoCO Framework in Python (Experimental Part)
===================================================

Prerequisites
-------------

The simplest way to check the prerequisits is to go directly to [_Getting Started_](#Getting-Started)
below and give it a try. Then act upon failure, as in this case probably one of
the following is lacking: 

- Python is installed (version >=2.6). If this is not the case, check out
  [Anaconda](https://www.continuum.io), as this provides additionally all
  Python packages necessary to run the COCO postprocessing as well as the
  ipython shell. The postprocessing needs currently Python < 3.0, i.e. 2.6 or 2.7.

- `make` is installed and works with one of the MakeFiles provided in folder
  `code-experiments/build/c`. You might type `make` within the `build/c` folder
  to see whether this works. 
  
- A C compiler, like `gcc`, which is invoked by `make`. 


Getting Started  <a name="Getting-Started"></a>
---------------

See _Getting Started_ [here](../../../README.md#Getting-Started) for the first steps. Then

- Copy (and rename) [`example_experiment_for_beginners.py`](./example_experiment_for_beginners.py)
  or [`example_experiment.py`](`./example_experiment.py`) to a place (and name) of
  your choice. Modify this file to include the solver of your choice (instead of
  `random_search`) to the benchmarking framework. Do not forget to also choose
  the right benchmarking suite and the corresponding observer.

- Execute the modified file either from a system shell like 
  ```
      python example_experiment_new_name.py
  ```
  or in ipython (highly recommended for debugging, see Anaconda at prerequisites) with 
  the `run` command like
  ```
      ipython
      Python 2.7.11 ...
      
      In [1]: run example_experiment_new_name.py
      
      Benchmarking solver...
      [...]
      bbob-biobj done (3300 of 3300 problems benchmarked),...
  ```
  or (with [`example_experiment.py`](`./example_experiment.py`) only) in python or
  ipython like
  ```
      >>> import example_experiment_new_name as ee
      >>> ee.main()
  ```
See [here](../../../README.md#Getting-Started-pp) for the remaining steps to investate the resulting data.


Details
-------
- `python do.py run-python` builds, installs (locally) and tests the 
  `cocoex` Python module, and runs 
  `python code-experiments/build/python/example_experiment.py`.
  You will see something like this:
```
    AML	['code-experiments/src/coco_generics.c', 'code-experiments/src/coco_random.c', 'code-experiments/src/coco_suite.c', 'code-experiments/src/coco_observer.c', 'code-experiments/src/coco_runtime_c.c'] -> code-experiments/build/python/cython/coco.c
    COPY	code-experiments/src/coco.h -> code-experiments/build/python/cython/coco.h
    COPY	code-experiments/src/bbob2009_testcases.txt -> code-experiments/build/python/bbob2009_testcases.txt
    EXPAND	code-experiments/build/python/README.md to code-experiments/build/python/README.txt
    EXPAND	code-experiments/build/python/setup.py.in to code-experiments/build/python/setup.py
    PYTHON	setup.py install --user in code-experiments/build/python
    RUN	python coco_test.py in code-experiments/build/python
    RUN	python example_experiment.py in code-experiments/build/python
```


- The Python interface code, file `interface.c`, has been generated with Cython.
  Under normal circumstance this C-file is delivered with the library and does
  not need to be generated by the user. 

______________________

^1: you will see something like this:
```
    Benchmarking solver '<function random_search' with budget=10 * dimension, Fri Jan 15 18:23:35 2016
    Simple usecase ...
    bbob-biobj done (1650 of 1650 problems benchmarked), Fri Jan 15 18:23:38 2016 (0.05 min).
```
